package ONVIF::PTZ::Types::AudioOutputConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::PTZ::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %OutputToken_of :ATTR(:get<OutputToken>);
my %SendPrimacy_of :ATTR(:get<SendPrimacy>);
my %OutputLevel_of :ATTR(:get<OutputLevel>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        OutputToken
        SendPrimacy
        OutputLevel

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'OutputToken' => \%OutputToken_of,
        'SendPrimacy' => \%SendPrimacy_of,
        'OutputLevel' => \%OutputLevel_of,
    },
    {
        'Name' => 'ONVIF::PTZ::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'OutputToken' => 'ONVIF::PTZ::Types::ReferenceToken',
        'SendPrimacy' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'OutputLevel' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'OutputToken' => 'OutputToken',
        'SendPrimacy' => 'SendPrimacy',
        'OutputLevel' => 'OutputLevel',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::AudioOutputConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AudioOutputConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * OutputToken


=item * SendPrimacy


=item * OutputLevel




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::AudioOutputConfiguration
   OutputToken => $some_value, # ReferenceToken
   SendPrimacy =>  $some_value, # anyURI
   OutputLevel =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

