// SPDX-FileCopyrightText: Copyright 2024 yuzu Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#include "core/hle/service/cmif_serialization.h"
#include "core/hle/service/ns/vulnerability_manager_interface.h"

namespace Service::NS {

IVulnerabilityManagerInterface::IVulnerabilityManagerInterface(Core::System& system_)
    : ServiceFramework{system_, "ns:vm"} {
    // clang-format off
    static const FunctionInfo functions[] = {
        {1200, D<&IVulnerabilityManagerInterface::NeedsUpdateVulnerability>, "NeedsUpdateVulnerability"},
        {1201, nullptr, "UpdateSafeSystemVersionForDebug"},
        {1202, nullptr, "GetSafeSystemVersion"},
    };
    // clang-format on

    RegisterHandlers(functions);
}

IVulnerabilityManagerInterface::~IVulnerabilityManagerInterface() = default;

Result IVulnerabilityManagerInterface::NeedsUpdateVulnerability(
    Out<bool> out_needs_update_vulnerability) {
    LOG_WARNING(Service_NS, "(STUBBED) called");
    *out_needs_update_vulnerability = false;
    R_SUCCEED();
}

} // namespace Service::NS
