/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TBackground.h"

TBackground::TBackground(QRectF *bound, QColor color)
{
	this->bound = bound;
	this->color = color;
}

QRectF TBackground::boundingRect() const
{
	return *bound;
}

void TBackground::paint(QPainter *painter, const QStyleOptionGraphicsItem *,
               QWidget *)
{
	painter->setBrush(QBrush(color));
	QPen pen(color);
	pen.setWidth(1);
	painter->setPen(pen);
	
	painter->drawRect(*bound);
}

void TBackground::setSize(QRectF *bound)
{
	this->bound = bound;
	this->prepareGeometryChange();
}

void TBackground::setColor(QColor color)
{
	this->color = color;
	this->update(this->boundingRect());
}

QColor TBackground::getColor()
{
	return color;
}
