// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: types.proto

package prompbmarshal

import (
	"encoding/binary"
	"math"
	"sort"
	"strconv"
)

type Sample struct {
	Value     float64
	Timestamp int64
}

// TimeSeries represents samples and labels for a single time series.
type TimeSeries struct {
	Labels  []Label
	Samples []Sample
}

type Label struct {
	Name  string
	Value string
}

func (m *Sample) MarshalToSizedBuffer(dst []byte) (int, error) {
	i := len(dst)
	if m.Timestamp != 0 {
		i = encodeVarint(dst, i, uint64(m.Timestamp))
		i--
		dst[i] = 0x10
	}
	if m.Value != 0 {
		i -= 8
		binary.LittleEndian.PutUint64(dst[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dst[i] = 0x9
	}
	return len(dst) - i, nil
}

func (m *TimeSeries) MarshalToSizedBuffer(dst []byte) (int, error) {
	i := len(dst)
	for j := len(m.Samples) - 1; j >= 0; j-- {
		size, err := m.Samples[j].MarshalToSizedBuffer(dst[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarint(dst, i, uint64(size))
		i--
		dst[i] = 0x12
	}
	for j := len(m.Labels) - 1; j >= 0; j-- {
		size, err := m.Labels[j].MarshalToSizedBuffer(dst[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarint(dst, i, uint64(size))
		i--
		dst[i] = 0xa
	}
	return len(dst) - i, nil
}

func (m *Label) MarshalToSizedBuffer(dst []byte) (int, error) {
	i := len(dst)
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dst[i:], m.Value)
		i = encodeVarint(dst, i, uint64(len(m.Value)))
		i--
		dst[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dst[i:], m.Name)
		i = encodeVarint(dst, i, uint64(len(m.Name)))
		i--
		dst[i] = 0xa
	}
	return len(dst) - i, nil
}

func (m *Sample) Size() (n int) {
	if m == nil {
		return 0
	}
	if m.Value != 0 {
		n += 9
	}
	if m.Timestamp != 0 {
		n += 1 + sov(uint64(m.Timestamp))
	}
	return n
}

func (m *TimeSeries) Size() (n int) {
	if m == nil {
		return 0
	}
	for _, e := range m.Labels {
		l := e.Size()
		n += 1 + l + sov(uint64(l))
	}
	for _, e := range m.Samples {
		l := e.Size()
		n += 1 + l + sov(uint64(l))
	}
	return n
}

func (m *Label) Size() (n int) {
	if m == nil {
		return 0
	}
	if l := len(m.Name); l > 0 {
		n += 1 + l + sov(uint64(l))
	}
	if l := len(m.Value); l > 0 {
		n += 1 + l + sov(uint64(l))
	}
	return n
}

// LabelsToString converts labels to Prometheus-compatible string
func LabelsToString(labels []Label) string {
	labelsCopy := append([]Label{}, labels...)
	sort.Slice(labelsCopy, func(i, j int) bool {
		return string(labelsCopy[i].Name) < string(labelsCopy[j].Name)
	})
	var b []byte
	b = append(b, '{')
	for i, label := range labelsCopy {
		if len(label.Name) == 0 {
			b = append(b, "__name__"...)
		} else {
			b = append(b, label.Name...)
		}
		b = append(b, '=')
		b = strconv.AppendQuote(b, label.Value)
		if i < len(labels)-1 {
			b = append(b, ',')
		}
	}
	b = append(b, '}')
	return string(b)
}
