/* Generated By:JJTree&JavaCC: Do not edit this line. Parser.java */
package org.apache.velocity.runtime.parser;

import java.io.*;
import java.util.*;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.node.*;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.util.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.velocity.runtime.RuntimeConstants;

/**
 * This class is responsible for parsing a Velocity
 * template. This class was generated by JavaCC using
 * the JJTree extension to produce an Abstract
 * Syntax Tree (AST) of the template.
 *
 * Please look at the Parser.jjt file which is
 * what controls the generation of this class.
 *
 * @author <a href="mailto:jvanzyl@apache.org">Jason van Zyl</a>
 * @author <a href="mailto:geirm@optonline.net">Geir Magnusson Jr.</a>
 * @author <a href="hps@intermeta.de">Henning P. Schmiedehausen</a>
 * @version $Id: Parser.java 928463 2010-03-28 18:11:34Z nbubna $
*/
public class Parser/*@bgen(jjtree)*/implements ParserTreeConstants, ParserConstants {/*@bgen(jjtree)*/
  protected JJTParserState jjtree = new JJTParserState();/**
     * Keep track of defined macros, used for escape processing
     */
    private Map macroNames = new HashMap();

    /**
     * Name of current template we are parsing.  Passed to us in parse()
     */
    public String currentTemplateName = "";

    /**
     * Set to true if the property
     * RuntimeConstants.RUNTIME_REFERENCES_STRICT_ESCAPE is set to true
     */
    public boolean strictEscape = false;

    VelocityCharStream velcharstream = null;

    private RuntimeServices rsvc = null;

    /**
     * This constructor was added to allow the re-use of parsers.
     * The normal constructor takes a single argument which
     * an InputStream. This simply creates a re-usable parser
     * object, we satisfy the requirement of an InputStream
     * by using a newline character as an input stream.
     */
    public Parser( RuntimeServices rs)
    {
        /*
         * need to call the CTOR first thing.
         */

        this(   new VelocityCharStream(
                new ByteArrayInputStream("\n".getBytes()), 1, 1 ));

        /*
         * now setup a VCS for later use
         */
        velcharstream = new VelocityCharStream(
                new ByteArrayInputStream("\n".getBytes()), 1, 1 );


        strictEscape =
            rs.getBoolean(RuntimeConstants.RUNTIME_REFERENCES_STRICT_ESCAPE, false);

        /*
         *  and save the RuntimeServices
         */
        rsvc = rs;
    }

    /**
     * This was also added to allow parsers to be
     * re-usable. Normal JavaCC use entails passing an
     * input stream to the constructor and the parsing
     * process is carried out once. We want to be able
     * to re-use parsers: we do this by adding this
     * method and re-initializing the lexer with
     * the new stream that we want parsed.
     */
    public SimpleNode parse( Reader reader, String templateName )
        throws ParseException
    {
        SimpleNode sn = null;

        currentTemplateName = templateName;

        try
        {
            token_source.clearStateVars();

            /*
             *  reinitialize the VelocityCharStream
             *  with the new reader
             */
            velcharstream.ReInit( reader, 1, 1 );

            /*
             * now reinit the Parser with this CharStream
             */
            ReInit( velcharstream  );

            /*
             *  do that voodoo...
             */
            sn = process();
        }
        catch (MacroParseException mee)
        {
            /*
             *  thrown by the Macro class when something is amiss in the
             *  Macro specification
             */
            rsvc.getLog().error("Parser Error: " + templateName, mee);
            throw mee;
        }
        catch (ParseException pe)
        {
            rsvc.getLog().error("Parser Exception: " + templateName, pe);
            throw new TemplateParseException (pe.currentToken,
                                pe.expectedTokenSequences, pe.tokenImage, currentTemplateName);
                }
        catch (TokenMgrError tme)
        {
            throw new ParseException("Lexical error: " + tme.toString());
        }
        catch (Exception e)
        {
            String msg = "Parser Error: " + templateName;
            rsvc.getLog().error(msg, e);
            throw new VelocityException(msg, e);
        }

        currentTemplateName = "";

        return sn;
    }

    /**
     *  This method gets a Directive from the directives Hashtable
     */
    public Directive getDirective(String directive)
    {
        return (Directive) rsvc.getDirective(directive);
    }

    /**
     *  This method finds out of the directive exists in the directives Map.
     */
    public boolean isDirective(String directive)
    {
        return rsvc.getDirective(directive) != null;
    }


    /**
     * Produces a processed output for an escaped control or
     * pluggable directive
     */
    private String escapedDirective( String strImage )
    {
        int iLast = strImage.lastIndexOf("\\");

        String strDirective = strImage.substring(iLast + 1);

        boolean bRecognizedDirective = false;

        // we don't have to call substring method all the time in this method
        String dirTag = strDirective.substring(1);
        if (dirTag.charAt(0) == '{')
        {
            dirTag = dirTag.substring(1, dirTag.length() - 1);
        }

        /*
         *  If this is a predefined derective or if we detect
         *  a macro definition (this is aproximate at best) then
         *  we absorb the forward slash.  If in strict reference
         *  mode then we always absord the forward slash regardless
         *  if the derective is defined or not.
         */

        if (strictEscape
             || isDirective(dirTag)
             || macroNames.containsKey(dirTag)
             || rsvc.isVelocimacro(dirTag, currentTemplateName))
        {
            bRecognizedDirective = true;
        }
        else
        {
            /* order for speed? */

            if ( dirTag.equals("if")
                || dirTag.equals("end")
                || dirTag.equals("set")
                || dirTag.equals("else")
                || dirTag.equals("elseif")
            )
            {
                bRecognizedDirective = true;
            }
        }

        /*
         *  if so, make the proper prefix string (let the escapes do their thing..)
         *  otherwise, just return what it is..
         */

        if (bRecognizedDirective)
            return ( strImage.substring(0,iLast/2) + strDirective);
        else
            return ( strImage );
    }

    /**
     * Check whether there is a left parenthesis with leading optional
     * whitespaces. This method is used in the semantic look ahead of
     * Directive method. This is done in code instead of as a production
     * for simplicity and efficiency.
     */
    private boolean isLeftParenthesis()
    {
        char c;
        int no = 0;
        try {
            while(true)
            {
                /**
                 * Read a character
                 */
                c = velcharstream.readChar();
                no++;
                if (c == '(')
                {
                    return true;
                }
                /**
                 * if not a white space return
                 */
                else if (c != ' ' && c != '\n' && c != '\r' && c != '\t')
                {
                    return false;
                }
            }
        }
        catch (IOException e)
        {
        }
        finally
        {
            /**
             * Backup the stream to the initial state
             */
            velcharstream.backup(no);
        }
        return false;
    }

/**
 * This method is what starts the whole parsing
 * process. After the parsing is complete and
 * the template has been turned into an AST,
 * this method returns the root of AST which
 * can subsequently be traversed by a visitor
 * which implements the ParserVisitor interface
 * which is generated automatically by JavaCC
 */
  final public SimpleNode process() throws ParseException {
                        /*@bgen(jjtree) process */
  ASTprocess jjtn000 = new ASTprocess(this, JJTPROCESS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
        case RPAREN:
        case ESCAPE_DIRECTIVE:
        case SET_DIRECTIVE:
        case SINGLE_LINE_COMMENT_START:
        case DOUBLE_ESCAPE:
        case ESCAPE:
        case TEXT:
        case FORMAL_COMMENT:
        case MULTI_LINE_COMMENT:
        case TEXTBLOCK:
        case STRING_LITERAL:
        case IF_DIRECTIVE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case WORD:
        case BRACKETED_WORD:
        case IDENTIFIER:
        case DOT:
        case LCURLY:
        case RCURLY:
        case EMPTY_INDEX:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        Statement();
      }
      jj_consume_token(0);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * These are the types of statements that
 * are acceptable in Velocity templates.
 */
  final public void Statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF_DIRECTIVE:
      IfStatement();
      break;
    default:
      jj_la1[1] = jj_gen;
      if (jj_2_1(2)) {
        Reference();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLE_LINE_COMMENT_START:
        case FORMAL_COMMENT:
        case MULTI_LINE_COMMENT:
          Comment();
          break;
        case TEXTBLOCK:
          Textblock();
          break;
        case SET_DIRECTIVE:
          SetDirective();
          break;
        case ESCAPE_DIRECTIVE:
          EscapedDirective();
          break;
        case DOUBLE_ESCAPE:
          Escape();
          break;
        case WORD:
        case BRACKETED_WORD:
          Directive();
          break;
        case LPAREN:
        case RPAREN:
        case ESCAPE:
        case TEXT:
        case STRING_LITERAL:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case DOT:
        case LCURLY:
        case RCURLY:
        case EMPTY_INDEX:
          Text();
          break;
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

/**
 *  used to separate the notion of a valid directive that has been
 *  escaped, versus something that looks like a directive and
 *  is just schmoo.  This is important to do as a separate production
 *  that creates a node, because we want this, in either case, to stop
 *  the further parsing of the Directive() tree.
 */
  final public void EscapedDirective() throws ParseException {
                           /*@bgen(jjtree) EscapedDirective */
  ASTEscapedDirective jjtn000 = new ASTEscapedDirective(this, JJTESCAPEDDIRECTIVE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
        Token t = null;
      t = jj_consume_token(ESCAPE_DIRECTIVE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         *  churn and burn..
         */
        t.image = escapedDirective( t.image );
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *  Used to catch and process escape sequences in grammatical constructs
 *  as escapes outside of VTL are just characters.  Right now we have both
 *  this and the EscapeDirective() construction because in the EscapeDirective()
 *  case, we want to suck in the #<directive> and here we don't.  We just want
 *  the escapes to render correctly
 */
  final public void Escape() throws ParseException {
                 /*@bgen(jjtree) Escape */
  ASTEscape jjtn000 = new ASTEscape(this, JJTESCAPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
        Token t = null;
        int count = 0;
        boolean control = false;
      label_2:
      while (true) {
        t = jj_consume_token(DOUBLE_ESCAPE);
        count++;
        if (jj_2_2(2)) {
          ;
        } else {
          break label_2;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         * first, check to see if we have a control directive
         */
        switch(t.next.kind ) {
            case IF_DIRECTIVE :
            case ELSE_DIRECTIVE :
            case ELSEIF_DIRECTIVE :
            case END :
                control = true;
                break;
        }

        /*
         * if that failed, lets lookahead to see if we matched a PD or a VM
         */
        String nTag = t.next.image.substring(1);
        if (strictEscape
            || isDirective(nTag)
            || macroNames.containsKey(nTag)
            || rsvc.isVelocimacro(nTag, currentTemplateName))
        {
            control = true;
        }

        jjtn000.val = "";

        for( int i = 0; i < count; i++)
            jjtn000.val += ( control ? "\\" : "\\\\");
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Comment() throws ParseException {
                  /*@bgen(jjtree) Comment */
  ASTComment jjtn000 = new ASTComment(this, JJTCOMMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_LINE_COMMENT_START:
        jj_consume_token(SINGLE_LINE_COMMENT_START);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLE_LINE_COMMENT:
          jj_consume_token(SINGLE_LINE_COMMENT);
          break;
        default:
          jj_la1[3] = jj_gen;
          ;
        }
        break;
      case MULTI_LINE_COMMENT:
        jj_consume_token(MULTI_LINE_COMMENT);
        break;
      case FORMAL_COMMENT:
        jj_consume_token(FORMAL_COMMENT);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  final public void Textblock() throws ParseException {
                    /*@bgen(jjtree) Textblock */
  ASTTextblock jjtn000 = new ASTTextblock(this, JJTTEXTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TEXTBLOCK);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void FloatingPointLiteral() throws ParseException {
                               /*@bgen(jjtree) FloatingPointLiteral */
  ASTFloatingPointLiteral jjtn000 = new ASTFloatingPointLiteral(this, JJTFLOATINGPOINTLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FLOATING_POINT_LITERAL);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void IntegerLiteral() throws ParseException {
                         /*@bgen(jjtree) IntegerLiteral */
  ASTIntegerLiteral jjtn000 = new ASTIntegerLiteral(this, JJTINTEGERLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(INTEGER_LITERAL);
    } finally {
       if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
       }
    }
  }

  final public void StringLiteral() throws ParseException {
                        /*@bgen(jjtree) StringLiteral */
  ASTStringLiteral jjtn000 = new ASTStringLiteral(this, JJTSTRINGLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(STRING_LITERAL);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 * This method corresponds to variable
 * references in Velocity templates.
 * The following are examples of variable
 * references that may be found in a
 * template:
 *
 * $foo
 * $bar
 *
 */
  final public void Identifier() throws ParseException {
                     /*@bgen(jjtree) Identifier */
  ASTIdentifier jjtn000 = new ASTIdentifier(this, JJTIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void Word() throws ParseException {
               /*@bgen(jjtree) Word */
  ASTWord jjtn000 = new ASTWord(this, JJTWORD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(WORD);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *   Supports the arguments for the Pluggable Directives
 */
  final public int DirectiveArg() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case LCURLY:
      Reference();
        {if (true) return ParserTreeConstants.JJTREFERENCE;}
      break;
    case WORD:
      Word();
        {if (true) return ParserTreeConstants.JJTWORD;}
      break;
    case STRING_LITERAL:
      StringLiteral();
        {if (true) return ParserTreeConstants.JJTSTRINGLITERAL;}
      break;
    case INTEGER_LITERAL:
      IntegerLiteral();
        {if (true) return ParserTreeConstants.JJTINTEGERLITERAL;}
      break;
    default:
      jj_la1[5] = jj_gen;
      if (jj_2_3(2147483647)) {
        IntegerRange();
        {if (true) return ParserTreeConstants.JJTINTEGERRANGE;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FLOATING_POINT_LITERAL:
          FloatingPointLiteral();
        {if (true) return ParserTreeConstants.JJTFLOATINGPOINTLITERAL;}
          break;
        case LEFT_CURLEY:
          Map();
        {if (true) return ParserTreeConstants.JJTMAP;}
          break;
        case LBRACKET:
          ObjectArray();
        {if (true) return ParserTreeConstants.JJTOBJECTARRAY;}
          break;
        case TRUE:
          True();
        {if (true) return ParserTreeConstants.JJTTRUE;}
          break;
        case FALSE:
          False();
        {if (true) return ParserTreeConstants.JJTFALSE;}
          break;
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 *   Supports the Pluggable Directives
 *     #foo( arg+ )
 */
  final public SimpleNode Directive() throws ParseException {
 /*@bgen(jjtree) Directive */
    ASTDirective jjtn000 = new ASTDirective(this, JJTDIRECTIVE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t = null;
    int argType;
    int argPos = 0;
    Directive d;
    int directiveType;
    boolean isVM = false;
    boolean doItNow = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        t = jj_consume_token(WORD);
        break;
      case BRACKETED_WORD:
        t = jj_consume_token(BRACKETED_WORD);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        String directiveName;
        if (t.kind == ParserConstants.BRACKETED_WORD)
        {
            directiveName = t.image.substring(2, t.image.length() - 1);
        }
        else
        {
            directiveName = t.image.substring(1);
        }

        d = getDirective(directiveName);

        /*
         *  Velocimacro support : if the directive is macro directive
         *   then set the flag so after the block parsing, we add the VM
         *   right then. (So available if used w/in the current template )
         */

        if (directiveName.equals("macro"))
        {
             doItNow = true;
        }

        /*
         * set the directive name from here.  No reason for the thing to know
         * about parser tokens
         */

        jjtn000.setDirectiveName(directiveName);

        if ( d == null)
        {
            if( directiveName.startsWith("@") )
            {
                // block macro call of type: #@foobar($arg1 $arg2) astBody #end
                directiveType = Directive.BLOCK;
            }
            else
            {
                /*
                 *  if null, then not a real directive, but maybe a Velocimacro
                 */

                isVM = rsvc.isVelocimacro(directiveName, currentTemplateName);

                /*
                 * Currently, all VMs are LINE directives
                 */
                directiveType = Directive.LINE;
            }
        }
        else
        {
            directiveType = d.getType();
        }

        /*
         *  now, switch us out of PRE_DIRECTIVE
         */

        token_source.SwitchTo(DIRECTIVE);

        argPos = 0;
      if (isLeftParenthesis()) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        default:
          jj_la1[8] = jj_gen;
          ;
        }
        jj_consume_token(LPAREN);
        label_3:
        while (true) {
          if (jj_2_4(2)) {
            ;
          } else {
            break label_3;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WHITESPACE:
            jj_consume_token(WHITESPACE);
            break;
          default:
            jj_la1[9] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case WHITESPACE:
              jj_consume_token(WHITESPACE);
              break;
            default:
              jj_la1[10] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[11] = jj_gen;
            ;
          }
          argType = DirectiveArg();
                if (argType == ParserTreeConstants.JJTWORD)
                {
                    if (doItNow && argPos == 0)
                    {
                        /* if #macro and it's the 0th arg, ok */
                    }
                    else if (isVM)
                    {
                        {if (true) throw new MacroParseException("Invalid arg #"
                        + argPos + " in VM " + t.image, currentTemplateName, t);}
                    }
                                          /* if #foreach and it's the 2nd arg, ok */
                    else if (d != null && (!directiveName.equals("foreach") || argPos != 1))
                    {
                        {if (true) throw new MacroParseException("Invalid arg #"
                        + argPos + " in directive " + t.image, currentTemplateName, t);}
                    }
                    else
                    {
                        /* either schmoo or a late-defined macro,
                         * VelocimacroProxy will have to check for latter. */
                    }
                }
                else
                {
                    if (doItNow && argPos == 0)
                    {
                        /* if a VM and it's the 0th arg, not ok */

                        {if (true) throw new MacroParseException("Invalid first arg"
                        + " in #macro() directive - must be a"
                        + " word token (no \' or \" surrounding)", currentTemplateName, t);}
                    }
                }

                argPos++;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        default:
          jj_la1[12] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        if (directiveType  == Directive.LINE)
        {
            {if (true) return jjtn000;}
        }
      } else {
        if (doItNow)  // doItNow is true if the directive is "macro"
        {
            // VELOCITY-667 We get here if we have a "#macro" construct
            // without parenthesis which is a parse error
            {if (true) throw new MacroParseException("A macro declaration requires at least a name argument"
              , currentTemplateName, t);}
        }

        /**
         * Not a directive
         */
        token_source.stateStackPop();
        token_source.inDirective = false;
        {if (true) return jjtn000;}
      }
      ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      try {
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case RPAREN:
          case ESCAPE_DIRECTIVE:
          case SET_DIRECTIVE:
          case SINGLE_LINE_COMMENT_START:
          case DOUBLE_ESCAPE:
          case ESCAPE:
          case TEXT:
          case FORMAL_COMMENT:
          case MULTI_LINE_COMMENT:
          case TEXTBLOCK:
          case STRING_LITERAL:
          case IF_DIRECTIVE:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case WORD:
          case BRACKETED_WORD:
          case IDENTIFIER:
          case DOT:
          case LCURLY:
          case RCURLY:
          case EMPTY_INDEX:
            ;
            break;
          default:
            jj_la1[13] = jj_gen;
            break label_4;
          }
          Statement();
        }
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
      }
      jj_consume_token(END);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        /*
         *  VM : if we are processing a #macro directive, we need to
         *     process the block.  In truth, I can just register the name
         *     and do the work later when init-ing.  That would work
         *     as long as things were always defined before use.  This way
         *     we don't have to worry about forward references and such...
         */

        if (doItNow)
        {
            // Further checking of macro arguments
            Macro.checkArgs(rsvc, t, jjtn000, currentTemplateName);

            // Add the macro name so that we can peform escape processing
            // on defined macros
            String macroName = jjtn000.jjtGetChild(0).getFirstToken().image;
            macroNames.put(macroName, macroName);
        }

        /*
         *  VM : end
         */

        {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * for creating a map in a #set
 *
 *  #set($foo = {$foo : $bar, $blargh : $thingy})
 */
  final public void Map() throws ParseException {
              /*@bgen(jjtree) Map */
  ASTMap jjtn000 = new ASTMap(this, JJTMAP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LEFT_CURLEY);
      if (jj_2_5(2)) {
        Parameter();
        jj_consume_token(COLON);
        Parameter();
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[14] = jj_gen;
            break label_5;
          }
          jj_consume_token(COMMA);
          Parameter();
          jj_consume_token(COLON);
          Parameter();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WHITESPACE:
          jj_consume_token(WHITESPACE);
          break;
        default:
          jj_la1[15] = jj_gen;
          ;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHT_CURLEY:
        jj_consume_token(RIGHT_CURLEY);
        break;
      case RCURLY:
        jj_consume_token(RCURLY);
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void ObjectArray() throws ParseException {
                      /*@bgen(jjtree) ObjectArray */
  ASTObjectArray jjtn000 = new ASTObjectArray(this, JJTOBJECTARRAY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
      case LEFT_CURLEY:
      case WHITESPACE:
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case IDENTIFIER:
      case LCURLY:
        Parameter();
        label_6:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[17] = jj_gen;
            break label_6;
          }
          jj_consume_token(COMMA);
          Parameter();
        }
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *  supports the [n..m] vector generator for use in
 *  the #foreach() to generate measured ranges w/o
 *  needing explicit support from the app/servlet
 */
  final public void IntegerRange() throws ParseException {
                       /*@bgen(jjtree) IntegerRange */
  ASTIntegerRange jjtn000 = new ASTIntegerRange(this, JJTINTEGERRANGE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case LCURLY:
        Reference();
        break;
      case INTEGER_LITERAL:
        IntegerLiteral();
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[21] = jj_gen;
        ;
      }
      jj_consume_token(DOUBLEDOT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case LCURLY:
        Reference();
        break;
      case INTEGER_LITERAL:
        IntegerLiteral();
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 * A Simplified parameter more suitable for an index position: $foo[$index]
 */
  final public void IndexParameter() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      StringLiteral();
      break;
    case INTEGER_LITERAL:
      IntegerLiteral();
      break;
    case TRUE:
      True();
      break;
    case FALSE:
      False();
      break;
    case IDENTIFIER:
    case LCURLY:
      Reference();
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
  }

/**
 * This method has yet to be fully implemented
 * but will allow arbitrarily nested method
 * calls
 */
  final public void Parameter() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      StringLiteral();
      break;
    case INTEGER_LITERAL:
      IntegerLiteral();
      break;
    default:
      jj_la1[29] = jj_gen;
      if (jj_2_6(2147483647)) {
        IntegerRange();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LEFT_CURLEY:
          Map();
          break;
        case LBRACKET:
          ObjectArray();
          break;
        case TRUE:
          True();
          break;
        case FALSE:
          False();
          break;
        case IDENTIFIER:
        case LCURLY:
          Reference();
          break;
        case FLOATING_POINT_LITERAL:
          FloatingPointLiteral();
          break;
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
  }

/**
 * This method has yet to be fully implemented
 * but will allow arbitrarily nested method
 * calls
 */
  final public void Method() throws ParseException {
                 /*@bgen(jjtree) Method */
  ASTMethod jjtn000 = new ASTMethod(this, JJTMETHOD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Identifier();
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
      case LEFT_CURLEY:
      case WHITESPACE:
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case IDENTIFIER:
      case LCURLY:
        Parameter();
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[32] = jj_gen;
            break label_7;
          }
          jj_consume_token(COMMA);
          Parameter();
        }
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      jj_consume_token(REFMOD2_RPAREN);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void Index() throws ParseException {
                /*@bgen(jjtree) Index */
  ASTIndex jjtn000 = new ASTIndex(this, JJTINDEX);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(INDEX_LBRACKET);
      IndexParameter();
      jj_consume_token(INDEX_RBRACKET);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void Reference() throws ParseException {
                    /*@bgen(jjtree) Reference */
  ASTReference jjtn000 = new ASTReference(this, JJTREFERENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INDEX_LBRACKET:
            ;
            break;
          default:
            jj_la1[34] = jj_gen;
            break label_8;
          }
          Index();
        }
        label_9:
        while (true) {
          if (jj_2_7(2)) {
            ;
          } else {
            break label_9;
          }
          jj_consume_token(DOT);
          if (jj_2_8(3)) {
            Method();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case IDENTIFIER:
              Identifier();
              break;
            default:
              jj_la1[35] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          label_10:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INDEX_LBRACKET:
              ;
              break;
            default:
              jj_la1[36] = jj_gen;
              break label_10;
            }
            Index();
          }
        }
        break;
      case LCURLY:
        jj_consume_token(LCURLY);
        jj_consume_token(IDENTIFIER);
        label_11:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INDEX_LBRACKET:
            ;
            break;
          default:
            jj_la1[37] = jj_gen;
            break label_11;
          }
          Index();
        }
        label_12:
        while (true) {
          if (jj_2_9(2)) {
            ;
          } else {
            break label_12;
          }
          jj_consume_token(DOT);
          if (jj_2_10(3)) {
            Method();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case IDENTIFIER:
              Identifier();
              break;
            default:
              jj_la1[38] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          label_13:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INDEX_LBRACKET:
              ;
              break;
            default:
              jj_la1[39] = jj_gen;
              break label_13;
            }
            Index();
          }
        }
        jj_consume_token(RCURLY);
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
        if (jjtc000) {
          jjtree.clearNodeScope(jjtn000);
          jjtc000 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte000 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte000;}
        }
        if (jjte000 instanceof ParseException) {
          {if (true) throw (ParseException)jjte000;}
        }
        {if (true) throw (Error)jjte000;}
    } finally {
        if (jjtc000) {
          jjtree.closeNodeScope(jjtn000, true);
        }
    }
  }

  final public void True() throws ParseException {
               /*@bgen(jjtree) True */
  ASTTrue jjtn000 = new ASTTrue(this, JJTTRUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TRUE);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void False() throws ParseException {
                /*@bgen(jjtree) False */
  ASTFalse jjtn000 = new ASTFalse(this, JJTFALSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FALSE);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 * This method is responsible for allowing
 * all non-grammar text to pass through
 * unscathed.
 */
  final public void Text() throws ParseException {
               /*@bgen(jjtree) Text */
  ASTText jjtn000 = new ASTText(this, JJTTEXT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXT:
        jj_consume_token(TEXT);
        break;
      case DOT:
        jj_consume_token(DOT);
        break;
      case RPAREN:
        jj_consume_token(RPAREN);
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
        break;
      case INTEGER_LITERAL:
        jj_consume_token(INTEGER_LITERAL);
        break;
      case FLOATING_POINT_LITERAL:
        jj_consume_token(FLOATING_POINT_LITERAL);
        break;
      case STRING_LITERAL:
        jj_consume_token(STRING_LITERAL);
        break;
      case ESCAPE:
        jj_consume_token(ESCAPE);
        break;
      case LCURLY:
        jj_consume_token(LCURLY);
        break;
      case RCURLY:
        jj_consume_token(RCURLY);
        break;
      case EMPTY_INDEX:
        jj_consume_token(EMPTY_INDEX);
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/* -----------------------------------------------------------------------
 *
 *  Defined Directive Syntax
 *
 * ----------------------------------------------------------------------*/
  final public void IfStatement() throws ParseException {
                      /*@bgen(jjtree) IfStatement */
  ASTIfStatement jjtn000 = new ASTIfStatement(this, JJTIFSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(IF_DIRECTIVE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      try {
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case RPAREN:
          case ESCAPE_DIRECTIVE:
          case SET_DIRECTIVE:
          case SINGLE_LINE_COMMENT_START:
          case DOUBLE_ESCAPE:
          case ESCAPE:
          case TEXT:
          case FORMAL_COMMENT:
          case MULTI_LINE_COMMENT:
          case TEXTBLOCK:
          case STRING_LITERAL:
          case IF_DIRECTIVE:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case WORD:
          case BRACKETED_WORD:
          case IDENTIFIER:
          case DOT:
          case LCURLY:
          case RCURLY:
          case EMPTY_INDEX:
            ;
            break;
          default:
            jj_la1[43] = jj_gen;
            break label_14;
          }
          Statement();
        }
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSEIF_DIRECTIVE:
        label_15:
        while (true) {
          ElseIfStatement();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ELSEIF_DIRECTIVE:
            ;
            break;
          default:
            jj_la1[44] = jj_gen;
            break label_15;
          }
        }
        break;
      default:
        jj_la1[45] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE_DIRECTIVE:
        ElseStatement();
        break;
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      jj_consume_token(END);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void ElseStatement() throws ParseException {
                        /*@bgen(jjtree) ElseStatement */
  ASTElseStatement jjtn000 = new ASTElseStatement(this, JJTELSESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(ELSE_DIRECTIVE);
      ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      try {
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case RPAREN:
          case ESCAPE_DIRECTIVE:
          case SET_DIRECTIVE:
          case SINGLE_LINE_COMMENT_START:
          case DOUBLE_ESCAPE:
          case ESCAPE:
          case TEXT:
          case FORMAL_COMMENT:
          case MULTI_LINE_COMMENT:
          case TEXTBLOCK:
          case STRING_LITERAL:
          case IF_DIRECTIVE:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case WORD:
          case BRACKETED_WORD:
          case IDENTIFIER:
          case DOT:
          case LCURLY:
          case RCURLY:
          case EMPTY_INDEX:
            ;
            break;
          default:
            jj_la1[47] = jj_gen;
            break label_16;
          }
          Statement();
        }
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  final public void ElseIfStatement() throws ParseException {
                          /*@bgen(jjtree) ElseIfStatement */
  ASTElseIfStatement jjtn000 = new ASTElseIfStatement(this, JJTELSEIFSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(ELSEIF_DIRECTIVE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      ASTBlock jjtn001 = new ASTBlock(this, JJTBLOCK);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      try {
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
          case RPAREN:
          case ESCAPE_DIRECTIVE:
          case SET_DIRECTIVE:
          case SINGLE_LINE_COMMENT_START:
          case DOUBLE_ESCAPE:
          case ESCAPE:
          case TEXT:
          case FORMAL_COMMENT:
          case MULTI_LINE_COMMENT:
          case TEXTBLOCK:
          case STRING_LITERAL:
          case IF_DIRECTIVE:
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case WORD:
          case BRACKETED_WORD:
          case IDENTIFIER:
          case DOT:
          case LCURLY:
          case RCURLY:
          case EMPTY_INDEX:
            ;
            break;
          default:
            jj_la1[49] = jj_gen;
            break label_17;
          }
          Statement();
        }
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/**
 *  Currently support both types of set :
 *   #set( expr )
 *   #set expr
 */
  final public void SetDirective() throws ParseException {
                       /*@bgen(jjtree) SetDirective */
  ASTSetDirective jjtn000 = new ASTSetDirective(this, JJTSETDIRECTIVE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SET_DIRECTIVE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      Reference();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[51] = jj_gen;
        ;
      }
      jj_consume_token(EQUALS);
      Expression();
      jj_consume_token(RPAREN);
        /*
         * ensure that inSet is false.  Leads to some amusing bugs...
         */

        token_source.inSet = false;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        jj_consume_token(NEWLINE);
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

/* -----------------------------------------------------------------------
 *
 *  Expression Syntax
 *
 * ----------------------------------------------------------------------*/
  final public void Expression() throws ParseException {
                     /*@bgen(jjtree) Expression */
  ASTExpression jjtn000 = new ASTExpression(this, JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ConditionalOrExpression();
    } catch (Throwable jjte000) {
  if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
  }
    }
  }

  final public void Assignment() throws ParseException {
                                    /*@bgen(jjtree) #Assignment( 2) */
  ASTAssignment jjtn000 = new ASTAssignment(this, JJTASSIGNMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      PrimaryExpression();
      jj_consume_token(EQUALS);
      Expression();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000,  2);
      }
    }
  }

  final public void ConditionalOrExpression() throws ParseException {
    ConditionalAndExpression();
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_OR:
        ;
        break;
      default:
        jj_la1[53] = jj_gen;
        break label_18;
      }
      jj_consume_token(LOGICAL_OR);
                     ASTOrNode jjtn001 = new ASTOrNode(this, JJTORNODE);
                     boolean jjtc001 = true;
                     jjtree.openNodeScope(jjtn001);
      try {
        ConditionalAndExpression();
      } catch (Throwable jjte001) {
                     if (jjtc001) {
                       jjtree.clearNodeScope(jjtn001);
                       jjtc001 = false;
                     } else {
                       jjtree.popNode();
                     }
                     if (jjte001 instanceof RuntimeException) {
                       {if (true) throw (RuntimeException)jjte001;}
                     }
                     if (jjte001 instanceof ParseException) {
                       {if (true) throw (ParseException)jjte001;}
                     }
                     {if (true) throw (Error)jjte001;}
      } finally {
                     if (jjtc001) {
                       jjtree.closeNodeScope(jjtn001,  2);
                     }
      }
    }
  }

  final public void ConditionalAndExpression() throws ParseException {
    EqualityExpression();
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_AND:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_19;
      }
      jj_consume_token(LOGICAL_AND);
                    ASTAndNode jjtn001 = new ASTAndNode(this, JJTANDNODE);
                    boolean jjtc001 = true;
                    jjtree.openNodeScope(jjtn001);
      try {
        EqualityExpression();
      } catch (Throwable jjte001) {
                    if (jjtc001) {
                      jjtree.clearNodeScope(jjtn001);
                      jjtc001 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte001 instanceof RuntimeException) {
                      {if (true) throw (RuntimeException)jjte001;}
                    }
                    if (jjte001 instanceof ParseException) {
                      {if (true) throw (ParseException)jjte001;}
                    }
                    {if (true) throw (Error)jjte001;}
      } finally {
                    if (jjtc001) {
                      jjtree.closeNodeScope(jjtn001,  2);
                    }
      }
    }
  }

  final public void EqualityExpression() throws ParseException {
    RelationalExpression();
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_EQUALS:
      case LOGICAL_NOT_EQUALS:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_20;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_EQUALS:
        jj_consume_token(LOGICAL_EQUALS);
                          ASTEQNode jjtn001 = new ASTEQNode(this, JJTEQNODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
        try {
          RelationalExpression();
        } catch (Throwable jjte001) {
                          if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte001;}
                          }
                          if (jjte001 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte001;}
                          }
                          {if (true) throw (Error)jjte001;}
        } finally {
                          if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001,  2);
                          }
        }
        break;
      case LOGICAL_NOT_EQUALS:
        jj_consume_token(LOGICAL_NOT_EQUALS);
                              ASTNENode jjtn002 = new ASTNENode(this, JJTNENODE);
                              boolean jjtc002 = true;
                              jjtree.openNodeScope(jjtn002);
        try {
          RelationalExpression();
        } catch (Throwable jjte002) {
                              if (jjtc002) {
                                jjtree.clearNodeScope(jjtn002);
                                jjtc002 = false;
                              } else {
                                jjtree.popNode();
                              }
                              if (jjte002 instanceof RuntimeException) {
                                {if (true) throw (RuntimeException)jjte002;}
                              }
                              if (jjte002 instanceof ParseException) {
                                {if (true) throw (ParseException)jjte002;}
                              }
                              {if (true) throw (Error)jjte002;}
        } finally {
                              if (jjtc002) {
                                jjtree.closeNodeScope(jjtn002,  2);
                              }
        }
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void RelationalExpression() throws ParseException {
    AdditiveExpression();
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_LT:
      case LOGICAL_LE:
      case LOGICAL_GT:
      case LOGICAL_GE:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_21;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICAL_LT:
        jj_consume_token(LOGICAL_LT);
                        ASTLTNode jjtn001 = new ASTLTNode(this, JJTLTNODE);
                        boolean jjtc001 = true;
                        jjtree.openNodeScope(jjtn001);
        try {
          AdditiveExpression();
        } catch (Throwable jjte001) {
                        if (jjtc001) {
                          jjtree.clearNodeScope(jjtn001);
                          jjtc001 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte001 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte001;}
                        }
                        if (jjte001 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte001;}
                        }
                        {if (true) throw (Error)jjte001;}
        } finally {
                        if (jjtc001) {
                          jjtree.closeNodeScope(jjtn001,  2);
                        }
        }
        break;
      case LOGICAL_GT:
        jj_consume_token(LOGICAL_GT);
                        ASTGTNode jjtn002 = new ASTGTNode(this, JJTGTNODE);
                        boolean jjtc002 = true;
                        jjtree.openNodeScope(jjtn002);
        try {
          AdditiveExpression();
        } catch (Throwable jjte002) {
                        if (jjtc002) {
                          jjtree.clearNodeScope(jjtn002);
                          jjtc002 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte002 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte002;}
                        }
                        if (jjte002 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte002;}
                        }
                        {if (true) throw (Error)jjte002;}
        } finally {
                        if (jjtc002) {
                          jjtree.closeNodeScope(jjtn002,  2);
                        }
        }
        break;
      case LOGICAL_LE:
        jj_consume_token(LOGICAL_LE);
                        ASTLENode jjtn003 = new ASTLENode(this, JJTLENODE);
                        boolean jjtc003 = true;
                        jjtree.openNodeScope(jjtn003);
        try {
          AdditiveExpression();
        } catch (Throwable jjte003) {
                        if (jjtc003) {
                          jjtree.clearNodeScope(jjtn003);
                          jjtc003 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte003 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte003;}
                        }
                        if (jjte003 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte003;}
                        }
                        {if (true) throw (Error)jjte003;}
        } finally {
                        if (jjtc003) {
                          jjtree.closeNodeScope(jjtn003,  2);
                        }
        }
        break;
      case LOGICAL_GE:
        jj_consume_token(LOGICAL_GE);
                        ASTGENode jjtn004 = new ASTGENode(this, JJTGENODE);
                        boolean jjtc004 = true;
                        jjtree.openNodeScope(jjtn004);
        try {
          AdditiveExpression();
        } catch (Throwable jjte004) {
                        if (jjtc004) {
                          jjtree.clearNodeScope(jjtn004);
                          jjtc004 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte004 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte004;}
                        }
                        if (jjte004 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte004;}
                        }
                        {if (true) throw (Error)jjte004;}
        } finally {
                        if (jjtc004) {
                          jjtree.closeNodeScope(jjtn004,  2);
                        }
        }
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void AdditiveExpression() throws ParseException {
    MultiplicativeExpression();
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case PLUS:
        ;
        break;
      default:
        jj_la1[59] = jj_gen;
        break label_22;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
                  ASTAddNode jjtn001 = new ASTAddNode(this, JJTADDNODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte001) {
                  if (jjtc001) {
                    jjtree.clearNodeScope(jjtn001);
                    jjtc001 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte001 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte001;}
                  }
                  if (jjte001 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte001;}
                  }
                  {if (true) throw (Error)jjte001;}
        } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001,  2);
                  }
        }
        break;
      case MINUS:
        jj_consume_token(MINUS);
                  ASTSubtractNode jjtn002 = new ASTSubtractNode(this, JJTSUBTRACTNODE);
                  boolean jjtc002 = true;
                  jjtree.openNodeScope(jjtn002);
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte002) {
                  if (jjtc002) {
                    jjtree.clearNodeScope(jjtn002);
                    jjtc002 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte002 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte002;}
                  }
                  if (jjte002 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte002;}
                  }
                  {if (true) throw (Error)jjte002;}
        } finally {
                  if (jjtc002) {
                    jjtree.closeNodeScope(jjtn002,  2);
                  }
        }
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
    UnaryExpression();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULUS:
        ;
        break;
      default:
        jj_la1[61] = jj_gen;
        break label_23;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        jj_consume_token(MULTIPLY);
                          ASTMulNode jjtn001 = new ASTMulNode(this, JJTMULNODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
        try {
          UnaryExpression();
        } catch (Throwable jjte001) {
                          if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte001;}
                          }
                          if (jjte001 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte001;}
                          }
                          {if (true) throw (Error)jjte001;}
        } finally {
                          if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001,  2);
                          }
        }
        break;
      case DIVIDE:
        jj_consume_token(DIVIDE);
                        ASTDivNode jjtn002 = new ASTDivNode(this, JJTDIVNODE);
                        boolean jjtc002 = true;
                        jjtree.openNodeScope(jjtn002);
        try {
          UnaryExpression();
        } catch (Throwable jjte002) {
                        if (jjtc002) {
                          jjtree.clearNodeScope(jjtn002);
                          jjtc002 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte002 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte002;}
                        }
                        if (jjte002 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte002;}
                        }
                        {if (true) throw (Error)jjte002;}
        } finally {
                        if (jjtc002) {
                          jjtree.closeNodeScope(jjtn002,  2);
                        }
        }
        break;
      case MODULUS:
        jj_consume_token(MODULUS);
                         ASTModNode jjtn003 = new ASTModNode(this, JJTMODNODE);
                         boolean jjtc003 = true;
                         jjtree.openNodeScope(jjtn003);
        try {
          UnaryExpression();
        } catch (Throwable jjte003) {
                         if (jjtc003) {
                           jjtree.clearNodeScope(jjtn003);
                           jjtc003 = false;
                         } else {
                           jjtree.popNode();
                         }
                         if (jjte003 instanceof RuntimeException) {
                           {if (true) throw (RuntimeException)jjte003;}
                         }
                         if (jjte003 instanceof ParseException) {
                           {if (true) throw (ParseException)jjte003;}
                         }
                         {if (true) throw (Error)jjte003;}
        } finally {
                         if (jjtc003) {
                           jjtree.closeNodeScope(jjtn003,  2);
                         }
        }
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void UnaryExpression() throws ParseException {
    if (jj_2_11(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHITESPACE:
        jj_consume_token(WHITESPACE);
        break;
      default:
        jj_la1[63] = jj_gen;
        ;
      }
      jj_consume_token(LOGICAL_NOT);
                                                    ASTNotNode jjtn001 = new ASTNotNode(this, JJTNOTNODE);
                                                    boolean jjtc001 = true;
                                                    jjtree.openNodeScope(jjtn001);
      try {
        UnaryExpression();
      } catch (Throwable jjte001) {
                                                    if (jjtc001) {
                                                      jjtree.clearNodeScope(jjtn001);
                                                      jjtc001 = false;
                                                    } else {
                                                      jjtree.popNode();
                                                    }
                                                    if (jjte001 instanceof RuntimeException) {
                                                      {if (true) throw (RuntimeException)jjte001;}
                                                    }
                                                    if (jjte001 instanceof ParseException) {
                                                      {if (true) throw (ParseException)jjte001;}
                                                    }
                                                    {if (true) throw (Error)jjte001;}
      } finally {
                                                    if (jjtc001) {
                                                      jjtree.closeNodeScope(jjtn001,  1);
                                                    }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
      case LEFT_CURLEY:
      case LPAREN:
      case WHITESPACE:
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case IDENTIFIER:
      case LCURLY:
        PrimaryExpression();
        break;
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PrimaryExpression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      StringLiteral();
      break;
    case IDENTIFIER:
    case LCURLY:
      Reference();
      break;
    case INTEGER_LITERAL:
      IntegerLiteral();
      break;
    default:
      jj_la1[66] = jj_gen;
      if (jj_2_12(2147483647)) {
        IntegerRange();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FLOATING_POINT_LITERAL:
          FloatingPointLiteral();
          break;
        case LEFT_CURLEY:
          Map();
          break;
        case LBRACKET:
          ObjectArray();
          break;
        case TRUE:
          True();
          break;
        case FALSE:
          False();
          break;
        case LPAREN:
          jj_consume_token(LPAREN);
          Expression();
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHITESPACE:
      jj_consume_token(WHITESPACE);
      break;
    default:
      jj_la1[68] = jj_gen;
      ;
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_3_7() {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_29()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_97()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_74()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_63()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_7()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    }
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(INDEX_LBRACKET)) return true;
    if (jj_3R_91()) return true;
    if (jj_scan_token(INDEX_RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_35() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    return false;
  }

  private boolean jj_3_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    if (jj_scan_token(LOGICAL_NOT)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    if (jj_scan_token(DOUBLEDOT)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_60()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) jj_scanpos = xsp;
    if (jj_scan_token(REFMOD2_RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_29()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(DOUBLE_ESCAPE)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) return true;
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_29()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_101()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    if (jj_scan_token(DOUBLEDOT)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_29()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_29()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_100()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(LEFT_CURLEY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) return true;
    }
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    if (jj_scan_token(DOUBLEDOT)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(WORD)) return true;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) jj_scanpos = xsp;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_90()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    if (jj_scan_token(DOUBLEDOT)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[69];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x1de06c00,0x0,0x1de06c00,0x2000000,0xc200000,0x0,0x108,0x0,0x80000000,0x80000000,0x80000000,0x20,0x80000000,0x1de06c00,0x20,0x80000000,0x200,0x20,0x80000108,0x80000000,0x0,0x80000000,0x80000000,0x0,0x80000000,0x80000000,0x0,0x80000000,0x80000000,0x0,0x108,0x80000000,0x20,0x80000108,0x2,0x0,0x2,0x2,0x0,0x2,0x0,0x1800c00,0x80000000,0x1de06c00,0x0,0x0,0x0,0x1de06c00,0x80000000,0x1de06c00,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000508,0x80000000,0x0,0x508,0x80000000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x63100001,0x100000,0x63000001,0x0,0x0,0x21000001,0x2000006,0x60000000,0x0,0x0,0x0,0x0,0x0,0x63100001,0x0,0x0,0x0,0x0,0x3000007,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x1000007,0x0,0x0,0x1000001,0x2000006,0x0,0x0,0x3000007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3000001,0x0,0x63100001,0x200000,0x200000,0x400000,0x63100001,0x0,0x63100001,0x0,0x0,0x8,0x400,0x200,0x18000,0x18000,0x7800,0x7800,0x30,0x30,0x1c0,0x1c0,0x0,0x3000007,0x0,0x1000001,0x2000006,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x13c,0x0,0x138,0x0,0x0,0x14,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13c,0x0,0x0,0x20,0x0,0x14,0x0,0x14,0x0,0x0,0x14,0x0,0x0,0x14,0x0,0x0,0x0,0x14,0x0,0x0,0x14,0x0,0x4,0x0,0x0,0x4,0x0,0x14,0x138,0x0,0x13c,0x0,0x0,0x0,0x13c,0x0,0x13c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x14,0x0,0x14,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[12];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public Parser(CharStream stream) {
    token_source = new ParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 69; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[73];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 69; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 73; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 12; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
