/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#include "fullitemdelegate.h"
#include <QDebug>

FullItemDelegate::FullItemDelegate(QObject *parent, int module):
    QStyledItemDelegate(parent)
{
    this->module=module;
    QString path=QDir::homePath()+"/.config/ukui/ukui-menu.ini";
    setting=new QSettings(path,QSettings::IniFormat);
    pUkuiMenuInterface=new UkuiMenuInterface;
}

FullItemDelegate::~FullItemDelegate()
{
    delete pUkuiMenuInterface;
}

void FullItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    if(index.isValid())
    {
        painter->save();
        QStyleOptionViewItem viewOption(option);//用来在视图中画一个item
        QRectF rect;
        rect.setX(option.rect.x());
        rect.setY(option.rect.y());
        rect.setWidth(option.rect.width());
        rect.setHeight(option.rect.height());

        //QPainterPath画圆角矩形
        const qreal radius = 4;
        QPainterPath path;
        path.moveTo(rect.topRight() - QPointF(radius, 0));
        path.lineTo(rect.topLeft() + QPointF(radius, 0));
        path.quadTo(rect.topLeft(), rect.topLeft() + QPointF(0, radius));
        path.lineTo(rect.bottomLeft() + QPointF(0, -radius));
        path.quadTo(rect.bottomLeft(), rect.bottomLeft() + QPointF(radius, 0));
        path.lineTo(rect.bottomRight() - QPointF(radius, 0));
        path.quadTo(rect.bottomRight(), rect.bottomRight() + QPointF(0, -radius));
        path.lineTo(rect.topRight() + QPointF(0, radius));
        path.quadTo(rect.topRight(), rect.topRight() + QPointF(-radius, -0));

        painter->setRenderHint(QPainter::Antialiasing);
        if(option.state & QStyle::State_MouseOver)
        {
            painter->setPen(QPen(Qt::NoPen));
            QColor color;
            color.setNamedColor(QString::fromLocal8Bit(AppBtnHover));
            painter->setBrush(QBrush(color));

            painter->setOpacity(0.14);
            painter->drawPath(path);
        }

        painter->setOpacity(1);
//        QIcon icon=index.data(Qt::DecorationRole).value<QIcon>();
        QString desktopfp=index.data(Qt::DisplayRole).value<QString>();
//        QString desktopfp=index.data().value<QString>();
        QString iconstr=pUkuiMenuInterface->getAppIcon(desktopfp);
        iconstr.remove(".png");
        iconstr.remove(".svg");
        QIcon icon=QIcon::fromTheme(iconstr);
        if(icon.isNull())
            icon=QIcon::fromTheme(QString("application-x-desktop"));
        QString appname=pUkuiMenuInterface->getAppName(desktopfp);

//        QFont font;
        QRect iconRect;
//        font.setPixelSize(Style::AppListFontSize);
        iconRect=QRect(rect.x()+Style::AppLeftSpace ,
                       rect.y()+Style::AppTopSpace,
                       Style::AppListIconSize,
                       Style::AppListIconSize);
//        painter->setFont(font);
        icon.paint(painter,iconRect);
        if(module==0)
        {
            setting->beginGroup("lockapplication");
            QFileInfo fileInfo(desktopfp);
            QString desktopfn=fileInfo.fileName();
            if(setting->contains(desktopfn))
            {
                QIcon icon(QString(":/data/img/mainviewwidget/lock-fs.svg"));
                icon.paint(painter,QRect(iconRect.topRight().x()-14,iconRect.topRight().y()-2,16,16));
//                icon.paint(painter,QRect(rect.topRight().x()-18,rect.topRight().y()+6,12,12));
            }
            setting->endGroup();
        }

        painter->setPen(QPen(Qt::white));
        QRect textRect;

        textRect=QRect(rect.x(),
                       iconRect.bottom()+Style::AppSpaceBetweenIconText,
                       rect.width(),
                       rect.height()-iconRect.height()-Style::AppSpaceBetweenIconText);
        QFontMetrics fm=painter->fontMetrics();
        QString appnameElidedText=fm.elidedText(appname,Qt::ElideRight,rect.width(),Qt::TextShowMnemonic);
        painter->drawText(textRect,Qt::AlignHCenter |Qt::AlignTop,appnameElidedText);

        if(option.state & QStyle::State_MouseOver)
        {
//            painter->setPen(QPen(Qt::NoPen));
//            QColor color;
//            color.setNamedColor(QString::fromLocal8Bit(AppBtnHover));
//            painter->setBrush(QBrush(color));

//            painter->setOpacity(0.14);
//            painter->drawPath(path);

            if(fm.boundingRect(appname).width()>rect.width())
            {
                QToolTip::showText(QCursor::pos(),appname);
            }
//                QToolTip::showText(QPoint(QCursor::pos().x(),option.rect.bottom()),appname);

        }
        else {
            QToolTip::hideText();
        }
        painter->restore();

    }
}

QSize FullItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    return QSize(Style::AppListItemSizeWidth, Style::AppListItemSizeWidth);
}

//bool FullItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)
//{
//    if(event->type()==QEvent::ToolTip)
//    {
//    }
//    else if(event->type()==QEvent::Leave)
//    {
//    }
//    return true;
//}
