// @HEADER
// *****************************************************************************
//   Zoltan2: A package of combinatorial algorithms for scientific computing
//
// Copyright 2012 NTESS and the Zoltan2 contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

/*! \file Zoltan2_Standards.hpp
    \brief Gathering definitions used in software development.

     \todo Should we allow data types for part ID to be set as
         cmake configure options?  Part ID lists in the PartitioningSolution
         are of length "number of objects".  If part ID could be short
         or int, we save significant memory.  For now - typedef'd to int
         so it is easy to change.  It seems data type for proc should
         be int - since it is int in the rest of Trilinos.
*/

#ifndef _ZOLTAN2_STANDARDS_HPP_
#define _ZOLTAN2_STANDARDS_HPP_

#include <Zoltan2_Version.hpp>

//////////////////////////////////////////
// Generated by CMake
#include <Zoltan2_config.h>

//////////////////////////////////////////
// Omit time consuming actions?

#ifdef Z2_OMIT_ALL_OPTIONAL_ACTIONS
#define Z2_OMIT_ALL_STATUS_MESSAGES
#define Z2_OMIT_ALL_PROFILING
#define Z2_OMIT_ALL_ERROR_CHECKING
#endif

//////////////////////////////////////////
// Frequently used Trilinos symbols

#include <Teuchos_RCP.hpp>
#include <Teuchos_Array.hpp>
#include <Teuchos_Tuple.hpp>
#include <Teuchos_ArrayRCP.hpp>
#include <Teuchos_ArrayView.hpp>
#include <Teuchos_ParameterList.hpp>
#include <Teuchos_ParameterEntry.hpp>
#include <Teuchos_DefaultComm.hpp>
#include <Teuchos_Comm.hpp>
#include <Teuchos_CommHelpers.hpp>
#include <Teuchos_toString.hpp>
#include <Tpetra_Core.hpp>
#include <Tpetra_ConfigDefs.hpp>

namespace Zoltan2{

using Teuchos::ENull;
using Teuchos::RCP;
using Teuchos::rcp;
using Teuchos::rcp_const_cast;
using Teuchos::rcp_implicit_cast;
using Teuchos::rcp_dynamic_cast;
using Teuchos::Array;
using Teuchos::Tuple;
using Teuchos::ArrayRCP;
using Teuchos::arcp_const_cast;
using Teuchos::arcp_reinterpret_cast;
using Teuchos::arcp;
using Teuchos::ArrayView;
using Teuchos::av_const_cast;
#ifdef HAVE_ZOLTAN2_MPI
using Teuchos::MpiComm;
#endif
using Teuchos::Comm;
using Teuchos::SerialComm;
using Teuchos::CommRequest;
using Teuchos::ParameterList;
using Teuchos::ParameterEntry;
using Teuchos::reduceAll;
using Teuchos::gatherAll;

typedef Tpetra::global_size_t global_size_t;

}

// Workarounds for Purify; it doesn't like the standard string operations
#ifdef HAVE_ZOLTAN2_PURIFY
#define strcmp Zoltan_strcmp
#define strncmp Zoltan_strncmp
#define strcasecmp Zoltan_strcasecmp
#define strncasecmp Zoltan_strncasecmp
#endif

// For debugging
#define HELLO
//#define HELLO printf("HELLO from %s:%i\n", __FILE__, __LINE__); // Turn on for debug 

//////////////////////////////////////////////////////
// Internal macros and methods
//////////////////////////////////////////////////////

#include <Zoltan2_Exceptions.hpp>


#endif
