(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    708383,      14804]
NotebookOptionsPosition[    704653,      14689]
NotebookOutlinePosition[    705086,      14706]
CellTagsIndexPosition[    705043,      14703]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["G1 Gregory Patches (agnostic)",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.5126106282852554`*^9, 3.5126106568804216`*^9}, 
   3.512610692885683*^9, {3.512610948401359*^9, 3.5126110104277544`*^9}, {
   3.512611046136612*^9, 3.5126111722018285`*^9}, {3.512611241419916*^9, 
   3.5126112622149825`*^9}, {3.5126113365811357`*^9, 
   3.5126113465340633`*^9}, {3.5126114872322674`*^9, 3.512611540023344*^9}, 
   3.512611582175084*^9, {3.5126116559796305`*^9, 3.512611670425416*^9}, {
   3.5126117361802588`*^9, 3.512611752498068*^9}, 3.5126463289362526`*^9, {
   3.5126463690131664`*^9, 3.5126463756432514`*^9}, {3.5126466769355173`*^9, 
   3.512646680180359*^9}, {3.512646760755392*^9, 3.512646763937833*^9}, {
   3.5126468008947067`*^9, 3.5126468016591167`*^9}, {3.512649501002942*^9, 
   3.512649526521532*^9}, {3.512649973945984*^9, 3.5126499791255827`*^9}, {
   3.512650106883809*^9, 3.5126501278362207`*^9}, {3.5183800737557135`*^9, 
   3.518380088450939*^9}},
 FontSize->16],

Cell[CellGroupData[{

Cell["\<\

Graphics Directives\
\>", "Section",
 CellChangeTimes->{{3.5226782378604765`*^9, 3.5226782549650717`*^9}},
 FontSize->24],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", "Viewpoint", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"gf", " ", "had", " ", "0"}], ",", " ", 
    RowBox[{"-", "1"}], ",", " ", "2"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"myviewpoint", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", " ", 
       RowBox[{"-", "1.2"}], ",", " ", "2.0"}], "}"}]}], ";"}], " ", "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "sphere", " ", "usedata"}], " ", "=", " ", "5"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"myviewpoint", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1.3", ",", " ", 
       RowBox[{"-", "2.4"}], ",", " ", "2.2"}], "}"}]}], ";"}], " ", "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"sinxsiny", " ", "usedata"}], " ", "=", " ", "8"}], " ", "*)"}], 
  "\[IndentingNewLine]", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"myviewpoint", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1"}], ",", " ", 
       RowBox[{"-", "2"}], ",", " ", "3.1"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"tri", "&"}], "rec", " ", "patch", " ", "usedata"}], " ", "=", 
     " ", "6"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"myviewpoint", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{"4", ",", " ", 
        RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";"}], " ", "*)"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"for", " ", "cone", " ", "usedata"}], " ", "=", " ", "9"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"myviewvertical", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"default", " ", "--"}], " ", "unless", " ", "specified"}], ",", 
     " ", 
     RowBox[{
     "us", " ", "this", " ", "one", " ", "for", " ", "data", " ", "sets"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"myviewvertical", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], " ", "*)"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "cone", " ", "data", " ", "set", " ", "for", " ", "upright", " ", 
     "view"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Turn", " ", 
     RowBox[{"on", "/", "off"}], " ", "the", " ", "control", " ", "points", 
     " ", "on", " ", "the", " ", "shaded", " ", "images"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"withcontrolstructure", " ", "=", "1"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"rendermethod", " ", "=", " ", 
      RowBox[{"0", " ", "smooth", " ", "shading"}]}], ",", " ", 
     RowBox[{"1", " ", "=", " ", "colormap"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rendermethod", " ", "=", " ", "0"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "should", " ", "be", " ", "the", " ", "number", " ", "of", 
     " ", 
     RowBox[{"evals", " ", "--"}], " ", "but", " ", "not", " ", "sure"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"myplotpoints", " ", "=", " ", "5"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colorsurface", " ", "=", " ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", ".8", ",", ".2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"myopacity", " ", "=", " ", "1.0"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"was", " ", "0.9"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"myspecularity", " ", "=", " ", "10"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "two", " ", "colors", " ", "for", " ", "the", " ", 
     "rectangle", " ", "patch"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "One", " ", "for", " ", "main", " ", "control", " ", "net", " ", "and", 
     " ", "one", " ", "for", " ", "extra", " ", "Gregory", " ", "points"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colorrec1", " ", "=", " ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", " ", "0.5", ",", " ", "0.3"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colorrec2", " ", "=", " ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", " ", "0.8", ",", " ", "0.5"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colortri1", " ", "=", " ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.7", ",", " ", "0.8", ",", " ", "0.3"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colortri2", " ", "=", " ", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.8", ",", " ", "0.9", ",", " ", "0.6"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colorpolygon", " ", "=", " ", "Gray"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colordatapoints", " ", "=", " ", "Black"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colornormals", " ", "=", " ", "Black"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"colorbndry", " ", "=", " ", "Black"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointsizemedium", " ", "=", " ", "0.025"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointsizelarge", " ", "=", " ", "0.03"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"linewidththin", " ", "=", " ", "0.003"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"linewidthmedium", " ", "=", " ", "0.004"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"linewidththick", " ", "=", " ", "0.007"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"normallengthfactor", " ", "=", " ", "1.0"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5226133363343024`*^9, 3.5226134838964863`*^9}, {
   3.522613654732136*^9, 3.52261366976375*^9}, {3.522676103891981*^9, 
   3.522676151780842*^9}, {3.522677583890114*^9, 3.522677636736102*^9}, {
   3.5226777940322833`*^9, 3.5226778291027117`*^9}, {3.522677879595317*^9, 
   3.52267790775581*^9}, {3.522678001450536*^9, 3.522678044732773*^9}, {
   3.522678134521883*^9, 3.5226781431643105`*^9}, {3.5226781858556976`*^9, 
   3.52267822962864*^9}, {3.522678279560438*^9, 3.5226782912272143`*^9}, {
   3.522678416527387*^9, 3.522678420793522*^9}, {3.5226947697521696`*^9, 
   3.522694776371688*^9}, {3.5226950097672944`*^9, 3.5226950178389006`*^9}, {
   3.5226964912075005`*^9, 3.5226964988084307`*^9}, {3.5226973353513203`*^9, 
   3.522697362209941*^9}, {3.5226982334827695`*^9, 3.5226982474228144`*^9}, {
   3.5226990344545107`*^9, 3.5226990351855617`*^9}, {3.5230231054694643`*^9, 
   3.5230231055595937`*^9}, {3.523031643426443*^9, 3.523031654171894*^9}, {
   3.523032592401002*^9, 3.523032615994928*^9}, {3.5230326839526463`*^9, 
   3.523032705363434*^9}, {3.523033493206296*^9, 3.5230334962206306`*^9}, {
   3.5230347055395455`*^9, 3.523034706410798*^9}, {3.523034744455504*^9, 
   3.52303474735968*^9}, {3.5230349324858785`*^9, 3.5230349406676435`*^9}, {
   3.5238204021901855`*^9, 3.523820402520661*^9}, {3.523820901027478*^9, 
   3.5238209044323745`*^9}, {3.523820935206626*^9, 3.5238209363883247`*^9}, {
   3.523903766534897*^9, 3.5239037711014633`*^9}, {3.5244212154442225`*^9, 
   3.5244212671185265`*^9}, {3.5244215984249215`*^9, 3.524421623801411*^9}, {
   3.5244223991963744`*^9, 3.524422399286504*^9}, {3.524426640014371*^9, 
   3.5244266550559998`*^9}, {3.5244268449190097`*^9, 
   3.5244268482738333`*^9}, {3.5244270147331905`*^9, 3.5244270148433485`*^9}, 
   3.5244270931759853`*^9, 3.5244271891339664`*^9, {3.5244272476781487`*^9, 
   3.524427252364888*^9}, {3.5244273677107472`*^9, 3.5244273719167953`*^9}, 
   3.5244274309817266`*^9, {3.5244274944930515`*^9, 3.524427495484477*^9}, {
   3.5244293509424944`*^9, 3.524429355469003*^9}, {3.524429395196128*^9, 
   3.5244293954565024`*^9}, {3.524429502380251*^9, 3.5244295104518576`*^9}, {
   3.5244296040864973`*^9, 3.524429604597232*^9}, {3.5244296357119727`*^9, 
   3.5244296442542562`*^9}, {3.524429674838234*^9, 3.5244296812073917`*^9}, {
   3.5244297158872595`*^9, 3.524429716808584*^9}, {3.524429774461485*^9, 
   3.5244297750523343`*^9}, {3.524499294010833*^9, 3.52449929848727*^9}, 
   3.524508491556254*^9, {3.524509178744382*^9, 3.524509191162238*^9}, {
   3.524509335099209*^9, 3.5245093452838535`*^9}, {3.524509410507641*^9, 
   3.524509442203217*^9}, {3.5245096439833627`*^9, 3.524509687205513*^9}, {
   3.5245104766106215`*^9, 3.524510480125676*^9}, {3.524511791210924*^9, 
   3.5245117940550137`*^9}, {3.5245126916356716`*^9, 3.524512692326665*^9}, {
   3.524512930068521*^9, 3.5245130061178746`*^9}, {3.5245135066776443`*^9, 
   3.5245135089308844`*^9}, {3.5245152963911257`*^9, 3.524515322558753*^9}, {
   3.5245164170024858`*^9, 3.524516456739625*^9}, {3.524517030654875*^9, 
   3.5245170882176456`*^9}, {3.524517130808889*^9, 3.5245171310492344`*^9}, {
   3.5245742710824366`*^9, 3.524574281297125*^9}, {3.524574314474832*^9, 
   3.524574314755235*^9}, {3.52457463497569*^9, 3.5245746461217165`*^9}, {
   3.5245748530592785`*^9, 3.524574864285421*^9}, {3.5247502358158865`*^9, 
   3.524750281090989*^9}, {3.524751140116206*^9, 3.524751141237819*^9}, {
   3.5247512234860864`*^9, 3.5247512347022142`*^9}, {3.5247513706977663`*^9, 
   3.524751371188472*^9}, {3.5247515366764317`*^9, 3.5247515483432083`*^9}, {
   3.524751619074915*^9, 3.524751619415405*^9}, {3.524751658912198*^9, 
   3.524751660284171*^9}, 3.5247518563761377`*^9, 3.5247519393654704`*^9, {
   3.524751992261531*^9, 3.524751992912467*^9}, {3.5247520483521852`*^9, 
   3.5247520484823728`*^9}, {3.524752118513072*^9, 3.524752147054112*^9}, {
   3.524752254889171*^9, 3.5247522980712643`*^9}, {3.5247528806289406`*^9, 
   3.524752906816597*^9}, {3.5247530632415247`*^9, 3.5247530717938223`*^9}, {
   3.5249394001376257`*^9, 3.5249394047442493`*^9}},
 FontFamily->"Courier New",
 FontSize->16],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6299141414426403`*^9, 3.6299143092831917`*^9, 3.6299150711999273`*^9, 
   3.629915112433895*^9, {3.629915154140732*^9, 3.6299151754086123`*^9}, 
   3.629995059812953*^9, 3.62999530527034*^9, 3.629995374066757*^9, 
   3.629995529490664*^9}],

Cell[BoxData[
 InterpretationBox[
  ButtonBox[
   TooltipBox[
    RowBox[{
     GraphicsBox[{
       {GrayLevel[0], RectangleBox[{0, 0}]}, 
       {GrayLevel[0], RectangleBox[{1, -1}]}, 
       {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
      AspectRatio->1,
      Frame->True,
      FrameStyle->GrayLevel[0.],
      FrameTicks->None,
      ImageSize->
       Dynamic[{
        Automatic, 1.35 CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
         Magnification]}],
      PlotRangePadding->None], "\[InvisibleSpace]"}],
    "GrayLevel[0]"],
   Appearance->None,
   BaseStyle->{},
   BaselinePosition->Baseline,
   ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
     If[
      Not[
       AbsoluteCurrentValue["Deployed"]], 
      SelectionMove[Typeset`box$, All, Expression]; 
      FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
      FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
      FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
      MathLink`CallFrontEnd[
        FrontEnd`AttachCell[Typeset`box$, 
         FrontEndResource["GrayLevelColorValueSelector"], {
         0, {Left, Bottom}}, {Left, Top}, 
         "ClosingActions" -> {
          "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
   DefaultBaseStyle->{},
   Evaluator->Automatic,
   Method->"Preemptive"],
  GrayLevel[0],
  Editable->False,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.6299141414426403`*^9, 3.6299143092831917`*^9, 3.6299150711999273`*^9, 
   3.629915112433895*^9, {3.629915154140732*^9, 3.6299151754086123`*^9}, 
   3.629995059812953*^9, 3.62999530527034*^9, 3.629995374066757*^9, 
   3.6299955294959373`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "\n",
 StyleBox["Input Data",
  FontSize->24]
}], "Section",
 CellChangeTimes->{{3.5184621345847845`*^9, 3.518462147938408*^9}},
 FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Flag", " ", "to", " ", "check", " ", "G1", " ", 
     RowBox[{"continuity", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Added", " ", "this", " ", "with", " ", "thought", " ", "that", " ", 
      "it", " ", "would", " ", "speed", " ", "up", " ", "calculations"}], ",",
      " ", 
     RowBox[{"but", " ", "it", " ", 
      RowBox[{"doesn", "'"}], "t"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"checkg1condition", " ", "=", " ", "1"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"check", " ", "occurs", " ", "at", " ", "t"}], "=", 
     RowBox[{
      RowBox[{"0.5", " ", "--"}], " ", "this", " ", "is", " ", "same", " ", 
      "point", " ", "for", " ", "opposing", " ", 
      RowBox[{"patches", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Initialize", " ", "dimension", " ", "of", " ", 
     RowBox[{"bb1", " ", "--"}], " ", "the", " ", "working", " ", "Bezier", 
     " ", "patch"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bb1", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "And", " ", "the", " ", "Bezier", " ", "patch", " ", "for", " ", "the", 
     " ", "triangle", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tt1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"===", "===", "===", "===", "===", "===", " ", 
     RowBox[{"Data", " ", "Sets"}], " ", "===", "===", "===", "===", "===", "===",
      "==="}], " ", "*)"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Convention", ":", 
      RowBox[{"faces", " ", "are", " ", "ordered", " ", 
       RowBox[{"counterclockwise", ".", "\[IndentingNewLine]", "Neighbors"}], 
       " ", "are", " ", "given", " ", "across", " ", "an", " ", 
       RowBox[{"edge", ".", "\[IndentingNewLine]", "faces"}], " ", "lists", 
       " ", "the", " ", "number", " ", "of", " ", "vertices"}]}], ",", 
     RowBox[{"index", " ", "into", " ", "vertex", " ", "list"}], ",", 
     RowBox[{"and", " ", "neighbors"}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"usedata", " ", "set", "\[IndentingNewLine]", "0"}], " ", "=", 
     " ", 
     RowBox[{
      RowBox[{
      "simple", " ", "two", " ", "rectangles", "\[IndentingNewLine]", "1"}], 
      " ", "=", " ", 
      RowBox[{
       RowBox[{"two", " ", "rectangles", "\[IndentingNewLine]", "2"}], " ", 
       "=", " ", 
       RowBox[{
        RowBox[{
        "2", "x2", " ", "rectangular", " ", "grid", "\[IndentingNewLine]", 
         "3"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
         "3", "x3", " ", "rectangular", " ", "grid", "\[IndentingNewLine]", 
          "4"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"one", " ", "triangle", " ", "\[IndentingNewLine]", "5"}], 
          " ", "=", " ", 
          RowBox[{
           RowBox[{"spherical", " ", "cap", "\[IndentingNewLine]", "6"}], " ",
            "=", " ", 
           RowBox[{
            RowBox[{
            "one", " ", "triangle", " ", "and", " ", "one", " ", "rectangle", 
             "\[IndentingNewLine]", "7"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"two", " ", "triangles", "\[IndentingNewLine]", "8"}], 
             " ", "=", " ", 
             RowBox[{
              RowBox[{
              "3", "x3", " ", "grid", " ", "with", " ", "triangle", " ", "in",
                " ", "middle", "\[IndentingNewLine]", "9"}], " ", "=", " ", 
              "cone"}]}]}]}]}]}]}]}]}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"usedataset", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", " ", 
      RowBox[{
       RowBox[{"Simple", " ", "Two", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rectangle", "--"}], "--"}], "--"}], "--"}], "--"}], 
         "--"}]}], "-"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "0"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.0", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1.0", ",", "0", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "5", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "6", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"6", ",", "2", ",", "1", ",", " ", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nfaces", "=", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", " ", 
      RowBox[{
       RowBox[{"Two", " ", "rectangle", " ", "as", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"spaceship", " ", "--"}], "--"}], "--"}], "--"}], "--"}],
          "--"}]}], "-"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "1"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "6"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.5"}], ",", "0.0", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "0", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "5", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "6", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"nn", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";"}], 
         " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", 
              RowBox[{"{", 
               RowBox[{"0", ",", " ", "0.5", ",", " ", 
                RowBox[{"-", "2"}]}], "}"}]}], ")"}], "/", 
            RowBox[{"Norm", "[", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "-", 
               RowBox[{"{", 
                RowBox[{"0", ",", " ", "0.5", ",", " ", 
                 RowBox[{"-", "2"}]}], "}"}]}], ")"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "1", ",", "5", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nfaces", "=", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", 
      RowBox[{"2", "x2", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rectangles", "--"}], "--"}], "--"}], "--"}], "--"}], 
         "--"}], "--"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "2"}], ",", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "9"}], "}"}]}], "]"}]}], ";", "\n", 
        "\t", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"1", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{"j", ",", "2", ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], ";", "\n", "\t", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"4", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"7", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "5", "]"}], "]"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", "5", "]"}], "]"}], " ", "+", " ", 
          RowBox[{"{", 
           RowBox[{"0.5", ",", " ", "0.0", ",", " ", "0.25"}], "}"}]}]}], ";",
         " ", "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"nn", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";"}], 
         " ", "*)"}], "\n", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", 
              RowBox[{"{", 
               RowBox[{"1.5", ",", " ", "1.5", ",", " ", 
                RowBox[{"-", "2"}]}], "}"}]}], ")"}], "/", 
            RowBox[{"Norm", "[", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "-", 
               RowBox[{"{", 
                RowBox[{"1.5", ",", " ", "1.5", ",", " ", 
                 RowBox[{"-", "2"}]}], "}"}]}], ")"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "4", ",", "5", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "2", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "            ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "5", ",", "6", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "4", ",", "0", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "7", ",", "8", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "4", ",", "1"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "8", ",", "9", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nfaces", " ", "=", " ", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", 
      RowBox[{"3", "x3", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rectangles", "--"}], "--"}], "--"}], "--"}], "--"}], 
         "--"}], "--"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "3"}], ",", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "16"}], "}"}]}], "]"}]}], ";", "\n", 
        "\t", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"1", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{"j", ",", "3", ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", "\n", "\t", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"5", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{"j", ",", "2", ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"9", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", "\n", "\t", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"13", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"movez", " ", "=", " ", "0.5"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "6", "]"}], "]"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", "6", "]"}], "]"}], " ", "+", " ", 
          RowBox[{"{", 
           RowBox[{"0.3", ",", "0.3", ",", " ", "movez"}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "7", "]"}], "]"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", "7", "]"}], "]"}], " ", "+", " ", 
          RowBox[{"{", 
           RowBox[{"0", ",", " ", "0", ",", 
            RowBox[{"-", " ", "movez"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "10", "]"}], "]"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", "10", "]"}], "]"}], " ", "+", " ", 
          RowBox[{"{", 
           RowBox[{"0.0", ",", " ", "0.0", ",", " ", 
            RowBox[{"-", "movez"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "11", "]"}], "]"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", "11", "]"}], "]"}], " ", "+", " ", 
          RowBox[{"{", 
           RowBox[{"0", ",", " ", "0", ",", " ", "movez"}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", "\n", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\n", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"nn", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"data", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "-", 
                RowBox[{"{", 
                 RowBox[{"1.5", ",", " ", "1.5", ",", " ", 
                  RowBox[{"-", "2"}]}], "}"}]}], ")"}], "/", 
              RowBox[{"Norm", "[", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"data", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "-", 
                 RowBox[{"{", 
                  RowBox[{"1.5", ",", " ", "1.5", ",", " ", 
                   RowBox[{"-", "2"}]}], "}"}]}], ")"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";"}], 
         " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "6", ",", "2", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "2", ",", "0", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "            ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "6", ",", "7", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "5", ",", "3", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "7", ",", "8", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "6", ",", "0", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "9", ",", "10", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "7", ",", "5", ",", "1"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"6", ",", "10", ",", "11", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "8", ",", "6", ",", "2"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "11", ",", "12", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "9", ",", "0", ",", "3"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"9", ",", "13", ",", "14", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "8", ",", "4"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"10", ",", "14", ",", "15", ",", "11"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "0", ",", "9", ",", "5"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"11", ",", "15", ",", "16", ",", "12"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"8", ",", "0", ",", "0", ",", "6"}], "}"}]}], "}"}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nfaces", " ", "=", " ", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", " ", 
      RowBox[{
       RowBox[{"One", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"triangle", "  ", "--"}], "--"}], "--"}], "--"}], "--"}],
          "--"}]}], "-"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "4"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.0", ",", "0.5"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1.0", ",", "0", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
          "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nfaces", "=", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", " ", 
      RowBox[{
       RowBox[{"Spherical", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Cap", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
         "--"}]}], "-"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "5"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}]}], ";", " ", 
        RowBox[{"(*", " ", "initialize", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "2", ",", "0"}], "}"}], "//", "N"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"-", "0.5"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"cc", "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", "0.25"}]}], "}"}]}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "center", " ", "of", " ", "sphere", " ", "that", " ", "data", " ", 
          "should", " ", "be", " ", "on"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"radius", "=", 
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", "cc"}], "]"}]}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"radius", " ", "of", " ", "that", " ", "sphere"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "6", "]"}], "]"}], "=", " ", 
         RowBox[{"cc", "+", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "radius"}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "7", "]"}], "]"}], "=", 
         RowBox[{"cc", "+", 
          RowBox[{"radius", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "0.5"}], ",", "0"}], "}"}], "-", "cc"}], ")"}], 
            "/", 
            RowBox[{"Norm", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "0.5"}], ",", "0"}], "}"}], "-", "cc"}], 
             "]"}]}]}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"deg", "=", 
         RowBox[{
          RowBox[{"72", "*", 
           RowBox[{"Pi", "/", "180"}]}], "//", "N"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rotmat", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "deg", "]"}], ",", 
             RowBox[{"-", 
              RowBox[{"Sin", "[", "deg", "]"}]}], ",", "0"}], "}"}], ",", 
           "\[IndentingNewLine]", "\t", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Sin", "[", "deg", "]"}], ",", " ", 
             RowBox[{"Cos", "[", "deg", "]"}], ",", "0"}], "}"}], ",", 
           "\[IndentingNewLine]", "\t", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"rotmat", ".", 
            RowBox[{"data", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"create", " ", "pentagon"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "3", "D", " ", "unit", " ", "normals", " ", "come", " ", "from", " ",
           "sphere", " ", "with", " ", "center", " ", "cc"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", "cc"}], ")"}], "/", 
            RowBox[{"Norm", "[", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "-", "cc"}], ")"}], "]"}]}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}]}], ";", " ", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"arrows", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"data", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "+", 
              RowBox[{"nn", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}]}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"for", " ", "Graphics"}], " ", "*)"}], "\[IndentingNewLine]",
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"gf", "'"}], "s", " ", "original"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "2", ",", "5", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "3", ",", "7", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "3", ",", "5", ",", "1"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "4", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "4", ",", "2"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "4", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "0", ",", "5"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "}"}]}], 
            "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
         "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "slightly", " ", "different", " ", "connectivity", " ", "for", " ", 
          "triangles"}], " ", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "5", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "3", ",", "7", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "4", ",", "1"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "4", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4", ",", "2"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "4", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5", ",", "2"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "4"}], "}"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "same", " ", "as", " ", "previous", " ", "but", " ", "with", " ", 
          "e2", " ", "to", " ", "outside", " ", "if", " ", "possible"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "2", ",", "5", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "3", ",", "7", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "3", ",", "4", ",", "1"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "3", ",", "4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "0", ",", "4"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "6", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "4", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
            "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
         "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"all", " ", "triangles"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "2", ",", "7"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "7", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "6", ",", "1"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "3", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "4", ",", "2"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "4", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "5", ",", "3"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "4", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "0", ",", "6"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "5", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "7", ",", "2"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "1", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "6"}], "}"}]}], "}"}]}], 
            "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
         "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"just", " ", "two", " ", "triangles"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "4", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "4", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
            "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"just", " ", "rectangles"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "3", ",", "7", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "2", ",", "3"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "3", ",", "1", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "2", ",", "0"}], "}"}]}], "}"}]}],
             "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
         "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"nfaces", "=", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"-", "  ", "End"}]}]}], " ", "of", " ", "Spherical", " ", 
      "cap", " ", "data", " ", 
      RowBox[{
       RowBox[{"set", " ", "--"}], "--"}]}], "-"}], "  ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", " ", 
      RowBox[{
       RowBox[{"One", " ", "triangle", " ", "and", " ", "one", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rectangle", " ", "--"}], "--"}], "--"}], "--"}], "--"}],
          "--"}]}], "-"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "6"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.0", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1.0", ",", "0", ",", "0.25"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0.25"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "0.5", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "5", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1.5", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"cc", "=", 
         RowBox[{"{", 
          RowBox[{"0.75", ",", "0.75", ",", 
           RowBox[{"-", "0.5"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"nn", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";"}], 
         " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", "cc"}], ")"}], "/", 
            RowBox[{"Norm", "[", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "-", "cc"}], ")"}], "]"}]}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "4", ",", "5", ",", "3"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", "1"}], 
                "}"}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
         "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "4", ",", "5", ",", "3"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", "1"}], 
              "}"}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"nfaces", "=", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", " ", 
      RowBox[{
       RowBox[{"Two", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"triangles", " ", "--"}], "--"}], "--"}], "--"}], "--"}],
          "--"}]}], "-"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "7"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0.0", ",", "0.0", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1.0", ",", "0", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0.0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"nn", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";"}], 
         " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", 
              RowBox[{"{", 
               RowBox[{"0.5", ",", " ", "0.5", ",", " ", 
                RowBox[{"-", "2.0"}]}], "}"}]}], ")"}], "/", 
            RowBox[{"Norm", "[", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "-", 
               RowBox[{"{", 
                RowBox[{"0.5", ",", " ", "0.5", ",", " ", 
                 RowBox[{"-", "2.0"}]}], "}"}]}], ")"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "4", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "2", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nfaces", "=", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", "Data"}]}]}]}]}]}], " ", 
     RowBox[{"Set", ":", 
      RowBox[{
      "3", "x3", " ", "rectangles", " ", "with", " ", "middle", " ", "rec", 
       " ", "as", " ", "2", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"triangles", " ", "--"}], "--"}], "--"}], "--"}], "--"}],
          "--"}], "--"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "8"}], ",", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "16"}], "}"}]}], "]"}]}], ";", "\n", 
        "\t", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Data", " ", "over", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "3"}]}], ")"}], " ", "to", " ", 
          RowBox[{"(", 
           RowBox[{"3", ",", "3"}], ")"}], " ", "grid"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"1", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"j", "/", "3"}], ")"}], "*", "6"}]}], ",", "3", ",", 
             "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", "\n", "\t", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"5", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"j", "/", "3"}], ")"}], "*", "6"}]}], ",", "1", ",", 
             "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"9", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"j", "/", "3"}], ")"}], "*", "6"}]}], ",", 
             RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", "\n", "\t", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"13", "+", "j"}], "]"}], "]"}], "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"j", "/", "3"}], ")"}], "*", "6"}]}], ",", 
             RowBox[{"-", "3"}], ",", "0"}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"function", " ", "x"}], ",", "y", ",", " ", 
          RowBox[{"sinx", "*", "siny"}]}], " ", "*)"}], "\[IndentingNewLine]",
         "\n", " ", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "3"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"data", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "1"}], "]"}], "]"}], "]"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"data", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "2"}], "]"}], "]"}], "]"}]}]}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "ndata"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"data", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"data", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], ",", " ", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"data", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"data", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], ",", " ", 
               "1.0"}], "}"}], ")"}], "/", 
            RowBox[{"Norm", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"data", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"data", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], ",", " ", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"data", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"data", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], ",", " ", 
               "1.0"}], "}"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "6", ",", "2", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "2", ",", "0", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "            ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "6", ",", "7", ",", "3"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "6", ",", "3", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "7", ",", "8", ",", "4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "7", ",", "0", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "9", ",", "10", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "8", ",", "5", ",", "1"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "10", ",", "11"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "9", ",", "6"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "7", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "2", ",", "5"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", "            ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "11", ",", "12", ",", "8"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "10", ",", " ", "0", ",", " ", "3"}], 
                "}"}]}], "}"}], ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"9", ",", "13", ",", "14", ",", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "9", ",", "4"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"10", ",", "14", ",", "15", ",", "11"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "0", ",", "10", ",", "5"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "15", ",", "16", ",", "12"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"9", ",", "0", ",", "0", ",", "7"}], "}"}]}], "}"}]}],
             "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"nfaces", " ", "=", " ", 
           RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
         "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "6", ",", "2", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "2", ",", "0", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "            ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "6", ",", "7", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "5", ",", "3", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "7", ",", "8", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "7", ",", "0", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "9", ",", "10", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "8", ",", "5", ",", "1"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"6", ",", "10", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "6", ",", "2"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"11", ",", "7", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "5", ",", "9"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", "            ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "11", ",", "12", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"6", ",", "10", ",", " ", "0", ",", " ", "3"}], "}"}]}],
             "}"}], ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"9", ",", "13", ",", "14", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "9", ",", "4"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"10", ",", "14", ",", "15", ",", "11"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"8", ",", "0", ",", "10", ",", "6"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"11", ",", "15", ",", "16", ",", "12"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"9", ",", "0", ",", "0", ",", "7"}], "}"}]}], "}"}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nfaces", " ", "=", " ", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", "Data"}]}]}]}]}]}], "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"around", "  ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}], "--"}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"usedataset", " ", "\[Equal]", " ", "9"}], ",", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"data", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "18"}], "}"}]}], "]"}]}], ";", "\n", 
        "\t", 
        RowBox[{"ndata", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "basic", " ", "ring", " ", "is", " ", "at", " ", "2.", " ", "Needs", 
          " ", "to", " ", "be", " ", "greater", " ", "than", " ", "1"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"r2", " ", "=", " ", "1.7"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1", ",", "r2"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "2", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "3", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "4", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "r2"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "5", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "r2"}], ",", "1", ",", "1"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "6", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "7", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "8", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "r2"}], ",", "1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "9", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "10", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "11", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", 
           RowBox[{"-", "r2"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "12", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1", ",", 
           RowBox[{"-", "r2"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "13", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "14", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"r2", ",", "1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "15", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"r2", ",", "1", ",", "1"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "16", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "17", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", 
           RowBox[{"-", "4"}], ",", " ", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "18", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "4", ",", " ", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"cc", "=", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nn", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "-", "cc"}], ")"}], "/", 
            RowBox[{"Norm", "[", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "-", "cc"}], ")"}], "]"}]}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "ndata"}], "}"}]}], "]"}]}], ";", " ",
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"just", " ", "around"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "            ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "16", ",", "15", ",", "4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "3", ",", "0", ",", "1"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "0", ",", "2", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "14", ",", "13", ",", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "3", ",", "0", ",", "5"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "10", ",", "9", ",", "12"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "0", ",", "6", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"12", ",", "9", ",", "7", ",", "8"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "0", ",", "7", ",", "0"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "6", ",", "5", ",", "8"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "8", ",", "0", ",", "6"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "2", ",", "1", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "0", ",", "7"}], "}"}]}], "}"}]}],
             "}"}]}], ";"}], "\[IndentingNewLine]", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "with", " ", "one", " ", "end", " ", "of", " ", "trinagles"}], " ", 
         "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"faces", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"8", ",", "9", ",", "2", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "            ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "16", ",", "15", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"10", ",", "3", ",", "0", ",", "1"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "0", ",", "2", ",", "11"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"11", ",", "14", ",", "13", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "3", ",", "12", ",", "5"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"11", ",", "10", ",", "9", ",", "12"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "13", ",", "6", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"12", ",", "9", ",", "7", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "14", ",", "7", ",", "0"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "6", ",", "5", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"15", ",", "8", ",", "0", ",", "6"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", "\t  ", 
           RowBox[{"{", 
            RowBox[{"4", ",", 
             RowBox[{"{", 
              RowBox[{"6", ",", "2", ",", "1", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"16", ",", "1", ",", "0", ",", "7"}], "}"}]}], "}"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "3", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"10", ",", "1", ",", "16"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "16", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"11", ",", "2", ",", "9"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "13", ",", "16"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"12", ",", "3", ",", "10"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "10", ",", "13"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"13", ",", "4", ",", "11"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "9", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"14", ",", "5", ",", "12"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "7", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"15", ",", "6", ",", "13"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "6", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"16", ",", "7", ",", "14"}], "}"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"{", 
              RowBox[{"17", ",", "2", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"9", ",", "8", ",", "15"}], "}"}]}], "}"}]}], 
          "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "faces", " ", "with", " ", "cone", " ", "at", " ", "each", " ", 
          "end"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"faces", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "9", ",", "2", ",", "17"}], "}"}]}], "}"}], 
             ",", "\[IndentingNewLine]", "            ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "16", ",", "15", ",", "4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"10", ",", "3", ",", "18", ",", "1"}], "}"}]}], "}"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "19", ",", "2", ",", "11"}], "}"}]}], "}"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "14", ",", "13", ",", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"20", ",", "3", ",", "12", ",", "5"}], "}"}]}], "}"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "10", ",", "9", ",", "12"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "13", ",", "6", ",", "21"}], "}"}]}], "}"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"12", ",", "9", ",", "7", ",", "8"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "14", ",", "7", ",", "22"}], "}"}]}], "}"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "6", ",", "5", ",", "8"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "8", ",", "23", ",", "6"}], "}"}]}], "}"}],
              ",", "\[IndentingNewLine]", "\t  ", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "2", ",", "1", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"16", ",", "1", ",", "24", ",", "7"}], "}"}]}], "}"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "3", ",", "2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"10", ",", "1", ",", "16"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "16", ",", "3"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"11", ",", "2", ",", "9"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "13", ",", "16"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"12", ",", "3", ",", "10"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "10", ",", "13"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"13", ",", "4", ",", "11"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "9", ",", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"14", ",", "5", ",", "12"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "7", ",", "9"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"15", ",", "6", ",", "13"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "6", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"16", ",", "7", ",", "14"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"{", 
                RowBox[{"17", ",", "2", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"9", ",", "8", ",", "15"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"1", ",", "4", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "18", ",", "24"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"4", ",", "15", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "19", ",", "17"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"15", ",", "14", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "20", ",", "18"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"14", ",", "11", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "21", ",", "19"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"11", ",", "12", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"5", ",", "22", ",", "20"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"12", ",", "8", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "23", ",", "21"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"8", ",", "5", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"7", ",", "24", ",", "22"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"3", ",", " ", 
               RowBox[{"{", 
                RowBox[{"5", ",", "1", ",", "18"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"8", ",", "17", ",", "23"}], "}"}]}], "}"}]}], 
            "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
         "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"nfaces", " ", "=", " ", 
         RowBox[{"Length", "[", "faces", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"-", " ", "Print"}]}]}]}]}]}], " ", "Input", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Data", "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
      "--"}]}], " ", "*)"}], 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Input data points  ndata =\>\"", ",", "ndata", ",", 
      "\"\<  data = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "data", "]"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Input normals nn = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "nn", "]"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Input faces  nfaces =\>\"", ",", "nfaces"}], "]"}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<face \>\"", ",", "i", ",", "\"\< #verts =\>\"", ",", 
        RowBox[{"faces", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        "                                          ", "\"\<   vertices =\>\"",
         ",", 
        RowBox[{"faces", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        "                                          ", "\"\<   neighbors=\>\"",
         ",", 
        RowBox[{"faces", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Created working Bezier patch bb1 = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "bb1", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    " ", "*)"}], "\n", "\n", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5126106282852554`*^9, 3.5126106568804216`*^9}, 
   3.512610692885683*^9, {3.512610948401359*^9, 3.5126110104277544`*^9}, {
   3.512611046136612*^9, 3.5126111722018285`*^9}, {3.512611241419916*^9, 
   3.5126112622149825`*^9}, {3.5126113365811357`*^9, 
   3.5126113465340633`*^9}, {3.5126114872322674`*^9, 3.512611540023344*^9}, 
   3.512611582175084*^9, {3.5126116559796305`*^9, 3.512611670425416*^9}, {
   3.5126117361802588`*^9, 3.512611752498068*^9}, 3.5126463289362526`*^9, {
   3.5126463690131664`*^9, 3.5126463756432514`*^9}, {3.5126466769355173`*^9, 
   3.512646680180359*^9}, {3.512646760755392*^9, 3.512646763937833*^9}, {
   3.5126468008947067`*^9, 3.5126468016591167`*^9}, {3.512649501002942*^9, 
   3.512649526521532*^9}, {3.512649973945984*^9, 3.5126499791255827`*^9}, {
   3.512650106883809*^9, 3.5126501278362207`*^9}, {3.5126503206025944`*^9, 
   3.5126503245495462`*^9}, {3.512650549818143*^9, 3.5126505607382827`*^9}, {
   3.512650601735608*^9, 3.5126506574283223`*^9}, {3.5126506876615095`*^9, 
   3.5126507464274635`*^9}, {3.512651020538577*^9, 3.5126510294150915`*^9}, {
   3.5126510663251643`*^9, 3.5126511006612043`*^9}, 3.5126511315340004`*^9, 
   3.512651278971491*^9, {3.512651328424782*^9, 3.512651331451298*^9}, {
   3.5126513763810263`*^9, 3.5126514018724065`*^9}, {3.5126514339627204`*^9, 
   3.5126515331663*^9}, {3.5126515661925583`*^9, 3.512651603415352*^9}, {
   3.5126517218854628`*^9, 3.512651729124002*^9}, {3.512651995530325*^9, 
   3.512652014344287*^9}, {3.512653313655458*^9, 3.512653314700671*^9}, 
   3.5126548290257626`*^9, {3.5126548987586565`*^9, 3.5126549084463806`*^9}, {
   3.512654974341625*^9, 3.5126549770872602`*^9}, {3.512655268967003*^9, 
   3.5126553093715205`*^9}, {3.5126636588161955`*^9, 
   3.5126636602039547`*^9}, {3.5126646951940365`*^9, 
   3.5126647237286315`*^9}, {3.5126647678644266`*^9, 3.512664787475135*^9}, {
   3.5126648959633656`*^9, 3.512664938537676*^9}, {3.51266498922435*^9, 
   3.5126650805508475`*^9}, 3.5126651148099847`*^9, {3.5126653323637285`*^9, 
   3.512665363779108*^9}, 3.5126654332392282`*^9, 3.5126654755423603`*^9, {
   3.5126660053686566`*^9, 3.512666056068657*^9}, {3.5126661089370565`*^9, 
   3.512666146845126*^9}, {3.5126662052834754`*^9, 3.5126662764208794`*^9}, 
   3.512666867059222*^9, {3.5126672403919144`*^9, 3.512667322278428*^9}, {
   3.5126678601800795`*^9, 3.5126679348119144`*^9}, {3.5126680352778463`*^9, 
   3.51266804275039*^9}, {3.512668298513115*^9, 3.512668298981124*^9}, {
   3.5126683313977423`*^9, 3.5126683439554205`*^9}, {3.5126686070894732`*^9, 
   3.5126686091486206`*^9}, 3.51266868310811*^9, {3.5126700985463495`*^9, 
   3.5126703314417353`*^9}, {3.5126703675248814`*^9, 3.512670379802003*^9}, {
   3.512670479298165*^9, 3.512670482028147*^9}, {3.512670514975136*^9, 
   3.5126705179547167`*^9}, {3.5126790405894136`*^9, 
   3.5126790429918604`*^9}, {3.512844612440539*^9, 3.512844642674114*^9}, {
   3.51284468345356*^9, 3.512844774903105*^9}, {3.5128448518442774`*^9, 
   3.512844853185912*^9}, {3.5128453089827986`*^9, 3.5128453344114504`*^9}, {
   3.512857240030056*^9, 3.5128572410596495`*^9}, {3.512915276592617*^9, 
   3.512915307621813*^9}, 3.512915457557257*^9, 3.5129156949329433`*^9, {
   3.5129157288170123`*^9, 3.512915755587299*^9}, {3.51291579034499*^9, 
   3.51291580048525*^9}, 3.5129161299997053`*^9, {3.5129231724292192`*^9, 
   3.512923235033223*^9}, {3.512923273831169*^9, 3.5129233431277018`*^9}, 
   3.5129234851685696`*^9, {3.51292846251621*^9, 3.512928490518928*^9}, {
   3.5142037217381196`*^9, 3.5142037394909506`*^9}, {3.5144633506125402`*^9, 
   3.514463383310198*^9}, {3.514463474445558*^9, 3.5144634946163936`*^9}, 
   3.5144636335502377`*^9, {3.5144822564885473`*^9, 3.514482404220806*^9}, {
   3.5144825421250486`*^9, 3.514482591436735*^9}, {3.514482676566085*^9, 
   3.514482728420576*^9}, {3.5152195017698307`*^9, 3.5152195039694347`*^9}, 
   3.5152196109076223`*^9, {3.515228426815308*^9, 3.515228450059349*^9}, {
   3.516295484624885*^9, 3.5162954890240927`*^9}, {3.5169025560839715`*^9, 
   3.51690256098238*^9}, {3.5170593833909616`*^9, 3.517059389833773*^9}, 
   3.517516874606846*^9, {3.5178527303705835`*^9, 3.5178528744524364`*^9}, {
   3.5178529320789375`*^9, 3.5178529374765472`*^9}, {3.517853154894129*^9, 
   3.517853163006143*^9}, {3.517853225031852*^9, 3.517853234859869*^9}, 
   3.517853601288913*^9, {3.518380138917028*^9, 3.518380218539568*^9}, {
   3.5183803737130404`*^9, 3.518380526172108*^9}, {3.51838056117857*^9, 
   3.518380599523437*^9}, {3.518380632595495*^9, 3.518380634982299*^9}, {
   3.51838068100238*^9, 3.518380801091391*^9}, 3.518380844943068*^9, {
   3.51838099407933*^9, 3.5183810178849716`*^9}, {3.518381082344285*^9, 
   3.518381085729491*^9}, {3.518381231418147*^9, 3.5183812477669754`*^9}, {
   3.5183826013357553`*^9, 3.518382661411461*^9}, {3.518398157617878*^9, 
   3.5183981650434914`*^9}, {3.5183991187979665`*^9, 
   3.5183991250067773`*^9}, {3.5183991570024333`*^9, 
   3.5183992501197968`*^9}, {3.5183992951258755`*^9, 3.518399407118472*^9}, {
   3.5183994905630193`*^9, 3.518399562993946*^9}, {3.518461769731344*^9, 
   3.5184619160128007`*^9}, {3.518461948570058*^9, 3.5184619699576955`*^9}, 
   3.518462078892687*^9, {3.518462227966549*^9, 3.5184623187431083`*^9}, {
   3.518462357431176*^9, 3.5184624277248993`*^9}, {3.518462466194567*^9, 
   3.518462554943123*^9}, {3.5184626044732103`*^9, 3.518462690975362*^9}, {
   3.5184630906480637`*^9, 3.5184631102104983`*^9}, {3.518463327004079*^9, 
   3.5184633597173367`*^9}, {3.5184633932885957`*^9, 3.5184634184982395`*^9}, 
   3.518463480227548*^9, {3.518463545576063*^9, 3.5184635471204653`*^9}, {
   3.5184636261190042`*^9, 3.5184637402956047`*^9}, {3.518463812523732*^9, 
   3.5184638418985834`*^9}, {3.518463874580641*^9, 3.518463897668681*^9}, {
   3.518466836557843*^9, 3.5184668618298874`*^9}, {3.518467247493765*^9, 
   3.518467301017459*^9}, {3.518551445834772*^9, 3.5185514459127727`*^9}, {
   3.518551488064047*^9, 3.5185515073612804`*^9}, {3.5185515831930137`*^9, 
   3.5185515980130396`*^9}, {3.5185517193032527`*^9, 3.518551760440525*^9}, {
   3.518551809705412*^9, 3.5185518136210184`*^9}, {3.5185518681743145`*^9, 
   3.518551869718717*^9}, {3.5185521920620832`*^9, 3.5185522034345036`*^9}, {
   3.5185523738336024`*^9, 3.518552390166831*^9}, {3.5185526506248884`*^9, 
   3.5185526631049104`*^9}, {3.5185527042421827`*^9, 
   3.5185527404966464`*^9}, {3.5185565648789663`*^9, 
   3.5185566383706956`*^9}, {3.5185567921245656`*^9, 3.5185568005017805`*^9}, 
   3.518557419276867*^9, 3.518557469836556*^9, {3.518558512963588*^9, 
   3.518558569061287*^9}, {3.518558659120245*^9, 3.518558766900834*^9}, {
   3.5185588126245146`*^9, 3.518558870719016*^9}, 3.518559101047021*^9, {
   3.518559234848456*^9, 3.518559246283276*^9}, {3.518559429801998*^9, 
   3.518559448085231*^9}, {3.5185625121562123`*^9, 3.51856252242103*^9}, {
   3.518562612557989*^9, 3.5185626791545057`*^9}, {3.518562714972169*^9, 
   3.5185627303069954`*^9}, {3.5185627905075016`*^9, 3.518562791459103*^9}, {
   3.518562948520179*^9, 3.518562953309387*^9}, 3.518563060278775*^9, {
   3.5185636975098944`*^9, 3.5185637299735518`*^9}, {3.5185640921437874`*^9, 
   3.518564094624192*^9}, {3.518564464360441*^9, 3.518564470272852*^9}, 
   3.5185645957906723`*^9, 3.5185647089220705`*^9, {3.51856477684459*^9, 
   3.518564781259398*^9}, 3.5185648556403284`*^9, 3.518628171482338*^9, {
   3.5186282411364603`*^9, 3.5186282451768675`*^9}, {3.518635053301225*^9, 
   3.518635089430889*^9}, {3.5186356048401937`*^9, 3.5186356198942204`*^9}, {
   3.5186356871147385`*^9, 3.5186357019659643`*^9}, {3.5186358611330442`*^9, 
   3.518635861429445*^9}, {3.518637175476948*^9, 3.5186371989705887`*^9}, {
   3.5186372548342867`*^9, 3.5186373550488625`*^9}, {3.5186374484150267`*^9, 
   3.5186375085375323`*^9}, {3.518637584977667*^9, 3.5186375950708847`*^9}, {
   3.518637681635436*^9, 3.518637691884654*^9}, {3.518637810600863*^9, 
   3.518637813346468*^9}, {3.518637923763462*^9, 3.518637926321866*^9}, {
   3.5186384951612654`*^9, 3.5186385132572975`*^9}, {3.518640040000779*^9, 
   3.5186402101190777`*^9}, {3.51864025113155*^9, 3.51864025127195*^9}, {
   3.5186411059194508`*^9, 3.518641106293852*^9}, {3.5186413040397987`*^9, 
   3.518641304148999*^9}, {3.51864150804296*^9, 3.5186415387282143`*^9}, {
   3.5186421416068735`*^9, 3.5186421418252735`*^9}, {3.518642201854179*^9, 
   3.518642208640191*^9}, {3.5186449153697453`*^9, 3.518644951951809*^9}, {
   3.5187079684108934`*^9, 3.5187080660046654`*^9}, {3.518709661419467*^9, 
   3.5187096615130672`*^9}, {3.518709695333927*^9, 3.518709695411927*^9}, {
   3.518715649726785*^9, 3.518715651224388*^9}, {3.518721890837349*^9, 
   3.5187219053921747`*^9}, {3.518721978041502*^9, 3.5187219883843203`*^9}, {
   3.5187220397864103`*^9, 3.5187220506908293`*^9}, {3.518722738028037*^9, 
   3.518722752894863*^9}, {3.518723360079129*^9, 3.5187233731675525`*^9}, {
   3.518724061019561*^9, 3.5187240997388287`*^9}, {3.5187242684687247`*^9, 
   3.5187242892323613`*^9}, {3.518724375063712*^9, 3.5187243874033337`*^9}, {
   3.5187244514726467`*^9, 3.5187244602086616`*^9}, {3.5187249199102693`*^9, 
   3.5187249200194693`*^9}, {3.5187252189315944`*^9, 
   3.5187252576976624`*^9}, {3.5187252902861195`*^9, 3.51872529059812*^9}, {
   3.518725327304985*^9, 3.518725327991386*^9}, {3.518725375259469*^9, 
   3.5187254518868036`*^9}, {3.5187254820416565`*^9, 
   3.5187255929110513`*^9}, {3.518725705527649*^9, 3.518725736712104*^9}, {
   3.5187357338464627`*^9, 3.518735737465669*^9}, {3.5187358014413815`*^9, 
   3.518735801597382*^9}, {3.518735851143069*^9, 3.518735854013474*^9}, 
   3.518787479612078*^9, {3.518787831733097*^9, 3.5187878431835165`*^9}, {
   3.5187925665568767`*^9, 3.518792566915677*^9}, {3.5188095255946693`*^9, 
   3.51880952570387*^9}, {3.5188095727223525`*^9, 3.5188095728159523`*^9}, {
   3.5188108269289556`*^9, 3.518810827006956*^9}, {3.518812455063816*^9, 
   3.5188124803514605`*^9}, 3.5188125904564543`*^9, {3.518812643153347*^9, 
   3.518812660154177*^9}, {3.5188136331958866`*^9, 3.518813633507888*^9}, {
   3.518814034069791*^9, 3.518814034163391*^9}, {3.5188140811038733`*^9, 
   3.518814081181874*^9}, {3.518814223563324*^9, 3.518814224187325*^9}, 
   3.518818554324933*^9, {3.518869284246833*^9, 3.5188692954320526`*^9}, {
   3.518869374196591*^9, 3.5188693835566072`*^9}, {3.518869451713127*^9, 
   3.5188694604647427`*^9}, {3.5188695269988594`*^9, 3.518869568245332*^9}, {
   3.5188712692559123`*^9, 3.518871270238714*^9}, {3.51887133092282*^9, 
   3.518871331500022*^9}, {3.518871374602897*^9, 3.5188713761785*^9}, {
   3.5188714437890186`*^9, 3.5188714705118656`*^9}, {3.5188715446119957`*^9, 
   3.5188715496196046`*^9}, {3.518888603004362*^9, 3.5188886142519817`*^9}, {
   3.5188890634547706`*^9, 3.518889132625292*^9}, 3.518889191764996*^9, {
   3.51888945565506*^9, 3.5188894879783163`*^9}, 3.518889647847397*^9, 
   3.518890031506071*^9, 3.5188900674017344`*^9, {3.5188909519232874`*^9, 
   3.518890978240534*^9}, {3.518892761880065*^9, 3.5188927649064703`*^9}, {
   3.5188928088517475`*^9, 3.5188928107705507`*^9}, {3.51889300382089*^9, 
   3.518893046752166*^9}, {3.51889314010273*^9, 3.5188931484955444`*^9}, {
   3.518893308127825*^9, 3.518893343586687*^9}, {3.5188960791734915`*^9, 
   3.518896088814309*^9}, {3.518896164209241*^9, 3.5188962022421083`*^9}, {
   3.5188963853708296`*^9, 3.518896459049759*^9}, 3.518896544584709*^9, {
   3.5188981871399946`*^9, 3.518898210025234*^9}, {3.518898901106448*^9, 
   3.518898933242505*^9}, {3.518899039338291*^9, 3.51889908995198*^9}, {
   3.5188996123160973`*^9, 3.5188996483365607`*^9}, {3.5188996832962227`*^9, 
   3.518899708443466*^9}, {3.5188998835849743`*^9, 3.5188999109942226`*^9}, {
   3.518899971569129*^9, 3.5188999806639442`*^9}, {3.5189004281507306`*^9, 
   3.51890045055237*^9}, {3.5189018423372145`*^9, 3.518901855238437*^9}, {
   3.518979257592966*^9, 3.5189792996350393`*^9}, {3.5189801165020742`*^9, 
   3.5189801302144985`*^9}, {3.5189806042681313`*^9, 3.518980613284947*^9}, {
   3.5189813100105705`*^9, 3.518981310072971*^9}, {3.518981372753881*^9, 
   3.5189813791966925`*^9}, {3.5189814362771926`*^9, 
   3.5189814372599945`*^9}, {3.5189819161652355`*^9, 
   3.5189819162432356`*^9}, {3.5189820475174665`*^9, 3.5189820475798664`*^9}, 
   3.5189979481181965`*^9, 3.5189980912484484`*^9, {3.519398358117883*^9, 
   3.519398387099557*^9}, {3.519410914673323*^9, 3.5194109284230947`*^9}, {
   3.519410977213251*^9, 3.519411073021016*^9}, {3.519411105928334*^9, 
   3.5194111066794147`*^9}, {3.519412387661376*^9, 3.5194123877815485`*^9}, {
   3.5194124240637197`*^9, 3.5194124251552896`*^9}, 3.5194126282473216`*^9, {
   3.519419827990043*^9, 3.519419847207677*^9}, {3.5194199098477488`*^9, 
   3.5194199934579744`*^9}, {3.519420094292968*^9, 3.5194200954946957`*^9}, {
   3.5194201697314434`*^9, 3.519420226453005*^9}, {3.519420271517805*^9, 
   3.5194202721787553`*^9}, {3.519420422014208*^9, 3.519420458186221*^9}, {
   3.5194211201981473`*^9, 3.5194211500010014`*^9}, {3.519421183378997*^9, 
   3.519421255142187*^9}, {3.5194215932984324`*^9, 3.519421593368533*^9}, {
   3.519421623842352*^9, 3.519421761390136*^9}, {3.5194220410622845`*^9, 
   3.519422041122371*^9}, 3.519422420858405*^9, {3.519422927316656*^9, 
   3.5194229278574333`*^9}, 3.5194230254677906`*^9, {3.519423205897235*^9, 
   3.5194232253452*^9}, {3.5194232931727314`*^9, 3.5194232961970797`*^9}, {
   3.5194236171886435`*^9, 3.519423617779493*^9}, {3.5194236945298543`*^9, 
   3.5194236946400127`*^9}, {3.519423980901637*^9, 3.5194240356503615`*^9}, {
   3.5194240702501135`*^9, 3.5194240703402433`*^9}, {3.5194242023600783`*^9, 
   3.519424202650496*^9}, {3.5194270377171216`*^9, 3.5194270377972364`*^9}, {
   3.5194271344261827`*^9, 3.5194271345163116`*^9}, {3.5194290901183295`*^9, 
   3.519429098169907*^9}, {3.519429136865549*^9, 3.519429232302781*^9}, {
   3.519429441613755*^9, 3.519429472528208*^9}, {3.5194295167618127`*^9, 
   3.519429529690403*^9}, {3.519437103280691*^9, 3.519437104131915*^9}, {
   3.519474821637501*^9, 3.519474842247136*^9}, {3.519478719859434*^9, 
   3.5194787201097937`*^9}, {3.5194789179242373`*^9, 3.519478918254712*^9}, {
   3.5194789641006355`*^9, 3.5194789641707363`*^9}, {3.519479014352895*^9, 
   3.5194790144029665`*^9}, {3.5194898328491287`*^9, 3.519489833009359*^9}, {
   3.519491935963258*^9, 3.5194919364339347`*^9}, {3.51949700505225*^9, 
   3.519497005482869*^9}, {3.5194975289656005`*^9, 3.5194976411769524`*^9}, {
   3.519497807976799*^9, 3.5194980390490646`*^9}, 3.519498217906248*^9, {
   3.5194988515473795`*^9, 3.5194988517977395`*^9}, {3.519500394576146*^9, 
   3.5195004027679253`*^9}, {3.5195004610317044`*^9, 3.51950056266785*^9}, {
   3.5195102057886868`*^9, 3.5195102159599047`*^9}, {3.519510685442729*^9, 
   3.5195106992331533`*^9}, {3.519510836482195*^9, 3.519510837059396*^9}, {
   3.5195109094435225`*^9, 3.5195109122359276`*^9}, 3.520008317334217*^9, 
   3.520009773667591*^9, 3.520019094065524*^9, 3.5200194428197365`*^9, 
   3.5200194979502335`*^9, 3.520019530835091*^9, {3.5200196182576447`*^9, 
   3.5200196591765165`*^9}, 3.520025902323926*^9, 3.5200259356143847`*^9, {
   3.520027553493226*^9, 3.520027566815649*^9}, {3.520028551551779*^9, 
   3.5200285652954035`*^9}, {3.520028852710308*^9, 3.520028873926345*^9}, 
   3.520029100750744*^9, {3.520029157862444*^9, 3.5200291730100703`*^9}, 
   3.5200292583110204`*^9, 3.5200302160219035`*^9, {3.5200303349097123`*^9, 
   3.5200303357365136`*^9}, 3.520030469072748*^9, {3.5200306522950697`*^9, 
   3.5200306550094748`*^9}, 3.520032046140747*^9, {3.5200321088372574`*^9, 
   3.520032120599678*^9}, {3.520097132804257*^9, 3.520097133303458*^9}, {
   3.5200972999741507`*^9, 3.5200973025949554`*^9}, 3.52009737380908*^9, {
   3.520097471527652*^9, 3.520097472354453*^9}, 3.520097511510522*^9, 
   3.5200975838166494`*^9, 3.5201143738109474`*^9, 3.520513589302034*^9, 
   3.5205136623413625`*^9, {3.520514073424489*^9, 3.5205141015045385`*^9}, 
   3.520514302386091*^9, {3.5205144616311707`*^9, 3.520514480273204*^9}, 
   3.520682872981331*^9, 3.5209524244167905`*^9, {3.521320260201367*^9, 
   3.5213202607161674`*^9}, {3.5213208588524184`*^9, 
   3.5213208592424192`*^9}, {3.521321063696378*^9, 3.5213210826504116`*^9}, 
   3.5213368655413327`*^9, {3.521336947675477*^9, 3.5213369621367025`*^9}, {
   3.5213966579607615`*^9, 3.5213966871927953`*^9}, {3.521396741060253*^9, 
   3.5213967749489822`*^9}, 3.5213987667129984`*^9, 3.521398881538109*^9, {
   3.521399199305035*^9, 3.521399209289392*^9}, {3.521399628712493*^9, 
   3.5213996288526945`*^9}, 3.521399708607376*^9, {3.521399770726699*^9, 
   3.5213997776366353`*^9}, {3.5213998661338882`*^9, 
   3.5213998710609727`*^9}, {3.521485797986291*^9, 3.521485810123744*^9}, {
   3.5214858737051697`*^9, 3.52148588897713*^9}, {3.5214859501150417`*^9, 
   3.5214860558370624`*^9}, {3.5214866638112864`*^9, 3.521486690609821*^9}, {
   3.5214912805498304`*^9, 3.5214912869390173`*^9}, {3.5214913224801235`*^9, 
   3.5214913273671503`*^9}, {3.5215714388876333`*^9, 3.5215714412310033`*^9}, 
   3.5215715755140924`*^9, 3.5215717097471104`*^9, {3.5215800970073986`*^9, 
   3.521580111908826*^9}, {3.521580506255869*^9, 3.521580506386056*^9}, {
   3.521580552872901*^9, 3.521580553373621*^9}, {3.521580714565403*^9, 
   3.5215808059267745`*^9}, {3.521580867084715*^9, 3.521580901704496*^9}, {
   3.5215812956309347`*^9, 3.5215812957711363`*^9}, {3.5215813291090736`*^9, 
   3.5215813292092175`*^9}, {3.5215813837776833`*^9, 
   3.5215813838577986`*^9}, {3.5215815013066816`*^9, 3.521581501426854*^9}, {
   3.521581574972608*^9, 3.5215815750827665`*^9}, {3.5215816367414274`*^9, 
   3.521581650851717*^9}, {3.521581692221203*^9, 3.52158174727036*^9}, {
   3.521581807837451*^9, 3.5215818209963727`*^9}, {3.5215819478587923`*^9, 
   3.5215819479188786`*^9}, {3.521582061041541*^9, 3.5215820617024913`*^9}, 
   3.521585421483619*^9, {3.521586705199512*^9, 3.5215867053296995`*^9}, {
   3.5215869762993345`*^9, 3.5215869769702992`*^9}, {3.521635550653515*^9, 
   3.5216355512844224`*^9}, {3.5216378926210995`*^9, 
   3.5216379050890274`*^9}, {3.521638014266016*^9, 3.5216380220071473`*^9}, {
   3.521727489183346*^9, 3.5217274897842093`*^9}, {3.5217381974010067`*^9, 
   3.5217381979718275`*^9}, {3.521745781205982*^9, 3.521745781316141*^9}, {
   3.5218115055275984`*^9, 3.52181150557767*^9}, {3.5219262474633183`*^9, 
   3.5219262479540243`*^9}, {3.5219799109066305`*^9, 3.521979910986746*^9}, {
   3.521980132845763*^9, 3.5219801469260097`*^9}, {3.521980393971243*^9, 
   3.5219804010013523`*^9}, {3.5219938767084675`*^9, 
   3.5219938767785683`*^9}, {3.52200857505365*^9, 3.5220085753540816`*^9}, {
   3.5220086590243936`*^9, 3.5220086590844803`*^9}, {3.5220093928696113`*^9, 
   3.522009392939712*^9}, {3.522009483329686*^9, 3.5220094833797584`*^9}, {
   3.5220096506202383`*^9, 3.522009651090915*^9}, {3.5220097695212097`*^9, 
   3.5220097778031187`*^9}, {3.5220098481142206`*^9, 3.522009855124301*^9}, {
   3.522010782037136*^9, 3.5220107927725725`*^9}, {3.5220703562323456`*^9, 
   3.5220703694413395`*^9}, {3.522091982970067*^9, 3.522091983360629*^9}, {
   3.522093443390048*^9, 3.5220934434401197`*^9}, {3.5220940062393856`*^9, 
   3.522094018246651*^9}, {3.522094048890715*^9, 3.522094072074051*^9}, {
   3.5220942406364317`*^9, 3.5220942608254623`*^9}, {3.5220942929216146`*^9, 
   3.5220943253382273`*^9}, {3.5220943589665823`*^9, 
   3.5220944960937614`*^9}, {3.5220951204114866`*^9, 
   3.5220952068257437`*^9}, {3.522095237830326*^9, 3.5220952966649265`*^9}, {
   3.522095336842699*^9, 3.5220953750977073`*^9}, {3.5220954470211277`*^9, 
   3.522095483193141*^9}, {3.522095541256632*^9, 3.5220955530135374`*^9}, {
   3.5220956240356627`*^9, 3.522095638105894*^9}, {3.522095701607205*^9, 
   3.522095706173771*^9}, {3.522095911559101*^9, 3.522095961951562*^9}, {
   3.522095995730133*^9, 3.5220960066458287`*^9}, {3.522096052121219*^9, 
   3.5220961308744607`*^9}, {3.5220963086200466`*^9, 3.522096309260968*^9}, {
   3.5220963532141695`*^9, 3.5220963633687716`*^9}, {3.522096490701867*^9, 
   3.5220965567067776`*^9}, {3.5220966006199217`*^9, 3.522096637252597*^9}, {
   3.522156776545392*^9, 3.5221567765954638`*^9}, {3.522157486566352*^9, 
   3.522157486626438*^9}, {3.522159938842552*^9, 3.522159938912653*^9}, {
   3.522167553612053*^9, 3.522167591917133*^9}, {3.522167735263254*^9, 
   3.5221677378870273`*^9}, {3.522168142969507*^9, 3.5221681432298813`*^9}, {
   3.522168243594198*^9, 3.5221682509948397`*^9}, {3.5221687417605267`*^9, 
   3.5221687419107423`*^9}, {3.522169121596704*^9, 3.5221691221374817`*^9}, {
   3.522169268397794*^9, 3.5221692826582994`*^9}, {3.5221693652871137`*^9, 
   3.5221693657878337`*^9}, {3.52218083709276*^9, 3.5221808372329617`*^9}, {
   3.5221815413954973`*^9, 3.522181541956304*^9}, {3.5221889709186273`*^9, 
   3.5221889715495343`*^9}, {3.5222397621214304`*^9, 3.522239764084253*^9}, {
   3.522240481365653*^9, 3.522240481515869*^9}, {3.5222407577731075`*^9, 
   3.5222407579032946`*^9}, {3.522241085314088*^9, 3.522241085834837*^9}, {
   3.5222415827781353`*^9, 3.522241595008557*^9}, {3.522242117859075*^9, 
   3.522242119543878*^9}, 3.5222434352441893`*^9, 3.52224419819473*^9, 
   3.5222444487623696`*^9, {3.522244549374149*^9, 3.522244550544151*^9}, 
   3.5222594215166717`*^9, {3.5226098791431055`*^9, 3.5226098798140707`*^9}, {
   3.522610504912918*^9, 3.5226105050330915`*^9}, {3.5226114586743603`*^9, 
   3.5226114599962606`*^9}, {3.522698765127237*^9, 3.522698765187323*^9}, {
   3.5227080916381006`*^9, 3.5227080920587053`*^9}, {3.522708237718154*^9, 
   3.5227082379685135`*^9}, {3.5227088790102863`*^9, 3.522708881754232*^9}, {
   3.523021171989256*^9, 3.5230211724499187`*^9}, {3.523023668098485*^9, 
   3.523023668509075*^9}, {3.5230242126414995`*^9, 3.523024212701586*^9}, {
   3.523032910248043*^9, 3.523032910648619*^9}, {3.523034078207486*^9, 
   3.523034078668149*^9}, {3.523038953187363*^9, 3.5230389536079683`*^9}, {
   3.523042207536888*^9, 3.523042216119229*^9}, {3.523042570398658*^9, 
   3.523042582666298*^9}, {3.523047015770789*^9, 3.523047017973957*^9}, {
   3.523047101574168*^9, 3.5230471150735793`*^9}, {3.523047520506563*^9, 
   3.5230475620663233`*^9}, {3.5230476088435855`*^9, 3.523047671373499*^9}, {
   3.5230489590350657`*^9, 3.523048968678933*^9}, {3.523106978494835*^9, 
   3.523107016539541*^9}, {3.5231071473676624`*^9, 3.5231071694494143`*^9}, {
   3.5231072884004574`*^9, 3.5231072989456205`*^9}, {3.5231080588683357`*^9, 
   3.5231080679213533`*^9}, {3.523108247169099*^9, 3.5231083111811438`*^9}, {
   3.5231083559354973`*^9, 3.523108579947611*^9}, {3.52310917707624*^9, 
   3.523109213308339*^9}, {3.523109251102685*^9, 3.5231093761024256`*^9}, {
   3.523110338916885*^9, 3.5231103680788174`*^9}, {3.523110585982147*^9, 
   3.523110588936395*^9}, {3.5231108938047743`*^9, 3.5231108980709085`*^9}, {
   3.523132259196699*^9, 3.5231323077465105`*^9}, {3.5231323463319936`*^9, 
   3.5231323597212467`*^9}, 3.523132392538435*^9, {3.5236256736851807`*^9, 
   3.5236256743461313`*^9}, {3.5236258715897536`*^9, 3.523625873121957*^9}, {
   3.5236262863361297`*^9, 3.5236262902717886`*^9}, {3.523627425113611*^9, 
   3.5236274406659746`*^9}, {3.523627471149808*^9, 3.523627472021061*^9}, {
   3.5236275069613028`*^9, 3.523627521472168*^9}, {3.5236276426363935`*^9, 
   3.5236276428066387`*^9}, {3.5236277891570797`*^9, 3.5236277892972813`*^9}, 
   3.5236278923354435`*^9, {3.523820512709104*^9, 3.5238205136504574`*^9}, {
   3.523821337094512*^9, 3.523821337615261*^9}, {3.5238234383860207`*^9, 
   3.523823438786597*^9}, {3.5238411373258467`*^9, 3.5238412577490063`*^9}, {
   3.5238412910268574`*^9, 3.523841384050619*^9}, {3.5238414484932833`*^9, 
   3.5238419209025745`*^9}, {3.5238419828917103`*^9, 3.523841993186514*^9}, {
   3.5238424905216465`*^9, 3.5238427639648385`*^9}, {3.523842808218472*^9, 
   3.5238429707421694`*^9}, {3.5238430007453117`*^9, 
   3.5238430469317245`*^9}, {3.5238836496181912`*^9, 
   3.5238836783294764`*^9}, {3.5238837564818535`*^9, 3.5238838532009287`*^9}, 
   3.523884764851818*^9, {3.5238848312072325`*^9, 3.5238848368052826`*^9}, {
   3.52388495025842*^9, 3.5238850743067927`*^9}, {3.523885146440516*^9, 
   3.5238851718871064`*^9}, {3.5238854432573175`*^9, 3.523885443988369*^9}, {
   3.523885728597617*^9, 3.5238858442739515`*^9}, {3.523886359635004*^9, 
   3.5238864128515253`*^9}, {3.5238864481222425`*^9, 3.523886622492975*^9}, {
   3.5238894888746295`*^9, 3.5238895098547974`*^9}, 3.523901672353612*^9, {
   3.523901901252753*^9, 3.5239019017735014`*^9}, {3.523901949051484*^9, 
   3.523901999003311*^9}, {3.523902358610401*^9, 3.5239023744732103`*^9}, {
   3.5244213807919807`*^9, 3.524421425085672*^9}, 3.5244215917052593`*^9, {
   3.524422415609976*^9, 3.524422416160768*^9}, {3.5244262013936653`*^9, 
   3.524426217546893*^9}, {3.5244263773767166`*^9, 3.5244263813223906`*^9}, {
   3.524426686150712*^9, 3.524426687432555*^9}, 3.5244268763642254`*^9, {
   3.5245092038204393`*^9, 3.52450920389054*^9}, {3.524509355188095*^9, 
   3.5245093555486135`*^9}, {3.5245094500444922`*^9, 
   3.5245094504851255`*^9}, {3.5245097109997272`*^9, 
   3.5245097141342344`*^9}, {3.5245153294787035`*^9, 
   3.5245153302397976`*^9}, {3.524516485090391*^9, 3.5245164853607802`*^9}, {
   3.5245170979516425`*^9, 3.5245170984223194`*^9}, {3.5245743040097837`*^9, 
   3.5245743049210944`*^9}, {3.5245746596111135`*^9, 3.524574659971632*^9}, {
   3.524750289733416*^9, 3.5247502902842083`*^9}, {3.524751562954218*^9, 
   3.5247515633748226`*^9}, {3.5247521994394383`*^9, 3.524752199509539*^9}, {
   3.5247523039697456`*^9, 3.5247523042401342`*^9}, {3.52475291645045*^9, 
   3.5247529165205507`*^9}, {3.5247530871158543`*^9, 3.524753087536459*^9}},
 FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input data points  ndata =\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"  data = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0.`", "0.`"},
       {"1.`", "0", "0.25`"},
       {"0", "1", "0.25`"},
       {"1.5`", "0.5`", "0"},
       {"1", "1.5`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Input data points  ndata =", 5, "  data = ", 
   MatrixForm[{{0, 0., 0.}, {1., 0, 0.25}, {0, 1, 0.25}, {1.5, 0.5, 0}, {
     1, 1.5, 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.629914141781111*^9, 3.629914309643169*^9, 3.629915071401623*^9, 
   3.6299151127116127`*^9, {3.62991515442745*^9, 3.6299151756924267`*^9}, 
   3.629995060349325*^9, 3.629995305632167*^9, 3.629995374451026*^9, 
   3.629995529872508*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input normals nn = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.6396021490668312`"}], 
        RowBox[{"-", "0.6396021490668312`"}], "0.42640143271122083`"},
       {"0.2294157338705618`", 
        RowBox[{"-", "0.6882472016116854`"}], "0.6882472016116854`"},
       {
        RowBox[{"-", "0.6882472016116854`"}], "0.2294157338705618`", 
        "0.6882472016116854`"},
       {"0.8017837257372732`", 
        RowBox[{"-", "0.2672612419124244`"}], "0.5345224838248488`"},
       {"0.2672612419124244`", "0.8017837257372732`", "0.5345224838248488`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Input normals nn = ", 
   MatrixForm[{{-0.6396021490668312, -0.6396021490668312, 
    0.42640143271122083`}, {0.2294157338705618, -0.6882472016116854, 
    0.6882472016116854}, {-0.6882472016116854, 0.2294157338705618, 
    0.6882472016116854}, {0.8017837257372732, -0.2672612419124244, 
    0.5345224838248488}, {0.2672612419124244, 0.8017837257372732, 
    0.5345224838248488}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.629914141781111*^9, 3.629914309643169*^9, 3.629915071401623*^9, 
   3.6299151127116127`*^9, {3.62991515442745*^9, 3.6299151756924267`*^9}, 
   3.629995060349325*^9, 3.629995305632167*^9, 3.629995374451026*^9, 
   3.629995529874052*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input faces  nfaces =\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Input faces  nfaces =", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.629914141781111*^9, 3.629914309643169*^9, 3.629915071401623*^9, 
   3.6299151127116127`*^9, {3.62991515442745*^9, 3.6299151756924267`*^9}, 
   3.629995060349325*^9, 3.629995305632167*^9, 3.629995374451026*^9, 
   3.62999552987529*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"face \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" #verts =\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"   vertices =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   neighbors=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "0"}], "}"}]}],
  SequenceForm[
  "face ", 1, " #verts =", 3, "   vertices =", {2, 3, 1}, "   neighbors=", {2,
    0, 0}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.629914141781111*^9, 3.629914309643169*^9, 3.629915071401623*^9, 
   3.6299151127116127`*^9, {3.62991515442745*^9, 3.6299151756924267`*^9}, 
   3.629995060349325*^9, 3.629995305632167*^9, 3.629995374451026*^9, 
   3.629995529876235*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"face \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" #verts =\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"   vertices =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "5", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\"   neighbors=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}],
  SequenceForm[
  "face ", 2, " #verts =", 4, "   vertices =", {2, 4, 5, 3}, 
   "   neighbors=", {0, 0, 0, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.629914141781111*^9, 3.629914309643169*^9, 3.629915071401623*^9, 
   3.6299151127116127`*^9, {3.62991515442745*^9, 3.6299151756924267`*^9}, 
   3.629995060349325*^9, 3.629995305632167*^9, 3.629995374451026*^9, 
   3.62999552987792*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Created working Bezier patch bb1 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}]},
       {
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}]},
       {
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}]},
       {
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}], 
        RowBox[{"(", "\[NoBreak]", 
         TagBox[GridBox[{
            {"0"},
            {"0"},
            {"0"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          Column], "\[NoBreak]", ")"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Created working Bezier patch bb1 = ", 
   MatrixForm[{{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 
    0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 
    0}}, {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.629914141781111*^9, 3.629914309643169*^9, 3.629915071401623*^9, 
   3.6299151127116127`*^9, {3.62991515442745*^9, 3.6299151756924267`*^9}, 
   3.629995060349325*^9, 3.629995305632167*^9, 3.629995374451026*^9, 
   3.62999552988413*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "\n",
 StyleBox["Core G1 Functions",
  FontSize->24]
}], "Section",
 CellChangeTimes->{{3.5126106282852554`*^9, 3.5126106568804216`*^9}, 
   3.512610692885683*^9, {3.512610948401359*^9, 3.5126110104277544`*^9}, {
   3.512611046136612*^9, 3.5126111722018285`*^9}, {3.512611241419916*^9, 
   3.5126112622149825`*^9}, {3.5126113365811357`*^9, 
   3.5126113465340633`*^9}, {3.5126114872322674`*^9, 3.512611540023344*^9}, 
   3.512611582175084*^9, {3.5126116559796305`*^9, 3.512611670425416*^9}, {
   3.5126117361802588`*^9, 3.512611752498068*^9}, 3.5126463289362526`*^9, {
   3.5126463690131664`*^9, 3.5126463756432514`*^9}, {3.5126466769355173`*^9, 
   3.512646680180359*^9}, {3.512646760755392*^9, 3.512646763937833*^9}, {
   3.5126468008947067`*^9, 3.5126468016591167`*^9}, {3.512649501002942*^9, 
   3.512649526521532*^9}, {3.512649973945984*^9, 3.5126499791255827`*^9}, {
   3.512650106883809*^9, 3.5126501278362207`*^9}, {3.5126503206025944`*^9, 
   3.5126503245495462`*^9}, {3.512650549818143*^9, 3.5126505607382827`*^9}, {
   3.512650601735608*^9, 3.5126506574283223`*^9}, {3.5126506876615095`*^9, 
   3.5126507464274635`*^9}, {3.512651020538577*^9, 3.5126510294150915`*^9}, {
   3.5126510663251643`*^9, 3.5126511006612043`*^9}, 3.5126511315340004`*^9, 
   3.512651278971491*^9, {3.512651328424782*^9, 3.512651331451298*^9}, {
   3.5126513763810263`*^9, 3.5126514018724065`*^9}, {3.5126514339627204`*^9, 
   3.5126515331663*^9}, {3.5126515661925583`*^9, 3.512651603415352*^9}, {
   3.5126517218854628`*^9, 3.512651729124002*^9}, {3.512651995530325*^9, 
   3.512652014344287*^9}, {3.512653313655458*^9, 3.512653314700671*^9}, 
   3.5126548290257626`*^9, {3.5126548987586565`*^9, 3.5126549084463806`*^9}, {
   3.512654974341625*^9, 3.5126549770872602`*^9}, {3.512655268967003*^9, 
   3.5126553093715205`*^9}, {3.5126636588161955`*^9, 
   3.5126636602039547`*^9}, {3.5126646951940365`*^9, 
   3.5126647237286315`*^9}, {3.5126647678644266`*^9, 3.512664787475135*^9}, {
   3.5126648959633656`*^9, 3.512664938537676*^9}, {3.51266498922435*^9, 
   3.5126650805508475`*^9}, 3.5126651148099847`*^9, {3.5126653323637285`*^9, 
   3.512665363779108*^9}, 3.5126654332392282`*^9, 3.5126654755423603`*^9, {
   3.5126660053686566`*^9, 3.512666056068657*^9}, {3.5126661089370565`*^9, 
   3.512666146845126*^9}, {3.5126662052834754`*^9, 3.5126662764208794`*^9}, 
   3.512666867059222*^9, {3.5126672403919144`*^9, 3.512667322278428*^9}, {
   3.5126678601800795`*^9, 3.5126679348119144`*^9}, {3.5126680352778463`*^9, 
   3.51266804275039*^9}, {3.512668298513115*^9, 3.512668298981124*^9}, {
   3.5126683313977423`*^9, 3.5126683439554205`*^9}, {3.5126686070894732`*^9, 
   3.5126686091486206`*^9}, 3.51266868310811*^9, {3.5126700985463495`*^9, 
   3.5126703314417353`*^9}, {3.5126703675248814`*^9, 3.512670379802003*^9}, {
   3.512670479298165*^9, 3.512670482028147*^9}, {3.512670514975136*^9, 
   3.5126705179547167`*^9}, {3.5126790405894136`*^9, 
   3.5126790429918604`*^9}, {3.512844612440539*^9, 3.512844642674114*^9}, {
   3.51284468345356*^9, 3.512844774903105*^9}, {3.5128448518442774`*^9, 
   3.512844853185912*^9}, {3.5128453089827986`*^9, 3.5128453344114504`*^9}, {
   3.512857240030056*^9, 3.5128572410596495`*^9}, {3.512915276592617*^9, 
   3.512915307621813*^9}, 3.512915457557257*^9, 3.5129156949329433`*^9, {
   3.5129157288170123`*^9, 3.512915755587299*^9}, {3.51291579034499*^9, 
   3.51291580048525*^9}, 3.5129159478026342`*^9, {3.5244216670936623`*^9, 
   3.5244216757160606`*^9}},
 FontSize->16],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"project", "[", 
     RowBox[{"aa_", ",", "nn_", ",", "xx_"}], "]"}], ":=", 
    RowBox[{"xx", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"aa", "-", "xx"}], ")"}], ".", "nn"}], ")"}], "*", 
      "nn"}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "project", " ", "xx", " ", "into", " ", "plane", " ", "through", " ", "aa",
     " ", "with", " ", "unit", " ", "normal", " ", "nn"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "ratio", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}]}], ":", 
    RowBox[{
    "t", " ", "should", " ", "depend", " ", "on", " ", "the", " ", "normal", 
     " ", "angle", " ", "??"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Sphere", " ", "can", " ", "be", " ", "good", " ", "with", " ", "t"}], 
     "=", "0.5"}], ",", " ", 
    RowBox[{
    "but", " ", "this", " ", "causes", " ", "problems", " ", "in", " ", 
     "planar"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"t", "=", 
    RowBox[{"0.4", " ", "also", " ", "good", " ", "for", " ", "curved"}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Piper", " ", "=", " ", 
    RowBox[{"t", "=", 
     RowBox[{"1", "/", "3"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"aux", "[", 
     RowBox[{"i_", ",", "j_"}], "]"}], ":=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "/", "3"}], ")"}], "*", 
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "3"}], ")"}], "*", 
      RowBox[{"data", "[", 
       RowBox[{"[", "j", "]"}], "]"}]}]}]}], ";"}], "   ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"boundary", "[", 
      RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"data", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"project", "[", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"nn", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"aux", "[", 
          RowBox[{"i", ",", "j"}], "]"}]}], "]"}], ",", 
       RowBox[{"project", "[", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"nn", "[", 
          RowBox[{"[", "j", "]"}], "]"}], ",", 
         RowBox[{"aux", "[", 
          RowBox[{"j", ",", "i"}], "]"}]}], "]"}], ",", 
       RowBox[{"data", "[", 
        RowBox[{"[", "j", "]"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"boundary", "[", 
     RowBox[{"i_", ",", "j_"}], "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", 
      RowBox[{"project", "[", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"nn", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"aux", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}], "]"}], ",", 
      RowBox[{"project", "[", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"nn", "[", 
         RowBox[{"[", "j", "]"}], "]"}], ",", 
        RowBox[{"aux", "[", 
         RowBox[{"j", ",", "i"}], "]"}]}], "]"}], ",", 
      RowBox[{"data", "[", 
       RowBox[{"[", "j", "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"columnfix", "[", 
     RowBox[{"a_", ",", "j_", ",", "vec_"}], "]"}], " ", ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"auxx", "=", "a"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"auxx", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
         RowBox[{"vec", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "vec", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "auxx"}], "\[IndentingNewLine]", ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"guesstri", "[", 
     RowBox[{"pp_", ",", "qq_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "\"\<intelligent\>\"", " ", "guesses", " ", "for", " ", "the", " ", 
         "unknowns", " ", 
         RowBox[{"pp", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
        RowBox[{"pp", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"shrink", " ", "to", " ", "deg", " ", "4", " ", "patch"}], " ",
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ribbon1", " ", "=", " ", 
        RowBox[{
         RowBox[{"3", "/", "4"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"pp", "[", 
            RowBox[{"[", "1", "]"}], "]"}], " ", "-", " ", 
           RowBox[{"qq", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ribbon2", " ", "=", " ", 
        RowBox[{
         RowBox[{"3", "/", "4"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"pp", "[", 
            RowBox[{"[", "4", "]"}], "]"}], " ", "-", " ", 
           RowBox[{"qq", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"pp", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "\[IndentingNewLine]", " ", 
         RowBox[{
          RowBox[{"qq", "[", 
           RowBox[{"[", "2", "]"}], "]"}], " ", "+", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "ribbon1"}], "+", " ", "ribbon2"}], " ", ")"}], "/",
            "3"}]}], ",", "\[IndentingNewLine]", " ", 
         RowBox[{
          RowBox[{"qq", "[", 
           RowBox[{"[", "3", "]"}], "]"}], " ", "+", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"ribbon1", "   ", "+", " ", 
             RowBox[{"2", "ribbon2"}]}], ")"}], "/", "3"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"pp", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
      ")"}], "//", "N"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"guessleft", "[", 
     RowBox[{"pp_", ",", "qq_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "\"\<intelligent\>\"", " ", "guesses", " ", "for", " ", "the", " ", 
         "unknowns", " ", 
         RowBox[{"pp", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
        RowBox[{"pp", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pp", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\[IndentingNewLine]", " ", 
       RowBox[{
        RowBox[{"qq", "[", 
         RowBox[{"[", "2", "]"}], "]"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"pp", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"pp", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "-", 
             RowBox[{"qq", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}], " ", ")"}], "/", 
         "3"}]}], ",", "\[IndentingNewLine]", " ", 
       RowBox[{
        RowBox[{"qq", "[", 
         RowBox[{"[", "3", "]"}], "]"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"pp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{"qq", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "   ", "+", " ", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"pp", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "-", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}], ")"}], "/", 
         "3"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"pp", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], "//", 
     "N"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"guessright", "[", 
     RowBox[{"qq_", ",", "rr_"}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "\"\<intelligent\>\"", " ", "guesses", " ", "for", " ", "the", " ", 
         "unknowns", " ", 
         RowBox[{"rr", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
        RowBox[{"rr", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rr", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\[IndentingNewLine]", " ", 
       RowBox[{
        RowBox[{"qq", "[", 
         RowBox[{"[", "2", "]"}], "]"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"rr", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"rr", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "-", 
             RowBox[{"qq", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}], " ", ")"}], "/", 
         "3"}]}], ",", "\[IndentingNewLine]", " ", 
       RowBox[{
        RowBox[{"qq", "[", 
         RowBox[{"[", "3", "]"}], "]"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"rr", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{"qq", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "   ", "+", " ", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"rr", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "-", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}], ")"}], "/", 
         "3"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"rr", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], "//", 
     "N"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"elevate", "[", "bb_", "]"}], ":=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"bb", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"bb", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{"3", 
           RowBox[{"bb", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "/", "4"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"bb", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "+", 
          RowBox[{"bb", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", "2"}], ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", 
           RowBox[{"bb", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "+", 
          RowBox[{"bb", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ")"}], "/", "4"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"bb", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], "//", "N"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"bern", "[", 
     RowBox[{"n_", ",", "i_", ",", "t_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", "\[Equal]", "0"}], ",", " ", 
        RowBox[{"ti", " ", "=", " ", "1.0"}], ",", " ", 
        RowBox[{"ti", " ", "=", " ", 
         RowBox[{"t", "^", "i"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "i"}], ")"}], "\[Equal]", " ", "0"}], ",", " ", 
        RowBox[{"nmit", " ", "=", " ", "1.0"}], ",", " ", 
        RowBox[{"nmit", " ", "=", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "t"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "i"}], ")"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"n", ",", "i"}], "]"}], "*", "nmit", "*", "ti"}]}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"tribern", "[", 
     RowBox[{"n_", ",", "i_", ",", "j_", ",", "u_", ",", "v_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"facn", " ", "=", " ", 
       RowBox[{"Factorial", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"faci", " ", "=", " ", 
       RowBox[{"Factorial", "[", "i", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"facj", " ", "=", " ", 
       RowBox[{"Factorial", "[", "j", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"facnij", " ", "=", " ", 
       RowBox[{"Factorial", "[", 
        RowBox[{"n", "-", "i", "-", "j"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"i", " ", "\[Equal]", " ", "0"}], ",", " ", 
        RowBox[{"ui", " ", "=", " ", "1.0"}], ",", " ", 
        RowBox[{"ui", " ", "=", " ", 
         RowBox[{"u", "^", "i"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"j", "\[Equal]", "0"}], ",", " ", 
        RowBox[{"vj", " ", "=", " ", "1.0"}], ",", " ", 
        RowBox[{"vj", " ", "=", " ", 
         RowBox[{"v", "^", "j"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "i", "-", "j"}], ")"}], " ", "\[Equal]", " ", 
         "0"}], ",", " ", 
        RowBox[{"uvij", " ", "=", " ", "1.0"}], ",", " ", 
        RowBox[{"uvij", " ", "=", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1.0", "-", "u", "-", "v"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "i", "-", "j"}], ")"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"val", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"facn", "/", 
          RowBox[{"(", 
           RowBox[{"faci", "*", "facj", "*", "facnij"}], ")"}]}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"ui", "*", "vj", "*", "uvij"}], ")"}]}]}]}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Gregory", " ", 
    RowBox[{"quad", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"old", " ", 
    RowBox[{"gquad", "[", 
     RowBox[{
     "bb_", ",", "c22_", ",", "c23_", ",", "c32_", ",", "c33_", ",", "u_", 
      ",", "v_"}], "]"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"gquad", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "the", " ", "second", " ", "and", " ", "third", " ", "rows", " ", "of", 
       " ", "bb", " ", "are", " ", "from", " ", "ribbons", " ", "across", " ",
        "v"}], "=", 
      RowBox[{
       RowBox[{"0", " ", "and", " ", "v"}], "=", "1"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"aa", "=", "bb1"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"aa", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "*", 
           RowBox[{"aa", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "+", 
          RowBox[{"v", "*", "cc22"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"u", "+", "v"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"aa", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "*", 
           RowBox[{"aa", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "v"}], ")"}], "*", "cc23"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", "u", "-", "v"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"aa", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "u"}], ")"}], "*", 
           RowBox[{"aa", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", 
          RowBox[{"v", "*", "cc32"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", "u", "+", "v"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"aa", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "3"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "u"}], ")"}], "*", 
           RowBox[{"aa", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "3"}], "]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "v"}], ")"}], "*", "cc33"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "-", "u", "-", "v"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"aa", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", 
            RowBox[{"j", "+", "1"}]}], "]"}], "]"}], "*", 
         RowBox[{"bern", "[", 
          RowBox[{"3", ",", "i", ",", "u"}], "]"}], "*", 
         RowBox[{"bern", "[", 
          RowBox[{"3", ",", "j", ",", "v"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "3"}], "}"}]}], "]"}]}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Gregory", " ", 
    RowBox[{"triangle", ":"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"gtri", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ss", "=", "tt1"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"eps", " ", "=", " ", "0.00000001"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"upv", " ", "=", " ", 
       RowBox[{"u", "+", "v"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"u1", " ", "=", " ", 
       RowBox[{"1.0", " ", "-", "u"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"v1", " ", "=", " ", 
       RowBox[{"1.0", " ", "-", " ", "v"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", "upv", "]"}], " ", "\[LessEqual]", " ", 
           "eps"}], ",", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"upv", "<", " ", "0"}], ",", " ", 
            RowBox[{"upv", " ", "=", " ", 
             RowBox[{"upv", " ", "-", " ", "eps"}]}], ",", " ", 
            RowBox[{"upv", " ", "=", " ", 
             RowBox[{"upv", " ", "+", " ", "eps"}]}]}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", "u1", "]"}], "<=", " ", "eps"}], ",", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"u1", " ", "<", " ", "0"}], ",", " ", 
            RowBox[{"u1", " ", "=", "  ", 
             RowBox[{"u1", " ", "-", " ", "eps"}]}], ",", " ", 
            RowBox[{"u1", " ", "=", " ", 
             RowBox[{"u1", " ", "+", " ", "eps"}]}]}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", "v1", "]"}], " ", "<=", " ", "eps"}], ",", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"v1", " ", "<", " ", "0"}], ",", " ", 
            RowBox[{"v1", " ", "=", "  ", 
             RowBox[{"v1", " ", "-", " ", "eps"}]}], ",", " ", 
            RowBox[{"v1", " ", "=", " ", 
             RowBox[{"v1", " ", "+", " ", "eps"}]}]}], "]"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "  ", 
       RowBox[{"This", " ", "is", " ", "the", " ", "old", " ", "one"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ss", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"u", "*", 
             RowBox[{"ss", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "+", 
            RowBox[{"v", "*", "dd22"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"u", "+", "v"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ss", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"u", "*", 
             RowBox[{"ss", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "v"}], ")"}], "*", "dd23"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", "v", "+", "u"}], ")"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ss", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "u"}], ")"}], "*", 
             RowBox[{"ss", "[", 
              RowBox[{"[", 
               RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", 
            RowBox[{"v", "*", "dd32"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", "u", "+", "v"}], ")"}]}]}], ";"}], 
       "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ss", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "*", 
           RowBox[{"ss", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "+", 
          RowBox[{"v", "*", "dd22"}]}], ")"}], "/", "upv"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ss", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"u", "*", 
           RowBox[{"ss", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "u", "-", "v"}], ")"}], "*", "dd23"}]}], ")"}], 
        "/", "v1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ss", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "2"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "u", "-", "v"}], ")"}], "*", 
           RowBox[{"ss", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", " ", 
          RowBox[{"v", "*", "dd32"}]}], ")"}], "/", "u1"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ss", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", 
            RowBox[{"j", "+", "1"}]}], "]"}], "]"}], "*", 
         RowBox[{"tribern", "[", 
          RowBox[{"4", ",", "i", ",", "j", ",", "u", ",", "v"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", 
          RowBox[{"4", "-", "j"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
     ")"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
    "*"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Create", " ", "G1", " ", "tangent", " ", 
    RowBox[{"ribbons", ".", " ", "Numbering"}], " ", "of", " ", "topleft", 
    " ", "etc", " ", "is", " ", "*", "away", "*", " ", "from", " ", 
    RowBox[{"qq", "."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"interiorG1", "[", 
     RowBox[{
     "qq_", ",", "topleft_", ",", "topright_", ",", "bottomleft_", ",", 
      "bottomright_", ",", " ", "nume_", ",", " ", "numenbr_"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"(", " ", "\[IndentingNewLine]", 
     RowBox[{"(*", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", "\"\<in interiorG1\>\"", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<qq = \>\"", ",", 
         RowBox[{"MatrixForm", "[", "qq", "]"}], ",", "\"\<  topl=\>\"", ",", 
         RowBox[{"MatrixForm", "[", "topleft", "]"}], ",", 
         "\"\<  topr = \>\"", ",", 
         RowBox[{"MatrixForm", "[", "topright", "]"}], ",", "\"\<botl=\>\"", 
         ",", 
         RowBox[{"MatrixForm", "[", "bottomleft", "]"}], ",", 
         "\"\<  botr=\>\"", ",", 
         RowBox[{"MatrixForm", "[", "bottomright", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<numedges=\>\"", ",", "nume", ",", "\"\<  numedges nbr = \>\"", 
         ",", "numenbr"}], "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"First", ",", " ", 
       RowBox[{"determine", " ", "geometry", " ", "parameters", " ", "l0"}], 
       ",", " ", 
       RowBox[{"m0", "  ", "and", " ", "l1", " ", "m1", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"lambda", "'"}], "s", " ", "and", " ", 
           RowBox[{"mu", "'"}], "s", " ", "in", " ", "text"}], ")"}], 
         "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Create", " ", "degree", " ", "4", " ", "boundary", " ", "data", " ", 
       "that", " ", "is", " ", "needed"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"qqhat", " ", "=", " ", 
       RowBox[{"elevate", "[", "qq", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<After elevate: qqhat=\>\"", ",", "qqhat"}], "]"}], 
        ";"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"nume", " ", "\[Equal]", " ", "4"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"bndrytl", " ", "=", " ", 
           RowBox[{"topleft", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"bndrybl", " ", "=", " ", 
           RowBox[{"bottomleft", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"bndrytl", " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", "*", 
               RowBox[{"topleft", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
              RowBox[{"topleft", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "4.0"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"bndrybl", " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", "*", 
               RowBox[{"bottomleft", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
              RowBox[{"bottomleft", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "4.0"}]}]}], 
         ")"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"numenbr", " ", "\[Equal]", " ", "4"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"bndrytr", " ", "=", " ", 
           RowBox[{"topright", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"bndrybr", " ", "=", " ", 
           RowBox[{"bottomright", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"bndrytr", " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", "*", 
               RowBox[{"topright", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
              RowBox[{"topright", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "4.0"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"bndrybr", " ", "=", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", "*", 
               RowBox[{"bottomright", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
              RowBox[{"bottomright", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "4.0"}]}]}], 
         ")"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<bndry points to use below depend on num edges\>\"",
          "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<bndrytl=\>\"", ",", "bndrytl", ",", "\"\<bndrybl=\>\"", ",", 
          "bndrybl", ",", "\"\< bndrytr=\>\"", ",", "bndrytr", ",", 
          "\"\< bndrybr=\>\"", ",", "bndrybr"}], "]"}], ";"}], 
       "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Is", " ", "it", " ", "better", " ", "to", " ", "use", " ", "the", " ",
         "degree", " ", "4", " ", "boundary", " ", "for", " ", "the", " ", 
        "triangle", " ", "in", " ", 
        RowBox[{"guess", " ", "?"}]}], "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"pp", "=", 
       RowBox[{"guessleft", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"bndrytl", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "bndrybl"}], "}"}],
          ",", "qq"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rr", "=", 
       RowBox[{"guessright", "[", 
        RowBox[{"qq", ",", 
         RowBox[{"{", 
          RowBox[{"bndrytr", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "bndrybr"}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"False", ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Guess pp = \>\"", ",", 
          RowBox[{"MatrixForm", "[", "pp", "]"}], ",", "\"\< qq=\>\"", ",", 
          RowBox[{"MatrixForm", "[", "qq", "]"}], ",", "\"\< Guess rr \>\"", 
          ",", 
          RowBox[{"MatrixForm", "[", "rr", "]"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"True", ",", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Guess pp = \>\"", ",", "pp", ",", "\"\< qq=\>\"", ",", "qq", 
          ",", "\"\< Guess rr \>\"", ",", "rr"}], "]"}]}], "]"}], ";", " ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"lmat", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "bndrytl"}], " ", "+", " ", "bndrytr"}], ",", " ", 
         RowBox[{
          RowBox[{"qqhat", "[", 
           RowBox[{"[", "1", "]"}], "]"}], " ", "-", " ", 
          RowBox[{"qqhat", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ltrans", " ", "=", " ", 
       RowBox[{"Transpose", "[", "lmat", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp0", "=", " ", 
       RowBox[{"LeastSquares", "[", 
        RowBox[{"ltrans", ",", " ", 
         RowBox[{
          RowBox[{"-", "bndrytl"}], " ", "+", " ", 
          RowBox[{"qqhat", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], " ", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"l0", "=", 
       RowBox[{"temp0", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"m0", " ", "=", " ", 
       RowBox[{"temp0", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"mmat", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "bndrybl"}], " ", "+", " ", "bndrybr"}], ",", " ", 
         RowBox[{
          RowBox[{"qqhat", "[", 
           RowBox[{"[", "4", "]"}], "]"}], " ", "-", " ", 
          RowBox[{"qqhat", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"mtrans", " ", "=", " ", 
       RowBox[{"Transpose", "[", "mmat", "]"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"temp1", " ", "=", " ", 
       RowBox[{"LeastSquares", "[", 
        RowBox[{"mtrans", ",", 
         RowBox[{
          RowBox[{"-", "bndrybl"}], " ", "+", " ", 
          RowBox[{"qqhat", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"l1", "=", 
       RowBox[{"temp1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"m1", " ", "=", " ", 
       RowBox[{"temp1", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"True", ",", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Factors from degree 4 bndry: l0=\>\"", ",", "l0", ",", 
          "\"\< m0=\>\"", ",", " ", "m0", ",", "\"\<  l1=\>\"", ",", " ", 
          "l1", ",", "\"\<  m1=\>\"", ",", "m1"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "Having", " ", "found", " ", "the", " ", "geometry", " ", "params"}], 
        ",", " ", 
        RowBox[{"compute", " ", "the", " ", 
         RowBox[{"unknowns", ":"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      "   ", 
      RowBox[{"mat", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"1", " ", "-", " ", "l0"}], ")"}]}], ",", "  ", 
           RowBox[{
            RowBox[{"-", "3"}], "*", "l0"}], ",", " ", "0", ",", " ", "0"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", " ", "-", " ", "l1"}], ")"}], ",", " ", "l1", ",", 
           " ", 
           RowBox[{"(", 
            RowBox[{"1", " ", "-", " ", "l0"}], ")"}], ",", " ", "l0"}], 
          "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "0", ",", " ", 
           RowBox[{"3", "*", 
            RowBox[{"(", 
             RowBox[{"1", " ", "-", " ", "l1"}], ")"}]}], ",", " ", 
           RowBox[{"3", "*", "l1"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{"lc", "[", 
        RowBox[{"k_", ",", " ", "i_"}], "]"}], " ", ":=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", "k"}], ")"}], "*", 
         RowBox[{"qqhat", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "  ", "+", "  ", 
        RowBox[{"k", "*", 
         RowBox[{"qqhat", "[", 
          RowBox[{"[", 
           RowBox[{"i", " ", "+", " ", "1"}], "]"}], "]"}]}]}]}], " ", ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"rhs", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", " ", "-", " ", "l1"}], ")"}], "*", "bndrytl"}], " ", 
          "+", " ", 
          RowBox[{"l1", "*", "bndrytr"}], " ", "-", " ", 
          RowBox[{"lc", "[", 
           RowBox[{"m1", ",", " ", "1"}], "]"}], " ", "-", " ", 
          RowBox[{"3", "*", 
           RowBox[{"lc", "[", 
            RowBox[{"m0", ",", " ", "2"}], "]"}]}]}], ",", "\n", "        ", 
         RowBox[{
          RowBox[{"lc", "[", 
           RowBox[{"m0", ",", " ", "3"}], "]"}], " ", "+", " ", 
          RowBox[{"lc", "[", 
           RowBox[{"m1", ",", " ", "2"}], "]"}]}], ",", "\n", "        ", 
         RowBox[{
          RowBox[{"3", "*", 
           RowBox[{"lc", "[", 
            RowBox[{"m1", ",", " ", "3"}], "]"}]}], " ", "-", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", " ", "-", " ", "l0"}], ")"}], "*", "bndrybl"}], 
            " ", "+", " ", 
            RowBox[{"l0", "*", "bndrybr"}], " ", "-", " ", 
            RowBox[{"lc", "[", 
             RowBox[{"m0", ",", " ", "4"}], "]"}]}], ")"}]}]}], "}"}]}], ";", 
      "\n", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Matrix = \>\"", ",", 
          RowBox[{"MatrixForm", "[", "mat", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<rhs = \>\"", ",", 
          RowBox[{"MatrixForm", "[", "rhs", "]"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"approx", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"pp", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
         RowBox[{"rr", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
         RowBox[{"pp", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
         RowBox[{"rr", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], " ", "}"}]}], ";", " ", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"yy", " ", "=", " ", 
       RowBox[{"LeastSquares", "[", 
        RowBox[{
         RowBox[{"mat", ".", 
          RowBox[{"Transpose", "[", "mat", "]"}]}], ",", " ", 
         RowBox[{"rhs", " ", "-", " ", 
          RowBox[{"mat", ".", "approx"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"solution", " ", "=", " ", 
       RowBox[{"approx", " ", "+", " ", 
        RowBox[{
         RowBox[{"Transpose", "[", "mat", "]"}], ".", "yy"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"For", " ", "the", " ", "tri", " ", "patch"}], ",", " ", 
        RowBox[{
        "the", " ", "first", " ", "and", " ", "last", " ", "entries", " ", 
         "should", " ", "be", " ", "deg", " ", "elevated"}]}], " ", "*)"}], 
      "\n", 
      RowBox[{"(*", " ", 
       RowBox[{"But", " ", "these", " ", 
        RowBox[{"aren", "'"}], "t", " ", "used"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"outpp", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"pp", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{"solution", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{"solution", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
         RowBox[{"pp", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], ";", 
      RowBox[{"outrr", " ", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rr", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{"solution", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
         RowBox[{"solution", "[", 
          RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
         RowBox[{"rr", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Leaving inGbot1 pp = \>\"", ",", 
          RowBox[{"MatrixForm", "[", "outpp", "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Leaving inGbot1 rr = \>\"", ",", 
          RowBox[{"MatrixForm", "[", "outrr", "]"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"True", ",", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<Leaving inGbot1 \\npp = \>\"", ",", "outpp", ",", " ", 
           "\"\<\\nqq= \>\"", ",", "qq", ",", "\"\<\\nrr=\>\"", ",", 
           "outrr"}], "]"}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "outpp"}], 
     "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", "   "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1check", "[", 
    RowBox[{"pp_", ",", "qq_", ",", "rr_"}], "]"}], ":=", 
   RowBox[{"Max", "[", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Abs", "[", "\[IndentingNewLine]", 
       RowBox[{"Det", "[", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "t"}], ")"}], "^", "3"}], "*", 
            RowBox[{"rr", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], " ", "\[IndentingNewLine]", 
           "+", " ", 
           RowBox[{"3", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "t"}], ")"}], "^", "2"}], "*", "t", " ", "*", 
            RowBox[{"rr", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t"}], ")"}], "*", 
            RowBox[{"t", "^", "2"}], "*", 
            RowBox[{"rr", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], " ", "+", " ", 
           RowBox[{
            RowBox[{"t", "^", "3"}], "*", 
            RowBox[{"rr", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], "\[IndentingNewLine]", "  ", 
           "-", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "t"}], ")"}], "^", "2"}], "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}], "*", "t", "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{
              RowBox[{"t", "^", "2"}], "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], ",", 
          "\[IndentingNewLine]", "  ", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "t"}], ")"}], "^", "2"}], "*", 
            RowBox[{"qq", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t"}], ")"}], "*", "t", "*", 
            RowBox[{"qq", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], " ", "+", " ", 
           RowBox[{
            RowBox[{"t", "^", "2"}], "*", 
            RowBox[{"qq", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], " ", "-", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "t"}], ")"}], "^", "2"}], "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}], "*", "t", "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{
              RowBox[{"t", "^", "2"}], "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "t"}], ")"}], "^", "3"}], "*", 
            RowBox[{"pp", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], " ", "\[IndentingNewLine]", 
           "+", " ", 
           RowBox[{"3", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "t"}], ")"}], "^", "2"}], "*", "t", " ", "*", 
            RowBox[{"pp", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t"}], ")"}], "*", 
            RowBox[{"t", "^", "2"}], "*", 
            RowBox[{"pp", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], " ", "+", " ", 
           RowBox[{
            RowBox[{"t", "^", "3"}], "*", 
            RowBox[{"pp", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], "-", "\[IndentingNewLine]", 
           "  ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "t"}], ")"}], "^", "2"}], "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}], "*", "t", "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{
              RowBox[{"t", "^", "2"}], "*", 
              RowBox[{"qq", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}]}], 
         "\[IndentingNewLine]", "}"}], "]"}], "\[IndentingNewLine]", "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.512915951655933*^9, {3.512916052247312*^9, 3.5129161229795256`*^9}, {
   3.512916186223547*^9, 3.5129162080797076`*^9}, {3.5129162823688126`*^9, 
   3.5129163193105593`*^9}, {3.51291650354289*^9, 3.512916561529577*^9}, {
   3.51291674146459*^9, 3.5129167653644032`*^9}, {3.5129168070174713`*^9, 
   3.5129168075010834`*^9}, {3.512916941882929*^9, 3.5129169715236893`*^9}, {
   3.512917039853441*^9, 3.5129170487144685`*^9}, {3.5129171626753902`*^9, 
   3.51291721259667*^9}, {3.512923441050785*^9, 3.512923635213217*^9}, {
   3.5129238836807876`*^9, 3.5129239487812567`*^9}, {3.512924014396539*^9, 
   3.512924018093834*^9}, {3.512924354235653*^9, 3.512924549989472*^9}, {
   3.512924646602749*^9, 3.5129246728270216`*^9}, {3.5129247440896487`*^9, 
   3.5129247520458527`*^9}, {3.5129250194211082`*^9, 3.5129250825559273`*^9}, 
   3.512925112805103*^9, 3.51292532681139*^9, {3.5129273977589035`*^9, 
   3.5129274184450336`*^9}, {3.5129275657128096`*^9, 
   3.5129275713913555`*^9}, {3.5129282681520205`*^9, 3.512928415949016*^9}, {
   3.5129284579296923`*^9, 3.512928458491307*^9}, 3.512928504216079*^9, {
   3.5129362089788656`*^9, 3.5129362233624344`*^9}, {3.5129554414160104`*^9, 
   3.512955441603213*^9}, {3.5129556437262845`*^9, 3.512955658624571*^9}, {
   3.512955706252287*^9, 3.51295572147818*^9}, 3.512956140346235*^9, 
   3.5129561772097435`*^9, {3.5129562095335655`*^9, 3.512956210344781*^9}, {
   3.512956243932227*^9, 3.5129562445406384`*^9}, 3.512994146465104*^9, {
   3.513097410249886*^9, 3.513097457183666*^9}, {3.513097507112224*^9, 
   3.5130975417563405`*^9}, {3.5130976353521404`*^9, 
   3.5130978006423235`*^9}, {3.5130978542891855`*^9, 
   3.5130978847867947`*^9}, {3.513097955391489*^9, 3.513097998446937*^9}, {
   3.513098070119622*^9, 3.5130981031443987`*^9}, {3.5130994801909304`*^9, 
   3.51309948465233*^9}, {3.5140306581817636`*^9, 3.5140306641565742`*^9}, {
   3.514030763622349*^9, 3.514030765244752*^9}, {3.5140820933017693`*^9, 
   3.51408209356697*^9}, {3.514082148135866*^9, 3.514082153252675*^9}, {
   3.514082218117589*^9, 3.51408225874006*^9}, {3.514082430589962*^9, 
   3.514082431525964*^9}, {3.5140824695744305`*^9, 3.514082470432432*^9}, 
   3.5140825602261896`*^9, {3.514082703325241*^9, 3.5140827059148455`*^9}, {
   3.5140835891259966`*^9, 3.5140836127288384`*^9}, {3.5140837394322605`*^9, 
   3.5140837540338864`*^9}, {3.5140863765232925`*^9, 3.514086380080099*^9}, {
   3.514086697400256*^9, 3.514086699865061*^9}, {3.514086914802238*^9, 
   3.514086938202279*^9}, {3.5140873463925962`*^9, 3.5140873475781984`*^9}, {
   3.5140877215576553`*^9, 3.514087740433688*^9}, 3.514087822848633*^9, {
   3.5140884124360685`*^9, 3.5140884475985303`*^9}, {3.514088661974107*^9, 
   3.5140886650161123`*^9}, {3.5141759853368845`*^9, 3.514176084599859*^9}, {
   3.5141994608450356`*^9, 3.5141995249611483`*^9}, {3.51419957127763*^9, 
   3.514199601448083*^9}, {3.514200515999689*^9, 3.5142005179184923`*^9}, 
   3.514200773946142*^9, {3.514201547957102*^9, 3.5142015684711375`*^9}, {
   3.514201805903555*^9, 3.514201844170422*^9}, {3.5142018855416946`*^9, 
   3.5142018886149*^9}, {3.5142021932522354`*^9, 3.514202220645883*^9}, {
   3.5142030790793905`*^9, 3.514203085350602*^9}, {3.5142039163952613`*^9, 
   3.5142039221048717`*^9}, {3.51420421728859*^9, 3.5142042198157945`*^9}, {
   3.514204339312004*^9, 3.514204347533219*^9}, {3.514204529959939*^9, 
   3.5142045360907497`*^9}, {3.5142045920324483`*^9, 3.514204615104889*^9}, {
   3.514204653465356*^9, 3.514204654588558*^9}, {3.51420685870483*^9, 
   3.5142068601244326`*^9}, 3.5142069220565414`*^9, {3.5142069621174116`*^9, 
   3.5142069894174595`*^9}, {3.5142590213682823`*^9, 
   3.5142590395579147`*^9}, {3.5142590862487965`*^9, 3.514259092364007*^9}, {
   3.51425931038999*^9, 3.5142593105771904`*^9}, {3.5144571945141277`*^9, 
   3.5144572015965405`*^9}, {3.5144572924042997`*^9, 
   3.5144572990187116`*^9}, {3.5148977429325547`*^9, 3.5148977436813564`*^9}, 
   3.5148984426873837`*^9, 3.5162947529524*^9, 3.516294788224062*^9, {
   3.5163662145036087`*^9, 3.5163662752501154`*^9}, {3.5164043626066093`*^9, 
   3.5164044245387177`*^9}, {3.516453785881099*^9, 3.516453828975766*^9}, {
   3.516453874036395*^9, 3.516453878593088*^9}, {3.516453910428568*^9, 
   3.516454028718472*^9}, {3.516454124213001*^9, 3.516454182924774*^9}, 
   3.516454253065649*^9, 3.516454347941146*^9, {3.516456397410473*^9, 
   3.516456441165949*^9}, {3.5164565195675144`*^9, 3.516456543746585*^9}, {
   3.5164566374842415`*^9, 3.5164566443170853`*^9}, {3.5164770745396857`*^9, 
   3.5164770748672867`*^9}, {3.5165429006280465`*^9, 3.516542904949254*^9}, {
   3.516569946229577*^9, 3.5165699503635845`*^9}, {3.517061599865655*^9, 
   3.5170616125016775`*^9}, {3.51706187595494*^9, 3.5170618784977446`*^9}, {
   3.517063226858514*^9, 3.5170633058570523`*^9}, {3.5170703955172453`*^9, 
   3.5170704004624543`*^9}, {3.517070804565564*^9, 3.517070809323572*^9}, {
   3.5170709467910137`*^9, 3.5170709533742256`*^9}, {3.5174903001413937`*^9, 
   3.5174903063502045`*^9}, {3.517689469472043*^9, 3.517689550950986*^9}, {
   3.5176896882780275`*^9, 3.517689689276429*^9}, {3.5176911672542253`*^9, 
   3.5176911681278267`*^9}, {3.51769130674967*^9, 3.5176913542205534`*^9}, {
   3.51769603778998*^9, 3.5176960656516285`*^9}, {3.517696144790568*^9, 
   3.517696184617438*^9}, 3.5178619807833433`*^9, {3.51793911442764*^9, 
   3.517939118265247*^9}, {3.5179500546319847`*^9, 3.5179500601855946`*^9}, {
   3.518126702807025*^9, 3.5181267059426303`*^9}, {3.5181934467801127`*^9, 
   3.518193517541837*^9}, {3.5181939664014254`*^9, 3.5181939961506777`*^9}, 
   3.518194055711582*^9, {3.5181948614557977`*^9, 3.5181948959942584`*^9}, {
   3.5181952387736607`*^9, 3.518195280550534*^9}, {3.51819558596787*^9, 
   3.518195595593087*^9}, {3.518195701314473*^9, 3.518195763418182*^9}, {
   3.5181958332907047`*^9, 3.518195850450735*^9}, {3.5181963088731403`*^9, 
   3.5181963243951674`*^9}, {3.518196698574624*^9, 3.5181967651555414`*^9}, {
   3.5182107038668222`*^9, 3.5182108966675615`*^9}, 3.5182109278364162`*^9, {
   3.5182111550976152`*^9, 3.518211156532818*^9}, {3.518226414671212*^9, 
   3.5182264685069065`*^9}, 3.518226566506279*^9, {3.5182270818219843`*^9, 
   3.5182270831479864`*^9}, {3.5183055173275814`*^9, 3.518305596731721*^9}, {
   3.5183056308957815`*^9, 3.5183056355601892`*^9}, {3.518305733169561*^9, 
   3.518305733372361*^9}, {3.518305813462902*^9, 3.518305830513732*^9}, {
   3.5183059149566803`*^9, 3.518305932740711*^9}, {3.5183060540621243`*^9, 
   3.5183060672285476`*^9}, {3.518374119957258*^9, 3.518374194026188*^9}, {
   3.5184630245351477`*^9, 3.518463041835578*^9}, {3.5184640491605473`*^9, 
   3.5184640849002104`*^9}, {3.518464154367132*^9, 3.5184641852395864`*^9}, {
   3.5184643274338365`*^9, 3.5184643350310497`*^9}, {3.5184643827983336`*^9, 
   3.518464527519788*^9}, 3.518464564725853*^9, {3.5184645967839093`*^9, 
   3.5184646636924267`*^9}, {3.5184648473515496`*^9, 
   3.5184648671479845`*^9}, {3.5184649458345222`*^9, 3.5184650727563457`*^9}, 
   3.5184651181524253`*^9, {3.51846516655931*^9, 3.5184651748741245`*^9}, {
   3.5184660252940187`*^9, 3.518466110470168*^9}, {3.51846648162602*^9, 
   3.5184666351770897`*^9}, {3.518466731772459*^9, 3.5184667392916727`*^9}, {
   3.518466884496728*^9, 3.518467039046199*^9}, {3.518467425037677*^9, 
   3.5184674283916826`*^9}, {3.5184674629301434`*^9, 
   3.5184674658317485`*^9}, {3.518467510775428*^9, 3.518467533130267*^9}, {
   3.5184675913027687`*^9, 3.5184676673529024`*^9}, {3.518467725244604*^9, 
   3.5184677488942456`*^9}, {3.5184677992823343`*^9, 
   3.5184678204983716`*^9}, {3.5184679378885775`*^9, 
   3.5184679482313957`*^9}, {3.5184681294413137`*^9, 
   3.5184681456029425`*^9}, {3.5184685770997005`*^9, 3.518468582076109*^9}, {
   3.5184686694362626`*^9, 3.5184686894510975`*^9}, {3.518532313692048*^9, 
   3.5185323264996705`*^9}, 3.518532394141389*^9, {3.518532424686243*^9, 
   3.5185324261214457`*^9}, {3.518532477632736*^9, 3.5185325503600636`*^9}, {
   3.51853258803413*^9, 3.5185325989853487`*^9}, {3.5185327420220003`*^9, 
   3.518532792550489*^9}, {3.518533131913485*^9, 3.5185331334578876`*^9}, {
   3.518533359486685*^9, 3.51853340800277*^9}, {3.5185342794671006`*^9, 
   3.5185343437236137`*^9}, {3.518534450349801*^9, 3.518534452237404*^9}, {
   3.5185347894319963`*^9, 3.5185347928016024`*^9}, {3.5185349983319635`*^9, 
   3.518535175891475*^9}, {3.51853936889524*^9, 3.518539384370467*^9}, {
   3.518539456302193*^9, 3.5185395235071115`*^9}, {3.5185395953140373`*^9, 
   3.518539648432131*^9}, {3.518539686230997*^9, 3.518539688415001*^9}, {
   3.5185397236086626`*^9, 3.5185399295758247`*^9}, {3.5185399888403287`*^9, 
   3.5185400116319685`*^9}, {3.518540128897375*^9, 3.5185401710018487`*^9}, {
   3.518540290716459*^9, 3.5185403243969183`*^9}, {3.518540357328576*^9, 
   3.518540357484576*^9}, {3.5185403936142397`*^9, 3.5185406885327578`*^9}, {
   3.5185407505272665`*^9, 3.5185407971245484`*^9}, {3.5185408547042494`*^9, 
   3.5185409356995916`*^9}, {3.5185411497475677`*^9, 
   3.5185411843640285`*^9}, {3.5185412346117167`*^9, 
   3.5185412777457924`*^9}, {3.5185413079786453`*^9, 3.518541369739154*^9}, {
   3.5185454218185916`*^9, 3.518545442301428*^9}, {3.5185454762314873`*^9, 
   3.518545577475665*^9}, {3.518545915494259*^9, 3.518545992807995*^9}, {
   3.518546069482129*^9, 3.518546095970976*^9}, {3.5185461364998474`*^9, 
   3.518546149104669*^9}, {3.5185462282436085`*^9, 3.5185462476500425`*^9}, {
   3.5185463281773834`*^9, 3.518546345119014*^9}, {3.518546381389077*^9, 
   3.518546461776018*^9}, {3.5185465045980935`*^9, 3.5185465768886204`*^9}, {
   3.5185466213330984`*^9, 3.5185466418471346`*^9}, {3.518546672189188*^9, 
   3.518546674513592*^9}, {3.5185467330448947`*^9, 3.5185468535239067`*^9}, {
   3.518546908670003*^9, 3.51854693511205*^9}, {3.5185469810073304`*^9, 
   3.518547088366719*^9}, {3.5185471238255816`*^9, 3.5185472656454306`*^9}, {
   3.5185474352801285`*^9, 3.5185476231824584`*^9}, {3.518547934356205*^9, 
   3.5185479551354413`*^9}, {3.518548042136794*^9, 3.518548065568035*^9}, {
   3.5185481293877473`*^9, 3.518548202583076*^9}, {3.518548298273644*^9, 
   3.5185482998648467`*^9}, {3.5185483807665887`*^9, 3.518548400204223*^9}, 
   3.5185484632907343`*^9, {3.518724518568364*^9, 3.5187245757424645`*^9}, {
   3.5188060821286182`*^9, 3.518806110536268*^9}, {3.5188061478671336`*^9, 
   3.5188061524847417`*^9}, {3.5194053933941135`*^9, 3.519405424328595*^9}, {
   3.5194149954111357`*^9, 3.519415023481499*^9}, {3.5194154307571325`*^9, 
   3.5194154395197325`*^9}, {3.519415964935243*^9, 3.519416163170291*^9}, {
   3.5194162561539955`*^9, 3.5194162678307858`*^9}, {3.519416337831442*^9, 
   3.5194163625970526`*^9}, {3.519416394873464*^9, 3.5194164046875763`*^9}, {
   3.51942342228839*^9, 3.5194234283270736`*^9}, {3.519423807612459*^9, 
   3.519423814482338*^9}, {3.5194246827508464`*^9, 3.5194246920642385`*^9}, {
   3.5194824046979713`*^9, 3.519482443714074*^9}, {3.519482597344984*^9, 
   3.5194825980359783`*^9}, 3.519483956158863*^9, {3.5194884646717863`*^9, 
   3.5194885003631077`*^9}, {3.5194888602105427`*^9, 
   3.5194888618529043`*^9}, {3.5194889751958838`*^9, 3.519488978430535*^9}, {
   3.519498644329415*^9, 3.519498655655701*^9}, {3.5195006228043222`*^9, 
   3.519500631566922*^9}, {3.519996224527811*^9, 3.5199962290362186`*^9}, {
   3.5199987263882074`*^9, 3.5199987850287104`*^9}, {3.519999523930009*^9, 
   3.5199995466904488`*^9}, {3.5199996318041983`*^9, 3.5199997446235967`*^9}, 
   3.5200005962758923`*^9, {3.5200051170293937`*^9, 3.520005162893474*^9}, {
   3.5200052039059463`*^9, 3.5200053215457525`*^9}, {3.5200055949206333`*^9, 
   3.520005727489666*^9}, {3.520005786270569*^9, 3.520005839591463*^9}, {
   3.5200058895895505`*^9, 3.5200060527262373`*^9}, {3.5200079909548435`*^9, 
   3.52000799502645*^9}, 3.5200082616889195`*^9, {3.520008381029129*^9, 
   3.5200084615876703`*^9}, 3.520008506297349*^9, 3.520008578790676*^9, {
   3.5200087837594366`*^9, 3.520008789203846*^9}, {3.5200090345982776`*^9, 
   3.520009039122286*^9}, {3.520018560691025*^9, 3.5200185808618603`*^9}, {
   3.5205146361330776`*^9, 3.5205146481918983`*^9}, {3.520514718470022*^9, 
   3.520514731043644*^9}, {3.5205178347470956`*^9, 3.5205179903729687`*^9}, {
   3.5205180272982335`*^9, 3.520518115282388*^9}, {3.5205184907198477`*^9, 
   3.5205184958834567`*^9}, {3.520518562214773*^9, 3.520518638795308*^9}, 
   3.520687394884876*^9, {3.5209523161526003`*^9, 3.5209523354966345`*^9}, {
   3.52095249237051*^9, 3.520952497003718*^9}, {3.5213204106168313`*^9, 
   3.5213204153904395`*^9}, {3.5214682103264785`*^9, 3.521468222163499*^9}, {
   3.521468260648838*^9, 3.5214682772727423`*^9}, {3.5214683199340863`*^9, 
   3.5214683285564847`*^9}, {3.521468373741458*^9, 3.5214683762150145`*^9}, {
   3.521484310917992*^9, 3.521484331697872*^9}, {3.5214843696123905`*^9, 
   3.521484398323675*^9}, {3.521484437700296*^9, 3.521484450668944*^9}, {
   3.521484583489931*^9, 3.521484602146758*^9}, {3.5214850087614417`*^9, 
   3.5214850237529984`*^9}, {3.5214867933275213`*^9, 
   3.5214867949097967`*^9}, {3.5214869257279043`*^9, 
   3.5214869554506435`*^9}, {3.5214874601864176`*^9, 
   3.5214874654139347`*^9}, {3.521487514554595*^9, 3.5214875688727007`*^9}, {
   3.521487605245002*^9, 3.521487611994707*^9}, {3.521487664490192*^9, 
   3.5214876686061106`*^9}, {3.521487722123064*^9, 3.5214877649346237`*^9}, {
   3.52148779963452*^9, 3.521487859190157*^9}, 3.5214879026826963`*^9, {
   3.521488348694029*^9, 3.5214883543020926`*^9}, {3.521488396883322*^9, 
   3.5214883995371375`*^9}, {3.521488440636235*^9, 3.5214885416214447`*^9}, {
   3.5214887198477216`*^9, 3.521488784630875*^9}, {3.52148897623639*^9, 
   3.5214889865311937`*^9}, {3.521493421768752*^9, 3.521493425323864*^9}, {
   3.521493855021739*^9, 3.5214939071166477`*^9}, {3.5214939673933215`*^9, 
   3.521493975815432*^9}, {3.5214940126083374`*^9, 3.5214940198888063`*^9}, {
   3.5214940664557667`*^9, 3.5214940701210365`*^9}, {3.5215510169723616`*^9, 
   3.521551044291645*^9}, {3.5215511728464975`*^9, 3.5215511765117683`*^9}, {
   3.521551295082264*^9, 3.5215513095030003`*^9}, {3.521551340367381*^9, 
   3.5215513923220882`*^9}, {3.5215514294554834`*^9, 
   3.5215514652569633`*^9}, {3.5215515193447375`*^9, 
   3.5215516727453165`*^9}, {3.521569695160277*^9, 3.5215697320533266`*^9}, {
   3.5215698166349487`*^9, 3.521569837114397*^9}, {3.5215705834075136`*^9, 
   3.5215706083033123`*^9}, {3.521571016440184*^9, 3.5215710198651085`*^9}, {
   3.5215710726309824`*^9, 3.521571075525144*^9}, {3.521571253280744*^9, 
   3.5215712696643023`*^9}, {3.521572762220493*^9, 3.5215727663364115`*^9}, {
   3.521572801777373*^9, 3.5215728096687202`*^9}, {3.521576094502078*^9, 
   3.521576106579445*^9}, {3.5215761579533167`*^9, 3.5215761871152496`*^9}, {
   3.5215762403017282`*^9, 3.5215762478726144`*^9}, {3.52157630118928*^9, 
   3.521576314278101*^9}, {3.5215764697917185`*^9, 3.5215764704025965`*^9}, {
   3.5215766899583025`*^9, 3.521576694554912*^9}, {3.5215768185431986`*^9, 
   3.521576843519112*^9}, {3.521576881894293*^9, 3.521576884457979*^9}, {
   3.5215769726047277`*^9, 3.5215769812371407`*^9}, {3.5215770234578514`*^9, 
   3.5215770671006064`*^9}, {3.521577113327077*^9, 3.521577159543533*^9}, {
   3.521577389023509*^9, 3.5215773980364685`*^9}, 3.5215774465061646`*^9, {
   3.521577479713915*^9, 3.521577482758293*^9}, 3.5215775476916623`*^9, {
   3.521577694823227*^9, 3.5215777023039837`*^9}, {3.521577777361912*^9, 
   3.5215777825794144`*^9}, {3.521580058421915*^9, 3.5215800659126863`*^9}, {
   3.5215801645044546`*^9, 3.5215801714444337`*^9}, {3.521586552810387*^9, 
   3.5215865851669135`*^9}, {3.5216393537220592`*^9, 
   3.5216393580082226`*^9}, {3.5217285842279425`*^9, 
   3.5217286216116977`*^9}, {3.5217286604875984`*^9, 3.521728980738096*^9}, {
   3.521729017010253*^9, 3.521729071448531*^9}, 3.521729153186064*^9, {
   3.521737371192978*^9, 3.521737398392088*^9}, {3.5217378454248896`*^9, 
   3.521737848469267*^9}, {3.5217381518154573`*^9, 3.521738158685336*^9}, {
   3.5217449446330495`*^9, 3.521745133244259*^9}, {3.521745186811285*^9, 
   3.521745222552678*^9}, {3.521746184375712*^9, 3.521746201249976*^9}, {
   3.521811388939954*^9, 3.5218114157084446`*^9}, {3.521811576199219*^9, 
   3.521811597429747*^9}, {3.521925117178048*^9, 3.521925253624248*^9}, {
   3.52192566977264*^9, 3.521925672957219*^9}, {3.5219841829995985`*^9, 
   3.521984190640586*^9}, {3.5219842458599873`*^9, 3.521984292767437*^9}, 
   3.52198448723707*^9, {3.5219845401231165`*^9, 3.521984542957192*^9}, {
   3.5219850905145407`*^9, 3.521985090875059*^9}, {3.521985384347051*^9, 
   3.521985402593288*^9}, {3.521985629699851*^9, 3.5219856679348307`*^9}, {
   3.521985893088586*^9, 3.5219859755771985`*^9}, {3.52198603430164*^9, 
   3.521986077513776*^9}, {3.5219866190925283`*^9, 3.5219866726795826`*^9}, {
   3.521988060775566*^9, 3.5219881731872063`*^9}, {3.521992733084016*^9, 
   3.521992748386019*^9}, {3.5219928798851056`*^9, 3.521993204461824*^9}, {
   3.5219937219259005`*^9, 3.5219937908550158`*^9}, {3.52200547325348*^9, 
   3.5220056837761965`*^9}, {3.5220057303832145`*^9, 
   3.5220057721332483`*^9}, {3.5220060136204896`*^9, 
   3.5220063177978754`*^9}, {3.522006357695245*^9, 3.5220065248055377`*^9}, {
   3.5220066450584526`*^9, 3.522006654301744*^9}, {3.5220068243863134`*^9, 
   3.522007222919376*^9}, {3.522007404911067*^9, 3.5220074106292896`*^9}, {
   3.522007461752802*^9, 3.522007578630864*^9}, {3.5220076108371744`*^9, 
   3.522007724390456*^9}, {3.5220077674724045`*^9, 3.5220078300824337`*^9}, {
   3.522007875778141*^9, 3.5220081606077056`*^9}, {3.522009550175806*^9, 
   3.5220096156699824`*^9}, {3.5220700284810624`*^9, 3.522070037063403*^9}, {
   3.5220701878301954`*^9, 3.522070194860304*^9}, {3.5220705390452175`*^9, 
   3.522070546465888*^9}, {3.522070658076376*^9, 3.522070665106485*^9}, {
   3.522091804603589*^9, 3.5220918247225184`*^9}, {3.5222596565466843`*^9, 
   3.522259661585493*^9}, {3.5227087746502237`*^9, 3.5227088339755297`*^9}, {
   3.5244217794352016`*^9, 3.524421780396584*^9}, {3.5247504644346237`*^9, 
   3.5247505639176736`*^9}, {3.524750958374875*^9, 3.5247509630315714`*^9}, {
   3.524751052239846*^9, 3.524751067631979*^9}, {3.6299950211779737`*^9, 
   3.62999503649553*^9}, {3.629995245352996*^9, 3.6299952919852*^9}, {
   3.6299953493131866`*^9, 3.629995367857172*^9}, {3.629995451996108*^9, 
   3.629995525634138*^9}},
 FontSize->16]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "\n",
 StyleBox["Data Structure Related Functions",
  FontSize->24],
 "\n"
}], "Section",
 CellChangeTimes->{{3.5185484716679487`*^9, 3.518548484943572*^9}, {
  3.5244217391973424`*^9, 3.5244217577239823`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"===", "===", "===", "===", "===", 
    RowBox[{"Rectangle", " ", 
     RowBox[{"patch", ":", " ", 
      RowBox[{
       RowBox[{
       "Load", " ", "Default", " ", "bb1", " ", "and", " ", "cc", " ", "data",
         " ", "code"}], "===", "===", "===", "===", "===", "===", "===", "===",
        "==="}]}]}]}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Input", ":", 
     RowBox[{"global", " ", "data"}]}], ",", 
    RowBox[{"global", " ", "normals"}], ",", 
    RowBox[{"and", " ", "faces", " ", "info"}], ",", " ", 
    RowBox[{"global", " ", "current", " ", "iface", "\[IndentingNewLine]", 
     RowBox[{"Output", ":", 
      RowBox[{"global", " ", "bb1"}]}]}], ",", 
    RowBox[{"cc", " ", "\[IndentingNewLine]", "Module"}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"loadbb1patch", "[", "iface_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<loadbb1patch: iface = \>\"", ",", "iface"}], "]"}], ";"}],
      " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Load", " ", "the", " ", "boundaries"}], " ", "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", " ", "=", " ", 
      RowBox[{"boundary", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "=", " ", 
        RowBox[{"temp", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"temp", " ", "=", " ", 
      RowBox[{"boundary", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "4"}], "]"}], "]"}], " ", "=", " ", 
        RowBox[{"temp", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"temp", " ", "=", " ", 
      RowBox[{"boundary", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "i"}], "]"}], "]"}], " ", "=", " ", 
        RowBox[{"temp", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"temp", " ", "=", " ", 
      RowBox[{"boundary", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"faces", "[", 
           RowBox[{"[", "iface", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "i"}], "]"}], "]"}], " ", "=", " ", 
        RowBox[{"temp", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Load", " ", "interior", " ", "data"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"interiorrow", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "2"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bndry", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newrow", " ", "=", " ", 
      RowBox[{"guessleft", "[", 
       RowBox[{"interiorrow", ",", " ", "bndry"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"bb1", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"bb1", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"interiorrow", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "3"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bndry", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", " ", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newrow", " ", "=", " ", 
      RowBox[{"guessleft", "[", 
       RowBox[{"interiorrow", ",", " ", "bndry"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"bb1", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "3"}], "]"}], "]"}], " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"bb1", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "3"}], "]"}], "]"}], " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"interiorrow", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bndry", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newrow", " ", "=", " ", 
      RowBox[{"guessleft", "[", 
       RowBox[{"interiorrow", ",", " ", "bndry"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cc22", " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cc23", " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"interiorrow", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"3", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bndry", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", 
        RowBox[{"bb1", "[", 
         RowBox[{"[", 
          RowBox[{"4", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"newrow", " ", "=", " ", 
      RowBox[{"guessleft", "[", 
       RowBox[{"interiorrow", ",", " ", "bndry"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cc32", " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cc33", " ", "=", " ", 
      RowBox[{"newrow", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<loadbb1patch: loaded boundaries and interior guesses = \>\"", ",", 
        RowBox[{"MatrixForm", "[", "bb1", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<  cc22=\>\"", ",", "cc22", ",", "\"\< cc23=\>\"", ",", "cc23", 
        ",", "\"\<  cc32=\>\"", ",", "cc32", ",", "\"\<  cc33=\>\"", ",", 
        "cc33"}], "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
    "\[IndentingNewLine]", ")"}]}]}]], "Input",
 CellChangeTimes->{
  3.512915951655933*^9, {3.512916052247312*^9, 3.5129161229795256`*^9}, {
   3.512916186223547*^9, 3.5129162080797076`*^9}, {3.5129162823688126`*^9, 
   3.5129163193105593`*^9}, {3.51291650354289*^9, 3.512916561529577*^9}, {
   3.51291674146459*^9, 3.5129167653644032`*^9}, {3.5129168070174713`*^9, 
   3.5129168075010834`*^9}, {3.512916941882929*^9, 3.5129169715236893`*^9}, {
   3.512917039853441*^9, 3.5129170487144685`*^9}, {3.5129171626753902`*^9, 
   3.51291721259667*^9}, {3.512923441050785*^9, 3.512923635213217*^9}, {
   3.5129238836807876`*^9, 3.5129239487812567`*^9}, {3.512924014396539*^9, 
   3.512924018093834*^9}, {3.512924354235653*^9, 3.512924549989472*^9}, {
   3.512924646602749*^9, 3.5129246728270216`*^9}, {3.5129247440896487`*^9, 
   3.5129247520458527`*^9}, {3.5129250194211082`*^9, 3.5129250825559273`*^9}, 
   3.512925112805103*^9, 3.51292532681139*^9, {3.5129273977589035`*^9, 
   3.5129274184450336`*^9}, {3.5129275657128096`*^9, 
   3.5129275713913555`*^9}, {3.5129282681520205`*^9, 3.512928415949016*^9}, {
   3.5129284579296923`*^9, 3.512928458491307*^9}, 3.512928504216079*^9, {
   3.5129362089788656`*^9, 3.5129362233624344`*^9}, {3.5129554414160104`*^9, 
   3.512955441603213*^9}, {3.5129556437262845`*^9, 3.512955658624571*^9}, {
   3.512955706252287*^9, 3.51295572147818*^9}, 3.512956140346235*^9, 
   3.5129561772097435`*^9, {3.5129562095335655`*^9, 3.512956210344781*^9}, {
   3.512956243932227*^9, 3.5129562445406384`*^9}, 3.512994146465104*^9, {
   3.513097410249886*^9, 3.513097457183666*^9}, {3.513097507112224*^9, 
   3.5130975417563405`*^9}, {3.5130976353521404`*^9, 
   3.5130978006423235`*^9}, {3.5130978542891855`*^9, 
   3.5130978847867947`*^9}, {3.513097955391489*^9, 3.513097998446937*^9}, {
   3.513098070119622*^9, 3.5130981031443987`*^9}, {3.5130994801909304`*^9, 
   3.51309948465233*^9}, {3.5140306581817636`*^9, 3.5140306641565742`*^9}, {
   3.514030763622349*^9, 3.514030765244752*^9}, {3.5140820933017693`*^9, 
   3.51408209356697*^9}, {3.514082148135866*^9, 3.514082153252675*^9}, {
   3.514082218117589*^9, 3.51408225874006*^9}, {3.514082430589962*^9, 
   3.514082431525964*^9}, {3.5140824695744305`*^9, 3.514082470432432*^9}, 
   3.5140825602261896`*^9, {3.514082703325241*^9, 3.5140827059148455`*^9}, {
   3.5140835891259966`*^9, 3.5140836127288384`*^9}, {3.5140837394322605`*^9, 
   3.5140837540338864`*^9}, {3.5140863765232925`*^9, 3.514086380080099*^9}, {
   3.514086697400256*^9, 3.514086699865061*^9}, {3.514086914802238*^9, 
   3.514086938202279*^9}, {3.5140873463925962`*^9, 3.5140873475781984`*^9}, {
   3.5140877215576553`*^9, 3.514087740433688*^9}, 3.514087822848633*^9, {
   3.5140884124360685`*^9, 3.5140884475985303`*^9}, {3.514088661974107*^9, 
   3.5140886650161123`*^9}, {3.5141759853368845`*^9, 3.514176084599859*^9}, {
   3.5141994608450356`*^9, 3.5141995249611483`*^9}, {3.51419957127763*^9, 
   3.514199601448083*^9}, {3.514200515999689*^9, 3.5142005179184923`*^9}, 
   3.514200773946142*^9, {3.514201547957102*^9, 3.5142015684711375`*^9}, {
   3.514201805903555*^9, 3.514201844170422*^9}, {3.5142018855416946`*^9, 
   3.5142018886149*^9}, {3.5142021932522354`*^9, 3.514202220645883*^9}, {
   3.5142030790793905`*^9, 3.514203085350602*^9}, {3.5142039163952613`*^9, 
   3.5142039221048717`*^9}, {3.51420421728859*^9, 3.5142042198157945`*^9}, {
   3.514204339312004*^9, 3.514204347533219*^9}, {3.514204529959939*^9, 
   3.5142045360907497`*^9}, {3.5142045920324483`*^9, 3.514204615104889*^9}, {
   3.514204653465356*^9, 3.514204654588558*^9}, {3.51420685870483*^9, 
   3.5142068601244326`*^9}, 3.5142069220565414`*^9, {3.5142069621174116`*^9, 
   3.5142069894174595`*^9}, {3.5142590213682823`*^9, 
   3.5142590395579147`*^9}, {3.5142590862487965`*^9, 3.514259092364007*^9}, {
   3.51425931038999*^9, 3.5142593105771904`*^9}, {3.5144571945141277`*^9, 
   3.5144572015965405`*^9}, {3.5144572924042997`*^9, 
   3.5144572990187116`*^9}, {3.5148977429325547`*^9, 3.5148977436813564`*^9}, 
   3.5148984426873837`*^9, 3.5162947529524*^9, 3.516294788224062*^9, {
   3.5163662145036087`*^9, 3.5163662752501154`*^9}, {3.5164043626066093`*^9, 
   3.5164044245387177`*^9}, {3.516453785881099*^9, 3.516453828975766*^9}, {
   3.516453874036395*^9, 3.516453878593088*^9}, {3.516453910428568*^9, 
   3.516454028718472*^9}, {3.516454124213001*^9, 3.516454182924774*^9}, 
   3.516454253065649*^9, 3.516454347941146*^9, {3.516456397410473*^9, 
   3.516456441165949*^9}, {3.5164565195675144`*^9, 3.516456543746585*^9}, {
   3.5164566374842415`*^9, 3.5164566443170853`*^9}, {3.5164770745396857`*^9, 
   3.5164770748672867`*^9}, {3.5165429006280465`*^9, 3.516542904949254*^9}, {
   3.516569946229577*^9, 3.5165699503635845`*^9}, {3.517061599865655*^9, 
   3.5170616125016775`*^9}, {3.51706187595494*^9, 3.5170618784977446`*^9}, {
   3.517063226858514*^9, 3.5170633058570523`*^9}, {3.5170703955172453`*^9, 
   3.5170704004624543`*^9}, {3.517070804565564*^9, 3.517070809323572*^9}, {
   3.5170709467910137`*^9, 3.5170709533742256`*^9}, {3.5174903001413937`*^9, 
   3.5174903063502045`*^9}, {3.517689469472043*^9, 3.517689550950986*^9}, {
   3.5176896882780275`*^9, 3.517689689276429*^9}, {3.5176911672542253`*^9, 
   3.5176911681278267`*^9}, {3.51769130674967*^9, 3.5176913542205534`*^9}, {
   3.51769603778998*^9, 3.5176960656516285`*^9}, {3.517696144790568*^9, 
   3.517696184617438*^9}, 3.5178619807833433`*^9, {3.51793911442764*^9, 
   3.517939118265247*^9}, {3.5179500546319847`*^9, 3.5179500601855946`*^9}, {
   3.518126702807025*^9, 3.5181267059426303`*^9}, {3.5181934467801127`*^9, 
   3.518193517541837*^9}, {3.5181939664014254`*^9, 3.5181939961506777`*^9}, 
   3.518194055711582*^9, {3.5181948614557977`*^9, 3.5181948959942584`*^9}, {
   3.5181952387736607`*^9, 3.518195280550534*^9}, {3.51819558596787*^9, 
   3.518195595593087*^9}, {3.518195701314473*^9, 3.518195763418182*^9}, {
   3.5181958332907047`*^9, 3.518195850450735*^9}, {3.5181963088731403`*^9, 
   3.5181963243951674`*^9}, {3.518196698574624*^9, 3.5181967651555414`*^9}, {
   3.5182107038668222`*^9, 3.5182108966675615`*^9}, 3.5182109278364162`*^9, {
   3.5182111550976152`*^9, 3.518211156532818*^9}, {3.518226414671212*^9, 
   3.5182264685069065`*^9}, 3.518226566506279*^9, {3.5182270818219843`*^9, 
   3.5182270831479864`*^9}, {3.5183055173275814`*^9, 3.518305596731721*^9}, {
   3.5183056308957815`*^9, 3.5183056355601892`*^9}, {3.518305733169561*^9, 
   3.518305733372361*^9}, {3.518305813462902*^9, 3.518305830513732*^9}, {
   3.5183059149566803`*^9, 3.518305932740711*^9}, {3.5183060540621243`*^9, 
   3.5183060672285476`*^9}, {3.518374119957258*^9, 3.518374194026188*^9}, {
   3.5184630245351477`*^9, 3.518463041835578*^9}, {3.5184640491605473`*^9, 
   3.5184640849002104`*^9}, {3.518464154367132*^9, 3.5184641852395864`*^9}, {
   3.5184643274338365`*^9, 3.5184643350310497`*^9}, {3.5184643827983336`*^9, 
   3.518464527519788*^9}, 3.518464564725853*^9, {3.5184645967839093`*^9, 
   3.5184646636924267`*^9}, {3.5184648473515496`*^9, 
   3.5184648671479845`*^9}, {3.5184649458345222`*^9, 3.5184650727563457`*^9}, 
   3.5184651181524253`*^9, {3.51846516655931*^9, 3.5184651748741245`*^9}, {
   3.5184660252940187`*^9, 3.518466110470168*^9}, {3.51846648162602*^9, 
   3.5184666351770897`*^9}, {3.518466731772459*^9, 3.5184667392916727`*^9}, {
   3.518466884496728*^9, 3.518467039046199*^9}, {3.518467425037677*^9, 
   3.5184674283916826`*^9}, {3.5184674629301434`*^9, 
   3.5184674658317485`*^9}, {3.518467510775428*^9, 3.518467533130267*^9}, {
   3.5184675913027687`*^9, 3.5184676673529024`*^9}, {3.518467725244604*^9, 
   3.5184677488942456`*^9}, {3.5184677992823343`*^9, 
   3.5184678204983716`*^9}, {3.5184679378885775`*^9, 
   3.5184679482313957`*^9}, {3.5184681294413137`*^9, 
   3.5184681456029425`*^9}, {3.5184685770997005`*^9, 3.518468582076109*^9}, {
   3.5184686694362626`*^9, 3.5184686894510975`*^9}, {3.518532313692048*^9, 
   3.5185323264996705`*^9}, 3.518532394141389*^9, {3.518532424686243*^9, 
   3.5185324261214457`*^9}, {3.518532477632736*^9, 3.5185325503600636`*^9}, {
   3.51853258803413*^9, 3.5185325989853487`*^9}, {3.5185327420220003`*^9, 
   3.518532792550489*^9}, {3.518533131913485*^9, 3.5185331334578876`*^9}, {
   3.518533359486685*^9, 3.51853340800277*^9}, {3.5185342794671006`*^9, 
   3.5185343437236137`*^9}, {3.518534450349801*^9, 3.518534452237404*^9}, {
   3.5185347894319963`*^9, 3.5185347928016024`*^9}, {3.5185349983319635`*^9, 
   3.518535175891475*^9}, {3.51853936889524*^9, 3.518539384370467*^9}, {
   3.518539456302193*^9, 3.5185395235071115`*^9}, {3.5185395953140373`*^9, 
   3.518539648432131*^9}, {3.518539686230997*^9, 3.518539688415001*^9}, {
   3.5185397236086626`*^9, 3.5185399295758247`*^9}, {3.5185399888403287`*^9, 
   3.5185400116319685`*^9}, {3.518540128897375*^9, 3.5185401710018487`*^9}, {
   3.518540290716459*^9, 3.5185403243969183`*^9}, {3.518540357328576*^9, 
   3.518540357484576*^9}, {3.5185403936142397`*^9, 3.5185406885327578`*^9}, {
   3.5185407505272665`*^9, 3.5185407971245484`*^9}, {3.5185408547042494`*^9, 
   3.5185409356995916`*^9}, {3.5185411497475677`*^9, 
   3.5185411843640285`*^9}, {3.5185412346117167`*^9, 
   3.5185412777457924`*^9}, {3.5185413079786453`*^9, 3.518541369739154*^9}, {
   3.5185454218185916`*^9, 3.518545442301428*^9}, {3.5185454762314873`*^9, 
   3.518545577475665*^9}, {3.518545915494259*^9, 3.518545992807995*^9}, {
   3.518546069482129*^9, 3.518546095970976*^9}, {3.5185461364998474`*^9, 
   3.518546149104669*^9}, {3.5185462282436085`*^9, 3.5185462476500425`*^9}, {
   3.5185463281773834`*^9, 3.518546345119014*^9}, {3.518546381389077*^9, 
   3.518546461776018*^9}, {3.5185465045980935`*^9, 3.5185465768886204`*^9}, {
   3.5185466213330984`*^9, 3.5185466418471346`*^9}, {3.518546672189188*^9, 
   3.518546674513592*^9}, {3.5185467330448947`*^9, 3.5185468535239067`*^9}, {
   3.518546908670003*^9, 3.51854693511205*^9}, {3.5185469810073304`*^9, 
   3.518547088366719*^9}, {3.5185471238255816`*^9, 3.5185472656454306`*^9}, {
   3.5185474352801285`*^9, 3.5185476231824584`*^9}, {3.518547934356205*^9, 
   3.5185479551354413`*^9}, {3.518548042136794*^9, 3.518548065568035*^9}, {
   3.5185481293877473`*^9, 3.518548202583076*^9}, {3.518548298273644*^9, 
   3.5185482998648467`*^9}, {3.5185483807665887`*^9, 3.518548400204223*^9}, 
   3.5185484632907343`*^9, 3.518548563068509*^9, {3.518549799963482*^9, 
   3.5185498186211147`*^9}, {3.5185510773873253`*^9, 
   3.5185511035953712`*^9}, {3.518551242784816*^9, 3.5185512470904236`*^9}, {
   3.518551332703374*^9, 3.518551349910204*^9}, {3.5187089396841993`*^9, 
   3.518709148615367*^9}, {3.518709238814725*^9, 3.5187092618091655`*^9}, {
   3.5187094168266373`*^9, 3.51870946382952*^9}, {3.518709555214481*^9, 
   3.518709615664587*^9}, {3.5187245887528877`*^9, 3.5187246441641846`*^9}, {
   3.518813230319579*^9, 3.5188132455920057`*^9}, {3.51881328225207*^9, 
   3.51881333927017*^9}, {3.5188133702986245`*^9, 3.51881350995007*^9}, {
   3.5188137470448866`*^9, 3.518813768323324*^9}, {3.5188138015981827`*^9, 
   3.518813804125387*^9}, {3.518813857555481*^9, 3.518813865963896*^9}, {
   3.5188138988175535`*^9, 3.5188139022183595`*^9}, {3.5188139529808483`*^9, 
   3.518814005474941*^9}, 3.5189015876199675`*^9, {3.5189796717268934`*^9, 
   3.5189796760917015`*^9}, {3.5189797383730106`*^9, 3.518979871784445*^9}, {
   3.5189810717669525`*^9, 3.518981090611786*^9}, {3.519398689864912*^9, 
   3.519398694331334*^9}, {3.5194263465833197`*^9, 3.5194265044202785`*^9}, {
   3.521586064948877*^9, 3.5215860676227217`*^9}, {3.521586175988544*^9, 
   3.5215861790829935`*^9}, {3.5215862420935984`*^9, 3.521586244537112*^9}, 
   3.5215863298598003`*^9, {3.521586393531355*^9, 3.521586410345533*^9}},
 FontSize->16],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  StyleBox["\[IndentingNewLine]",
   FontSize->16], 
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Triangle", " ", 
      RowBox[{"patch", ":", " ", 
       RowBox[{"Load", " ", "Default", " ", "bb1"}]}]}], ",", " ", 
     RowBox[{"tt1", " ", "and", " ", "dd", " ", "data", " ", "code"}]}], " ", 
    "*)"}],
   FontSize->16], 
  StyleBox["\[IndentingNewLine]",
   FontSize->16], 
  StyleBox["\[IndentingNewLine]",
   FontSize->16], 
  StyleBox[
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Input", ":", 
      RowBox[{"global", " ", "data"}]}], ",", 
     RowBox[{"global", " ", "normals"}], ",", 
     RowBox[{"and", " ", "faces", " ", "info"}], ",", " ", 
     RowBox[{"global", " ", "current", " ", "iface", "\[IndentingNewLine]", 
      RowBox[{"Output", ":", 
       RowBox[{"global", " ", "bb1"}]}]}], ",", "tt1", ",", 
     RowBox[{"dd", "\[IndentingNewLine]", "Module"}]}], "\[IndentingNewLine]",
     "*)"}],
   FontSize->16], 
  StyleBox["\[IndentingNewLine]",
   FontSize->16], 
  StyleBox[
   RowBox[{
    RowBox[{"loadpatchtricase", "[", "iface_", "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<loadpatchtricase: iface = \>\"", ",", "iface"}], "]"}], 
       ";"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Load", " ", "the", " ", "boundaries"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tedge1", " ", "=", " ", 
       RowBox[{"boundary", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"faces", "[", 
            RowBox[{"[", "iface", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"faces", "[", 
            RowBox[{"[", "iface", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"tedge2", " ", "=", " ", 
       RowBox[{"boundary", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"faces", "[", 
            RowBox[{"[", "iface", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"faces", "[", 
            RowBox[{"[", "iface", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"tedge3", " ", "=", " ", 
       RowBox[{"boundary", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"faces", "[", 
            RowBox[{"[", "iface", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"faces", "[", 
            RowBox[{"[", "iface", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Load", " ", "interior", " ", "data"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"interiorrow", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"tedge3", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"tedge2", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bndry", " ", "=", " ", "tedge1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"newrow", " ", "=", " ", 
       RowBox[{"guesstri", "[", 
        RowBox[{"interiorrow", ",", " ", "bndry"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tt1", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"newrow", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tt1", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"newrow", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"interiorrow", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"tedge2", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"tedge1", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bndry", " ", "=", " ", "tedge3"}], ";", "\[IndentingNewLine]", 
      RowBox[{"newrow", " ", "=", " ", 
       RowBox[{"guesstri", "[", 
        RowBox[{"interiorrow", ",", " ", "bndry"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dd23", " ", "=", " ", 
       RowBox[{"newrow", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dd22", " ", "=", " ", 
       RowBox[{"newrow", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"interiorrow", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"tedge1", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"tedge3", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bndry", " ", "=", " ", "tedge2"}], ";", "\[IndentingNewLine]", 
      RowBox[{"newrow", " ", "=", " ", 
       RowBox[{"guesstri", "[", 
        RowBox[{"interiorrow", ",", " ", "bndry"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dd32", " ", "=", " ", 
       RowBox[{"newrow", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tt1", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "3"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"newrow", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"deg4curve", " ", "=", " ", 
       RowBox[{"elevate", "[", "tedge1", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "=", " ", 
         RowBox[{"deg4curve", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"deg4curve", " ", "=", " ", 
       RowBox[{"elevate", "[", "tedge2", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tt1", "[", 
        RowBox[{"[", 
         RowBox[{"4", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"deg4curve", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tt1", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "3"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"deg4curve", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tt1", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "4"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"deg4curve", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"deg4curve", " ", "=", " ", 
       RowBox[{"elevate", "[", "tedge3", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", " ", 
            RowBox[{"6", "-", "i"}]}], "]"}], "]"}], " ", "=", " ", 
         RowBox[{"deg4curve", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}],
   FontSize->16]}]], "Input",
 CellChangeTimes->{{3.519398713298608*^9, 3.519398737152909*^9}, {
   3.519398783299264*^9, 3.5193988118503184`*^9}, {3.519398892576397*^9, 
   3.519398897042819*^9}, {3.519399111431094*^9, 3.5193991389005938`*^9}, {
   3.519399222410675*^9, 3.519399303497272*^9}, {3.519399349583541*^9, 
   3.5193997182636766`*^9}, {3.5194062757028112`*^9, 
   3.5194062964927053`*^9}, {3.519410097638485*^9, 3.5194102356970034`*^9}, {
   3.519410310875104*^9, 3.5194104671097584`*^9}, {3.5194112570656595`*^9, 
   3.519411272477821*^9}, {3.519411378009568*^9, 3.5194114183776145`*^9}, {
   3.5194115756036944`*^9, 3.519411614579739*^9}, {3.519411799065016*^9, 
   3.5194118569582624`*^9}, {3.519413190846299*^9, 3.5194131909965153`*^9}, {
   3.519414371734333*^9, 3.5194144544933343`*^9}, 3.5194144881717615`*^9, {
   3.519414530742976*^9, 3.5194145324854813`*^9}, {3.5194150464244895`*^9, 
   3.5194150529338493`*^9}, {3.5194219465163345`*^9, 3.519421972273371*^9}, {
   3.5194265412332125`*^9, 3.519426588250821*^9}, {3.519426819313072*^9, 
   3.5194268348854637`*^9}, {3.5194268938402367`*^9, 3.519426988876893*^9}, {
   3.5194795841722546`*^9, 3.5194796072955046`*^9}, {3.5194797177743654`*^9, 
   3.5194797305527396`*^9}, {3.5194915501885414`*^9, 
   3.5194915621958065`*^9}, {3.5244218142552705`*^9, 3.5244218429765697`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
     "===", "==="}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"-", "Rectangular"}]}]}]}]}]}]}]}]}], " ", "Patch", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Rules", "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
        "--"}], "--"}], "--"}], "--"}]}], "*)"}], 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Rectangular", " ", "patch", " ", "should", " ", "be", " ", "in", " ", 
     "ccw", " ", 
     RowBox[{"order", ".", " ", "Vertices"}], " ", "v1"}], ",", "v2", ",", 
    "v3", ",", 
    RowBox[{
    "v4", "\[IndentingNewLine]", "\[IndentingNewLine]", "v1", " ", "to", " ", 
     RowBox[{"v2", "--"}], " ", "called", " ", 
     RowBox[{"E1", "--"}], " ", "has", " ", "Bezier", " ", "points", " ", 
     "11"}], ",", "12", ",", "13", ",", 
    RowBox[{"14", "\[IndentingNewLine]", "v1", " ", "to", " ", 
     RowBox[{"v4", "--"}], " ", "called", " ", 
     RowBox[{"E4", "--"}], " ", "has", " ", "Bezier", " ", "points", " ", 
     "11"}], ",", "21", ",", "31", ",", 
    RowBox[{"41", "\[IndentingNewLine]", "Gregory", " ", "points", " ", 
     RowBox[{"definition", "/", 
      RowBox[{"convention", ":", "\[IndentingNewLine]", 
       RowBox[{
       "Working", " ", "across", " ", "E1", " ", "and", " ", "E3", " ", 
        "load", " ", "Gregory", " ", "points", " ", "into", " ", "cc", " ", 
        RowBox[{"points", ".", "\[IndentingNewLine]", "Working"}], " ", 
        "across", " ", "E2", " ", "and", " ", "E4", " ", "load", " ", 
        "Gregory", " ", "points", " ", "into", " ", "bb1", " ", 
        "positions"}]}]}]}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"===", "===", "===", "===", "===", 
    RowBox[{"Load", " ", "G1", " ", "Input", " ", "code"}], "===", "===", "===",
     "===", "===", "===", "===", "===", "==="}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Input", ":", 
     RowBox[{"global", " ", "faces"}]}], ",", "inbr", ",", "iedge", ",", 
    "bb1", ",", 
    RowBox[{"nbrverts", " ", "\[IndentingNewLine]", 
     RowBox[{"Output", ":", "q"}]}], ",", "topl", ",", "topr", ",", "botl", 
    ",", " ", 
    RowBox[{
     RowBox[{
     "botr", " ", "\[IndentingNewLine]", "inbr", " ", "is", " ", "the", " ", 
      "patch", " ", "neighboring", " ", "the", " ", "current", " ", 
      RowBox[{"patch", "'"}], "s", " ", "iedge", " ", "bb1", " ", "should", 
      " ", "have", " ", "correct", " ", "boundary", " ", "information", " ", 
      "loaded", " ", "nbrverts", " ", "take", " ", "values", " ", "1", " ", 
      "to", " ", "4"}], ":", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"nbrvert", "[", 
        RowBox[{"[", "2", "]"}], "]"}], " ", "has", " ", "the", " ", "face", 
       " ", "index", " ", "for", " ", "the", " ", "neighboring", " ", "patch",
        " ", "that", " ", "is", " ", "at", " ", "the", " ", "start", " ", 
       "of", " ", "q", " ", "\[IndentingNewLine]", 
       RowBox[{"nbrvert", "[", 
        RowBox[{"[", "3", "]"}], "]"}], " ", "is", " ", "at", " ", "the", " ",
        "end", " ", "of", " ", "q", " ", "\[IndentingNewLine]", 
       RowBox[{"nbrvert", "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "is", " ", 
       RowBox[{"nbrvert", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "-", 
      RowBox[{"1", " ", "mod", " ", "4", " ", "\[IndentingNewLine]", 
       RowBox[{"nbrvert", "[", 
        RowBox[{"[", "4", "]"}], "]"}], " ", "is", " ", 
       RowBox[{"nbrvert", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "+", 
      RowBox[{"1", " ", "mod", " ", "4"}]}]}]}], "\[IndentingNewLine]", 
   "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.512915951655933*^9, {3.512916052247312*^9, 3.5129161229795256`*^9}, {
   3.512916186223547*^9, 3.5129162080797076`*^9}, {3.5129162823688126`*^9, 
   3.5129163193105593`*^9}, {3.51291650354289*^9, 3.512916561529577*^9}, {
   3.51291674146459*^9, 3.5129167653644032`*^9}, {3.5129168070174713`*^9, 
   3.5129168075010834`*^9}, {3.512916941882929*^9, 3.5129169715236893`*^9}, {
   3.512917039853441*^9, 3.5129170487144685`*^9}, {3.5129171626753902`*^9, 
   3.51291721259667*^9}, {3.512923441050785*^9, 3.512923635213217*^9}, {
   3.5129238836807876`*^9, 3.5129239487812567`*^9}, {3.512924014396539*^9, 
   3.512924018093834*^9}, {3.512924354235653*^9, 3.512924549989472*^9}, {
   3.512924646602749*^9, 3.5129246728270216`*^9}, {3.5129247440896487`*^9, 
   3.5129247520458527`*^9}, {3.5129250194211082`*^9, 3.5129250825559273`*^9}, 
   3.512925112805103*^9, 3.51292532681139*^9, {3.5129273977589035`*^9, 
   3.5129274184450336`*^9}, {3.5129275657128096`*^9, 
   3.5129275713913555`*^9}, {3.5129282681520205`*^9, 3.512928415949016*^9}, {
   3.5129284579296923`*^9, 3.512928458491307*^9}, 3.512928504216079*^9, {
   3.5129362089788656`*^9, 3.5129362233624344`*^9}, {3.5129554414160104`*^9, 
   3.512955441603213*^9}, {3.5129556437262845`*^9, 3.512955658624571*^9}, {
   3.512955706252287*^9, 3.51295572147818*^9}, 3.512956140346235*^9, 
   3.5129561772097435`*^9, {3.5129562095335655`*^9, 3.512956210344781*^9}, {
   3.512956243932227*^9, 3.5129562445406384`*^9}, 3.512994146465104*^9, {
   3.513097410249886*^9, 3.513097457183666*^9}, {3.513097507112224*^9, 
   3.5130975417563405`*^9}, {3.5130976353521404`*^9, 
   3.5130978006423235`*^9}, {3.5130978542891855`*^9, 
   3.5130978847867947`*^9}, {3.513097955391489*^9, 3.513097998446937*^9}, {
   3.513098070119622*^9, 3.5130981031443987`*^9}, {3.5130994801909304`*^9, 
   3.51309948465233*^9}, {3.5140306581817636`*^9, 3.5140306641565742`*^9}, {
   3.514030763622349*^9, 3.514030765244752*^9}, {3.5140820933017693`*^9, 
   3.51408209356697*^9}, {3.514082148135866*^9, 3.514082153252675*^9}, {
   3.514082218117589*^9, 3.51408225874006*^9}, {3.514082430589962*^9, 
   3.514082431525964*^9}, {3.5140824695744305`*^9, 3.514082470432432*^9}, 
   3.5140825602261896`*^9, {3.514082703325241*^9, 3.5140827059148455`*^9}, {
   3.5140835891259966`*^9, 3.5140836127288384`*^9}, {3.5140837394322605`*^9, 
   3.5140837540338864`*^9}, {3.5140863765232925`*^9, 3.514086380080099*^9}, {
   3.514086697400256*^9, 3.514086699865061*^9}, {3.514086914802238*^9, 
   3.514086938202279*^9}, {3.5140873463925962`*^9, 3.5140873475781984`*^9}, {
   3.5140877215576553`*^9, 3.514087740433688*^9}, 3.514087822848633*^9, {
   3.5140884124360685`*^9, 3.5140884475985303`*^9}, {3.514088661974107*^9, 
   3.5140886650161123`*^9}, {3.5141759853368845`*^9, 3.514176084599859*^9}, {
   3.5141994608450356`*^9, 3.5141995249611483`*^9}, {3.51419957127763*^9, 
   3.514199601448083*^9}, {3.514200515999689*^9, 3.5142005179184923`*^9}, 
   3.514200773946142*^9, {3.514201547957102*^9, 3.5142015684711375`*^9}, {
   3.514201805903555*^9, 3.514201844170422*^9}, {3.5142018855416946`*^9, 
   3.5142018886149*^9}, {3.5142021932522354`*^9, 3.514202220645883*^9}, {
   3.5142030790793905`*^9, 3.514203085350602*^9}, {3.5142039163952613`*^9, 
   3.5142039221048717`*^9}, {3.51420421728859*^9, 3.5142042198157945`*^9}, {
   3.514204339312004*^9, 3.514204347533219*^9}, {3.514204529959939*^9, 
   3.5142045360907497`*^9}, {3.5142045920324483`*^9, 3.514204615104889*^9}, {
   3.514204653465356*^9, 3.514204654588558*^9}, {3.51420685870483*^9, 
   3.5142068601244326`*^9}, 3.5142069220565414`*^9, {3.5142069621174116`*^9, 
   3.5142069894174595`*^9}, {3.5142590213682823`*^9, 
   3.5142590395579147`*^9}, {3.5142590862487965`*^9, 3.514259092364007*^9}, {
   3.51425931038999*^9, 3.5142593105771904`*^9}, {3.5144571945141277`*^9, 
   3.5144572015965405`*^9}, {3.5144572924042997`*^9, 
   3.5144572990187116`*^9}, {3.5148977429325547`*^9, 3.5148977436813564`*^9}, 
   3.5148984426873837`*^9, 3.5162947529524*^9, 3.516294788224062*^9, {
   3.5163662145036087`*^9, 3.5163662752501154`*^9}, {3.5164043626066093`*^9, 
   3.5164044245387177`*^9}, {3.516453785881099*^9, 3.516453828975766*^9}, {
   3.516453874036395*^9, 3.516453878593088*^9}, {3.516453910428568*^9, 
   3.516454028718472*^9}, {3.516454124213001*^9, 3.516454182924774*^9}, 
   3.516454253065649*^9, 3.516454347941146*^9, {3.516456397410473*^9, 
   3.516456441165949*^9}, {3.5164565195675144`*^9, 3.516456543746585*^9}, {
   3.5164566374842415`*^9, 3.5164566443170853`*^9}, {3.5164770745396857`*^9, 
   3.5164770748672867`*^9}, {3.5165429006280465`*^9, 3.516542904949254*^9}, {
   3.516569946229577*^9, 3.5165699503635845`*^9}, {3.517061599865655*^9, 
   3.5170616125016775`*^9}, {3.51706187595494*^9, 3.5170618784977446`*^9}, {
   3.517063226858514*^9, 3.5170633058570523`*^9}, {3.5170703955172453`*^9, 
   3.5170704004624543`*^9}, {3.517070804565564*^9, 3.517070809323572*^9}, {
   3.5170709467910137`*^9, 3.5170709533742256`*^9}, {3.5174903001413937`*^9, 
   3.5174903063502045`*^9}, {3.517689469472043*^9, 3.517689550950986*^9}, {
   3.5176896882780275`*^9, 3.517689689276429*^9}, {3.5176911672542253`*^9, 
   3.5176911681278267`*^9}, {3.51769130674967*^9, 3.5176913542205534`*^9}, {
   3.51769603778998*^9, 3.5176960656516285`*^9}, {3.517696144790568*^9, 
   3.517696184617438*^9}, 3.5178619807833433`*^9, {3.51793911442764*^9, 
   3.517939118265247*^9}, {3.5179500546319847`*^9, 3.5179500601855946`*^9}, {
   3.518126702807025*^9, 3.5181267059426303`*^9}, {3.5181934467801127`*^9, 
   3.518193517541837*^9}, {3.5181939664014254`*^9, 3.5181939961506777`*^9}, 
   3.518194055711582*^9, {3.5181948614557977`*^9, 3.5181948959942584`*^9}, {
   3.5181952387736607`*^9, 3.518195280550534*^9}, {3.51819558596787*^9, 
   3.518195595593087*^9}, {3.518195701314473*^9, 3.518195763418182*^9}, {
   3.5181958332907047`*^9, 3.518195850450735*^9}, {3.5181963088731403`*^9, 
   3.5181963243951674`*^9}, {3.518196698574624*^9, 3.5181967651555414`*^9}, {
   3.5182107038668222`*^9, 3.5182108966675615`*^9}, 3.5182109278364162`*^9, {
   3.5182111550976152`*^9, 3.518211156532818*^9}, {3.518226414671212*^9, 
   3.5182264685069065`*^9}, 3.518226566506279*^9, {3.5182270818219843`*^9, 
   3.5182270831479864`*^9}, {3.5183055173275814`*^9, 3.518305596731721*^9}, {
   3.5183056308957815`*^9, 3.5183056355601892`*^9}, {3.518305733169561*^9, 
   3.518305733372361*^9}, {3.518305813462902*^9, 3.518305830513732*^9}, {
   3.5183059149566803`*^9, 3.518305932740711*^9}, {3.5183060540621243`*^9, 
   3.5183060672285476`*^9}, {3.518374119957258*^9, 3.518374194026188*^9}, {
   3.5184630245351477`*^9, 3.518463041835578*^9}, {3.5184640491605473`*^9, 
   3.5184640849002104`*^9}, {3.518464154367132*^9, 3.5184641852395864`*^9}, {
   3.5184643274338365`*^9, 3.5184643350310497`*^9}, {3.5184643827983336`*^9, 
   3.518464527519788*^9}, 3.518464564725853*^9, {3.5184645967839093`*^9, 
   3.5184646636924267`*^9}, {3.5184648473515496`*^9, 
   3.5184648671479845`*^9}, {3.5184649458345222`*^9, 3.5184650727563457`*^9}, 
   3.5184651181524253`*^9, {3.51846516655931*^9, 3.5184651748741245`*^9}, {
   3.5184660252940187`*^9, 3.518466110470168*^9}, {3.51846648162602*^9, 
   3.5184666351770897`*^9}, {3.518466731772459*^9, 3.5184667392916727`*^9}, {
   3.518466884496728*^9, 3.518467039046199*^9}, {3.518467425037677*^9, 
   3.5184674283916826`*^9}, {3.5184674629301434`*^9, 
   3.5184674658317485`*^9}, {3.518467510775428*^9, 3.518467533130267*^9}, {
   3.5184675913027687`*^9, 3.5184676673529024`*^9}, {3.518467725244604*^9, 
   3.5184677488942456`*^9}, {3.5184677992823343`*^9, 
   3.5184678204983716`*^9}, {3.5184679378885775`*^9, 
   3.5184679482313957`*^9}, {3.5184681294413137`*^9, 
   3.5184681456029425`*^9}, {3.5184685770997005`*^9, 3.518468582076109*^9}, {
   3.5184686694362626`*^9, 3.5184686894510975`*^9}, {3.518532313692048*^9, 
   3.5185323264996705`*^9}, 3.518532394141389*^9, {3.518532424686243*^9, 
   3.5185324261214457`*^9}, {3.518532477632736*^9, 3.5185325503600636`*^9}, {
   3.51853258803413*^9, 3.5185325989853487`*^9}, {3.5185327420220003`*^9, 
   3.518532792550489*^9}, {3.518533131913485*^9, 3.5185331334578876`*^9}, {
   3.518533359486685*^9, 3.51853340800277*^9}, {3.5185342794671006`*^9, 
   3.5185343437236137`*^9}, {3.518534450349801*^9, 3.518534452237404*^9}, {
   3.5185347894319963`*^9, 3.5185347928016024`*^9}, {3.5185349983319635`*^9, 
   3.518535175891475*^9}, {3.51853936889524*^9, 3.518539384370467*^9}, {
   3.518539456302193*^9, 3.5185395235071115`*^9}, {3.5185395953140373`*^9, 
   3.518539648432131*^9}, {3.518539686230997*^9, 3.518539688415001*^9}, {
   3.5185397236086626`*^9, 3.5185399295758247`*^9}, {3.5185399888403287`*^9, 
   3.5185400116319685`*^9}, {3.518540128897375*^9, 3.5185401710018487`*^9}, {
   3.518540290716459*^9, 3.5185403243969183`*^9}, {3.518540357328576*^9, 
   3.518540357484576*^9}, {3.5185403936142397`*^9, 3.5185406885327578`*^9}, {
   3.5185407505272665`*^9, 3.5185407971245484`*^9}, {3.5185408547042494`*^9, 
   3.5185409356995916`*^9}, {3.5185411497475677`*^9, 
   3.5185411843640285`*^9}, {3.5185412346117167`*^9, 
   3.5185412777457924`*^9}, {3.5185413079786453`*^9, 3.518541369739154*^9}, {
   3.5185454218185916`*^9, 3.518545442301428*^9}, {3.5185454762314873`*^9, 
   3.518545577475665*^9}, {3.518545915494259*^9, 3.518545992807995*^9}, {
   3.518546069482129*^9, 3.518546095970976*^9}, {3.5185461364998474`*^9, 
   3.518546149104669*^9}, {3.5185462282436085`*^9, 3.5185462476500425`*^9}, {
   3.5185463281773834`*^9, 3.518546345119014*^9}, {3.518546381389077*^9, 
   3.518546461776018*^9}, {3.5185465045980935`*^9, 3.5185465768886204`*^9}, {
   3.5185466213330984`*^9, 3.5185466418471346`*^9}, {3.518546672189188*^9, 
   3.518546674513592*^9}, {3.5185467330448947`*^9, 3.5185468535239067`*^9}, {
   3.518546908670003*^9, 3.51854693511205*^9}, {3.5185469810073304`*^9, 
   3.518547088366719*^9}, {3.5185471238255816`*^9, 3.5185472656454306`*^9}, {
   3.5185474352801285`*^9, 3.5185476231824584`*^9}, {3.518547934356205*^9, 
   3.5185479551354413`*^9}, {3.518548042136794*^9, 3.518548065568035*^9}, {
   3.5185481293877473`*^9, 3.518548202583076*^9}, {3.518548298273644*^9, 
   3.5185482998648467`*^9}, {3.5185483807665887`*^9, 3.518548400204223*^9}, 
   3.5185484632907343`*^9, {3.518548563068509*^9, 3.518548573099327*^9}, 
   3.518724655162204*^9, {3.5244218526204367`*^9, 3.5244218555646706`*^9}},
 FontSize->16],

Cell[BoxData[
 RowBox[{
  RowBox[{"loadG1input", "[", 
   RowBox[{"iface_", ",", " ", "iedge_", ",", " ", "nbr_"}], "]"}], ":=", " ", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<loadG1input: iface=\>\"", ",", "iface", ",", "\"\<  iedge=\>\"", 
       ",", "iedge", ",", "\"\<  nbr=\>\"", ",", "nbr"}], "]"}], ";"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"iedge", "\[Equal]", "1"}], ",", 
      RowBox[{"(", "\n", "\t", 
       RowBox[{
        RowBox[{"q", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
        "\t", 
        RowBox[{"topl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
        "\t", 
        RowBox[{"botl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";"}], ")"}]}],
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"iedge", "\[Equal]", "2"}], ",", " ", 
      RowBox[{"(", "\n", "\t", 
       RowBox[{
        RowBox[{"q", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
        "\t", 
        RowBox[{"topl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
        "\t", 
        RowBox[{"botl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";"}], ")"}]}],
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"iedge", "\[Equal]", "3"}], ",", " ", 
      RowBox[{"(", "\n", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"q", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"bb1", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
            RowBox[{"bb1", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", 
            RowBox[{"bb1", "[", 
             RowBox[{"[", 
              RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
            RowBox[{"bb1", "[", 
             RowBox[{"[", 
              RowBox[{"4", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";"}], ";", 
        "\n", "\t", 
        RowBox[{"topl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
        "\t", 
        RowBox[{"botl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";"}], " ", 
       ")"}]}], "\[IndentingNewLine]", "]"}], ";", "\n", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"iedge", "\[Equal]", "4"}], ",", " ", 
      RowBox[{"(", "\n", "\t", 
       RowBox[{
        RowBox[{"q", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
        "\t", 
        RowBox[{"topl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", "\n", 
        "\t", 
        RowBox[{"botl", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"bb1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";"}], ")"}]}],
      "\[IndentingNewLine]", "]"}], ";", "\n", "\[IndentingNewLine]", 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    RowBox[{
     StyleBox["If",
      FontSize->16], 
     StyleBox["[",
      FontSize->16], 
     RowBox[{
      RowBox[{
       StyleBox[
        RowBox[{"faces", "[", 
         RowBox[{"[", 
          RowBox[{"nbr", ",", "1"}], "]"}], "]"}],
        FontSize->16], 
       StyleBox[" ",
        FontSize->16], 
       StyleBox["\[Equal]",
        FontSize->16], " ", 
       StyleBox["4",
        FontSize->16]}], 
      StyleBox[",",
       FontSize->16], "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{"nbrverts", " ", "=", " ", 
        RowBox[{"loadnghbrinfo", "[", 
         RowBox[{"iface", ",", " ", "nbr"}], "]"}]}],
       FontSize->16], 
      StyleBox[",",
       FontSize->16], 
      StyleBox["\[IndentingNewLine]",
       FontSize->16], 
      StyleBox[
       RowBox[{"nbrverts", " ", "=", " ", 
        RowBox[{"loadnghbrinfotri", "[", 
         RowBox[{"iface", ",", " ", "nbr"}], "]"}]}],
       FontSize->16]}], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["]",
      FontSize->16]}], 
    StyleBox[";",
     FontSize->16], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<loadG1input: nbrverts = \>\"", ",", "nbrverts"}], "]"}], 
      ";"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
     "load", " ", "data", " ", "starting", " ", "at", " ", "common", " ", 
      "boundary"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"topr", "=", 
     RowBox[{"boundary", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"faces", "[", 
        RowBox[{"[", 
         RowBox[{"nbr", ",", "2", ",", 
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"faces", "[", 
        RowBox[{"[", 
         RowBox[{"nbr", ",", "2", ",", 
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"botr", "=", 
     RowBox[{"boundary", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"faces", "[", 
        RowBox[{"[", 
         RowBox[{"nbr", ",", "2", ",", 
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"faces", "[", 
        RowBox[{"[", 
         RowBox[{"nbr", ",", "2", ",", 
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", "\"\<loadG1input: data loaded\>\"", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<    q = \>\"", ",", "q"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<    topl = \>\"", ",", "topl"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<    botl = \>\"", ",", "botl"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<    topr = \>\"", ",", "topr"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<    botr = \>\"", ",", "botr"}], "]"}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{
  3.512915951655933*^9, {3.512916052247312*^9, 3.5129161229795256`*^9}, {
   3.512916186223547*^9, 3.5129162080797076`*^9}, {3.5129162823688126`*^9, 
   3.5129163193105593`*^9}, {3.51291650354289*^9, 3.512916561529577*^9}, {
   3.51291674146459*^9, 3.5129167653644032`*^9}, {3.5129168070174713`*^9, 
   3.5129168075010834`*^9}, {3.512916941882929*^9, 3.5129169715236893`*^9}, {
   3.512917039853441*^9, 3.5129170487144685`*^9}, {3.5129171626753902`*^9, 
   3.51291721259667*^9}, {3.512923441050785*^9, 3.512923635213217*^9}, {
   3.5129238836807876`*^9, 3.5129239487812567`*^9}, {3.512924014396539*^9, 
   3.512924018093834*^9}, {3.512924354235653*^9, 3.512924549989472*^9}, {
   3.512924646602749*^9, 3.5129246728270216`*^9}, {3.5129247440896487`*^9, 
   3.5129247520458527`*^9}, {3.5129250194211082`*^9, 3.5129250825559273`*^9}, 
   3.512925112805103*^9, 3.51292532681139*^9, {3.5129273977589035`*^9, 
   3.5129274184450336`*^9}, {3.5129275657128096`*^9, 
   3.5129275713913555`*^9}, {3.5129282681520205`*^9, 3.512928415949016*^9}, {
   3.5129284579296923`*^9, 3.512928458491307*^9}, 3.512928504216079*^9, {
   3.5129362089788656`*^9, 3.5129362233624344`*^9}, {3.5129554414160104`*^9, 
   3.512955441603213*^9}, {3.5129556437262845`*^9, 3.512955658624571*^9}, {
   3.512955706252287*^9, 3.51295572147818*^9}, 3.512956140346235*^9, 
   3.5129561772097435`*^9, {3.5129562095335655`*^9, 3.512956210344781*^9}, {
   3.512956243932227*^9, 3.5129562445406384`*^9}, 3.512994146465104*^9, {
   3.513097410249886*^9, 3.513097457183666*^9}, {3.513097507112224*^9, 
   3.5130975417563405`*^9}, {3.5130976353521404`*^9, 
   3.5130978006423235`*^9}, {3.5130978542891855`*^9, 
   3.5130978847867947`*^9}, {3.513097955391489*^9, 3.513097998446937*^9}, {
   3.513098070119622*^9, 3.5130981031443987`*^9}, {3.5130994801909304`*^9, 
   3.51309948465233*^9}, {3.5140306581817636`*^9, 3.5140306641565742`*^9}, {
   3.514030763622349*^9, 3.514030765244752*^9}, {3.5140820933017693`*^9, 
   3.51408209356697*^9}, {3.514082148135866*^9, 3.514082153252675*^9}, {
   3.514082218117589*^9, 3.51408225874006*^9}, {3.514082430589962*^9, 
   3.514082431525964*^9}, {3.5140824695744305`*^9, 3.514082470432432*^9}, 
   3.5140825602261896`*^9, {3.514082703325241*^9, 3.5140827059148455`*^9}, {
   3.5140835891259966`*^9, 3.5140836127288384`*^9}, {3.5140837394322605`*^9, 
   3.5140837540338864`*^9}, {3.5140863765232925`*^9, 3.514086380080099*^9}, {
   3.514086697400256*^9, 3.514086699865061*^9}, {3.514086914802238*^9, 
   3.514086938202279*^9}, {3.5140873463925962`*^9, 3.5140873475781984`*^9}, {
   3.5140877215576553`*^9, 3.514087740433688*^9}, 3.514087822848633*^9, {
   3.5140884124360685`*^9, 3.5140884475985303`*^9}, {3.514088661974107*^9, 
   3.5140886650161123`*^9}, {3.5141759853368845`*^9, 3.514176084599859*^9}, {
   3.5141994608450356`*^9, 3.5141995249611483`*^9}, {3.51419957127763*^9, 
   3.514199601448083*^9}, {3.514200515999689*^9, 3.5142005179184923`*^9}, 
   3.514200773946142*^9, {3.514201547957102*^9, 3.5142015684711375`*^9}, {
   3.514201805903555*^9, 3.514201844170422*^9}, {3.5142018855416946`*^9, 
   3.5142018886149*^9}, {3.5142021932522354`*^9, 3.514202220645883*^9}, {
   3.5142030790793905`*^9, 3.514203085350602*^9}, {3.5142039163952613`*^9, 
   3.5142039221048717`*^9}, {3.51420421728859*^9, 3.5142042198157945`*^9}, {
   3.514204339312004*^9, 3.514204347533219*^9}, {3.514204529959939*^9, 
   3.5142045360907497`*^9}, {3.5142045920324483`*^9, 3.514204615104889*^9}, {
   3.514204653465356*^9, 3.514204654588558*^9}, {3.51420685870483*^9, 
   3.5142068601244326`*^9}, 3.5142069220565414`*^9, {3.5142069621174116`*^9, 
   3.5142069894174595`*^9}, {3.5142590213682823`*^9, 
   3.5142590395579147`*^9}, {3.5142590862487965`*^9, 3.514259092364007*^9}, {
   3.51425931038999*^9, 3.5142593105771904`*^9}, {3.5144571945141277`*^9, 
   3.5144572015965405`*^9}, {3.5144572924042997`*^9, 
   3.5144572990187116`*^9}, {3.5148977429325547`*^9, 3.5148977436813564`*^9}, 
   3.5148984426873837`*^9, 3.5162947529524*^9, 3.516294788224062*^9, {
   3.5163662145036087`*^9, 3.5163662752501154`*^9}, {3.5164043626066093`*^9, 
   3.5164044245387177`*^9}, {3.516453785881099*^9, 3.516453828975766*^9}, {
   3.516453874036395*^9, 3.516453878593088*^9}, {3.516453910428568*^9, 
   3.516454028718472*^9}, {3.516454124213001*^9, 3.516454182924774*^9}, 
   3.516454253065649*^9, 3.516454347941146*^9, {3.516456397410473*^9, 
   3.516456441165949*^9}, {3.5164565195675144`*^9, 3.516456543746585*^9}, {
   3.5164566374842415`*^9, 3.5164566443170853`*^9}, {3.5164770745396857`*^9, 
   3.5164770748672867`*^9}, {3.5165429006280465`*^9, 3.516542904949254*^9}, {
   3.516569946229577*^9, 3.5165699503635845`*^9}, {3.517061599865655*^9, 
   3.5170616125016775`*^9}, {3.51706187595494*^9, 3.5170618784977446`*^9}, {
   3.517063226858514*^9, 3.5170633058570523`*^9}, {3.5170703955172453`*^9, 
   3.5170704004624543`*^9}, {3.517070804565564*^9, 3.517070809323572*^9}, {
   3.5170709467910137`*^9, 3.5170709533742256`*^9}, {3.5174903001413937`*^9, 
   3.5174903063502045`*^9}, {3.517689469472043*^9, 3.517689550950986*^9}, {
   3.5176896882780275`*^9, 3.517689689276429*^9}, {3.5176911672542253`*^9, 
   3.5176911681278267`*^9}, {3.51769130674967*^9, 3.5176913542205534`*^9}, {
   3.51769603778998*^9, 3.5176960656516285`*^9}, {3.517696144790568*^9, 
   3.517696184617438*^9}, 3.5178619807833433`*^9, {3.51793911442764*^9, 
   3.517939118265247*^9}, {3.5179500546319847`*^9, 3.5179500601855946`*^9}, {
   3.518126702807025*^9, 3.5181267059426303`*^9}, {3.5181934467801127`*^9, 
   3.518193517541837*^9}, {3.5181939664014254`*^9, 3.5181939961506777`*^9}, 
   3.518194055711582*^9, {3.5181948614557977`*^9, 3.5181948959942584`*^9}, {
   3.5181952387736607`*^9, 3.518195280550534*^9}, {3.51819558596787*^9, 
   3.518195595593087*^9}, {3.518195701314473*^9, 3.518195763418182*^9}, {
   3.5181958332907047`*^9, 3.518195850450735*^9}, {3.5181963088731403`*^9, 
   3.5181963243951674`*^9}, {3.518196698574624*^9, 3.5181967651555414`*^9}, {
   3.5182107038668222`*^9, 3.5182108966675615`*^9}, 3.5182109278364162`*^9, {
   3.5182111550976152`*^9, 3.518211156532818*^9}, {3.518226414671212*^9, 
   3.5182264685069065`*^9}, 3.518226566506279*^9, {3.5182270818219843`*^9, 
   3.5182270831479864`*^9}, {3.5183055173275814`*^9, 3.518305596731721*^9}, {
   3.5183056308957815`*^9, 3.5183056355601892`*^9}, {3.518305733169561*^9, 
   3.518305733372361*^9}, {3.518305813462902*^9, 3.518305830513732*^9}, {
   3.5183059149566803`*^9, 3.518305932740711*^9}, {3.5183060540621243`*^9, 
   3.5183060672285476`*^9}, {3.518374119957258*^9, 3.518374194026188*^9}, {
   3.5184630245351477`*^9, 3.518463041835578*^9}, {3.5184640491605473`*^9, 
   3.5184640849002104`*^9}, {3.518464154367132*^9, 3.5184641852395864`*^9}, {
   3.5184643274338365`*^9, 3.5184643350310497`*^9}, {3.5184643827983336`*^9, 
   3.518464527519788*^9}, 3.518464564725853*^9, {3.5184645967839093`*^9, 
   3.5184646636924267`*^9}, {3.5184648473515496`*^9, 
   3.5184648671479845`*^9}, {3.5184649458345222`*^9, 3.5184650727563457`*^9}, 
   3.5184651181524253`*^9, {3.51846516655931*^9, 3.5184651748741245`*^9}, {
   3.5184660252940187`*^9, 3.518466110470168*^9}, {3.51846648162602*^9, 
   3.5184666351770897`*^9}, {3.518466731772459*^9, 3.5184667392916727`*^9}, {
   3.518466884496728*^9, 3.518467039046199*^9}, {3.518467425037677*^9, 
   3.5184674283916826`*^9}, {3.5184674629301434`*^9, 
   3.5184674658317485`*^9}, {3.518467510775428*^9, 3.518467533130267*^9}, {
   3.5184675913027687`*^9, 3.5184676673529024`*^9}, {3.518467725244604*^9, 
   3.5184677488942456`*^9}, {3.5184677992823343`*^9, 
   3.5184678204983716`*^9}, {3.5184679378885775`*^9, 
   3.5184679482313957`*^9}, {3.5184681294413137`*^9, 
   3.5184681456029425`*^9}, {3.5184685770997005`*^9, 3.518468582076109*^9}, {
   3.5184686694362626`*^9, 3.5184686894510975`*^9}, {3.518532313692048*^9, 
   3.5185323264996705`*^9}, 3.518532394141389*^9, {3.518532424686243*^9, 
   3.5185324261214457`*^9}, {3.518532477632736*^9, 3.5185325503600636`*^9}, {
   3.51853258803413*^9, 3.5185325989853487`*^9}, {3.5185327420220003`*^9, 
   3.518532792550489*^9}, {3.518533131913485*^9, 3.5185331334578876`*^9}, {
   3.518533359486685*^9, 3.51853340800277*^9}, {3.5185342794671006`*^9, 
   3.5185343437236137`*^9}, {3.518534450349801*^9, 3.518534452237404*^9}, {
   3.5185347894319963`*^9, 3.5185347928016024`*^9}, {3.5185349983319635`*^9, 
   3.518535175891475*^9}, {3.51853936889524*^9, 3.518539384370467*^9}, {
   3.518539456302193*^9, 3.5185395235071115`*^9}, {3.5185395953140373`*^9, 
   3.518539648432131*^9}, {3.518539686230997*^9, 3.518539688415001*^9}, {
   3.5185397236086626`*^9, 3.5185399295758247`*^9}, {3.5185399888403287`*^9, 
   3.5185400116319685`*^9}, {3.518540128897375*^9, 3.5185401710018487`*^9}, {
   3.518540290716459*^9, 3.5185403243969183`*^9}, {3.518540357328576*^9, 
   3.518540357484576*^9}, {3.5185403936142397`*^9, 3.5185406885327578`*^9}, {
   3.5185407505272665`*^9, 3.5185407971245484`*^9}, {3.5185408547042494`*^9, 
   3.5185409356995916`*^9}, {3.5185411497475677`*^9, 
   3.5185411843640285`*^9}, {3.5185412346117167`*^9, 
   3.5185412777457924`*^9}, {3.5185413079786453`*^9, 3.518541369739154*^9}, {
   3.5185454218185916`*^9, 3.518545442301428*^9}, {3.5185454762314873`*^9, 
   3.518545577475665*^9}, {3.518545915494259*^9, 3.518545992807995*^9}, {
   3.518546069482129*^9, 3.518546095970976*^9}, {3.5185461364998474`*^9, 
   3.518546149104669*^9}, {3.5185462282436085`*^9, 3.5185462476500425`*^9}, {
   3.5185463281773834`*^9, 3.518546345119014*^9}, {3.518546381389077*^9, 
   3.518546461776018*^9}, {3.5185465045980935`*^9, 3.5185465768886204`*^9}, {
   3.5185466213330984`*^9, 3.5185466418471346`*^9}, {3.518546672189188*^9, 
   3.518546674513592*^9}, {3.5185467330448947`*^9, 3.5185468535239067`*^9}, {
   3.518546908670003*^9, 3.51854693511205*^9}, {3.5185469810073304`*^9, 
   3.518547088366719*^9}, {3.5185471238255816`*^9, 3.5185472656454306`*^9}, {
   3.5185474352801285`*^9, 3.5185476231824584`*^9}, {3.518547934356205*^9, 
   3.5185479551354413`*^9}, {3.518548042136794*^9, 3.518548065568035*^9}, {
   3.5185481293877473`*^9, 3.518548202583076*^9}, {3.518548298273644*^9, 
   3.5185482998648467`*^9}, {3.5185483807665887`*^9, 3.518548400204223*^9}, 
   3.5185484632907343`*^9, {3.518548563068509*^9, 3.5185485854857483`*^9}, {
   3.518548665295489*^9, 3.5185486736727037`*^9}, {3.518549494296545*^9, 
   3.518549504327362*^9}, {3.518707050770482*^9, 3.518707344565798*^9}, {
   3.5187246680322266`*^9, 3.5187246891078634`*^9}, {3.5194190756782722`*^9, 
   3.5194190869444723`*^9}},
 FontSize->16],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   StyleBox[
    RowBox[{"loadG1inputtri", "[", 
     RowBox[{"iface_", ",", " ", "iedge_", ",", " ", "nbr_"}], "]"}],
    FontSize->16], 
   StyleBox[":=",
    FontSize->16], 
   StyleBox[" ",
    FontSize->16], 
   RowBox[{
    StyleBox["(",
     FontSize->16], 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    StyleBox[
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<loadG1input tri case: iface=\>\"", ",", "iface", ",", 
         "\"\<  iedge=\>\"", ",", "iedge", ",", "\"\<  nbr=\>\"", ",", 
         "nbr"}], "]"}], ";"}], " ", "*)"}],
     FontSize->16], 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    RowBox[{
     StyleBox[
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"iedge", "\[Equal]", "1"}], ",", 
        RowBox[{"(", "\n", "\t", 
         RowBox[{
          RowBox[{"q", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ";", "\n", "\t", 
          RowBox[{"topl", "=", " ", "tedge2"}], ";", "\n", "\t", 
          RowBox[{"botl", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ";"}], ")"}]}], 
       "\[IndentingNewLine]", "]"}],
      FontSize->16], 
     StyleBox[";",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox[
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"iedge", "\[Equal]", "2"}], ",", " ", 
        RowBox[{"(", "\n", "\t", 
         RowBox[{
          RowBox[{"q", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ";", "\n", "\t", 
          RowBox[{"topl", "=", "tedge3"}], ";", "\n", "\t", 
          RowBox[{"botl", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"tedge1", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ";"}], ")"}]}], 
       "\[IndentingNewLine]", "]"}],
      FontSize->16], 
     StyleBox[";",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["\n",
      FontSize->16], 
     StyleBox[
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"iedge", "\[Equal]", "3"}], ",", " ", 
        RowBox[{"(", "\n", "\t", 
         RowBox[{
          RowBox[{"q", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"tedge3", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ";", "\n", "\t", 
          RowBox[{"topl", "=", "tedge1"}], ";", "\n", "\t", 
          RowBox[{"botl", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"tedge2", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], ";"}], " ", ")"}]}], 
       "\[IndentingNewLine]", "]"}],
      FontSize->16], 
     StyleBox[";",
      FontSize->16], 
     StyleBox["\n",
      FontSize->16], 
     StyleBox["\n",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     RowBox[{
      StyleBox["If",
       FontSize->16], 
      StyleBox["[",
       FontSize->16], 
      RowBox[{
       RowBox[{
        StyleBox[
         RowBox[{"faces", "[", 
          RowBox[{"[", 
           RowBox[{"nbr", ",", "1"}], "]"}], "]"}],
         FontSize->16], 
        StyleBox[" ",
         FontSize->16], 
        StyleBox["\[Equal]",
         FontSize->16], " ", 
        StyleBox["4",
         FontSize->16]}], 
       StyleBox[",",
        FontSize->16], "\[IndentingNewLine]", 
       StyleBox[
        RowBox[{"nbrverts", " ", "=", " ", 
         RowBox[{"loadnghbrinfo", "[", 
          RowBox[{"iface", ",", " ", "nbr"}], "]"}]}],
        FontSize->16], 
       StyleBox[",",
        FontSize->16], 
       StyleBox["\[IndentingNewLine]",
        FontSize->16], 
       StyleBox[
        RowBox[{"nbrverts", " ", "=", " ", 
         RowBox[{"loadnghbrinfotri", "[", 
          RowBox[{"iface", ",", " ", "nbr"}], "]"}]}],
        FontSize->16]}], 
      StyleBox["\[IndentingNewLine]",
       FontSize->16], 
      StyleBox["]",
       FontSize->16]}], 
     StyleBox[";",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox[
      RowBox[{"(*", 
       RowBox[{
       "load", " ", "data", " ", "starting", " ", "at", " ", "common", " ", 
        "boundary"}], "*)"}],
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox[
      RowBox[{"topr", "=", 
       RowBox[{"boundary", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"faces", "[", 
          RowBox[{"[", 
           RowBox[{"nbr", ",", "2", ",", 
            RowBox[{"nbrverts", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"faces", "[", 
          RowBox[{"[", 
           RowBox[{"nbr", ",", "2", ",", 
            RowBox[{"nbrverts", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}], "]"}]}],
      FontSize->16], 
     StyleBox[";",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox["\[IndentingNewLine]",
      FontSize->16], 
     StyleBox[
      RowBox[{"botr", "=", 
       RowBox[{"boundary", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"faces", "[", 
          RowBox[{"[", 
           RowBox[{"nbr", ",", "2", ",", 
            RowBox[{"nbrverts", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"faces", "[", 
          RowBox[{"[", 
           RowBox[{"nbr", ",", "2", ",", 
            RowBox[{"nbrverts", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "]"}]}], "]"}]}],
      FontSize->16]}], 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    StyleBox[" ",
     FontSize->16], 
    StyleBox[
     RowBox[{"(*", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", "\"\<loadG1input: data loaded\>\"", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<    q = \>\"", ",", "q"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<    topl = \>\"", ",", "topl"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<    botl = \>\"", ",", "botl"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<    topr = \>\"", ",", "topr"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<    botr = \>\"", ",", "botr"}], "]"}], ";"}], 
      "\[IndentingNewLine]", "*)"}],
     FontSize->16], 
    StyleBox["\[IndentingNewLine]",
     FontSize->16], 
    StyleBox[")",
     FontSize->16]}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvSXo5eKDFq8cj7l9XQqiZ7norALR959UbQbRBy59
3Q6iVW/82wGi+Zz8boLoFylLP4Pojtx3P0F0yobCfyCawWOP9iEgvSPuEJh+
9GmbB4jOZb0RAKJLZNc4vgDSHJ3PnEG02gT+KSBaZ8r1qSD6w5oNAa+A9Jnp
hYEgWkFVORJEN7xbAqY3JPefBtFbujLOgOg1k7acegek/zg/PQui9X5x1Lyy
fOUo2GhQC6IZSve+fQOkLZ3z34PoF/ciJ74F0nnRSWD6eVTtdBC93fwymE5p
DJ7Aa/XKsSb6xUQQ3Zew6pEokObhrn4Mom+sT/p1A0iLveL5DaK3CF4s0bZ+
5ahltKsURAMAhOK2LQ==
  "]],

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{"(*", " ", 
   RowBox[{"===", "===", "===", "===", "===", 
    RowBox[{"Load", " ", "Gregory", " ", "Points", " ", "code"}], "===", "===",
     "===", "===", "===", "===", "===", "===", "==="}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Input", ":", "iedge"}], ",", 
    RowBox[{"p", " ", "\[IndentingNewLine]", 
     RowBox[{"Output", ":", "bb1"}]}], ",", 
    RowBox[{
    "cc", "\[IndentingNewLine]", "\[IndentingNewLine]", "Load", " ", 
     "Gregory", " ", "points", " ", "into", " ", "bb1", " ", "or", " ", "cc", 
     " ", "arrays", " ", "depending", " ", "on", " ", "edge", " ", "working", 
     " ", 
     RowBox[{"on", ".", "\[IndentingNewLine]", "Input"}], " ", "array", " ", 
     "p", " ", "is", " ", "the", " ", 
     RowBox[{"row", "/", "column"}], " ", "of", " ", "Bezier", " ", "points", 
     " ", "that", " ", "is", " ", "adjacent", " ", "to", " ", 
     RowBox[{"boundary", ".", "\[IndentingNewLine]", 
      RowBox[{"Don", "'"}]}], "t", " ", "need", " ", "to", " ", "reload", " ",
      "the", " ", "control", " ", "points", " ", "on", " ", "the", " ", 
     RowBox[{"boundaries", "--"}], " ", "they", " ", 
     RowBox[{"didn", "'"}], "t", " ", "get", " ", 
     RowBox[{"modified", ".", "\[IndentingNewLine]", "Modify"}], " ", 
     "interior", " ", "control", " ", "points", " ", "in", " ", "the", " ", 
     "following", " ", 
     RowBox[{"way", ":", "\[IndentingNewLine]", 
      RowBox[{
      "Edges", " ", "1", " ", "and", " ", "3", " ", "load", " ", "into", " ", 
       "cc", " ", "and", " ", "Edges", " ", "2", " ", "and", " ", "4", " ", 
       "load", " ", "into", " ", 
       RowBox[{
       "bb1", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "FIX"}], " ",
        "FOR", " ", 
       RowBox[{
        RowBox[{"TRIANGLES", "!!"}], "!!"}]}]}]}]}], "\[IndentingNewLine]", 
   "*)"}]}]], "Input",
 CellChangeTimes->{
  3.512915951655933*^9, {3.512916052247312*^9, 3.5129161229795256`*^9}, {
   3.512916186223547*^9, 3.5129162080797076`*^9}, {3.5129162823688126`*^9, 
   3.5129163193105593`*^9}, {3.51291650354289*^9, 3.512916561529577*^9}, {
   3.51291674146459*^9, 3.5129167653644032`*^9}, {3.5129168070174713`*^9, 
   3.5129168075010834`*^9}, {3.512916941882929*^9, 3.5129169715236893`*^9}, {
   3.512917039853441*^9, 3.5129170487144685`*^9}, {3.5129171626753902`*^9, 
   3.51291721259667*^9}, {3.512923441050785*^9, 3.512923635213217*^9}, {
   3.5129238836807876`*^9, 3.5129239487812567`*^9}, {3.512924014396539*^9, 
   3.512924018093834*^9}, {3.512924354235653*^9, 3.512924549989472*^9}, {
   3.512924646602749*^9, 3.5129246728270216`*^9}, {3.5129247440896487`*^9, 
   3.5129247520458527`*^9}, {3.5129250194211082`*^9, 3.5129250825559273`*^9}, 
   3.512925112805103*^9, 3.51292532681139*^9, {3.5129273977589035`*^9, 
   3.5129274184450336`*^9}, {3.5129275657128096`*^9, 
   3.5129275713913555`*^9}, {3.5129282681520205`*^9, 3.512928415949016*^9}, {
   3.5129284579296923`*^9, 3.512928458491307*^9}, 3.512928504216079*^9, {
   3.5129362089788656`*^9, 3.5129362233624344`*^9}, {3.5129554414160104`*^9, 
   3.512955441603213*^9}, {3.5129556437262845`*^9, 3.512955658624571*^9}, {
   3.512955706252287*^9, 3.51295572147818*^9}, 3.512956140346235*^9, 
   3.5129561772097435`*^9, {3.5129562095335655`*^9, 3.512956210344781*^9}, {
   3.512956243932227*^9, 3.5129562445406384`*^9}, 3.512994146465104*^9, {
   3.513097410249886*^9, 3.513097457183666*^9}, {3.513097507112224*^9, 
   3.5130975417563405`*^9}, {3.5130976353521404`*^9, 
   3.5130978006423235`*^9}, {3.5130978542891855`*^9, 
   3.5130978847867947`*^9}, {3.513097955391489*^9, 3.513097998446937*^9}, {
   3.513098070119622*^9, 3.5130981031443987`*^9}, {3.5130994801909304`*^9, 
   3.51309948465233*^9}, {3.5140306581817636`*^9, 3.5140306641565742`*^9}, {
   3.514030763622349*^9, 3.514030765244752*^9}, {3.5140820933017693`*^9, 
   3.51408209356697*^9}, {3.514082148135866*^9, 3.514082153252675*^9}, {
   3.514082218117589*^9, 3.51408225874006*^9}, {3.514082430589962*^9, 
   3.514082431525964*^9}, {3.5140824695744305`*^9, 3.514082470432432*^9}, 
   3.5140825602261896`*^9, {3.514082703325241*^9, 3.5140827059148455`*^9}, {
   3.5140835891259966`*^9, 3.5140836127288384`*^9}, {3.5140837394322605`*^9, 
   3.5140837540338864`*^9}, {3.5140863765232925`*^9, 3.514086380080099*^9}, {
   3.514086697400256*^9, 3.514086699865061*^9}, {3.514086914802238*^9, 
   3.514086938202279*^9}, {3.5140873463925962`*^9, 3.5140873475781984`*^9}, {
   3.5140877215576553`*^9, 3.514087740433688*^9}, 3.514087822848633*^9, {
   3.5140884124360685`*^9, 3.5140884475985303`*^9}, {3.514088661974107*^9, 
   3.5140886650161123`*^9}, {3.5141759853368845`*^9, 3.514176084599859*^9}, {
   3.5141994608450356`*^9, 3.5141995249611483`*^9}, {3.51419957127763*^9, 
   3.514199601448083*^9}, {3.514200515999689*^9, 3.5142005179184923`*^9}, 
   3.514200773946142*^9, {3.514201547957102*^9, 3.5142015684711375`*^9}, {
   3.514201805903555*^9, 3.514201844170422*^9}, {3.5142018855416946`*^9, 
   3.5142018886149*^9}, {3.5142021932522354`*^9, 3.514202220645883*^9}, {
   3.5142030790793905`*^9, 3.514203085350602*^9}, {3.5142039163952613`*^9, 
   3.5142039221048717`*^9}, {3.51420421728859*^9, 3.5142042198157945`*^9}, {
   3.514204339312004*^9, 3.514204347533219*^9}, {3.514204529959939*^9, 
   3.5142045360907497`*^9}, {3.5142045920324483`*^9, 3.514204615104889*^9}, {
   3.514204653465356*^9, 3.514204654588558*^9}, {3.51420685870483*^9, 
   3.5142068601244326`*^9}, 3.5142069220565414`*^9, {3.5142069621174116`*^9, 
   3.5142069894174595`*^9}, {3.5142590213682823`*^9, 
   3.5142590395579147`*^9}, {3.5142590862487965`*^9, 3.514259092364007*^9}, {
   3.51425931038999*^9, 3.5142593105771904`*^9}, {3.5144571945141277`*^9, 
   3.5144572015965405`*^9}, {3.5144572924042997`*^9, 
   3.5144572990187116`*^9}, {3.5148977429325547`*^9, 3.5148977436813564`*^9}, 
   3.5148984426873837`*^9, 3.5162947529524*^9, 3.516294788224062*^9, {
   3.5163662145036087`*^9, 3.5163662752501154`*^9}, {3.5164043626066093`*^9, 
   3.5164044245387177`*^9}, {3.516453785881099*^9, 3.516453828975766*^9}, {
   3.516453874036395*^9, 3.516453878593088*^9}, {3.516453910428568*^9, 
   3.516454028718472*^9}, {3.516454124213001*^9, 3.516454182924774*^9}, 
   3.516454253065649*^9, 3.516454347941146*^9, {3.516456397410473*^9, 
   3.516456441165949*^9}, {3.5164565195675144`*^9, 3.516456543746585*^9}, {
   3.5164566374842415`*^9, 3.5164566443170853`*^9}, {3.5164770745396857`*^9, 
   3.5164770748672867`*^9}, {3.5165429006280465`*^9, 3.516542904949254*^9}, {
   3.516569946229577*^9, 3.5165699503635845`*^9}, {3.517061599865655*^9, 
   3.5170616125016775`*^9}, {3.51706187595494*^9, 3.5170618784977446`*^9}, {
   3.517063226858514*^9, 3.5170633058570523`*^9}, {3.5170703955172453`*^9, 
   3.5170704004624543`*^9}, {3.517070804565564*^9, 3.517070809323572*^9}, {
   3.5170709467910137`*^9, 3.5170709533742256`*^9}, {3.5174903001413937`*^9, 
   3.5174903063502045`*^9}, {3.517689469472043*^9, 3.517689550950986*^9}, {
   3.5176896882780275`*^9, 3.517689689276429*^9}, {3.5176911672542253`*^9, 
   3.5176911681278267`*^9}, {3.51769130674967*^9, 3.5176913542205534`*^9}, {
   3.51769603778998*^9, 3.5176960656516285`*^9}, {3.517696144790568*^9, 
   3.517696184617438*^9}, 3.5178619807833433`*^9, {3.51793911442764*^9, 
   3.517939118265247*^9}, {3.5179500546319847`*^9, 3.5179500601855946`*^9}, {
   3.518126702807025*^9, 3.5181267059426303`*^9}, {3.5181934467801127`*^9, 
   3.518193517541837*^9}, {3.5181939664014254`*^9, 3.5181939961506777`*^9}, 
   3.518194055711582*^9, {3.5181948614557977`*^9, 3.5181948959942584`*^9}, {
   3.5181952387736607`*^9, 3.518195280550534*^9}, {3.51819558596787*^9, 
   3.518195595593087*^9}, {3.518195701314473*^9, 3.518195763418182*^9}, {
   3.5181958332907047`*^9, 3.518195850450735*^9}, {3.5181963088731403`*^9, 
   3.5181963243951674`*^9}, {3.518196698574624*^9, 3.5181967651555414`*^9}, {
   3.5182107038668222`*^9, 3.5182108966675615`*^9}, 3.5182109278364162`*^9, {
   3.5182111550976152`*^9, 3.518211156532818*^9}, {3.518226414671212*^9, 
   3.5182264685069065`*^9}, 3.518226566506279*^9, {3.5182270818219843`*^9, 
   3.5182270831479864`*^9}, {3.5183055173275814`*^9, 3.518305596731721*^9}, {
   3.5183056308957815`*^9, 3.5183056355601892`*^9}, {3.518305733169561*^9, 
   3.518305733372361*^9}, {3.518305813462902*^9, 3.518305830513732*^9}, {
   3.5183059149566803`*^9, 3.518305932740711*^9}, {3.5183060540621243`*^9, 
   3.5183060672285476`*^9}, {3.518374119957258*^9, 3.518374194026188*^9}, {
   3.5184630245351477`*^9, 3.518463041835578*^9}, {3.5184640491605473`*^9, 
   3.5184640849002104`*^9}, {3.518464154367132*^9, 3.5184641852395864`*^9}, {
   3.5184643274338365`*^9, 3.5184643350310497`*^9}, {3.5184643827983336`*^9, 
   3.518464527519788*^9}, 3.518464564725853*^9, {3.5184645967839093`*^9, 
   3.5184646636924267`*^9}, {3.5184648473515496`*^9, 
   3.5184648671479845`*^9}, {3.5184649458345222`*^9, 3.5184650727563457`*^9}, 
   3.5184651181524253`*^9, {3.51846516655931*^9, 3.5184651748741245`*^9}, {
   3.5184660252940187`*^9, 3.518466110470168*^9}, {3.51846648162602*^9, 
   3.5184666351770897`*^9}, {3.518466731772459*^9, 3.5184667392916727`*^9}, {
   3.518466884496728*^9, 3.518467039046199*^9}, {3.518467425037677*^9, 
   3.5184674283916826`*^9}, {3.5184674629301434`*^9, 
   3.5184674658317485`*^9}, {3.518467510775428*^9, 3.518467533130267*^9}, {
   3.5184675913027687`*^9, 3.5184676673529024`*^9}, {3.518467725244604*^9, 
   3.5184677488942456`*^9}, {3.5184677992823343`*^9, 
   3.5184678204983716`*^9}, {3.5184679378885775`*^9, 
   3.5184679482313957`*^9}, {3.5184681294413137`*^9, 
   3.5184681456029425`*^9}, {3.5184685770997005`*^9, 3.518468582076109*^9}, {
   3.5184686694362626`*^9, 3.5184686894510975`*^9}, {3.518532313692048*^9, 
   3.5185323264996705`*^9}, 3.518532394141389*^9, {3.518532424686243*^9, 
   3.5185324261214457`*^9}, {3.518532477632736*^9, 3.5185325503600636`*^9}, {
   3.51853258803413*^9, 3.5185325989853487`*^9}, {3.5185327420220003`*^9, 
   3.518532792550489*^9}, {3.518533131913485*^9, 3.5185331334578876`*^9}, {
   3.518533359486685*^9, 3.51853340800277*^9}, {3.5185342794671006`*^9, 
   3.5185343437236137`*^9}, {3.518534450349801*^9, 3.518534452237404*^9}, {
   3.5185347894319963`*^9, 3.5185347928016024`*^9}, {3.5185349983319635`*^9, 
   3.518535175891475*^9}, {3.51853936889524*^9, 3.518539384370467*^9}, {
   3.518539456302193*^9, 3.5185395235071115`*^9}, {3.5185395953140373`*^9, 
   3.518539648432131*^9}, {3.518539686230997*^9, 3.518539688415001*^9}, {
   3.5185397236086626`*^9, 3.5185399295758247`*^9}, {3.5185399888403287`*^9, 
   3.5185400116319685`*^9}, {3.518540128897375*^9, 3.5185401710018487`*^9}, {
   3.518540290716459*^9, 3.5185403243969183`*^9}, {3.518540357328576*^9, 
   3.518540357484576*^9}, {3.5185403936142397`*^9, 3.5185406885327578`*^9}, {
   3.5185407505272665`*^9, 3.5185407971245484`*^9}, {3.5185408547042494`*^9, 
   3.5185409356995916`*^9}, {3.5185411497475677`*^9, 
   3.5185411843640285`*^9}, {3.5185412346117167`*^9, 
   3.5185412777457924`*^9}, {3.5185413079786453`*^9, 3.518541369739154*^9}, {
   3.5185454218185916`*^9, 3.518545442301428*^9}, {3.5185454762314873`*^9, 
   3.518545577475665*^9}, {3.518545915494259*^9, 3.518545992807995*^9}, {
   3.518546069482129*^9, 3.518546095970976*^9}, {3.5185461364998474`*^9, 
   3.518546149104669*^9}, {3.5185462282436085`*^9, 3.5185462476500425`*^9}, {
   3.5185463281773834`*^9, 3.518546345119014*^9}, {3.518546381389077*^9, 
   3.518546461776018*^9}, {3.5185465045980935`*^9, 3.5185465768886204`*^9}, {
   3.5185466213330984`*^9, 3.5185466418471346`*^9}, {3.518546672189188*^9, 
   3.518546674513592*^9}, {3.5185467330448947`*^9, 3.5185468535239067`*^9}, {
   3.518546908670003*^9, 3.51854693511205*^9}, {3.5185469810073304`*^9, 
   3.518547088366719*^9}, {3.5185471238255816`*^9, 3.5185472656454306`*^9}, {
   3.5185474352801285`*^9, 3.5185476231824584`*^9}, {3.518547934356205*^9, 
   3.5185479551354413`*^9}, {3.518548042136794*^9, 3.518548065568035*^9}, {
   3.5185481293877473`*^9, 3.518548202583076*^9}, {3.518548298273644*^9, 
   3.5185482998648467`*^9}, {3.5185483807665887`*^9, 3.518548400204223*^9}, 
   3.5185484632907343`*^9, {3.518548563068509*^9, 3.518548593753763*^9}, 
   3.5187246946302733`*^9},
 FontSize->16],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"loadG1output", "[", 
    RowBox[{"iedge_", ",", "p_"}], "]"}], " ", ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"iedge", "\[Equal]", "1"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"bb1", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "2"}], "]"}], "]"}], "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", 
         RowBox[{
          RowBox[{"bb1", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], "]"}], ";", "\n", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"iedge", "\[Equal]", "2"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cc33", "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", 
         RowBox[{"cc32", "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], "]"}], ";", "\n", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"iedge", "\[Equal]", "3"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"bb1", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", 
         RowBox[{
          RowBox[{"bb1", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3"}], "]"}], "]"}], "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\n", "     ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"iedge", "\[Equal]", "4"}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cc22", "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ";", 
         RowBox[{"cc23", "=", 
          RowBox[{"p", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<loadG1output: loaded p using case iedge=\>\"", ",", "iedge"}], 
       "]"}], ";", " ", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<loadG1output: bb1 = \>\"", ",", 
        RowBox[{"MatrixForm", "[", "bb1", "]"}]}], "]"}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<  cc22=\>\"", ",", "cc22", ",", "\"\< cc23=\>\"", ",", "cc23", 
        ",", "\"\<  cc32=\>\"", ",", "cc32", ",", "\"\<  cc33=\>\"", ",", 
        "cc33"}], "]"}], ";"}], "\[IndentingNewLine]", "*)"}], "\n", ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"loadG1outputtri", "[", 
   RowBox[{"iedge_", ",", "p_"}], "]"}], " ", ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"iedge", "\[Equal]", "1"}], ",", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", 
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\n", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"iedge", "\[Equal]", "2"}], ",", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", 
        RowBox[{"dd32", "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\n", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"iedge", "\[Equal]", "3"}], ",", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"dd22", "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", 
        RowBox[{"dd23", "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}], "]"}], ";"}], "\n", 
   "\[IndentingNewLine]", "     ", "\n", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<loadG1outputtri: loaded p using case iedge=\>\"", ",", "iedge"}], 
      "]"}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<loadG1outputtri: tt1 = \>\"", ",", 
       RowBox[{"MatrixForm", "[", "tt1", "]"}]}], "]"}], ";", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<  dd22=\>\"", ",", "dd22", ",", "\"\< dd23=\>\"", ",", "dd23", 
       ",", "\"\<  dd32=\>\"", ",", "dd32", ",", "\"\<  dd33=\>\"", ",", 
       "dd33"}], "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", ")"}]}]}], "Input",
 CellChangeTimes->{
  3.512915951655933*^9, {3.512916052247312*^9, 3.5129161229795256`*^9}, {
   3.512916186223547*^9, 3.5129162080797076`*^9}, {3.5129162823688126`*^9, 
   3.5129163193105593`*^9}, {3.51291650354289*^9, 3.512916561529577*^9}, {
   3.51291674146459*^9, 3.5129167653644032`*^9}, {3.5129168070174713`*^9, 
   3.5129168075010834`*^9}, {3.512916941882929*^9, 3.5129169715236893`*^9}, {
   3.512917039853441*^9, 3.5129170487144685`*^9}, {3.5129171626753902`*^9, 
   3.51291721259667*^9}, {3.512923441050785*^9, 3.512923635213217*^9}, {
   3.5129238836807876`*^9, 3.5129239487812567`*^9}, {3.512924014396539*^9, 
   3.512924018093834*^9}, {3.512924354235653*^9, 3.512924549989472*^9}, {
   3.512924646602749*^9, 3.5129246728270216`*^9}, {3.5129247440896487`*^9, 
   3.5129247520458527`*^9}, {3.5129250194211082`*^9, 3.5129250825559273`*^9}, 
   3.512925112805103*^9, 3.51292532681139*^9, {3.5129273977589035`*^9, 
   3.5129274184450336`*^9}, {3.5129275657128096`*^9, 
   3.5129275713913555`*^9}, {3.5129282681520205`*^9, 3.512928415949016*^9}, {
   3.5129284579296923`*^9, 3.512928458491307*^9}, 3.512928504216079*^9, {
   3.5129362089788656`*^9, 3.5129362233624344`*^9}, {3.5129554414160104`*^9, 
   3.512955441603213*^9}, {3.5129556437262845`*^9, 3.512955658624571*^9}, {
   3.512955706252287*^9, 3.51295572147818*^9}, 3.512956140346235*^9, 
   3.5129561772097435`*^9, {3.5129562095335655`*^9, 3.512956210344781*^9}, {
   3.512956243932227*^9, 3.5129562445406384`*^9}, 3.512994146465104*^9, {
   3.513097410249886*^9, 3.513097457183666*^9}, {3.513097507112224*^9, 
   3.5130975417563405`*^9}, {3.5130976353521404`*^9, 
   3.5130978006423235`*^9}, {3.5130978542891855`*^9, 
   3.5130978847867947`*^9}, {3.513097955391489*^9, 3.513097998446937*^9}, {
   3.513098070119622*^9, 3.5130981031443987`*^9}, {3.5130994801909304`*^9, 
   3.51309948465233*^9}, {3.5140306581817636`*^9, 3.5140306641565742`*^9}, {
   3.514030763622349*^9, 3.514030765244752*^9}, {3.5140820933017693`*^9, 
   3.51408209356697*^9}, {3.514082148135866*^9, 3.514082153252675*^9}, {
   3.514082218117589*^9, 3.51408225874006*^9}, {3.514082430589962*^9, 
   3.514082431525964*^9}, {3.5140824695744305`*^9, 3.514082470432432*^9}, 
   3.5140825602261896`*^9, {3.514082703325241*^9, 3.5140827059148455`*^9}, {
   3.5140835891259966`*^9, 3.5140836127288384`*^9}, {3.5140837394322605`*^9, 
   3.5140837540338864`*^9}, {3.5140863765232925`*^9, 3.514086380080099*^9}, {
   3.514086697400256*^9, 3.514086699865061*^9}, {3.514086914802238*^9, 
   3.514086938202279*^9}, {3.5140873463925962`*^9, 3.5140873475781984`*^9}, {
   3.5140877215576553`*^9, 3.514087740433688*^9}, 3.514087822848633*^9, {
   3.5140884124360685`*^9, 3.5140884475985303`*^9}, {3.514088661974107*^9, 
   3.5140886650161123`*^9}, {3.5141759853368845`*^9, 3.514176084599859*^9}, {
   3.5141994608450356`*^9, 3.5141995249611483`*^9}, {3.51419957127763*^9, 
   3.514199601448083*^9}, {3.514200515999689*^9, 3.5142005179184923`*^9}, 
   3.514200773946142*^9, {3.514201547957102*^9, 3.5142015684711375`*^9}, {
   3.514201805903555*^9, 3.514201844170422*^9}, {3.5142018855416946`*^9, 
   3.5142018886149*^9}, {3.5142021932522354`*^9, 3.514202220645883*^9}, {
   3.5142030790793905`*^9, 3.514203085350602*^9}, {3.5142039163952613`*^9, 
   3.5142039221048717`*^9}, {3.51420421728859*^9, 3.5142042198157945`*^9}, {
   3.514204339312004*^9, 3.514204347533219*^9}, {3.514204529959939*^9, 
   3.5142045360907497`*^9}, {3.5142045920324483`*^9, 3.514204615104889*^9}, {
   3.514204653465356*^9, 3.514204654588558*^9}, {3.51420685870483*^9, 
   3.5142068601244326`*^9}, 3.5142069220565414`*^9, {3.5142069621174116`*^9, 
   3.5142069894174595`*^9}, {3.5142590213682823`*^9, 
   3.5142590395579147`*^9}, {3.5142590862487965`*^9, 3.514259092364007*^9}, {
   3.51425931038999*^9, 3.5142593105771904`*^9}, {3.5144571945141277`*^9, 
   3.5144572015965405`*^9}, {3.5144572924042997`*^9, 
   3.5144572990187116`*^9}, {3.5148977429325547`*^9, 3.5148977436813564`*^9}, 
   3.5148984426873837`*^9, 3.5162947529524*^9, 3.516294788224062*^9, {
   3.5163662145036087`*^9, 3.5163662752501154`*^9}, {3.5164043626066093`*^9, 
   3.5164044245387177`*^9}, {3.516453785881099*^9, 3.516453828975766*^9}, {
   3.516453874036395*^9, 3.516453878593088*^9}, {3.516453910428568*^9, 
   3.516454028718472*^9}, {3.516454124213001*^9, 3.516454182924774*^9}, 
   3.516454253065649*^9, 3.516454347941146*^9, {3.516456397410473*^9, 
   3.516456441165949*^9}, {3.5164565195675144`*^9, 3.516456543746585*^9}, {
   3.5164566374842415`*^9, 3.5164566443170853`*^9}, {3.5164770745396857`*^9, 
   3.5164770748672867`*^9}, {3.5165429006280465`*^9, 3.516542904949254*^9}, {
   3.516569946229577*^9, 3.5165699503635845`*^9}, {3.517061599865655*^9, 
   3.5170616125016775`*^9}, {3.51706187595494*^9, 3.5170618784977446`*^9}, {
   3.517063226858514*^9, 3.5170633058570523`*^9}, {3.5170703955172453`*^9, 
   3.5170704004624543`*^9}, {3.517070804565564*^9, 3.517070809323572*^9}, {
   3.5170709467910137`*^9, 3.5170709533742256`*^9}, {3.5174903001413937`*^9, 
   3.5174903063502045`*^9}, {3.517689469472043*^9, 3.517689550950986*^9}, {
   3.5176896882780275`*^9, 3.517689689276429*^9}, {3.5176911672542253`*^9, 
   3.5176911681278267`*^9}, {3.51769130674967*^9, 3.5176913542205534`*^9}, {
   3.51769603778998*^9, 3.5176960656516285`*^9}, {3.517696144790568*^9, 
   3.517696184617438*^9}, 3.5178619807833433`*^9, {3.51793911442764*^9, 
   3.517939118265247*^9}, {3.5179500546319847`*^9, 3.5179500601855946`*^9}, {
   3.518126702807025*^9, 3.5181267059426303`*^9}, {3.5181934467801127`*^9, 
   3.518193517541837*^9}, {3.5181939664014254`*^9, 3.5181939961506777`*^9}, 
   3.518194055711582*^9, {3.5181948614557977`*^9, 3.5181948959942584`*^9}, {
   3.5181952387736607`*^9, 3.518195280550534*^9}, {3.51819558596787*^9, 
   3.518195595593087*^9}, {3.518195701314473*^9, 3.518195763418182*^9}, {
   3.5181958332907047`*^9, 3.518195850450735*^9}, {3.5181963088731403`*^9, 
   3.5181963243951674`*^9}, {3.518196698574624*^9, 3.5181967651555414`*^9}, {
   3.5182107038668222`*^9, 3.5182108966675615`*^9}, 3.5182109278364162`*^9, {
   3.5182111550976152`*^9, 3.518211156532818*^9}, {3.518226414671212*^9, 
   3.5182264685069065`*^9}, 3.518226566506279*^9, {3.5182270818219843`*^9, 
   3.5182270831479864`*^9}, {3.5183055173275814`*^9, 3.518305596731721*^9}, {
   3.5183056308957815`*^9, 3.5183056355601892`*^9}, {3.518305733169561*^9, 
   3.518305733372361*^9}, {3.518305813462902*^9, 3.518305830513732*^9}, {
   3.5183059149566803`*^9, 3.518305932740711*^9}, {3.5183060540621243`*^9, 
   3.5183060672285476`*^9}, {3.518374119957258*^9, 3.518374194026188*^9}, {
   3.5184630245351477`*^9, 3.518463041835578*^9}, {3.5184640491605473`*^9, 
   3.5184640849002104`*^9}, {3.518464154367132*^9, 3.5184641852395864`*^9}, {
   3.5184643274338365`*^9, 3.5184643350310497`*^9}, {3.5184643827983336`*^9, 
   3.518464527519788*^9}, 3.518464564725853*^9, {3.5184645967839093`*^9, 
   3.5184646636924267`*^9}, {3.5184648473515496`*^9, 
   3.5184648671479845`*^9}, {3.5184649458345222`*^9, 3.5184650727563457`*^9}, 
   3.5184651181524253`*^9, {3.51846516655931*^9, 3.5184651748741245`*^9}, {
   3.5184660252940187`*^9, 3.518466110470168*^9}, {3.51846648162602*^9, 
   3.5184666351770897`*^9}, {3.518466731772459*^9, 3.5184667392916727`*^9}, {
   3.518466884496728*^9, 3.518467039046199*^9}, {3.518467425037677*^9, 
   3.5184674283916826`*^9}, {3.5184674629301434`*^9, 
   3.5184674658317485`*^9}, {3.518467510775428*^9, 3.518467533130267*^9}, {
   3.5184675913027687`*^9, 3.5184676673529024`*^9}, {3.518467725244604*^9, 
   3.5184677488942456`*^9}, {3.5184677992823343`*^9, 
   3.5184678204983716`*^9}, {3.5184679378885775`*^9, 
   3.5184679482313957`*^9}, {3.5184681294413137`*^9, 
   3.5184681456029425`*^9}, {3.5184685770997005`*^9, 3.518468582076109*^9}, {
   3.5184686694362626`*^9, 3.5184686894510975`*^9}, {3.518532313692048*^9, 
   3.5185323264996705`*^9}, 3.518532394141389*^9, {3.518532424686243*^9, 
   3.5185324261214457`*^9}, {3.518532477632736*^9, 3.5185325503600636`*^9}, {
   3.51853258803413*^9, 3.5185325989853487`*^9}, {3.5185327420220003`*^9, 
   3.518532792550489*^9}, {3.518533131913485*^9, 3.5185331334578876`*^9}, {
   3.518533359486685*^9, 3.51853340800277*^9}, {3.5185342794671006`*^9, 
   3.5185343437236137`*^9}, {3.518534450349801*^9, 3.518534452237404*^9}, {
   3.5185347894319963`*^9, 3.5185347928016024`*^9}, {3.5185349983319635`*^9, 
   3.518535175891475*^9}, {3.51853936889524*^9, 3.518539384370467*^9}, {
   3.518539456302193*^9, 3.5185395235071115`*^9}, {3.5185395953140373`*^9, 
   3.518539648432131*^9}, {3.518539686230997*^9, 3.518539688415001*^9}, {
   3.5185397236086626`*^9, 3.5185399295758247`*^9}, {3.5185399888403287`*^9, 
   3.5185400116319685`*^9}, {3.518540128897375*^9, 3.5185401710018487`*^9}, {
   3.518540290716459*^9, 3.5185403243969183`*^9}, {3.518540357328576*^9, 
   3.518540357484576*^9}, {3.5185403936142397`*^9, 3.5185406885327578`*^9}, {
   3.5185407505272665`*^9, 3.5185407971245484`*^9}, {3.5185408547042494`*^9, 
   3.5185409356995916`*^9}, {3.5185411497475677`*^9, 
   3.5185411843640285`*^9}, {3.5185412346117167`*^9, 
   3.5185412777457924`*^9}, {3.5185413079786453`*^9, 3.518541369739154*^9}, {
   3.5185454218185916`*^9, 3.518545442301428*^9}, {3.5185454762314873`*^9, 
   3.518545577475665*^9}, {3.518545915494259*^9, 3.518545992807995*^9}, {
   3.518546069482129*^9, 3.518546095970976*^9}, {3.5185461364998474`*^9, 
   3.518546149104669*^9}, {3.5185462282436085`*^9, 3.5185462476500425`*^9}, {
   3.5185463281773834`*^9, 3.518546345119014*^9}, {3.518546381389077*^9, 
   3.518546461776018*^9}, {3.5185465045980935`*^9, 3.5185465768886204`*^9}, {
   3.5185466213330984`*^9, 3.5185466418471346`*^9}, {3.518546672189188*^9, 
   3.518546674513592*^9}, {3.5185467330448947`*^9, 3.5185468535239067`*^9}, {
   3.518546908670003*^9, 3.51854693511205*^9}, {3.5185469810073304`*^9, 
   3.518547088366719*^9}, {3.5185471238255816`*^9, 3.5185472656454306`*^9}, {
   3.5185474352801285`*^9, 3.5185476231824584`*^9}, {3.518547934356205*^9, 
   3.5185479551354413`*^9}, {3.518548042136794*^9, 3.518548065568035*^9}, {
   3.5185481293877473`*^9, 3.518548202583076*^9}, {3.518548298273644*^9, 
   3.5185482998648467`*^9}, {3.5185483807665887`*^9, 3.518548400204223*^9}, 
   3.5185484632907343`*^9, {3.518548563068509*^9, 3.518548606857786*^9}, {
   3.5185520663726625`*^9, 3.518552101488324*^9}, {3.518635567758929*^9, 
   3.518635567852529*^9}, {3.5187069428182926`*^9, 3.51870703276805*^9}, {
   3.518724708685898*^9, 3.518724711493903*^9}, {3.518979906010905*^9, 
   3.5189799706886187`*^9}, {3.5189811008766036`*^9, 
   3.5189811038874087`*^9}, {3.5194191247087746`*^9, 
   3.5194191297660465`*^9}, {3.5194191740296946`*^9, 
   3.5194192037023616`*^9}, {3.519419235718398*^9, 3.5194193581444387`*^9}, {
   3.519429358994955*^9, 3.51942936191916*^9}, {3.5205139338978443`*^9, 
   3.5205139346466455`*^9}},
 FontSize->16],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"===", "===", "===", "===", "===", 
    RowBox[{"Construct", " ", "neighbor", " ", "vertices"}], "===", "===", "===",
     "===", "===", "===", "===", "===", "==="}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Input", ":", 
     RowBox[{"gobal", " ", "faces"}]}], ",", "iface", ",", 
    RowBox[{
     RowBox[{"inbr", " ", "\[IndentingNewLine]", 
      RowBox[{"Output", ":", 
       RowBox[{
       "nbrverts", " ", "which", " ", "holds", " ", "4", " ", "vertex", " ", 
        "pointers", " ", "This", " ", "routine", " ", "assumes", " ", "that", 
        " ", "the", " ", "patches", " ", "are", " ", "oriented", " ", 
        RowBox[{"ccw", ".", "\[IndentingNewLine]", "nbrverts"}]}]}]}], " ", 
     "=", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"l", "-", "1"}], ",", " ", "l", ",", " ", 
        RowBox[{"l", "+", "1"}], ",", " ", 
        RowBox[{"l", "+", "2"}]}], "}"}], " ", "where", " ", "l", " ", "is", 
      " ", "the", " ", "vertex", " ", "of", " ", "the", " ", "neighboring", 
      " ", "patch", " ", "at", " ", "the", " ", "start", " ", "of", " ", "q", 
      "\[IndentingNewLine]", "l", " ", 
      RowBox[{
       RowBox[{"is", " ", "[", 
        RowBox[{"1", ",", "4"}], "]"}], " ", "--"}], " ", "a", " ", "pointer",
       " ", "into", " ", "the", " ", "faces", " ", "list"}]}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"loadnghbrinfo", "[", 
     RowBox[{"iface_", ",", " ", "nbr_"}], "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"nbrverts", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<loadnghbrinfo: neighbors of neighbor -- faces[nbr,3] = \>\"", 
          ",", 
          RowBox[{"faces", "[", 
           RowBox[{"[", 
            RowBox[{"nbr", ",", "3"}], "]"}], "]"}]}], "]"}], ";"}], " ", 
       "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"faces", "[", 
            RowBox[{"[", 
             RowBox[{"nbr", ",", "3", ",", "ii"}], "]"}], "]"}], " ", 
           "\[Equal]", " ", "iface"}], ",", " ", 
          RowBox[{
           RowBox[{"nbrverts", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "=", "ii"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], ",", " ", 
        RowBox[{
        "Print", "[", "\"\<ERROR: loadnghbrinfo nbrverts[[2]] = 0\>\"", 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nbrverts", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"nbrverts", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", " ", "0"}], ",", 
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "=", "4"}]}], "]"}], ";", "\n", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nbrverts", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"nbrverts", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "+", "1"}]}], ";", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "5"}], ",", 
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "=", "1"}]}], "]"}], ";", "\n", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nbrverts", "[", 
        RowBox[{"[", "4", "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"nbrverts", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "+", "1"}]}], ";", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "5"}], ",", 
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "=", "1"}]}], "]"}], ";", "\n", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<loadnbrinfo: {lm1, l, l+1, l+2} == nbrverts = \>\"", ",", 
          "nbrverts"}], "]"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "nbrverts", "]"}]}], "\n", ")"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.512915951655933*^9, {3.512916052247312*^9, 3.5129161229795256`*^9}, {
   3.512916186223547*^9, 3.5129162080797076`*^9}, {3.5129162823688126`*^9, 
   3.5129163193105593`*^9}, {3.51291650354289*^9, 3.512916561529577*^9}, {
   3.51291674146459*^9, 3.5129167653644032`*^9}, {3.5129168070174713`*^9, 
   3.5129168075010834`*^9}, {3.512916941882929*^9, 3.5129169715236893`*^9}, {
   3.512917039853441*^9, 3.5129170487144685`*^9}, {3.5129171626753902`*^9, 
   3.51291721259667*^9}, {3.512923441050785*^9, 3.512923635213217*^9}, {
   3.5129238836807876`*^9, 3.5129239487812567`*^9}, {3.512924014396539*^9, 
   3.512924018093834*^9}, {3.512924354235653*^9, 3.512924549989472*^9}, {
   3.512924646602749*^9, 3.5129246728270216`*^9}, {3.5129247440896487`*^9, 
   3.5129247520458527`*^9}, {3.5129250194211082`*^9, 3.5129250825559273`*^9}, 
   3.512925112805103*^9, 3.51292532681139*^9, {3.5129273977589035`*^9, 
   3.5129274184450336`*^9}, {3.5129275657128096`*^9, 
   3.5129275713913555`*^9}, {3.5129282681520205`*^9, 3.512928415949016*^9}, {
   3.5129284579296923`*^9, 3.512928458491307*^9}, 3.512928504216079*^9, {
   3.5129362089788656`*^9, 3.5129362233624344`*^9}, {3.5129554414160104`*^9, 
   3.512955441603213*^9}, {3.5129556437262845`*^9, 3.512955658624571*^9}, {
   3.512955706252287*^9, 3.51295572147818*^9}, 3.512956140346235*^9, 
   3.5129561772097435`*^9, {3.5129562095335655`*^9, 3.512956210344781*^9}, {
   3.512956243932227*^9, 3.5129562445406384`*^9}, 3.512994146465104*^9, {
   3.513097410249886*^9, 3.513097457183666*^9}, {3.513097507112224*^9, 
   3.5130975417563405`*^9}, {3.5130976353521404`*^9, 
   3.5130978006423235`*^9}, {3.5130978542891855`*^9, 
   3.5130978847867947`*^9}, {3.513097955391489*^9, 3.513097998446937*^9}, {
   3.513098070119622*^9, 3.5130981031443987`*^9}, {3.5130994801909304`*^9, 
   3.51309948465233*^9}, {3.5140306581817636`*^9, 3.5140306641565742`*^9}, {
   3.514030763622349*^9, 3.514030765244752*^9}, {3.5140820933017693`*^9, 
   3.51408209356697*^9}, {3.514082148135866*^9, 3.514082153252675*^9}, {
   3.514082218117589*^9, 3.51408225874006*^9}, {3.514082430589962*^9, 
   3.514082431525964*^9}, {3.5140824695744305`*^9, 3.514082470432432*^9}, 
   3.5140825602261896`*^9, {3.514082703325241*^9, 3.5140827059148455`*^9}, {
   3.5140835891259966`*^9, 3.5140836127288384`*^9}, {3.5140837394322605`*^9, 
   3.5140837540338864`*^9}, {3.5140863765232925`*^9, 3.514086380080099*^9}, {
   3.514086697400256*^9, 3.514086699865061*^9}, {3.514086914802238*^9, 
   3.514086938202279*^9}, {3.5140873463925962`*^9, 3.5140873475781984`*^9}, {
   3.5140877215576553`*^9, 3.514087740433688*^9}, 3.514087822848633*^9, {
   3.5140884124360685`*^9, 3.5140884475985303`*^9}, {3.514088661974107*^9, 
   3.5140886650161123`*^9}, {3.5141759853368845`*^9, 3.514176084599859*^9}, {
   3.5141994608450356`*^9, 3.5141995249611483`*^9}, {3.51419957127763*^9, 
   3.514199601448083*^9}, {3.514200515999689*^9, 3.5142005179184923`*^9}, 
   3.514200773946142*^9, {3.514201547957102*^9, 3.5142015684711375`*^9}, {
   3.514201805903555*^9, 3.514201844170422*^9}, {3.5142018855416946`*^9, 
   3.5142018886149*^9}, {3.5142021932522354`*^9, 3.514202220645883*^9}, {
   3.5142030790793905`*^9, 3.514203085350602*^9}, {3.5142039163952613`*^9, 
   3.5142039221048717`*^9}, {3.51420421728859*^9, 3.5142042198157945`*^9}, {
   3.514204339312004*^9, 3.514204347533219*^9}, {3.514204529959939*^9, 
   3.5142045360907497`*^9}, {3.5142045920324483`*^9, 3.514204615104889*^9}, {
   3.514204653465356*^9, 3.514204654588558*^9}, {3.51420685870483*^9, 
   3.5142068601244326`*^9}, 3.5142069220565414`*^9, {3.5142069621174116`*^9, 
   3.5142069894174595`*^9}, {3.5142590213682823`*^9, 
   3.5142590395579147`*^9}, {3.5142590862487965`*^9, 3.514259092364007*^9}, {
   3.51425931038999*^9, 3.5142593105771904`*^9}, {3.5144571945141277`*^9, 
   3.5144572015965405`*^9}, {3.5144572924042997`*^9, 
   3.5144572990187116`*^9}, {3.5148977429325547`*^9, 3.5148977436813564`*^9}, 
   3.5148984426873837`*^9, 3.5162947529524*^9, 3.516294788224062*^9, {
   3.5163662145036087`*^9, 3.5163662752501154`*^9}, {3.5164043626066093`*^9, 
   3.5164044245387177`*^9}, {3.516453785881099*^9, 3.516453828975766*^9}, {
   3.516453874036395*^9, 3.516453878593088*^9}, {3.516453910428568*^9, 
   3.516454028718472*^9}, {3.516454124213001*^9, 3.516454182924774*^9}, 
   3.516454253065649*^9, 3.516454347941146*^9, {3.516456397410473*^9, 
   3.516456441165949*^9}, {3.5164565195675144`*^9, 3.516456543746585*^9}, {
   3.5164566374842415`*^9, 3.5164566443170853`*^9}, {3.5164770745396857`*^9, 
   3.5164770748672867`*^9}, {3.5165429006280465`*^9, 3.516542904949254*^9}, {
   3.516569946229577*^9, 3.5165699503635845`*^9}, {3.517061599865655*^9, 
   3.5170616125016775`*^9}, {3.51706187595494*^9, 3.5170618784977446`*^9}, {
   3.517063226858514*^9, 3.5170633058570523`*^9}, {3.5170703955172453`*^9, 
   3.5170704004624543`*^9}, {3.517070804565564*^9, 3.517070809323572*^9}, {
   3.5170709467910137`*^9, 3.5170709533742256`*^9}, {3.5174903001413937`*^9, 
   3.5174903063502045`*^9}, {3.517689469472043*^9, 3.517689550950986*^9}, {
   3.5176896882780275`*^9, 3.517689689276429*^9}, {3.5176911672542253`*^9, 
   3.5176911681278267`*^9}, {3.51769130674967*^9, 3.5176913542205534`*^9}, {
   3.51769603778998*^9, 3.5176960656516285`*^9}, {3.517696144790568*^9, 
   3.517696184617438*^9}, 3.5178619807833433`*^9, {3.51793911442764*^9, 
   3.517939118265247*^9}, {3.5179500546319847`*^9, 3.5179500601855946`*^9}, {
   3.518126702807025*^9, 3.5181267059426303`*^9}, {3.5181934467801127`*^9, 
   3.518193517541837*^9}, {3.5181939664014254`*^9, 3.5181939961506777`*^9}, 
   3.518194055711582*^9, {3.5181948614557977`*^9, 3.5181948959942584`*^9}, {
   3.5181952387736607`*^9, 3.518195280550534*^9}, {3.51819558596787*^9, 
   3.518195595593087*^9}, {3.518195701314473*^9, 3.518195763418182*^9}, {
   3.5181958332907047`*^9, 3.518195850450735*^9}, {3.5181963088731403`*^9, 
   3.5181963243951674`*^9}, {3.518196698574624*^9, 3.5181967651555414`*^9}, {
   3.5182107038668222`*^9, 3.5182108966675615`*^9}, 3.5182109278364162`*^9, {
   3.5182111550976152`*^9, 3.518211156532818*^9}, {3.518226414671212*^9, 
   3.5182264685069065`*^9}, 3.518226566506279*^9, {3.5182270818219843`*^9, 
   3.5182270831479864`*^9}, {3.5183055173275814`*^9, 3.518305596731721*^9}, {
   3.5183056308957815`*^9, 3.5183056355601892`*^9}, {3.518305733169561*^9, 
   3.518305733372361*^9}, {3.518305813462902*^9, 3.518305830513732*^9}, {
   3.5183059149566803`*^9, 3.518305932740711*^9}, {3.5183060540621243`*^9, 
   3.5183060672285476`*^9}, {3.518374119957258*^9, 3.518374194026188*^9}, {
   3.5184630245351477`*^9, 3.518463041835578*^9}, {3.5184640491605473`*^9, 
   3.5184640849002104`*^9}, {3.518464154367132*^9, 3.5184641852395864`*^9}, {
   3.5184643274338365`*^9, 3.5184643350310497`*^9}, {3.5184643827983336`*^9, 
   3.518464527519788*^9}, 3.518464564725853*^9, {3.5184645967839093`*^9, 
   3.5184646636924267`*^9}, {3.5184648473515496`*^9, 
   3.5184648671479845`*^9}, {3.5184649458345222`*^9, 3.5184650727563457`*^9}, 
   3.5184651181524253`*^9, {3.51846516655931*^9, 3.5184651748741245`*^9}, {
   3.5184660252940187`*^9, 3.518466110470168*^9}, {3.51846648162602*^9, 
   3.5184666351770897`*^9}, {3.518466731772459*^9, 3.5184667392916727`*^9}, {
   3.518466884496728*^9, 3.518467039046199*^9}, {3.518467425037677*^9, 
   3.5184674283916826`*^9}, {3.5184674629301434`*^9, 
   3.5184674658317485`*^9}, {3.518467510775428*^9, 3.518467533130267*^9}, {
   3.5184675913027687`*^9, 3.5184676673529024`*^9}, {3.518467725244604*^9, 
   3.5184677488942456`*^9}, {3.5184677992823343`*^9, 
   3.5184678204983716`*^9}, {3.5184679378885775`*^9, 
   3.5184679482313957`*^9}, {3.5184681294413137`*^9, 
   3.5184681456029425`*^9}, {3.5184685770997005`*^9, 3.518468582076109*^9}, {
   3.5184686694362626`*^9, 3.5184686894510975`*^9}, {3.518532313692048*^9, 
   3.5185323264996705`*^9}, 3.518532394141389*^9, {3.518532424686243*^9, 
   3.5185324261214457`*^9}, {3.518532477632736*^9, 3.5185325503600636`*^9}, {
   3.51853258803413*^9, 3.5185325989853487`*^9}, {3.5185327420220003`*^9, 
   3.518532792550489*^9}, {3.518533131913485*^9, 3.5185331334578876`*^9}, {
   3.518533359486685*^9, 3.51853340800277*^9}, {3.5185342794671006`*^9, 
   3.5185343437236137`*^9}, {3.518534450349801*^9, 3.518534452237404*^9}, {
   3.5185347894319963`*^9, 3.5185347928016024`*^9}, {3.5185349983319635`*^9, 
   3.518535175891475*^9}, {3.51853936889524*^9, 3.518539384370467*^9}, {
   3.518539456302193*^9, 3.5185395235071115`*^9}, {3.5185395953140373`*^9, 
   3.518539648432131*^9}, {3.518539686230997*^9, 3.518539688415001*^9}, {
   3.5185397236086626`*^9, 3.5185399295758247`*^9}, {3.5185399888403287`*^9, 
   3.5185400116319685`*^9}, {3.518540128897375*^9, 3.5185401710018487`*^9}, {
   3.518540290716459*^9, 3.5185403243969183`*^9}, {3.518540357328576*^9, 
   3.518540357484576*^9}, {3.5185403936142397`*^9, 3.5185406885327578`*^9}, {
   3.5185407505272665`*^9, 3.5185407971245484`*^9}, {3.5185408547042494`*^9, 
   3.5185409356995916`*^9}, {3.5185411497475677`*^9, 
   3.5185411843640285`*^9}, {3.5185412346117167`*^9, 
   3.5185412777457924`*^9}, {3.5185413079786453`*^9, 3.518541369739154*^9}, {
   3.5185454218185916`*^9, 3.518545442301428*^9}, {3.5185454762314873`*^9, 
   3.518545577475665*^9}, {3.518545915494259*^9, 3.518545992807995*^9}, {
   3.518546069482129*^9, 3.518546095970976*^9}, {3.5185461364998474`*^9, 
   3.518546149104669*^9}, {3.5185462282436085`*^9, 3.5185462476500425`*^9}, {
   3.5185463281773834`*^9, 3.518546345119014*^9}, {3.518546381389077*^9, 
   3.518546461776018*^9}, {3.5185465045980935`*^9, 3.5185465768886204`*^9}, {
   3.5185466213330984`*^9, 3.5185466418471346`*^9}, {3.518546672189188*^9, 
   3.518546674513592*^9}, {3.5185467330448947`*^9, 3.5185468535239067`*^9}, {
   3.518546908670003*^9, 3.51854693511205*^9}, {3.5185469810073304`*^9, 
   3.518547088366719*^9}, {3.5185471238255816`*^9, 3.5185472656454306`*^9}, {
   3.5185474352801285`*^9, 3.5185476231824584`*^9}, {3.518547934356205*^9, 
   3.5185479551354413`*^9}, {3.518548042136794*^9, 3.518548065568035*^9}, {
   3.5185481293877473`*^9, 3.518548202583076*^9}, {3.518548298273644*^9, 
   3.5185482998648467`*^9}, {3.5185483807665887`*^9, 3.518548400204223*^9}, 
   3.5185484632907343`*^9, {3.518548563068509*^9, 3.518548606857786*^9}, {
   3.5185488154145527`*^9, 3.5185488192989593`*^9}, {3.518548849329012*^9, 
   3.5185488871122785`*^9}, {3.5185489774832373`*^9, 
   3.5185489891520576`*^9}, {3.518549086199828*^9, 3.518549088493032*^9}, {
   3.5185491649643664`*^9, 3.5185491662903686`*^9}, {3.5185492878457823`*^9, 
   3.518549299670603*^9}, {3.5185494794765186`*^9, 3.518549481910123*^9}, {
   3.5185540130376816`*^9, 3.518554015440086*^9}, {3.518724717281513*^9, 
   3.5187247610863905`*^9}, {3.519491428433466*^9, 3.519491435173157*^9}, {
   3.519496810051853*^9, 3.519496825694346*^9}, {3.519497420780037*^9, 
   3.519497424475351*^9}, {3.520513921854623*^9, 3.52051392581703*^9}, 
   3.5205142800156517`*^9},
 FontSize->16],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"(*", " ", 
    RowBox[{
    "Construct", " ", "neighbor", " ", "vertices", " ", "for", " ", "a", " ", 
     "neighbor", " ", "that", " ", "is", " ", "a", " ", "tri", " ", "patch"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Input", ":", 
      RowBox[{"gobal", " ", "faces"}]}], ",", "iface", ",", 
     RowBox[{
      RowBox[{"inbr", " ", "\[IndentingNewLine]", 
       RowBox[{"Output", ":", 
        RowBox[{
        "nbrverts", " ", "which", " ", "holds", " ", "4", " ", "vertex", " ", 
         "pointers", " ", "This", " ", "routine", " ", "assumes", " ", "that",
          " ", "the", " ", "patches", " ", "are", " ", "oriented", " ", 
         RowBox[{"ccw", ".", "\[IndentingNewLine]", "nbrverts"}]}]}]}], " ", 
      "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"l", "-", "1"}], ",", " ", "l", ",", " ", 
            RowBox[{"l", "+", "1"}], ",", " ", 
            RowBox[{"l", "+", "2"}]}], "}"}], " ", "where", " ", "l", " ", 
          "is", " ", "the", " ", "vertex", " ", "of", " ", "the", " ", 
          "neighboring", " ", "patch", " ", "at", " ", "the", " ", "start", 
          " ", "of", " ", "q", "\[IndentingNewLine]", "l", " ", 
          RowBox[{
           RowBox[{"is", " ", "[", 
            RowBox[{"1", ",", "4"}], "]"}], " ", "--"}], " ", "a", " ", 
          "pointer", " ", "into", " ", "the", " ", "faces", " ", 
          RowBox[{
           RowBox[{
           "list", "\[IndentingNewLine]", "\[IndentingNewLine]", "--"}], 
           "--"}], " ", "fix", " ", "comment"}], " ", "..."}], " ", "l"}], 
       "+", 
       RowBox[{"2", " ", "is", " ", "same", " ", "as", " ", "l"}], "-", 
       "1"}]}]}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"loadnghbrinfotri", "[", 
      RowBox[{"iface_", ",", " ", "nbr_"}], "]"}], ":=", 
     RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"nbrverts", "=", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"faces", "[", 
             RowBox[{"[", 
              RowBox[{"nbr", ",", "3", ",", "ii"}], "]"}], "]"}], " ", 
            "\[Equal]", " ", "iface"}], ",", " ", 
           RowBox[{
            RowBox[{"nbrverts", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "=", "ii"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "3"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], ",", " ", 
         RowBox[{
         "Print", "[", "\"\<ERROR: loadnghbrinfo nbrverts[[2]] = 0\>\"", 
          "]"}]}], "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nbrverts", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", " ", "0"}], ",", 
         RowBox[{
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "=", "3"}]}], "]"}], ";", "\n", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nbrverts", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "+", "1"}]}], ";", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", "4"}], ",", 
         RowBox[{
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "=", "1"}]}], "]"}], ";", "\n", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nbrverts", "[", 
         RowBox[{"[", "4", "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"nbrverts", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "+", "1"}]}], ";", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "\[Equal]", "4"}], ",", 
         RowBox[{
          RowBox[{"nbrverts", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "=", "1"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "nbrverts", "]"}], ";"}], "\[IndentingNewLine]",
       ")"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]"}]}],
  FontSize->16]], "Input",
 CellChangeTimes->{{3.5194186113606157`*^9, 3.5194186458001375`*^9}, {
   3.5194187347680674`*^9, 3.5194187410470963`*^9}, {3.519418781525301*^9, 
   3.519418781675517*^9}, {3.519418855491659*^9, 3.5194189273850365`*^9}, {
   3.5194742413731213`*^9, 3.519474245368867*^9}, {3.5194794087900677`*^9, 
   3.5194794196256485`*^9}, {3.51947968799154*^9, 3.519479691476551*^9}, {
   3.5194798721763844`*^9, 3.519479875621338*^9}, {3.5194913599650135`*^9, 
   3.5194913681367636`*^9}, {3.5194914661877537`*^9, 
   3.5194914686012244`*^9}, {3.5194968371608343`*^9, 
   3.5194968752956696`*^9}, {3.5194974334282246`*^9, 
   3.5194974383653235`*^9}, {3.519501075635461*^9, 3.5195011152524276`*^9}, {
   3.519501759029843*^9, 3.5195017781086764`*^9}, {3.519510007839939*^9, 
   3.519510041348798*^9}, {3.5200256026473994`*^9, 3.520025678104732*^9}, {
   3.5200306043405857`*^9, 3.520030604590186*^9}, {3.5200319054909*^9, 
   3.5200319057873*^9}, {3.5200972060151854`*^9, 3.52009720832399*^9}, {
   3.5201144149170194`*^9, 3.52011441513542*^9}, {3.52051394305506*^9, 
   3.5205139597470894`*^9}, 3.5206829408882504`*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  StyleBox[
   RowBox[{
    RowBox[{"maketrinet", "[", "iface_", "]"}], " ", ":=", " ", 
    RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"trinet", "  ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"5", ",", "1"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "2"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "3"}], "]"}], "]"}]}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"tt1", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5"}], "]"}], "]"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"trinetu", "  ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"5", ",", "1"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "2"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "3"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"trinetv", "  ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "5"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "3"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "2"}], "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"trinetw", "  ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"5", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "5"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
           RowBox[{"tt1", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"bndrytrisv0", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bndrytrisu0", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", "dd22", ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", " ", "dd23", ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"bndrytrisw0", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", " ", "dd32", ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", " ", 
         RowBox[{"tt1", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     ")"}]}],
   FontSize->16]}]], "Input",
 CellChangeTimes->{{3.5194029371822543`*^9, 3.5194031364688144`*^9}, {
  3.5194031698468094`*^9, 3.5194033742707567`*^9}, {3.5194034441312113`*^9, 
  3.519403518578261*^9}, {3.5194035569934993`*^9, 3.519403618772333*^9}, {
  3.5194125272921553`*^9, 3.519412587168253*^9}, {3.5194127689896994`*^9, 
  3.5194127747579937`*^9}, {3.5194166131773696`*^9, 3.519416613357629*^9}, {
  3.5244227888566785`*^9, 3.5244228044490995`*^9}, {3.5244228408514433`*^9, 
  3.524422852638392*^9}, {3.524423695610526*^9, 3.524423883811146*^9}, {
  3.5244243370128174`*^9, 3.524424341929888*^9}, {3.5244244908039584`*^9, 
  3.5244245318930416`*^9}, {3.5244248281189938`*^9, 3.5244248828877473`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Compute", " ", "the", " ", "partials", " ", "du", " ", "and", " ", "dv", 
    " ", "of", " ", "the", " ", "rectangular", " ", "patch", " ", "at", " ", 
    "the", " ", "edge", " ", "specified"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"iedge", " ", "=", " ", 
    RowBox[{
     RowBox[{"1", " ", 
      RowBox[{"(", 
       RowBox[{"u", ",", 
        RowBox[{"v", "=", "0"}]}], ")"}], "   ", "edge"}], "=", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"u", "=", "1"}], ",", " ", "v"}], ")"}]}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"secantpartialsrec", "[", 
      RowBox[{"iedge_", ",", " ", "param_"}], "]"}], " ", ":=", " ", 
     RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"eps", " ", "=", " ", "0.000000005"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], ",", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"partialdu", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{
                 RowBox[{"param", "+", "eps"}], ",", " ", "0.0"}], "]"}], " ",
                "-", " ", 
               RowBox[{"gquad", "[", 
                RowBox[{"param", ",", " ", "0.0"}], "]"}]}], ")"}], "/", 
             "eps"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"partialdv", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{"param", ",", " ", "eps"}], "]"}], " ", "-", " ", 
               RowBox[{"gquad", "[", 
                RowBox[{"param", ",", " ", "0.0"}], "]"}]}], ")"}], "/", 
             "eps"}]}]}], ")"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"iedge", " ", "\[Equal]", " ", "2"}], ",", " ", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"partialdu", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{"1.0", ",", " ", "param"}], "]"}], " ", "-", " ", 
               RowBox[{"gquad", "[", 
                RowBox[{
                 RowBox[{"1.0", " ", "-", " ", "eps"}], ",", " ", "param"}], 
                "]"}]}], ")"}], "/", "eps"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"partialdv", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{"1.0", ",", " ", 
                 RowBox[{"param", " ", "+", " ", "eps"}]}], "]"}], " ", "-", 
               " ", 
               RowBox[{"gquad", "[", 
                RowBox[{"1.0", ",", " ", "param"}], "]"}]}], ")"}], "/", 
             "eps"}]}]}], ")"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"iedge", " ", "\[Equal]", " ", "3"}], ",", " ", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"partialdu", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{
                 RowBox[{"param", " ", "+", " ", "eps"}], ",", " ", "1.0"}], 
                "]"}], " ", "-", " ", 
               RowBox[{"gquad", "[", 
                RowBox[{"param", ",", " ", "1.0"}], "]"}]}], ")"}], "/", 
             "eps"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"partialdv", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{"param", ",", " ", 
                 RowBox[{"1.0", "-", "eps"}]}], "]"}], " ", "-", " ", 
               RowBox[{"gquad", "[", 
                RowBox[{"param", ",", " ", "1.0"}], "]"}]}], ")"}], "/", 
             "eps"}]}]}], ")"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"iedge", " ", "\[Equal]", " ", "4"}], ",", " ", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"partialdu", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{"eps", ",", " ", "param"}], "]"}], " ", "-", " ", 
               RowBox[{"gquad", "[", 
                RowBox[{"0.0", ",", " ", "param"}], "]"}]}], ")"}], "/", 
             "eps"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"partialdv", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gquad", "[", 
                RowBox[{"0.0", ",", " ", 
                 RowBox[{"param", " ", "+", " ", "eps"}]}], "]"}], " ", "-", 
               " ", 
               RowBox[{"gquad", "[", 
                RowBox[{"0.0", ",", " ", "param"}], "]"}]}], ")"}], "/", 
             "eps"}]}]}], ")"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<secant partial rectangle: iedge=\>\"", ",", "iedge", ",", 
         "\"\<  du = \>\"", ",", "partialdu", ",", "\"\<  dv = \>\"", ",", 
         "partialdv"}], "]"}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ")"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.521812333808608*^9, 3.521812430187194*^9}, {
   3.5218200049992385`*^9, 3.5218200056802177`*^9}, {3.521922733029811*^9, 
   3.5219227685208445`*^9}, {3.5219228109718866`*^9, 
   3.5219228140062494`*^9}, {3.5219228715089345`*^9, 
   3.5219228854289503`*^9}, {3.5219229862238865`*^9, 3.521923005301318*^9}, {
   3.5219230569555936`*^9, 3.521923126004882*^9}, 3.5219231741240735`*^9, {
   3.521923210286072*^9, 3.521923223144562*^9}, {3.521923288328291*^9, 
   3.5219235127710238`*^9}, {3.521923554681288*^9, 3.5219236456020255`*^9}, {
   3.521923677537947*^9, 3.521923917683259*^9}, {3.5219242614375534`*^9, 
   3.5219242623388495`*^9}, {3.521924300984419*^9, 3.521924343765936*^9}, {
   3.521924478669918*^9, 3.5219244793709264`*^9}, {3.521925290677528*^9, 
   3.5219252961754336`*^9}, {3.5219253728857374`*^9, 3.521925411701552*^9}, {
   3.5219255201975613`*^9, 3.521925537031768*^9}, {3.5219259975038943`*^9, 
   3.5219260000675807`*^9}, {3.5219260730024557`*^9, 
   3.5219260795618877`*^9}, {3.5219264058410544`*^9, 3.521926406211587*^9}},
 FontFamily->"Courier New",
 FontSize->16],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Compute", " ", "the", " ", "partials", " ", "du", " ", "and", " ", "dv", 
    " ", "of", " ", "the", " ", "triangular", " ", "patch", " ", "at", " ", 
    "the", " ", "edge", " ", "specified"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", ",", "v"}], ")"}], " ", "origin", " ", "at", " ", 
     RowBox[{"v1", ".", " ", "e1"}], " ", "corresponds", " ", "to", " ", 
     "u"}], "-", 
    RowBox[{
     RowBox[{"dir", ".", " ", "for"}], " ", "e1", " ", "and", " ", "e3", " ", 
     "du", " ", "and", " ", "dv", " ", "are", " ", "consistent", " ", "with", 
     " ", "param", " ", 
     RowBox[{"space", ".", " ", "For"}], " ", "e2", " ", "boundary", " ", 
     "curve", " ", "deriv", " ", "is", " ", "stored", " ", "in", " ", "du", 
     " ", "and", " ", "cross", " ", "bndry", " ", "is", " ", "in", " ", 
     "dv"}]}], "  ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"secantpartialstri", "[", 
      RowBox[{"iedge_", ",", " ", "param_"}], "]"}], " ", ":=", " ", 
     RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"eps", " ", "=", " ", 
        RowBox[{"1.0", "*", 
         RowBox[{"10", "^", 
          RowBox[{"(", 
           RowBox[{"-", "10"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"eps2", " ", "=", " ", 
        RowBox[{"eps", "/", "2"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], ",", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"partialdu", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gtri", "[", 
                RowBox[{
                 RowBox[{"param", "+", "eps"}], ",", " ", "0.0"}], "]"}], " ",
                "-", " ", 
               RowBox[{"gtri", "[", 
                RowBox[{"param", ",", " ", "0.0"}], "]"}]}], ")"}], "/", 
             "eps"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"partialdv", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gtri", "[", 
                RowBox[{
                 RowBox[{"param", "-", "eps2"}], ",", " ", "eps"}], "]"}], 
               " ", "-", " ", 
               RowBox[{"gtri", "[", 
                RowBox[{"param", ",", " ", "0.0"}], "]"}]}], ")"}], "/", 
             "eps"}]}]}], ")"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"iedge", " ", "\[Equal]", " ", "2"}], ",", " ", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"partialdu", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gtri", "[", 
                RowBox[{
                 RowBox[{"param", "-", "eps"}], ",", " ", 
                 RowBox[{"param", "+", "eps"}]}], "]"}], " ", "-", " ", 
               RowBox[{"gtri", "[", 
                RowBox[{"param", ",", " ", "param"}], "]"}]}], ")"}], "/", 
             "eps"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"partialdv", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gtri", "[", 
                RowBox[{
                 RowBox[{"param", "-", "eps2"}], ",", " ", 
                 RowBox[{"param", " ", "-", "eps2"}]}], "]"}], " ", "-", " ", 
               RowBox[{"gtri", "[", 
                RowBox[{"param", ",", " ", "param"}], "]"}]}], ")"}], "/", 
             "eps"}]}]}], ")"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"iedge", " ", "\[Equal]", " ", "3"}], ",", " ", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"partialdu", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gtri", "[", 
                RowBox[{"eps", ",", " ", 
                 RowBox[{"param", "-", "eps2"}]}], "]"}], " ", "-", " ", 
               RowBox[{"gtri", "[", 
                RowBox[{"0.0", ",", " ", "param"}], "]"}]}], ")"}], "/", 
             "eps"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"partialdv", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"gtri", "[", 
                RowBox[{"0.0", ",", " ", 
                 RowBox[{"param", " ", "+", " ", "eps"}]}], "]"}], " ", "-", 
               " ", 
               RowBox[{"gtri", "[", 
                RowBox[{"0.0", ",", " ", "param"}], "]"}]}], ")"}], "/", 
             "eps"}]}]}], ")"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<secant partial triangle: iedge=\>\"", ",", "iedge", ",", 
          "\"\<  du = \>\"", ",", "partialdu", ",", "\"\<  dv = \>\"", ",", 
          "partialdv"}], "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", ")"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5219788890372543`*^9, 3.5219789941383824`*^9}, {
   3.521979435733365*^9, 3.5219794363742867`*^9}, {3.5219794776736717`*^9, 
   3.5219795677932577`*^9}, {3.5220090358662653`*^9, 3.5220090388205137`*^9}, 
   3.5220093342453136`*^9, {3.5220099734344225`*^9, 3.522009978281392*^9}, 
   3.522010062552568*^9, {3.5220101274058228`*^9, 3.5220101275560384`*^9}, 
   3.522010236833171*^9, {3.522069532838363*^9, 3.5220695330386515`*^9}, {
   3.5220697178343744`*^9, 3.5220697397759247`*^9}, {3.5220698380772753`*^9, 
   3.5220698383777075`*^9}, {3.522069925242613*^9, 3.522069925763362*^9}, {
   3.522070004116027*^9, 3.522070006890016*^9}, {3.522092085928114*^9, 
   3.522092088411685*^9}, {3.523041015793245*^9, 3.5230410200693936`*^9}, {
   3.523041167771779*^9, 3.5230411813012333`*^9}, {3.5230416268819475`*^9, 
   3.523041627262494*^9}, {3.523047288963621*^9, 3.523047289043736*^9}, {
   3.523047427012125*^9, 3.5230474281337376`*^9}, {3.5230486371622353`*^9, 
   3.5230486647819505`*^9}, {3.523048733150259*^9, 3.523048770123424*^9}, {
   3.523048808498605*^9, 3.52304880958016*^9}, {3.523048867543507*^9, 
   3.523048876746741*^9}, {3.5231068452131853`*^9, 3.523106918358363*^9}},
 FontFamily->"Courier New",
 FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "\n",
 StyleBox["Color Functions", "Subtitle"]
}], "Section",
 CellChangeTimes->{{3.522239880521682*^9, 3.522239897385931*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"zebracolorfct", "[", "val_", "]"}], " ", ":=", " ", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"onstripe", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"vizeps", " ", "=", " ", "0.05"}], ";", "\[IndentingNewLine]", 
       RowBox[{"isoval", " ", "=", " ", "0.4"}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"val", " ", "\[GreaterEqual]", " ", 
           RowBox[{"(", 
            RowBox[{"isoval", "-", "vizeps"}], ")"}]}], " ", "&&", " ", 
          RowBox[{"val", " ", "\[LessEqual]", " ", 
           RowBox[{"(", 
            RowBox[{"isoval", " ", "+", " ", "vizeps"}], ")"}]}]}], ",", 
         RowBox[{"onstripe", " ", "=", " ", "1"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"isoval", " ", "=", " ", "0.8"}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"val", " ", "\[GreaterEqual]", " ", 
           RowBox[{"(", 
            RowBox[{"isoval", "-", "vizeps"}], ")"}]}], " ", "&&", " ", 
          RowBox[{"val", " ", "\[LessEqual]", " ", 
           RowBox[{"(", 
            RowBox[{"isoval", " ", "+", " ", "vizeps"}], ")"}]}]}], ",", 
         RowBox[{"onstripe", " ", "=", " ", "1"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"isoval", " ", "=", " ", "1.2"}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"val", " ", "\[GreaterEqual]", " ", 
           RowBox[{"(", 
            RowBox[{"isoval", "-", "vizeps"}], ")"}]}], " ", "&&", " ", 
          RowBox[{"val", " ", "\[LessEqual]", " ", 
           RowBox[{"(", 
            RowBox[{"isoval", " ", "+", " ", "vizeps"}], ")"}]}]}], ",", 
         RowBox[{"onstripe", " ", "=", " ", "1"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"onstripe", " ", "\[Equal]", " ", "1"}], ",", " ", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"0", ",", "0", ",", "0"}], "]"}], ",", " ", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"1", ",", "1", ",", "1"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.5129357176058598`*^9, {3.512936024434527*^9, 3.512936058653411*^9}, 
   3.5129435566033216`*^9, {3.512956145463133*^9, 3.5129561470543633`*^9}, 
   3.5129562364440827`*^9, {3.513111355054247*^9, 3.513111360404327*^9}, {
   3.513170323741791*^9, 3.513170326409151*^9}, {3.517861059617326*^9, 
   3.5178610605377274`*^9}, {3.5222398700866766`*^9, 3.522239874152523*^9}, {
   3.5222399389557056`*^9, 3.5222400681514797`*^9}, {3.522240653783578*^9, 
   3.5222406540038943`*^9}, {3.522240771182389*^9, 3.5222407867948384`*^9}, {
   3.5222408815410767`*^9, 3.5222409322139406`*^9}, {3.522241002394856*^9, 
   3.522241002675259*^9}, {3.5222410668575487`*^9, 3.5222410768218765`*^9}, 
   3.522613331317088*^9},
 FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Gregory coefficients computed + graphics",
 FontSize->24]], "Section",
 CellChangeTimes->{{3.514345919991287*^9, 3.5143459344369125`*^9}, 
   3.5143492322983055`*^9, {3.516295183513156*^9, 3.516295187990364*^9}, {
   3.524421995706184*^9, 3.5244219977290926`*^9}},
 FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Run through the input to create a input data plot\>\"",
      "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"u", "-", " ", 
      RowBox[{"and", " ", "v"}], "-", 
      RowBox[{
      "partials", " ", "for", " ", "four", " ", "edges", " ", "of", " ", 
       "each", " ", 
       RowBox[{"face", ".", " ", "If"}], " ", "triangle", " ", "face"}]}], 
     ",", " ", 
     RowBox[{
      RowBox[{"don", "'"}], "t", " ", "use", " ", "fourth", " ", "set"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"checkg1condition", " ", "\[Equal]", " ", "1"}], ",", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"partials", " ", "=", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", "                                   ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", "                                  ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
             "\[IndentingNewLine]", "                                  ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
           ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
       "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Generate", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "input", 
     " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotcmatinput", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotbb1input", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quadpicinput", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotdata", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotfaces", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotnormals", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotbndrypoly", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotbndrycurve", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Process", " ", "each", " ", "face", " ", "to", " ", "create", " ", "a", 
     " ", "display", " ", "list"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "Extract", " ", "the", " ", "number", " ", "of", " ", "edges"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"numedges", " ", "=", " ", 
         RowBox[{"faces", "[", 
          RowBox[{"[", 
           RowBox[{"iface", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           StyleBox[
            RowBox[{
            "\"\<face \>\"", ",", "iface", ",", 
             "\"\<  number of edges = \>\"", ",", 
             RowBox[{"faces", "[", 
              RowBox[{"[", 
               RowBox[{"iface", ",", "1"}], "]"}], "]"}]}],
            FontSize->16], 
           StyleBox["]",
            FontSize->16]}], 
          StyleBox[";",
           FontSize->16]}], 
         StyleBox[" ",
          FontSize->16], 
         StyleBox["*)",
          FontSize->16]}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"numedges", " ", "<", " ", "3"}], " ", "||", " ", 
           RowBox[{"numedges", " ", ">", " ", "4"}]}], ",", " ", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<ERROR -- numfaces out of range -- numfaces=\>\"", ",", 
            "numedges"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "RECTANGLE", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"numedges", " ", "\[Equal]", " ", "4"}], ",", 
          RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"loadbb1patch", "[", "iface", "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<Initial iface=\>\"", ",", "iface", ",", 
                "\"\<   bb1 = \>\"", ",", 
                RowBox[{"MatrixForm", "[", "bb1", "]"}]}], "]"}], ";", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<  cc22=\>\"", ",", "cc22", ",", "\"\< cc23=\>\"", ",", 
                "cc23", ",", "\"\<  cc32=\>\"", ",", "cc32", ",", 
                "\"\<  cc33=\>\"", ",", "cc33"}], "]"}], ";"}], 
             "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"facedata", " ", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "1"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "2"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "3"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "4"}], "]"}], "]"}], "]"}],
                 "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotdata", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "pointsizelarge", "]"}], ",", 
                "colordatapoints", ",", 
                RowBox[{"Point", "[", "facedata", "]"}]}], "}"}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotfaces", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colorpolygon", ",", " ", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", " ", 
                RowBox[{"Line", "[", "facedata", "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
              "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"facenormals", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"nn", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "1"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"nn", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "2"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"nn", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "3"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"nn", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "4"}], "]"}], "]"}], "]"}],
                 "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotnormals", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colornormals", ",", " ", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", " ", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                   RowBox[{
                    RowBox[{"facedata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
                    RowBox[{"normallengthfactor", "*", 
                    RowBox[{"facenormals", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}]}], "}"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                   RowBox[{
                    RowBox[{"facedata", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "+", " ", 
                    RowBox[{"normallengthfactor", "*", 
                    RowBox[{"facenormals", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
                   RowBox[{
                    RowBox[{"facedata", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "+", " ", 
                    RowBox[{"normallengthfactor", "*", 
                    RowBox[{"facenormals", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}]}], "}"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
                   RowBox[{
                    RowBox[{"facedata", "[", 
                    RowBox[{"[", "4", "]"}], "]"}], " ", "+", " ", 
                    RowBox[{"normallengthfactor", "*", 
                    RowBox[{"facenormals", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}]}], "}"}], "]"}]}], 
               "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbb1input", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colorrec1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "bb1"}], "]"}], ",", "colorpolygon", 
                ",", 
                RowBox[{"Thickness", "[", "linewidththin", "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "3"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", "cc22"}], 
                  "}"}], "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", "cc23"}], 
                  "}"}], "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", "cc32"}], 
                  "}"}], "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", "cc33"}], 
                  "}"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"cmat1", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"cc22", ",", "cc23"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"cc32", ",", "cc33"}], "}"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotcmatinput", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colorrec1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "cmat1"}], "]"}]}], "}"}], "]"}]}], 
            ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"boundary", " ", "curves"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"bndry1", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"bndry2", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", " ", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"bndry3", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", " ", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"bndry4", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
               RowBox[{"bb1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbndrypoly", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colorrec1", ",", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", 
                RowBox[{"Line", "[", "bndry1", "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Line", "[", "bndry2", "]"}], ",", 
                RowBox[{"Line", "[", "bndry3", "]"}], ",", 
                RowBox[{"Line", "[", "bndry4", "]"}], ",", 
                "\[IndentingNewLine]", "colorrec1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", " ", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "3"}], "]"}], "]"}]}], "}"}], "]"}]}], 
               "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbndrycurve", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"Black", ",", " ", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", 
                RowBox[{"BezierCurve", "[", "bndry1", "]"}], ",", " ", 
                RowBox[{"BezierCurve", "[", "bndry2", "]"}], ",", " ", 
                RowBox[{"BezierCurve", "[", "bndry3", "]"}], ",", 
                RowBox[{"BezierCurve", "[", "bndry4", "]"}]}], "}"}], "]"}]}],
             ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"rendermethod", " ", "\[Equal]", " ", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"quadpicinput", " ", "[", 
                RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
               "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot3D", "[", 
                RowBox[{
                 RowBox[{"gquad", "[", 
                  RowBox[{"u", ",", "v"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"PlotStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"colorsurface", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "myspecularity"}], "]"}], ",", " ", 
                    RowBox[{"Opacity", "[", "myopacity", "]"}]}], "}"}]}], 
                 ",", 
                 RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}]}], 
             "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"rendermethod", " ", "\[Equal]", " ", "1"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"quadpicinput", " ", "[", 
                RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
               "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot3D", "[", 
                RowBox[{
                 RowBox[{"gquad", "[", 
                  RowBox[{"u", ",", "v"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
                 RowBox[{"PlotPoints", "\[Rule]", "myplotpoints"}], ",", 
                 RowBox[{"ColorFunction", "\[Rule]", 
                  RowBox[{"Function", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "v", ",", "u"}], 
                    "}"}], ",", 
                    RowBox[{"zebracolorfct", "[", "z", "]"}]}], "]"}]}], ",", 
                 RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], 
                "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "plot", " ", "arrows", " ", "on", " ", "first", " ", "patch"}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"iface", " ", "\[Equal]", " ", "1"}], ",", 
              RowBox[{"(", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"axisc1input", "=", 
                 RowBox[{"Graphics3D", "[", 
                  RowBox[{"{", 
                   RowBox[{"Green", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"cc22", ",", "cc23"}], "}"}], "]"}]}], "}"}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"axisbb1input", "=", 
                 RowBox[{"Graphics3D", "[", 
                  RowBox[{"{", 
                   RowBox[{"Red", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}]}], 
                   "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", ")"}]}], 
             "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "Get", " ", "partials", " ", "to", " ", "check", " ", "G1", " ", 
              "condition"}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"checkg1condition", " ", "\[Equal]", " ", "1"}], ",", 
              RowBox[{"(", "\[IndentingNewLine]", 
               RowBox[{"Do", "[", 
                RowBox[{
                 RowBox[{"(", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"nbr", "=", 
                    RowBox[{"faces", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "3", ",", "iedge"}], "]"}], "]"}]}],
                    ";", "\[IndentingNewLine]", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"nbr", " ", "\[NotEqual]", " ", "0"}], ",", 
                    RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    "store", " ", "partials", " ", "at", " ", "this", " ", 
                    "edge"}], " ", "*)"}], "\[IndentingNewLine]", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "0.0"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "1.0"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "1.0"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "4"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.0"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", " ", 
                    RowBox[{"gotpartial", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"1", ",", "0"}], "]"}], "[", "gquad", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"(", 
                    RowBox[{"gotpartial", "/", 
                    RowBox[{"Norm", "[", "gotpartial", "]"}]}], ")"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"gotpartial", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"0", ",", "1"}], "]"}], "[", "gquad", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"(", 
                    RowBox[{"gotpartial", "/", 
                    RowBox[{"Norm", "[", "gotpartial", "]"}]}], ")"}]}], 
                    ";"}], "\[IndentingNewLine]", 
                    RowBox[{"(*", "  ", 
                    RowBox[{
                    RowBox[{
                    "Derivative", " ", "command", " ", "works", " ", "well", 
                    " ", "for", " ", "rectangle", " ", "patches", 
                    "\[IndentingNewLine]", 
                    RowBox[{"secantpartialsrec", "[", 
                    RowBox[{"iedge", ",", " ", "0.5"}], "]"}]}], ";", " ", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", "partialdu"}], ";", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", "partialdv"}], ";"}], 
                    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
                    "\[IndentingNewLine]", ")"}]}], "]"}]}], 
                  "\[IndentingNewLine]", ")"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"iedge", ",", "1", ",", "4"}], "}"}]}], "]"}], 
               "\[IndentingNewLine]", ")"}]}], "]"}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{"if", " ", "checkg1"}], " ", "*)"}], 
           "\[IndentingNewLine]", ")"}]}], "]"}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"If", " ", "numedges"}], " ", "=", " ", "4"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "TRIANGLE", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"numedges", " ", "\[Equal]", " ", "3"}], ",", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"loadpatchtricase", "[", "iface", "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"facedata", " ", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "1"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "2"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "3"}], "]"}], "]"}], "]"}],
                 "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotdata", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colordatapoints", ",", 
                RowBox[{"PointSize", "[", "pointsizelarge", "]"}], ",", 
                RowBox[{"Point", "[", "facedata", "]"}]}], "}"}], "]"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotfaces", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colorpolygon", ",", " ", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", " ", 
                RowBox[{"Line", "[", "facedata", "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
              "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"facenormals", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"nn", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "1"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"nn", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "2"}], "]"}], "]"}], "]"}],
                 "]"}], ",", " ", 
               RowBox[{"nn", "[", 
                RowBox[{"[", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "2", ",", "3"}], "]"}], "]"}], "]"}],
                 "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotnormals", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colornormals", ",", " ", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", " ", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                   RowBox[{
                    RowBox[{"facedata", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
                    RowBox[{"normallengthfactor", "*", 
                    RowBox[{"facenormals", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}]}], "}"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                   RowBox[{
                    RowBox[{"facedata", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "+", " ", 
                    RowBox[{"normallengthfactor", "*", 
                    RowBox[{"facenormals", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"facedata", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
                   RowBox[{
                    RowBox[{"facedata", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "+", " ", 
                    RowBox[{"normallengthfactor", "*", 
                    RowBox[{"facenormals", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}]}], "}"}], "]"}]}], 
               "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"maketrinet", "[", "iface", "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbb1input", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colortri1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", " ", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "trinet"}], "]"}], ",", "colorpolygon",
                 ",", " ", 
                RowBox[{"Thickness", "[", "linewidththin", "]"}], ",", 
                RowBox[{"Line", "[", "bndrytrisu0", "]"}], ",", 
                RowBox[{"Line", "[", "bndrytrisv0", "]"}], ",", 
                RowBox[{"Line", "[", "bndrytrisw0", "]"}]}], "}"}], "]"}]}], 
            ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"dmat1", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
              "dd22", ",", " ", "dd32", ",", " ", "dd23", ",", " ", "dd22"}], 
              "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotcmatinput", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colortri1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "dmat1"}], "]"}], ",", "colorpolygon", 
                ",", 
                RowBox[{"Thickness", "[", "linewidththin", "]"}]}], "}"}], 
              "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"boundary", " ", "curves"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"bndry1", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"5", ",", "1"}], "]"}], "]"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"bndry2", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"5", ",", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "5"}], "]"}], "]"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"bndry3", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", " ", 
               RowBox[{"tt1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "5"}], "]"}], "]"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbndrypoly", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colortri1", ",", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"5", ",", "1"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "5"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"5", ",", "1"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "5"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", "\[IndentingNewLine]", "colortri1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", " ", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "1"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"5", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "5"}], "]"}], "]"}], ",", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", " ", 
                   RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "4"}], "]"}], "]"}]}], "}"}], "]"}]}], 
               "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbndrycurve", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], " ", "=", " ", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"Black", ",", " ", 
                RowBox[{"Thickness", "[", "linewidththick", "]"}], ",", 
                RowBox[{"BezierCurve", "[", 
                 RowBox[{"bndry1", ",", " ", 
                  RowBox[{"SplineDegree", "\[Rule]", "4"}]}], "]"}], ",", " ", 
                RowBox[{"BezierCurve", "[", 
                 RowBox[{"bndry2", ",", " ", 
                  RowBox[{"SplineDegree", "\[Rule]", "4"}]}], "]"}], ",", " ", 
                RowBox[{"BezierCurve", "[", 
                 RowBox[{"bndry3", ",", " ", 
                  RowBox[{"SplineDegree", "\[Rule]", "4"}]}], "]"}]}], "}"}], 
              "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{
              "Problems", " ", "with", " ", "this", " ", "on", " ", "w", " ", 
               "edge", "\[IndentingNewLine]", "RegionFunction"}], "\[Rule]", 
              RowBox[{"Function", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "z", ",", "u", ",", "v"}], "}"}],
                 ",", " ", 
                RowBox[{"0", " ", "<=", " ", 
                 RowBox[{"u", "+", "v"}], " ", "<=", " ", "1.0"}]}], "]"}]}], 
             "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"rendermethod", " ", "\[Equal]", " ", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"quadpicinput", " ", "[", 
                RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
               "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot3D", "[", 
                RowBox[{
                 RowBox[{"gtri", "[", 
                  RowBox[{"u", ",", "v"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"v", ",", "0.0", ",", " ", "1.0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "0.0", ",", 
                   RowBox[{"1.0", "-", "v"}]}], "}"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
                 RowBox[{"PlotStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"colorsurface", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "myspecularity"}], "]"}], ",", 
                    RowBox[{"Opacity", "[", "myopacity", "]"}]}], "}"}]}]}], 
                "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"rendermethod", " ", "\[Equal]", " ", "1"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"quadpicinput", " ", "[", 
                RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
               "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot3D", "[", 
                RowBox[{
                 RowBox[{"gtri", "[", 
                  RowBox[{"u", ",", "v"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"v", ",", "0.0", ",", " ", "1.0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "0.0", ",", 
                   RowBox[{"1.0", "-", "v"}]}], "}"}], ",", 
                 RowBox[{"Mesh", "->", "False"}], ",", 
                 RowBox[{"PlotPoints", "\[Rule]", "myplotpoints"}], ",", 
                 RowBox[{"ColorFunction", "\[Rule]", 
                  RowBox[{"Function", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "v", ",", "u"}], 
                    "}"}], ",", 
                    RowBox[{"zebracolorfct", "[", "z", "]"}]}], "]"}]}], ",", 
                 RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], 
                "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"Function", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "z", ",", "v", ",", "u"}], "}"}],
                 ",", 
                RowBox[{
                 RowBox[{"ColorData", "[", "\"\<DarkBands\>\"", "]"}], "[", 
                 RowBox[{"z", "/", "1.6"}], "]"}]}], "]"}]}], " ", "*)"}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "plot", " ", "arrows", " ", "on", " ", "first", " ", "patch"}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"iface", " ", "\[Equal]", " ", "1"}], ",", 
               RowBox[{"(", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"axisc1input", "=", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{"{", 
                    RowBox[{"Green", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"dd22", ",", "dd23"}], "}"}], "]"}]}], "}"}], 
                   "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{"axisbb1input", "=", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}]}], 
                    "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", ")"}]}], 
              "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Get", " ", "partials", " ", "to", " ", "check", " ", "G1", " ",
                "condition"}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"checkg1condition", " ", "\[Equal]", " ", "1"}], ",", 
               " ", 
               RowBox[{"(", "\[IndentingNewLine]", 
                RowBox[{"Do", "[", 
                 RowBox[{
                  RowBox[{"(", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"nbr", "=", 
                    RowBox[{"faces", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "3", ",", "iedge"}], "]"}], "]"}]}],
                     ";", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"nbr", " ", "\[NotEqual]", " ", "0"}], ",", 
                    RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    "store", " ", "partials", " ", "at", " ", "this", " ", 
                    "edge"}], " ", "*)"}], "\[IndentingNewLine]", 
                    RowBox[{"(*", " ", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "0.0"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.0"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", " ", 
                    RowBox[{"gotpartial", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"1", ",", "0"}], "]"}], "[", "gtri", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", "gotpartial"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"gotpartial", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"0", ",", "1"}], "]"}], "[", "gtri", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", "gotpartial"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<Derivative tri: iedge=\>\"", ",", "iedge", ",", 
                    "\"\<  du=\>\"", ",", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    ",", "\"\<  dv=\>\"", ",", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}]}],
                     "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"secantpartialstri", "[", 
                    RowBox[{"iedge", ",", " ", "0.5"}], "]"}], ";", " ", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"(", 
                    RowBox[{"partialdu", "/", 
                    RowBox[{"Norm", "[", "partialdu", "]"}]}], ")"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"partialdv", "/", 
                    RowBox[{"Norm", "[", "partialdv", "]"}]}]}], ";"}], 
                    "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], 
                   "\[IndentingNewLine]", ")"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"iedge", ",", "1", ",", "3"}], "}"}]}], "]"}], 
                "\[IndentingNewLine]", ")"}]}], "]"}]}]}], " ", 
           RowBox[{"(*", " ", 
            RowBox[{"if", " ", "checkg1"}], " ", "*)"}], 
           "\[IndentingNewLine]", ")"}]}], "]"}]}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"if", " ", "triangle", " ", "case"}], " ", "*)"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"iface", ",", "1", ",", "nfaces"}], "}"}]}], "]"}], ";"}], 
   "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Check", " ", "G1", " ", "conditions", " ", "across", " ", "faces"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"checkg1condition", " ", "\[Equal]", " ", "1"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
        "Print", "[", 
         "\"\<Check G1 conditions **before ** G1 modifications \>\"", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Partials = \>\"", ",", "partials"}], "]"}], ";"}], 
         " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"numedges", " ", "=", " ", 
             RowBox[{"faces", "[", 
              RowBox[{"[", 
               RowBox[{"iface", ",", "1"}], "]"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Do", "[", 
             RowBox[{
              RowBox[{"(", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"nbr", "=", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "3", ",", "iedge"}], "]"}], "]"}]}], 
                ";", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"nbr", " ", ">", " ", "iface"}], ",", 
                  RowBox[{"(", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"numedgesnbr", " ", "=", " ", 
                    RowBox[{"faces", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "1"}], "]"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"numedgesnbr", " ", "\[Equal]", " ", "4"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"loadnghbrinfo", "[", 
                    RowBox[{"iface", ",", " ", "nbr"}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"loadnghbrinfotri", "[", 
                    RowBox[{"iface", ",", "nbr"}], "]"}]}], 
                    "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"nbredge", " ", "=", " ", 
                    RowBox[{"nbrverts", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"numedges", " ", "\[Equal]", " ", "4"}], ",", 
                    RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], " ", "||", 
                    " ", 
                    RowBox[{"iedge", " ", "\[Equal]", " ", "3"}]}], ",", 
                    RowBox[{"iacross", "=", "2"}], ",", " ", 
                    RowBox[{"iacross", "=", "1"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"volume", " ", "=", " ", 
                    RowBox[{"Det", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "iacross"}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "nbredge", ",", "1"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "nbredge", ",", "2"}], "]"}], "]"}]}],
                     "}"}], "]"}]}]}], ")"}], ",", "\[IndentingNewLine]", 
                    "\[IndentingNewLine]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], " ", "||", 
                    " ", 
                    RowBox[{"iedge", " ", "\[Equal]", " ", "2"}]}], ",", 
                    RowBox[{"iacross", "=", "2"}], ",", " ", 
                    RowBox[{"iacross", "=", "1"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"volume", " ", "=", " ", 
                    RowBox[{"Det", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "iacross"}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "nbredge", ",", "1"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "nbredge", ",", "2"}], "]"}], "]"}]}],
                     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", ")"}]}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"(*", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<Main: Face #\>\"", ",", "iface", ",", 
                    "\"\<  iedge=\>\"", ",", "iedge", ",", 
                    "\"\< u-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "iface", "]"}], "]"}], "[", 
                    RowBox[{"[", "iedge", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    "\"\<  v-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "iface", "]"}], "]"}], "[", 
                    RowBox[{"[", "iedge", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<Main: Face #\>\"", ",", "nbr", ",", 
                    "\"\<  nbredge=\>\"", ",", "nbredge", ",", 
                    "\"\< u-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    "\"\<  v-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], 
                    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<                   Across face \>\"", ",", "iface", 
                    ",", "\"\< and face\>\"", ",", "nbr", ",", 
                    "\"\< is it G1 at mid-param of edge?  volume of partials \
= \>\"", ",", "volume"}], "]"}], ";"}], "\[IndentingNewLine]", 
                   "\[IndentingNewLine]", ")"}]}], "]"}]}], " ", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"if", " ", "nbrface", " ", "index"}], " ", ">", " ", 
                 RowBox[{"current", " ", "face", " ", "index"}]}], " ", 
                "*)"}], "\[IndentingNewLine]", ")"}], ",", 
              RowBox[{"{", 
               RowBox[{"iedge", ",", "1", ",", "numedges"}], "}"}]}], "]"}]}],
            "\[IndentingNewLine]", ")"}], ",", 
          RowBox[{"{", 
           RowBox[{"iface", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"if", " ", "checkg1"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
      "===", "===", "===", "===", "===", "===", "===", "===", "===", 
     "\[Equal]"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
      "===", "===", "===", "===", "===", "===", "===", "===", "===", 
     "\[Equal]"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
      "===", "===", "===", "===", "===", "===", "===", "===", "===", 
     "\[Equal]"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
      "===", "===", "===", "===", "===", "===", "===", "===", "===", 
     "\[Equal]"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Run the the data to do G1 correction \>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Now", " ", "do", " ", "the", " ", "correction", " ", "and", " ", 
     "generate", " ", "a", " ", "plot"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotcmat1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotbb1", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"quadpic1", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "nfaces"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "Extract", " ", "the", " ", "number", " ", "of", " ", "edges"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"numedges", " ", "=", " ", 
         RowBox[{"faces", "[", 
          RowBox[{"[", 
           RowBox[{"iface", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           StyleBox[
            RowBox[{
            "\"\<face \>\"", ",", "iface", ",", 
             "\"\<  number of edges = \>\"", ",", 
             RowBox[{"faces", "[", 
              RowBox[{"[", 
               RowBox[{"iface", ",", "1"}], "]"}], "]"}]}],
            FontSize->16], 
           StyleBox["]",
            FontSize->16]}], 
          StyleBox[";",
           FontSize->16]}], 
         StyleBox[" ",
          FontSize->16], 
         StyleBox["*)",
          FontSize->16]}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"numedges", " ", "<", " ", "3"}], " ", "||", " ", 
           RowBox[{"numedges", " ", ">", " ", "4"}]}], ",", " ", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<ERROR -- numfaces out of range -- numfaces=\>\"", ",", 
            "numedges"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "RECTANGLE", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"numedges", " ", "\[Equal]", " ", "4"}], ",", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"loadbb1patch", "[", "iface", "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Do", "[", 
             RowBox[{
              RowBox[{"(", "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"Print", "[", 
                  RowBox[{
                  "\"\<Main: Face #\>\"", ",", "iface", ",", 
                   "\"\<  iedge=\>\"", ",", "iedge"}], "]"}], ";"}], " ", 
                "*)"}], "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                "Extract", " ", "the", " ", "neighbor", " ", "across", " ", 
                 "edge"}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"nbr", "=", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "3", ",", "iedge"}], "]"}], "]"}]}], 
                ";", "\[IndentingNewLine]", 
                RowBox[{"(*", " ", 
                 RowBox[{
                  RowBox[{"Print", "[", 
                   RowBox[{"\"\<Main: nbr = \>\"", ",", "nbr"}], "]"}], ";"}],
                  " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"nbr", " ", "\[NotEqual]", " ", "0"}], ",", 
                  RowBox[{"(", "\[IndentingNewLine]", 
                   RowBox[{"(*", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<       Face #\>\"", ",", "iface", ",", 
                    "\"\<  iedge=\>\"", ",", "iedge", ",", "\"\< nbr=\>\"", 
                    ",", "nbr", ",", "\"\<  Computing G1 condition\>\""}], 
                    "]"}], ";"}], " ", "\[IndentingNewLine]", "*)"}], 
                   "\[IndentingNewLine]", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"numedgesnbr", " ", "=", " ", 
                    RowBox[{"faces", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "1"}], "]"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"loadG1input", "[", 
                    RowBox[{"iface", ",", " ", "iedge", ",", " ", "nbr"}], 
                    "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"p", "=", 
                    RowBox[{"interiorG1", "[", 
                    RowBox[{
                    "q", ",", "topl", ",", "topr", ",", "botl", ",", "botr", 
                    ",", " ", "numedges", ",", " ", "numedgesnbr"}], "]"}]}], 
                    " ", ";", "\[IndentingNewLine]", 
                    RowBox[{"loadG1output", "[", 
                    RowBox[{"iedge", ",", "p"}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    "store", " ", "partials", " ", "at", " ", "this", " ", 
                    "edge"}], " ", "*)"}], "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"checkg1condition", " ", "\[Equal]", " ", "1"}], 
                    ",", " ", 
                    RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "0.0"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "1.0"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "1.0"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "4"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.0"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", " ", 
                    RowBox[{"gotpartial", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"1", ",", "0"}], "]"}], "[", "gquad", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"gotpartial", "/", 
                    RowBox[{"Norm", "[", "gotpartial", "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"gotpartial", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"0", ",", "1"}], "]"}], "[", "gquad", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"gotpartial", "/", 
                    RowBox[{"Norm", "[", "gotpartial", "]"}]}]}], ";"}], 
                    "\[IndentingNewLine]", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"for", " ", "rectangles"}], ",", " ", 
                    RowBox[{
                    "Derivative", " ", "seems", " ", "to", " ", "work", " ", 
                    "fine"}]}], " ", "*)"}], "\[IndentingNewLine]", 
                    RowBox[{"(*", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"secantpartialsrec", "[", 
                    RowBox[{"iedge", ",", " ", "0.5"}], "]"}], ";", " ", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", "partialdu"}], ";", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", "partialdv"}], ";"}], 
                    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
                    ")"}]}], "]"}]}], "\[IndentingNewLine]", " ", 
                   RowBox[{"(*", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\<Main: Updated bb1 = \>\"", ",", 
                    RowBox[{"MatrixForm", "[", "bb1", "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "   ", 
                    RowBox[{
                    "Print", "[", "\"\<Main: check updates to cc  \>\"", 
                    "]"}], ";", "\[IndentingNewLine]", "  ", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<  cc22=\>\"", ",", "cc22", ",", "\"\< cc23=\>\"", 
                    ",", "cc23", ",", "\"\<  cc32=\>\"", ",", "cc32", ",", 
                    "\"\<  cc33=\>\"", ",", "cc33"}], "]"}], ";"}], 
                    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
                   ")"}]}], "]"}]}], " ", 
               RowBox[{"(*", " ", 
                RowBox[{"nbr", " ", "<>", " ", "0"}], " ", "*)"}], 
               "\[IndentingNewLine]", ")"}], ",", 
              RowBox[{"{", 
               RowBox[{"iedge", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{"\"\<Main: All done with patch   bb1 = \>\"", ",", 
                RowBox[{"MatrixForm", "[", "bb1", "]"}]}], "]"}], ";", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<  cc22=\>\"", ",", "cc22", ",", "\"\< cc23=\>\"", ",", 
                "cc23", ",", "\"\<  cc32=\>\"", ",", "cc32", ",", 
                "\"\<  cc33=\>\"", ",", "cc33"}], "]"}], ";"}], 
             "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "plot", " ", "arrows", " ", "on", " ", "first", " ", "patch"}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"iface", " ", "\[Equal]", " ", "1"}], ",", 
              RowBox[{"(", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"axisc1", "=", 
                 RowBox[{"Graphics3D", "[", 
                  RowBox[{"{", 
                   RowBox[{"Green", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"cc22", ",", "cc23"}], "}"}], "]"}]}], "}"}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"axisbb1", "=", 
                 RowBox[{"Graphics3D", "[", 
                  RowBox[{"{", 
                   RowBox[{"Red", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}]}], 
                   "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", ")"}]}], 
             "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbb1", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colorrec1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "bb1"}], "]"}], ",", "colorpolygon", 
                ",", " ", 
                RowBox[{"Thickness", "[", "linewidththin", "]"}], ",", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "1"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", 
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"3", ",", "3"}], "]"}], "]"}]}], "}"}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", "cc22"}], 
                  "}"}], "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", "cc23"}], 
                  "}"}], "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "2"}], "]"}], "]"}], ",", "cc32"}], 
                  "}"}], "]"}], ",", " ", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"bb1", "[", 
                    RowBox[{"[", 
                    RowBox[{"4", ",", "3"}], "]"}], "]"}], ",", "cc33"}], 
                  "}"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"cmat1", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"cc22", ",", "cc23"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"cc32", ",", "cc33"}], "}"}]}], "}"}]}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotcmat1", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colorrec1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "cmat1"}], "]"}]}], "}"}], "]"}]}], 
            ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"rendermethod", " ", "\[Equal]", " ", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"quadpic1", " ", "[", 
                RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
               "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot3D", "[", 
                RowBox[{
                 RowBox[{"gquad", "[", 
                  RowBox[{"u", ",", "v"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"PlotStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"colorsurface", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "myspecularity"}], "]"}], ",", 
                    RowBox[{"Opacity", "[", "myopacity", "]"}]}], "}"}]}], 
                 ",", 
                 RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}]}], 
             "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"rendermethod", " ", "\[Equal]", " ", "1"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"quadpic1", " ", "[", 
                 RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
                "\[IndentingNewLine]", 
                RowBox[{"ParametricPlot3D", "[", 
                 RowBox[{
                  RowBox[{"gquad", "[", 
                   RowBox[{"u", ",", "v"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
                  RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
                  RowBox[{"PlotPoints", "\[Rule]", "myplotpoints"}], ",", 
                  RowBox[{"ColorFunction", "\[Rule]", 
                   RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "v", ",", "u"}], 
                    "}"}], ",", 
                    RowBox[{"zebracolorfct", "[", "z", "]"}]}], "]"}]}], ",", 
                  RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], 
                 "]"}]}]}], "\[IndentingNewLine]", "]"}], 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{
                RowBox[{"ColorFunction", "\[Rule]", 
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "v", ",", "u"}], 
                    "}"}], ",", 
                   RowBox[{
                    RowBox[{"ColorData", "[", "\"\<DarkBands\>\"", "]"}], "[", 
                    RowBox[{"z", "/", "1.6"}], "]"}]}], "]"}]}], ",", 
                RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}],
               " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"quadrefcurve", "=", 
                RowBox[{"ParametricPlot", "[", 
                 RowBox[{
                  RowBox[{"quadrefline", "[", 
                   RowBox[{
                   "l1_", ",", "l2_", ",", "t_", ",", "bb_", ",", "c22_", ",",
                     "c23_", ",", "c32_", ",", "c33_"}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}],
               "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
             "\[IndentingNewLine]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"quad1", "=", "bb1"}], ";", "\[IndentingNewLine]", 
               RowBox[{"quad2", "=", " ", 
                RowBox[{"{", 
                 RowBox[{"cc22", ",", " ", "cc23", ",", "cc32", ",", "cc33"}],
                  "}"}]}], ";"}], ")"}]}]}], "\[IndentingNewLine]", ")"}]}], 
         "]"}], ";", " ", 
        RowBox[{"(*", " ", 
         RowBox[{"rectangle", " ", "case"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "TRIANGLE", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"numedges", " ", "\[Equal]", " ", "3"}], ",", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"loadpatchtricase", "[", "iface", "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{"\"\<Main: Initialized tri patch   tt1 = \>\"", ",", 
                RowBox[{"MatrixForm", "[", "tt1", "]"}]}], "]"}], ";", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<  dd22=\>\"", ",", "dd22", ",", "\"\< dd23=\>\"", ",", 
                "dd23", ",", "\"\<  dd32=\>\"", ",", "dd32"}], "]"}], ";"}], 
             "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"Do", "[", 
             RowBox[{
              RowBox[{"(", "\[IndentingNewLine]", 
               RowBox[{"(*", " ", 
                RowBox[{
                 RowBox[{"Print", "[", 
                  RowBox[{
                  "\"\<Main: Face #\>\"", ",", "iface", ",", 
                   "\"\<  iedge=\>\"", ",", "iedge"}], "]"}], ";"}], " ", 
                "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                "Extract", " ", "the", " ", "neighbor", " ", "across", " ", 
                 "edge"}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"nbr", "=", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "3", ",", "iedge"}], "]"}], "]"}]}], 
                ";", "\[IndentingNewLine]", 
                RowBox[{"(*", " ", 
                 RowBox[{
                  RowBox[{"Print", "[", 
                   RowBox[{"\"\<Main: nbr = \>\"", ",", "nbr"}], "]"}], ";"}],
                  " ", "*)"}], " ", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"nbr", " ", "\[NotEqual]", " ", "0"}], ",", 
                  RowBox[{"(", "\[IndentingNewLine]", 
                   RowBox[{"(*", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<       Face #\>\"", ",", "iface", ",", 
                    "\"\<  iedge=\>\"", ",", "iedge", ",", "\"\< nbr=\>\"", 
                    ",", "nbr", ",", "\"\<  Computing G1 condition\>\""}], 
                    "]"}], ";"}], " ", "\[IndentingNewLine]", "*)"}], 
                   "\[IndentingNewLine]", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"numedgesnbr", " ", "=", " ", 
                    RowBox[{"faces", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "1"}], "]"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"loadG1inputtri", "[", 
                    RowBox[{"iface", ",", " ", "iedge", ",", " ", "nbr"}], 
                    "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"p", "=", 
                    RowBox[{"interiorG1", "[", 
                    RowBox[{
                    "q", ",", "topl", ",", "topr", ",", "botl", ",", "botr", 
                    ",", " ", "numedges", ",", " ", "numedgesnbr"}], "]"}]}], 
                    " ", ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"loadG1outputtri", "[", 
                    RowBox[{"iedge", ",", "p"}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    "store", " ", "partials", " ", "at", " ", "this", " ", 
                    "edge"}], " ", "*)"}], "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"checkg1condition", " ", "\[Equal]", " ", "1"}], 
                    ",", " ", 
                    RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{"(*", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "0.0"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.5"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{"uu", "=", "0.0"}], ";", " ", 
                    RowBox[{"vv", "=", "0.5"}]}]}], "]"}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
                    RowBox[{"gotpartial", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"1", ",", "0"}], "]"}], "[", "gtri", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", "gotpartial"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"gotpartial", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Derivative", "[", 
                    RowBox[{"0", ",", "1"}], "]"}], "[", "gtri", "]"}], "[", 
                    RowBox[{"uu", ",", "vv"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", "gotpartial"}], ";", "\[IndentingNewLine]",
                     "\[IndentingNewLine]", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<Derivative tri: iedge=\>\"", ",", "iedge", ",", 
                    "\"\<  du=\>\"", ",", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    ",", "\"\<  dv=\>\"", ",", 
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}]}],
                     "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"secantpartialstri", "[", 
                    RowBox[{"iedge", ",", " ", "0.5"}], "]"}], ";", " ", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "1"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"partialdu", "/", 
                    RowBox[{"Norm", "[", "partialdu", "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", 
                    RowBox[{"iface", ",", "iedge", ",", "2"}], "]"}], "]"}], 
                    " ", "=", " ", 
                    RowBox[{"partialdv", "/", 
                    RowBox[{"Norm", "[", "partialdv", "]"}]}]}], ";"}], 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], 
                    "]"}]}], "\[IndentingNewLine]", ")"}]}], "]"}]}], " ", 
               RowBox[{"(*", " ", 
                RowBox[{"nbr", " ", "<>", " ", "0"}], " ", "*)"}], 
               "\[IndentingNewLine]", ")"}], ",", 
              RowBox[{"{", 
               RowBox[{"iedge", ",", "1", ",", "3"}], "}"}]}], "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{"\"\<Main: All done with patch   tt1 = \>\"", ",", 
                RowBox[{"MatrixForm", "[", "tt1", "]"}]}], "]"}], ";", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{
               "\"\<  dd22=\>\"", ",", "dd22", ",", "\"\< dd23=\>\"", ",", 
                "dd23", ",", "\"\<  dd32=\>\"", ",", "dd32"}], "]"}], ";"}], 
             "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"maketrinet", "[", "iface", "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotbb1", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colortri1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "trinet"}], "]"}], ",", "colorpolygon",
                 ",", 
                RowBox[{"Thickness", "[", "linewidththin", "]"}], ",", " ", 
                RowBox[{"Line", "[", "bndrytrisu0", "]"}], ",", " ", 
                RowBox[{"Line", "[", "bndrytrisv0", "]"}], ",", " ", 
                RowBox[{"Line", "[", "bndrytrisw0", "]"}]}], "}"}], "]"}]}], 
            ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"dmat1", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
              "dd22", ",", " ", "dd32", ",", " ", "dd23", ",", " ", "dd22"}], 
              "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"plotcmat1", "[", 
              RowBox[{"[", "iface", "]"}], "]"}], "=", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{"colortri1", ",", 
                RowBox[{"PointSize", "[", "pointsizemedium", "]"}], ",", 
                RowBox[{"Map", "[", 
                 RowBox[{"Point", ",", "dmat1"}], "]"}]}], "}"}], "]"}]}], 
            ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"rendermethod", " ", "\[Equal]", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"quadpic1", " ", "[", 
                RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
               "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot3D", "[", 
                RowBox[{
                 RowBox[{"gtri", "[", 
                  RowBox[{"u", ",", "v"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "0", ",", 
                   RowBox[{"1", "-", "v"}]}], "}"}], ",", 
                 RowBox[{"PlotStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"colorsurface", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "myspecularity"}], "]"}], ",", 
                    RowBox[{"Opacity", "[", "myopacity", "]"}]}], "}"}]}], 
                 ",", 
                 RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]}]}], 
             "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"rendermethod", " ", "\[Equal]", " ", "1"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"quadpic1", " ", "[", 
                RowBox[{"[", "iface", "]"}], "]"}], "=", " ", 
               "\[IndentingNewLine]", 
               RowBox[{"ParametricPlot3D", "[", 
                RowBox[{
                 RowBox[{"gtri", "[", 
                  RowBox[{"u", ",", "v"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"v", ",", "0", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "0", ",", 
                   RowBox[{"1", "-", "v"}]}], "}"}], ",", 
                 RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
                 RowBox[{"PlotPoints", "\[Rule]", "myplotpoints"}], ",", 
                 RowBox[{"ColorFunction", "\[Rule]", 
                  RowBox[{"Function", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y", ",", "z", ",", "v", ",", "u"}], 
                    "}"}], ",", 
                    RowBox[{"zebracolorfct", "[", "z", "]"}]}], "]"}]}], ",", 
                 RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], 
                "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "plot", " ", "arrows", " ", "on", " ", "first", " ", "patch"}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"iface", " ", "\[Equal]", " ", "1"}], ",", 
               RowBox[{"(", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"axisc1", "=", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{"{", 
                    RowBox[{"Green", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"dd22", ",", "dd23"}], "}"}], "]"}]}], "}"}], 
                   "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{"axisbb1", "=", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
                    RowBox[{"tt1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}]}], 
                    "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", ")"}]}], 
              "]"}], "\[IndentingNewLine]", 
             RowBox[{"(", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"tri1", "=", "tt1"}], ";", "\[IndentingNewLine]", 
               RowBox[{"tri2", "=", " ", 
                RowBox[{"{", 
                 RowBox[{"dd22", ",", " ", "dd23", ",", "dd32"}], "}"}]}], 
               ";"}], "\[IndentingNewLine]", ")"}]}]}], "\[IndentingNewLine]",
            ")"}]}], "]"}], ";"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"Triangle", " ", "case"}], " ", "*)"}], "\n", 
       "\[IndentingNewLine]", ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"iface", ",", "1", ",", "nfaces"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Check", " ", "G1", " ", "conditions", " ", "across", " ", "faces"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"checkg1condition", " ", "\[Equal]", " ", "1"}], ",", " ", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<Check partials *after* G1 conditions: \>\"", "]"}],
         ";", " ", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"numedges", " ", "=", " ", 
             RowBox[{"faces", "[", 
              RowBox[{"[", 
               RowBox[{"iface", ",", "1"}], "]"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Do", "[", 
             RowBox[{
              RowBox[{"(", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"nbr", "=", 
                 RowBox[{"faces", "[", 
                  RowBox[{"[", 
                   RowBox[{"iface", ",", "3", ",", "iedge"}], "]"}], "]"}]}], 
                ";", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"nbr", " ", ">", " ", "iface"}], ",", 
                  RowBox[{"(", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"numedgesnbr", " ", "=", " ", 
                    RowBox[{"faces", "[", 
                    RowBox[{"[", 
                    RowBox[{"nbr", ",", "1"}], "]"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"numedgesnbr", " ", "\[Equal]", " ", "4"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"loadnghbrinfo", "[", 
                    RowBox[{"iface", ",", " ", "nbr"}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"loadnghbrinfotri", "[", 
                    RowBox[{"iface", ",", "nbr"}], "]"}]}], 
                    "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"nbredge", " ", "=", " ", 
                    RowBox[{"nbrverts", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"numedges", " ", "\[Equal]", " ", "4"}], ",", 
                    RowBox[{"(", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], " ", "||", 
                    " ", 
                    RowBox[{"iedge", " ", "\[Equal]", " ", "3"}]}], ",", 
                    RowBox[{"iacross", "=", "2"}], ",", " ", 
                    RowBox[{"iacross", "=", "1"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"volume", " ", "=", " ", 
                    RowBox[{"Det", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "iface", "]"}], "]"}], "[", 
                    RowBox[{"[", "iedge", "]"}], "]"}], "[", 
                    RowBox[{"[", "iacross", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}]}]}], ")"}],
                     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"iedge", " ", "\[Equal]", " ", "1"}], " ", "||", 
                    " ", 
                    RowBox[{"iedge", " ", "\[Equal]", " ", "2"}]}], ",", 
                    RowBox[{"iacross", "=", "2"}], ",", " ", 
                    RowBox[{"iacross", "=", "1"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"volume", " ", "=", " ", 
                    RowBox[{"Det", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "iface", "]"}], "]"}], "[", 
                    RowBox[{"[", "iedge", "]"}], "]"}], "[", 
                    RowBox[{"[", "iacross", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
                    "\[IndentingNewLine]", ")"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"(*", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<Main: Face #\>\"", ",", "iface", ",", 
                    "\"\<  iedge=\>\"", ",", "iedge", ",", 
                    "\"\< u-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "iface", "]"}], "]"}], "[", 
                    RowBox[{"[", "iedge", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    "\"\<  v-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "iface", "]"}], "]"}], "[", 
                    RowBox[{"[", "iedge", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<Main: Face #\>\"", ",", "nbr", ",", 
                    "\"\<  nbredge=\>\"", ",", "nbredge", ",", 
                    "\"\< u-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    "\"\<  v-partial=\>\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"partials", "[", 
                    RowBox[{"[", "nbr", "]"}], "]"}], "[", 
                    RowBox[{"[", "nbredge", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], 
                    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<                   Across face \>\"", ",", "iface", 
                    ",", "\"\< and face\>\"", ",", "nbr", ",", 
                    "\"\< is it G1 at mid-param of edge?  volume of partials \
= \>\"", ",", "volume"}], "]"}], ";"}], "\[IndentingNewLine]", ")"}]}], "]"}],
                 ";"}], "\[IndentingNewLine]", ")"}], ",", 
              RowBox[{"{", 
               RowBox[{"iedge", ",", "1", ",", "numedges"}], "}"}]}], "]"}], 
            ";"}], "\[IndentingNewLine]", ")"}], ",", 
          RowBox[{"{", 
           RowBox[{"iface", ",", "1", ",", "nfaces"}], "}"}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ")"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"withcontrolstructure", " ", "\[Equal]", " ", "1"}], ",", 
     RowBox[{"picc0", " ", "=", " ", 
      RowBox[{"Show", "[", 
       RowBox[{
       "quadpicinput", ",", "  ", "plotbb1input", ",", "plotcmatinput", ",", 
        " ", "plotbndrypoly", ",", " ", "plotdata", ",", " ", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
        RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", 
        RowBox[{"ViewPoint", "\[Rule]", " ", "myviewpoint"}], ",", 
        RowBox[{"ViewVertical", "\[Rule]", "myviewvertical"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PreserveImageOptions", " ", "\[Rule]", "False"}]}], 
       "]"}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"withcontrolstructure", " ", "\[Equal]", " ", "1"}], ",", 
     RowBox[{"picg1", " ", "=", " ", 
      RowBox[{"Show", "[", 
       RowBox[{
       "quadpic1", ",", " ", "plotbb1", ",", "plotcmat1", ",", 
        "plotbndrypoly", ",", "plotdata", ",", " ", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
        RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", 
        RowBox[{"ViewPoint", "\[Rule]", " ", "myviewpoint"}], ",", 
        RowBox[{"ViewVertical", "\[Rule]", "myviewvertical"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PreserveImageOptions", " ", "\[Rule]", "False"}]}], 
       "]"}]}]}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"withcontrolstructure", " ", "\[Equal]", " ", "0"}], ",", 
     RowBox[{"picc0", " ", "=", " ", 
      RowBox[{"Show", "[", 
       RowBox[{"quadpicinput", ",", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
        RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
        RowBox[{"ViewPoint", "\[Rule]", " ", "myviewpoint"}], ",", 
        RowBox[{"ViewVertical", "\[Rule]", "myviewvertical"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PreserveImageOptions", " ", "\[Rule]", "False"}]}], 
       "]"}]}]}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"withcontrolstructure", " ", "\[Equal]", " ", "0"}], ",", 
     RowBox[{"picg1", " ", "=", " ", 
      RowBox[{"Show", "[", 
       RowBox[{"quadpic1", ",", 
        RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
        RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
        RowBox[{"ViewPoint", "\[Rule]", " ", "myviewpoint"}], ",", " ", 
        RowBox[{"ViewVertical", "\[Rule]", "myviewvertical"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"PreserveImageOptions", " ", "\[Rule]", "False"}]}], 
       "]"}]}]}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"picinput", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"plotdata", ",", "plotfaces", ",", "plotnormals", ",", " ", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
      RowBox[{"ViewPoint", "\[Rule]", " ", "myviewpoint"}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", "myviewvertical"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PreserveImageOptions", " ", "\[Rule]", "False"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"picbndry", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotbndrycurve", ",", "plotbndrypoly", ",", " ", "plotdata", ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
      RowBox[{"ViewPoint", "\[Rule]", "myviewpoint"}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", "myviewvertical"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PreserveImageOptions", " ", "\[Rule]", "False"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<picc0.eps\>\"", ",", " ", "picc0"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<picg1.eps\>\"", ",", " ", "picg1"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<picbndry.eps\>\"", ",", " ", "picbndry"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<picinput.eps\>\"", ",", " ", "picinput"}], "]"}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.514345952564144*^9, 3.514345965652568*^9}, {
   3.5143460638235397`*^9, 3.514346100811205*^9}, {3.514346270071502*^9, 
   3.514346273612708*^9}, {3.514346423466572*^9, 3.514346435618993*^9}, {
   3.5143464967243004`*^9, 3.514346593896871*^9}, {3.514346678121419*^9, 
   3.514346684954231*^9}, {3.5143492938716135`*^9, 3.5143493282852736`*^9}, {
   3.514349359656929*^9, 3.51434938307257*^9}, {3.514349737973193*^9, 
   3.514349744743605*^9}, {3.5143499516935687`*^9, 3.5143499668567953`*^9}, {
   3.5143500671649714`*^9, 3.514350086477805*^9}, {3.5143506125887294`*^9, 
   3.5143507130217056`*^9}, {3.5143507693846045`*^9, 3.514350809835476*^9}, {
   3.5143508607539654`*^9, 3.5143509848833833`*^9}, {3.5143510528995028`*^9, 
   3.514351202207365*^9}, {3.514351236277825*^9, 3.514351247197844*^9}, {
   3.5143512947623277`*^9, 3.5143513313287916`*^9}, {3.514351397535308*^9, 
   3.514351490745472*^9}, {3.5143515572483883`*^9, 3.514351567684807*^9}, {
   3.514351673764993*^9, 3.5143516865258155`*^9}, {3.51435208151851*^9, 
   3.514352146321023*^9}, {3.5143524825484138`*^9, 3.514352484124017*^9}, {
   3.514352528927295*^9, 3.514352557678146*^9}, {3.514352825359016*^9, 
   3.5143528391182404`*^9}, 3.514353649726864*^9, {3.514353800126728*^9, 
   3.514353802747533*^9}, {3.5143539085001183`*^9, 3.514353942367778*^9}, 
   3.514375935993805*^9, {3.514376030451971*^9, 3.5143760324955745`*^9}, {
   3.5144366656992707`*^9, 3.5144367003625317`*^9}, {3.514456416041561*^9, 
   3.5144564222347717`*^9}, {3.514457927809016*^9, 3.5144579331910257`*^9}, 
   3.5144635947373695`*^9, {3.51455242185417*^9, 3.5145524304653845`*^9}, {
   3.5145525481207914`*^9, 3.5145525564044056`*^9}, {3.5145526104117007`*^9, 
   3.514552616324111*^9}, {3.5151393852171755`*^9, 3.515139405824811*^9}, {
   3.515139499768176*^9, 3.515139574679508*^9}, {3.5151405182287655`*^9, 
   3.515140522846373*^9}, {3.5163668522327285`*^9, 3.516366929484064*^9}, {
   3.5163669598417177`*^9, 3.5163669616669207`*^9}, {3.51636706944751*^9, 
   3.5163670833939342`*^9}, {3.516367337393581*^9, 3.5163673677980337`*^9}, 
   3.5163673998404903`*^9, {3.516367465189005*^9, 3.516367476826626*^9}, {
   3.5163675643895793`*^9, 3.5163676545421376`*^9}, {3.516367703354624*^9, 
   3.5163677051642265`*^9}, {3.5163679538910637`*^9, 
   3.5163679853719187`*^9}, {3.51636805440204*^9, 3.5163681853954697`*^9}, {
   3.516368273566825*^9, 3.5163682766400304`*^9}, {3.5163683906606307`*^9, 
   3.5163683942018366`*^9}, {3.5163684469299297`*^9, 
   3.5163684560559454`*^9}, {3.5163685100320406`*^9, 
   3.5163685201408577`*^9}, {3.5163685710281477`*^9, 3.516368573180951*^9}, {
   3.5163686175630293`*^9, 3.516368622648638*^9}, 3.5163686775295343`*^9, {
   3.5163721758512793`*^9, 3.5163722411685934`*^9}, {3.516389683636027*^9, 
   3.516389818685464*^9}, {3.516389859245535*^9, 3.5163898600255365`*^9}, {
   3.516390171277283*^9, 3.5163901752396903`*^9}, {3.516390526942308*^9, 
   3.516390534929522*^9}, {3.516391805629754*^9, 3.5163918231173844`*^9}, {
   3.516394971327714*^9, 3.5163950028553696`*^9}, {3.516399873199524*^9, 
   3.5163998920755568`*^9}, {3.516480973087333*^9, 3.51648104506586*^9}, 
   3.516481243420208*^9, {3.516481514439484*^9, 3.5164815187138915`*^9}, 
   3.5164816551517315`*^9, {3.5164824154346666`*^9, 3.5164824203330755`*^9}, {
   3.5165384107828407`*^9, 3.5165384973785925`*^9}, {3.516541537450852*^9, 
   3.51654159880576*^9}, {3.5165416656050773`*^9, 3.516541690580721*^9}, {
   3.5165421764903746`*^9, 3.5165421824339848`*^9}, {3.5165423612102985`*^9, 
   3.5165423643459044`*^9}, {3.5165430838347683`*^9, 3.516543096689191*^9}, {
   3.5165520255364733`*^9, 3.516552081119371*^9}, {3.516552629319934*^9, 
   3.5165526722980094`*^9}, {3.516566421643386*^9, 3.5165664350282097`*^9}, {
   3.5170592868267927`*^9, 3.5170592966080093`*^9}, {3.5170598276513424`*^9, 
   3.517059842346568*^9}, {3.517060178885959*^9, 3.517060214875222*^9}, {
   3.51718643057697*^9, 3.517186465411831*^9}, 3.51718655553319*^9, {
   3.517778684302765*^9, 3.5177788153273954`*^9}, {3.51777884618425*^9, 
   3.5177789525452366`*^9}, {3.517779008674135*^9, 3.5177790225425596`*^9}, {
   3.517779420858059*^9, 3.5177794272696705`*^9}, {3.517837338558543*^9, 
   3.5178373473725586`*^9}, {3.517861647566758*^9, 3.517861664820389*^9}, {
   3.517862190962513*^9, 3.5178621926941156`*^9}, {3.5178624045580883`*^9, 
   3.5178624880962343`*^9}, {3.5178626029748363`*^9, 3.517862604644039*^9}, {
   3.517862704203414*^9, 3.5178628234968233`*^9}, {3.5178629451614375`*^9, 
   3.517862952852251*^9}, {3.5178629911191177`*^9, 3.51786301487796*^9}, {
   3.517863112190931*^9, 3.5178631348421707`*^9}, {3.5178632830112305`*^9, 
   3.5178632835416317`*^9}, {3.517863564150925*^9, 3.5178635688933334`*^9}, {
   3.5178636802463293`*^9, 3.5178637221480026`*^9}, {3.5178638428142147`*^9, 
   3.51786388568309*^9}, {3.517863936414379*^9, 3.517863939487584*^9}, {
   3.517863995554083*^9, 3.5178640464257727`*^9}, {3.517864211349262*^9, 
   3.5178642151868687`*^9}, {3.5178644353656554`*^9, 
   3.5178644940061584`*^9}, {3.5178645316646247`*^9, 3.51786455763867*^9}, {
   3.5178648238219376`*^9, 3.517864825881141*^9}, 3.517865092345209*^9, {
   3.517865271558324*^9, 3.517865292462361*^9}, {3.517865347124857*^9, 
   3.5178653560948725`*^9}, {3.5178653978405457`*^9, 3.517865412613772*^9}, 
   3.517865469117071*^9, {3.517865924208271*^9, 3.5178659342702885`*^9}, 
   3.517871485306039*^9, {3.517934747202368*^9, 3.5179349056986465`*^9}, {
   3.517937304652861*^9, 3.5179373091144695`*^9}, {3.5179385152773876`*^9, 
   3.517938526322207*^9}, {3.517938566866678*^9, 3.517938598191533*^9}, {
   3.517939126985662*^9, 3.5179391310728693`*^9}, 3.517946994560281*^9, {
   3.5179470978636622`*^9, 3.51794710218487*^9}, {3.5179488809043226`*^9, 
   3.5179489057395663`*^9}, 3.5179490173577623`*^9, 3.517949126932355*^9, {
   3.5179497400730324`*^9, 3.5179497423350363`*^9}, {3.5179501149572906`*^9, 
   3.5179502554355373`*^9}, 3.5179502866979923`*^9, {3.5179503217668543`*^9, 
   3.517950349628503*^9}, {3.5179503880513706`*^9, 3.5179504463798733`*^9}, {
   3.517950510870386*^9, 3.51795052425521*^9}, {3.5179514043619556`*^9, 
   3.5179514271847954`*^9}, {3.5179515347313843`*^9, 3.5179516053215084`*^9}, 
   3.5179516806852407`*^9, {3.5179518290571012`*^9, 3.5179518307107043`*^9}, {
   3.51795191351565*^9, 3.517951914685652*^9}, 3.5179519497389135`*^9, 
   3.517952092993965*^9, {3.5179525125567017`*^9, 3.517952517517511*^9}, {
   3.517955899579451*^9, 3.5179559186114845`*^9}, {3.5179559542575474`*^9, 
   3.517955956644351*^9}, 3.517956090726587*^9, {3.5181253185229936`*^9, 
   3.518125336244625*^9}, {3.5181253811415033`*^9, 3.518125386414313*^9}, {
   3.518126397093288*^9, 3.518126418137725*^9}, {3.5181275143360505`*^9, 
   3.518127593459389*^9}, 3.518127626796648*^9, {3.5181279289691787`*^9, 
   3.5181279527280207`*^9}, {3.518128192235241*^9, 3.518128196494048*^9}, {
   3.5181283353030925`*^9, 3.5181283406539016`*^9}, {3.518128380636772*^9, 
   3.5181283858627815`*^9}, {3.5181924386319427`*^9, 3.518192445152754*^9}, {
   3.5181926700271487`*^9, 3.5181926730379543`*^9}, {3.5181927974325724`*^9, 
   3.518192804296585*^9}, 3.518192915056779*^9, {3.518194139390129*^9, 
   3.5181941453337398`*^9}, {3.5181945921029243`*^9, 3.518194684676287*^9}, {
   3.5181958985300193`*^9, 3.518195953020915*^9}, {3.5181959995089965`*^9, 
   3.5181960089782133`*^9}, {3.5181961098011904`*^9, 
   3.5181961406268444`*^9}, {3.518208567989071*^9, 3.5182086306387815`*^9}, {
   3.5182087248317466`*^9, 3.5182087294181547`*^9}, {3.5182087780902405`*^9, 
   3.5182087969818735`*^9}, {3.5182103968114834`*^9, 
   3.5182104119123096`*^9}, {3.518227186123767*^9, 3.518227213891816*^9}, {
   3.5182272739363213`*^9, 3.5182273690652885`*^9}, {3.5182998005571404`*^9, 
   3.5182998416944127`*^9}, {3.5182998764356737`*^9, 
   3.5182998773872757`*^9}, {3.5182999501926036`*^9, 3.518299962407425*^9}, {
   3.518300818583729*^9, 3.5183008270233436`*^9}, {3.5183008703914194`*^9, 
   3.518300873917026*^9}, {3.518300904149879*^9, 3.5183009289851227`*^9}, {
   3.518301114547448*^9, 3.5183011669167404`*^9}, {3.518301370497098*^9, 
   3.5183014289036007`*^9}, {3.518301555950224*^9, 3.51830155947583*^9}, {
   3.5183016297071533`*^9, 3.5183016406115723`*^9}, {3.5183016868344536`*^9, 
   3.518301748470162*^9}, {3.518302386027682*^9, 3.518302392220893*^9}, {
   3.5183025222783213`*^9, 3.518302528253132*^9}, {3.5183025777832184`*^9, 
   3.51830260697087*^9}, {3.51830277769757*^9, 3.5183027844211817`*^9}, {
   3.5183047876207*^9, 3.5183047943287115`*^9}, 3.518304828555172*^9, {
   3.5183095138050013`*^9, 3.5183095429614525`*^9}, {3.5183097259341736`*^9, 
   3.518309736370592*^9}, 3.518309768787449*^9, 3.518309799051502*^9, {
   3.518309919140513*^9, 3.5183099936930437`*^9}, 3.518310174481762*^9, {
   3.5183571768055677`*^9, 3.5183571827803783`*^9}, {3.5183575014265385`*^9, 
   3.5183575038445425`*^9}, 3.518357533905795*^9, {3.5183576153535385`*^9, 
   3.518357616617141*^9}, {3.518357716004915*^9, 3.518357722057726*^9}, {
   3.51835798035458*^9, 3.518357993099802*^9}, {3.518358090771573*^9, 
   3.518358108150004*^9}, 3.5183589600715017`*^9, 3.518358999258771*^9, {
   3.5183593806198406`*^9, 3.5183593827882442`*^9}, {3.5183594229271145`*^9, 
   3.518359449681162*^9}, {3.5183595184616823`*^9, 3.5183595595521545`*^9}, 
   3.5183597421504755`*^9, 3.51836467508074*^9, {3.518364855370257*^9, 
   3.518364878692298*^9}, {3.5183655619578977`*^9, 3.518365581411132*^9}, {
   3.518365676384099*^9, 3.5183656813137074`*^9}, {3.518365724572583*^9, 
   3.5183657275209885`*^9}, {3.5183734756605263`*^9, 
   3.5183734914945545`*^9}, {3.518373704996529*^9, 3.5183737176013513`*^9}, {
   3.518373760236226*^9, 3.5183738060223064`*^9}, {3.5183738838820434`*^9, 
   3.5183739641597843`*^9}, {3.5184629896846867`*^9, 
   3.5184629977811007`*^9}, {3.5184641439307137`*^9, 
   3.5184641444299145`*^9}, {3.518464676312849*^9, 3.518464808866282*^9}, 
   3.518464943478918*^9, {3.518465207337782*^9, 3.5184652229690094`*^9}, {
   3.5184652611578765`*^9, 3.5184652850883183`*^9}, {3.518465335148806*^9, 
   3.518465481227463*^9}, {3.5184662320099816`*^9, 3.5184662321503816`*^9}, {
   3.5184664309415307`*^9, 3.5184664478831606`*^9}, {3.518534351196027*^9, 
   3.5185343521164284`*^9}, {3.5185344106009307`*^9, 
   3.5185344232837534`*^9}, {3.5185386923064513`*^9, 
   3.5185387826930103`*^9}, {3.5185388233466816`*^9, 3.518538851426731*^9}, {
   3.518538885559591*^9, 3.518538893578005*^9}, {3.518538965884132*^9, 
   3.518538992575779*^9}, {3.5185390457718725`*^9, 3.518539046910674*^9}, {
   3.518539087018345*^9, 3.518539090684351*^9}, {3.5185391483576527`*^9, 
   3.5185391717576933`*^9}, {3.5185392372466087`*^9, 3.518539258057045*^9}, {
   3.518539299131917*^9, 3.518539337726385*^9}, {3.5185394056489043`*^9, 
   3.5185394370985594`*^9}, {3.518539540464341*^9, 3.518539541088342*^9}, {
   3.5185466882416162`*^9, 3.518546691626822*^9}, {3.5185476724317446`*^9, 
   3.5185476818853617`*^9}, {3.5185477856879435`*^9, 
   3.5185478294304204`*^9}, {3.518548320893684*^9, 3.518548322094886*^9}, {
   3.51854939490877*^9, 3.5185494538768735`*^9}, {3.5185496404532013`*^9, 
   3.518549640765202*^9}, {3.5185496883296857`*^9, 3.5185497039609127`*^9}, {
   3.518549849181568*^9, 3.5185498552031784`*^9}, {3.5185500438699102`*^9, 
   3.5185501004824095`*^9}, {3.5185502112426043`*^9, 
   3.5185502363118477`*^9}, {3.5185513733102455`*^9, 3.518551377662653*^9}, {
   3.5185516214130807`*^9, 3.5185516559671416`*^9}, {3.5185528812556934`*^9, 
   3.5185531623213873`*^9}, {3.518553336324093*^9, 3.5185533693181505`*^9}, {
   3.5185534033730106`*^9, 3.5185534455866847`*^9}, {3.5185534927299676`*^9, 
   3.5185534957719727`*^9}, {3.518553660664263*^9, 3.518553672255083*^9}, {
   3.5185537511132216`*^9, 3.5185537807532735`*^9}, {3.518553836882172*^9, 
   3.5185538824030523`*^9}, {3.518554036578123*^9, 3.518554067622177*^9}, {
   3.518554178975173*^9, 3.5185543967983556`*^9}, {3.518554557619038*^9, 
   3.5185545735622663`*^9}, {3.518554609535929*^9, 3.5185547208265247`*^9}, {
   3.518554862006773*^9, 3.518554897450035*^9}, {3.5185551863157425`*^9, 
   3.518555217515797*^9}, {3.518555263239477*^9, 3.518555322176381*^9}, {
   3.518555438568185*^9, 3.5185556004964695`*^9}, {3.5185556393873377`*^9, 
   3.5185557068730564`*^9}, {3.518555787291198*^9, 3.518555866570537*^9}, {
   3.5185559284090457`*^9, 3.5185559349454575`*^9}, {3.51855598190154*^9, 
   3.5185560067679834`*^9}, {3.518556461778385*^9, 3.5185564994524517`*^9}, {
   3.51855711342273*^9, 3.5185571233131475`*^9}, 3.5185573514323483`*^9, {
   3.5186351929682703`*^9, 3.5186352009086847`*^9}, 3.518635590425769*^9, {
   3.5186360725758157`*^9, 3.5186361199062986`*^9}, {3.518636346621497*^9, 
   3.518636351816306*^9}, {3.518636391565176*^9, 3.5186363943887806`*^9}, {
   3.518636963238575*^9, 3.518636964985778*^9}, {3.518638039375265*^9, 
   3.5186381758755045`*^9}, {3.518638256434046*^9, 3.518638260490053*^9}, {
   3.5186383736214523`*^9, 3.5186384335411572`*^9}, {3.5186385435525503`*^9, 
   3.51863854361495*^9}, {3.5186385843310223`*^9, 3.518638665607165*^9}, {
   3.518638774058555*^9, 3.518638963598888*^9}, 3.5186390298834047`*^9, {
   3.518639068696273*^9, 3.5186391369463925`*^9}, {3.518639174651659*^9, 
   3.5186392103601217`*^9}, {3.5186392899826612`*^9, 3.518639290965463*^9}, {
   3.5186393292323303`*^9, 3.5186393435999556`*^9}, {3.5186393992764535`*^9, 
   3.5186394136284785`*^9}, {3.518639461723363*^9, 3.518639487432208*^9}, {
   3.518639619829641*^9, 3.5186396783765435`*^9}, {3.5186397353790436`*^9, 
   3.51863977305311*^9}, {3.5186398394000263`*^9, 3.5186398440800343`*^9}, {
   3.518640009533925*^9, 3.518640028113558*^9}, {3.5186408808734555`*^9, 
   3.5186408809982557`*^9}, {3.518641159333945*^9, 3.518641159692745*^9}, {
   3.5186419915190096`*^9, 3.51864199176861*^9}, {3.5186449979562902`*^9, 
   3.518644998517891*^9}, 3.518702332359394*^9, {3.5187073958586884`*^9, 
   3.518707470317619*^9}, {3.5187082762462344`*^9, 3.5187083018770795`*^9}, {
   3.5187155750494537`*^9, 3.5187155753614545`*^9}, {3.5187220996593156`*^9, 
   3.518722099799716*^9}, {3.5187247817408266`*^9, 3.5187247985576563`*^9}, {
   3.5187250078320236`*^9, 3.518725036723274*^9}, {3.5187251024305897`*^9, 
   3.518725107219798*^9}, {3.518735911405975*^9, 3.5187359114839745`*^9}, {
   3.518736130305559*^9, 3.518736131272761*^9}, 3.5187362630305924`*^9, 
   3.5187365171238384`*^9, {3.5187925877417135`*^9, 3.518792587819714*^9}, {
   3.5187929862288136`*^9, 3.518793005682048*^9}, {3.5187930527317305`*^9, 
   3.5187930766153727`*^9}, {3.518793108923029*^9, 3.518793221383627*^9}, {
   3.5187932936117535`*^9, 3.518793306356976*^9}, 3.518793407679154*^9, {
   3.518793544460194*^9, 3.518793622507131*^9}, {3.5187937465117493`*^9, 
   3.5187938497995305`*^9}, {3.518793885897994*^9, 3.518794065220309*^9}, {
   3.518794105249979*^9, 3.518794118291602*^9}, {3.518794344445199*^9, 
   3.518794426251743*^9}, {3.518799695727001*^9, 3.5187997385646763`*^9}, {
   3.518799829980837*^9, 3.5187999158745875`*^9}, 3.5187999987887335`*^9, 
   3.518800187939066*^9, {3.518800229013938*^9, 3.518800248560772*^9}, {
   3.5188003474961457`*^9, 3.51880034983615*^9}, {3.518800689994747*^9, 
   3.5188007000723653`*^9}, 3.518800850175829*^9, {3.518800922091955*^9, 
   3.51880092516516*^9}, 3.518801072304619*^9, 3.51880112963472*^9, {
   3.518801310189437*^9, 3.5188013157586465`*^9}, {3.5188013549927154`*^9, 
   3.518801366084335*^9}, {3.518801451057684*^9, 3.5188015139101944`*^9}, {
   3.518801865971613*^9, 3.518801884894446*^9}, {3.518802049443535*^9, 
   3.5188021160556517`*^9}, {3.5188021834165707`*^9, 3.5188022003582*^9}, {
   3.5188022645055127`*^9, 3.518802293131563*^9}, {3.5188059693092203`*^9, 
   3.518806020102909*^9}, 3.5188060614273815`*^9, {3.518807728371112*^9, 
   3.518807768073181*^9}, {3.518807813453661*^9, 3.5188078451217165`*^9}, {
   3.518808038764857*^9, 3.518808084285737*^9}, {3.5188081425986395`*^9, 
   3.518808146184246*^9}, {3.5188082032371464`*^9, 3.518808239164009*^9}, {
   3.51880827371807*^9, 3.518808342607791*^9}, {3.518808527202915*^9, 
   3.5188086019426465`*^9}, {3.518808646012724*^9, 3.5188086844355917`*^9}, {
   3.5188088668155117`*^9, 3.518808910838789*^9}, {3.5188089425224447`*^9, 
   3.5188090652066607`*^9}, {3.518809171286847*^9, 3.5188093496263604`*^9}, {
   3.5188094083916636`*^9, 3.51880943486491*^9}, {3.5188094903698072`*^9, 
   3.5188094954866166`*^9}, {3.5188096628749104`*^9, 
   3.5188096766653347`*^9}, {3.518809889590109*^9, 3.518809959473832*^9}, {
   3.5188099908298874`*^9, 3.5188100877840576`*^9}, {3.518810172383006*^9, 
   3.5188102522551465`*^9}, {3.5188102826751995`*^9, 
   3.5188103553089275`*^9}, {3.5188103872421837`*^9, 3.518810487347559*^9}, {
   3.5188105452860613`*^9, 3.5188105745985126`*^9}, {3.518810606219768*^9, 
   3.518810627935006*^9}, {3.518810718867566*^9, 3.5188107624852424`*^9}, {
   3.518812743723524*^9, 3.5188127440355244`*^9}, {3.5188138357154427`*^9, 
   3.518813835731043*^9}, {3.5188141249087505`*^9, 3.5188141251427507`*^9}, {
   3.5188146828917313`*^9, 3.518814703296567*^9}, 3.5188150313651433`*^9, 
   3.518815691127103*^9, {3.5188158465345755`*^9, 3.5188159045198774`*^9}, {
   3.5188160680861645`*^9, 3.5188161076478343`*^9}, {3.518816289034953*^9, 
   3.5188162925761595`*^9}, {3.5188163794839125`*^9, 3.5188163869719257`*^9}, 
   3.518816453334442*^9, {3.5188171068663898`*^9, 3.5188171117335987`*^9}, {
   3.5188172347542152`*^9, 3.5188172374530196`*^9}, {3.518817292053116*^9, 
   3.5188172941435194`*^9}, 3.518817365139244*^9, {3.5188174538409996`*^9, 
   3.518817456727005*^9}, {3.5188175275823293`*^9, 3.518817540514752*^9}, {
   3.5188176905402155`*^9, 3.5188176921002183`*^9}, {3.5188180626588697`*^9, 
   3.518818063532471*^9}, {3.5188183749714184`*^9, 3.5188183791366253`*^9}, {
   3.5188184484007473`*^9, 3.5188184501635504`*^9}, 3.5188935819395056`*^9, 
   3.518893613373561*^9, {3.518894082089184*^9, 3.5188941717581415`*^9}, {
   3.5188942327542486`*^9, 3.5188942500858793`*^9}, {3.518894290973551*^9, 
   3.5188943715632925`*^9}, {3.5188945286711683`*^9, 3.518894557406419*^9}, {
   3.5188946140189185`*^9, 3.518894633004152*^9}, {3.518894871731371*^9, 
   3.5188948899522033`*^9}, {3.5188949908375807`*^9, 
   3.5188949970307913`*^9}, {3.518895072659724*^9, 3.518895147961056*^9}, {
   3.518895250796437*^9, 3.5188953230557637`*^9}, {3.518895392163885*^9, 
   3.518895606243061*^9}, {3.5188957017620287`*^9, 3.5188957106852446`*^9}, {
   3.5188958497282887`*^9, 3.518895948273662*^9}, {3.5188978682782345`*^9, 
   3.518897932597147*^9}, {3.5188987143585205`*^9, 3.5188987144833207`*^9}, {
   3.5188987690522165`*^9, 3.518898832201127*^9}, {3.5188995565459995`*^9, 
   3.518899560836007*^9}, {3.518900538692525*^9, 3.5189005954610243`*^9}, {
   3.5189006462703133`*^9, 3.5189006803251734`*^9}, {3.518900973278088*^9, 
   3.5189009819985037`*^9}, {3.5189016975845604`*^9, 
   3.5189017068041763`*^9}, {3.5189018074087534`*^9, 3.518901816035568*^9}, {
   3.518979403141221*^9, 3.5189794492861023`*^9}, {3.518979511046611*^9, 
   3.5189795175206223`*^9}, {3.5189800697487926`*^9, 3.51898009108963*^9}, {
   3.518980934923512*^9, 3.518981006215637*^9}, {3.5189811244170446`*^9, 
   3.518981127927051*^9}, {3.518981169828725*^9, 3.5189811727147293`*^9}, {
   3.5189812758153105`*^9, 3.5189812785141153`*^9}, {3.518981535555767*^9, 
   3.5189815694078264`*^9}, {3.51898159967188*^9, 3.5189816293743315`*^9}, {
   3.518981675488013*^9, 3.518981686969633*^9}, 3.518981882765577*^9, {
   3.5189819759289403`*^9, 3.518981976006941*^9}, 3.519048711186159*^9, 
   3.5190488077035284`*^9, 3.5190489323789473`*^9, {3.51939978122421*^9, 
   3.5193998068009872`*^9}, {3.5193999006859875`*^9, 3.519399945250067*^9}, {
   3.519400106531979*^9, 3.5194001176579776`*^9}, {3.5194001513864765`*^9, 
   3.5194002824449296`*^9}, {3.5194024508429327`*^9, 3.519402473124973*^9}, {
   3.5194025242885427`*^9, 3.5194026047842894`*^9}, {3.519402666733368*^9, 
   3.5194027210314445`*^9}, {3.5194028563760605`*^9, 
   3.5194029022620416`*^9}, {3.5194036317109375`*^9, 3.519403668323584*^9}, {
   3.519403704645813*^9, 3.519403865727437*^9}, {3.5194039081784782`*^9, 
   3.519404045165456*^9}, {3.5194041266326*^9, 3.5194041409632063`*^9}, {
   3.5194041901439247`*^9, 3.5194041962727375`*^9}, {3.5194042458740606`*^9, 
   3.519404247025717*^9}, {3.5194043078531823`*^9, 3.519404390772414*^9}, {
   3.519404436978856*^9, 3.5194045425907183`*^9}, {3.519404573194725*^9, 
   3.5194046916150045`*^9}, {3.519404743489597*^9, 3.519404779301091*^9}, {
   3.5194048777827005`*^9, 3.519404894186288*^9}, {3.51940494005224*^9, 
   3.5194050931724157`*^9}, {3.519405148652192*^9, 3.519405196380822*^9}, {
   3.519405227615736*^9, 3.519405228617176*^9}, {3.519405647619672*^9, 
   3.5194056481504354`*^9}, {3.519405678714384*^9, 3.5194056790148163`*^9}, {
   3.519406121150576*^9, 3.5194061642225103`*^9}, {3.5194105440403795`*^9, 
   3.519410552702835*^9}, {3.519410619318624*^9, 3.5194106894294386`*^9}, {
   3.5194107433069105`*^9, 3.519410878641512*^9}, {3.5194116679665055`*^9, 
   3.519411668096693*^9}, {3.5194120029181423`*^9, 3.5194120190913982`*^9}, 
   3.51941210285184*^9, {3.519412157029744*^9, 3.5194121573301764`*^9}, {
   3.5194122128800526`*^9, 3.519412218648347*^9}, {3.519412250784557*^9, 
   3.5194123000554047`*^9}, {3.5194123471130705`*^9, 3.519412349626685*^9}, {
   3.519412699059144*^9, 3.5194127022537374`*^9}, {3.5194164620901165`*^9, 
   3.519416488147586*^9}, {3.5194166404565954`*^9, 3.5194166528544226`*^9}, {
   3.5194166890965357`*^9, 3.519416701163888*^9}, {3.519416752928322*^9, 
   3.5194167653361635`*^9}, {3.5194168196642833`*^9, 
   3.5194168849281282`*^9}, {3.5194169299228272`*^9, 3.519417009737595*^9}, {
   3.5194170670199633`*^9, 3.5194171132163906`*^9}, {3.5194171709293776`*^9, 
   3.519417259416616*^9}, {3.5194173436477346`*^9, 3.5194173996382446`*^9}, {
   3.5194194138245025`*^9, 3.5194194241693773`*^9}, {3.5194196944580336`*^9, 
   3.5194197424670672`*^9}, 3.519419794111328*^9, {3.5194228094471684`*^9, 
   3.519422810108118*^9}, {3.5194231128734736`*^9, 3.519423113404237*^9}, {
   3.5194272722343407`*^9, 3.519427274988301*^9}, {3.5194273298571987`*^9, 
   3.5194273600406*^9}, {3.519427394720467*^9, 3.5194274212285843`*^9}, {
   3.519427688112344*^9, 3.5194277243845005`*^9}, {3.519427766705355*^9, 
   3.519427952863037*^9}, {3.519427990487138*^9, 3.5194280816982927`*^9}, {
   3.5194281294769955`*^9, 3.5194282954256177`*^9}, {3.5194283314073567`*^9, 
   3.519428407126235*^9}, {3.5194284832957616`*^9, 3.5194284834559917`*^9}, 
   3.519428523163088*^9, 3.5194285630103855`*^9, {3.519428618149672*^9, 
   3.5194287964660783`*^9}, {3.519428829723901*^9, 3.5194288590660925`*^9}, {
   3.5194289227977343`*^9, 3.5194289257519827`*^9}, 3.519429031343816*^9, {
   3.519436409943722*^9, 3.5194364106247005`*^9}, {3.5194373726680512`*^9, 
   3.5194373728483105`*^9}, {3.519474324402512*^9, 3.5194743275470333`*^9}, {
   3.5194748862003374`*^9, 3.5194751784405584`*^9}, {3.519475220170563*^9, 
   3.5194755132019215`*^9}, {3.5194757595261183`*^9, 3.519475772614939*^9}, {
   3.5194758031788883`*^9, 3.5194758644069295`*^9}, {3.5194759223903055`*^9, 
   3.519475951321907*^9}, {3.5194759924310193`*^9, 3.5194760449465327`*^9}, {
   3.5194760999255886`*^9, 3.519476194371395*^9}, {3.519478449150173*^9, 
   3.519478457892744*^9}, {3.5194788584587297`*^9, 3.5194789076795063`*^9}, {
   3.5194790878285475`*^9, 3.519479093246338*^9}, {3.5194792797745523`*^9, 
   3.519479351587815*^9}, {3.519479780053919*^9, 3.519479799271552*^9}, 
   3.519479966181557*^9, 3.5194799985280695`*^9, {3.5194806665185924`*^9, 
   3.5194807449013014`*^9}, 3.5194807778286486`*^9, {3.519480885313204*^9, 
   3.519481016662074*^9}, {3.519481501809682*^9, 3.5194816102456055`*^9}, {
   3.5194816408696404`*^9, 3.519481645275976*^9}, {3.5194817082365093`*^9, 
   3.519481740432805*^9}, {3.5194817929082613`*^9, 3.5194818789519863`*^9}, {
   3.519481933550495*^9, 3.51948208309553*^9}, {3.519482145985962*^9, 
   3.5194821888576083`*^9}, {3.5194823340964518`*^9, 3.519482359302696*^9}, {
   3.5194826631496067`*^9, 3.519482672292754*^9}, {3.519482734231818*^9, 
   3.5194827434650946`*^9}, {3.5194827777544003`*^9, 3.519482798053589*^9}, {
   3.5194829348402786`*^9, 3.5194829388961105`*^9}, {3.5194832625915623`*^9, 
   3.519483451603348*^9}, {3.519483699289503*^9, 3.519483711477028*^9}, {
   3.5194838019771605`*^9, 3.519483827794284*^9}, {3.5194838780665717`*^9, 
   3.5194838784270897`*^9}, {3.51948860221957*^9, 3.5194886217376356`*^9}, {
   3.5194886948127127`*^9, 3.519488695573807*^9}, {3.5194887391564755`*^9, 
   3.5194887427015734`*^9}, {3.5194889526935267`*^9, 
   3.5194889547364645`*^9}, {3.5194891038308516`*^9, 3.519489107375949*^9}, {
   3.519489217283989*^9, 3.5194892574116898`*^9}, {3.5194893111289315`*^9, 
   3.5194893588675766`*^9}, {3.519489459171807*^9, 3.5194894734923987`*^9}, {
   3.519489678186735*^9, 3.51948977807036*^9}, {3.5194898200006533`*^9, 
   3.519489820050725*^9}, {3.519489996915044*^9, 3.5194900810660467`*^9}, {
   3.519491671012277*^9, 3.5194917238382373`*^9}, {3.519491754672575*^9, 
   3.5194917700647078`*^9}, {3.519491822019415*^9, 3.5194918499195333`*^9}, {
   3.519498454336218*^9, 3.519498468526623*^9}, {3.5194988172881174`*^9, 
   3.519498837587306*^9}, {3.5195106229646196`*^9, 3.519510623573021*^9}, {
   3.519510883391477*^9, 3.5195108834382772`*^9}, {3.5205181544540567`*^9, 
   3.5205182092257533`*^9}, {3.5205184243657312`*^9, 3.5205184592545924`*^9}, 
   3.5206872270753813`*^9, {3.521396972102475*^9, 3.521396974495917*^9}, 
   3.5213971411054897`*^9, {3.5213972207199697`*^9, 3.52139729198244*^9}, {
   3.521398793351302*^9, 3.521398830314453*^9}, 3.5213991352929907`*^9, {
   3.5213993620690784`*^9, 3.5213993621592083`*^9}, {3.521399594092712*^9, 
   3.521399594623475*^9}, {3.521468513001704*^9, 3.5214685130918336`*^9}, {
   3.521485099301632*^9, 3.521485099451848*^9}, {3.521485726713806*^9, 
   3.5214857562863293`*^9}, {3.5214860839875407`*^9, 
   3.5214860840275984`*^9}, {3.521486311264349*^9, 3.5214863119753714`*^9}, {
   3.521486412670163*^9, 3.5214864132309694`*^9}, {3.5214905487475505`*^9, 
   3.5214905504800415`*^9}, {3.521490627230403*^9, 3.5214906583351297`*^9}, {
   3.521490754903989*^9, 3.5214907760043297`*^9}, {3.521490909386123*^9, 
   3.5214909108281965`*^9}, {3.5214911272093377`*^9, 
   3.5214911390864162`*^9}, {3.521491798764987*^9, 3.521491810622037*^9}, {
   3.521491865040286*^9, 3.5214918694366083`*^9}, {3.5214919169148784`*^9, 
   3.521491927600243*^9}, {3.521491986284627*^9, 3.52149198990984*^9}, {
   3.521492142268922*^9, 3.5214921657727184`*^9}, {3.5214923306197567`*^9, 
   3.5214923416756544`*^9}, {3.521492386550181*^9, 3.521492387581664*^9}, {
   3.5214924724837475`*^9, 3.52149247360536*^9}, {3.521492541883539*^9, 
   3.5214925506761827`*^9}, {3.521493257332304*^9, 3.5214932619589567`*^9}, {
   3.5214934095111265`*^9, 3.521493411824453*^9}, {3.52155111822796*^9, 
   3.5215511188788958`*^9}, 3.521551272569893*^9, {3.5215723413252754`*^9, 
   3.5215723488661184`*^9}, {3.5215724476581745`*^9, 
   3.5215724559000254`*^9}, {3.521572568582054*^9, 3.521572569743725*^9}, {
   3.5215726236011677`*^9, 3.52157262665556*^9}, 3.5215726738634415`*^9, {
   3.5215727117879744`*^9, 3.5215727135104513`*^9}, {3.521578666069811*^9, 
   3.5215786782473216`*^9}, {3.521578735499646*^9, 3.5215787431907053`*^9}, {
   3.521579164626701*^9, 3.521579167330589*^9}, {3.521580396097469*^9, 
   3.5215804072334814`*^9}, 3.5215806724848948`*^9, {3.521581019173408*^9, 
   3.5215810193736963`*^9}, {3.5215814664765987`*^9, 3.521581470111826*^9}, {
   3.521582117662958*^9, 3.5215821177030163`*^9}, {3.5215854037681456`*^9, 
   3.521585406812523*^9}, {3.5215857076551137`*^9, 3.5215857503865585`*^9}, {
   3.5215868408345456`*^9, 3.5215868438789234`*^9}, {3.521586894411586*^9, 
   3.521586904105525*^9}, {3.5215872679687347`*^9, 3.521587270842867*^9}, {
   3.5215875068622465`*^9, 3.521587506942362*^9}, {3.5216366032270412`*^9, 
   3.521636604018179*^9}, {3.521636718152296*^9, 3.521636718482771*^9}, {
   3.5216376491810493`*^9, 3.521637755564021*^9}, {3.5216377941595182`*^9, 
   3.5216378217491903`*^9}, {3.521742366856389*^9, 3.5217423671267776`*^9}, {
   3.521742407524867*^9, 3.5217424109898496`*^9}, {3.521745938111602*^9, 
   3.52174596025344*^9}, {3.5217460131394863`*^9, 3.521746032327077*^9}, {
   3.521746090931346*^9, 3.5217461180703697`*^9}, {3.5218121825511103`*^9, 
   3.5218123036552496`*^9}, {3.5219228430079517`*^9, 
   3.5219228499479313`*^9}, {3.5219239539854593`*^9, 3.521924026810176*^9}, {
   3.521924143748325*^9, 3.5219241489357843`*^9}, {3.521924242550395*^9, 
   3.5219242465761843`*^9}, {3.5219257268947773`*^9, 3.521925768985301*^9}, {
   3.521925834519534*^9, 3.5219258469574194`*^9}, {3.521925881376912*^9, 
   3.5219259050409393`*^9}, {3.5219261806672707`*^9, 
   3.5219262381399117`*^9}, {3.5219264839433603`*^9, 3.521926559221605*^9}, 
   3.5219268767782288`*^9, {3.521979692202149*^9, 3.5219798320933027`*^9}, {
   3.521980156179315*^9, 3.521980156239402*^9}, {3.52200533580584*^9, 
   3.5220054477167597`*^9}, {3.5220084421625614`*^9, 3.522008501628069*^9}, {
   3.5220088779091344`*^9, 3.5220089121884255`*^9}, {3.522008961749691*^9, 
   3.5220089659357104`*^9}, {3.522009002708587*^9, 3.5220090234183664`*^9}, {
   3.522092105816712*^9, 3.5220921058567696`*^9}, {3.522092202505744*^9, 
   3.522092210347019*^9}, {3.5220923798707824`*^9, 3.522092404646408*^9}, {
   3.5220925083355055`*^9, 3.5220925085157647`*^9}, {3.5220930408211823`*^9, 
   3.522093072707032*^9}, {3.522093119284006*^9, 3.5220931588909583`*^9}, {
   3.5220932453452735`*^9, 3.5220933286350384`*^9}, {3.522093383323677*^9, 
   3.5220933848859234`*^9}, {3.522094543852435*^9, 3.522094543892493*^9}, {
   3.522157512173173*^9, 3.5221575526513777`*^9}, {3.522157692111912*^9, 
   3.5221577284241266`*^9}, {3.5221579405691757`*^9, 3.522157940739421*^9}, {
   3.52215804898507*^9, 3.522158049175344*^9}, {3.5221582860359325`*^9, 
   3.5221582862161922`*^9}, {3.5221583435486317`*^9, 
   3.5221583437288914`*^9}, {3.5221590940578113`*^9, 
   3.5221590942380705`*^9}, {3.5221594627980337`*^9, 3.522159533740043*^9}, {
   3.5221595882083645`*^9, 3.5221595883986387`*^9}, {3.522159706889019*^9, 
   3.5221597135886526`*^9}, {3.5221598099972816`*^9, 3.522159883072358*^9}, {
   3.522167611475256*^9, 3.522167721914059*^9}, {3.522167774259328*^9, 
   3.522168047622405*^9}, {3.522168402011992*^9, 3.522168405867536*^9}, 
   3.5221686009780912`*^9, {3.522169146302229*^9, 3.522169152991848*^9}, {
   3.522169400267413*^9, 3.5221694128855567`*^9}, {3.522173320754797*^9, 
   3.522173330899384*^9}, {3.5221734635801697`*^9, 3.5221734858321667`*^9}, {
   3.522173612003592*^9, 3.5221736540640717`*^9}, {3.522174408128363*^9, 
   3.522174423951115*^9}, {3.522175417920373*^9, 3.5221754256014175`*^9}, 
   3.5221754963932114`*^9, {3.5221761577842445`*^9, 3.5221761689503007`*^9}, {
   3.522176218070933*^9, 3.522176244118387*^9}, {3.5221765183727455`*^9, 
   3.5221765325130787`*^9}, {3.5221768161509295`*^9, 3.522176844922301*^9}, {
   3.522176897217498*^9, 3.522176954990571*^9}, {3.5221771645919633`*^9, 
   3.5221771833289056`*^9}, {3.522177301939459*^9, 3.5221773111426926`*^9}, {
   3.522177818552312*^9, 3.522177825612464*^9}, {3.5221782207105875`*^9, 
   3.5221782421714463`*^9}, {3.522178339220997*^9, 3.522178350066592*^9}, {
   3.5221784365209074`*^9, 3.5221784532549696`*^9}, {3.522178854261589*^9, 
   3.522178892476539*^9}, {3.522178993311533*^9, 3.522178994042584*^9}, {
   3.522179369011763*^9, 3.522179379566941*^9}, {3.522179504236206*^9, 
   3.522179567166696*^9}, {3.5221796032285504`*^9, 3.5221796230270195`*^9}, 
   3.5221797099820547`*^9, {3.5221797486075954`*^9, 3.522179749208459*^9}, {
   3.5221798330890737`*^9, 3.522179885744789*^9}, {3.522180018776078*^9, 
   3.5221801838634624`*^9}, {3.52218032085044*^9, 3.5221803351610174`*^9}, {
   3.5221806170363345`*^9, 3.5221806359134784`*^9}, {3.5221807416254845`*^9, 
   3.522180823032542*^9}, 3.5221814335303955`*^9, {3.5221889607640257`*^9, 
   3.5221889642590513`*^9}, {3.522239812183416*^9, 3.5222398657203984`*^9}, {
   3.522240089722498*^9, 3.522240103632499*^9}, {3.5222403956323743`*^9, 
   3.5222403957926044`*^9}, {3.5222417446596193`*^9, 
   3.5222418998954926`*^9}, {3.5222419607199993`*^9, 
   3.5222419697524147`*^9}, {3.5222421498703313`*^9, 
   3.5222421956876116`*^9}, {3.5222434068677397`*^9, 3.522243419441362*^9}, {
   3.5222434909830875`*^9, 3.5222435135407267`*^9}, {3.5222436990562525`*^9, 
   3.522243706263466*^9}, {3.5222443946926746`*^9, 3.522244410245902*^9}, {
   3.5222467216607647`*^9, 3.5222467289303775`*^9}, {3.5222586108612475`*^9, 
   3.522258630766883*^9}, 3.5222595097972264`*^9, {3.5222595448192883`*^9, 
   3.5222595826025543`*^9}, {3.522259837366602*^9, 3.522259840658208*^9}, {
   3.5222601557475615`*^9, 3.522260157993965*^9}, {3.522609862348957*^9, 
   3.522609865553565*^9}, 3.5226099557532654`*^9, {3.522610214305045*^9, 
   3.52261023507491*^9}, {3.5226103567298417`*^9, 3.5226103576010942`*^9}, {
   3.522610430966589*^9, 3.5226104588466787`*^9}, {3.522610495609541*^9, 
   3.5226104961903763`*^9}, {3.5226106306937823`*^9, 3.522610634759629*^9}, {
   3.522610716737507*^9, 3.522610733050965*^9}, {3.5226109413204412`*^9, 
   3.522610946077282*^9}, {3.5226109881277475`*^9, 3.5226109992036734`*^9}, {
   3.5226110603515997`*^9, 3.5226110929985437`*^9}, {3.522611307336747*^9, 
   3.522611308087827*^9}, {3.5226113681041265`*^9, 3.5226113862802625`*^9}, {
   3.5226114810966015`*^9, 3.5226114836402593`*^9}, 3.5226118317908754`*^9, {
   3.522612535522792*^9, 3.5226125592669344`*^9}, {3.5226126326224146`*^9, 
   3.5226126589002*^9}, {3.5226127715021133`*^9, 3.5226128644357457`*^9}, {
   3.5226129857101297`*^9, 3.5226129925399504`*^9}, {3.5226135000196705`*^9, 
   3.522613540217472*^9}, {3.5226761678539534`*^9, 3.5226762419705276`*^9}, {
   3.522677849652261*^9, 3.522677867277605*^9}, {3.5226779272638607`*^9, 
   3.5226779759538736`*^9}, {3.5226780599947186`*^9, 
   3.5226780970279694`*^9}, {3.5226781539698477`*^9, 3.522678176402104*^9}, 
   3.522678213024765*^9, {3.522678313018549*^9, 3.5226783164635024`*^9}, {
   3.522695217926613*^9, 3.5226953317002115`*^9}, {3.522695380119835*^9, 
   3.522695572165984*^9}, {3.522695696594904*^9, 3.5226956979869056`*^9}, {
   3.5226957372333393`*^9, 3.522695796258213*^9}, {3.5226960177967696`*^9, 
   3.5226960515252686`*^9}, {3.522696083681507*^9, 3.5226960846428895`*^9}, {
   3.5226962171834736`*^9, 3.522696219897376*^9}, {3.5226962506015263`*^9, 
   3.522696277570306*^9}, {3.522696535981883*^9, 3.5226965603569326`*^9}, {
   3.52269667540236*^9, 3.522696787193107*^9}, {3.522696885554544*^9, 
   3.5226968885388355`*^9}, {3.522697068898179*^9, 3.5226970763689213`*^9}, {
   3.5226972474248877`*^9, 3.522697296124915*^9}, {3.5226973728953056`*^9, 
   3.5226974053319473`*^9}, {3.522697501780634*^9, 3.5226975279382467`*^9}, {
   3.522697562197509*^9, 3.5226976452369137`*^9}, {3.522697718071645*^9, 
   3.522697728676894*^9}, {3.522697799939365*^9, 3.522697905821616*^9}, {
   3.522698080793213*^9, 3.522698135802312*^9}, {3.522698259630368*^9, 
   3.522698332645358*^9}, {3.522698369658581*^9, 3.522698400322674*^9}, {
   3.5226985262537537`*^9, 3.5226986682078733`*^9}, {3.522708357900968*^9, 
   3.5227083684761744`*^9}, {3.5230212343789682`*^9, 
   3.5230212388253613`*^9}, {3.523022114494512*^9, 3.523022226335331*^9}, {
   3.5230223167753773`*^9, 3.523022340910082*^9}, {3.523022406714704*^9, 
   3.523022432652*^9}, {3.5230224646480083`*^9, 3.523022466771061*^9}, {
   3.5230225497603936`*^9, 3.523022551252539*^9}, {3.523022633861325*^9, 
   3.523022656023192*^9}, 3.523022802383648*^9, {3.523022908606389*^9, 
   3.523022982272315*^9}, {3.523023048267211*^9, 3.5230230554074783`*^9}, {
   3.523023128662814*^9, 3.523023148301053*^9}, {3.5230232083574095`*^9, 
   3.523023220705165*^9}, {3.523023314570136*^9, 3.523023411008808*^9}, {
   3.5230234869580173`*^9, 3.52302354441063*^9}, {3.5230235783594465`*^9, 
   3.5230235987587795`*^9}, {3.5230237809607725`*^9, 3.523023787420061*^9}, {
   3.523024096855006*^9, 3.5230241909402943`*^9}, {3.523024431456139*^9, 
   3.5230244732161875`*^9}, 3.523024556896514*^9, {3.5230246297612877`*^9, 
   3.5230246453436947`*^9}, {3.523024703637517*^9, 3.523024777764106*^9}, {
   3.5230310207310514`*^9, 3.5230310510947123`*^9}, 3.5230311746023073`*^9, {
   3.5230312392853165`*^9, 3.5230313405509295`*^9}, {3.5230314096102324`*^9, 
   3.5230316316495085`*^9}, {3.523031719455768*^9, 3.523031820531107*^9}, {
   3.5230318597675266`*^9, 3.5230318635830126`*^9}, {3.5230319560559826`*^9, 
   3.52303199665436*^9}, {3.5230320559996943`*^9, 3.5230320586835537`*^9}, {
   3.5230321168972607`*^9, 3.5230321257900476`*^9}, {3.5230327249916573`*^9, 
   3.5230327410146976`*^9}, {3.523032846175912*^9, 3.5230328531859922`*^9}, {
   3.5230330243521166`*^9, 3.523033036599728*^9}, {3.523033266650525*^9, 
   3.523033298926936*^9}, {3.5230338751454973`*^9, 3.523033898158589*^9}, {
   3.523033951315024*^9, 3.5230340070551744`*^9}, {3.5230342780949106`*^9, 
   3.523034284754486*^9}, {3.523034465354176*^9, 3.5230344736561136`*^9}, {
   3.523034524168747*^9, 3.523034556855749*^9}, {3.5230345963525424`*^9, 
   3.5230346056158624`*^9}, 3.523034909773219*^9, {3.523035034873104*^9, 
   3.5230350952799644`*^9}, {3.5230413816793633`*^9, 
   3.5230415323359966`*^9}, {3.523105988110733*^9, 3.5231059990965295`*^9}, {
   3.5231070657002306`*^9, 3.5231070815930834`*^9}, {3.5231071198380766`*^9, 
   3.523107132466235*^9}, {3.523107697028035*^9, 3.523107720421674*^9}, {
   3.5231095210808945`*^9, 3.52310952116101*^9}, {3.523625738888939*^9, 
   3.523625747891885*^9}, {3.5238213983225536`*^9, 3.523821398903389*^9}, {
   3.5238214818025923`*^9, 3.5238215447531104`*^9}, {3.5238217610441217`*^9, 
   3.523821782965643*^9}, {3.52382188742585*^9, 3.52382189459616*^9}, {
   3.523821977565464*^9, 3.5238219801491795`*^9}, {3.523822114262024*^9, 
   3.5238221172763586`*^9}, {3.5238225631474895`*^9, 
   3.5238225633978496`*^9}, {3.5238226734961634`*^9, 3.52382268914867*^9}, {
   3.523822761612869*^9, 3.523822761863229*^9}, {3.523822874435099*^9, 
   3.523822874935819*^9}, {3.52382383488616*^9, 3.523823872740592*^9}, {
   3.5238240571757965`*^9, 3.5238240606808367`*^9}, {3.5238243026988416`*^9, 
   3.523824315427144*^9}, {3.523824564034624*^9, 3.5238245767328835`*^9}, {
   3.523884518237204*^9, 3.5238845182972903`*^9}, {3.523885398072345*^9, 
   3.523885398853468*^9}, {3.523903667192049*^9, 3.523903741078292*^9}, {
   3.523906037440298*^9, 3.5239060620256505`*^9}, 3.5244211903881936`*^9, 
   3.5244212387677603`*^9, {3.524422554439603*^9, 3.5244225635326786`*^9}, {
   3.524422638210059*^9, 3.524422671688198*^9}, 3.52442271614212*^9, {
   3.524422868971878*^9, 3.52442288012792*^9}, {3.5244230484299264`*^9, 
   3.5244230591453342`*^9}, {3.5244233113179407`*^9, 
   3.5244233190791006`*^9}, {3.5244233574042096`*^9, 3.524423389760736*^9}, {
   3.524423501401267*^9, 3.524423526257008*^9}, {3.5244235676264944`*^9, 
   3.5244235711315346`*^9}, {3.5244239006253233`*^9, 3.524423907385043*^9}, {
   3.524424058241965*^9, 3.5244240587326703`*^9}, {3.5244241447163086`*^9, 
   3.524424194007186*^9}, {3.5244242503281713`*^9, 3.5244242508889775`*^9}, {
   3.524424564399784*^9, 3.524424605068262*^9}, {3.5244247568164654`*^9, 
   3.524424757257099*^9}, {3.524424966808419*^9, 3.52442498615624*^9}, {
   3.5244250712886543`*^9, 3.5244250964247985`*^9}, {3.5244252711660643`*^9, 
   3.524425323831794*^9}, {3.5244254179671535`*^9, 3.5244255427666063`*^9}, {
   3.524425600069003*^9, 3.5244256771698685`*^9}, {3.5244257788160286`*^9, 
   3.5244257993054914`*^9}, {3.524426814385104*^9, 3.5244268146254497`*^9}, {
   3.524427912814568*^9, 3.524427975945346*^9}, {3.524428259563168*^9, 
   3.524428263298539*^9}, {3.524489724166108*^9, 3.5244898154719515`*^9}, {
   3.52449018511143*^9, 3.5244902147048693`*^9}, {3.52449040445339*^9, 
   3.524490406466345*^9}, {3.524490986167254*^9, 3.524490993748382*^9}, {
   3.524491056170007*^9, 3.524491072864512*^9}, {3.5244925682156773`*^9, 
   3.524492593682805*^9}, {3.524492674700919*^9, 3.5244926761029625`*^9}, 
   3.5244927141183844`*^9, 3.524492778522277*^9, {3.5244928949219728`*^9, 
   3.524492933347993*^9}, {3.5244929893195925`*^9, 3.524493020745407*^9}, 
   3.5244930853696213`*^9, {3.52449315261766*^9, 3.5244931658769903`*^9}, {
   3.5244932734334126`*^9, 3.5244933038374343`*^9}, 3.5244933949193115`*^9, {
   3.5244934424280996`*^9, 3.524493443069028*^9}, 3.524493534431311*^9, {
   3.524493599124981*^9, 3.5244936001464605`*^9}, {3.524493656898632*^9, 
   3.524493661044635*^9}, 3.5244936993901553`*^9, 3.5244987782091465`*^9, {
   3.5244989226167946`*^9, 3.52449894222499*^9}, {3.5244990159009304`*^9, 
   3.5244990250540924`*^9}, {3.5244994836935835`*^9, 3.524499484214332*^9}, {
   3.5244995462435255`*^9, 3.524499554295103*^9}, {3.524499970884129*^9, 
   3.5244999787554474`*^9}, {3.5245001364421897`*^9, 3.52450018275879*^9}, {
   3.5245002543216925`*^9, 3.5245002694634647`*^9}, {3.5245003090804315`*^9, 
   3.524500309320777*^9}, {3.5245003643599195`*^9, 3.524500364830596*^9}, 
   3.524500458855798*^9, {3.5245007546311016`*^9, 3.52450075624342*^9}, {
   3.5245007870377*^9, 3.5245007881693277`*^9}, {3.524500823710433*^9, 
   3.524500838271371*^9}, {3.5245008958341417`*^9, 3.524500912438017*^9}, {
   3.5245009790738344`*^9, 3.5245009795745544`*^9}, {3.524501083113436*^9, 
   3.5245010846155963`*^9}, {3.5245012449661694`*^9, 3.524501288719083*^9}, {
   3.524501608508918*^9, 3.5245016288081064`*^9}, {3.524508437057889*^9, 
   3.5245084739909964`*^9}, {3.524508539605345*^9, 3.524508541057433*^9}, 
   3.524509267371822*^9, {3.5245126566053*^9, 3.5245126676311545`*^9}, {
   3.524512822113289*^9, 3.5245129124131336`*^9}, {3.524516282969756*^9, 
   3.5245163066538124`*^9}, {3.5245165160949736`*^9, 
   3.5245166386411867`*^9}, {3.5245167477480745`*^9, 
   3.5245167575321436`*^9}, {3.5245735710959053`*^9, 3.524573601579739*^9}, {
   3.5245736975277057`*^9, 3.5245737070213566`*^9}, {3.5245743991866417`*^9, 
   3.5245744023712206`*^9}, {3.629914125409974*^9, 3.62991413539841*^9}, {
   3.629914216229373*^9, 3.6299143047493963`*^9}, {3.629915010323661*^9, 
   3.629915066191371*^9}, {3.629915098127076*^9, 3.629915107980174*^9}, {
   3.629915140268135*^9, 3.62991517239645*^9}},
 FontSize->16],

Cell[CellGroupData[{

Cell[BoxData["\<\"Run through the input to create a input data plot\"\>"], \
"Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.629995530269765*^9}],

Cell[BoxData["\<\"Check G1 conditions **before ** G1 modifications \"\>"], \
"Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.629995531876731*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"                   Across face \"\>", "\[InvisibleSpace]", "1",
    "\[InvisibleSpace]", "\<\" and face\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" is it G1 at mid-param of edge?  volume of \
partials = \"\>", "\[InvisibleSpace]", "0.16365775918163497`"}],
  SequenceForm[
  "                   Across face ", 1, " and face", 2, 
   " is it G1 at mid-param of edge?  volume of partials = ", 
   0.16365775918163497`],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.6299955318915443`*^9}],

Cell[BoxData["\<\"Run the the data to do G1 correction \"\>"], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.62999553189221*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Guess pp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.7730263157894737`", ",",
        "0.2565789473684211`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0010964912280700678`", ",", "0.5625`", ",", "0.46710526315789486`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5625`", ",", "0.0010964912280700678`", ",", "0.46710526315789486`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7730263157894737`", ",", 
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.2565789473684211`"}], 
      "}"}]}], "}"}], "\[InvisibleSpace]", "\<\" qq=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.12280701754385956`", ",", "0.7368421052631579`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7368421052631579`", ",", "0.12280701754385956`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0.25`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" Guess rr \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.1622807017543859`", ",", "1.2236842105263157`", ",", 
       "0.3377192982456141`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.2967836257309939`", ",", "0.9108187134502923`", ",", 
       "0.5219298245614037`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.9225146198830407`", ",", "0.24707602339181273`", ",", 
       "0.49561403508771945`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.1973684210526314`", ",", "0.07456140350877187`", ",", 
       "0.25877192982456143`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Guess pp = ", {{-0.06907894736842109, 0.7730263157894737, 
   0.2565789473684211}, {0.0010964912280700678`, 0.5625, 
   0.46710526315789486`}, {0.5625, 0.0010964912280700678`, 
   0.46710526315789486`}, {0.7730263157894737, -0.06907894736842109, 
   0.2565789473684211}}, 
   " qq=", {{0, 1, 0.25}, {0.12280701754385956`, 0.7368421052631579, 
    0.4605263157894738}, {0.7368421052631579, 0.12280701754385956`, 
    0.4605263157894738}, {1., 0, 0.25}}, " Guess rr ", {{0.1622807017543859, 
   1.2236842105263157`, 0.3377192982456141}, {0.2967836257309939, 
   0.9108187134502923, 0.5219298245614037}, {0.9225146198830407, 
   0.24707602339181273`, 0.49561403508771945`}, {1.1973684210526314`, 
   0.07456140350877187, 0.25877192982456143`}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.62999553192584*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factors from degree 4 bndry: l0=\"\>", "\[InvisibleSpace]", 
   "0.3962264150943399`", "\[InvisibleSpace]", "\<\" m0=\"\>", 
   "\[InvisibleSpace]", "0.24528301886792472`", 
   "\[InvisibleSpace]", "\<\"  l1=\"\>", "\[InvisibleSpace]", 
   "0.5121951219512197`", "\[InvisibleSpace]", "\<\"  m1=\"\>", 
   "\[InvisibleSpace]", "0.9512195121951219`"}],
  SequenceForm[
  "Factors from degree 4 bndry: l0=", 0.3962264150943399, " m0=", 
   0.24528301886792472`, "  l1=", 0.5121951219512197, "  m1=", 
   0.9512195121951219],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.629995531928198*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Leaving inGbot1 \\npp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.7730263157894737`", ",",
        "0.2565789473684211`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.07602853386275349`", ",", "0.5049483426508528`", ",", 
       "0.4306842766789487`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5771382342907696`", ",", "0.004175964256766342`", ",", 
       "0.4299774108048654`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7730263157894737`", ",", 
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.2565789473684211`"}], 
      "}"}]}], "}"}], "\[InvisibleSpace]", "\<\"\\nqq= \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.12280701754385956`", ",", "0.7368421052631579`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7368421052631579`", ",", "0.12280701754385956`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0.25`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\nrr=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.1622807017543859`", ",", "1.2236842105263157`", ",", 
       "0.3377192982456141`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.35779554829365756`", ",", "0.8642784429202798`", ",", 
       "0.491604153734774`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.9232327341017902`", ",", "0.26116688323964254`", ",", 
       "0.4645814983870059`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.1973684210526314`", ",", "0.07456140350877187`", ",", 
       "0.25877192982456143`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Leaving inGbot1 \npp = ", {{-0.06907894736842109, 0.7730263157894737, 
   0.2565789473684211}, {0.07602853386275349, 0.5049483426508528, 
   0.4306842766789487}, {0.5771382342907696, 0.004175964256766342, 
   0.4299774108048654}, {0.7730263157894737, -0.06907894736842109, 
   0.2565789473684211}}, 
   "\nqq= ", {{0, 1, 0.25}, {0.12280701754385956`, 0.7368421052631579, 
    0.4605263157894738}, {0.7368421052631579, 0.12280701754385956`, 
    0.4605263157894738}, {1., 0, 0.25}}, "\nrr=", {{0.1622807017543859, 
   1.2236842105263157`, 0.3377192982456141}, {0.35779554829365756`, 
   0.8642784429202798, 0.491604153734774}, {0.9232327341017902, 
   0.26116688323964254`, 0.4645814983870059}, {1.1973684210526314`, 
   0.07456140350877187, 0.25877192982456143`}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.629995531930585*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Guess pp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1.1973684210526314`", ",", "0.07456140350877187`", ",", 
       "0.25877192982456143`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.9225146198830407`", ",", "0.24707602339181273`", ",", 
       "0.49561403508771945`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.2967836257309939`", ",", "0.9108187134502923`", ",", 
       "0.5219298245614037`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.1622807017543859`", ",", "1.2236842105263157`", ",", 
       "0.3377192982456141`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" qq=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7368421052631579`", ",", "0.12280701754385956`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.12280701754385956`", ",", "0.7368421052631579`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.25`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" Guess rr \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7730263157894737`", ",", 
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.2565789473684211`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5625`", ",", "0.0010964912280700678`", ",", "0.46710526315789486`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0010964912280700678`", ",", "0.5625`", ",", "0.46710526315789486`"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.7730263157894737`", ",",
        "0.2565789473684211`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Guess pp = ", {{1.1973684210526314`, 0.07456140350877187, 
   0.25877192982456143`}, {0.9225146198830407, 0.24707602339181273`, 
   0.49561403508771945`}, {0.2967836257309939, 0.9108187134502923, 
   0.5219298245614037}, {0.1622807017543859, 1.2236842105263157`, 
   0.3377192982456141}}, 
   " qq=", {{1., 0, 0.25}, {0.7368421052631579, 0.12280701754385956`, 
    0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
    0.4605263157894738}, {0, 1, 0.25}}, " Guess rr ", {{
   0.7730263157894737, -0.06907894736842109, 0.2565789473684211}, {0.5625, 
   0.0010964912280700678`, 0.46710526315789486`}, {0.0010964912280700678`, 
   0.5625, 0.46710526315789486`}, {-0.06907894736842109, 0.7730263157894737, 
   0.2565789473684211}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.62999553322491*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Factors from degree 4 bndry: l0=\"\>", "\[InvisibleSpace]", 
   "0.48780487804878053`", "\[InvisibleSpace]", "\<\" m0=\"\>", 
   "\[InvisibleSpace]", "0.04878048780487796`", 
   "\[InvisibleSpace]", "\<\"  l1=\"\>", "\[InvisibleSpace]", 
   "0.6037735849056605`", "\[InvisibleSpace]", "\<\"  m1=\"\>", 
   "\[InvisibleSpace]", "0.7547169811320761`"}],
  SequenceForm[
  "Factors from degree 4 bndry: l0=", 0.48780487804878053`, " m0=", 
   0.04878048780487796, "  l1=", 0.6037735849056605, "  m1=", 
   0.7547169811320761],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.629995533243761*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Leaving inGbot1 \\npp = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1.1973684210526314`", ",", "0.07456140350877187`", ",", 
       "0.25877192982456143`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.9232327341017901`", ",", "0.2611668832396433`", ",", 
       "0.46458149838700574`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.3577955482936576`", ",", "0.8642784429202794`", ",", 
       "0.49160415373477423`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.1622807017543859`", ",", "1.2236842105263157`", ",", 
       "0.3377192982456141`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\nqq= \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7368421052631579`", ",", "0.12280701754385956`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.12280701754385956`", ",", "0.7368421052631579`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.25`"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\nrr=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7730263157894737`", ",", 
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.2565789473684211`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5771382342907699`", ",", "0.004175964256765519`", ",", 
       "0.4299774108048655`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.07602853386275321`", ",", "0.5049483426508543`", ",", 
       "0.4306842766789486`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.7730263157894737`", ",",
        "0.2565789473684211`"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Leaving inGbot1 \npp = ", {{1.1973684210526314`, 0.07456140350877187, 
   0.25877192982456143`}, {0.9232327341017901, 0.2611668832396433, 
   0.46458149838700574`}, {0.3577955482936576, 0.8642784429202794, 
   0.49160415373477423`}, {0.1622807017543859, 1.2236842105263157`, 
   0.3377192982456141}}, 
   "\nqq= ", {{1., 0, 0.25}, {0.7368421052631579, 0.12280701754385956`, 
    0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
    0.4605263157894738}, {0, 1, 0.25}}, "\nrr=", {{
   0.7730263157894737, -0.06907894736842109, 0.2565789473684211}, {
   0.5771382342907699, 0.004175964256765519, 0.4299774108048655}, {
   0.07602853386275321, 0.5049483426508543, 
   0.4306842766789486}, {-0.06907894736842109, 0.7730263157894737, 
   0.2565789473684211}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.6299955332462053`*^9}],

Cell[BoxData["\<\"Check partials *after* G1 conditions: \"\>"], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.629995533635178*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"                   Across face \"\>", "\[InvisibleSpace]", "1",
    "\[InvisibleSpace]", "\<\" and face\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" is it G1 at mid-param of edge?  volume of \
partials = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "9.163760220105746`*^-9"}]}],
  SequenceForm[
  "                   Across face ", 1, " and face", 2, 
   " is it G1 at mid-param of edge?  volume of partials = ", \
-9.163760220105746*^-9],
  Editable->False]], "Print",
 CellChangeTimes->{3.629995060767915*^9, 3.6299953060291777`*^9, 
  3.6299953748359632`*^9, 3.6299955336503487`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJztWGk4ldvbV0kyNUonIkoyNEui3KgURaGIlCglQ5kTJWNlio2IQpvM8xQV
HnPbPGcrhMhUlIZjynmd497/b8+H/td7vdf74fhgXR57r2ete/3Wb7gFDa9r
GC1kYmISnfu1aG7c19RZtpb+GVoLNXf7rg4kDHL0b/YtaoA4iYIuTp8RcLFK
7e38SCX8G9MMj8XWg5wCz5enG4cglFMtQXFRApF+80EP2/s6YFM0ehwY+xHY
Fle++lqTStyLX7vAO6cWWAw2uMXx9UHQm+3fsx5lEOej2TVPbK2BbQ3FyhG+
PbBpa8Ls8mVZxP20TVffKVfBcjePjdYLu8Aw3eKSWlEWob9SsDWTiwYb6qSn
bWfpYO8V6yMWnUXsWlG4RedOOTzo99On8beAf79J18XUTELza94P9cgSSNKd
EnvXXwfNI51FefR0QuJL+GOFvkL4svJjaePqCuh6AFL1O5OJ8FYHj4CfudBx
w0/kZ9Mr4D9MjT9X/Yx4tt6tJvxWOjjaLQ+wY08Ey3BFtd1twQQtxnBL69RT
uP5DWs6fdRTeDto3eYlRgc2m68Dp1CZYz3Y9bubbCKj0f5+95OoJvu5PlD76
NMHGbZEelNwhWP6JT70o+AZBHeE4GM7bBL63+KjaFwbgUjv3leGeh8Qfw4XH
9CwaQaV3bfO6iT7YsXnwUGcAlYh9tU/WIqAB4qe6o0vu9YKc5PNT22tiieCo
p3JtHPXAJ+a3IoWnG7ITPPIU/BMJE46OsbHIGhgJiijx0n8Hzw2/yFg0JxO0
bherp32VINXq1bAm7Q3sEr4S5OGdQrASHIHt3RWwpmO3pIREE4h9Xqr2Pi2Z
YLZg7tkWVgrG9ha26rRq8BQIUbDfl0j8OHs1+xN3EWzUeBEt+boUVKKmIweF
Ygm5cu9Nqpl54PN1sf0UPQ8G7NKVDIyfEk3fp5vcGtPh5/QlrpXScWBspV2i
vCyAaH/B5TwtTAX/dWby0rQR8KDuUNT3zoZy6yGPVd9aoNmh1Y61dgi2pLHr
B2Ykg6M/5ZZmcQtcuzIuVBY/AIInR44+6qaCkHmcmKpQC2hNPhn0Me2HJ6NZ
KX50f9AYc7HrlGkGgTW18GvDB7B5qVAarn8IxGWcG+zm6v9cQIq5pakbkij1
0YdCPAmxbPUjr2obgHNgjOfiqk5g59mg91k3hPD+UXs8Pb0OHO5pUTLD6FBp
a6Dg8SOC2FDvuLPXuRryepabhyi3ACvvi/qZcipxd6nDIdfVNBB5vNQmSqIB
9BZry/7yiiIObw0wfmdVBp0POA9OhdPgj10bmi5XUoneI33C16OK4KNW0qZ2
m2JQuhkVbL40kngM7xTMNF5A0EIBcaXOHNCrez50+34IoejoGBz+Rwa49ize
LG30DJrj1KS0jnsRy4lrO+6pUGHyzrUQTrUhkFiwzrUhuxgk/tpAl6l7A5Ff
f4ouvz4AGvdT/uzQzIc9Gce/+wW8gVKNnuMuV/uhbsHZIwYTOSCSW+vj3NwK
IeUX3HnVPoC5jmyJiEI6dButuny0oAV6isPtJUV7QHjbQeA8FwsLDxyaWmrc
DN4xfJoJS7sg8xuzkKrAYyg13J71qrcRzCZjhFia22F39EJTn+T7IDN+38xl
bwO4T8pISBe0gnPovm6RX3KgahffaPCuBo4c+EYdb2mEFJGCjwF5zkTfBVaV
Yu5KeCqqPrVcpQas6DPuuqd9iEym4QY2kXLY/MFn67RZOazMLrj58Zs/EZgd
uCRlTTGc+L6/Z49iIfTZBvobVfoTXsk3o1TevAD7hFHxrN5MCHvSn5YZ4E0U
nzHcUXkqA1pu0s9BEBWk5Wo1lh5wJjKulzVbG1NBU4q7RTjhI8ywnliddrYK
lNZ4SFYDHToPpOfuGOyDu26TT9efqYCHCn1DHr/aIMbkNjc/ywfIe37NgRpe
Arm7X/1g2dIGm0Nqu1NW9sCzUeVXYhqFQDBV9POMtULKxxPhJbu7gF/eZ3Pf
r1x4eWcwU8OiBXJ6b4u3qrwF786js4LHM2GrbJ2bGNEEdxp1g1Id3oBen/Bb
roeJwLrWofvbYAP8KRS1g9bQBFv4JzY/Y40CUV7PxTBaC+dvhIiEz+GX3YGf
uYw5GFSzDYwEeyohYPprf6gkDeTz6u2Dhe+CBPM+5/HscriR2y3oIVsC2V81
pXSLrsKCu+NZXZbFcH4fz5v0iBdgNmrC28iuS9wdL1hx8cBL+Bz8WFmangZn
x3e08vw0I255vuEacc0At/w4/xmfcMiCCH1++hUiqkC5qeAOFaTU9twLHvwA
XQE7vaZmG2HFC+7HZUfaQelgw61RpV6wEavkbbhVDy5Lfn4VX9AOTFtWvsv1
7gYmx4y2epFq4D6zyyaTjw4aV+S8rnp2QkOd2G5vltfg4EU/3Fz9Bta/EW5x
mGyHalblKplNpaBopGCXub0VytVzXh+8+QbGP+ymCv5BAKttyc4l+s3gv231
MkWeZtjIsf7E1qA8YGq7KhR1tRHMw4Vdogrrgbh3syayKhM6KdYaJ3PqIHgZ
t2RvTiWMT2pt4KEkQfb5NEtemypIVBOVahMqA/dAYYFtotFg33DbUpa3Atzu
vH8TLVAII5ZbmFcRj8BgKauRWVYx0HxVVfsW58CT9Vtavif6wLmCZRIn7r2E
71ZBL/ImEsC0te/u6TRHYMnpf/s5OgOaappYQqZCoKpWJ+okpyFoe5kYGPpT
QZ4erWDL2wMObC4Csdvb4P5AE7vIx3Z4mTzwsG33e7jMVtb9MrUFbotffrY6
vB2GtFPTbJZ1wP67nQsddjXB6i62U5NpdBhYbM09+54OubYKHIGe9XDm46XL
y9XbQLjpaFBibiusOb7rG9FVBWrnOk3toluBwn1K6V5ME7RR+kb47Crgmrpu
cRvRDLUZAhpDpvVguvF6zIvzJVA4xpoamNsIHGeGL3T2V4K/du+R48oFcDp0
38v6rfWQU6DVbEYrA1m96lQL6nPYJ7+S/WdNFYy5Soc28xeB9EDrms6GdBBR
PZjy59w9GxYXGT3YnQvuJuFynrlxcJx+6v7I22Iw3lNTGuSUDrWL+GuFZyNA
/TLVuiLrJZRkPRePlHgGt0IdqmerKHD2wMNLJbkZcPppt9m0dQBYRgsIndd0
Ap1iMTf9MCqsrzLdkkbtAB4c06n5d8fXvQWloWNeSe/bQQVHhXOyR1c0tkOL
/VHhy8va/jOWrTEU2NhDh9RfF9hXKbRACo6n9PaEhd5umztfo0elro3/GWM+
vh3fVdUKR0MuGo8V1f5n3CWv90uhuxmOXOmt06TR4BCOlubcaimNjXCYemMy
TbwMDuK40EXCYLNWPXAJdfMJjxKwDEfFp0o66cNVMK1rvVbVKA9mcDygvlrs
sXkFzO5Uu21TngF/4Xiyx7mfb7AYVEQrhVYKxIMmjloegknhJS/hWsaL1CPf
noAejh0iBUH6hRngRD8hn/qnJ0TieDIkb3F2OBXuIC4PIE4Z+DRCXBYgThn4
lEJcDiBOVyA+cxCXDJwy8MmDuNyMOGXgk4649EOcMvBpibh8jThl4DMSccmC
OGXgUwZxmYU4lUZ8yiIuvyBORRGfrojLQcSpCuKzEnHJwOlJxKc74rICcXoB
8cnAJQOnDHz2Im9KIo8uR/5k8OYR5FF3Bn8iby5CHuVB/mxC3lRDHrVH/qxD
3uRDHlVA/pxC3ixFHl2K/CmOvPkAeXQB8mcZ8qYp8mg38ucU8uZj5NEXyJ8+
yJupyKO3kT8XWc3zphPy6EXkz1jkzSrk0QvIn97Imz+RR9mQP4/WzfNmCfLo
GeRP5qXzuq6OOn8E9d0ddb0LdT4E9f056voz1HmGviegrm9BnS9CfRdAXWfo
PEPfA1DXs1Hnt6G+G6Cu30KdZ0F9V0RdH0edF0N950RdZ+i8Guq7HOo6Q+e3
or6fGp/XdWvUeSbU9xrUdV3UeWfU902o659Q551Q3xm6ztB5hr5Lou+cQB+6
Hf3nSfSdDB8qif6zHn0nw4duRv9phb4zFH1oL/rP9eg7P6APXYT+Mwl9pw/6
UIb/vIC+0wR9qCz6T/mIed/phD5UGf1nMvrOQ+hDu9F/RqPvjEIfmoH+cwn6
ToYPfYj+8wP6zmPoQ++h//RH38nwoSXoP3XQd3ahD2X4zwDMRd6Ykxj5iB9z
USvmJEY+EsNcZIE5aSPmo2eYixg56RTmoyDMRYycxMhHaZiLGDmJkY+G18zn
IkZO8sN89ARzkR3mpI2Yj5gwF2VhTmLko0uYi8QwJylhPuLGXMTISYx8pIi5
iJGTwjEf6WAuYuSkg5iPGLmIkZMY+egb5nZzzPFcmN8FMbfzY473wfxePjKf
24Uxx0djfr+AuZ2R49dhfhfF3K6MOZ6R3xm5nZHjGfk9FXM7P+b465jfkzG3
D2COr8T8vhlz+17M8ZyY37dhbufBHL8Y87sH5vaLmOO/Y35XxNy+AXM8I7/3
YW6/jzmekd91Mbd/xhzPyO8/1v1jlPbP/vX3zxgwM/390wB92FeSxT6TPvaX
bmBfKRr7TIz+0iPsKwH2mTKxv7QY+0qMPpMX9pcYfSVGn4nRX9qIfSVGn8kH
+0t62FfixD6TEfaXrLGvtB77TIz+UhD2lRh9ppPYX2rCvlI89pnEsL/Ugn2l
UewzUbG/xId9JTr2maKwv8ToKzH6TIz+UlvfFc9TnKOg3kmr9t1tCUZuXd0l
2o3QQjnvunttKPhKun0u7LlH7HltzbldmgJlCyMSWc4Hw6UHs9Kpva4EJTC2
7LMqBfT6z+51fhYIs77SCwtjHIlYQ+Ptpy9QQP+kQu+hT/5QUWnivueKJVHo
bFZ46frcc2X2mnFTH2gpbKVp79QjDh93muF1pIBXSdiMO/M9GKE1NpkrHoMC
QccHDm4UmOFcWe8Z7QLrpCK4Dg+aQlSU6m7n+xTYtemk48Mge1iF43qt4VIJ
LwpY4Oe+4feS8PNd1fPznsH3FOL84gXz65DEdanheuJw3WdwHwSuPwn3KY/7
jsT9SmFdkrBOAVgf6WM/v3J8HYXVDlLLymLdCN4ck+Io1gZgFiqZzGwfgWRP
4TPdy3wJpeoVtuaCjbAqbPUdpV8jc/s8djFqIAace3jCvGqbocYj8Y4W1xgE
vun/Opz7APzjE26fu9QIKq8Wp/A+/wQ3wl487y58TGgm/iie+lAP4RfZvyjc
zgKHy1K7D9pFEOIa9Is79ieA51rPSzRqPGgcWMPkfyOIGD6UrSu7gvrb5870
tfyz35dPcFn61AYP7WSwMoyQH+hsBl/zR5QAtQzguG2nw3wnhFAXnH0TGZIA
Kw63nneqiwHtEzMOZgf8iJog3YnV+6ik+PmkBCJX5VOBZU2SZSP4E0ZTKzcY
9iWAVQzHHpOZKDh0dYB95pgHEe/JGqWuSyXFG/Guw8h8IAECJG9b1952IbRY
BQsMhRLhY+gG616Jp8ARuOq1hrwdcc+bR+ezDZUUn3LvmDNPPIyBvjVRa7m2
nCRM9WR3UtQTwUps+UXHkjC4MPDX6aGhvcQZD4tPffeppHgWOc++ZZsqFQJZ
6zR88h3h2UuxmW7LRBh31twcs+ch6O9pqb4WZQ0v37z7c08wlRT/Avk+smqb
wmBSev+An8ADiOcXDFJ2S4RNUxs535v6wcWcltplPu4Qde/2h64nVNL7YrMv
TzizjgKszG8td+iEgCr7NYMKj0Q4h9/nw/me4Dxk92vtzjR3L3CDm37c6gLl
kRAetj1f62YimOB+JnB/RbgvsvsooZcWr9qhA2p/ehYmbX4GRzfNjvw6lwiX
B+fra4H11sA6k93fc8a1R4+U2RP0iCvcdbbx4CMWIFq6OxFmA+bPexDP3wfP
ney+qw8r6S7y9SZGuz840muS4ecfl6MyphJAGfFngXiMRhyS8cOmlBsDqnwP
idbHRq5aQelQeFjbiZ6ZABp4H1bh/WjAe0HGJ2pCD+kd3HZg2+iUu3r6MyTv
3RbXNOcHhpAXKhk8gfwge6P8DxmJJ8QSFTt2ntJMUDQ7NqCilwCaeP/vIR/0
Iw/IONwUrTv7lNAPoAcr782GvmhevhvrEsANeYGGPLEV+eHGoaIL7aOfwDWC
OevyMWtCWmm//OOTczfWc0+SJfNnMDukcuIbfwjQTznZ0BLn/AzOy3gPY34m
5Me9yJd8yJPvZFcntbFmgvJSVv789lCCaI9OL3dIgKMVbG6XstPg2Srob84I
IPouOLddq0kA2toHHA06SWCUP2YFPneJypXuOXrLEv/zdzn+vwyfB+H35XC+
jzjPEXxfB76/DN/ryKIsmhF2Hxod4IuEsT0hl1bma6rlAsuFdBUzRz3AbXsi
i8Zxa+LHPq+40wYuMHOfXiBw0A0OUz3f8Z80I0RzulkDTFxgKsVVRuWRM2Ta
69M4JgwIQ7acyA1WLlAmcS6VudMRFvqKHypWUiNoBQfOLbB3gdV+fkY7feyA
aUmoyVPOvfAjf2qP5C0XuHAtjP5KzhL4o02TXhXrgrFMjuALJxfQG9rv7TV8
BV4Ozo8GAXd4/e+4gC1+7jR+zxI/r4Hz/vlg/j19OH+G1/w6zHFdRbieQFz3
OO6DsX5F3Ocw7nsF7vcq1oUL67RYZr4+VQMqJefZx6CWQ3xo01NdaGKPDs9P
awDtyolp7W3RwL4junK5B4Vgi71l4BgbSlp/oQjf0K61VOAy43p+J8eb2Puw
+cXetlDSc2FycZVqWhIBK//qqzkj6044JI3KOTCFkZ6X7mqtLVe7Q+HI/p4o
xQM3CUK8X1BeKIz0HP2cXu2ZyX8I13cs5djreZE4kzqx5t7+MNLz3S7TRFkc
Oad7UbNvTXK0wVPuxGnVE2Gk5x5jfn1odpk30Pi7luY22cLxZQXBFN0wUjx8
27F2D23cFaZwjMkP59E8H0aKkwycNwHfo4Tzk+HHBde9A/fhhOsnw9UM1iUW
66SH9SHFG9b9Gp5DAdafDIer8VzZ8Jzv4/mS4XMl4kYEcQSIHzLcVl9ft6jW
cwwu0ryWyL+9BUPX3ewccxpI8Unmr8g+T+a7uvOfT5c0JwPMnHeT7Qwi3mYu
0WEyjCHFOZm/IsM5mY8iwzmZXyLDOZkvIsM5mf8hwzmZzyHDOZmfIcM5mW8h
wzmZPyHDOZkPIcM5md8gwzmZr5C684dsqFwIkfxZxoL7YCrE8dl+3a4cQ4p/
jy+CG97cHIOJDnaV3FFrwqzOdvEClgZg06k11uAaBZGlQ6LazwOgQUx4lx5H
Eymf/6ub/51uclYscYIkAxg0qgpOXzgG2bJndCLzG+A18ogF8ooU8kligNma
ou+foY3vRsCu83eIkuqq2UfpDcCyu0r7gssoRHkun07SvEo87I/vWprZAHYV
K/xM/EZhKZ0jPt3KDbjVhkuUDRqhYPS7cXIVFcqaNj88K/6A0Ijjt6h9HUqq
v+zBtx+ufBUCuxJNpw0vzfllferRmwcpcOw+a9+ISSQkstqqGhbcJZpEk/Y/
+BZKqsv5qu1nNi14CJwbc1sr9ZyJGTYRcx9tCnQksLS5Kj6Gx7OGQXnaToSU
hMDRZp4wUr0eEL7Uue1oAIhV3Wrd6mVHmI6qTx0xpsD+hObWkPUhoPhl8aaJ
j+bEyqUcvGGSYaQ6Hrwg5mWKoB+MmDh0qDkYE9v39pon2VLgybKUFTG/AmD1
dyOWX87CILj+V1G3chipviv3J4u45nrCpMWNSSn1A4TlWLL+8zsUYLt3yFWZ
5gsT4+bqw84WoHpsPy1GO4xU97P3/7q5SdMdFP3Kz/zUMoDRkGAX47sUqODd
JScU4wGnCqeWURWdQXJ5rMLguTBSP2By65RW/shtKJ2YNP2qYA1SvH6RxZ4U
iJtQiaOIOgJvsefmQJ370LDOtyhOL4zUJ0hMzn+fC+eTwXkyxR8se218GTbX
ydmJK/iDhFGKbp9mGKl/sMH9PMX9DeO+aDtYjK0PaBDglvxtWi8IaLRt8REH
w0h9RdC1+frKYL1tsc4DxZI2Fbw2hILlbGOR0yPQXZ5b2iYeRuo3pPC8DfH8
xfHcuZcEC9jnuMzh7ETHX8+egIOXtwqFI4zUh9Aq5/HXgHi8jjh8lJz6xF7W
k1hOSbMUuPIUXm8q0avtDyX1JwvwPmTi/ZjAe/HxYOM6ezV/wurR0fcut6Lg
3DrX8Ae5oSCI93Ax3ktbvI/ZyOMMXr+OfC4f/K2a7jsKChsrnsQYP4LRBCvu
2Dk+X18573sq0QeNov9p/85yq9RoFNjibdlXcPoSAdsWyn5a0gB9lpTdrS6F
MHjijOkfB6nExF1nUd1f2RBRZFktejYX5LaILtm9/wnxI7LdReLPdBh4TONz
YMmBBv2OaZejT4jzmju7YmNSwL/WqZEq+JQY5elcP1xYAA4cZawFq3JAAr//
COdjzLPx++ni4cvBxETqpy8V27IgwZVp3+vvKXCS99ZlM2oM4azd0zVbXgRR
LTYZY4+zwd34/H39qChi1768ST2tl1Ao7D8ZF58OjgNjtuVBEUSIQ5uyYGkO
sF9WvybulgKcqGe6qG9cqGvterNGY3+NweHiNZIde8oKJyx0fv7dry54+Zlj
5Har3DBPJde7nNJCNcWz+bo2jXJW7t1cW3ua5K5fnNhePZFfWLN9Uf/Zueff
Aq3Erx9qkDOteqPa5ZFZ+GX9qza9ueelD6bphieq5ZJeih54L/y0MI/DLejc
3POyydzcAe4KORHd7VmLmdzkRGZ0ec/PPZcQrmMx7yiSe7H10qr+mAS5fZ8U
zf5+7h72Iav/cK7cR4nBf8avHTL3/n6+44XuP58z0W3453uqdfOfv3Vj1z/z
Thfk/fOetOyz/8y/8eD8Olhh5p91nY6bX4/P8/l18/bO74MaNr9+yxvz+6TS
5vcd+GB+v1175uvy/ft8nba4zdfnmm/EjRNjtMKx+0W8CevochftS8/pzD3P
PDP/t+fZ+f/bnZ5//m+d/7s6/1vPf+v5/7meuyKPzPbM8epRGzkhE/louSuP
Z4zXzPEqWZ1/t/6/ey6/e16/e46/e76/e+6/i4ffxcnv4ud3cfW7ePtdHP4u
PsmeG15S9/86h9tLE09OlY1XyRkGTqzl+V/E7b+88S8P/1/W838A9GzBpw==

    "], {
     {RGBColor[1, 0.8, 0.2], Opacity[1.], EdgeForm[None], Specularity[
       GrayLevel[1], 10], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmQn41lMWx3/3VdqkSFFKRQip0KJFUUpZkpBIq6ikQnaJpBClRSlCJNmi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          "]], Polygon3DBox[CompressedData["
1:eJwt02dLHVEUheGZsbffoMZulCAiYiSIiIiKIBcREQkiIhiIvQX/V2Lvvfde
Y4u9t1iSd3P2h4fDfLhzz95rTXBJpavCsSzrM9yxaFvWHoLhwgJ+Iwi5WMYB
QpCPeewiEDlYwj4+IA9uvHyDsxip2MY5PqIMO7hADMrRBYvfpHDWYQtniEYp
NnGKKJRgDX8QjiJc653kLp9s898niNQ7rOMYEfiKDrwiGTVox18koRpteEIi
qtCJd3xBLX7hBnH4jgDufqX/nQ1/ni85Y5GFFtwhHhW41R3n6jta8YAEVKIP
3rwjg7MJ3XAcs8t69MCd5zTOBvTDl+dMzh/ohSfP6ZyNWMEhQlGAUZ25WjMd
0ZmrNMNVHCEMhbi3TUdcOsOjZp6nd/6nmRTpjmzH7Fx2LZn6OKYDkr3M5OGY
TCVLmcHLMZlL1nJnP8d0RLohMz3bpoP5msmb3rFQM3zRGQs0Q9n9T3zTDMY1
w1qdaVh3LruWzg9pRpKNdH7CNp2ULkrHxmzTmRrd4YxmJNlIR6d157Jr6eig
dkS6Id/IpGYo2UkHpzRDyU46OqsZSnbyjcxhAM22+Ub+AxKSevo=
          "]]}],
       Lighting->Automatic]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJzteGk0ll3YdqEkUYmiqCRNRKWBwlkyVQilUkSK0iBKkygZEpUhpNBDJEIy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     "]], GraphicsComplex3DBox[CompressedData["
1:eJwdV3c8lt8bNiqSinZRVPoSZaSvCrlUGlZCKjIio76SKA1lpMgsLbMlm+y9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    "], {
     {RGBColor[1, 0.8, 0.2], Opacity[1.], EdgeForm[None], Specularity[
       GrayLevel[1], 10], 
      StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
         "]]],
       Lighting->Automatic]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJwVl2k0lV8bhyPRYChEk6QkRCMqyYNUIilp8Cc0UErIFEWSkEpSpiiZKvM8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     "]], 
   {RGBColor[0.7, 0.8, 0.3], PointSize[
    0.025], {Point3DBox[{{1., 0., 0.25}, {0.8026315789473684, 
      0.09210526315789466, 0.4078947368421053}, {0.4298245614035087, 
      0.4298245614035087, 0.4605263157894738}, {0.09210526315789466, 
      0.8026315789473684, 0.4078947368421053}, {0., 1., 0.25}}], 
     Point3DBox[{{0.7730263157894737, -0.06907894736842109, 
      0.2565789473684211}, {0.5625, 0.001096491228070054, 
      0.46710526315789486`}, {0.001096491228070054, 0.5625, 
      0.46710526315789486`}, {-0.06907894736842109, 0.7730263157894737, 
      0.2565789473684211}}], 
     Point3DBox[{{0.4585326953748006, -0.1028708133971292, 
      0.20893141945773525`}, {0.026913875598086154`, 0.09708931419457738, 
      0.291267942583732}, {-0.1028708133971292, 0.4585326953748006, 
      0.20893141945773525`}}], 
     Point3DBox[{{0.1647727272727273, -0.08522727272727271, 
      0.1193181818181818}, {-0.08522727272727271, 0.1647727272727273, 
      0.1193181818181818}}], Point3DBox[{{0., 0., 0.}}]}, 
    {GrayLevel[0.5], Thickness[0.003], 
     Line3DBox[{{0.7730263157894737, -0.06907894736842109, 
      0.2565789473684211}, {0.5373803827751196, 0.02422248803827741, 
      0.40380781499202556`}, {0.4585326953748006, -0.1028708133971292, 
      0.20893141945773525`}, {0.09708931419457738, 0.026913875598086154`, 
      0.291267942583732}, {0.1647727272727273, -0.08522727272727271, 
      0.1193181818181818}}], 
     Line3DBox[{{0.8026315789473684, 0.09210526315789466, 
      0.4078947368421053}, {0.5625, 0.001096491228070054, 
      0.46710526315789486`}, {0.4298245614035087, 0.4298245614035087, 
      0.4605263157894738}, {0.001096491228070054, 0.5625, 
      0.46710526315789486`}, {0.09210526315789466, 0.8026315789473684, 
      0.4078947368421053}}], 
     Line3DBox[{{-0.06907894736842109, 0.7730263157894737, 
      0.2565789473684211}, {0.02422248803827741, 0.5373803827751196, 
      0.40380781499202556`}, {-0.1028708133971292, 0.4585326953748006, 
      0.20893141945773525`}, {0.026913875598086154`, 0.09708931419457738, 
      0.291267942583732}, {-0.08522727272727271, 0.1647727272727273, 
      0.1193181818181818}}]}}, 
   {RGBColor[1, 0.5, 0.3], PointSize[
    0.025], {Point3DBox[{{1., 0, 0.25}, {0.7368421052631579, 
       0.12280701754385956`, 0.4605263157894738}, {0.12280701754385956`, 
       0.7368421052631579, 0.4605263157894738}, {0, 1, 0.25}}], 
     Point3DBox[{{1.1973684210526314`, 0.07456140350877187, 
      0.25877192982456143`}, {1.0258980785296572`, 0.2477025898078528, 
      0.43880534670008364`}, {0.3195488721804509, 0.9966583124477861, 
      0.5177527151211363}, {0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}}], 
     Point3DBox[{{1.369047619047619, 0.3214285714285714, 
      0.10714285714285716`}, {1.289264828738513, 0.5449039264828737, 
      0.2566833751044278}, {0.9060150375939848, 1.2852965747702592`, 
      0.32811194653299924`}, {0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}}], 
     Point3DBox[{{1.5, 0.5, 0}, {1.5119047619047619`, 0.7738095238095237, 
       0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
       0.11904761904761905`}, {1, 1.5, 0.}}]}, 
    {GrayLevel[0.5], Thickness[0.003], 
     Line3DBox[{{1.1973684210526314`, 0.07456140350877187, 
      0.25877192982456143`}, {1.0258980785296572`, 0.2477025898078528, 
      0.43880534670008364`}}], 
     Line3DBox[{{1.369047619047619, 0.3214285714285714, 
      0.10714285714285716`}, {1.289264828738513, 0.5449039264828737, 
      0.2566833751044278}}], 
     Line3DBox[{{0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}, {0.3195488721804509, 0.9966583124477861, 
      0.5177527151211363}}], 
     Line3DBox[{{0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}, {0.9060150375939848, 1.2852965747702592`, 
      0.32811194653299924`}}], 
     Line3DBox[{{0.7368421052631579, 0.12280701754385956`, 
      0.4605263157894738}, {0.9225146198830407, 0.24707602339181273`, 
      0.49561403508771945`}}], 
     Line3DBox[{{0.12280701754385956`, 0.7368421052631579, 
      0.4605263157894738}, {0.2967836257309939, 0.9108187134502923, 
      0.5219298245614037}}], 
     Line3DBox[{{1.5119047619047619`, 0.7738095238095237, 
      0.11904761904761908`}, {1.3293650793650793`, 0.6468253968253967, 
      0.25000000000000006`}}], 
     Line3DBox[{{1.226190476190476, 1.3452380952380953`, 
      0.11904761904761905`}, {0.992063492063492, 1.26984126984127, 
      0.27380952380952384`}}]}}, 
   {RGBColor[0.7, 0.8, 0.3], PointSize[
    0.025], {Point3DBox[{0.5373803827751196, 0.02422248803827741, 
      0.40380781499202556`}], 
     Point3DBox[{0.02422248803827741, 0.5373803827751196, 
      0.40380781499202556`}], 
     Point3DBox[{0.09708931419457738, 0.026913875598086154`, 
      0.291267942583732}], 
     Point3DBox[{0.5373803827751196, 0.02422248803827741, 
      0.40380781499202556`}]}, 
    {GrayLevel[0.5], Thickness[0.003]}}, 
   {RGBColor[1, 0.5, 0.3], PointSize[0.025], 
    Point3DBox[{{0.9225146198830407, 0.24707602339181273`, 
     0.49561403508771945`}, {0.2967836257309939, 0.9108187134502923, 
     0.5219298245614037}}], 
    Point3DBox[{{1.3293650793650793`, 0.6468253968253967, 
     0.25000000000000006`}, {0.992063492063492, 1.26984126984127, 
     0.27380952380952384`}}]}, 
   {RGBColor[0.7, 0.8, 0.3], Thickness[0.007], 
    Line3DBox[{{1., 0., 0.25}, {0.8026315789473684, 0.09210526315789466, 
     0.4078947368421053}, {0.4298245614035087, 0.4298245614035087, 
     0.4605263157894738}, {0.09210526315789466, 0.8026315789473684, 
     0.4078947368421053}, {0., 1., 0.25}}], 
    Line3DBox[{{1., 0., 0.25}, {0.7730263157894737, -0.06907894736842109, 
     0.2565789473684211}, {0.4585326953748006, -0.1028708133971292, 
     0.20893141945773525`}, {0.1647727272727273, -0.08522727272727271, 
     0.1193181818181818}, {0., 0., 0.}}], 
    Line3DBox[{{0., 1., 0.25}, {-0.06907894736842109, 0.7730263157894737, 
     0.2565789473684211}, {-0.1028708133971292, 0.4585326953748006, 
     0.20893141945773525`}, {-0.08522727272727271, 0.1647727272727273, 
     0.1193181818181818}, {0., 0., 0.}}], 
    {RGBColor[0.7, 0.8, 0.3], PointSize[0.025], 
     Point3DBox[{{1., 0., 0.25}, {0.8026315789473684, 0.09210526315789466, 
      0.4078947368421053}, {0.4298245614035087, 0.4298245614035087, 
      0.4605263157894738}, {0.09210526315789466, 0.8026315789473684, 
      0.4078947368421053}, {0., 1., 0.25}, {
      0.7730263157894737, -0.06907894736842109, 0.2565789473684211}, {
      0.4585326953748006, -0.1028708133971292, 0.20893141945773525`}, {
      0.1647727272727273, -0.08522727272727271, 0.1193181818181818}, {0., 0., 
      0.}, {-0.06907894736842109, 0.7730263157894737, 
      0.2565789473684211}, {-0.1028708133971292, 0.4585326953748006, 
      0.20893141945773525`}, {-0.08522727272727271, 0.1647727272727273, 
      0.1193181818181818}}]}}, 
   {RGBColor[1, 0.5, 0.3], Thickness[0.007], 
    Line3DBox[{{1., 0, 0.25}, {1.1973684210526314`, 0.07456140350877187, 
      0.25877192982456143`}, {1.369047619047619, 0.3214285714285714, 
      0.10714285714285716`}, {1.5, 0.5, 0}}], 
    Line3DBox[{{1.5, 0.5, 0}, {1.5119047619047619`, 0.7738095238095237, 
      0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
      0.11904761904761905`}, {1, 1.5, 0.}}], 
    Line3DBox[{{0, 1, 0.25}, {0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}, {0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}, {1, 1.5, 0.}}], 
    Line3DBox[{{1., 0, 0.25}, {0.7368421052631579, 0.12280701754385956`, 
      0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
      0.4605263157894738}, {0, 1, 0.25}}], 
    {RGBColor[1, 0.5, 0.3], PointSize[0.025], 
     Point3DBox[{{1., 0, 0.25}, {1.1973684210526314`, 0.07456140350877187, 
       0.25877192982456143`}, {1.369047619047619, 0.3214285714285714, 
       0.10714285714285716`}, {1.5, 0.5, 0}, {0, 1, 0.25}, {
       0.1622807017543859, 1.2236842105263157`, 0.3377192982456141}, {
       0.7142857142857143, 1.4761904761904763`, 0.1785714285714286}, {
       1, 1.5, 0.}, {0.7368421052631579, 0.12280701754385956`, 
       0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
       0.4605263157894738}, {1.5119047619047619`, 0.7738095238095237, 
       0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
       0.11904761904761905`}}]}}, 
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {0, 1, 0.25}, {0, 0., 0.}}]}, 
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {1.5, 0.5, 0}, {1, 1.5, 0.}, {0, 1, 0.25}}]}},
  Axes->False,
  Boxed->False,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{},
  PlotRange->Automatic,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  PreserveImageOptions->False,
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-0.1, -2, 3.1},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{3.629995064019644*^9, 3.6299953103308163`*^9, 
  3.629995378168784*^9, 3.629995533674184*^9}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJzteGk4lV/YPSWVORGZkkrIGEoZbkNKJYVQQkhIJDJlnjOWI0OO8ZhCmUKG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    "], {
     {RGBColor[1, 0.8, 0.2], Opacity[1.], EdgeForm[None], Specularity[
       GrayLevel[1], 10], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmQn41lMWx3/3VdqkSFFKRQip0KJFUUpZkpBIq6ikQnaJpBClRSlCJNmi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          "]], Polygon3DBox[CompressedData["
1:eJwt02dLHVEUheGZsbffoMZulCAiYiSIiIiKIBcREQkiIhiIvQX/V2Lvvfde
Y4u9t1iSd3P2h4fDfLhzz95rTXBJpavCsSzrM9yxaFvWHoLhwgJ+Iwi5WMYB
QpCPeewiEDlYwj4+IA9uvHyDsxip2MY5PqIMO7hADMrRBYvfpHDWYQtniEYp
NnGKKJRgDX8QjiJc653kLp9s898niNQ7rOMYEfiKDrwiGTVox18koRpteEIi
qtCJd3xBLX7hBnH4jgDufqX/nQ1/ni85Y5GFFtwhHhW41R3n6jta8YAEVKIP
3rwjg7MJ3XAcs8t69MCd5zTOBvTDl+dMzh/ohSfP6ZyNWMEhQlGAUZ25WjMd
0ZmrNMNVHCEMhbi3TUdcOsOjZp6nd/6nmRTpjmzH7Fx2LZn6OKYDkr3M5OGY
TCVLmcHLMZlL1nJnP8d0RLohMz3bpoP5msmb3rFQM3zRGQs0Q9n9T3zTDMY1
w1qdaVh3LruWzg9pRpKNdH7CNp2ULkrHxmzTmRrd4YxmJNlIR6d157Jr6eig
dkS6Id/IpGYo2UkHpzRDyU46OqsZSnbyjcxhAM22+Ub+AxKSevo=
          "]]}],
       Lighting->Automatic]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJzteGk4lV/0NqWJTEmSoUg0yJBKpSxFZMgsQyWESCgpDaZSppSKJskQypgh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     "]], GraphicsComplex3DBox[CompressedData["
1:eJwdV3k81F8XRqWohKSiiEoL2UkpjyKyZVfhV5JQlEoiSSqhTYiUilIpW8i+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    "], {
     {RGBColor[1, 0.8, 0.2], Opacity[1.], EdgeForm[None], Specularity[
       GrayLevel[1], 10], 
      StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
         "]]],
       Lighting->Automatic]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJwVl3dYze8bxxEpSiFKQoPSVFLI+JTV0pB8lShCJCm0SwpFibSkooX23kO9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     "]], 
   {RGBColor[0.7, 0.8, 0.3], PointSize[
    0.025], {Point3DBox[{{1., 0., 0.25}, {0.8026315789473684, 
      0.09210526315789466, 0.4078947368421053}, {0.4298245614035087, 
      0.4298245614035087, 0.4605263157894738}, {0.09210526315789466, 
      0.8026315789473684, 0.4078947368421053}, {0., 1., 0.25}}], 
     Point3DBox[{{0.7730263157894737, -0.06907894736842109, 
      0.2565789473684211}, {0.5771382342907696, 0.004175964256766342, 
      0.4299774108048654}, {0.07602853386275349, 0.5049483426508528, 
      0.4306842766789487}, {-0.06907894736842109, 0.7730263157894737, 
      0.2565789473684211}}], 
     Point3DBox[{{0.4585326953748006, -0.1028708133971292, 
      0.20893141945773525`}, {0.026913875598086154`, 0.09708931419457738, 
      0.291267942583732}, {-0.1028708133971292, 0.4585326953748006, 
      0.20893141945773525`}}], 
     Point3DBox[{{0.1647727272727273, -0.08522727272727271, 
      0.1193181818181818}, {-0.08522727272727271, 0.1647727272727273, 
      0.1193181818181818}}], Point3DBox[{{0., 0., 0.}}]}, 
    {GrayLevel[0.5], Thickness[0.003], 
     Line3DBox[{{0.7730263157894737, -0.06907894736842109, 
      0.2565789473684211}, {0.5373803827751196, 0.02422248803827741, 
      0.40380781499202556`}, {0.4585326953748006, -0.1028708133971292, 
      0.20893141945773525`}, {0.09708931419457738, 0.026913875598086154`, 
      0.291267942583732}, {0.1647727272727273, -0.08522727272727271, 
      0.1193181818181818}}], 
     Line3DBox[{{0.8026315789473684, 0.09210526315789466, 
      0.4078947368421053}, {0.5771382342907696, 0.004175964256766342, 
      0.4299774108048654}, {0.4298245614035087, 0.4298245614035087, 
      0.4605263157894738}, {0.07602853386275349, 0.5049483426508528, 
      0.4306842766789487}, {0.09210526315789466, 0.8026315789473684, 
      0.4078947368421053}}], 
     Line3DBox[{{-0.06907894736842109, 0.7730263157894737, 
      0.2565789473684211}, {0.02422248803827741, 0.5373803827751196, 
      0.40380781499202556`}, {-0.1028708133971292, 0.4585326953748006, 
      0.20893141945773525`}, {0.026913875598086154`, 0.09708931419457738, 
      0.291267942583732}, {-0.08522727272727271, 0.1647727272727273, 
      0.1193181818181818}}]}}, 
   {RGBColor[1, 0.5, 0.3], PointSize[
    0.025], {Point3DBox[{{1., 0, 0.25}, {0.7368421052631579, 
       0.12280701754385956`, 0.4605263157894738}, {0.12280701754385956`, 
       0.7368421052631579, 0.4605263157894738}, {0, 1, 0.25}}], 
     Point3DBox[{{1.1973684210526314`, 0.07456140350877187, 
      0.25877192982456143`}, {1.0258980785296572`, 0.2477025898078528, 
      0.43880534670008364`}, {0.3195488721804509, 0.9966583124477861, 
      0.5177527151211363}, {0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}}], 
     Point3DBox[{{1.369047619047619, 0.3214285714285714, 
      0.10714285714285716`}, {1.289264828738513, 0.5449039264828737, 
      0.2566833751044278}, {0.9060150375939848, 1.2852965747702592`, 
      0.32811194653299924`}, {0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}}], 
     Point3DBox[{{1.5, 0.5, 0}, {1.5119047619047619`, 0.7738095238095237, 
       0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
       0.11904761904761905`}, {1, 1.5, 0.}}]}, 
    {GrayLevel[0.5], Thickness[0.003], 
     Line3DBox[{{1.1973684210526314`, 0.07456140350877187, 
      0.25877192982456143`}, {1.0258980785296572`, 0.2477025898078528, 
      0.43880534670008364`}}], 
     Line3DBox[{{1.369047619047619, 0.3214285714285714, 
      0.10714285714285716`}, {1.289264828738513, 0.5449039264828737, 
      0.2566833751044278}}], 
     Line3DBox[{{0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}, {0.3195488721804509, 0.9966583124477861, 
      0.5177527151211363}}], 
     Line3DBox[{{0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}, {0.9060150375939848, 1.2852965747702592`, 
      0.32811194653299924`}}], 
     Line3DBox[{{0.7368421052631579, 0.12280701754385956`, 
      0.4605263157894738}, {0.9232327341017901, 0.2611668832396433, 
      0.46458149838700574`}}], 
     Line3DBox[{{0.12280701754385956`, 0.7368421052631579, 
      0.4605263157894738}, {0.3577955482936576, 0.8642784429202794, 
      0.49160415373477423`}}], 
     Line3DBox[{{1.5119047619047619`, 0.7738095238095237, 
      0.11904761904761908`}, {1.3293650793650793`, 0.6468253968253967, 
      0.25000000000000006`}}], 
     Line3DBox[{{1.226190476190476, 1.3452380952380953`, 
      0.11904761904761905`}, {0.992063492063492, 1.26984126984127, 
      0.27380952380952384`}}]}}, 
   {RGBColor[0.7, 0.8, 0.3], PointSize[0.025], 
    Point3DBox[{0.5373803827751196, 0.02422248803827741, 
     0.40380781499202556`}], 
    Point3DBox[{0.02422248803827741, 0.5373803827751196, 
     0.40380781499202556`}], 
    Point3DBox[{0.09708931419457738, 0.026913875598086154`, 
     0.291267942583732}], 
    Point3DBox[{0.5373803827751196, 0.02422248803827741, 
     0.40380781499202556`}]}, 
   {RGBColor[1, 0.5, 0.3], PointSize[0.025], 
    Point3DBox[{{0.9232327341017901, 0.2611668832396433, 
     0.46458149838700574`}, {0.3577955482936576, 0.8642784429202794, 
     0.49160415373477423`}}], 
    Point3DBox[{{1.3293650793650793`, 0.6468253968253967, 
     0.25000000000000006`}, {0.992063492063492, 1.26984126984127, 
     0.27380952380952384`}}]}, 
   {RGBColor[0.7, 0.8, 0.3], Thickness[0.007], 
    Line3DBox[{{1., 0., 0.25}, {0.8026315789473684, 0.09210526315789466, 
     0.4078947368421053}, {0.4298245614035087, 0.4298245614035087, 
     0.4605263157894738}, {0.09210526315789466, 0.8026315789473684, 
     0.4078947368421053}, {0., 1., 0.25}}], 
    Line3DBox[{{1., 0., 0.25}, {0.7730263157894737, -0.06907894736842109, 
     0.2565789473684211}, {0.4585326953748006, -0.1028708133971292, 
     0.20893141945773525`}, {0.1647727272727273, -0.08522727272727271, 
     0.1193181818181818}, {0., 0., 0.}}], 
    Line3DBox[{{0., 1., 0.25}, {-0.06907894736842109, 0.7730263157894737, 
     0.2565789473684211}, {-0.1028708133971292, 0.4585326953748006, 
     0.20893141945773525`}, {-0.08522727272727271, 0.1647727272727273, 
     0.1193181818181818}, {0., 0., 0.}}], 
    {RGBColor[0.7, 0.8, 0.3], PointSize[0.025], 
     Point3DBox[{{1., 0., 0.25}, {0.8026315789473684, 0.09210526315789466, 
      0.4078947368421053}, {0.4298245614035087, 0.4298245614035087, 
      0.4605263157894738}, {0.09210526315789466, 0.8026315789473684, 
      0.4078947368421053}, {0., 1., 0.25}, {
      0.7730263157894737, -0.06907894736842109, 0.2565789473684211}, {
      0.4585326953748006, -0.1028708133971292, 0.20893141945773525`}, {
      0.1647727272727273, -0.08522727272727271, 0.1193181818181818}, {0., 0., 
      0.}, {-0.06907894736842109, 0.7730263157894737, 
      0.2565789473684211}, {-0.1028708133971292, 0.4585326953748006, 
      0.20893141945773525`}, {-0.08522727272727271, 0.1647727272727273, 
      0.1193181818181818}}]}}, 
   {RGBColor[1, 0.5, 0.3], Thickness[0.007], 
    Line3DBox[{{1., 0, 0.25}, {1.1973684210526314`, 0.07456140350877187, 
      0.25877192982456143`}, {1.369047619047619, 0.3214285714285714, 
      0.10714285714285716`}, {1.5, 0.5, 0}}], 
    Line3DBox[{{1.5, 0.5, 0}, {1.5119047619047619`, 0.7738095238095237, 
      0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
      0.11904761904761905`}, {1, 1.5, 0.}}], 
    Line3DBox[{{0, 1, 0.25}, {0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}, {0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}, {1, 1.5, 0.}}], 
    Line3DBox[{{1., 0, 0.25}, {0.7368421052631579, 0.12280701754385956`, 
      0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
      0.4605263157894738}, {0, 1, 0.25}}], 
    {RGBColor[1, 0.5, 0.3], PointSize[0.025], 
     Point3DBox[{{1., 0, 0.25}, {1.1973684210526314`, 0.07456140350877187, 
       0.25877192982456143`}, {1.369047619047619, 0.3214285714285714, 
       0.10714285714285716`}, {1.5, 0.5, 0}, {0, 1, 0.25}, {
       0.1622807017543859, 1.2236842105263157`, 0.3377192982456141}, {
       0.7142857142857143, 1.4761904761904763`, 0.1785714285714286}, {
       1, 1.5, 0.}, {0.7368421052631579, 0.12280701754385956`, 
       0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
       0.4605263157894738}, {1.5119047619047619`, 0.7738095238095237, 
       0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
       0.11904761904761905`}}]}}, 
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {0, 1, 0.25}, {0, 0., 0.}}]}, 
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {1.5, 0.5, 0}, {1, 1.5, 0.}, {0, 1, 0.25}}]}},
  Axes->False,
  Boxed->False,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{},
  PlotRange->Automatic,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  PreserveImageOptions->False,
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-0.1, -2, 3.1},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{3.629995064019644*^9, 3.6299953103308163`*^9, 
  3.629995378168784*^9, 3.6299955337011538`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {0, 1, 0.25}, {0, 0., 0.}}]}, 
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {1.5, 0.5, 0}, {1, 1.5, 0.}, {0, 1, 0.25}}]}, 
   {GrayLevel[0.5], Thickness[0.007], 
    Line3DBox[{{1., 0, 0.25}, {0, 1, 0.25}, {0, 0., 0.}}], 
    Line3DBox[{{1., 0, 0.25}, {0, 0., 0.}}]}, 
   {GrayLevel[0.5], Thickness[0.007], 
    Line3DBox[{{1., 0, 0.25}, {1.5, 0.5, 0}, {1, 1.5, 0.}, {0, 1, 0.25}}], 
    Line3DBox[{{1., 0, 0.25}, {0, 1, 0.25}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    Arrow3DBox[{{1., 0, 0.25}, {1.2294157338705618`, -0.6882472016116854, 
      0.9382472016116854}}], 
    Arrow3DBox[{{0, 1, 0.25}, {-0.6882472016116854, 1.2294157338705618`, 
      0.9382472016116854}}], 
    Arrow3DBox[{{0, 0., 0.}, {-0.6396021490668312, -0.6396021490668312, 
      0.42640143271122083`}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    Arrow3DBox[{{1., 0, 0.25}, {1.2294157338705618`, -0.6882472016116854, 
      0.9382472016116854}}], 
    Arrow3DBox[{{1.5, 0.5, 0}, {2.3017837257372733`, 0.2327387580875756, 
      0.5345224838248488}}], 
    Arrow3DBox[{{1, 1.5, 0.}, {1.2672612419124243`, 2.3017837257372733`, 
      0.5345224838248488}}], 
    Arrow3DBox[{{0, 1, 0.25}, {-0.6882472016116854, 1.2294157338705618`, 
      0.9382472016116854}}]}},
  Axes->False,
  Boxed->False,
  PlotRange->Automatic,
  PreserveImageOptions->False,
  ViewPoint->{-0.1, -2, 3.1},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{3.629995064019644*^9, 3.6299953103308163`*^9, 
  3.629995378168784*^9, 3.629995533724122*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0], Thickness[0.007], 
    BezierCurve3DBox[{{1., 0., 0.25}, {0.8026315789473684, 
     0.09210526315789466, 0.4078947368421053}, {0.4298245614035087, 
     0.4298245614035087, 0.4605263157894738}, {0.09210526315789466, 
     0.8026315789473684, 0.4078947368421053}, {0., 1., 0.25}},
     SplineDegree->4], 
    BezierCurve3DBox[{{0., 1., 0.25}, {-0.06907894736842109, 
     0.7730263157894737, 0.2565789473684211}, {-0.1028708133971292, 
     0.4585326953748006, 0.20893141945773525`}, {-0.08522727272727271, 
     0.1647727272727273, 0.1193181818181818}, {0., 0., 0.}},
     SplineDegree->4], 
    BezierCurve3DBox[{{1., 0., 0.25}, {
     0.7730263157894737, -0.06907894736842109, 0.2565789473684211}, {
     0.4585326953748006, -0.1028708133971292, 0.20893141945773525`}, {
     0.1647727272727273, -0.08522727272727271, 0.1193181818181818}, {0., 0., 
     0.}},
     SplineDegree->4]}, 
   {GrayLevel[0], Thickness[0.007], 
    BezierCurve3DBox[{{1., 0, 0.25}, {1.1973684210526314`, 
      0.07456140350877187, 0.25877192982456143`}, {1.369047619047619, 
      0.3214285714285714, 0.10714285714285716`}, {1.5, 0.5, 0}}], 
    BezierCurve3DBox[{{1.5, 0.5, 0}, {1.5119047619047619`, 0.7738095238095237,
       0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
      0.11904761904761905`}, {1, 1.5, 0.}}], 
    BezierCurve3DBox[{{0, 1, 0.25}, {0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}, {0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}, {1, 1.5, 0.}}], 
    BezierCurve3DBox[{{1., 0, 0.25}, {0.7368421052631579, 
      0.12280701754385956`, 0.4605263157894738}, {0.12280701754385956`, 
      0.7368421052631579, 0.4605263157894738}, {0, 1, 0.25}}]}, 
   {RGBColor[0.7, 0.8, 0.3], Thickness[0.007], 
    Line3DBox[{{1., 0., 0.25}, {0.8026315789473684, 0.09210526315789466, 
     0.4078947368421053}, {0.4298245614035087, 0.4298245614035087, 
     0.4605263157894738}, {0.09210526315789466, 0.8026315789473684, 
     0.4078947368421053}, {0., 1., 0.25}}], 
    Line3DBox[{{1., 0., 0.25}, {0.7730263157894737, -0.06907894736842109, 
     0.2565789473684211}, {0.4585326953748006, -0.1028708133971292, 
     0.20893141945773525`}, {0.1647727272727273, -0.08522727272727271, 
     0.1193181818181818}, {0., 0., 0.}}], 
    Line3DBox[{{0., 1., 0.25}, {-0.06907894736842109, 0.7730263157894737, 
     0.2565789473684211}, {-0.1028708133971292, 0.4585326953748006, 
     0.20893141945773525`}, {-0.08522727272727271, 0.1647727272727273, 
     0.1193181818181818}, {0., 0., 0.}}], 
    {RGBColor[0.7, 0.8, 0.3], PointSize[0.025], 
     Point3DBox[{{1., 0., 0.25}, {0.8026315789473684, 0.09210526315789466, 
      0.4078947368421053}, {0.4298245614035087, 0.4298245614035087, 
      0.4605263157894738}, {0.09210526315789466, 0.8026315789473684, 
      0.4078947368421053}, {0., 1., 0.25}, {
      0.7730263157894737, -0.06907894736842109, 0.2565789473684211}, {
      0.4585326953748006, -0.1028708133971292, 0.20893141945773525`}, {
      0.1647727272727273, -0.08522727272727271, 0.1193181818181818}, {0., 0., 
      0.}, {-0.06907894736842109, 0.7730263157894737, 
      0.2565789473684211}, {-0.1028708133971292, 0.4585326953748006, 
      0.20893141945773525`}, {-0.08522727272727271, 0.1647727272727273, 
      0.1193181818181818}}]}}, 
   {RGBColor[1, 0.5, 0.3], Thickness[0.007], 
    Line3DBox[{{1., 0, 0.25}, {1.1973684210526314`, 0.07456140350877187, 
      0.25877192982456143`}, {1.369047619047619, 0.3214285714285714, 
      0.10714285714285716`}, {1.5, 0.5, 0}}], 
    Line3DBox[{{1.5, 0.5, 0}, {1.5119047619047619`, 0.7738095238095237, 
      0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
      0.11904761904761905`}, {1, 1.5, 0.}}], 
    Line3DBox[{{0, 1, 0.25}, {0.1622807017543859, 1.2236842105263157`, 
      0.3377192982456141}, {0.7142857142857143, 1.4761904761904763`, 
      0.1785714285714286}, {1, 1.5, 0.}}], 
    Line3DBox[{{1., 0, 0.25}, {0.7368421052631579, 0.12280701754385956`, 
      0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
      0.4605263157894738}, {0, 1, 0.25}}], 
    {RGBColor[1, 0.5, 0.3], PointSize[0.025], 
     Point3DBox[{{1., 0, 0.25}, {1.1973684210526314`, 0.07456140350877187, 
       0.25877192982456143`}, {1.369047619047619, 0.3214285714285714, 
       0.10714285714285716`}, {1.5, 0.5, 0}, {0, 1, 0.25}, {
       0.1622807017543859, 1.2236842105263157`, 0.3377192982456141}, {
       0.7142857142857143, 1.4761904761904763`, 0.1785714285714286}, {
       1, 1.5, 0.}, {0.7368421052631579, 0.12280701754385956`, 
       0.4605263157894738}, {0.12280701754385956`, 0.7368421052631579, 
       0.4605263157894738}, {1.5119047619047619`, 0.7738095238095237, 
       0.11904761904761908`}, {1.226190476190476, 1.3452380952380953`, 
       0.11904761904761905`}}]}}, 
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {0, 1, 0.25}, {0, 0., 0.}}]}, 
   {GrayLevel[0], PointSize[0.03], 
    Point3DBox[{{1., 0, 0.25}, {1.5, 0.5, 0}, {1, 1.5, 0.}, {0, 1, 0.25}}]}},
  Axes->False,
  Boxed->False,
  PlotRange->Automatic,
  PreserveImageOptions->False,
  ViewPoint->{-0.1, -2, 3.1},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{3.629995064019644*^9, 3.6299953103308163`*^9, 
  3.629995378168784*^9, 3.629995533776019*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["data"], "Input",
 CellChangeTimes->{{3.629986314245929*^9, 3.629986315901185*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "0.5`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1.5`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6299863169071903`*^9, 3.6299950643796587`*^9, 
  3.6299953108875523`*^9, 3.629995378277834*^9, 3.62999553396894*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"quadData", "=", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"quad1", ",", "1"}], "]"}], ",", "quad2"}], "]"}], "//", 
   "Sort"}]}]], "Input",
 CellChangeTimes->{{3.629987570445387*^9, 3.62998759803905*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.12280701754385956`", ",", "0.7368421052631579`", ",", 
     "0.4605263157894738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.1622807017543859`", ",", "1.2236842105263157`", ",", 
     "0.3377192982456141`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3195488721804509`", ",", "0.9966583124477861`", ",", 
     "0.5177527151211363`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3577955482936576`", ",", "0.8642784429202794`", ",", 
     "0.49160415373477423`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7142857142857143`", ",", "1.4761904761904763`", ",", 
     "0.1785714285714286`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7368421052631579`", ",", "0.12280701754385956`", ",", 
     "0.4605263157894738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9060150375939848`", ",", "1.2852965747702592`", ",", 
     "0.32811194653299924`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9232327341017901`", ",", "0.2611668832396433`", ",", 
     "0.46458149838700574`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.992063492063492`", ",", "1.26984126984127`", ",", 
     "0.27380952380952384`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1.5`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0258980785296572`", ",", "0.2477025898078528`", ",", 
     "0.43880534670008364`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.1973684210526314`", ",", "0.07456140350877187`", ",", 
     "0.25877192982456143`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.226190476190476`", ",", "1.3452380952380953`", ",", 
     "0.11904761904761905`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.289264828738513`", ",", "0.5449039264828737`", ",", 
     "0.2566833751044278`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3293650793650793`", ",", "0.6468253968253967`", ",", 
     "0.25000000000000006`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.369047619047619`", ",", "0.3214285714285714`", ",", 
     "0.10714285714285716`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "0.5`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.5119047619047619`", ",", "0.7738095238095237`", ",", 
     "0.11904761904761908`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6299875721178007`*^9, 3.629987598628726*^9}, 
   3.6299879469904213`*^9, 3.6299950644167957`*^9, 3.6299953109116898`*^9, 
   3.629995378285503*^9, 3.6299955339778757`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"quadData", "//", "ColumnForm"}]], "Input",
 CellChangeTimes->{{3.629987949932242*^9, 3.629987983265333*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.25`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.12280701754385956`", ",", "0.7368421052631579`", ",", 
       "0.4605263157894738`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.1622807017543859`", ",", "1.2236842105263157`", ",", 
       "0.3377192982456141`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.3195488721804509`", ",", "0.9966583124477861`", ",", 
       "0.5177527151211363`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.3577955482936576`", ",", "0.8642784429202794`", ",", 
       "0.49160415373477423`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.7142857142857143`", ",", "1.4761904761904763`", ",", 
       "0.1785714285714286`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.7368421052631579`", ",", "0.12280701754385956`", ",", 
       "0.4605263157894738`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.9060150375939848`", ",", "1.2852965747702592`", ",", 
       "0.32811194653299924`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.9232327341017901`", ",", "0.2611668832396433`", ",", 
       "0.46458149838700574`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "0.992063492063492`", ",", "1.26984126984127`", ",", 
       "0.27380952380952384`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5`", ",", "0.`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0.25`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1.0258980785296572`", ",", "0.2477025898078528`", ",", 
       "0.43880534670008364`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1.1973684210526314`", ",", "0.07456140350877187`", ",", 
       "0.25877192982456143`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1.226190476190476`", ",", "1.3452380952380953`", ",", 
       "0.11904761904761905`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1.289264828738513`", ",", "0.5449039264828737`", ",", 
       "0.2566833751044278`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1.3293650793650793`", ",", "0.6468253968253967`", ",", 
       "0.25000000000000006`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1.369047619047619`", ",", "0.3214285714285714`", ",", 
       "0.10714285714285716`"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1.5`", ",", "0.5`", ",", "0"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1.5119047619047619`", ",", "0.7738095238095237`", ",", 
       "0.11904761904761908`"}], "}"}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  ColumnForm[{{0, 1, 0.25}, {0.12280701754385956`, 0.7368421052631579, 
    0.4605263157894738}, {0.1622807017543859, 1.2236842105263157`, 
    0.3377192982456141}, {0.3195488721804509, 0.9966583124477861, 
    0.5177527151211363}, {0.3577955482936576, 0.8642784429202794, 
    0.49160415373477423`}, {0.7142857142857143, 1.4761904761904763`, 
    0.1785714285714286}, {0.7368421052631579, 0.12280701754385956`, 
    0.4605263157894738}, {0.9060150375939848, 1.2852965747702592`, 
    0.32811194653299924`}, {0.9232327341017901, 0.2611668832396433, 
    0.46458149838700574`}, {0.992063492063492, 1.26984126984127, 
    0.27380952380952384`}, {1, 1.5, 0.}, {1., 0, 0.25}, {1.0258980785296572`, 
    0.2477025898078528, 0.43880534670008364`}, {1.1973684210526314`, 
    0.07456140350877187, 0.25877192982456143`}, {1.226190476190476, 
    1.3452380952380953`, 0.11904761904761905`}, {1.289264828738513, 
    0.5449039264828737, 0.2566833751044278}, {1.3293650793650793`, 
    0.6468253968253967, 0.25000000000000006`}, {1.369047619047619, 
    0.3214285714285714, 0.10714285714285716`}, {1.5, 0.5, 0}, {
    1.5119047619047619`, 0.7738095238095237, 0.11904761904761908`}}],
  Editable->False]], "Output",
 CellChangeTimes->{{3.629987954345324*^9, 3.62998798398027*^9}, 
   3.6299950644556923`*^9, 3.629995310935758*^9, 3.629995378358242*^9, 
   3.629995534009514*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"triData", "=", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"tri1", ",", "1"}], "]"}], ",", "tri2"}], "]"}], "//", 
   "Sort"}]}]], "Input",
 CellChangeTimes->{{3.629915183667453*^9, 3.629915224143536*^9}, {
  3.629988076509585*^9, 3.629988077769167*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1028708133971292`"}], ",", "0.4585326953748006`", ",", 
     "0.20893141945773525`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.08522727272727271`"}], ",", "0.1647727272727273`", ",", 
     "0.1193181818181818`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.06907894736842109`"}], ",", "0.7730263157894737`", ",", 
     "0.2565789473684211`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.02422248803827741`", ",", "0.5373803827751196`", ",", 
     "0.40380781499202556`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.026913875598086154`", ",", "0.09708931419457738`", ",", 
     "0.291267942583732`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.07602853386275349`", ",", "0.5049483426508528`", ",", 
     "0.4306842766789487`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.09210526315789466`", ",", "0.8026315789473684`", ",", 
     "0.4078947368421053`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.09708931419457738`", ",", "0.026913875598086154`", ",", 
     "0.291267942583732`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1647727272727273`", ",", 
     RowBox[{"-", "0.08522727272727271`"}], ",", "0.1193181818181818`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.4298245614035087`", ",", "0.4298245614035087`", ",", 
     "0.4605263157894738`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4585326953748006`", ",", 
     RowBox[{"-", "0.1028708133971292`"}], ",", "0.20893141945773525`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.5373803827751196`", ",", "0.02422248803827741`", ",", 
     "0.40380781499202556`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.5771382342907696`", ",", "0.004175964256766342`", ",", 
     "0.4299774108048654`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7730263157894737`", ",", 
     RowBox[{"-", "0.06907894736842109`"}], ",", "0.2565789473684211`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8026315789473684`", ",", "0.09210526315789466`", ",", 
     "0.4078947368421053`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`", ",", "0.25`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.629914146399454*^9, 3.6299143135479803`*^9, 3.629915075565988*^9, 
   3.629915116491997*^9, {3.629915158186922*^9, 3.629915225071052*^9}, 
   3.629988078929923*^9, 3.6299950644964457`*^9, 3.629995310955907*^9, 
   3.629995378492969*^9, 3.629995534039261*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"triData", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1028708133971292`"}], ",", "0.4585326953748006`", ",", 
       "0.20893141945773525`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.08522727272727271`"}], ",", "0.1647727272727273`", ",",
        "0.1193181818181818`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.7730263157894737`", ",",
        "0.2565789473684211`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.02422248803827741`", ",", "0.5373803827751196`", ",", 
       "0.40380781499202556`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.026913875598086154`", ",", "0.09708931419457738`", ",", 
       "0.291267942583732`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.07602853386275349`", ",", "0.5049483426508528`", ",", 
       "0.4306842766789487`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09210526315789466`", ",", "0.8026315789473684`", ",", 
       "0.4078947368421053`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09708931419457738`", ",", "0.026913875598086154`", ",", 
       "0.291267942583732`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.1647727272727273`", ",", 
       RowBox[{"-", "0.08522727272727271`"}], ",", "0.1193181818181818`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4298245614035087`", ",", "0.4298245614035087`", ",", 
       "0.4605263157894738`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4585326953748006`", ",", 
       RowBox[{"-", "0.1028708133971292`"}], ",", "0.20893141945773525`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5373803827751196`", ",", "0.02422248803827741`", ",", 
       "0.40380781499202556`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5771382342907696`", ",", "0.004175964256766342`", ",", 
       "0.4299774108048654`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7730263157894737`", ",", 
       RowBox[{"-", "0.06907894736842109`"}], ",", "0.2565789473684211`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8026315789473684`", ",", "0.09210526315789466`", ",", 
       "0.4078947368421053`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.25`"}], "}"}]}], "}"}]}], ";"}]], \
"Input",
 CellChangeTimes->{{3.629987512058549*^9, 3.629987520211652*^9}, 
   3.62998809581619*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"triData", "//", "InputForm"}]], "Input",
 CellChangeTimes->{{3.629988203468061*^9, 3.629988216469429*^9}}],

Cell["\<\
{{-0.1028708133971292, 0.4585326953748006, 0.20893141945773525}, 
 {-0.08522727272727271, 0.1647727272727273, 0.1193181818181818}, 
 {-0.06907894736842109, 0.7730263157894737, 0.2565789473684211}, 
 {0, 0, 0}, {0., 1., 0.25}, {0.02422248803827741, 0.5373803827751196, 
  0.40380781499202556}, {0.026913875598086154, 0.09708931419457738, 
  0.291267942583732}, {0.07602853386275349, 0.5049483426508528, 
  0.4306842766789487}, {0.09210526315789466, 0.8026315789473684, 
  0.4078947368421053}, {0.09708931419457738, 0.026913875598086154, 
  0.291267942583732}, {0.1647727272727273, -0.08522727272727271, 
  0.1193181818181818}, {0.4298245614035087, 0.4298245614035087, 
  0.4605263157894738}, {0.4585326953748006, -0.1028708133971292, 
  0.20893141945773525}, {0.5373803827751196, 0.02422248803827741, 
  0.40380781499202556}, {0.5771382342907696, 0.004175964256766342, 
  0.4299774108048654}, {0.7730263157894737, -0.06907894736842109, 
  0.2565789473684211}, {0.8026315789473684, 0.09210526315789466, 
  0.4078947368421053}, {1., 0., 0.25}}\
\>", "Output",
 CellChangeTimes->{3.629988217443809*^9, 3.629995064538703*^9, 
  3.629995310990399*^9, 3.629995378539815*^9, 3.629995534087668*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"quadData", "//", "Flatten"}], "//", "Sort"}], "//", 
  "InputForm"}]], "Input",
 CellChangeTimes->{{3.62991432189151*^9, 3.629914326317233*^9}, {
  3.629988247459656*^9, 3.629988252404971*^9}, {3.6299886645691023`*^9, 
  3.629988673251093*^9}}],

Cell["\<\
{0, 0, 0, 0., 0.07456140350877187, 0.10714285714285716, 
 0.11904761904761905, 0.11904761904761908, 0.12280701754385956, 
 0.12280701754385956, 0.1622807017543859, 0.1785714285714286, 
 0.2477025898078528, 0.25, 0.25, 0.25000000000000006, 
 0.2566833751044278, 0.25877192982456143, 0.2611668832396433, 
 0.27380952380952384, 0.3195488721804509, 0.3214285714285714, 
 0.32811194653299924, 0.3377192982456141, 0.3577955482936576, 
 0.43880534670008364, 0.4605263157894738, 0.4605263157894738, 
 0.46458149838700574, 0.49160415373477423, 0.5, 0.5177527151211363, 
 0.5449039264828737, 0.6468253968253967, 0.7142857142857143, 
 0.7368421052631579, 0.7368421052631579, 0.7738095238095237, 
 0.8642784429202794, 0.9060150375939848, 0.9232327341017901, 
 0.992063492063492, 0.9966583124477861, 1, 1, 1., 1.0258980785296572, 
 1.1973684210526314, 1.2236842105263157, 1.226190476190476, 
 1.26984126984127, 1.2852965747702592, 1.289264828738513, 
 1.3293650793650793, 1.3452380952380953, 1.369047619047619, 
 1.4761904761904763, 1.5, 1.5, 1.5119047619047619}\
\>", "Output",
 CellChangeTimes->{3.62998825295674*^9, 3.6299886740560417`*^9, 
  3.6299950645649557`*^9, 3.629995311012644*^9, 3.6299953785756397`*^9, 
  3.6299955341171503`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"triData", "//", "Flatten"}], "//", "Sort"}], "//", 
  "InputForm"}]], "Input",
 CellChangeTimes->{{3.629988963584976*^9, 3.62998897185252*^9}}],

Cell["\<\
{-0.1028708133971292, -0.1028708133971292, -0.08522727272727271, 
 -0.08522727272727271, -0.06907894736842109, -0.06907894736842109, 0, 
 0, 0, 0., 0., 0.004175964256766342, 0.02422248803827741, 
 0.02422248803827741, 0.026913875598086154, 0.026913875598086154, 
 0.07602853386275349, 0.09210526315789466, 0.09210526315789466, 
 0.09708931419457738, 0.09708931419457738, 0.1193181818181818, 
 0.1193181818181818, 0.1647727272727273, 0.1647727272727273, 
 0.20893141945773525, 0.20893141945773525, 0.25, 0.25, 
 0.2565789473684211, 0.2565789473684211, 0.291267942583732, 
 0.291267942583732, 0.40380781499202556, 0.40380781499202556, 
 0.4078947368421053, 0.4078947368421053, 0.4298245614035087, 
 0.4298245614035087, 0.4299774108048654, 0.4306842766789487, 
 0.4585326953748006, 0.4585326953748006, 0.4605263157894738, 
 0.5049483426508528, 0.5373803827751196, 0.5373803827751196, 
 0.5771382342907696, 0.7730263157894737, 0.7730263157894737, 
 0.8026315789473684, 0.8026315789473684, 1., 1.}\
\>", "Output",
 CellChangeTimes->{3.629988972717009*^9, 3.629995064596562*^9, 
  3.629995311034511*^9, 3.629995378606063*^9, 3.629995534146764*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1082, 470},
WindowMargins->{{Automatic, 92}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.25,
FrontEndVersion->"10.0 for Linux x86 (64-bit) (June 27, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 1007, 15, 65, "Subtitle"],
Cell[CellGroupData[{
Cell[1611, 41, 132, 5, 117, "Section"],
Cell[CellGroupData[{
Cell[1768, 50, 10444, 223, 1423, "Input"],
Cell[12215, 275, 347, 7, 37, "Output"],
Cell[12565, 284, 1666, 46, 37, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14280, 336, 160, 6, 105, "Section"],
Cell[CellGroupData[{
Cell[14465, 346, 122817, 2803, 15343, "Input"],
Cell[CellGroupData[{
Cell[137307, 3153, 1326, 32, 101, "Print"],
Cell[138636, 3187, 1864, 41, 101, "Print"],
Cell[140503, 3230, 437, 9, 28, "Print"],
Cell[140943, 3241, 827, 18, 28, "Print"],
Cell[141773, 3261, 852, 18, 28, "Print"],
Cell[142628, 3281, 11967, 319, 234, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154656, 3607, 3515, 52, 105, "Section"],
Cell[158174, 3661, 68668, 1565, 7723, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226879, 5231, 227, 7, 171, "Section"],
Cell[227109, 5240, 24098, 493, 2023, "Input"],
Cell[251210, 5735, 11192, 262, 2246, "Input"],
Cell[262405, 5999, 15600, 257, 1470, "Input"],
Cell[278008, 6258, 22354, 473, 2512, "Input"],
Cell[300365, 6733, 9531, 280, 1835, "Input"],
Cell[309899, 7015, 12328, 182, 745, "Input"],
Cell[322230, 7199, 16233, 299, 1425, "Input"],
Cell[338466, 7500, 16268, 284, 1741, "Input"],
Cell[354737, 7786, 6255, 143, 1651, "Input"],
Cell[360995, 7931, 11124, 287, 1016, "Input"],
Cell[372122, 8220, 7009, 158, 1560, "Input"],
Cell[379134, 8380, 6740, 147, 1515, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[385911, 8532, 144, 4, 106, "Section"],
Cell[386058, 8538, 3232, 69, 583, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[389327, 8612, 303, 5, 58, "Section"],
Cell[CellGroupData[{
Cell[389655, 8621, 164932, 3200, 19663, "Input"],
Cell[CellGroupData[{
Cell[554612, 11825, 200, 3, 28, "Print"],
Cell[554815, 11830, 200, 3, 28, "Print"],
Cell[555018, 11835, 632, 12, 52, "Print"],
Cell[555653, 11849, 185, 2, 28, "Print"],
Cell[555841, 11853, 2824, 70, 121, "Print"],
Cell[558668, 11925, 715, 14, 28, "Print"],
Cell[559386, 11941, 2880, 70, 167, "Print"],
Cell[562269, 12013, 2824, 70, 121, "Print"],
Cell[565096, 12085, 717, 14, 28, "Print"],
Cell[565816, 12101, 2888, 71, 167, "Print"],
Cell[568707, 12174, 187, 2, 28, "Print"],
Cell[568897, 12178, 653, 13, 52, "Print"]
}, Open  ]],
Cell[569565, 12194, 53285, 897, 440, "Output"],
Cell[622853, 13093, 55975, 940, 440, "Output"],
Cell[678831, 14035, 1626, 35, 441, "Output"],
Cell[680460, 14072, 5333, 92, 434, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[685830, 14169, 96, 1, 37, "Input"],
Cell[685929, 14172, 561, 14, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[686527, 14191, 281, 8, 37, "Input"],
Cell[686811, 14201, 2695, 77, 182, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[689543, 14283, 132, 2, 37, "Input"],
Cell[689678, 14287, 4194, 119, 456, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[693909, 14411, 328, 9, 37, "Input"],
Cell[694240, 14422, 3377, 93, 230, "Output"]
}, Open  ]],
Cell[697632, 14518, 2672, 73, 374, InheritFromParent],
Cell[CellGroupData[{
Cell[700329, 14595, 130, 2, 37, "Input"],
Cell[700462, 14599, 1199, 19, 359, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[701698, 14623, 291, 7, 37, "Input"],
Cell[701992, 14632, 1240, 21, 379, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[703269, 14658, 190, 5, 37, "Input"],
Cell[703462, 14665, 1151, 19, 359, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
