/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import net.tinyos.comm.SerialPortEvent;
import net.tinyos.comm.SerialPortListener;
import net.tinyos.comm.TOSSerial;

public class ZigbitProgrammer
implements SerialPortListener {
    TOSSerial serial;
    protected InputStream is;
    protected OutputStream os;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n, long l) throws IOException {
        long l2 = System.currentTimeMillis() + l;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            InputStream inputStream = this.is;
            synchronized (inputStream) {
                if (this.is.available() > 0) {
                    byArray[n2++] = (byte)this.is.read();
                } else {
                    l = l2 - System.currentTimeMillis();
                    if (l <= 0L) {
                        return null;
                    }
                    try {
                        this.is.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent serialPortEvent) {
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            this.is.notify();
        }
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.os.write(byArray);
        this.os.flush();
    }

    public void closePort() throws IOException {
        if (this.serial != null) {
            this.is.close();
            this.os.close();
            this.serial.close();
            this.serial = null;
            this.is = null;
            this.os = null;
        }
    }

    public void openPort(String string) throws IOException {
        this.closePort();
        try {
            this.serial = new TOSSerial(string);
        }
        catch (Exception exception) {
            System.out.println("Cound not open port: " + string);
            System.exit(5);
        }
        this.serial.addListener(this);
        this.serial.notifyOn(1, true);
        this.is = this.serial.getInputStream();
        this.os = this.serial.getOutputStream();
    }

    public void setBaudrate(int n) {
        this.serial.setSerialPortParams(n, 8, 1, false);
    }

    public boolean resetTinyOS(int n) throws IOException {
        byte[] byArray = new byte[]{126, 68, 25, 114, 82, 83, 84, -71, 30, 126};
        byte[] byArray2 = new byte[]{126, 69, 114, 90, 66, 80, 118, 53, 126};
        byte[] byArray3 = new byte[byArray2.length];
        int[] nArray = n == 0 ? new int[]{57600, 230400, 115200, 38400} : new int[]{n};
        System.out.print("Resetting TinyOS ..");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                this.setBaudrate(nArray[j]);
                for (int k = 0; k < 2; ++k) {
                    long l;
                    System.out.print('.');
                    this.writeBytes(byArray);
                    long l2 = System.currentTimeMillis() + 200L;
                    while ((l = l2 - System.currentTimeMillis()) > 0L) {
                        byte[] byArray4 = this.readBytes(1, l);
                        if (byArray4 == null) continue;
                        System.arraycopy(byArray3, 1, byArray3, 0, byArray3.length - 1);
                        byArray3[byArray3.length - 1] = byArray4[0];
                        if (!Arrays.equals(byArray3, byArray2)) continue;
                        System.out.println(" done");
                        return true;
                    }
                }
            }
        }
        System.out.println(" failed");
        return false;
    }

    public void accessBootloder() throws IOException {
        byte[] byArray = new byte[]{-78, -91, 101, 75};
        byte[] byArray2 = new byte[]{105, -45, -46, 38};
        System.out.print("Connecting to bootloader ..");
        for (int i = 0; i < 20; ++i) {
            System.out.print('.');
            this.writeBytes(byArray);
            byte[] byArray3 = this.readBytes(4, 500L);
            if (byArray3 == null || !Arrays.equals(byArray3, byArray2)) continue;
            System.out.println(" done");
            return;
        }
        System.out.println(" failed");
        System.exit(1);
    }

    public void uploadFile(String string) throws FileNotFoundException, IOException {
        Scanner scanner = new Scanner(new File(string));
        ArrayList<String> arrayList = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            arrayList.add(scanner.nextLine());
        }
        byte[] byArray = new byte[]{77, 90, -102, -76};
        byte[] byArray2 = new byte[]{45, 89, 90, -78};
        System.out.print("Writing " + arrayList.size() + " pages to flash ...");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            byte[] byArray3 = new byte[1 + string2.length() / 2];
            byArray3[0] = (byte)string2.charAt(0);
            byArray3[1] = (byte)string2.charAt(1);
            for (int j = 2; j < byArray3.length; ++j) {
                byArray3[j] = (byte)Integer.parseInt(string2.substring(-2 + j * 2, j * 2), 16);
            }
            this.writeBytes(byArray3);
            byte[] byArray4 = this.readBytes(4, 50L);
            if (byArray4 == null) {
                System.out.println(" no response");
                System.exit(2);
                continue;
            }
            if (Arrays.equals(byArray4, byArray)) {
                if (i % 16 != 0) continue;
                System.out.print(".");
                continue;
            }
            if (Arrays.equals(byArray4, byArray2)) {
                System.out.println(" not accepted");
                System.exit(3);
                continue;
            }
            System.out.println(" incorrect response");
            System.exit(4);
        }
        System.out.println(" done");
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        String string = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        int n2 = 0;
        if (stringArray.length == 0) {
            System.out.println("Usage: java net.tinyos.util.ZigbitProgrammer <flags>");
            System.out.println("  where flags are the following");
            System.out.println("\t-port <name>\t\tsets the communication port (mandatory)");
            System.out.println("\t-baudrate <rate>\tsets the baudrate of TinyOS serial (0=auto)");
            System.out.println("\t-reset\t\t\tsoftware reset through TinyOS serial");
            System.out.println("\t-askforreset\t\tasks the user to reset the mote if needed");
            System.out.println("\t-sleep <seconds>\twaits (omitted if a reset fails)");
            System.out.println("\t-upload <srec file>\tuploads file through ZigBit bootloader");
            System.exit(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-port")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-baudrate")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-reset")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-askforreset")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-sleep")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-upload")) {
                string2 = stringArray[++i];
                continue;
            }
            System.out.println("Incorrect option: " + stringArray[i]);
            System.exit(6);
        }
        if (string == null) {
            System.out.println("The communication port is not specified");
            System.exit(6);
        }
        ZigbitProgrammer zigbitProgrammer = new ZigbitProgrammer();
        if (bl) {
            zigbitProgrammer.openPort(string);
            if (!zigbitProgrammer.resetTinyOS(n)) {
                n2 = 0;
            } else {
                bl2 = false;
            }
            zigbitProgrammer.closePort();
        }
        if (bl2) {
            System.out.println("Please reset the mote, than press enter");
            System.in.read();
        } else if (n2 > 0) {
            Thread.sleep(1000 * n2);
        }
        if (string2 != null) {
            zigbitProgrammer.openPort(string);
            zigbitProgrammer.setBaudrate(38400);
            zigbitProgrammer.accessBootloder();
            zigbitProgrammer.uploadFile(string2);
            zigbitProgrammer.closePort();
        }
    }
}

