/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLSet;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import java.util.NoSuchElementException;

public class Exists
implements ADQLConstraint {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "EXISTS", false, "An EXISTS constraint (which tests whether the given sub-query returns any row).");
    private ADQLSet subQuery;
    private TextPosition position = null;

    public Exists(ADQLSet query) {
        this.subQuery = query;
    }

    public Exists(Exists toCopy) throws Exception {
        this.subQuery = (ADQLSet)toCopy.subQuery.getCopy();
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final ADQLSet getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(ADQLSet query) throws NullPointerException {
        if (query == null) {
            throw new NullPointerException("Impossible to build an EXISTS constraint with a sub-query NULL!");
        }
        this.subQuery = query;
        this.position = null;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new Exists(this);
    }

    @Override
    public String getName() {
        return "EXISTS";
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean subQueryGot;
            {
                this.subQueryGot = Exists.this.subQuery == null;
            }

            @Override
            public ADQLObject next() {
                if (this.subQueryGot) {
                    throw new NoSuchElementException();
                }
                this.subQueryGot = true;
                return Exists.this.subQuery;
            }

            @Override
            public boolean hasNext() {
                return !this.subQueryGot;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLSet) {
                    Exists.this.subQuery = (ADQLSet)replacer;
                    Exists.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLSet by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                }
            }

            @Override
            public void remove() {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove the sub-query of an EXISTS constraint!");
            }
        };
    }

    @Override
    public String toADQL() {
        return this.getName() + "(" + this.subQuery.toADQL() + ")";
    }
}

