/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Pointer;
import uk.ac.bristol.star.cdf.record.RecordPlan;

public abstract class Record {
    private final RecordPlan plan_;
    private final String abbrev_;
    private final Logger logger_ = Logger.getLogger(Record.class.getName());

    protected Record(RecordPlan recordPlan, String string) {
        this.plan_ = recordPlan;
        this.abbrev_ = string;
    }

    protected Record(RecordPlan recordPlan, String string, int n) {
        this(recordPlan, string);
        int n2 = recordPlan.getRecordType();
        if (n2 != n) {
            throw new AssertionError((Object)("Incorrect record type (" + n2 + " != " + n + ")"));
        }
    }

    public long getRecordSize() {
        return this.plan_.getRecordSize();
    }

    public int getRecordType() {
        return this.plan_.getRecordType();
    }

    public Buf getBuf() {
        return this.plan_.getBuf();
    }

    public String getRecordTypeAbbreviation() {
        return this.abbrev_;
    }

    public long getContentOffset() {
        return this.plan_.createContentPointer().get();
    }

    protected void checkEndRecord(Pointer pointer) {
        long l;
        long l2 = this.plan_.getReadCount(pointer);
        if (l2 != (l = this.getRecordSize())) {
            this.warnFormat("Bytes read in record not equal to record size (" + l2 + " != " + l + ")");
        }
    }

    protected void warnFormat(String string) {
        assert (false) : string;
        this.logger_.warning(string);
    }

    public static int[] readIntArray(Buf buf, Pointer pointer, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = buf.readInt(pointer);
        }
        return nArray;
    }

    public static long[] readOffsetArray(Buf buf, Pointer pointer, int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = buf.readOffset(pointer);
        }
        return lArray;
    }

    public static String[] toLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean hasBit(int n, int n2) {
        return (n >> n2) % 2 == 1;
    }
}

