/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDOCUMENTFILTER_H
#define SKGDOCUMENTFILTER_H
/** @file
 * The grantlee's filter to get information from document.
 *
 * @author Stephane MANKOWSKI
 */
#include <QObject>
#include <grantlee/filter.h>

/**
 * The grantlee's filter to get items of a document table
 */
class SKGDocumentTableFilter : public Grantlee::Filter
{
public:
    /**
     * Do the filtering
     * @param input the input
     * @param argument the argument
     * @param autoescape the autoescape mode
     * @return the filtered value
     */
    virtual QVariant doFilter(const QVariant& input, const QVariant& argument = QVariant(), bool autoescape = false) const;

    /**
     * To know if the filter is safe
     * @return true or false
     */
    virtual bool isSafe() const;
};

/**
 * The grantlee's filter to get display of an attrivute
 */
class SKGDocumentDisplayFilter : public Grantlee::Filter
{
public:
    /**
     * Do the filtering
     * @param input the input
     * @param argument the argument
     * @param autoescape the autoescape mode
     * @return the filtered value
     */
    virtual QVariant doFilter(const QVariant& input, const QVariant& argument = QVariant(), bool autoescape = false) const;

    /**
     * To know if the filter is safe
     * @return true or false
     */
    virtual bool isSafe() const;
};

/**
 * The grantlee's filter to format percent
 */
class SKGPercentFilter : public Grantlee::Filter
{
public:
    /**
     * Do the filtering
     * @param input the input
     * @param argument the argument
     * @param autoescape the autoescape mode
     * @return the filtered value
     */
    virtual QVariant doFilter(const QVariant& input, const QVariant& argument = QVariant(), bool autoescape = false) const;

    /**
     * To know if the filter is safe
     * @return true or false
     */
    virtual bool isSafe() const;
};

/**
 * The grantlee's filter to dump objects
 */
class SKGDumpFilter : public Grantlee::Filter
{
public:
    /**
     * Do the filtering
     * @param input the input
     * @param argument the argument
     * @param autoescape the autoescape mode
     * @return the filtered value
     */
    virtual QVariant doFilter(const QVariant& input, const QVariant& argument = QVariant(), bool autoescape = false) const;

    /**
     * To know if the filter is safe
     * @return true or false
     */
    virtual bool isSafe() const;
};

/**
 * The grantlee's filter to format money
 */
class SKGMoneyFilter : public Grantlee::Filter
{
public:
    /**
     * Do the filtering
     * @param input the input
     * @param argument the argument
     * @param autoescape the autoescape mode
     * @return the filtered value
     */
    virtual QVariant doFilter(const QVariant& input, const QVariant& argument = QVariant(), bool autoescape = false) const;

    /**
     * To know if the filter is safe
     * @return true or false
     */
    virtual bool isSafe() const;
};

/**
 * The grantlee's filter to encode url
 */
class SKGUrlEncodeFilter : public Grantlee::Filter
{
public:
    /**
     * Do the filtering
     * @param input the input
     * @param argument the argument
     * @param autoescape the autoescape mode
     * @return the filtered value
     */
    virtual QVariant doFilter(const QVariant& input, const QVariant& argument = QVariant(), bool autoescape = false) const;

    /**
     * To know if the filter is safe
     * @return true or false
     */
    virtual bool isSafe() const;
};
#endif  // SKGDOCUMENTFILTER_H
