/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli DISMAN-SCHEDULE-MIB
 *
 * Derived from DISMAN-SCHEDULE-MIB:
 *   This MIB module defines a MIB which provides mechanisms to
 *   schedule SNMP set operations periodically or at specific
 *   points in time.
 *
 * Revision 2002-01-07 00:00:
 *   Revised version, published as RFC 3231.
 *   
 *   This revision introduces a new object type called
 *   schedTriggers.  Created new conformance and compliance
 *   statements that take care of the new schedTriggers object.
 *   
 *   Several clarifications have been added to remove ambiguities
 *   that were discovered and reported by implementors.
 *
 * Revision 1998-11-17 18:00:
 *   Initial version, published as RFC 2591.
 *
 * $Id: disman-schedule-mib.c 3180 2009-07-29 22:36:13Z schoenw $
 */

#include "disman-schedule-mib.h"

GNetSnmpEnum const disman_schedule_mib_enums_schedType[] = {
    { DISMAN_SCHEDULE_MIB_SCHEDTYPE_PERIODIC, "periodic" },
    { DISMAN_SCHEDULE_MIB_SCHEDTYPE_CALENDAR, "calendar" },
    { DISMAN_SCHEDULE_MIB_SCHEDTYPE_ONESHOT,  "oneshot" },
    { 0, NULL }
};

GNetSnmpEnum const disman_schedule_mib_enums_schedAdminStatus[] = {
    { DISMAN_SCHEDULE_MIB_SCHEDADMINSTATUS_ENABLED,  "enabled" },
    { DISMAN_SCHEDULE_MIB_SCHEDADMINSTATUS_DISABLED, "disabled" },
    { 0, NULL }
};

GNetSnmpEnum const disman_schedule_mib_enums_schedOperStatus[] = {
    { DISMAN_SCHEDULE_MIB_SCHEDOPERSTATUS_ENABLED,  "enabled" },
    { DISMAN_SCHEDULE_MIB_SCHEDOPERSTATUS_DISABLED, "disabled" },
    { DISMAN_SCHEDULE_MIB_SCHEDOPERSTATUS_FINISHED, "finished" },
    { 0, NULL }
};

GNetSnmpEnum const disman_schedule_mib_enums_SnmpPduErrorStatus[] = {
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_NORESPONSE,          "noResponse" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_NOERROR,             "noError" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_TOOBIG,              "tooBig" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_NOSUCHNAME,          "noSuchName" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_BADVALUE,            "badValue" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_READONLY,            "readOnly" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_GENERR,              "genErr" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_NOACCESS,            "noAccess" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_WRONGTYPE,           "wrongType" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_WRONGLENGTH,         "wrongLength" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_WRONGENCODING,       "wrongEncoding" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_WRONGVALUE,          "wrongValue" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_NOCREATION,          "noCreation" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_INCONSISTENTVALUE,   "inconsistentValue" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_RESOURCEUNAVAILABLE, "resourceUnavailable" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_COMMITFAILED,        "commitFailed" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_UNDOFAILED,          "undoFailed" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_AUTHORIZATIONERROR,  "authorizationError" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_NOTWRITABLE,         "notWritable" },
    { DISMAN_SCHEDULE_MIB_SNMPPDUERRORSTATUS_INCONSISTENTNAME,    "inconsistentName" },
    { 0, NULL }
};


static guint32 const schedActionFailure[]
	= { DISMAN_SCHEDULE_MIB_SCHEDACTIONFAILURE };

GNetSnmpIdentity const disman_schedule_mib_notifications[] = {
    { schedActionFailure,
      G_N_ELEMENTS(schedActionFailure),
      "schedActionFailure" },
    { 0, 0, NULL }
};


static guint16 schedLocalTime_constraints[] = {11U, 11U, 0, 0};
static guint16 schedDescr_constraints[] = {0U, 255U, 0, 0};
static guint16 schedContextName_constraints[] = {0U, 32U, 0, 0};
static guint16 schedLastFailed_constraints[] = {8U, 8U, 11, 11, 0, 0};


static guint32 const schedObjects_oid[] = {1, 3, 6, 1, 2, 1, 63, 1};

static GNetSnmpAttribute schedObjects_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDLOCALTIME, "schedLocalTime",
       schedLocalTime_constraints,
      G_STRUCT_OFFSET(disman_schedule_mib_schedObjects_t, schedLocalTime),
      11,
      GSNMP_ATTR_FLAG_FIXED_LENGTH },
    { 0, 0, 0, NULL }
};

static guint32 const schedEntry_oid[] = {1, 3, 6, 1, 2, 1, 63, 1, 2, 1};

static GNetSnmpAttribute schedEntry_attr[] = {
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDDESCR, "schedDescr",
       schedDescr_constraints,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedDescr),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedDescrLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      DISMAN_SCHEDULE_MIB_SCHEDINTERVAL, "schedInterval",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedInterval),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDWEEKDAY, "schedWeekDay",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedWeekDay),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedWeekDayLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDMONTH, "schedMonth",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedMonth),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedMonthLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDDAY, "schedDay",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedDay),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedDayLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDHOUR, "schedHour",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedHour),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedHourLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDMINUTE, "schedMinute",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedMinute),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedMinuteLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDCONTEXTNAME, "schedContextName",
       schedContextName_constraints,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedContextName),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedContextNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      DISMAN_SCHEDULE_MIB_SCHEDVARIABLE, "schedVariable",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedVariable),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedVariableLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCHEDULE_MIB_SCHEDVALUE, "schedValue",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedValue),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCHEDULE_MIB_SCHEDTYPE, "schedType",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCHEDULE_MIB_SCHEDADMINSTATUS, "schedAdminStatus",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCHEDULE_MIB_SCHEDOPERSTATUS, "schedOperStatus",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedOperStatus),
      0,
      0 },
    { 16, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      DISMAN_SCHEDULE_MIB_SCHEDFAILURES, "schedFailures",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedFailures),
      0,
      0 },
    { 17, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCHEDULE_MIB_SCHEDLASTFAILURE, "schedLastFailure",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedLastFailure),
      0,
      0 },
    { 18, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCHEDULE_MIB_SCHEDLASTFAILED, "schedLastFailed",
       schedLastFailed_constraints,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedLastFailed),
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, _schedLastFailedLength),
      0 },
    { 19, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCHEDULE_MIB_SCHEDSTORAGETYPE, "schedStorageType",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedStorageType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 20, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCHEDULE_MIB_SCHEDROWSTATUS, "schedRowStatus",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 21, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      DISMAN_SCHEDULE_MIB_SCHEDTRIGGERS, "schedTriggers",
       NULL,
      G_STRUCT_OFFSET(disman_schedule_mib_schedEntry_t, schedTriggers),
      0,
      0 },
    { 0, 0, 0, NULL }
};


disman_schedule_mib_schedObjects_t *
disman_schedule_mib_new_schedObjects()
{
    disman_schedule_mib_schedObjects_t *schedObjects;

    schedObjects = (disman_schedule_mib_schedObjects_t *) g_malloc0(sizeof(disman_schedule_mib_schedObjects_t) + sizeof(gpointer));
    return schedObjects;
}

static inline disman_schedule_mib_schedObjects_t *
assign_schedObjects(GList *vbl)
{
    disman_schedule_mib_schedObjects_t *schedObjects;
    char *p;

    schedObjects = disman_schedule_mib_new_schedObjects();
    p = (char *) schedObjects + sizeof(disman_schedule_mib_schedObjects_t);
    * (GList **) p = vbl;

    gnet_snmp_attr_assign(vbl, schedObjects_oid, G_N_ELEMENTS(schedObjects_oid),
                      schedObjects_attr, schedObjects);

    return schedObjects;
}

void
disman_schedule_mib_get_schedObjects(GNetSnmp *s, disman_schedule_mib_schedObjects_t **schedObjects, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    static const guint32 _base[] = {1, 3, 6, 1, 2, 1, 63, 1, 0};
    guint32 base[128];

    *schedObjects = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 9, 8, schedObjects_attr, mask);

    out = gnet_snmp_sync_getnext(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if ((error && *error) || s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *schedObjects = assign_schedObjects(out);
    }
}

void
disman_schedule_mib_free_schedObjects(disman_schedule_mib_schedObjects_t *schedObjects)
{
    GList *vbl;
    char *p;

    if (schedObjects) {
        p = (char *) schedObjects + sizeof(disman_schedule_mib_schedObjects_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(schedObjects);
    }
}

disman_schedule_mib_schedEntry_t *
disman_schedule_mib_new_schedEntry()
{
    disman_schedule_mib_schedEntry_t *schedEntry;

    schedEntry = (disman_schedule_mib_schedEntry_t *) g_malloc0(sizeof(disman_schedule_mib_schedEntry_t) + sizeof(gpointer));
    return schedEntry;
}

static inline int
unpack_schedEntry(GNetSnmpVarBind *vb, disman_schedule_mib_schedEntry_t *schedEntry)
{
    guint8 idx = 11;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        schedEntry->schedOwner[i] = vb->oid[idx++];
    }
    schedEntry->_schedOwnerLength = len;
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len < 1 || len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        schedEntry->schedName[i] = vb->oid[idx++];
    }
    schedEntry->_schedNameLength = len;
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_schedEntry(guint32 *base, guchar *schedOwner, guint16 _schedOwnerLength, guchar *schedName, guint16 _schedNameLength)
{
    guint8 idx = 11;
    guint16 i, len;

    len = _schedOwnerLength;
    base[idx++] = len;
    if (len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = schedOwner[i];
        if (idx >= 128) return -1;
    }
    len = _schedNameLength;
    base[idx++] = len;
    if (len < 1 || len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = schedName[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline disman_schedule_mib_schedEntry_t *
assign_schedEntry(GList *vbl)
{
    disman_schedule_mib_schedEntry_t *schedEntry;
    char *p;

    schedEntry = disman_schedule_mib_new_schedEntry();
    p = (char *) schedEntry + sizeof(disman_schedule_mib_schedEntry_t);
    * (GList **) p = vbl;

    if (unpack_schedEntry((GNetSnmpVarBind *) vbl->data, schedEntry) < 0) {
        g_warning("%s: invalid instance identifier", "schedEntry");
        g_free(schedEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, schedEntry_oid, G_N_ELEMENTS(schedEntry_oid),
                      schedEntry_attr, schedEntry);

    return schedEntry;
}

void
disman_schedule_mib_get_schedTable(GNetSnmp *s, disman_schedule_mib_schedEntry_t ***schedEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 63, 1, 2, 1, 0};
    guint32 base[128];

    *schedEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, schedEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *schedEntry = (disman_schedule_mib_schedEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(disman_schedule_mib_schedEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*schedEntry)[i] = assign_schedEntry(row->data);
        }
    }
}

void
disman_schedule_mib_get_schedEntry(GNetSnmp *s, disman_schedule_mib_schedEntry_t **schedEntry, guchar *schedOwner, guint16 _schedOwnerLength, guchar *schedName, guint16 _schedNameLength, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, schedEntry_oid, sizeof(schedEntry_oid));
    len = pack_schedEntry(base, schedOwner, _schedOwnerLength, schedName, _schedNameLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "schedEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *schedEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, schedEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *schedEntry = assign_schedEntry(out);
    }
}

void
disman_schedule_mib_set_schedEntry(GNetSnmp *s, disman_schedule_mib_schedEntry_t *schedEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, schedEntry_oid, sizeof(schedEntry_oid));
    len = pack_schedEntry(base, schedEntry->schedOwner, schedEntry->_schedOwnerLength, schedEntry->schedName, schedEntry->_schedNameLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "schedEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, schedEntry_attr, mask, schedEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
disman_schedule_mib_free_schedEntry(disman_schedule_mib_schedEntry_t *schedEntry)
{
    GList *vbl;
    char *p;

    if (schedEntry) {
        p = (char *) schedEntry + sizeof(disman_schedule_mib_schedEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(schedEntry);
    }
}

void
disman_schedule_mib_free_schedTable(disman_schedule_mib_schedEntry_t **schedEntry)
{
    int i;

    if (schedEntry) {
        for (i = 0; schedEntry[i]; i++) {
            disman_schedule_mib_free_schedEntry(schedEntry[i]);
        }
        g_free(schedEntry);
    }
}


