// ============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Sylvain GENIN
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================

// <-- CLI SHELL MODE -->
// <-- NO CHECK REF -->

s = %s;
empty = [];
r = 2;
R = [1,2;3,4];
R3(:,:,1) = R;
R3(:,:,2) = R';
c = 1 + 2*%i;
C = [1+2*%i,2+4*%i;3+6*%i,4+8*%i];
C3(:,:,1) = C;
C3(:,:,2) = C';
e = eye();
ec = (5+%i) * eye();
p = 1 + %s - %s**2;
pc = 1 + %s - %s**2 + (2 - 3 * %s + 4 * %s**2 ) * %i;
P = [2*p,-3*p;4*p,-5*p];
PC = [2*pc,-3*pc;4*pc,-5*pc];
SP = sparse([1,2;4,5;3,10],[1,2,3]);
SPC = sparse([1,2;4,5;3,10],[1,2,3]) * (1 + 4*%i);
SP1 = sparse([1,1],[10]);
SPC1 = sparse([1,1],[1]) * (2 + 6*%i);

i8 = int8(-8);
ui8 = uint8(8);
I8 = int8([-8 -16 ; -24 -32]);
UI8 = uint8([8 16 ; 24 32]);

I16 = int16([-16 -32 ; -48 -64]);
UI16 = uint16([16 32 ; 48 64]);
i16 = int16(-16);
ui16 = uint16(16);

i32 = int32(-32);
ui32 = uint32(32);
I32 = int32([-32 -64 ; -96 -128]);
UI32 = uint32([32 64 ; 96 128]);

assert_checkequal(empty .\ empty, []);
assert_checkequal(empty .\ r, []);
assert_checkequal(empty .\ c, []);
assert_checkequal(empty .\ R, []);
assert_checkequal(empty .\ C, []);
assert_checkequal(empty .\ e, []);
assert_checkequal(empty .\ ec, []);
assert_checkequal(empty .\ p, []);
assert_checkequal(empty .\ pc, []);
assert_checkequal(empty .\ P, []);
assert_checkequal(empty .\ PC, []);
assert_checkequal(empty .\ SP, []);
assert_checkequal(empty .\ SPC, []);
assert_checkequal(empty .\ SP1, []);
assert_checkequal(empty .\ SPC1, []);

assert_checkequal(r .\ empty, []);
assert_checkequal(r .\ r, 1);
assert_checkequal(r .\ c, 0.5+%i);
assert_checkequal(r .\ R, [0.5, 1; 1.5, 2]);
assert_checkequal(r .\ C, [0.5+%i, 1+%i* 2; 1.5+%i* 3, 2+%i* 4]);
assert_checkequal(r .\ e, (0.5)*eye());
assert_checkequal(r .\ ec, (2.5+%i* 0.5)*eye());
assert_checkequal(r .\ p, 0.5+(0.5)*s+(- 0.5)*s^ 2);
assert_checkequal(r .\ pc, 0.5+%i+(0.5-%i* 1.5)*s+(- 0.5+%i* 2)*s^ 2);
assert_checkequal(r .\ P, [1+(1)*s+(- 1)*s^ 2,- 1.5+(- 1.5)*s+(1.5)*s^ 2;2+(2)*s+(- 2)*s^ 2,- 2.5+(- 2.5)*s+(2.5)*s^ 2]);
assert_checkequal(r .\ PC, [1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,- 1.5-%i* 3+(- 1.5+%i* 4.5)*s+(1.5-%i* 6)*s^ 2;2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 2.5-%i* 5+(- 2.5+%i* 7.5)*s+(2.5-%i* 10)*s^ 2]);
assert_checkequal(r .\ SP, sparse([1, 2; 3, 10; 4, 5],[0.5; 1.5; 1],[4, 10]));
assert_checkequal(r .\ SPC, sparse([1, 2; 3, 10; 4, 5],[0.5+%i* 2; 1.5+%i* 6; 1+%i* 4],[4, 10]));
assert_checkequal(r .\ SP1, sparse([1, 1], 5,[1, 1]));
assert_checkequal(r .\ SPC1, sparse([1, 1], 1+%i* 3,[1, 1]));
assert_checkequal(r .\ i8, int8(- 4));
assert_checkequal(r .\ I8, int8([- 4, - 8; - 12, - 16]));
assert_checkequal(r .\ ui8, uint8(4));
assert_checkequal(r .\ UI8, uint8([4, 8; 12, 16]));
assert_checkequal(r .\ i16, int16(- 8));
assert_checkequal(r .\ I16, int16([- 8, - 16; - 24, - 32]));
assert_checkequal(r .\ ui16, uint16(8));
assert_checkequal(r .\ UI16, uint16([8, 16; 24, 32]));
assert_checkequal(r .\ i32, int32(- 16));
assert_checkequal(r .\ I32, int32([- 16, - 32; - 48, - 64]));
assert_checkequal(r .\ ui32, uint32(16));
assert_checkequal(r .\ UI32, uint32([16, 32; 48, 64]));

assert_checkequal(c .\ empty, []);
assert_checkalmostequal(c .\ r,  0.4-%i* 0.8);
assert_checkequal(c .\ c,  1+%i*0);
assert_checkalmostequal(c .\ R, [0.2-%i* 0.4, 0.4-%i* 0.8; 0.6-%i* 1.2, 0.8-%i* 1.6]);
assert_checkequal(c .\ C, [1, 2; 3, 4]+%i*0);
assert_checkequal(c .\ e, (1+%i*2)*eye());
assert_checkequal(c .\ ec, (1.4-%i* 1.8)*eye());
assert_checkalmostequal(coeff(c .\ p), coeff(0.2-%i*0.4+(0.2-%i*0.4)*s+(-0.2+%i*0.4)*s^2));
assert_checkequal(c .\ pc, 1+(- 1-%i)*s+(1.4+%i* 1.2)*s^ 2);
assert_checkalmostequal(coeff(c .\ P), coeff([0.4-%i*0.8+(0.4-%i*0.8)*s+(-0.4+%i*0.8)*s^2,-0.6+%i*1.2+(-0.6+%i*1.2)*s+(0.6-%i*1.2)*s^2;0.8-%i*1.6+(0.8-%i*1.6)*s+(-0.8+%i*1.6)*s^2,-1+%i*2+(-1+%i*2)*s+(1-%i*2)*s^2]));
assert_checkequal(c .\ PC, [2+(- 2-%i* 2)*s+(2.8+%i* 2.4)*s^ 2,- 3+(3+%i* 3)*s+(- 4.2-%i* 3.6)*s^ 2;4+(- 4-%i* 4)*s+(5.6+%i* 4.8)*s^ 2,- 5+(5+%i* 5)*s+(- 7-%i* 6)*s^ 2]);
assert_checkequal(c .\ SP, sparse([1, 2; 3, 10; 4, 5],[0.2-%i* 0.4; 0.6-%i* 1.2; 0.4-%i* 0.8],[4, 10]));
assert_checkequal(c .\ SPC, sparse([1, 2; 3, 10; 4, 5],[1.8+%i* 0.4; 5.4+%i* 1.2; 3.6+%i* 0.8],[4, 10]));
assert_checkequal(c .\ SP1, sparse([1, 1], 2-%i* 4,[1, 1]));
assert_checkequal(c .\ SPC1, sparse([1, 1], 2.8+%i* 0.4,[1, 1]));

assert_checkequal(R .\ empty, []);
assert_checkequal(R .\ r, [2, 1; (2/3), 0.5]);
assert_checkequal(R .\ c,  [ 1+%i*2, 0.5+%i; (1/3)+%i*(2/3), 0.25+%i*0.5]);
assert_checkequal(R .\ R, [1, 1; 1, 1]);
assert_checkequal(R .\ C, [1+%i* 2, 1+%i* 2; 1+%i* 2, 1+%i* 2]);
assert_checkequal(R .\ p, [1+(1)*s+(- 1)*s^ 2,0.5+(0.5)*s+(- 0.5)*s^ 2;(1/3)+(1/3)*s+(- (1/3))*s^ 2,0.25+(0.25)*s+(- 0.25)*s^ 2]);
assert_checkequal(R .\ pc, [1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,0.5+%i+(0.5-%i* 1.5)*s+(- 0.5+%i* 2)*s^ 2;(1/3)+%i* (2/3)+((1/3)-%i)*s+(- (1/3)+%i* (1+1/3))*s^ 2,0.25+%i* 0.5+(0.25-%i* 0.75)*s+(- 0.25+%i)*s^ 2]);
assert_checkequal(R .\ P, [2+(2)*s+(- 2)*s^ 2,- 1.5+(- 1.5)*s+(1.5)*s^ 2;(1+1/3)+(1+1/3)*s+(- (1+1/3))*s^ 2,- 1.25+(- 1.25)*s+(1.25)*s^ 2]);
assert_checkequal(R .\ PC, [2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 1.5-%i* 3+(- 1.5+%i* 4.5)*s+(1.5-%i* 6)*s^ 2;(1+1/3)+%i* (2+2/3)+((1+1/3)-%i* 4)*s+(- (1+1/3)+%i* (5+1/3))*s^ 2,- 1.25-%i* 2.5+(- 1.25+%i* 3.75)*s+(1.25-%i* 5)*s^ 2]);
assert_checkequal(R .\ SPC1,  [ 2+%i*6, 1+%i*3; (2/3)+%i*2, 0.5+%i*1.5]);
assert_checkequal(R .\ i8, int8([- 8, - 4; - 2, - 2]));
assert_checkequal(R .\ I8, int8([- 8, - 8; - 8, - 8]));
assert_checkequal(R .\ ui8, uint8([8, 4; 2, 2]));
assert_checkequal(R .\ UI8, uint8([8, 8; 8, 8]));
assert_checkequal(R .\ i16, int16([- 16, - 8; - 5, - 4]));
assert_checkequal(R .\ I16, int16([- 16, - 16; - 16, - 16]));
assert_checkequal(R .\ ui16, uint16([16, 8; 5, 4]));
assert_checkequal(R .\ UI16, uint16([16, 16; 16, 16]));
assert_checkequal(R .\ i32, int32([- 32, - 16; - 10, - 8]));
assert_checkequal(R .\ I32, int32([- 32, - 32; - 32, - 32]));
assert_checkequal(R .\ ui32, uint32([32, 16; 10, 8]));
assert_checkequal(R .\ UI32, uint32([32, 32; 32, 32]));

assert_checkequal(C .\ empty, []);
assert_checkalmostequal(C .\ r, [0.4-%i* 0.8, 0.2-%i* 0.4; 2/15-%i* 4/15, 0.1-%i* 0.2]);
assert_checkequal(C .\ c, [1, 0.5; (1/3), 0.25]+%i*0);
assert_checkalmostequal(C .\ R, [0.2-%i* 0.4, 0.2-%i* 0.4; 0.2-%i* 0.4, 0.2-%i* 0.4]);
assert_checkequal(C .\ C, [1, 1; 1, 1]+%i*0);
assert_checkalmostequal(coeff(C .\ p), coeff([0.2-%i* 0.4+(0.2-%i* 0.4)*s+(- 0.2+%i* 0.4)*s^ 2,0.1-%i* 0.2+(0.1-%i* 0.2)*s+(- 0.1+%i* 0.2)*s^ 2;1/15-%i* 2/15+(1/15-%i* 2/15)*s+(- 1/15+%i* 2/15)*s^ 2,0.05-%i* 0.1+(0.05-%i* 0.1)*s+(- 0.05+%i* 0.1)*s^ 2]));
assert_checkequal(C .\ pc, [1+(- 1-%i)*s+(1.4+%i* 1.2)*s^ 2,0.5+(- 0.5-%i* 0.5)*s+(0.7+%i* 0.6)*s^ 2;(1/3)+(- (1/3)-%i* (1/3))*s+(7/15+%i* 0.4)*s^ 2,0.25+(- 0.25-%i* 0.25)*s+(0.35+%i* 0.3)*s^ 2]);
assert_checkalmostequal(coeff(C .\ P), coeff([0.4-%i* 0.8+(0.4-%i* 0.8)*s+(- 0.4+%i* 0.8)*s^ 2,- 0.3+%i* 0.6+(- 0.3+%i* 0.6)*s+(0.3-%i* 0.6)*s^ 2;4/15-%i* 8/15+(4/15-%i* 8/15)*s+(- 4/15+%i* 8/15)*s^ 2,- 0.25+%i* 0.5+(- 0.25+%i* 0.5)*s+(0.25-%i* 0.5)*s^ 2]));
assert_checkequal(C .\ PC, [2+(- 2-%i* 2)*s+(2.8+%i* 2.4)*s^ 2,- 1.5+(1.5+%i* 1.5)*s+(- 2.1-%i* 1.8)*s^ 2;(1+1/3)+(- (1+1/3)-%i* (1+1/3))*s+(28/15+%i* 1.6)*s^ 2,- 1.25+(1.25+%i* 1.25)*s+(- 1.75-%i* 1.5)*s^ 2]);
assert_checkequal(C .\ SPC1, [2.8+%i* 0.4, 1.4+%i* 0.2; 14/15+%i* 2/15, 0.7+%i* 0.1]);

assert_checkequal(e .\ empty, []);
assert_checkequal(e .\ r, (2)*eye());
assert_checkequal(e .\ c, (1+%i* 2)*eye());
assert_checkequal(e .\ e, (1)*eye());
assert_checkequal(e .\ ec, (5+%i)*eye());
assert_checkequal(e .\ SP1, 10*eye());
assert_checkequal(e .\ SPC1, (2+%i*6)*eye());
assert_checkequal(e .\ i8, int8((- 8)*eye()));
assert_checkequal(e .\ ui8, uint8((8)*eye()));
assert_checkequal(e .\ i16, int16((- 16)*eye()));
assert_checkequal(e .\ ui16, uint16((16)*eye()));
assert_checkequal(e .\ i32, int32((- 32)*eye()));
assert_checkequal(e .\ ui32, uint32((32)*eye()));

assert_checkequal(ec .\ empty, []);
assert_checkalmostequal(ec .\ r, (10/26-%i* 1/13)*eye());
assert_checkequal(ec .\ c, (7/26+%i* 9/26)*eye());
assert_checkalmostequal(ec .\ e, (5/26-%i* 1/26)*eye());
assert_checkequal(ec .\ ec, (1+%i*0)*eye());

assert_checkequal(p .\ empty, []);
test = p .\ r;
assert_checkequal(test(2), 2);
assert_checkequal(test(3), 1+(1)*s+(- 1)*s^ 2);
test = p .\ c;
assert_checkequal(test(2), 1+%i* 2);
assert_checkequal(test(3), 1+(1)*s+(- 1)*s^ 2);
test = p .\ R;
assert_checkequal(test(2), [1, 2; 3, 4]);
assert_checkequal(test(3),[1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2;1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2]);
test = p .\ C;
assert_checkequal(test(2), [1+%i* 2, 2+%i* 4; 3+%i* 6, 4+%i* 8]);
assert_checkequal(test(3),[1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2;1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2]);
test = p .\ p;
assert_checkequal(test(2), 1+s*0);
assert_checkequal(test(3), 1+s*0);
test = p .\ pc;
assert_checkequal(test(2), (1+%i*2) + (1-%i*3)*s + (-1+%i*4)*s^2  );
assert_checkequal(test(3), 1+s-s^2);
test = p .\ P;
assert_checkequal(test(2), [1, 1; 1, 1]+s*0);
assert_checkequal(test(3),[0.5, - (1/3) ; 0.25 , -0.2]+s*0);
test = p .\ PC;
assert_checkequal(test(2), [(2+%i*4)+(2-%i*6)*s+(-2+%i*8)*s^2 , (-3-%i*6)+(-3+%i*9)*s+(3-%i*12)*s^2 ; (4+%i*8)+(4-%i*12)*s+(-4+%i*16)*s^2 , (-5-%i*10)+(-5+%i*15)*s+(5-%i*20)*s^2 ]);
assert_checkequal(test(3),[1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2;1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2]);

assert_checkequal(pc .\ empty, []);
test = pc .\ r;
assert_checkequal(test(2), 2);
assert_checkequal(test(3), 1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2);
test = pc .\ c;
assert_checkequal(test(2), 1+%i* 2);
assert_checkequal(test(3), 1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2);
test = pc .\ R;
assert_checkequal(test(2), [1, 2; 3, 4]);
assert_checkequal(test(3),[1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2;1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2]);
test = pc .\ C;
assert_checkequal(test(2), [1+%i* 2, 2+%i* 4; 3+%i* 6, 4+%i* 8]);
assert_checkequal(test(3),[1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2;1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2]);

test = pc .\ p;
assert_checkequal(test(2), 1+s-s^2);
assert_checkequal(test(3), 1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2);
test = pc .\ pc;
assert_checkequal(test(2), 1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2);
assert_checkequal(test(3), 1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2);
test = pc .\ P;
assert_checkequal(test(2), [2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);
assert_checkequal(test(3),[1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);
test = pc .\ PC;
assert_checkequal(test(2), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
assert_checkequal(test(3), [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);

assert_checkequal(P .\ empty, []);
test = P .\ r;
assert_checkequal(test(2), [2, 2; 2, 2]);
assert_checkequal(test(3), [2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = P .\ c;
assert_checkequal(test(2), [1+%i* 2, 1+%i* 2; 1+%i* 2, 1+%i* 2]);
assert_checkequal(test(3), [2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = P .\ R;
assert_checkequal(test(2), [1, 2; 3, 4]);
assert_checkequal(test(3),[2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = P .\ C;
assert_checkequal(test(2), [1+%i* 2, 2+%i* 4; 3+%i* 6, 4+%i* 8]);
assert_checkequal(test(3),[2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = P .\ p;
assert_checkequal(test(2), [1,1;1,1]+s*0);
assert_checkequal(test(3), [2,-3;4,-5]+s*0);
test = P .\ pc;
assert_checkequal(test(2), [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);
assert_checkequal(test(3), [2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);
test = P .\ P;
assert_checkequal(test(2), [1,1;1,1]+s*0);
assert_checkequal(test(3),[1,1;1,1]+s*0);
test = P .\ PC;
assert_checkequal(test(2), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
assert_checkequal(test(3),[2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);

assert_checkequal(PC .\ empty, []);
test = PC .\ r;
assert_checkequal(test(2), [2, 2; 2, 2]);
assert_checkequal(test(3), [2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
test = PC .\ c;
assert_checkequal(test(2), [1+%i* 2, 1+%i* 2; 1+%i* 2, 1+%i* 2]);
assert_checkequal(test(3), [2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
test = PC .\ R;
assert_checkequal(test(2), [1, 2; 3, 4]);
assert_checkequal(test(3),[2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
test = PC .\ C;
assert_checkequal(test(2), [1+%i* 2, 2+%i* 4; 3+%i* 6, 4+%i* 8]);
assert_checkequal(test(3),[2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
test = PC .\ p;
assert_checkequal(test(2), [1+s-s^2,1+s-s^2;1+s-s^2,1+s-s^2]);
assert_checkequal(test(3), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
test = PC .\ pc;
assert_checkequal(test(2), [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);
assert_checkequal(test(3), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
test = PC .\ P;
assert_checkequal(test(2), [2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);
assert_checkequal(test(3),[2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
test = PC .\ PC;
assert_checkequal(test(2), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
assert_checkequal(test(3), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);

assert_checkequal(SP .\ empty, []);
assert_checkequal(SP .\ r, sparse([1, 2; 3, 10; 4, 5],[2; (2/3); 1],[4, 10]));
assert_checkequal(SP .\ c, sparse([1, 2; 3, 10; 4, 5],[1+%i* 2; (1/3)+%i* (2/3); 0.5+%i],[4, 10]));
assert_checkequal(SP .\ SP, sparse([1, 2; 3, 10; 4, 5],[1; 1; 1],[4, 10]));
assert_checkequal(SP .\ SPC, sparse([1, 2; 3, 10; 4, 5],[1+%i* 4; 1+%i* 4; 1+%i* 4],[4, 10]));
assert_checkequal(SP .\ SP1, sparse([1, 2; 3, 10; 4, 5],[10; (3+1/3); 5],[4, 10]));
assert_checkequal(SP .\ SPC1, sparse([1, 2; 3, 10; 4, 5],[2+%i* 6; (2/3)+%i* 2; 1+%i* 3],[4, 10]));

assert_checkequal(SPC .\ empty, []);
assert_checkequal(SPC .\ r, sparse([1, 2; 3, 10; 4, 5],[2/17-%i* 8/17; 2/51-%i* 8/51; 1/17-%i* 4/17],[4, 10]));
assert_checkequal(SPC .\ c, sparse([1, 2; 3, 10; 4, 5],[9/17-%i* 2/17; 3/17-%i* 2/51; 9/34-%i* 1/17],[4, 10]));
assert_checkequal(SPC .\ SP, sparse([1, 2; 3, 10; 4, 5],[1/17-%i* 4/17; 1/17-%i* 4/17; 1/17-%i* 4/17],[4, 10]));
assert_checkequal(SPC .\ SPC, sparse([1, 2; 3, 10; 4, 5],[1+0*%i; 1+0*%i; 1+0*%i],[4, 10]));
assert_checkequal(SPC .\ SP1, sparse([1, 2; 3, 10; 4, 5],[10/17-%i* 40/17; 10/51-%i* 40/51; 10/34-%i* 20/17],[4, 10]));
assert_checkequal(SPC .\ SPC1, sparse([1, 2; 3, 10; 4, 5],[26/17-%i* 2/17; 26/51-%i* 2/51; 13/17-%i* 1/17],[4, 10]));

assert_checkequal(SP1 .\ empty, []);
assert_checkequal(SP1 .\ r, sparse([1, 1], 0.2,[1, 1]));
assert_checkequal(SP1 .\ c, sparse([1, 1], 0.1+%i* 0.2,[1, 1]));
assert_checkequal(SP1 .\ R, [0.1, 0.2; 0.3, 0.4]);
assert_checkalmostequal(SP1 .\ C, [0.1+%i* 0.2, 0.2+%i* 0.4; 0.3+%i* 0.6, 0.4+%i* 0.8]);
assert_checkequal(SP1 .\ SP, sparse([1, 2; 3, 10; 4, 5],[0.1; 0.3; 0.2],[4, 10]));
assert_checkequal(SP1 .\ SPC, sparse([1, 2; 3, 10; 4, 5],[0.1+%i* 0.4; 0.3+%i* 1.2; 0.2+%i* 0.8],[4, 10]));
assert_checkequal(SP1 .\ SP1, sparse([1, 1], 1,[1, 1]));
assert_checkequal(SP1 .\ SPC1, sparse([1, 1], 0.2+%i* 0.6,[1, 1]));

assert_checkequal(SPC1 .\ empty, []);
assert_checkalmostequal(SPC1 .\ r, sparse([1, 1], 0.1-%i* 0.3,[1, 1]));
assert_checkalmostequal(SPC1 .\ c, sparse([1, 1], 0.35-%i* 0.05,[1, 1]));
assert_checkequal(SPC1 .\ R, [0.05-%i* 0.15, 0.1-%i* 0.3; 0.15-%i* 0.45, 0.2-%i* 0.6]);
assert_checkalmostequal(SPC1 .\ C, [0.35-%i* 0.05, 0.7-%i* 0.1; 1.05-%i* 0.15, 1.4-%i* 0.2]);
assert_checkalmostequal(SPC1 .\ SP, sparse([1, 2; 3, 10; 4, 5],[0.05-%i* 0.15; 0.15-%i* 0.45; 0.1-%i* 0.3],[4, 10]));
assert_checkalmostequal(SPC1 .\ SPC, sparse([1, 2; 3, 10; 4, 5],[0.65+%i* 0.05; 1.95+%i* 0.15; 1.3+%i* 0.1],[4, 10]));
assert_checkalmostequal(SPC1 .\ SP1, sparse([1, 1], 0.5-%i* 1.5,[1, 1]));
assert_checkequal(SPC1 .\ SPC1, sparse([1, 1], 1+0*%i,[1, 1]));

assert_checkequal(i8 .\ r, int8(0));
assert_checkequal(i8 .\ R, int8([0, 0; 0, 0]));
assert_checkequal(i8 .\ i8, int8(1));
assert_checkequal(i8 .\ I8, int8([1, 2; 3, 4]));
assert_checkequal(i8 .\ ui8, uint8(0));
assert_checkequal(i8 .\ UI8, uint8([0, 0; 0, 0]));
assert_checkequal(i8 .\ i16, int16(2));
assert_checkequal(i8 .\ I16, int16([2, 4; 6, 8]));
assert_checkequal(i8 .\ ui16, uint16(0));
assert_checkequal(i8 .\ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(i8 .\ i32, int32(4));
assert_checkequal(i8 .\ I32, int32([4, 8; 12, 16]));
assert_checkequal(i8 .\ ui32, uint32(0));
assert_checkequal(i8 .\ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(I8 .\ r, int8([0, 0; 0, 0]));
assert_checkequal(I8 .\ R, int8([0, 0; 0, 0]));
assert_checkequal(I8 .\ i8, int8([1, 0; 0, 0]));
assert_checkequal(I8 .\ I8, int8([1, 1; 1, 1]));
assert_checkequal(I8 .\ ui8, uint8([0, 0; 0, 0]));
assert_checkequal(I8 .\ UI8, uint8([0, 0; 0, 0]));
assert_checkequal(I8 .\ i16, int16([2, 1; 0, 0]));
assert_checkequal(I8 .\ I16, int16([2, 2; 2, 2]));
assert_checkequal(I8 .\ ui16, uint16([0, 0; 0, 0]));
assert_checkequal(I8 .\ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(I8 .\ i32, int32([4, 2; 1, 1]));
assert_checkequal(I8 .\ I32, int32([4, 4; 4, 4]));
assert_checkequal(I8 .\ ui32, uint32([0, 0; 0, 0]));
assert_checkequal(I8 .\ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(ui8 .\ r, uint8(0));
assert_checkequal(ui8 .\ R, uint8([0, 0; 0, 0]));
assert_checkequal(ui8 .\ i8, uint8(31));
assert_checkequal(ui8 .\ I8, uint8([31, 30; 29, 28]));
assert_checkequal(ui8 .\ ui8, uint8(1));
assert_checkequal(ui8 .\ UI8, uint8([1, 2; 3, 4]));
assert_checkequal(ui8 .\ i16, uint16(8190));
assert_checkequal(ui8 .\ I16, uint16([8190, 8188; 8186, 8184]));
assert_checkequal(ui8 .\ ui16, uint16(2));
assert_checkequal(ui8 .\ UI16, uint16([2, 4; 6, 8]));
assert_checkequal(ui8 .\ i32, uint32(536870908));
assert_checkequal(ui8 .\ I32, uint32([536870908, 536870904; 536870900, 536870896]));
assert_checkequal(ui8 .\ ui32, uint32(4));
assert_checkequal(ui8 .\ UI32, uint32([4, 8; 12, 16]));

assert_checkequal(UI8 .\ r, uint8([0, 0; 0, 0]));
assert_checkequal(UI8 .\ R, uint8([0, 0; 0, 0]));
assert_checkequal(UI8 .\ i8, uint8([31, 15; 10, 7]));
assert_checkequal(UI8 .\ I8, uint8([31, 15; 9, 7]));
assert_checkequal(UI8 .\ ui8, uint8([1, 0; 0, 0]));
assert_checkequal(UI8 .\ UI8, uint8([1, 1; 1, 1]));
assert_checkequal(UI8 .\ i16, uint16([8190, 4095; 2730, 2047]));
assert_checkequal(UI8 .\ I16, uint16([8190, 4094; 2728, 2046]));
assert_checkequal(UI8 .\ ui16, uint16([2, 1; 0, 0]));
assert_checkequal(UI8 .\ UI16, uint16([2, 2; 2, 2]));
assert_checkequal(UI8 .\ i32, uint32([536870908, 268435454; 178956969, 134217727]));
assert_checkequal(UI8 .\ I32, uint32([536870908, 268435452; 178956966, 134217724]));
assert_checkequal(UI8 .\ ui32, uint32([4, 2; 1, 1]));
assert_checkequal(UI8 .\ UI32, uint32([4, 4; 4, 4]));

assert_checkequal(i16 .\ r, int16(0));
assert_checkequal(i16 .\ R, int16([0, 0; 0, 0]));
assert_checkequal(i16 .\ i8, int16(0));
assert_checkequal(i16 .\ I8, int16([0, 1; 1, 2]));
assert_checkequal(i16 .\ ui8, uint16(0));
assert_checkequal(i16 .\ UI8, uint16([0, 0; 0, 0]));
assert_checkequal(i16 .\ i16, int16(1));
assert_checkequal(i16 .\ I16, int16([1, 2; 3, 4]));
assert_checkequal(i16 .\ ui16, uint16(0));
assert_checkequal(i16 .\ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(i16 .\ i32, int32(2));
assert_checkequal(i16 .\ I32, int32([2, 4; 6, 8]));
assert_checkequal(i16 .\ ui32, uint32(0));
assert_checkequal(i16 .\ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(I16 .\ r, int16([0, 0; 0, 0]));
assert_checkequal(I16 .\ R, int16([0, 0; 0, 0]));
assert_checkequal(I16 .\ i8, int16([0, 0; 0, 0]));
assert_checkequal(I16 .\ I8, int16([0, 0; 0, 0]));
assert_checkequal(I16 .\ ui8, uint16([0, 0; 0, 0]));
assert_checkequal(I16 .\ UI8, uint16([0, 0; 0, 0]));
assert_checkequal(I16 .\ i16, int16([1, 0; 0, 0]));
assert_checkequal(I16 .\ I16, int16([1, 1; 1, 1]));
assert_checkequal(I16 .\ ui16, uint16([0, 0; 0, 0]));
assert_checkequal(I16 .\ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(I16 .\ i32, int32([2, 1; 0, 0]));
assert_checkequal(I16 .\ I32, int32([2, 2; 2, 2]));
assert_checkequal(I16 .\ ui32, uint32([0, 0; 0, 0]));
assert_checkequal(I16 .\ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(ui16 .\ r, uint16(0));
assert_checkequal(ui16 .\ R, uint16([0, 0; 0, 0]));
assert_checkequal(ui16 .\ i8, uint16(4095));
assert_checkequal(ui16 .\ I8, uint16([4095, 4095; 4094, 4094]));
assert_checkequal(ui16 .\ ui8, uint16(0));
assert_checkequal(ui16 .\ UI8, uint16([0, 1; 1, 2]));
assert_checkequal(ui16 .\ i16, uint16(4095));
assert_checkequal(ui16 .\ I16, uint16([4095, 4094; 4093, 4092]));
assert_checkequal(ui16 .\ ui16, uint16(1));
assert_checkequal(ui16 .\ UI16, uint16([1, 2; 3, 4]));
assert_checkequal(ui16 .\ i32, uint32(268435454));
assert_checkequal(ui16 .\ I32, uint32([268435454, 268435452; 268435450, 268435448]));
assert_checkequal(ui16 .\ ui32, uint32(2));
assert_checkequal(ui16 .\ UI32, uint32([2, 4; 6, 8]));

assert_checkequal(UI16 .\ r, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 .\ R, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 .\ i8, uint16([4095, 2047; 1365, 1023]));
assert_checkequal(UI16 .\ I8, uint16([4095, 2047; 1364, 1023]));
assert_checkequal(UI16 .\ ui8, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 .\ UI8, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 .\ i16, uint16([4095, 2047; 1365, 1023]));
assert_checkequal(UI16 .\ I16, uint16([4095, 2047; 1364, 1023]));
assert_checkequal(UI16 .\ ui16, uint16([1, 0; 0, 0]));
assert_checkequal(UI16 .\ UI16, uint16([1, 1; 1, 1]));
assert_checkequal(UI16 .\ i32, uint32([268435454, 134217727; 89478484, 67108863]));
assert_checkequal(UI16 .\ I32, uint32([268435454, 134217726; 89478483, 67108862]));
assert_checkequal(UI16 .\ ui32, uint32([2, 1; 0, 0]));
assert_checkequal(UI16 .\ UI32, uint32([2, 2; 2, 2]));

assert_checkequal(i32 .\ r, int32(0));
assert_checkequal(i32 .\ R, int32([0, 0; 0, 0]));
assert_checkequal(i32 .\ i8, int32(0));
assert_checkequal(i32 .\ I8, int32([0, 0; 0, 1]));
assert_checkequal(i32 .\ ui8, uint32(0));
assert_checkequal(i32 .\ UI8, uint32([0, 0; 0, 0]));
assert_checkequal(i32 .\ i16, int32(0));
assert_checkequal(i32 .\ I16, int32([0, 1; 1, 2]));
assert_checkequal(i32 .\ ui16, uint32(0));
assert_checkequal(i32 .\ UI16, uint32([0, 0; 0, 0]));
assert_checkequal(i32 .\ i32, int32(1));
assert_checkequal(i32 .\ I32, int32([1, 2; 3, 4]));
assert_checkequal(i32 .\ ui32, uint32(0));
assert_checkequal(i32 .\ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(I32 .\ r, int32([0, 0; 0, 0]));
assert_checkequal(I32 .\ R, int32([0, 0; 0, 0]));
assert_checkequal(I32 .\ i8, int32([0, 0; 0, 0]));
assert_checkequal(I32 .\ I8, int32([0, 0; 0, 0]));
assert_checkequal(I32 .\ ui8, uint32([0, 0; 0, 0]));
assert_checkequal(I32 .\ UI8, uint32([0, 0; 0, 0]));
assert_checkequal(I32 .\ i16, int32([0, 0; 0, 0]));
assert_checkequal(I32 .\ I16, int32([0, 0; 0, 0]));
assert_checkequal(I32 .\ ui16, uint32([0, 0; 0, 0]));
assert_checkequal(I32 .\ UI16, uint32([0, 0; 0, 0]));
assert_checkequal(I32 .\ i32, int32([1, 0; 0, 0]));
assert_checkequal(I32 .\ I32, int32([1, 1; 1, 1]));
assert_checkequal(I32 .\ ui32, uint32([0, 0; 0, 0]));
assert_checkequal(I32 .\ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(ui32 .\ r, uint32(0));
assert_checkequal(ui32 .\ R, uint32([0, 0; 0, 0]));
assert_checkequal(ui32 .\ i8, uint32(134217727));
assert_checkequal(ui32 .\ I8, uint32([134217727, 134217727; 134217727, 134217727]));
assert_checkequal(ui32 .\ ui8, uint32(0));
assert_checkequal(ui32 .\ UI8, uint32([0, 0; 0, 1]));
assert_checkequal(ui32 .\ i16, uint32(134217727));
assert_checkequal(ui32 .\ I16, uint32([134217727, 134217727; 134217726, 134217726]));
assert_checkequal(ui32 .\ ui16, uint32(0));
assert_checkequal(ui32 .\ UI16, uint32([0, 1; 1, 2]));
assert_checkequal(ui32 .\ i32, uint32(134217727));
assert_checkequal(ui32 .\ I32, uint32([134217727, 134217726; 134217725, 134217724]));
assert_checkequal(ui32 .\ ui32, uint32(1));
assert_checkequal(ui32 .\ UI32, uint32([1, 2; 3, 4]));

assert_checkequal(UI32 .\ r, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 .\ R, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 .\ i8, uint32([134217727, 67108863; 44739242, 33554431]));
assert_checkequal(UI32 .\ I8, uint32([134217727, 67108863; 44739242, 33554431]));
assert_checkequal(UI32 .\ ui8, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 .\ UI8, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 .\ i16, uint32([134217727, 67108863; 44739242, 33554431]));
assert_checkequal(UI32 .\ I16, uint32([134217727, 67108863; 44739242, 33554431]));
assert_checkequal(UI32 .\ ui16, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 .\ UI16, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 .\ i32, uint32([134217727, 67108863; 44739242, 33554431]));
assert_checkequal(UI32 .\ I32, uint32([134217727, 67108863; 44739241, 33554431]));
assert_checkequal(UI32 .\ ui32, uint32([1, 0; 0, 0]));
assert_checkequal(UI32 .\ UI32, uint32([1, 1; 1, 1]));

assert_checkequal(empty ./ empty, []);
assert_checkequal(empty ./ r, []);
assert_checkequal(empty ./ c, []);
assert_checkequal(empty ./ R, []);
assert_checkequal(empty ./ C, []);
assert_checkequal(empty ./ e, []);
assert_checkequal(empty ./ ec, []);
assert_checkequal(empty ./ p, []);
assert_checkequal(empty ./ pc, []);
assert_checkequal(empty ./ P, []);
assert_checkequal(empty ./ PC, []);
assert_checkequal(empty ./ SP, []);
assert_checkequal(empty ./ SPC, []);
assert_checkequal(empty ./ SP1, []);
assert_checkequal(empty ./ SPC1, []);

assert_checkequal(r ./ empty, []);
assert_checkequal(r ./ r,  1);
assert_checkalmostequal(r ./ c,  0.4-%i* 0.8);
assert_checkequal(r ./ R, [2, 1; (2/3), 0.5]);
assert_checkalmostequal(r ./ C, [0.4-%i* 0.8, 0.2-%i* 0.4; 2/15-%i* 4/15, 0.1-%i* 0.2]);
assert_checkequal(r ./ e, (2)*eye());
assert_checkalmostequal(r ./ ec, (1/2.6-%i* 1/13)*eye());

test = r ./ p;
assert_checkequal(test(2), 2+0*%s);
assert_checkequal(test(3), 1+(1)*s+(- 1)*s^ 2);
test = r ./ pc;
assert_checkequal(test(2), 2+0*%s);
assert_checkequal(test(3), 1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2);
test = r ./ P;
assert_checkequal(test(2), [2,2;2,2]+0*%s);
assert_checkequal(test(3),[2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = r ./ PC;
assert_checkequal(test(2), [2,2;2,2]+0*%s);
assert_checkequal(test(3),[2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
assert_checkequal(r ./ SP, sparse([1, 2; 3, 10; 4, 5],[2; (2/3); 1],[4, 10]));
assert_checkequal(r ./ SPC, sparse([1, 2; 3, 10; 4, 5],[2/17-%i* 8/17; 2/51-%i* 8/51; 1/17-%i* 4/17],[4, 10]));
assert_checkequal(r ./ SP1, sparse([1, 1], 0.2,[1, 1]));
assert_checkalmostequal(r ./ SPC1, sparse([1, 1], 0.1-%i* 0.3,[1, 1]));
assert_checkequal(r ./ i8, int8(0));
assert_checkequal(r ./ I8, int8([0, 0; 0, 0]));
assert_checkequal(r ./ ui8, uint8(0));
assert_checkequal(r ./ UI8, uint8([0, 0; 0, 0]));
assert_checkequal(r ./ i16, int16(0));
assert_checkequal(r ./ I16, int16([0, 0; 0, 0]));
assert_checkequal(r ./ ui16, uint16(0));
assert_checkequal(r ./ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(r ./ i32, int32(0));
assert_checkequal(r ./ I32, int32([0, 0; 0, 0]));
assert_checkequal(r ./ ui32, uint32(0));
assert_checkequal(r ./ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(c ./ empty, []);
assert_checkequal(c ./ r,  0.5+%i);
assert_checkequal(c ./ c,  1+%i*0);
assert_checkequal(c ./ R,  [ 1+%i*2, 0.5+%i; (1/3)+%i*(2/3), 0.25+%i*0.5]);
assert_checkequal(c ./ C, [1, 0.5; (1/3), 0.25]+%i*0);
assert_checkequal(c ./ e, (1+%i* 2)*eye());
assert_checkequal(c ./ ec, (7/26+%i* 9/26)*eye());
test = c ./ p;
assert_checkequal(test(2), 1+%i*2+0*%s);
assert_checkequal(test(3), 1+(1)*s+(- 1)*s^ 2);
test = c ./ pc;
assert_checkequal(test(2), 1+%i*2+0*%s);
assert_checkequal(test(3), 1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2);
test = c ./ P;
assert_checkequal(test(2), [1,1;1,1]*(1+%i*2)+0*%s);
assert_checkequal(test(3),[2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = c ./ PC;
assert_checkequal(test(2), [1,1;1,1]*(1+%i*2)+0*%s);
assert_checkequal(test(3),[2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
assert_checkequal(c ./ SP, sparse([1, 2; 3, 10; 4, 5],[1+%i* 2; (1/3)+%i* (2/3); 0.5+%i],[4, 10]));
assert_checkequal(c ./ SPC, sparse([1, 2; 3, 10; 4, 5],[9/17-%i* 2/17; 3/17-%i* 2/51; 9/34-%i* 1/17],[4, 10]));
assert_checkequal(c ./ SP1, sparse([1, 1], 0.1+%i* 0.2,[1, 1]));
assert_checkalmostequal(c ./ SPC1, sparse([1, 1], 0.35-%i* 0.05,[1, 1]));

assert_checkequal(R ./ empty, []);
assert_checkequal(R ./ r, [0.5, 1; 1.5, 2]);
assert_checkalmostequal(R ./ c, [0.2-%i* 0.4, 0.4-%i* 0.8; 0.6-%i* 1.2, 0.8-%i* 1.60]);
assert_checkequal(R ./ R, [1, 1; 1, 1]);
assert_checkalmostequal(R ./ C, [0.2-%i* 0.4, 0.2-%i* 0.4; 0.2-%i* 0.4, 0.2-%i* 0.4]);
test = R ./ p;
assert_checkequal(test(2), [1,2;3,4]+0*%s);
assert_checkequal(test(3), [1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2;1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2]);
test = R ./ pc;
assert_checkequal(test(2), [1,2;3,4]+0*%s);
assert_checkequal(test(3), [1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2;1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2]);
test = R ./ P;
assert_checkequal(test(2), [1,2;3,4]+0*%s);
assert_checkequal(test(3),[2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = R ./ PC;
assert_checkequal(test(2), [1,2;3,4]+0*%s);
assert_checkequal(test(3),[2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
assert_checkequal(R ./ SP1, [0.1 ,0.2;0.3,0.4]);
assert_checkequal(R ./ SPC1, [0.05-%i* 0.15, 0.1-%i* 0.3; 0.15-%i* 0.45, 0.2-%i* 0.6]);
assert_checkequal(R ./ i8, int8([0, 0; 0, 0]));
assert_checkequal(R ./ I8, int8([0, 0; 0, 0]));
assert_checkequal(R ./ ui8, uint8([0, 0; 0, 0]));
assert_checkequal(R ./ UI8, uint8([0, 0; 0, 0]));
assert_checkequal(R ./ i16, int16([0, 0; 0, 0]));
assert_checkequal(R ./ I16, int16([0, 0; 0, 0]));
assert_checkequal(R ./ ui16, uint16([0, 0; 0, 0]));
assert_checkequal(R ./ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(R ./ i32, int32([0, 0; 0, 0]));
assert_checkequal(R ./ I32, int32([0, 0; 0, 0]));
assert_checkequal(R ./ ui32, uint32([0, 0; 0, 0]));
assert_checkequal(R ./ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(C ./ empty, []);
assert_checkequal(C ./ r, [0.5+%i, 1+%i* 2; 1.5+%i* 3, 2+%i* 4]);
assert_checkequal(C ./ c, [1, 2; 3, 4]+%i*0);
assert_checkequal(C ./ R, [1+%i* 2, 1+%i* 2; 1+%i* 2, 1+%i* 2]);
assert_checkequal(C ./ C, [1, 1; 1, 1]+%i*0);
test = C ./ p;
assert_checkequal(test(2), [1+%i* 2,2+%i* 4;3+%i* 6,4+%i* 8]+0*%s);
assert_checkequal(test(3), [1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2;1+(1)*s+(- 1)*s^ 2,1+(1)*s+(- 1)*s^ 2]);
test = C ./ pc;
assert_checkequal(test(2), [1+%i* 2,2+%i* 4;3+%i* 6,4+%i* 8]+0*%s);
assert_checkequal(test(3), [1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2;1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2]);
test = C ./ P;
assert_checkequal(test(2), [1+%i* 2,2+%i* 4;3+%i* 6,4+%i* 8]+0*%s);
assert_checkequal(test(3),[2+(2)*s+(- 2)*s^ 2,- 3+(- 3)*s+(3)*s^ 2;4+(4)*s+(- 4)*s^ 2,- 5+(- 5)*s+(5)*s^ 2]);
test = C ./ PC;
assert_checkequal(test(2), [1+%i* 2,2+%i* 4;3+%i* 6,4+%i* 8]+0*%s);
assert_checkequal(test(3),[2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 3-%i* 6+(- 3+%i* 9)*s+(3-%i* 12)*s^ 2;4+%i* 8+(4-%i* 12)*s+(- 4+%i* 16)*s^ 2,- 5-%i* 10+(- 5+%i* 15)*s+(5-%i* 20)*s^ 2]);
assert_checkequal(C ./ SP1, [0.1+0.2*%i,0.2+0.4*%i;0.3+0.6*%i,0.4+0.8*%i]);
assert_checkalmostequal(C ./ SPC1, [0.35-%i* 0.05, 0.7-%i* 0.1; 1.05-%i* 0.15, 1.4-%i* 0.2]);

assert_checkequal(e ./ empty, []);
assert_checkequal(e ./ r, (0.5)*eye());
assert_checkequal(e ./ c, (1+%i*2)*eye());
assert_checkequal(e ./ e, (1)*eye());
assert_checkalmostequal(e ./ ec, (5/26-%i* 1/26)*eye());
assert_checkequal(e ./ SP1, 0.1*eye());
assert_checkequal(e ./ SPC1, (2+6*%i)*eye());
assert_checkequal(e ./ i8, int8((0)*eye()));
assert_checkequal(e ./ ui8, uint8((0)*eye()));
assert_checkequal(e ./ i16, int16((0)*eye()));
assert_checkequal(e ./ ui16, uint16((0)*eye()));
assert_checkequal(e ./ i32, int32((0)*eye()));
assert_checkequal(e ./ ui32, uint32((0)*eye()));

assert_checkequal(ec ./ empty, []);
assert_checkequal(ec ./ r, (2.5+%i* 0.5)*eye());
assert_checkequal(ec ./ c, (1.4-%i* 1.8)*eye());
assert_checkequal(ec ./ e, (5+%i)*eye());
assert_checkequal(ec ./ ec, (1+%i*0)*eye());

assert_checkequal(p ./ empty, []);
assert_checkequal(p ./ r, 0.5+(0.5)*s+(- 0.5)*s^ 2);
assert_checkalmostequal(coeff(p ./ c), coeff(0.2-%i*0.4+(0.2-%i*0.4)*s+(-0.2+%i*0.4)*s^2));
assert_checkequal(p ./ R, [1+(1)*s+(- 1)*s^ 2,0.5+(0.5)*s+(- 0.5)*s^ 2;(1/3)+((1/3))*s+(- (1/3))*s^ 2,0.25+(0.25)*s+(- 0.25)*s^ 2]);
assert_checkalmostequal(coeff(p ./ C), coeff([0.2-%i* 0.4+(0.2-%i* 0.4)*s+(- 0.2+%i* 0.4)*s^ 2,0.1-%i* 0.2+(0.1-%i* 0.2)*s+(- 0.1+%i* 0.2)*s^ 2;1/15-%i* 2/15+(1/15-%i* 2/15)*s+(- 1/15+%i* 2/15)*s^ 2,0.05-%i* 0.1+(0.05-%i* 0.1)*s+(- 0.05+%i* 0.1)*s^ 2]));
test = p ./ p;
assert_checkequal(test(2), 1+s*0);
assert_checkequal(test(3), 1+s*0);
test = p ./ pc;
assert_checkequal(test(2), 1+s-s^2);
assert_checkequal(test(3), 1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2);
test = p ./ P;
assert_checkequal(test(2), [0.5,-(1/3);0.25,-0.2]+s*0);
assert_checkequal(test(3), [1,1;1,1]+s*0);
test = p ./ PC;
assert_checkequal(test(2), [1+s-s^2,1+s-s^2;1+s-s^2,1+s-s^2]);
assert_checkequal(test(3), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);

assert_checkequal(pc ./ empty, []);
assert_checkequal(pc ./ r, 0.5+%i+(0.5-%i* 1.5)*s+(- 0.5+%i* 2)*s^ 2);
assert_checkequal(pc ./ c, 1+(- 1-%i)*s+(1.4+%i* 1.2)*s^ 2);
assert_checkequal(pc ./ R, [1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,0.5+%i+(0.5-%i* 1.5)*s+(- 0.5+%i* 2)*s^ 2;(1/3)+%i* (2/3)+((1/3)-%i)*s+(- (1/3)+%i* (1+1/3))*s^ 2,0.25+%i* 0.5+(0.25-%i* 0.75)*s+(- 0.25+%i)*s^ 2]);
assert_checkequal(pc ./ C, [1+(- 1-%i)*s+(1.4+%i* 1.2)*s^ 2,0.5+(- 0.5-%i* 0.5)*s+(0.7+%i* 0.6)*s^ 2;(1/3)+(- (1/3)-%i* (1/3))*s+(7/15+%i* 0.4)*s^ 2,0.25+(- 0.25-%i* 0.25)*s+(0.35+%i* 0.3)*s^ 2]);
test = pc ./ p;
assert_checkequal(test(2), 1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2);
assert_checkequal(test(3), 1+s-s^2);
test = pc ./ pc;
assert_checkequal(test(2), 1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2);
assert_checkequal(test(3), 1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2);
test = pc ./ P;
assert_checkequal(test(2), [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);
assert_checkequal(test(3), [2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);
test = pc ./ PC;
assert_checkequal(test(2), [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);
assert_checkequal(test(3), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);

assert_checkequal(P ./ empty, []);
assert_checkequal(P ./ r, [1+(1)*s+(- 1)*s^ 2,- 1.5+(- 1.5)*s+(1.5)*s^ 2;2+(2)*s+(- 2)*s^ 2,- 2.5+(- 2.5)*s+(2.5)*s^ 2]);
assert_checkalmostequal(coeff(P ./ c), coeff([0.4-%i*0.8+(0.4-%i*0.8)*s+(-0.4+%i*0.8)*s^2,-0.6+%i*1.2+(-0.6+%i*1.2)*s+(0.6-%i*1.2)*s^2;0.8-%i*1.6+(0.8-%i*1.6)*s+(-0.8+%i*1.6)*s^2,-1+%i*2+(-1+%i*2)*s+(1-%i*2)*s^2]));
assert_checkequal(P ./ R, [2+(2)*s+(- 2)*s^ 2,- 1.5+(- 1.5)*s+(1.5)*s^ 2;(1+1/3)+((1+1/3))*s+(- (1+1/3))*s^ 2,- 1.25+(- 1.25)*s+(1.25)*s^ 2]);
assert_checkalmostequal(coeff(P ./ C), coeff([0.4-%i* 0.8+(0.4-%i* 0.8)*s+(- 0.4+%i* 0.8)*s^ 2,- 0.3+%i* 0.6+(- 0.3+%i* 0.6)*s+(0.3-%i* 0.6)*s^ 2;4/15-%i* 8/15+(4/15-%i* 8/15)*s+(- 4/15+%i* 8/15)*s^ 2,- 0.25+%i* 0.5+(- 0.25+%i* 0.5)*s+(0.25-%i* 0.5)*s^ 2]));
test = P ./ p;
assert_checkequal(test(2), [2,-3;4,-5]+s*0);
assert_checkequal(test(3), [1,1;1,1]+s*0);
test = P ./ pc;
assert_checkequal(test(2), [2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);
assert_checkequal(test(3), [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);
test = P ./ P;
assert_checkequal(test(2), [1,1;1,1]+s*0);
assert_checkequal(test(3), [1,1;1,1]+%s*0);
test = P ./ PC;
assert_checkequal(test(2), [2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);
assert_checkequal(test(3), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);

assert_checkequal(PC ./ empty, []);
assert_checkequal(PC ./ r, [1+%i* 2+(1-%i* 3)*s+(- 1+%i* 4)*s^ 2,- 1.5-%i* 3+(- 1.5+%i* 4.5)*s+(1.5-%i* 6)*s^ 2;2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 2.5-%i* 5+(- 2.5+%i* 7.5)*s+(2.5-%i* 10)*s^ 2]);
assert_checkequal(PC ./ c, [2+(- 2-%i* 2)*s+(2.8+%i* 2.4)*s^ 2,- 3+(3+%i* 3)*s+(- 4.2-%i* 3.6)*s^ 2;4+(- 4-%i* 4)*s+(5.6+%i* 4.8)*s^ 2,- 5+(5+%i* 5)*s+(- 7-%i* 6)*s^ 2]);
assert_checkequal(PC ./ R, [2+%i* 4+(2-%i* 6)*s+(- 2+%i* 8)*s^ 2,- 1.5-%i* 3+(- 1.5+%i* 4.5)*s+(1.5-%i* 6)*s^ 2;(1+1/3)+%i* 8/3+((1+1/3)-%i* 4)*s+(- (1+1/3)+%i* 16/3)*s^ 2,- 1.25-%i* 2.5+(- 1.25+%i* 3.75)*s+(1.25-%i* 5)*s^ 2]);
assert_checkequal(PC ./ C, [2+(- 2-%i* 2)*s+(2.8+%i* 2.4)*s^ 2,- 1.5+(1.5+%i* 1.5)*s+(- 2.1-%i* 1.8)*s^ 2;(1+1/3)+(- (1+1/3)-%i* (1+1/3))*s+(28/15+%i* 1.6)*s^ 2,- 1.25+(1.25+%i* 1.25)*s+(- 1.75-%i* 1.5)*s^ 2]);
test = PC ./ p;
assert_checkequal(test(2), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
assert_checkequal(test(3), [1+s-s^2,1+s-s^2;1+s-s^2,1+s-s^2]);
test = PC ./ pc;
assert_checkequal(test(2), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
assert_checkequal(test(3), [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2;1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2]);
test = PC ./ P;
assert_checkequal(test(2), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
assert_checkequal(test(3), [2+2*s-2*s^2,-3-3*s+3*s^2;4+4*s-4*s^2,-5-5*s+5*s^2]);
test = PC ./ PC;
assert_checkequal(test(2), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);
assert_checkequal(test(3), [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-3-%i*6+(-3+%i*9)*s+(3-%i*12)*s^2;4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-5-%i*10+(-5+%i*15)*s+(5-%i*20)*s^2]);

assert_checkequal(SP ./ empty, []);
assert_checkequal(SP ./ r, sparse([1, 2; 3, 10; 4, 5],[0.5; 1.5; 1],[4, 10]));
assert_checkequal(SP ./ c, sparse([1, 2; 3, 10; 4, 5],[0.2-%i* 0.4; 0.6-%i* 1.2; 0.4-%i* 0.8],[4, 10]));
assert_checkequal(SP ./ SP, sparse([1, 2; 3, 10; 4, 5],[1; 1; 1],[4, 10]));
assert_checkequal(SP ./ SPC, sparse([1, 2; 3, 10; 4, 5],[1/17-%i* 4/17; 1/17-%i* 4/17; 1/17-%i* 4/17],[4, 10]));
assert_checkequal(SP ./ SP1, sparse([1, 2; 3, 10; 4, 5],[0.1; 0.3; 0.2],[4, 10]));
assert_checkalmostequal(SP ./ SPC1, sparse([1, 2; 3, 10; 4, 5],[0.05-%i* 0.15; 0.15-%i* 0.45; 0.1-%i* 0.3],[4, 10]));

assert_checkequal(SPC ./ empty, []);
assert_checkequal(SPC ./ r, sparse([1, 2; 3, 10; 4, 5],[0.5+%i* 2; 1.5+%i* 6; 1+%i* 4],[4, 10]));
assert_checkequal(SPC ./ c, sparse([1, 2; 3, 10; 4, 5],[1.8+%i* 0.4; 5.4+%i* 1.2; 3.6+%i* 0.8],[4, 10]));
assert_checkequal(SPC ./ SP, sparse([1, 2; 3, 10; 4, 5],[1+%i* 4; 1+%i* 4; 1+%i* 4],[4, 10]));
assert_checkequal(SPC ./ SPC, sparse([1, 2; 3, 10; 4, 5] ,[1+0*%i; 1+0*%i; 1+0*%i],[4, 10]));
assert_checkequal(SPC ./ SP1, sparse([1, 2; 3, 10; 4, 5],[0.1+%i* 0.4; 0.3+%i* 1.2; 0.2+%i* 0.8],[4, 10]));
assert_checkalmostequal(SPC ./ SPC1, sparse([1, 2; 3, 10; 4, 5],[0.65+%i* 0.05; 1.95+%i* 0.15; 1.3+%i* 0.1],[4, 10]));

assert_checkequal(SP1 ./ empty, []);
assert_checkequal(SP1 ./ r, sparse([1, 1], 5,[1, 1]));
assert_checkequal(SP1 ./ c, sparse([1, 1], 2-%i* 4,[1, 1]));
assert_checkequal(SP1 ./ R, [10, 5; (3+1/3), 2.5]);
assert_checkequal(SP1 ./ C, [2-%i* 4, 1-%i* 2; (2/3)-%i* (1+1/3), 0.5-%i]);
assert_checkequal(SP1 ./ SP, sparse([1, 2; 3, 10; 4, 5],[10; (3+1/3); 5],[4, 10]));
assert_checkequal(SP1 ./ SPC, sparse([1, 2; 3, 10; 4, 5],[10/17-%i* 40/17; 10/51-%i* 40/51; 10/34-%i* 20/17],[4, 10]));
assert_checkequal(SP1 ./ SP1, sparse([1, 1], 1,[1, 1]));
assert_checkalmostequal(SP1 ./ SPC1, sparse([1, 1], 0.5-%i* 1.5,[1, 1]));

assert_checkequal(SPC1 ./ empty, []);
assert_checkequal(SPC1 ./ r, sparse([1, 1], 1+%i* 3,[1, 1]));
assert_checkequal(SPC1 ./ c, sparse([1, 1], 2.8+%i* 0.4,[1, 1]));
assert_checkequal(SPC1 ./ R, [2+%i*6, 1+%i*3; (2/3)+%i*2, 0.5+%i*1.5]);
assert_checkequal(SPC1 ./ C, [2.8+%i* 0.4, 1.4+%i* 0.2; 14/15+%i* 2/15, 0.7+%i* 0.1]);
assert_checkequal(SPC1 ./ SP, sparse([1, 2; 3, 10; 4, 5],[2+%i* 6; (2/3)+%i* 2; 1+%i* 3],[4, 10]));
assert_checkequal(SPC1 ./ SPC, sparse([1, 2; 3, 10; 4, 5],[26/17-%i* 2/17; 26/51-%i* 2/51; 13/17-%i* 1/17],[4, 10]));
assert_checkequal(SPC1 ./ SP1, sparse([1, 1], 0.2+%i* 0.6,[1, 1]));
assert_checkequal(SPC1 ./ SPC1, sparse([1, 1], 1+0*%i,[1, 1]));

assert_checkequal(i8 ./ r, int8(- 4));
assert_checkequal(i8 ./ R, int8([- 8, - 4; - 2, - 2]));
assert_checkequal(i8 ./ i8, int8(1));
assert_checkequal(i8 ./ I8, int8([1, 0; 0, 0]));
assert_checkequal(i8 ./ ui8, uint8(31));
assert_checkequal(i8 ./ UI8, uint8([31, 15; 10, 7]));
assert_checkequal(i8 ./ i16, int16(0));
assert_checkequal(i8 ./ I16, int16([0, 0; 0, 0]));
assert_checkequal(i8 ./ ui16, uint16(4095));
assert_checkequal(i8 ./ UI16, uint16([4095, 2047; 1365, 1023]));
assert_checkequal(i8 ./ i32, int32(0));
assert_checkequal(i8 ./ I32, int32([0, 0; 0, 0]));
assert_checkequal(i8 ./ ui32, uint32(134217727));
assert_checkequal(i8 ./ UI32, uint32([134217727, 67108863; 44739242, 33554431]));

assert_checkequal(I8 ./ r, int8([- 4, - 8; - 12, - 16]));
assert_checkequal(I8 ./ R, int8([- 8, - 8; - 8, - 8]));
assert_checkequal(I8 ./ i8, int8([1, 2; 3, 4]));
assert_checkequal(I8 ./ I8, int8([1, 1; 1, 1]));
assert_checkequal(I8 ./ ui8, uint8([31, 30; 29, 28]));
assert_checkequal(I8 ./ UI8, uint8([31, 15; 9, 7]));
assert_checkequal(I8 ./ i16, int16([0, 1; 1, 2]));
assert_checkequal(I8 ./ I16, int16([0, 0; 0, 0]));
assert_checkequal(I8 ./ ui16, uint16([4095, 4095; 4094, 4094]));
assert_checkequal(I8 ./ UI16, uint16([4095, 2047; 1364, 1023]));
assert_checkequal(I8 ./ i32, int32([0, 0; 0, 1]));
assert_checkequal(I8 ./ I32, int32([0, 0; 0, 0]));
assert_checkequal(I8 ./ ui32, uint32([134217727, 134217727; 134217727, 134217727]));
assert_checkequal(I8 ./ UI32, uint32([134217727, 67108863; 44739242, 33554431]));

assert_checkequal(ui8 ./ r, uint8(4));
assert_checkequal(ui8 ./ R, uint8([8, 4; 2, 2]));
assert_checkequal(ui8 ./ i8, uint8(0));
assert_checkequal(ui8 ./ I8, uint8([0, 0; 0, 0]));
assert_checkequal(ui8 ./ ui8, uint8(1));
assert_checkequal(ui8 ./ UI8, uint8([1, 0; 0, 0]));
assert_checkequal(ui8 ./ i16, uint16(0));
assert_checkequal(ui8 ./ I16, uint16([0, 0; 0, 0]));
assert_checkequal(ui8 ./ ui16, uint16(0));
assert_checkequal(ui8 ./ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(ui8 ./ i32, uint32(0));
assert_checkequal(ui8 ./ I32, uint32([0, 0; 0, 0]));
assert_checkequal(ui8 ./ ui32, uint32(0));
assert_checkequal(ui8 ./ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(UI8 ./ r, uint8([4, 8; 12, 16]));
assert_checkequal(UI8 ./ R, uint8([8, 8; 8, 8]));
assert_checkequal(UI8 ./ i8, uint8([0, 0; 0, 0]));
assert_checkequal(UI8 ./ I8, uint8([0, 0; 0, 0]));
assert_checkequal(UI8 ./ ui8, uint8([1, 2; 3, 4]));
assert_checkequal(UI8 ./ UI8, uint8([1, 1; 1, 1]));
assert_checkequal(UI8 ./ i16, uint16([0, 0; 0, 0]));
assert_checkequal(UI8 ./ I16, uint16([0, 0; 0, 0]));
assert_checkequal(UI8 ./ ui16, uint16([0, 1; 1, 2]));
assert_checkequal(UI8 ./ UI16, uint16([0, 0; 0, 0]));
assert_checkequal(UI8 ./ i32, uint32([0, 0; 0, 0]));
assert_checkequal(UI8 ./ I32, uint32([0, 0; 0, 0]));
assert_checkequal(UI8 ./ ui32, uint32([0, 0; 0, 1]));
assert_checkequal(UI8 ./ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(i16 ./ r, int16(- 8));
assert_checkequal(i16 ./ R, int16([- 16, - 8; - 5, - 4]));
assert_checkequal(i16 ./ i8, int16(2));
assert_checkequal(i16 ./ I8, int16([2, 1; 0, 0]));
assert_checkequal(i16 ./ ui8, uint16(8190));
assert_checkequal(i16 ./ UI8, uint16([8190, 4095; 2730, 2047]));
assert_checkequal(i16 ./ i16, int16(1));
assert_checkequal(i16 ./ I16, int16([1, 0; 0, 0]));
assert_checkequal(i16 ./ ui16, uint16(4095));
assert_checkequal(i16 ./ UI16, uint16([4095, 2047; 1365, 1023]));
assert_checkequal(i16 ./ i32, int32(0));
assert_checkequal(i16 ./ I32, int32([0, 0; 0, 0]));
assert_checkequal(i16 ./ ui32, uint32(134217727));
assert_checkequal(i16 ./ UI32, uint32([134217727, 67108863; 44739242, 33554431]));

assert_checkequal(I16 ./ r, int16([- 8, - 16; - 24, - 32]));
assert_checkequal(I16 ./ R, int16([- 16, - 16; - 16, - 16]));
assert_checkequal(I16 ./ i8, int16([2, 4; 6, 8]));
assert_checkequal(I16 ./ I8, int16([2, 2; 2, 2]));
assert_checkequal(I16 ./ ui8, uint16([8190, 8188; 8186, 8184]));
assert_checkequal(I16 ./ UI8, uint16([8190, 4094; 2728, 2046]));
assert_checkequal(I16 ./ i16, int16([1, 2; 3, 4]));
assert_checkequal(I16 ./ I16, int16([1, 1; 1, 1]));
assert_checkequal(I16 ./ ui16, uint16([4095, 4094; 4093, 4092]));
assert_checkequal(I16 ./ UI16, uint16([4095, 2047; 1364, 1023]));
assert_checkequal(I16 ./ i32, int32([0, 1; 1, 2]));
assert_checkequal(I16 ./ I32, int32([0, 0; 0, 0]));
assert_checkequal(I16 ./ ui32, uint32([134217727, 134217727; 134217726, 134217726]));
assert_checkequal(I16 ./ UI32, uint32([134217727, 67108863; 44739242, 33554431]));

assert_checkequal(ui16 ./ r, uint16(8));
assert_checkequal(ui16 ./ R, uint16([16, 8; 5, 4]));
assert_checkequal(ui16 ./ i8, uint16(0));
assert_checkequal(ui16 ./ I8, uint16([0, 0; 0, 0]));
assert_checkequal(ui16 ./ ui8, uint16(2));
assert_checkequal(ui16 ./ UI8, uint16([2, 1; 0, 0]));
assert_checkequal(ui16 ./ i16, uint16(0));
assert_checkequal(ui16 ./ I16, uint16([0, 0; 0, 0]));
assert_checkequal(ui16 ./ ui16, uint16(1));
assert_checkequal(ui16 ./ UI16, uint16([1, 0; 0, 0]));
assert_checkequal(ui16 ./ i32, uint32(0));
assert_checkequal(ui16 ./ I32, uint32([0, 0; 0, 0]));
assert_checkequal(ui16 ./ ui32, uint32(0));
assert_checkequal(ui16 ./ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(UI16 ./ r, uint16([8, 16; 24, 32]));
assert_checkequal(UI16 ./ R, uint16([16, 16; 16, 16]));
assert_checkequal(UI16 ./ i8, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 ./ I8, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 ./ ui8, uint16([2, 4; 6, 8]));
assert_checkequal(UI16 ./ UI8, uint16([2, 2; 2, 2]));
assert_checkequal(UI16 ./ i16, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 ./ I16, uint16([0, 0; 0, 0]));
assert_checkequal(UI16 ./ ui16, uint16([1, 2; 3, 4]));
assert_checkequal(UI16 ./ UI16, uint16([1, 1; 1, 1]));
assert_checkequal(UI16 ./ i32, uint32([0, 0; 0, 0]));
assert_checkequal(UI16 ./ I32, uint32([0, 0; 0, 0]));
assert_checkequal(UI16 ./ ui32, uint32([0, 1; 1, 2]));
assert_checkequal(UI16 ./ UI32, uint32([0, 0; 0, 0]));

assert_checkequal(i32 ./ r, int32(- 16));
assert_checkequal(i32 ./ R, int32([- 32, - 16; - 10, - 8]));
assert_checkequal(i32 ./ i8, int32(4));
assert_checkequal(i32 ./ I8, int32([4, 2; 1, 1]));
assert_checkequal(i32 ./ ui8, uint32(536870908));
assert_checkequal(i32 ./ UI8, uint32([536870908, 268435454; 178956969, 134217727]));
assert_checkequal(i32 ./ i16, int32(2));
assert_checkequal(i32 ./ I16, int32([2, 1; 0, 0]));
assert_checkequal(i32 ./ ui16, uint32(268435454));
assert_checkequal(i32 ./ UI16, uint32([268435454, 134217727; 89478484, 67108863]));
assert_checkequal(i32 ./ i32, int32(1));
assert_checkequal(i32 ./ I32, int32([1, 0; 0, 0]));
assert_checkequal(i32 ./ ui32, uint32(134217727));
assert_checkequal(i32 ./ UI32, uint32([134217727, 67108863; 44739242, 33554431]));

assert_checkequal(I32 ./ r, int32([- 16, - 32; - 48, - 64]));
assert_checkequal(I32 ./ R, int32([- 32, - 32; - 32, - 32]));
assert_checkequal(I32 ./ i8, int32([4, 8; 12, 16]));
assert_checkequal(I32 ./ I8, int32([4, 4; 4, 4]));
assert_checkequal(I32 ./ ui8, uint32([536870908, 536870904; 536870900, 536870896]));
assert_checkequal(I32 ./ UI8, uint32([536870908, 268435452; 178956966, 134217724]));
assert_checkequal(I32 ./ i16, int32([2, 4; 6, 8]));
assert_checkequal(I32 ./ I16, int32([2, 2; 2, 2]));
assert_checkequal(I32 ./ ui16, uint32([268435454, 268435452; 268435450, 268435448]));
assert_checkequal(I32 ./ UI16, uint32([268435454, 134217726; 89478483, 67108862]));
assert_checkequal(I32 ./ i32, int32([1, 2; 3, 4]));
assert_checkequal(I32 ./ I32, int32([1, 1; 1, 1]));
assert_checkequal(I32 ./ ui32, uint32([134217727, 134217726; 134217725, 134217724]));
assert_checkequal(I32 ./ UI32, uint32([134217727, 67108863; 44739241, 33554431]));

assert_checkequal(ui32 ./ r, uint32(16));
assert_checkequal(ui32 ./ R, uint32([32, 16; 10, 8]));
assert_checkequal(ui32 ./ i8, uint32(0));
assert_checkequal(ui32 ./ I8, uint32([0, 0; 0, 0]));
assert_checkequal(ui32 ./ ui8, uint32(4));
assert_checkequal(ui32 ./ UI8, uint32([4, 2; 1, 1]));
assert_checkequal(ui32 ./ i16, uint32(0));
assert_checkequal(ui32 ./ I16, uint32([0, 0; 0, 0]));
assert_checkequal(ui32 ./ ui16, uint32(2));
assert_checkequal(ui32 ./ UI16, uint32([2, 1; 0, 0]));
assert_checkequal(ui32 ./ i32, uint32(0));
assert_checkequal(ui32 ./ I32, uint32([0, 0; 0, 0]));
assert_checkequal(ui32 ./ ui32, uint32(1));
assert_checkequal(ui32 ./ UI32, uint32([1, 0; 0, 0]));

assert_checkequal(UI32 ./ r, uint32([16, 32; 48, 64]));
assert_checkequal(UI32 ./ R, uint32([32, 32; 32, 32]));
assert_checkequal(UI32 ./ i8, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 ./ I8, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 ./ ui8, uint32([4, 8; 12, 16]));
assert_checkequal(UI32 ./ UI8, uint32([4, 4; 4, 4]));
assert_checkequal(UI32 ./ i16, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 ./ I16, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 ./ ui16, uint32([2, 4; 6, 8]));
assert_checkequal(UI32 ./ UI16, uint32([2, 2; 2, 2]));
assert_checkequal(UI32 ./ i32, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 ./ I32, uint32([0, 0; 0, 0]));
assert_checkequal(UI32 ./ ui32, uint32([1, 2; 3, 4]));
assert_checkequal(UI32 ./ UI32, uint32([1, 1; 1, 1]));

