/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.File;
import java.io.FileReader;
import java.io.PushbackReader;
import java.util.Vector;
import org.sablecc.sablecc.AddAstProductions;
import org.sablecc.sablecc.AddEventualEmptyTransformationToProductions;
import org.sablecc.sablecc.AddProdTransformAndAltTransform;
import org.sablecc.sablecc.DisplayLicense;
import org.sablecc.sablecc.GenAlts;
import org.sablecc.sablecc.GenAnalyses;
import org.sablecc.sablecc.GenLexer;
import org.sablecc.sablecc.GenParser;
import org.sablecc.sablecc.GenProds;
import org.sablecc.sablecc.GenTokens;
import org.sablecc.sablecc.GenUtils;
import org.sablecc.sablecc.Grammar;
import org.sablecc.sablecc.LR0Collection;
import org.sablecc.sablecc.Production;
import org.sablecc.sablecc.ResolveAltIds;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.ResolveProdTransformIds;
import org.sablecc.sablecc.ResolveTransformIds;
import org.sablecc.sablecc.Symbol;
import org.sablecc.sablecc.lexer.Lexer;
import org.sablecc.sablecc.node.AGrammar;
import org.sablecc.sablecc.node.Start;
import org.sablecc.sablecc.parser.Parser;

public class SableCC {
    private static boolean processInlining = true;
    static int inliningMaxAlts = 20;
    private static boolean prettyPrinting = false;
    private static final String OPT_LICENSE = "--license";
    private static final String OPT_D = "-d";
    private static final String OPT_NO_INLINE = "--no-inline";
    private static final String OPT_INLINE_MAX_ALTS = "--inline-max-alts";
    private static final String OPT_PRETTY_PRINT = "--pretty-print";

    private static void displayCopyright() {
        System.out.println();
        System.out.println("SableCC version 3.2");
        System.out.println("Copyright (C) 1997-2003 Etienne M. Gagnon <etienne.gagnon@uqam.ca> and");
        System.out.println("others.  All rights reserved.");
        System.out.println();
        System.out.println("This software comes with ABSOLUTELY NO WARRANTY.  This is free software,");
        System.out.println("and you are welcome to redistribute it under certain conditions.");
        System.out.println();
        System.out.println("Type 'sablecc -license' to view");
        System.out.println("the complete copyright notice and license.");
        System.out.println();
    }

    private static void displayUsage() {
        System.out.println("Usage:");
        System.out.println("  sablecc [-d destination] [--no-inline] [--inline-max-alts number] [--pretty-print] filename [filename]...");
        System.out.println("  sablecc --license");
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        Vector<String> vector = new Vector<String>();
        if (stringArray.length == 0) {
            SableCC.displayCopyright();
            SableCC.displayUsage();
            System.exit(1);
        }
        if (stringArray.length == 1 && stringArray[0].equals(OPT_LICENSE)) {
            new DisplayLicense();
            System.exit(0);
        }
        SableCC.displayCopyright();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(OPT_D)) {
                if (string == null && ++n < stringArray.length) {
                    string = stringArray[n];
                    continue;
                }
                SableCC.displayUsage();
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals(OPT_NO_INLINE)) {
                processInlining = false;
                continue;
            }
            if (stringArray[n].equals(OPT_INLINE_MAX_ALTS)) {
                try {
                    inliningMaxAlts = Integer.parseInt(stringArray[++n]);
                }
                catch (Exception exception) {
                    SableCC.displayUsage();
                    System.exit(1);
                }
                continue;
            }
            if (stringArray[n].equals(OPT_PRETTY_PRINT)) {
                prettyPrinting = true;
                continue;
            }
            vector.addElement(stringArray[n]);
        }
        if (vector.size() == 0) {
            SableCC.displayUsage();
            System.exit(1);
        }
        try {
            for (n = 0; n < vector.size(); ++n) {
                SableCC.processGrammar((String)vector.elementAt(n), string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void processGrammar(String string, String string2) throws Exception {
        File file;
        File file2 = new File(string);
        file2 = new File(file2.getAbsolutePath());
        if (string2 == null) {
            file = new File(file2.getParent());
        } else {
            file = new File(string2);
            file = new File(file.getAbsolutePath());
        }
        SableCC.processGrammar(file2, file);
    }

    public static void processGrammar(File file, File file2) throws Exception {
        if (!file.exists()) {
            System.out.println("ERROR: grammar file " + file.getName() + " does not exist.");
            System.exit(1);
        }
        if (!file2.exists()) {
            System.out.println("ERROR: destination directory " + file2.getName() + " does not exist.");
            System.exit(1);
        }
        LR0Collection.reinit();
        Symbol.reinit();
        Production.reinit();
        Grammar.reinit();
        System.out.println("\n -- Generating parser for " + file.getName() + " in " + file2.getPath());
        FileReader fileReader = new FileReader(file);
        fileReader = new FileReader(file);
        Start start = new Parser(new Lexer(new PushbackReader(fileReader, 1000))).parse();
        fileReader.close();
        boolean bl = false;
        if (((AGrammar)start.getPGrammar()).getAst() == null) {
            System.out.println("Adding productions and alternative of section AST.");
            start.apply(new AddAstProductions());
        } else {
            bl = true;
        }
        System.out.println("Verifying identifiers.");
        ResolveIds resolveIds = new ResolveIds(file2);
        start.apply(resolveIds);
        System.out.println("Verifying ast identifiers.");
        ResolveAstIds resolveAstIds = new ResolveAstIds(resolveIds);
        start.apply(resolveAstIds);
        System.out.println("Adding empty productions and empty alternative transformation if necessary.");
        start.apply(new AddEventualEmptyTransformationToProductions(resolveIds, resolveAstIds));
        System.out.println("Adding productions and alternative transformation if necessary.");
        AddProdTransformAndAltTransform addProdTransformAndAltTransform = new AddProdTransformAndAltTransform();
        start.apply(addProdTransformAndAltTransform);
        System.out.println("computing alternative symbol table identifiers.");
        ResolveAltIds resolveAltIds = new ResolveAltIds(resolveIds);
        start.apply(resolveAltIds);
        System.out.println("Verifying production transform identifiers.");
        ResolveProdTransformIds resolveProdTransformIds = new ResolveProdTransformIds(resolveAstIds);
        start.apply(resolveProdTransformIds);
        System.out.println("Verifying ast alternatives transform identifiers.");
        ResolveTransformIds resolveTransformIds = new ResolveTransformIds(resolveAstIds, resolveAltIds, resolveProdTransformIds);
        start.apply(resolveTransformIds);
        System.out.println("Generating token classes.");
        start.apply(new GenTokens(resolveIds));
        System.out.println("Generating production classes.");
        start.apply(new GenProds(resolveAstIds));
        System.out.println("Generating alternative classes.");
        start.apply(new GenAlts(resolveAstIds));
        System.out.println("Generating analysis classes.");
        start.apply(new GenAnalyses(resolveAstIds));
        System.out.println("Generating utility classes.");
        start.apply(new GenUtils(resolveAstIds));
        try {
            System.out.println("Generating the lexer.");
            start.apply(new GenLexer(resolveIds));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw exception;
        }
        try {
            System.out.println("Generating the parser.");
            start.apply(new GenParser(resolveIds, resolveAltIds, resolveTransformIds, resolveAstIds.getFirstAstProduction(), processInlining, prettyPrinting, bl));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw exception;
        }
    }
}

