/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.LinkedList;
import java.util.Map;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.TypedTreeMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AAstAlt;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.ATokenSpecifier;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.TId;
import org.sablecc.sablecc.node.Token;

public class ResolveAstIds
extends DepthFirstAdapter {
    public final Map ast_prods = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ast_alts = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ast_elems = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)NodeCast.instance);
    public final Map ast_names = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public final Map ast_elemTypes = new TypedHashMap(NodeCast.instance, StringCast.instance);
    public ResolveIds astIds;
    private String firstAstProduction;
    private String currentProd;
    private String currentAlt;
    private int lastLine;
    private int lastPos;

    public ResolveAstIds(ResolveIds resolveIds) {
        this.astIds = resolveIds;
    }

    public String getFirstAstProduction() {
        return this.firstAstProduction;
    }

    public void inAAst(AAst aAst) {
        LinkedList linkedList = aAst.getProds();
        if (linkedList.size() > 0) {
            AAstProd aAstProd = (AAstProd)linkedList.getFirst();
            this.firstAstProduction = "P" + ResolveIds.name(aAstProd.getId().getText());
        }
    }

    public void inAAstProd(AAstProd aAstProd) {
        this.currentProd = ResolveIds.name(aAstProd.getId().getText());
        String string = "P" + this.currentProd;
        if (this.ast_prods.put(string, aAstProd) != null) {
            ResolveAstIds.error(aAstProd.getId(), string);
        }
        this.ast_names.put(aAstProd, string);
    }

    public void inAAstAlt(AAstAlt aAstAlt) {
        if (aAstAlt.getAltName() != null) {
            this.currentAlt = "A" + ResolveIds.name(aAstAlt.getAltName().getText()) + this.currentProd;
            if (this.ast_alts.put(this.currentAlt, aAstAlt) != null) {
                ResolveAstIds.error(aAstAlt.getAltName(), this.currentAlt);
            }
            this.ast_names.put(aAstAlt, this.currentAlt);
        } else {
            this.currentAlt = "A" + this.currentProd;
            if (this.ast_alts.put(this.currentAlt, aAstAlt) != null) {
                this.error(this.currentAlt);
            }
            this.ast_names.put(aAstAlt, this.currentAlt);
        }
    }

    public void caseAProductions(AProductions aProductions) {
    }

    public void caseAElem(AElem aElem) {
        TId tId = aElem.getElemName() != null ? aElem.getElemName() : aElem.getId();
        String string = tId.getText();
        String string2 = this.currentAlt + "." + ResolveIds.name(string);
        if (this.ast_elems.put(string2, aElem) != null) {
            ResolveAstIds.error(tId, string2);
        }
        if (string.equals("class")) {
            ResolveAstIds.error5(tId);
        }
        this.ast_names.put(aElem, ResolveIds.name(string));
    }

    public void outAAstProd(AAstProd aAstProd) {
        aAstProd.apply(new DepthFirstAdapter(){

            public void caseAElem(AElem aElem) {
                ResolveIds cfr_ignored_0 = ResolveAstIds.this.astIds;
                String string = ResolveIds.name(aElem.getId().getText());
                if (aElem.getSpecifier() != null) {
                    if (aElem.getSpecifier() instanceof ATokenSpecifier) {
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "T" + string);
                    } else {
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "P" + string);
                    }
                } else {
                    Object v = ResolveAstIds.this.astIds.tokens.get("T" + string);
                    if (v != null) {
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "T" + string);
                    } else {
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "P" + string);
                    }
                }
            }
        });
    }

    public void outAAst(AAst aAst) {
        aAst.apply(new DepthFirstAdapter(){

            public void caseAElem(AElem aElem) {
                ResolveIds cfr_ignored_0 = ResolveAstIds.this.astIds;
                String string = ResolveIds.name(aElem.getId().getText());
                if (aElem.getSpecifier() != null) {
                    if (aElem.getSpecifier() instanceof ATokenSpecifier) {
                        if (ResolveAstIds.this.astIds.tokens.get("T" + string) == null) {
                            ResolveAstIds.error2(aElem.getId(), "T" + string);
                        }
                        if (ResolveAstIds.this.astIds.ignTokens.get("T" + string) != null) {
                            ResolveAstIds.error3(aElem.getId(), "T" + string);
                        }
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "T" + string);
                    } else {
                        if (ResolveAstIds.this.ast_prods.get("P" + string) == null) {
                            ResolveAstIds.error2(aElem.getId(), "P" + string);
                        }
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "P" + string);
                    }
                } else {
                    Object v = ResolveAstIds.this.astIds.tokens.get("T" + string);
                    Object v2 = ResolveAstIds.this.astIds.ignTokens.get("T" + string);
                    Object v3 = ResolveAstIds.this.ast_prods.get("P" + string);
                    if (v == null && v3 == null) {
                        ResolveAstIds.error2(aElem.getId(), "P" + string + " and T" + string);
                    }
                    if (v != null) {
                        if (v3 != null) {
                            ResolveAstIds.error4(aElem.getId(), "P" + string + " and T" + string);
                        }
                        if (v2 != null) {
                            ResolveAstIds.error3(aElem.getId(), "T" + string);
                        }
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "T" + string);
                    } else {
                        ResolveAstIds.this.ast_elemTypes.put(aElem, "P" + string);
                    }
                }
            }
        });
    }

    public void defaultcase(Node node) {
        if (node instanceof Token) {
            Token token = (Token)node;
            this.lastLine = token.getLine();
            this.lastPos = token.getPos() + token.getText().length();
        }
    }

    private static void error(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "Redefinition of " + string + ".");
    }

    private void error(String string) {
        throw new RuntimeException("[" + this.lastLine + "," + this.lastPos + "] " + "Redefinition of " + string + ".");
    }

    private static void error2(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + string + " undefined. If it is a production, It should be defined in AST section");
    }

    private static void error3(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + string + " is ignored.");
    }

    private static void error4(Token token, String string) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "ambiguous " + string + ".");
    }

    private static void error5(Token token) {
        throw new RuntimeException("[" + token.getLine() + "," + token.getPos() + "] " + "class is an invalid element name.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Productions:");
        stringBuffer.append(string);
        stringBuffer.append(this.ast_prods);
        stringBuffer.append(string);
        stringBuffer.append("Alternatives:");
        stringBuffer.append(string);
        stringBuffer.append(this.ast_alts);
        stringBuffer.append(string);
        stringBuffer.append("Elements:");
        stringBuffer.append(string);
        stringBuffer.append(this.ast_elems);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

