A function call isn't allowed in the const's initialization expression
because the expression's value must be known at compile-time.

Erroneous code example:

```compile_fail,E0019
#![feature(box_syntax)]

fn main() {
    struct MyOwned;

    static STATIC11: Box<MyOwned> = box MyOwned; // error!
}
```

Remember: you can't use a function call inside a const's initialization
expression! However, you can totally use it anywhere else:

```
enum Test {
    V1
}

impl Test {
    fn func(&self) -> i32 {
        12
    }
}

fn main() {
    const FOO: Test = Test::V1;

    FOO.func(); // here is good
    let x = FOO.func(); // or even here!
}
```
