/* The following code was generated by JFlex 1.4.1 on 6/21/15 7:25 PM */

/*
 * 09/01/2014
 *
 * DartTokenMaker.java - Token parser for Dart.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for Dart files.  Its states could be simplified, but are
 * kept the way they are to keep a degree of similarity (i.e. copy/paste)
 * between it and HTML/JSP/PHPTokenMaker.  This should cause no difference in
 * performance.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>DartTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 1.0
 */

public class DartTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 1;
  public static final int JS_CHAR = 2;
  public static final int DART_MULTILINE_STRING_DOUBLE = 5;
  public static final int JS_EOL_COMMENT = 4;
  public static final int YYINITIAL = 0;
  public static final int JS_MLC = 3;
  public static final int DART_MULTILINE_STRING_SINGLE = 6;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\2\1\0\1\1\1\11\22\0\1\1\1\35\1\115"+
    "\1\12\1\15\1\35\1\37\1\44\2\43\1\17\1\30\1\27\1\24"+
    "\1\25\1\16\1\5\7\7\2\4\1\40\1\27\1\31\1\32\1\34"+
    "\1\36\1\42\1\75\1\6\1\76\1\77\1\23\1\22\1\3\1\101"+
    "\1\74\1\113\1\3\1\21\1\102\1\73\1\104\1\106\1\107\1\110"+
    "\1\103\1\100\1\114\1\3\1\111\1\20\1\3\1\112\1\43\1\13"+
    "\1\43\1\33\1\14\1\0\1\56\1\57\1\61\1\65\1\54\1\51"+
    "\1\67\1\45\1\52\1\105\1\72\1\53\1\70\1\63\1\62\1\47"+
    "\1\3\1\60\1\50\1\46\1\10\1\71\1\55\1\64\1\66\1\3"+
    "\1\26\1\41\1\26\1\36\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\2\1\1\2\1\3\1\4\1\5\2\6\1\5"+
    "\2\2\2\7\3\5\1\7\1\5\1\10\1\5\5\7"+
    "\2\2\1\11\37\5\1\12\1\1\1\13\1\14\1\15"+
    "\1\1\1\16\1\17\1\20\1\1\1\21\5\1\1\22"+
    "\3\1\1\23\1\24\1\1\1\25\1\26\1\1\1\2"+
    "\1\27\1\6\1\30\1\27\1\30\1\27\1\31\1\27"+
    "\1\5\4\2\1\32\1\33\5\5\1\0\1\7\1\34"+
    "\1\0\13\5\2\35\21\5\1\35\34\5\1\0\1\36"+
    "\1\37\1\40\1\41\10\0\1\24\1\0\1\26\1\0"+
    "\1\2\1\30\1\0\2\31\1\5\4\2\1\0\7\5"+
    "\1\42\13\5\1\43\17\5\1\43\31\5\1\44\15\5"+
    "\1\45\12\0\1\46\1\47\1\2\1\5\3\2\1\50"+
    "\7\5\1\51\64\5\1\0\1\1\2\0\1\52\2\0"+
    "\1\53\1\2\1\5\3\2\7\5\1\35\50\5\4\0"+
    "\1\2\1\5\3\2\3\5\1\44\6\5\1\54\23\5"+
    "\1\44\3\5\1\44\5\5\1\35\1\2\224\5";

  private static int [] zzUnpackAction() {
    int [] result = new int[616];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\116\0\234\0\352\0\u0138\0\u0186\0\u01d4\0\u0222"+
    "\0\u0270\0\u02be\0\u030c\0\u035a\0\u03a8\0\u03f6\0\u02be\0\u0444"+
    "\0\u0492\0\u04e0\0\u052e\0\u057c\0\u05ca\0\u0618\0\u0666\0\u02be"+
    "\0\u02be\0\u06b4\0\u0702\0\u0750\0\u02be\0\u079e\0\u07ec\0\u083a"+
    "\0\u0888\0\u08d6\0\u0924\0\u0972\0\u09c0\0\u0a0e\0\u0a5c\0\u0aaa"+
    "\0\u0af8\0\u0b46\0\u0b94\0\u0be2\0\u0c30\0\u0c7e\0\u0ccc\0\u0d1a"+
    "\0\u0d68\0\u0db6\0\u0e04\0\u0e52\0\u0ea0\0\u0eee\0\u0f3c\0\u0f8a"+
    "\0\u0fd8\0\u1026\0\u1074\0\u10c2\0\u1110\0\u115e\0\u11ac\0\u11fa"+
    "\0\u1248\0\u1296\0\u02be\0\u12e4\0\u02be\0\u1332\0\u02be\0\u12e4"+
    "\0\u02be\0\u1380\0\u02be\0\u13ce\0\u141c\0\u146a\0\u14b8\0\u1506"+
    "\0\u02be\0\u1554\0\u15a2\0\u15f0\0\u02be\0\u163e\0\u168c\0\u02be"+
    "\0\u16da\0\u1728\0\u1776\0\u17c4\0\u17c4\0\u17c4\0\u1812\0\u1860"+
    "\0\u18ae\0\u18fc\0\u194a\0\u1998\0\u19e6\0\u1a34\0\u1a82\0\u1ad0"+
    "\0\u02be\0\u1b1e\0\u1b6c\0\u1bba\0\u1c08\0\u1c56\0\u1ca4\0\u04e0"+
    "\0\u1cf2\0\u1d40\0\u1d8e\0\u1ddc\0\u1e2a\0\u1e78\0\u1ec6\0\u1f14"+
    "\0\u1f62\0\u1fb0\0\u1ffe\0\u204c\0\u209a\0\u20e8\0\u030c\0\u2136"+
    "\0\u2184\0\u21d2\0\u2220\0\u226e\0\u22bc\0\u230a\0\u2358\0\u23a6"+
    "\0\u23f4\0\u2442\0\u2490\0\u24de\0\u252c\0\u257a\0\u25c8\0\u2616"+
    "\0\u2664\0\u26b2\0\u2700\0\u274e\0\u279c\0\u27ea\0\u2838\0\u2886"+
    "\0\u28d4\0\u2922\0\u2970\0\u29be\0\u2a0c\0\u2a5a\0\u2aa8\0\u2af6"+
    "\0\u2b44\0\u2b92\0\u2be0\0\u2c2e\0\u2c7c\0\u2cca\0\u2d18\0\u2d66"+
    "\0\u2db4\0\u2e02\0\u2e50\0\u2e9e\0\u2eec\0\u2f3a\0\u2f88\0\u02be"+
    "\0\u2fd6\0\u3024\0\u02be\0\u3072\0\u30c0\0\u310e\0\u315c\0\u31aa"+
    "\0\u31f8\0\u3246\0\u3294\0\u02be\0\u32e2\0\u02be\0\u3330\0\u337e"+
    "\0\u33cc\0\u341a\0\u17c4\0\u3468\0\u34b6\0\u3504\0\u3552\0\u35a0"+
    "\0\u35ee\0\u363c\0\u368a\0\u36d8\0\u3726\0\u3774\0\u37c2\0\u3810"+
    "\0\u385e\0\u02be\0\u38ac\0\u38fa\0\u3948\0\u3996\0\u39e4\0\u3a32"+
    "\0\u3a80\0\u3ace\0\u3b1c\0\u3b6a\0\u3bb8\0\u3c06\0\u3c54\0\u3ca2"+
    "\0\u3cf0\0\u3d3e\0\u3d8c\0\u3dda\0\u3e28\0\u3e76\0\u3ec4\0\u3f12"+
    "\0\u3f60\0\u3fae\0\u3ffc\0\u404a\0\u4098\0\u030c\0\u40e6\0\u4134"+
    "\0\u4182\0\u41d0\0\u421e\0\u426c\0\u42ba\0\u4308\0\u4356\0\u43a4"+
    "\0\u43f2\0\u4440\0\u448e\0\u44dc\0\u452a\0\u4578\0\u45c6\0\u4614"+
    "\0\u4662\0\u46b0\0\u46fe\0\u474c\0\u479a\0\u47e8\0\u4836\0\u030c"+
    "\0\u4884\0\u48d2\0\u4920\0\u496e\0\u49bc\0\u4a0a\0\u4a58\0\u4aa6"+
    "\0\u4af4\0\u4b42\0\u4b90\0\u4bde\0\u4c2c\0\u02be\0\u4c7a\0\u4cc8"+
    "\0\u4d16\0\u4d64\0\u4db2\0\u4e00\0\u4e4e\0\u4e9c\0\u4eea\0\u4f38"+
    "\0\u02be\0\u02be\0\u4f86\0\u4fd4\0\u5022\0\u5070\0\u50be\0\u02be"+
    "\0\u510c\0\u515a\0\u51a8\0\u51f6\0\u5244\0\u5292\0\u52e0\0\u030c"+
    "\0\u532e\0\u537c\0\u53ca\0\u5418\0\u5466\0\u54b4\0\u5502\0\u5550"+
    "\0\u559e\0\u55ec\0\u563a\0\u5688\0\u56d6\0\u5724\0\u5772\0\u57c0"+
    "\0\u580e\0\u585c\0\u58aa\0\u58f8\0\u5946\0\u5994\0\u59e2\0\u5a30"+
    "\0\u5a7e\0\u5acc\0\u5b1a\0\u5b68\0\u5bb6\0\u5c04\0\u5c52\0\u5ca0"+
    "\0\u5cee\0\u5d3c\0\u5d8a\0\u5dd8\0\u5e26\0\u5e74\0\u5ec2\0\u5f10"+
    "\0\u5f5e\0\u5fac\0\u5ffa\0\u6048\0\u6096\0\u60e4\0\u6132\0\u6180"+
    "\0\u61ce\0\u621c\0\u626a\0\u62b8\0\u3024\0\u02be\0\u6306\0\u6354"+
    "\0\u63a2\0\u63f0\0\u643e\0\u648c\0\u64da\0\u6528\0\u6576\0\u65c4"+
    "\0\u6612\0\u6660\0\u66ae\0\u66fc\0\u674a\0\u6798\0\u67e6\0\u6834"+
    "\0\u6882\0\u68d0\0\u691e\0\u696c\0\u69ba\0\u6a08\0\u6a56\0\u6aa4"+
    "\0\u6af2\0\u6b40\0\u6b8e\0\u6bdc\0\u6c2a\0\u6c78\0\u6cc6\0\u6d14"+
    "\0\u6d62\0\u6db0\0\u6dfe\0\u6e4c\0\u6e9a\0\u6ee8\0\u6f36\0\u6f84"+
    "\0\u6fd2\0\u7020\0\u706e\0\u70bc\0\u710a\0\u7158\0\u71a6\0\u71f4"+
    "\0\u7242\0\u7290\0\u72de\0\u732c\0\u737a\0\u73c8\0\u7416\0\u7464"+
    "\0\u74b2\0\u7500\0\u63a2\0\u754e\0\u648c\0\u759c\0\u75ea\0\u7638"+
    "\0\u7686\0\u76d4\0\u7722\0\u7770\0\u77be\0\u780c\0\u785a\0\u78a8"+
    "\0\u78f6\0\u7944\0\u7992\0\u79e0\0\u030c\0\u7a2e\0\u7a7c\0\u7aca"+
    "\0\u7b18\0\u7b66\0\u7bb4\0\u7c02\0\u7c50\0\u7c9e\0\u7cec\0\u7d3a"+
    "\0\u7d88\0\u7dd6\0\u7e24\0\u7e72\0\u7ec0\0\u7f0e\0\u7f5c\0\u7faa"+
    "\0\u7ff8\0\u8046\0\u8094\0\u80e2\0\u8130\0\u817e\0\u81cc\0\u821a"+
    "\0\u8268\0\u82b6\0\u0222\0\u8304\0\u8352\0\u83a0\0\u83ee\0\u843c"+
    "\0\u848a\0\u84d8\0\u8526\0\u8574\0\u85c2\0\u8610\0\u865e\0\u86ac"+
    "\0\u86fa\0\u8748\0\u8796\0\u87e4\0\u8832\0\u8880\0\u88ce\0\u891c"+
    "\0\u896a\0\u89b8\0\u8a06\0\u8a54\0\u8aa2\0\u8af0\0\u8b3e\0\u8b8c"+
    "\0\u8bda\0\u8c28\0\u8c76\0\u8cc4\0\u8d12\0\u8d60\0\u8dae\0\u8dfc"+
    "\0\u8e4a\0\u8e98\0\u8ee6\0\u8f34\0\u8f82\0\u8fd0\0\u901e\0\u906c"+
    "\0\u90ba\0\u9108\0\u9156\0\u91a4\0\u91f2\0\u9240\0\u928e\0\u92dc"+
    "\0\u932a\0\u9378\0\u93c6\0\u9414\0\u9462\0\u94b0\0\u94fe\0\u954c"+
    "\0\u959a\0\u95e8\0\u9636\0\u9684\0\u96d2\0\u9720\0\u976e\0\u97bc"+
    "\0\u980a\0\u780c\0\u9858\0\u98a6\0\u98f4\0\u9942\0\u9990\0\u99de"+
    "\0\u9a2c\0\u9a7a\0\u9ac8\0\u9b16\0\u9b64\0\u9bb2\0\u9c00\0\u9c4e"+
    "\0\u9c9c\0\u9cea\0\u9d38\0\u9d86\0\u9dd4\0\u9e22\0\u9e70\0\u9ebe"+
    "\0\u9f0c\0\u9f5a\0\u9fa8\0\u9ff6\0\ua044\0\ua092\0\ua0e0\0\ua12e"+
    "\0\ua17c\0\ua1ca\0\ua218\0\ua266\0\ua2b4\0\ua302\0\ua350\0\ua39e"+
    "\0\ua3ec\0\ua43a\0\ua488\0\ua4d6\0\ua524\0\ua572\0\ua5c0\0\ua60e"+
    "\0\ua65c\0\ua6aa\0\ua6f8\0\ua746\0\ua794\0\ua7e2\0\ua830\0\ua87e"+
    "\0\ua8cc\0\ua91a\0\ua968\0\ua9b6\0\uaa04\0\uaa52\0\uaaa0\0\uaaee"+
    "\0\uab3c\0\uab8a\0\uabd8\0\uac26\0\uac74\0\uacc2\0\uad10\0\uad5e"+
    "\0\uadac\0\uadfa\0\uae48\0\uae96\0\uaee4\0\uaf32\0\uaf80\0\uafce";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[616];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\14"+
    "\1\13\1\17\1\20\1\10\2\13\1\21\1\22\1\13"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\2\22\1\34\1\22\1\35\1\36\1\35\1\37"+
    "\1\40\1\30\1\41\1\13\1\42\1\13\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\13\1\57\1\13\1\60\1\13\1\61"+
    "\1\13\1\62\1\63\1\64\1\65\1\66\1\67\1\70"+
    "\1\71\1\72\1\73\1\13\1\74\1\75\1\76\1\77"+
    "\2\13\1\100\1\101\2\102\1\103\10\102\1\104\101\102"+
    "\1\105\2\106\1\107\10\106\1\110\30\106\1\111\51\106"+
    "\2\112\1\113\14\112\1\114\25\112\1\115\3\112\1\116"+
    "\3\112\1\117\40\112\2\120\1\121\42\120\1\122\3\120"+
    "\1\123\3\120\1\124\40\120\2\102\1\125\10\102\1\126"+
    "\101\102\1\127\2\106\1\130\10\106\1\131\30\106\1\132"+
    "\51\106\1\10\2\0\6\10\1\0\4\10\2\0\4\10"+
    "\16\0\1\10\2\0\50\10\2\0\1\11\232\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\50\13\1\0\1\134\2\0\1\134"+
    "\2\14\1\134\1\14\1\134\1\0\4\134\2\0\1\134"+
    "\1\135\1\136\1\137\1\0\1\140\14\0\1\134\2\0"+
    "\4\134\1\136\1\134\1\135\1\137\10\134\1\136\11\134"+
    "\1\136\15\134\1\0\1\134\2\0\1\134\1\141\1\142"+
    "\1\134\1\142\1\134\1\0\4\134\2\0\1\143\1\135"+
    "\1\136\1\137\1\0\1\140\14\0\1\134\2\0\4\134"+
    "\1\136\1\134\1\135\1\137\7\134\1\143\1\136\11\134"+
    "\1\136\15\134\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\11\13"+
    "\1\144\36\13\1\0\1\10\2\0\6\10\1\0\4\10"+
    "\2\0\4\10\16\0\1\10\2\0\3\10\1\145\1\10"+
    "\1\146\1\147\4\10\1\150\34\10\17\0\1\151\1\152"+
    "\12\0\1\35\115\0\1\35\63\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\5\13\1\153\42\13\1\0\1\10\2\0\5\13"+
    "\1\154\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\11\13\1\155\36\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\17\13\1\156\3\13\1\157\24\13\25\0"+
    "\1\35\5\0\1\35\67\0\2\140\1\0\1\140\136\0"+
    "\1\35\1\0\1\35\114\0\1\160\1\35\115\0\1\35"+
    "\1\0\1\161\113\0\1\35\4\0\1\35\110\0\1\35"+
    "\6\0\1\35\54\0\1\10\2\0\1\162\2\10\1\162"+
    "\1\10\1\162\1\0\4\10\2\0\4\162\16\0\1\10"+
    "\2\0\50\162\45\0\1\163\51\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\164\12\13\1\165\5\13\1\166\26\13\1\0"+
    "\1\10\2\0\5\13\1\167\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\1\13\1\170\5\13"+
    "\1\171\1\172\4\13\1\173\32\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\5\13\1\174\3\13\1\175\3\13\1\176"+
    "\32\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\3\13\2\177"+
    "\11\13\1\200\4\13\1\201\24\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\5\13\1\202\42\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\6\13\1\203\10\13\1\204\30\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\205\47\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\3\13\1\206\6\13\1\207\35\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\210\1\13"+
    "\1\211\32\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\7\13"+
    "\1\212\40\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\6\13"+
    "\1\213\2\13\1\214\3\13\1\215\32\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\2\13\1\216\45\13\1\0\1\10"+
    "\2\0\5\13\1\217\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\7\13\1\220\40\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\7\13\1\221\5\13\1\222"+
    "\32\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\171"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\11\13\1\176"+
    "\3\13\1\223\32\13\1\0\1\10\2\0\5\13\1\224"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\11\13\1\225\3\13\1\226\32\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\1\13\1\227\1\13\1\230\2\13"+
    "\1\231\7\13\1\232\31\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\3\13\1\233\44\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\6\13\1\234\6\13\1\235\32\13\1\0\1\10"+
    "\2\0\5\13\1\236\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\5\13\1\237\3\13\1\240"+
    "\36\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\5\13\1\241"+
    "\13\13\1\242\26\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\11\13\1\243\36\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\11\13\1\244\36\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\1\13\1\245\5\13\1\246\40\13\1\0\1\10\2\0"+
    "\5\13\1\247\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\12\13\1\250\35\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\11\13\1\251\1\13\1\252\34\13"+
    "\1\0\1\10\2\0\5\13\1\253\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\50\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\7\13\1\254\40\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\13\13\1\255\34\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\16\13\1\256\31\13\116\0"+
    "\1\257\2\102\1\0\10\102\1\0\101\102\1\0\2\260"+
    "\1\0\5\260\1\261\53\260\1\262\31\260\2\106\1\0"+
    "\10\106\1\0\30\106\1\0\51\106\2\112\1\0\14\112"+
    "\1\0\25\112\1\0\3\112\1\0\3\112\1\0\40\112"+
    "\16\0\1\263\145\0\1\264\115\0\1\265\3\0\1\266"+
    "\120\0\1\267\40\0\2\120\1\0\42\120\1\0\3\120"+
    "\1\0\3\120\1\0\40\120\46\0\1\270\115\0\1\271"+
    "\3\0\1\272\120\0\1\273\40\0\2\274\1\0\113\274"+
    "\115\0\1\275\2\276\1\0\113\276\44\0\1\277\51\0"+
    "\1\10\2\0\5\10\1\300\1\0\4\10\2\0\4\10"+
    "\16\0\1\10\2\0\50\10\1\0\1\134\2\0\6\134"+
    "\1\0\4\134\2\0\4\134\16\0\1\134\2\0\50\134"+
    "\1\0\1\134\2\0\1\134\2\301\1\134\1\301\1\134"+
    "\1\0\4\134\2\0\4\134\1\302\3\0\1\302\11\0"+
    "\1\134\2\0\50\134\1\0\1\134\2\0\1\134\2\140"+
    "\1\134\1\140\1\134\1\0\4\134\2\0\2\134\1\136"+
    "\1\137\16\0\1\134\2\0\4\134\1\136\2\134\1\137"+
    "\10\134\1\136\11\134\1\136\15\134\1\0\1\134\2\0"+
    "\1\134\2\141\1\134\1\141\1\134\1\0\4\134\2\0"+
    "\2\134\1\136\1\137\1\0\1\140\14\0\1\134\2\0"+
    "\4\134\1\136\2\134\1\137\10\134\1\136\11\134\1\136"+
    "\15\134\1\0\1\134\2\0\1\134\1\141\1\142\1\134"+
    "\1\142\1\134\1\0\4\134\2\0\1\134\1\303\1\136"+
    "\1\137\1\0\1\140\14\0\1\134\2\0\4\134\1\136"+
    "\1\134\1\303\1\137\10\134\1\136\11\134\1\136\15\134"+
    "\1\0\1\134\2\0\1\134\4\304\1\134\1\0\4\134"+
    "\2\0\2\134\2\304\16\0\1\134\2\0\4\134\1\304"+
    "\2\134\1\304\1\134\2\304\1\134\1\304\3\134\1\304"+
    "\7\134\3\304\15\134\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\20\13\1\305\27\13\1\0\1\10\2\0\6\10\1\0"+
    "\4\10\2\0\4\10\16\0\1\10\2\0\15\10\1\306"+
    "\32\10\1\0\1\10\2\0\6\10\1\0\4\10\2\0"+
    "\4\10\16\0\1\10\2\0\23\10\1\307\24\10\1\0"+
    "\1\10\2\0\6\10\1\0\4\10\2\0\4\10\16\0"+
    "\1\10\2\0\5\10\1\310\42\10\1\0\1\10\2\0"+
    "\6\10\1\0\4\10\2\0\4\10\16\0\1\10\2\0"+
    "\7\10\1\311\40\10\20\0\1\312\76\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\3\13\1\313\12\13\1\314\31\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\16\13\1\315\31\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\6\13\1\316\41\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\2\13\1\317\11\13\1\320"+
    "\33\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\2\13\1\321"+
    "\45\13\33\0\1\35\1\0\1\22\61\0\1\10\2\0"+
    "\6\162\1\0\4\10\2\0\4\162\16\0\1\10\2\0"+
    "\50\162\45\0\1\322\51\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\5\13\1\323\5\13\1\324\34\13\1\0\1\10\2\0"+
    "\5\13\1\325\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\21\13\1\177\26\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\2\13\1\326\45\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\2\13\1\327\45\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\11\13\1\330\36\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\1\13\1\177\46\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\5\13\1\331\42\13\1\0\1\10"+
    "\2\0\5\13\1\332\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\50\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\16\13\1\333\31\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\6\13\1\334\5\13\1\335\33\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\13\13\1\177\34\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\336\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\2\13\1\337\45\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\12\13\1\340\35\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\3\13\1\341\44\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\342\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\5\13\1\343\42\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\3\13\1\344\44\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\3\13\1\345\44\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\7\13\1\346\40\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\15\13\1\347\32\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\350\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\11\13\1\351\36\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\352\1\13\1\341"+
    "\44\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\16\13\1\353"+
    "\31\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\354"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\6\13\1\355"+
    "\14\13\1\356\24\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\10\13\1\177\11\13\1\357\25\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\4\13\1\360\43\13\1\0\1\10\2\0"+
    "\5\13\1\361\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\50\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\5\13\1\362\42\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\6\13\1\363\41\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\26\13\1\177\21\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\13\1\364\33\13\1\365\1\366\11\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\7\13\1\367\40\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\15\13\1\370\32\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\6\13\1\371\41\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\372\2\13\1\373"+
    "\13\13\1\374\27\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\3\13\1\375\44\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\15\13\1\376\32\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\6\13\1\377\14\13\1\u0100\24\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\13\13\1\u0101\34\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\3\13\1\u0102\44\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\13\1\u0103\46\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\23\13\1\u0104\24\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\2\13\1\u0105\45\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\3\13\1\u0106\44\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\13\1\u0107\1\u0108\45\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\11\13\1\u0109\1\13\1\u010a\1\13"+
    "\1\u010b\32\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\1\13"+
    "\1\u0108\14\13\1\u010c\31\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\13\1\u010d\46\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\40\13\1\u010e\7\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\13\1\u010f\46\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\15\13\1\u0110\32\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\7\13\1\u0111\40\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\14\13\1\u0112\5\13\1\u0113\25\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\15\13\1\u0114\32\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\3\13\1\u0115\44\13\116\0\1\u0116"+
    "\4\0\4\u0117\12\0\2\u0117\25\0\1\u0117\2\0\1\u0117"+
    "\1\0\2\u0117\1\0\1\u0117\3\0\1\u0117\7\0\3\u0117"+
    "\22\0\4\u0118\12\0\2\u0118\25\0\1\u0118\2\0\1\u0118"+
    "\1\0\2\u0118\1\0\1\u0118\3\0\1\u0118\7\0\3\u0118"+
    "\64\0\1\u0119\116\0\1\u011a\121\0\1\u011b\117\0\1\u011c"+
    "\106\0\1\u011d\116\0\1\u011e\121\0\1\u011f\117\0\1\u0120"+
    "\155\0\1\u0121\44\0\1\u0122\51\0\1\10\2\0\1\10"+
    "\4\u0123\1\10\1\0\4\10\2\0\2\10\2\u0123\16\0"+
    "\1\10\2\0\4\10\1\u0123\2\10\1\u0123\1\10\2\u0123"+
    "\1\10\1\u0123\3\10\1\u0123\7\10\3\u0123\15\10\1\0"+
    "\1\134\2\0\1\134\2\301\1\134\1\301\1\134\1\0"+
    "\4\134\2\0\2\134\1\136\1\134\16\0\1\134\2\0"+
    "\4\134\1\136\13\134\1\136\11\134\1\136\15\134\5\0"+
    "\2\301\1\0\1\301\106\0\1\134\2\0\1\134\4\304"+
    "\1\134\1\0\4\134\2\0\1\134\1\303\2\304\16\0"+
    "\1\134\2\0\4\134\1\304\1\134\1\303\1\304\1\134"+
    "\2\304\1\134\1\304\3\134\1\304\7\134\3\304\15\134"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\26\13\1\u0124\21\13"+
    "\1\0\1\10\2\0\5\10\1\u0125\1\0\4\10\2\0"+
    "\4\10\16\0\1\10\2\0\50\10\1\0\1\10\2\0"+
    "\6\10\1\0\4\10\2\0\4\10\16\0\1\10\2\0"+
    "\2\10\1\u0126\45\10\1\0\1\10\2\0\6\10\1\0"+
    "\4\10\2\0\4\10\16\0\1\10\2\0\12\10\1\u0127"+
    "\35\10\1\0\1\10\2\0\6\10\1\0\4\10\2\0"+
    "\4\10\16\0\1\10\2\0\3\10\1\145\44\10\17\0"+
    "\1\u0128\77\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\1\13\1\u0108"+
    "\46\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\25\13\1\u0129"+
    "\22\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\14\13\1\u012a"+
    "\33\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\6\13\1\u012b"+
    "\41\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u012c"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u012d"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\1\13\1\u012e"+
    "\46\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\3\13\1\177"+
    "\44\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\15\13\1\u012f"+
    "\32\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u0130"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u0131"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\176"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\1\13\1\u0132"+
    "\46\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\1\13\1\352"+
    "\46\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\13\13\1\u0133"+
    "\34\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\11\13\1\u0134"+
    "\36\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\3\13\1\325"+
    "\44\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\1\13\1\u0135"+
    "\46\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u0136"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\6\13\1\u0137"+
    "\6\13\1\u0138\32\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\13\13\1\u0139\34\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\177\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u013a\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\6\13\1\341\41\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u0138\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\1\13\1\u013b\46\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\11\13\1\u013c\36\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\6\13\1\356\41\13\1\0\1\10\2\0\5\13\1\u013d"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\50\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\3\13"+
    "\1\323\44\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\14\13"+
    "\1\u013e\33\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\1\13"+
    "\1\u013f\1\13\1\171\44\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\13\13\1\u0140\34\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\6\13\1\177\41\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\11\13\1\u0141\36\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\11\13\1\u0142\36\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\12\13\1\u0143\35\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\20\13\1\356\27\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\6\13\1\u0144\41\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\27\13\1\u0145\20\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\15\13\1\u0146\32\13\1\0\1\10\2\0\5\13"+
    "\1\u0147\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\50\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\13\13\1\u0148\34\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\6\13\1\u0149\41\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u014a\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u014b\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\5\13\1\u014c\42\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u014d\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u014e\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\3\13\1\u014f\10\13\1\u0150\33\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\6\13\1\u0151\41\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\2\13\1\u0152\45\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\11\13\1\u012a\36\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\2\13\1\u0153\45\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\u0108\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\u0154\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\u0155\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\u0156\47\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\u0108\13\13\1\u0157\33\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\14\13\1\u0158\33\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\5\13\1\u0159\42\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\2\13\1\u015a\45\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\20\13\1\u015b\27\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\37\13\1\u015c\10\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\u015d\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\13\1\u015e\46\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\17\13\1\u015f\3\13\1\u0160\24\13\1\0"+
    "\1\10\2\0\5\13\1\u0103\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\50\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\7\13\1\u0161\40\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\3\13"+
    "\1\u0162\16\0\1\10\2\0\50\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\16\13\1\u0163\31\13\1\0\1\10\2\0"+
    "\5\13\1\u0164\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\50\13\5\0\4\u0165\12\0\2\u0165"+
    "\25\0\1\u0165\2\0\1\u0165\1\0\2\u0165\1\0\1\u0165"+
    "\3\0\1\u0165\7\0\3\u0165\22\0\4\u0166\12\0\2\u0166"+
    "\25\0\1\u0166\2\0\1\u0166\1\0\2\u0166\1\0\1\u0166"+
    "\3\0\1\u0166\7\0\3\u0166\65\0\1\u0167\106\0\1\u0168"+
    "\131\0\1\u011a\66\0\1\u0169\137\0\1\u016a\106\0\1\u016b"+
    "\131\0\1\u011e\66\0\1\u016c\70\0\1\10\2\0\1\10"+
    "\4\u016d\1\10\1\0\4\10\2\0\2\10\2\u016d\16\0"+
    "\1\10\2\0\4\10\1\u016d\2\10\1\u016d\1\10\2\u016d"+
    "\1\10\1\u016d\3\10\1\u016d\7\10\3\u016d\15\10\1\0"+
    "\1\10\2\0\5\13\1\u016e\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\50\13\1\0\1\10"+
    "\2\0\6\10\1\0\4\10\2\0\4\10\16\0\1\10"+
    "\2\0\13\10\1\u016f\34\10\1\0\1\10\2\0\6\10"+
    "\1\0\4\10\2\0\4\10\16\0\1\10\2\0\15\10"+
    "\1\u0170\32\10\1\0\1\10\2\0\6\10\1\0\4\10"+
    "\2\0\4\10\16\0\1\10\2\0\13\10\1\u0171\34\10"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\7\13\1\u0172\40\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\1\13\1\u0173\46\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\33\13\1\u0174\14\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\14\13\1\u0175\33\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\2\13\1\u012a\45\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\21\13\1\u0176\26\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\10\13\1\177\37\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\20\13\1\u0177\27\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\5\13\1\u0178\42\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\14\13\1\341\33\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\6\13\1\u0179\41\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\15\13\1\u017a\32\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\u017b\34\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\7\13\1\u017c\40\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\171\34\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\11\13\1\u017a\36\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\16\13\1\u017d\31\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\u017e\34\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\25\13\1\177\22\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\u017f\34\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\1\177\47\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\5\13\1\u0180\42\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\11\13\1\u0181\36\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\341\46\13\1\0"+
    "\1\10\2\0\5\13\1\u0182\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\50\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\6\13\1\u0183\41\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\41\13\1\u0184\6\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\23\13\1\u0185\24\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\13\13\1\u0186\34\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\14\13\1\u0187\33\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\11\13\1\u0188\36\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\11\13\1\240\36\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\22\13\1\u0189\25\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\22\13\1\u018a\25\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\16\13\1\u018b\31\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\17\13\1\u018c\30\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\13\13\1\u018d\34\13\1\0\1\10"+
    "\2\0\5\13\1\u018e\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\50\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\25\13\1\u0108\22\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\315\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\11\13\1\u018f\36\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\11\13\1\u0190\36\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\45\13\1\u0191\2\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\3\13\1\u0192"+
    "\16\0\1\10\2\0\50\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\11\13\1\u0193\23\13\1\u0194\1\u0195\11\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\u0108\47\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\25\13\1\u0196\22\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\16\13\1\u0197\31\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\44\13\1\u0198\3\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\41\13\1\u0199\6\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\4\13\1\u019a\43\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\14\13\1\u019b\33\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\7\13\1\u019c\40\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\21\13\1\u0108\26\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\5\13\1\u019d\42\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\5\13\1\u019e\42\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\17\13\1\u019f\30\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\22\13\1\u01a0\25\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\2\13\1\u01a1\45\13\41\0\1\u0168"+
    "\7\0\1\u011a\63\0\1\u01a2\102\0\6\u0169\1\0\1\u01a3"+
    "\1\0\1\u01a3\2\u0169\1\u01a3\4\u0169\2\u01a3\1\0\2\u01a3"+
    "\1\0\1\u01a3\2\0\4\u01a3\1\0\3\u01a3\50\u0169\41\0"+
    "\1\u016b\7\0\1\u011e\63\0\1\u01a4\102\0\6\u016c\1\0"+
    "\1\u01a5\1\0\1\u01a5\2\u016c\1\u01a5\4\u016c\2\u01a5\1\0"+
    "\2\u01a5\1\0\1\u01a5\2\0\4\u01a5\1\0\3\u01a5\50\u016c"+
    "\1\0\1\10\2\0\1\10\4\u01a6\1\10\1\0\4\10"+
    "\2\0\2\10\2\u01a6\16\0\1\10\2\0\4\10\1\u01a6"+
    "\2\10\1\u01a6\1\10\2\u01a6\1\10\1\u01a6\3\10\1\u01a6"+
    "\7\10\3\u01a6\15\10\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\23\13\1\u01a7\24\13\1\0\1\10\2\0\6\10\1\0"+
    "\4\10\2\0\4\10\16\0\1\10\2\0\14\10\1\u01a8"+
    "\33\10\1\0\1\10\2\0\6\10\1\0\4\10\2\0"+
    "\4\10\16\0\1\10\2\0\13\10\1\u01a9\34\10\1\0"+
    "\1\10\2\0\6\10\1\0\4\10\2\0\4\10\16\0"+
    "\1\10\2\0\11\10\1\u01aa\36\10\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\20\13\1\u01ab\27\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\5\13\1\u01ac\42\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\u01ad\47\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\13\1\u01ae\46\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\42\13\1\u01af\5\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\7\13\1\u01b0\40\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\14\13\1\177\33\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\6\13\1\u01b1\41\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\13\13\1\u01b1\34\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\4\13\1\u01b2\43\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\23\13\1\u01b3\24\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\20\13\1\323\27\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\11\13\1\u01b4\36\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\16\13\1\u01b5\31\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\16\13\1\u01b6\31\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\13\1\u01b7\46\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\6\13\1\171\41\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\7\13\1\356\40\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\15\13\1\u01b8\32\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\2\13\1\u01b9\45\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\7\13\1\u01ba\40\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\1\u01bb\47\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\1\13\1\u01bc\10\13\1\u01bd\35\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\11\13\1\u01be\36\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\u01bf\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\5\13\1\u01c0\42\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\37\13\1\u01c1\10\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\13\1\u01c2\46\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\13\13\1\u01c3\34\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\13\13\1\u01c4\34\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\13\1\u01c5\46\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\15\13\1\u01c6\32\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\13\13\1\u01c7\34\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\12\13\1\u01bd\35\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\11\13\1\u019f\36\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\313\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\37\13\1\u01c8\10\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\22\13\1\u01c9\25\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\11\13\1\u01ca\36\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\15\13\1\u01cb\32\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\35\13\1\u01cc\12\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\13\1\u01cd\46\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\13\13\1\u01ce\34\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\3\13\1\u0103\44\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\24\13\1\u01cf\23\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\2\13\1\u0108\45\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\30\13\1\u01d0\17\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\2\13\1\u01d1\45\13\17\0\1\u0169\115\0"+
    "\1\u016c\77\0\1\10\2\0\1\10\4\13\1\10\1\0"+
    "\4\10\2\0\2\10\2\13\16\0\1\10\2\0\4\10"+
    "\1\13\2\10\1\13\1\10\2\13\1\10\1\13\3\10"+
    "\1\13\7\10\3\13\15\10\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\12\13\1\u01d2\35\13\1\0\1\10\2\0\6\10"+
    "\1\0\4\10\2\0\4\10\16\0\1\10\2\0\7\10"+
    "\1\u01d3\40\10\1\0\1\10\2\0\6\10\1\0\4\10"+
    "\2\0\4\10\16\0\1\10\2\0\1\10\1\u01d3\46\10"+
    "\1\0\1\10\2\0\6\10\1\0\4\10\2\0\4\10"+
    "\16\0\1\10\2\0\13\10\1\u01d4\34\10\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\34\13\1\u01d5\13\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\15\13\1\u01ce\32\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\13\13\1\u01d6\34\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\3\13"+
    "\1\u01d7\16\0\1\10\2\0\50\13\1\0\1\10\2\0"+
    "\5\13\1\u01d8\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\50\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\4\13\1\177\43\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\21\13\1\177\26\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\11\13\1\u0133\36\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\7\13\1\u01d9\40\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\14\13\1\171\33\13\1\0\1\10\2\0\5\13"+
    "\1\341\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\50\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\15\13\1\176\32\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\5\13\1\u01da\42\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\6\13\1\u01db\41\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\3\13\1\u01dc\16\0\1\10"+
    "\2\0\50\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\35\13"+
    "\1\u01dd\12\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\15\13"+
    "\1\u01de\32\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\6\13"+
    "\1\u0103\41\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\6\13"+
    "\1\u01df\41\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\13\13"+
    "\1\u01e0\34\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\1\13"+
    "\1\u01b1\46\13\1\0\1\10\2\0\5\13\1\u01e1\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\50\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\5\13\1\u01e2"+
    "\42\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u01e3"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\11\13\1\u0193"+
    "\36\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\14\13\1\u01e4"+
    "\33\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\16\13\1\u0103"+
    "\31\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\13\13\1\u01bc"+
    "\34\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\24\13\1\u01e5"+
    "\23\13\1\0\1\10\2\0\3\13\1\u01e6\2\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\3\13\1\u0108\44\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\1\13\1\u01e7\46\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\13\13\1\313\34\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u01e8\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\26\13\1\u01e9\21\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\16\13\1\u0108\31\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u015b\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\13\13\1\u01ea\34\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\15\13\1\u01eb\32\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u01ec\40\13\1\0\1\10\2\0\6\10\1\0"+
    "\4\10\2\0\4\10\16\0\1\10\2\0\21\10\1\u01d3"+
    "\26\10\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\11\13\1\u01ed"+
    "\36\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\15\13\1\u01ee"+
    "\32\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\17\13\1\u01ef"+
    "\30\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u01f0"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\16\13\1\u01f1"+
    "\31\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\16\13\1\u01f2"+
    "\31\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u01f3"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\6\13\1\u01f4"+
    "\41\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u01f5"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\13\13\1\u0108"+
    "\34\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\30\13\1\u01f6"+
    "\15\13\1\u01f7\1\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\32\13\1\u01f8\15\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\1\13\1\u01f9\46\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\15\13\1\u01fa\32\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\30\13\1\u01fb\17\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\1\u01fc\47\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\7\13"+
    "\1\u01fd\40\13\1\0\1\10\2\0\5\13\1\u01fe\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\50\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\14\13\1\u0157"+
    "\33\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\23\13\1\u01ff"+
    "\24\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\15\13\1\u0200"+
    "\32\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\22\13\1\u0201"+
    "\25\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\13\13\1\u0202"+
    "\34\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\13\13\1\u0203"+
    "\34\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\3\13\1\u0204"+
    "\44\13\1\0\1\10\2\0\5\13\1\u0205\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\50\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\14\13\1\320\33\13"+
    "\1\0\1\10\2\0\5\13\1\u0206\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\50\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\323\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\u0207\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\23\13\1\u0208\24\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\7\13\1\u0209\40\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\u020a\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\13\13\1\u020b\1\u020c\33\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\36\13\1\u020d\11\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\5\13\1\u020e\42\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\37\13\1\u020f\10\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\16\13\1\u0155\31\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\u0210\34\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\7\13\1\u01de\40\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\u0211\34\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\4\13\1\u0212\43\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\15\13\1\u0213\32\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\1\13\1\u0214\46\13"+
    "\1\0\1\10\2\0\5\13\1\u0215\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\50\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\u0216\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\2\13\1\u0217\1\13\16\0\1\10\2\0\50\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\u0218\47\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\22\13\1\u0219\25\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\7\13\1\u021a\40\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\7\13\1\u021b\40\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\7\13\1\u021c\40\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\23\13\1\u021d\24\13\1\0\1\10"+
    "\2\0\6\13\1\0\1\10\1\133\2\13\2\0\4\13"+
    "\16\0\1\10\2\0\1\u021e\47\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\22\13\1\u021f\25\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\14\13\1\u0220\33\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\43\13\1\u0221\4\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\24\13\1\u0222\23\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\4\13\1\u0223\43\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\22\13\1\u0224\25\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\4\13\1\u0225\43\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\4\13\1\u01fc\43\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\13\13\1\u0226\34\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\31\13\1\u0227\16\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\23\13\1\u0228\24\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\7\13\1\u0229\40\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\15\13\1\u022a\32\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\35\13\1\u0194\12\13\1\0\1\10\2\0"+
    "\6\13\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\1\u0155\47\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\13\13\1\u021a\34\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\16\13\1\u022b\31\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\7\13\1\u022c\40\13\1\0\1\10\2\0\6\13"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\15\13\1\u022d\32\13\1\0\1\10\2\0\5\13"+
    "\1\u022e\1\0\1\10\1\133\2\13\2\0\4\13\16\0"+
    "\1\10\2\0\50\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u022f\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\7\13\1\u0230\40\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\5\13\1\u0231\42\13\1\0\1\10\2\0\6\13\1\0"+
    "\1\10\1\133\2\13\2\0\4\13\16\0\1\10\2\0"+
    "\43\13\1\u0232\4\13\1\0\1\10\2\0\5\13\1\u0233"+
    "\1\0\1\10\1\133\2\13\2\0\4\13\16\0\1\10"+
    "\2\0\50\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\6\13"+
    "\1\u0234\41\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\21\13"+
    "\1\u021a\26\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\6\13"+
    "\1\u0235\41\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\7\13"+
    "\1\u0236\40\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\20\13"+
    "\1\u0237\27\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\13\13"+
    "\1\u0238\34\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\1\13"+
    "\1\u0239\46\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\16\13"+
    "\1\u023a\31\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\20\13"+
    "\1\u021a\27\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\23\13"+
    "\1\u023b\24\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\3\13"+
    "\1\u023c\44\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\22\13"+
    "\1\u023d\25\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\3\13"+
    "\1\u023e\44\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\11\13"+
    "\1\u023f\36\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\23\13"+
    "\1\u0240\24\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\15\13"+
    "\1\u0241\32\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\15\13"+
    "\1\u0242\32\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\16\13"+
    "\1\u0243\31\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\37\13"+
    "\1\u0244\10\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\23\13"+
    "\1\u0245\24\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\7\13"+
    "\1\u022d\40\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\1\13"+
    "\1\u023c\46\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\7\13"+
    "\1\u0246\40\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\3\13"+
    "\1\u021a\44\13\1\0\1\10\2\0\6\13\1\0\1\10"+
    "\1\133\2\13\2\0\3\13\1\u0247\16\0\1\10\2\0"+
    "\50\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\5\13\1\u0248"+
    "\42\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\16\13\1\u0249"+
    "\31\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\7\13\1\u024a"+
    "\40\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\10\13\1\u021a"+
    "\37\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\3\13\1\u024b"+
    "\44\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\1\13\1\u024c"+
    "\46\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\2\13\1\u024d"+
    "\45\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\11\13\1\u024e"+
    "\36\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\16\13\1\u024e"+
    "\31\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\17\13\1\u024f"+
    "\30\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\15\13\1\u0250"+
    "\32\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\22\13\1\u0206"+
    "\25\13\1\0\1\10\2\0\6\13\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\16\13\1\u0251"+
    "\31\13\1\0\1\10\2\0\5\13\1\u0252\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\50\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\31\13\1\u0253\16\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\7\13\1\u0254\40\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\1\13\1\u021a\46\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\2\13\1\u021a\45\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\16\13\1\u0255\31\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\1\13\1\u0256\46\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\u0206\34\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\15\13\1\u0257\32\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\13\13\1\u0258\34\13"+
    "\1\0\1\10\2\0\3\13\1\u0259\2\13\1\0\1\10"+
    "\1\133\2\13\2\0\4\13\16\0\1\10\2\0\50\13"+
    "\1\0\1\10\2\0\6\13\1\0\1\10\1\133\2\13"+
    "\2\0\4\13\16\0\1\10\2\0\35\13\1\u025a\12\13"+
    "\1\0\1\10\2\0\5\13\1\u0246\1\0\1\10\1\133"+
    "\2\13\2\0\4\13\16\0\1\10\2\0\50\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\11\13\1\u025b\36\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\21\13\1\u025c\26\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\5\13\1\u025d\42\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\u025e\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\45\13\1\u025f\2\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\3\13\1\u0260\44\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\5\13\1\u0261\42\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\7\13\1\u0262\40\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\23\13\1\u0263\24\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\15\13\1\u0264\32\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\13\13\1\u0265\34\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\11\13\1\u0266\36\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\16\13\1\u021a\31\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\15\13\1\u021a\32\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\13\1\u0267\46\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\14\13\1\u0268\33\13\1\0"+
    "\1\10\2\0\6\13\1\0\1\10\1\133\2\13\2\0"+
    "\4\13\16\0\1\10\2\0\1\u021a\47\13\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[45084];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\4\1\1\11\4\1\1\11\10\1\2\11\3\1"+
    "\1\11\45\1\1\11\1\1\1\11\1\1\1\11\1\1"+
    "\1\11\1\1\1\11\5\1\1\11\3\1\1\11\2\1"+
    "\1\11\20\1\1\11\6\1\1\0\2\1\1\0\73\1"+
    "\1\0\1\11\2\1\1\11\10\0\1\11\1\0\1\11"+
    "\1\0\2\1\1\0\7\1\1\0\7\1\1\11\103\1"+
    "\1\11\12\0\2\11\5\1\1\11\74\1\1\0\1\11"+
    "\2\0\1\1\2\0\66\1\4\0\303\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[616];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specifying we're in a JavaScript multi-line comment.
	 */
	private static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_INVALID	= -10;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_VALID		= -11;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_INVALID	= -12;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_VALID		= -13;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;

	/**
	 * The version of JavaScript being highlighted.
	 */
	private static String jsVersion;

	/**
	 * Language state set on JS tokens.  Must be 0.
	 */
	private static final int LANG_INDEX_DEFAULT	= 0;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public DartTokenMaker() {
		super();
	}


	static {
		jsVersion = "1.0";
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the closest {@link TokenTypes "standard" token type} for a given
	 * "internal" token type (e.g. one whose value is <code>&lt; 0</code>).
	 */
	 @Override
	public int getClosestStandardTokenTypeForInternalType(int type) {
		switch (type) {
			case INTERNAL_IN_JS_MLC:
				return TokenTypes.COMMENT_MULTILINE;
			case INTERNAL_IN_JS_STRING_INVALID:
			case INTERNAL_IN_JS_STRING_VALID:
			case INTERNAL_IN_JS_CHAR_INVALID:
			case INTERNAL_IN_JS_CHAR_VALID:
				return TokenTypes.LITERAL_STRING_DOUBLE_QUOTE;
		}
		return type;
	}


	/**
	 * Returns the JavaScript version being highlighted.
	 *
	 * @return Supported JavaScript version.
	 * @see #isJavaScriptCompatible(String)
	 */
	public static String getJavaScriptVersion() {
		return jsVersion;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		validJSString = true;
		int languageIndex = LANG_INDEX_DEFAULT;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = DART_MULTILINE_STRING_DOUBLE;
				break;
			case Token.LITERAL_CHAR:
				state = DART_MULTILINE_STRING_SINGLE;
				break;
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				break;
			default:
				state = YYINITIAL; // ???
				break;
		}

		setLanguageIndex(languageIndex);
		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Returns whether features for a specific JS version should be honored
	 * while highlighting.
	 * 
	 * @param version JavaScript version required 
	 * @return Whether the JavaScript version is the same or greater than
	 *         version required. 
	 */
	public static boolean isJavaScriptCompatible(String version) {
		return jsVersion.compareTo(version) >= 0;
	}


	/**
	 * Set the supported JavaScript version because some keywords were
	 * introduced on or after this version.
	 *
	 * @param javaScriptVersion The version of JavaScript to support, such as
	 *        "<code>1.5</code>" or "<code>1.6</code>".
	 * @see #isJavaScriptCompatible(String)
	 * @see #getJavaScriptVersion()
	 */
	public static void setJavaScriptVersion(String javaScriptVersion) {
		jsVersion = javaScriptVersion;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DartTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DartTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 190) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 11: 
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 45: break;
        case 5: 
          { addToken(Token.IDENTIFIER);
          }
        case 46: break;
        case 41: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 47: break;
        case 39: 
          { addToken(start,zzStartRead+2, Token.LITERAL_CHAR); yybegin(YYINITIAL);
          }
        case 48: break;
        case 30: 
          { /* Skip all escaped chars. */
          }
        case 49: break;
        case 32: 
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 50: break;
        case 38: 
          { addToken(start,zzStartRead+2, Token.LITERAL_STRING_DOUBLE_QUOTE); yybegin(YYINITIAL);
          }
        case 51: break;
        case 23: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 52: break;
        case 17: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 53: break;
        case 36: 
          { addToken(Token.FUNCTION);
          }
        case 54: break;
        case 28: 
          { addToken(Token.ANNOTATION);
          }
        case 55: break;
        case 2: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 56: break;
        case 27: 
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 57: break;
        case 13: 
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 58: break;
        case 37: 
          { start = zzMarkedPos-3; yybegin(DART_MULTILINE_STRING_DOUBLE);
          }
        case 59: break;
        case 16: 
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 60: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 61: break;
        case 26: 
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 62: break;
        case 20: 
          { /* Skip escaped chars, handles case: '\"""'. */
          }
        case 63: break;
        case 34: 
          { start = zzMarkedPos-3; yybegin(DART_MULTILINE_STRING_SINGLE);
          }
        case 64: break;
        case 25: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 65: break;
        case 12: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 66: break;
        case 3: 
          { addToken(Token.WHITESPACE);
          }
        case 67: break;
        case 35: 
          { addToken(Token.DATA_TYPE);
          }
        case 68: break;
        case 33: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 69: break;
        case 15: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 70: break;
        case 6: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 71: break;
        case 10: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 72: break;
        case 31: 
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 73: break;
        case 22: 
          { /* Skip escaped chars, handles case: "\'''". */
          }
        case 74: break;
        case 9: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 75: break;
        case 29: 
          { addToken(Token.RESERVED_WORD);
          }
        case 76: break;
        case 42: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 77: break;
        case 44: 
          { addToken(Token.RESERVED_WORD_2);
          }
        case 78: break;
        case 18: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 79: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 80: break;
        case 4: 
          { addNullToken(); return firstToken;
          }
        case 81: break;
        case 7: 
          { addToken(Token.OPERATOR);
          }
        case 82: break;
        case 21: 
          { addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
          }
        case 83: break;
        case 24: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 84: break;
        case 43: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 85: break;
        case 40: 
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 86: break;
        case 1: 
          { 
          }
        case 87: break;
        case 19: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 88: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
            }
            case 617: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
            }
            case 618: break;
            case DART_MULTILINE_STRING_DOUBLE: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 619: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 620: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 621: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 622: break;
            case DART_MULTILINE_STRING_SINGLE: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
            }
            case 623: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
