//rpldnotify.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2014
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLDNOTIFY_H_
#define _RPLDNOTIFY_H_

#define RPLD_NOTIFY_BASE_QUEUE      ((uint32_t)0x01000000)
#define RPLD_NOTIFY_BASE_PLAYBACK   ((uint32_t)0x02000000)

#define RPLD_NOTIFY_QUEUE(x)        ROAR_NOTIFY_USER2EVENT((x) | RPLD_NOTIFY_BASE_QUEUE)
#define RPLD_NOTIFY_PLAYBACK(x)     ROAR_NOTIFY_USER2EVENT((x) | RPLD_NOTIFY_BASE_PLAYBACK)

/* target=$QUEUE_ID */
#define RPLD_NOTIFY_PLAYBACK_STOP   RPLD_NOTIFY_PLAYBACK(0) /* arg0=$OFFSET, arg1=$KICK */
#define RPLD_NOTIFY_PLAYBACK_PLAY   RPLD_NOTIFY_PLAYBACK(1) /* (none) */
#define RPLD_NOTIFY_PLAYBACK_NEXT   RPLD_NOTIFY_PLAYBACK(2) /* (none) */
#define RPLD_NOTIFY_PLAYBACK_PREV   RPLD_NOTIFY_PLAYBACK(3) /* (none) */
#define RPLD_NOTIFY_PLAYBACK_PAUSE  RPLD_NOTIFY_PLAYBACK(4) /* arg0=$HOW */
#define RPLD_NOTIFY_PLAYBACK_VOLUME RPLD_NOTIFY_PLAYBACK(5) /* arg0=(unsigned int)$VOL */
#define RPLD_NOTIFY_PLAYBACK_ROLE   RPLD_NOTIFY_PLAYBACK(6) /* arg0=$ROLE */

#ifdef _XXX_
 int emitter;
 int target;
 int target_type;
 int arg0;
 int arg1;
 void * arg2;

int  playback_add_queue(struct rpld_playlist * pl, const char * backend, int mixer, struct rpld_playlist * history);
int  playback_del_queue(struct rpld_playlist * pl);

int  playback_set_pointer(pli_t queue, int pointer, struct rpld_playlist_pointer * plp);

// start or stop all queues.
void playback_play_all(void);
void playback_stop_all(size_t offset, int kick);
#endif

#endif

//ll
