// Cg shaders, as static data buffers for release mode builds
// DO NOT EDIT - this file is autogenerated - see BUILD.txt
// To regenerate this file, run: premake4 embed

struct cgShaderDef_t
{
	const char* name;
	const char* shaderText;
};

static const cgShaderDef_t cg_renderprogs[] =
{
	{
		"renderprogs/global.inc",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"uniform float4 rpScreenCorrectionFactor	:	register(c0);\n"
		"uniform float4 rpWindowCoord			:	register(c1);\n"
		"uniform float4 rpDiffuseModifier		:	register(c2);\n"
		"uniform float4 rpSpecularModifier		:	register(c3);\n"
		"\n"
		"uniform float4 rpLocalLightOrigin		:	register(c4);\n"
		"uniform float4 rpLocalViewOrigin		:	register(c5);\n"
		"\n"
		"uniform float4 rpLightProjectionS		:	register(c6);\n"
		"uniform float4 rpLightProjectionT		:	register(c7);\n"
		"uniform float4 rpLightProjectionQ		:	register(c8);\n"
		"uniform float4 rpLightFalloffS			:	register(c9);\n"
		"\n"
		"uniform float4 rpBumpMatrixS			:	register(c10);\n"
		"uniform float4 rpBumpMatrixT			:	register(c11);\n"
		"\n"
		"uniform float4 rpDiffuseMatrixS			:	register(c12);\n"
		"uniform float4 rpDiffuseMatrixT			:	register(c13);\n"
		"\n"
		"uniform float4 rpSpecularMatrixS		:	register(c14);\n"
		"uniform float4 rpSpecularMatrixT		:	register(c15);\n"
		"\n"
		"uniform float4 rpVertexColorModulate	:	register(c16);\n"
		"uniform float4 rpVertexColorAdd			:	register(c17);\n"
		"\n"
		"uniform float4 rpColor					:	register(c18);\n"
		"uniform float4 rpViewOrigin				:	register(c19);\n"
		"uniform float4 rpGlobalEyePos			:	register(c20);\n"
		"\n"
		"uniform float4 rpMVPmatrixX				:	register(c21);\n"
		"uniform float4 rpMVPmatrixY				:	register(c22);\n"
		"uniform float4 rpMVPmatrixZ				:	register(c23);\n"
		"uniform float4 rpMVPmatrixW				:	register(c24);\n"
		"\n"
		"uniform float4 rpModelMatrixX			:	register(c25);\n"
		"uniform float4 rpModelMatrixY			:	register(c26);\n"
		"uniform float4 rpModelMatrixZ			:	register(c27);\n"
		"uniform float4 rpModelMatrixW			:	register(c28);\n"
		"\n"
		"uniform float4 rpProjectionMatrixX		:	register(c29);\n"
		"uniform float4 rpProjectionMatrixY		:	register(c30);\n"
		"uniform float4 rpProjectionMatrixZ		:	register(c31);\n"
		"uniform float4 rpProjectionMatrixW		:	register(c32);\n"
		"\n"
		"uniform float4 rpModelViewMatrixX		:	register(c33);\n"
		"uniform float4 rpModelViewMatrixY		:	register(c34);\n"
		"uniform float4 rpModelViewMatrixZ		:	register(c35);\n"
		"uniform float4 rpModelViewMatrixW		:	register(c36);\n"
		"\n"
		"uniform float4 rpTextureMatrixS			:	register(c37);\n"
		"uniform float4 rpTextureMatrixT			:	register(c38);\n"
		"\n"
		"uniform float4 rpTexGen0S				:	register(c39);\n"
		"uniform float4 rpTexGen0T				:	register(c40);\n"
		"uniform float4 rpTexGen0Q				:	register(c41);\n"
		"uniform float4 rpTexGen0Enabled			:	register(c42);\n"
		"\n"
		"uniform float4 rpTexGen1S				:	register(c43);\n"
		"uniform float4 rpTexGen1T				:	register(c44);\n"
		"uniform float4 rpTexGen1Q				:	register(c45);\n"
		"uniform float4 rpTexGen1Enabled			:	register(c46);\n"
		"\n"
		"uniform float4 rpWobbleSkyX				:	register(c47);\n"
		"uniform float4 rpWobbleSkyY				:	register(c48);\n"
		"uniform float4 rpWobbleSkyZ				:	register(c49);\n"
		"\n"
		"uniform float4 rpOverbright				:	register(c50);\n"
		"uniform float4 rpEnableSkinning			:	register(c51);\n"
		"uniform float4 rpAlphaTest				:	register(c52);\n"
		"\n"
		"// RB begin\n"
		"uniform float4 rpAmbientColor			:	register(c53);\n"
		"uniform float4 rpGlobalLightOrigin		:	register(c54);\n"
		"uniform float4 rpJitterTexScale			:	register(c55);\n"
		"uniform float4 rpJitterTexOffset		:	register(c56);\n"
		"uniform float4 rpCascadeDistances		:	register(c57);\n"
		"\n"
		"#if defined( USE_UNIFORM_ARRAYS )\n"
		"uniform float4 rpShadowMatrices			:	register(c58);\n"
		"#else\n"
		"uniform float4 rpShadowMatrices[6*4]	:	register(c59);\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"static float dot2( float2 a, float2 b ) { return dot( a, b ); }\n"
		"static float dot3( float3 a, float3 b ) { return dot( a, b ); }\n"
		"static float dot3( float3 a, float4 b ) { return dot( a, b.xyz ); }\n"
		"static float dot3( float4 a, float3 b ) { return dot( a.xyz, b ); }\n"
		"static float dot3( float4 a, float4 b ) { return dot( a.xyz, b.xyz ); }\n"
		"static float dot4( float4 a, float4 b ) { return dot( a, b ); }\n"
		"static float dot4( float2 a, float4 b ) { return dot( float4( a, 0, 1 ), b ); }\n"
		"\n"
		"// ----------------------\n"
		"// YCoCg Color Conversion\n"
		"// ----------------------\n"
		"static const half4 matrixRGB1toCoCg1YX = half4(  0.50,  0.0, -0.50, 0.50196078 );	// Co\n"
		"static const half4 matrixRGB1toCoCg1YY = half4( -0.25,  0.5, -0.25, 0.50196078 );	// Cg\n"
		"static const half4 matrixRGB1toCoCg1YZ = half4(  0.0,   0.0,  0.0,  1.0 );			// 1.0\n"
		"static const half4 matrixRGB1toCoCg1YW = half4(  0.25,  0.5,  0.25, 0.0 );			// Y\n"
		"\n"
		"static const half4 matrixCoCg1YtoRGB1X = half4(  1.0, -1.0,  0.0,        1.0 );\n"
		"static const half4 matrixCoCg1YtoRGB1Y = half4(  0.0,  1.0, -0.50196078, 1.0 ); // -0.5 * 256.0 / 255.0\n"
		"static const half4 matrixCoCg1YtoRGB1Z = half4( -1.0, -1.0,  1.00392156, 1.0 ); // +1.0 * 256.0 / 255.0\n"
		"\n"
		"static half3 ConvertYCoCgToRGB( half4 YCoCg ) {\n"
		"	half3 rgbColor;\n"
		"\n"
		"	YCoCg.z = ( YCoCg.z * 31.875 ) + 1.0;			//z = z * 255.0/8.0 + 1.0\n"
		"	YCoCg.z = 1.0 / YCoCg.z;\n"
		"	YCoCg.xy *= YCoCg.z;\n"
		"	rgbColor.x = dot4( YCoCg, matrixCoCg1YtoRGB1X );\n"
		"	rgbColor.y = dot4( YCoCg, matrixCoCg1YtoRGB1Y );\n"
		"	rgbColor.z = dot4( YCoCg, matrixCoCg1YtoRGB1Z );\n"
		"	return rgbColor;\n"
		"}\n"
		"\n"
		"static float2 CenterScale( float2 inTC, float2 centerScale ) {\n"
		"	float scaleX = centerScale.x;\n"
		"	float scaleY = centerScale.y;\n"
		"	float4 tc0 = float4( scaleX, 0, 0, 0.5 - ( 0.5f * scaleX ) );\n"
		"	float4 tc1 = float4( 0, scaleY, 0, 0.5 - ( 0.5f * scaleY ) );\n"
		"\n"
		"	float2 finalTC;\n"
		"	finalTC.x = dot4( inTC, tc0 );\n"
		"	finalTC.y = dot4( inTC, tc1 );\n"
		"	return finalTC;\n"
		"}\n"
		"\n"
		"static float2 Rotate2D( float2 inTC, float2 cs ) {\n"
		"	float sinValue = cs.y;\n"
		"	float cosValue = cs.x;\n"
		"\n"
		"	float4 tc0 = float4( cosValue, -sinValue, 0, ( -0.5f * cosValue ) + ( 0.5f * sinValue ) + 0.5f );\n"
		"	float4 tc1 = float4( sinValue, cosValue, 0, ( -0.5f * sinValue ) + ( -0.5f * cosValue ) + 0.5f );\n"
		"\n"
		"	float2 finalTC;\n"
		"	finalTC.x = dot4( inTC, tc0 );\n"
		"	finalTC.y = dot4( inTC, tc1 );\n"
		"	return finalTC;\n"
		"}\n"
		"\n"
		"// better noise function available at https://github.com/ashima/webgl-noise\n"
		"float rand( float2 co ) {\n"
		"    return frac( sin( dot( co.xy, float2( 12.9898, 78.233 ) ) ) * 43758.5453 );\n"
		"}\n"
		"\n"
		"// RB begin\n"
		"#ifndef PI\n"
		"#define PI	3.14159265358979323846\n"
		"#endif\n"
		"\n"
		"#define DEG2RAD( a )				( ( a ) * PI / 180.0f )\n"
		"#define RAD2DEG( a )				( ( a ) * 180.0f / PI )\n"
		"// RB end\n"
		"\n"
		"#define _half2( x )		half2( x )\n"
		"#define _half3( x )		half3( x )\n"
		"#define _half4( x )		half4( x )\n"
		"#define _float2( x )	float2( x )\n"
		"#define _float3( x )	float3( x )\n"
		"#define _float4( x )	float4( x )\n"
		"\n"
		"#define VPOS WPOS\n"
		"static float4 idtex2Dproj( sampler2D samp, float4 texCoords ) { return tex2Dproj( samp, texCoords.xyw ); }\n"
		"static float4 swizzleColor( float4 c ) { return c; }\n"
		"static float2 vposToScreenPosTexCoord( float2 vpos ) { return vpos.xy * rpWindowCoord.xy; }\n"
		"\n"
		"#define BRANCH\n"
		"#define IFANY\n"
		"\n"
		
	},
	
	{
		"renderprogs/skinning.inc",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"float4 modelPosition = vertex.position;\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"BRANCH if ( rpEnableSkinning.x > 0.0 ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"}\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		
	},
	
	{
		"renderprogs/bink.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); // Y\n"
		"uniform sampler2D samp1 : register(s1); // Cr\n"
		"uniform sampler2D samp2 : register(s2); // Cb\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	const float3 crc = float3( 1.595794678, -0.813476563, 0 );\n"
		"	const float3 crb = float3( 0, -0.391448975, 2.017822266 );\n"
		"	const float3 adj = float3( -0.87065506, 0.529705048f, -1.081668854f );\n"
		"	const float3 YScalar = float3( 1.164123535f, 1.164123535f, 1.164123535f );\n"
		"\n"
		"	float Y = tex2D( samp0, fragment.texcoord0.xy ).x;\n"
		"	float Cr = tex2D( samp1, fragment.texcoord0.xy ).x;\n"
		"	float Cb = tex2D( samp2, fragment.texcoord0.xy ).x;\n"
		"\n"
		"	float3 p = ( YScalar * Y );\n"
		"	p += ( crc * Cr ) + ( crb * Cb ) + adj;\n"
		"\n"
		"	result.color.xyz = p;\n"
		"	result.color.w = 1.0;\n"
		"	result.color *= rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bink.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bink_gui.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); // Y\n"
		"uniform sampler2D samp1 : register(s1); // Cr\n"
		"uniform sampler2D samp2 : register(s2); // Cb\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 texcoord1 : TEXCOORD1_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	const float3 crc = float3( 1.595794678, -0.813476563, 0 );\n"
		"	const float3 crb = float3( 0, -0.391448975, 2.017822266 );\n"
		"	const float3 adj = float3( -0.87065506, 0.529705048f, -1.081668854f );\n"
		"	const float3 YScalar = float3( 1.164123535f, 1.164123535f, 1.164123535f );\n"
		"\n"
		"	float Y = tex2D( samp0, fragment.texcoord0.xy ).x;\n"
		"	float Cr = tex2D( samp1, fragment.texcoord0.xy ).x;\n"
		"	float Cb = tex2D( samp2, fragment.texcoord0.xy ).x;\n"
		"\n"
		"	float3 p = ( YScalar * Y );\n"
		"	p += ( crc * Cr ) + ( crb * Cb ) + adj;\n"
		"\n"
		"	float4 binkImage;\n"
		"	binkImage.xyz = p;\n"
		"	binkImage.w = 1.0;\n"
		"\n"
		"	float4 color = ( binkImage * fragment.color ) + fragment.texcoord1;\n"
		"	result.color.xyz = color.xyz * color.w;\n"
		"	result.color.w = color.w;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bink_gui.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 texcoord1 : TEXCOORD1;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.xy = vertex.texcoord.xy;\n"
		"	result.texcoord1 = ( swizzleColor( vertex.color2 ) * 2.0 ) - 1.0;\n"
		"	result.color =  swizzleColor( vertex.color );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/blendLight.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float4 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = idtex2Dproj( samp0, fragment.texcoord0 ) * tex2D( samp1, fragment.texcoord1 ) * rpColor;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/blendLight.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 binormal : BINORMAL;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"	result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	result.texcoord0.z = 0.0;\n"
		"	result.texcoord0.w = dot4( vertex.position, rpTexGen0Q );\n"
		"\n"
		"	result.texcoord1.x = dot4( vertex.position, rpTexGen1S );\n"
		"	result.texcoord1.y = 0.5;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/bloodorb1_capture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 accumSample = tex2D( samp0, fragment.texcoord0 );\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord1 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord1 );\n"
		"\n"
		"	result.color = lerp( accumSample, currentRenderSample, maskSample.a );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb1_capture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 ); //rpCenterScale\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	//center scale\n"
		"	const float4 centerScale = rpUser0;\n"
		"	result.texcoord0 = CenterScale( vertex.texcoord, centerScale.xy );\n"
		"\n"
		"	// pass through texcoords	\n"
		"	result.texcoord1 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb2_capture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"	float2 texcoord2 : TEXCOORD2_centroid;\n"
		"	//float4 color	 : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 redTint = float4( 1, 0.98, 0.98, 1 );\n"
		"	float4 accumSample = tex2D( samp0, fragment.texcoord0 ) * redTint;\n"
		"\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord1 );\n"
		"\n"
		"	float4 tint = float4( 1.0, 0.8, 0.8, 1 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord2 ) * tint;\n"
		"\n"
		"	result.color = lerp( accumSample, currentRenderSample, maskSample.a );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb2_capture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 ); //rpCenterScaleTex0\n"
		"uniform float4 rpUser1 : register( c129 ); //rpRotateTex0\n"
		"uniform float4 rpUser2 : register( c130 ); //rpCenterScaleTex1\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"	float2 texcoord2 : TEXCOORD2;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	const float4 centerScaleTex0 = rpUser0;\n"
		"	const float4 rotateTex0 = rpUser1;\n"
		"	const float4 centerScaleTex1 = rpUser2;\n"
		"\n"
		"	//center scale and rotate for _accum\n"
		"	float2 tc0 = CenterScale( vertex.texcoord, centerScaleTex0.xy );\n"
		"	result.texcoord0 = Rotate2D( tc0, rotateTex0.xy );\n"
		"\n"
		"	//center scale for mask\n"
		"	result.texcoord1 = CenterScale( vertex.texcoord, centerScaleTex1.xy );\n"
		"\n"
		"	// pass through for currentrender\n"
		"	result.texcoord2 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb3_capture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"	float2 texcoord2 : TEXCOORD2_centroid;\n"
		"	float2 texcoord3 : TEXCOORD3_centroid;\n"
		"	float2 texcoord4 : TEXCOORD4;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float colorFactor = fragment.texcoord4.x;\n"
		"\n"
		"	float4 color0 = float4( 1.0f - colorFactor,	1.0f - colorFactor,		1.0f,	1.0f );\n"
		"	float4 color1 = float4( 1.0f,	0.95f - colorFactor,		0.95f,	0.5f );\n"
		"	float4 color2 = float4( 0.015f,	0.015f, 0.015f, 0.01f );\n"
		"\n"
		"	float4 accumSample0 = tex2D( samp0, fragment.texcoord0 ) * color0;\n"
		"	float4 accumSample1 = tex2D( samp0, fragment.texcoord1 ) * color1;\n"
		"	float4 accumSample2 = tex2D( samp0, fragment.texcoord2 ) * color2;\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord3 );\n"
		"\n"
		"	float4 tint = float4( 0.8, 0.5, 0.5, 1 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord3 ) * tint;\n"
		"\n"
		"	// blend of the first 2 accumulation samples\n"
		"	float4 accumColor = lerp( accumSample0, accumSample1, 0.5f );\n"
		"	// add thrid sample\n"
		"	accumColor += accumSample2;\n"
		"\n"
		"	accumColor = lerp( accumColor, currentRenderSample, maskSample.a );\n"
		"	result.color = accumColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb3_capture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 ); //rpCenterScaleTex\n"
		"uniform float4 rpUser1 : register( c129 ); //rpRotateTex\n"
		"uniform float4 rpUser2 : register( c130 ); //rpColorFactor\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"	float2 texcoord2 : TEXCOORD2;\n"
		"	float2 texcoord3 : TEXCOORD3;\n"
		"	float2 texcoord4 : TEXCOORD4;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	//_accum 1\n"
		"	const float4 centerScaleTex = rpUser0;\n"
		"	const float4 rotateTex = rpUser1;\n"
		"	float2 tc0 = CenterScale( vertex.texcoord, centerScaleTex.xy );\n"
		"	result.texcoord0 = Rotate2D( tc0, rotateTex.xy );\n"
		"\n"
		"	// accum 2\n"
		"	result.texcoord1 = Rotate2D( tc0, float2( rotateTex.z, -rotateTex.w ) );\n"
		"\n"
		"	// accum 3\n"
		"	result.texcoord2 = Rotate2D( tc0, rotateTex.zw );\n"
		"\n"
		"	// pass through for currentrender\n"
		"	result.texcoord3 = vertex.texcoord;\n"
		"\n"
		"	// pass through the color fator\n"
		"	const float4 colorFactor = rpUser2;\n"
		"	result.texcoord4 = colorFactor.xx;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb_draw.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0); //_accum\n"
		"uniform sampler2D samp1 : register(s1); //_currentRender\n"
		"uniform sampler2D samp2 : register(s2); //mask\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 accumSample = tex2D( samp0, fragment.texcoord0 );\n"
		"	float4 currentRenderSample = tex2D( samp1, fragment.texcoord0 );\n"
		"	float4 maskSample = tex2D( samp2, fragment.texcoord0 );\n"
		"\n"
		"	result.color = lerp( accumSample, currentRenderSample, maskSample.a );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bloodorb_draw.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// pass through texcoords\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"uniform sampler2D	samp1 : register(s1); // normal map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float2 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float3 texcoord2	: TEXCOORD2_centroid;\n"
		"	float3 texcoord3	: TEXCOORD3_centroid;\n"
		"	float3 texcoord4	: TEXCOORD4_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 bump = tex2D( samp1, fragment.texcoord0 ) * 2.0f - 1.0f;\n"
		"	// RB begin\n"
		"	float3 localNormal;\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal = float3( bump.rg, 0.0f );\n"
		"#else\n"
		"	localNormal = float3( bump.wy, 0.0f );\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( 1.0f - dot3( localNormal, localNormal ) );\n"
		"\n"
		"	float3 globalNormal;\n"
		"	globalNormal.x = dot3( localNormal, fragment.texcoord2 );\n"
		"	globalNormal.y = dot3( localNormal, fragment.texcoord3 );\n"
		"	globalNormal.z = dot3( localNormal, fragment.texcoord4 );\n"
		"\n"
		"	float3 globalEye = normalize( fragment.texcoord1 );\n"
		"\n"
		"	float3 reflectionVector = globalNormal * dot3( globalEye, globalNormal );\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( envMap.xyz, 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float2 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float3 texcoord2	: TEXCOORD2;\n"
		"	float3 texcoord3	: TEXCOORD3;\n"
		"	float3 texcoord4	: TEXCOORD4;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 normal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 tangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 binormal = cross( normal.xyz, tangent.xyz ) * tangent.w;\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord.xy;\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - vertex.position;\n"
		"	result.texcoord1.x = dot3( toEye, rpModelMatrixX );\n"
		"	result.texcoord1.y = dot3( toEye, rpModelMatrixY );\n"
		"	result.texcoord1.z = dot3( toEye, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.x = dot3( tangent, rpModelMatrixX );\n"
		"	result.texcoord3.x = dot3( tangent, rpModelMatrixY );\n"
		"	result.texcoord4.x = dot3( tangent, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.y = dot3( binormal, rpModelMatrixX );\n"
		"	result.texcoord3.y = dot3( binormal, rpModelMatrixY );\n"
		"	result.texcoord4.y = dot3( binormal, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.z = dot3( normal, rpModelMatrixX );\n"
		"	result.texcoord3.z = dot3( normal, rpModelMatrixY );\n"
		"	result.texcoord4.z = dot3( normal, rpModelMatrixZ );\n"
		"\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"uniform sampler2D	samp1 : register(s1); // normal map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float2 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float3 texcoord2	: TEXCOORD2_centroid;\n"
		"	float3 texcoord3	: TEXCOORD3_centroid;\n"
		"	float3 texcoord4	: TEXCOORD4_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float4 bump = tex2D( samp1, fragment.texcoord0 ) * 2.0f - 1.0f;\n"
		"	\n"
		"	// RB begin\n"
		"	float3 localNormal;\n"
		"#if defined(GLES2)\n"
		"	localNormal = float3( bump.rg, 0.0f );\n"
		"#else\n"
		"	localNormal = float3( bump.wy, 0.0f );\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( 1.0f - dot3( localNormal, localNormal ) );\n"
		"\n"
		"	float3 globalNormal;\n"
		"	globalNormal.x = dot3( localNormal, fragment.texcoord2 );\n"
		"	globalNormal.y = dot3( localNormal, fragment.texcoord3 );\n"
		"	globalNormal.z = dot3( localNormal, fragment.texcoord4 );\n"
		"\n"
		"	float3 globalEye = normalize( fragment.texcoord1 );\n"
		"\n"
		"	float3 reflectionVector = globalNormal * dot3( globalEye, globalNormal );\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( envMap.xyz, 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/bumpyenvironment_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float2 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float3 texcoord2	: TEXCOORD2;\n"
		"	float3 texcoord3	: TEXCOORD3;\n"
		"	float3 texcoord4	: TEXCOORD4;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBinormal = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 binormal;\n"
		"	binormal.x = dot3( matX, vBinormal );\n"
		"	binormal.y = dot3( matY, vBinormal );\n"
		"	binormal.z = dot3( matZ, vBinormal );\n"
		"	binormal = normalize( binormal );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord.xy;\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - modelPosition;\n"
		"	result.texcoord1.x = dot3( toEye, rpModelMatrixX );\n"
		"	result.texcoord1.y = dot3( toEye, rpModelMatrixY );\n"
		"	result.texcoord1.z = dot3( toEye, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.x = dot3( tangent, rpModelMatrixX );\n"
		"	result.texcoord3.x = dot3( tangent, rpModelMatrixY );\n"
		"	result.texcoord4.x = dot3( tangent, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.y = dot3( binormal, rpModelMatrixX );\n"
		"	result.texcoord3.y = dot3( binormal, rpModelMatrixY );\n"
		"	result.texcoord4.y = dot3( binormal, rpModelMatrixZ );\n"
		"\n"
		"	result.texcoord2.z = dot3( normal, rpModelMatrixX );\n"
		"	result.texcoord3.z = dot3( normal, rpModelMatrixY );\n"
		"	result.texcoord4.z = dot3( normal, rpModelMatrixZ );\n"
		"\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/color.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/color.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the position\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"#else\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/colorProcess.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 color		: COLOR;\n"
		"	float3 texcoord0	: TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 src = tex2D( samp0, fragment.texcoord0.xy );\n"
		"	float4 target = fragment.color * dot3( float3( 0.333, 0.333, 0.333 ), src );\n"
		"	result.color = lerp( src, target, fragment.texcoord0.z );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/colorProcess.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); //rpFraction\n"
		"uniform float4 rpUser1 : register(c129); //rpTargetHue\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 color 		: COLOR0;\n"
		"	float3 texcoord0	: TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	\n"
		"	result.color = rpUser1; // targetHue\n"
		"	\n"
		"	result.texcoord0.x = vertex.texcoord.x;\n"
		"	result.texcoord0.y = 1.0f - vertex.texcoord.y;\n"
		"\n"
		"	result.texcoord0.z = rpUser0.x; // fraction\n"
		"}\n"
		"\n"
		"\n"
		
	},
	
	{
		"renderprogs/debug_shadowmap.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2DArray samp0 : register(s0);\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	float3 tc;\n"
		"	tc.xy = fragment.texcoord0.xy;\n"
		"	tc.z = rpScreenCorrectionFactor.x; // layer\n"
		"\n"
		"	result.color = texture( samp0, tc );// * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/debug_shadowmap.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = float4( 0.0, 0.0, 0.0, 1.0 );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = float4( 0.0, 0.0, 0.0, 1.0 );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/depth_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/environment.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float3 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float3 globalNormal = normalize( fragment.texcoord1 );\n"
		"	float3 globalEye = normalize( fragment.texcoord0 );\n"
		"\n"
		"	float3 reflectionVector = _float3( dot3( globalEye, globalNormal ) );\n"
		"	reflectionVector *= globalNormal;\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( envMap.xyz, 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/environment.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float3 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - vertex.position;\n"
		"\n"
		"	result.texcoord0 = toEye.xyz;\n"
		"	result.texcoord1 = vNormal.xyz;\n"
		"\n"
		"	result.color = rpColor;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/environment_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE	samp0 : register(s0); // texture 0 is the cube map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float3 texcoord0	: TEXCOORD0_centroid;\n"
		"	float3 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float3 globalNormal = normalize( fragment.texcoord1 );\n"
		"	float3 globalEye = normalize( fragment.texcoord0 );\n"
		"\n"
		"	float3 reflectionVector = _float3( dot3( globalEye, globalNormal ) );\n"
		"	reflectionVector *= globalNormal;\n"
		"	reflectionVector = ( reflectionVector * 2.0f ) - globalEye;\n"
		"\n"
		"	float4 envMap = texCUBE( samp0, reflectionVector );\n"
		"\n"
		"	result.color = float4( envMap.xyz, 1.0f ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/environment_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float3 texcoord0	: TEXCOORD0;\n"
		"	float3 texcoord1	: TEXCOORD1;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 vNormalSkinned;\n"
		"	vNormalSkinned.x = dot3( matX, vNormal );\n"
		"	vNormalSkinned.y = dot3( matY, vNormal );\n"
		"	vNormalSkinned.z = dot3( matZ, vNormal );\n"
		"	vNormalSkinned = normalize( vNormalSkinned );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 toEye = rpLocalViewOrigin - modelPosition;\n"
		"\n"
		"	result.texcoord0 = toEye.xyz;\n"
		"	result.texcoord1 = vNormalSkinned.xyz;\n"
		"\n"
		"	result.color = rpColor;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/enviroSuit.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float2 texcoord		: TEXCOORD0_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	float2 screenTexCoord = fragment.texcoord;\n"
		"	\n"
		"	// compute warp factor\n"
		"	float4 warpFactor = 1.0 - ( tex2D( samp1, screenTexCoord.xy ) * fragment.color );\n"
		"	screenTexCoord -= float2( 0.5, 0.5 );\n"
		"	screenTexCoord *= warpFactor.xy;\n"
		"	screenTexCoord += float2( 0.5, 0.5 );\n"
		"\n"
		"	// load the screen render\n"
		"	result.color = tex2D( samp0, screenTexCoord );\n"
		"\n"
		"}\n"
		
	},
	
	{
		"renderprogs/enviroSuit.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// User Renderparms start at 128 as per renderprogs.h\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float2 texcoord		: TEXCOORD0;\n"
		"	float4 color		: COLOR;\n"
		"};\n"
		"\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	\n"
		"	result.texcoord = vertex.texcoord.xy;\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.color = deformMagnitude;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/fog.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = tex2D( samp0, fragment.texcoord0 ) * tex2D( samp1, fragment.texcoord1 ) * rpColor;\n"
		"}\n"
		"\n"
		"\n"
		
	},
	
	{
		"renderprogs/fog.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"	result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"\n"
		"	result.texcoord1.x = dot4( vertex.position, rpTexGen1S );\n"
		"	result.texcoord1.y = dot4( vertex.position, rpTexGen1T );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/fog_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float2 texcoord1 : TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = tex2D( samp0, fragment.texcoord0 ) * tex2D( samp1, fragment.texcoord1 ) * rpColor;\n"
		"}\n"
		"\n"
		"\n"
		
	},
	
	{
		"renderprogs/fog_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float2 texcoord1 : TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"	// end of skinning\n"
		"\n"
		"	// start of fog portion\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.x = dot4( modelPosition, rpTexGen0S );\n"
		"	result.texcoord0.y = dot4( modelPosition, rpTexGen0T );\n"
		"\n"
		"	result.texcoord1.x = dot4( modelPosition, rpTexGen1S );\n"
		"	result.texcoord1.y = dot4( modelPosition, rpTexGen1T );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/fxaa.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"#define FXAA_GREEN_AS_LUMA 1\n"
		"#define FXAA_EARLY_EXIT 0\n"
		"#include \"Fxaa3_11.h\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1); // exponent bias -1\n"
		"uniform sampler2D samp2 : register(s2); // exponent bias -2\n"
		"\n"
		"uniform float4 rpUser0 : register( c128 );\n"
		"uniform float4 rpUser1 : register( c129 );\n"
		"uniform float4 rpUser2 : register( c130 );\n"
		"uniform float4 rpUser3 : register( c131 );\n"
		"uniform float4 rpUser4 : register( c132 );\n"
		"uniform float4 rpUser5 : register( c133 );\n"
		"uniform float4 rpUser6 : register( c134 );\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {	\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	const float4 FXAAQualityRCPFrame = rpUser0;\n"
		"	const float4 FXAAConsoleRcpFrameOpt = rpUser1;\n"
		"	const float4 FXAAConsoleRcpFrameOpt2 = rpUser2;\n"
		"	const float4 FXAAConsole360RcpFrameOpt2 = rpUser3;\n"
		"	const float4 FXAAQualityParms = rpUser4;\n"
		"	const float4 FXAAConsoleEdgeParms = rpUser5;\n"
		"	const float4 FXAAConsole360ConstDir = rpUser6;\n"
		"\n"
		"	// Inputs - see more info in fxaa3_11.hfile\n"
		"	FxaaFloat2	fxaaPos = fragment.texcoord0;\n"
		"	FxaaFloat4	fxaaConsolePos;\n"
		"\n"
		"	float2 halfPixelOffset = float2( 0.5, 0.5 ) * FXAAQualityRCPFrame.xy;\n"
		"	fxaaConsolePos.xy = fxaaPos.xy - ( halfPixelOffset );\n"
		"	fxaaConsolePos.zw = fxaaPos.xy + ( halfPixelOffset );\n"
		"	FxaaFloat2	fxaaQualityRcpFrame = FXAAQualityRCPFrame.xy;\n"
		"	FxaaFloat4	fxaaConsoleRcpFrameOpt = FXAAConsoleRcpFrameOpt;\n"
		"	FxaaFloat4	fxaaConsoleRcpFrameOpt2 = FXAAConsoleRcpFrameOpt2;\n"
		"	FxaaFloat4	fxaaConsole360RcpFrameOpt2 = FXAAConsole360RcpFrameOpt2;\n"
		"\n"
		"	// Quality parms\n"
		"	FxaaFloat	fxaaQualitySubpix = FXAAQualityParms.x;\n"
		"	FxaaFloat	fxaaQualityEdgeThreshold = FXAAQualityParms.y;\n"
		"	FxaaFloat	fxaaQualityEdgeThresholdMin = FXAAQualityParms.z;\n"
		"\n"
		"	// Console specific Parms\n"
		"	FxaaFloat	fxaaConsoleEdgeSharpness = FXAAConsoleEdgeParms.x;\n"
		"	FxaaFloat	fxaaConsoleEdgeThreshold = FXAAConsoleEdgeParms.y;\n"
		"	FxaaFloat	fxaaConsoleEdgeThresholdMin = FXAAConsoleEdgeParms.z;\n"
		"\n"
		"	// 360 specific parms these have to come from a constant register so that the compiler\n"
		"	// does not unoptimize the shader\n"
		"	FxaaFloat4	fxaaConsole360ConstDir = FXAAConsole360ConstDir;\n"
		"\n"
		"\n"
		"	float4 colorSample = FxaaPixelShader(	fxaaPos,\n"
		"											fxaaConsolePos,\n"
		"											samp0,\n"
		"											samp1,\n"
		"											samp2,\n"
		"											fxaaQualityRcpFrame,\n"
		"											fxaaConsoleRcpFrameOpt,\n"
		"											fxaaConsoleRcpFrameOpt2,\n"
		"											fxaaConsole360RcpFrameOpt2,\n"
		"											fxaaQualitySubpix,\n"
		"											fxaaQualityEdgeThreshold,\n"
		"											fxaaQualityEdgeThresholdMin,\n"
		"											fxaaConsoleEdgeSharpness,\n"
		"											fxaaConsoleEdgeThreshold,\n"
		"											fxaaConsoleEdgeThresholdMin,\n"
		"											fxaaConsole360ConstDir );\n"
		"											\n"
		"	result.color = colorSample;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/fxaa.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/global.inc",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"uniform float4 rpScreenCorrectionFactor	:	register(c0);\n"
		"uniform float4 rpWindowCoord			:	register(c1);\n"
		"uniform float4 rpDiffuseModifier		:	register(c2);\n"
		"uniform float4 rpSpecularModifier		:	register(c3);\n"
		"\n"
		"uniform float4 rpLocalLightOrigin		:	register(c4);\n"
		"uniform float4 rpLocalViewOrigin		:	register(c5);\n"
		"\n"
		"uniform float4 rpLightProjectionS		:	register(c6);\n"
		"uniform float4 rpLightProjectionT		:	register(c7);\n"
		"uniform float4 rpLightProjectionQ		:	register(c8);\n"
		"uniform float4 rpLightFalloffS			:	register(c9);\n"
		"\n"
		"uniform float4 rpBumpMatrixS			:	register(c10);\n"
		"uniform float4 rpBumpMatrixT			:	register(c11);\n"
		"\n"
		"uniform float4 rpDiffuseMatrixS			:	register(c12);\n"
		"uniform float4 rpDiffuseMatrixT			:	register(c13);\n"
		"\n"
		"uniform float4 rpSpecularMatrixS		:	register(c14);\n"
		"uniform float4 rpSpecularMatrixT		:	register(c15);\n"
		"\n"
		"uniform float4 rpVertexColorModulate	:	register(c16);\n"
		"uniform float4 rpVertexColorAdd			:	register(c17);\n"
		"\n"
		"uniform float4 rpColor					:	register(c18);\n"
		"uniform float4 rpViewOrigin				:	register(c19);\n"
		"uniform float4 rpGlobalEyePos			:	register(c20);\n"
		"\n"
		"uniform float4 rpMVPmatrixX				:	register(c21);\n"
		"uniform float4 rpMVPmatrixY				:	register(c22);\n"
		"uniform float4 rpMVPmatrixZ				:	register(c23);\n"
		"uniform float4 rpMVPmatrixW				:	register(c24);\n"
		"\n"
		"uniform float4 rpModelMatrixX			:	register(c25);\n"
		"uniform float4 rpModelMatrixY			:	register(c26);\n"
		"uniform float4 rpModelMatrixZ			:	register(c27);\n"
		"uniform float4 rpModelMatrixW			:	register(c28);\n"
		"\n"
		"uniform float4 rpProjectionMatrixX		:	register(c29);\n"
		"uniform float4 rpProjectionMatrixY		:	register(c30);\n"
		"uniform float4 rpProjectionMatrixZ		:	register(c31);\n"
		"uniform float4 rpProjectionMatrixW		:	register(c32);\n"
		"\n"
		"uniform float4 rpModelViewMatrixX		:	register(c33);\n"
		"uniform float4 rpModelViewMatrixY		:	register(c34);\n"
		"uniform float4 rpModelViewMatrixZ		:	register(c35);\n"
		"uniform float4 rpModelViewMatrixW		:	register(c36);\n"
		"\n"
		"uniform float4 rpTextureMatrixS			:	register(c37);\n"
		"uniform float4 rpTextureMatrixT			:	register(c38);\n"
		"\n"
		"uniform float4 rpTexGen0S				:	register(c39);\n"
		"uniform float4 rpTexGen0T				:	register(c40);\n"
		"uniform float4 rpTexGen0Q				:	register(c41);\n"
		"uniform float4 rpTexGen0Enabled			:	register(c42);\n"
		"\n"
		"uniform float4 rpTexGen1S				:	register(c43);\n"
		"uniform float4 rpTexGen1T				:	register(c44);\n"
		"uniform float4 rpTexGen1Q				:	register(c45);\n"
		"uniform float4 rpTexGen1Enabled			:	register(c46);\n"
		"\n"
		"uniform float4 rpWobbleSkyX				:	register(c47);\n"
		"uniform float4 rpWobbleSkyY				:	register(c48);\n"
		"uniform float4 rpWobbleSkyZ				:	register(c49);\n"
		"\n"
		"uniform float4 rpOverbright				:	register(c50);\n"
		"uniform float4 rpEnableSkinning			:	register(c51);\n"
		"uniform float4 rpAlphaTest				:	register(c52);\n"
		"\n"
		"// RB begin\n"
		"uniform float4 rpAmbientColor			:	register(c53);\n"
		"uniform float4 rpGlobalLightOrigin		:	register(c54);\n"
		"uniform float4 rpJitterTexScale			:	register(c55);\n"
		"uniform float4 rpJitterTexOffset		:	register(c56);\n"
		"uniform float4 rpCascadeDistances		:	register(c57);\n"
		"\n"
		"#if defined( USE_UNIFORM_ARRAYS )\n"
		"uniform float4 rpShadowMatrices			:	register(c58);\n"
		"#else\n"
		"uniform float4 rpShadowMatrices[6*4]	:	register(c59);\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"static float dot2( float2 a, float2 b ) { return dot( a, b ); }\n"
		"static float dot3( float3 a, float3 b ) { return dot( a, b ); }\n"
		"static float dot3( float3 a, float4 b ) { return dot( a, b.xyz ); }\n"
		"static float dot3( float4 a, float3 b ) { return dot( a.xyz, b ); }\n"
		"static float dot3( float4 a, float4 b ) { return dot( a.xyz, b.xyz ); }\n"
		"static float dot4( float4 a, float4 b ) { return dot( a, b ); }\n"
		"static float dot4( float2 a, float4 b ) { return dot( float4( a, 0, 1 ), b ); }\n"
		"\n"
		"// ----------------------\n"
		"// YCoCg Color Conversion\n"
		"// ----------------------\n"
		"static const half4 matrixRGB1toCoCg1YX = half4(  0.50,  0.0, -0.50, 0.50196078 );	// Co\n"
		"static const half4 matrixRGB1toCoCg1YY = half4( -0.25,  0.5, -0.25, 0.50196078 );	// Cg\n"
		"static const half4 matrixRGB1toCoCg1YZ = half4(  0.0,   0.0,  0.0,  1.0 );			// 1.0\n"
		"static const half4 matrixRGB1toCoCg1YW = half4(  0.25,  0.5,  0.25, 0.0 );			// Y\n"
		"\n"
		"static const half4 matrixCoCg1YtoRGB1X = half4(  1.0, -1.0,  0.0,        1.0 );\n"
		"static const half4 matrixCoCg1YtoRGB1Y = half4(  0.0,  1.0, -0.50196078, 1.0 ); // -0.5 * 256.0 / 255.0\n"
		"static const half4 matrixCoCg1YtoRGB1Z = half4( -1.0, -1.0,  1.00392156, 1.0 ); // +1.0 * 256.0 / 255.0\n"
		"\n"
		"static half3 ConvertYCoCgToRGB( half4 YCoCg ) {\n"
		"	half3 rgbColor;\n"
		"\n"
		"	YCoCg.z = ( YCoCg.z * 31.875 ) + 1.0;			//z = z * 255.0/8.0 + 1.0\n"
		"	YCoCg.z = 1.0 / YCoCg.z;\n"
		"	YCoCg.xy *= YCoCg.z;\n"
		"	rgbColor.x = dot4( YCoCg, matrixCoCg1YtoRGB1X );\n"
		"	rgbColor.y = dot4( YCoCg, matrixCoCg1YtoRGB1Y );\n"
		"	rgbColor.z = dot4( YCoCg, matrixCoCg1YtoRGB1Z );\n"
		"	return rgbColor;\n"
		"}\n"
		"\n"
		"static float2 CenterScale( float2 inTC, float2 centerScale ) {\n"
		"	float scaleX = centerScale.x;\n"
		"	float scaleY = centerScale.y;\n"
		"	float4 tc0 = float4( scaleX, 0, 0, 0.5 - ( 0.5f * scaleX ) );\n"
		"	float4 tc1 = float4( 0, scaleY, 0, 0.5 - ( 0.5f * scaleY ) );\n"
		"\n"
		"	float2 finalTC;\n"
		"	finalTC.x = dot4( inTC, tc0 );\n"
		"	finalTC.y = dot4( inTC, tc1 );\n"
		"	return finalTC;\n"
		"}\n"
		"\n"
		"static float2 Rotate2D( float2 inTC, float2 cs ) {\n"
		"	float sinValue = cs.y;\n"
		"	float cosValue = cs.x;\n"
		"\n"
		"	float4 tc0 = float4( cosValue, -sinValue, 0, ( -0.5f * cosValue ) + ( 0.5f * sinValue ) + 0.5f );\n"
		"	float4 tc1 = float4( sinValue, cosValue, 0, ( -0.5f * sinValue ) + ( -0.5f * cosValue ) + 0.5f );\n"
		"\n"
		"	float2 finalTC;\n"
		"	finalTC.x = dot4( inTC, tc0 );\n"
		"	finalTC.y = dot4( inTC, tc1 );\n"
		"	return finalTC;\n"
		"}\n"
		"\n"
		"// better noise function available at https://github.com/ashima/webgl-noise\n"
		"float rand( float2 co ) {\n"
		"    return frac( sin( dot( co.xy, float2( 12.9898, 78.233 ) ) ) * 43758.5453 );\n"
		"}\n"
		"\n"
		"// RB begin\n"
		"#ifndef PI\n"
		"#define PI	3.14159265358979323846\n"
		"#endif\n"
		"\n"
		"#define DEG2RAD( a )				( ( a ) * PI / 180.0f )\n"
		"#define RAD2DEG( a )				( ( a ) * 180.0f / PI )\n"
		"// RB end\n"
		"\n"
		"#define _half2( x )		half2( x )\n"
		"#define _half3( x )		half3( x )\n"
		"#define _half4( x )		half4( x )\n"
		"#define _float2( x )	float2( x )\n"
		"#define _float3( x )	float3( x )\n"
		"#define _float4( x )	float4( x )\n"
		"\n"
		"#define VPOS WPOS\n"
		"static float4 idtex2Dproj( sampler2D samp, float4 texCoords ) { return tex2Dproj( samp, texCoords.xyw ); }\n"
		"static float4 swizzleColor( float4 c ) { return c; }\n"
		"static float2 vposToScreenPosTexCoord( float2 vpos ) { return vpos.xy * rpWindowCoord.xy; }\n"
		"\n"
		"#define BRANCH\n"
		"#define IFANY\n"
		"\n"
		
	},
	
	{
		"renderprogs/gui.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 texcoord1 : TEXCOORD1_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 color = ( tex2D( samp0, fragment.texcoord0 ) * fragment.color ) + fragment.texcoord1;\n"
		"	result.color.xyz = color.xyz * color.w;\n"
		"	result.color.w = color.w;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/gui.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 texcoord1 : TEXCOORD1;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0.xy = vertex.texcoord.xy;\n"
		"	result.texcoord1 = ( swizzleColor( vertex.color2 ) * 2.0 ) - 1.0;\n"
		"	result.color =  swizzleColor( vertex.color );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/heathaze.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2013-2014 Robert Beckebans \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"	float4 texcoord1	: TEXCOORD1_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// load the filtered normal map and convert to -1 to 1 range\n"
		"	float4 bumpMap = ( tex2D( samp1, fragment.texcoord0.xy ) * 2.0f ) - 1.0f;\n"
		"	float2 localNormal = bumpMap.wy;\n"
		"\n"
		"	// calculate the screen texcoord in the 0.0 to 1.0 range\n"
		"	float2 screenTexCoord = vposToScreenPosTexCoord( fragment.position.xy );\n"
		"	screenTexCoord += ( localNormal * fragment.texcoord1.xy );\n"
		"	screenTexCoord = saturate( screenTexCoord );\n"
		"\n"
		"	// load the screen render\n"
		"	result.color = tex2D( samp0, screenTexCoord.xy );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heathaze.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// User Renderparms start at 128 as per renderprogs.h\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	#include \"skinning.inc\"\n"
		"\n"
		"	//texture 0 takes the texture coordinates and adds a scroll\n"
		"	const float4 textureScroll = rpUser0;\n"
		"	result.texcoord0 = float4( vertex.texcoord.xy, 0, 0 ) + textureScroll;\n"
		"\n"
		"	//texture 1 takes the deform magnitude and scales it by the projection distance\n"
		"	float4	vec = float4( 0, 1, 0, 1 );\n"
		"	vec.z = dot4( modelPosition, rpModelViewMatrixZ ); // this is the modelview matrix\n"
		"\n"
		"	// magicProjectionAdjust is a magic scalar that scales the projection since we changed from \n"
		"	// using the X axis to the Y axis to calculate x.  It is an approximation to closely match \n"
		"	// what the original game did\n"
		"	const float magicProjectionAdjust = 0.43f;\n"
		"	float x = dot4( vec, rpProjectionMatrixY ) * magicProjectionAdjust;\n"
		"	float w = dot4( vec, rpProjectionMatrixW );\n"
		"\n"
		"	//don't let the recip get near zero for polygons that cross the view plane\n"
		"	w = max( w, 1.0 );\n"
		"	x /= w;\n"
		"	//x = x * ( 1.0f / w );\n"
		"\n"
		"	// clamp the distance so the the deformations don't get too wacky near the view\n"
		"	x = min( x, 0.02 );\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.texcoord1 = x * deformMagnitude;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMask.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp2 : register(s2); // texture 2 is the mask texture\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"	float4 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 texcoord2	: TEXCOORD2_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// load the distortion map\n"
		"	float4 mask = tex2D( samp2, fragment.texcoord0.xy );\n"
		"\n"
		"	// kill the pixel if the distortion wound up being very small\n"
		"	mask.xy -= 0.01f;\n"
		"	clip( mask );\n"
		"\n"
		"	// load the filtered normal map and convert to -1 to 1 range\n"
		"	float4 bumpMap = ( tex2D( samp1, fragment.texcoord1.xy ) * 2.0f ) - 1.0f;\n"
		"	float2 localNormal = bumpMap.wy;\n"
		"	localNormal *= mask.xy;\n"
		"\n"
		"	// calculate the screen texcoord in the 0.0 to 1.0 range\n"
		"	float2 screenTexCoord = vposToScreenPosTexCoord( fragment.position.xy );\n"
		"	screenTexCoord += ( localNormal * fragment.texcoord2.xy );\n"
		"	screenTexCoord = saturate( screenTexCoord );\n"
		"\n"
		"	result.color = tex2D( samp0, screenTexCoord );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMask.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company.\n"
		"Copyright (C) 2013 Robert Beckebans \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	#include \"skinning.inc\"\n"
		"\n"
		"	// texture 0 takes the texture coordinates unmodified\n"
		"	result.texcoord0 = float4( vertex.texcoord.xy, 0, 0 );\n"
		"\n"
		"	// texture 1 takes the texture coordinates and adds a scroll\n"
		"	const float4 textureScroll = rpUser0;\n"
		"	result.texcoord1 = float4( vertex.texcoord.xy, 0, 0 ) + textureScroll;\n"
		"\n"
		"	// texture 2 takes the deform magnitude and scales it by the projection distance\n"
		"	float4 vec = float4( 0, 1, 0, 1 );\n"
		"	vec.z  = dot4( modelPosition, rpModelViewMatrixZ );\n"
		"\n"
		"	// magicProjectionAdjust is a magic scalar that scales the projection since we changed from \n"
		"	// using the X axis to the Y axis to calculate R1.  It is an approximation to closely match \n"
		"	// what the original game did\n"
		"	const float magicProjectionAdjust = 0.43f;\n"
		"	float x = dot4 ( vec, rpProjectionMatrixY ) * magicProjectionAdjust;\n"
		"	float w = dot4 ( vec, rpProjectionMatrixW );\n"
		"\n"
		"	// don't let the recip get near zero for polygons that cross the view plane\n"
		"	w = max( w, 1.0 );\n"
		"	x /= w;\n"
		"	//x = x * ( 1.0f / ( w + 0.00001f ) );\n"
		"\n"
		"	// clamp the distance so the the deformations don't get too wacky near the view\n"
		"	x = min( x, 0.02 );\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.texcoord2 = x * deformMagnitude;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMaskAndVertex.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 0 is _current Render\n"
		"uniform sampler2D	samp1 : register(s1); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp2 : register(s2); // texture 2 is the mask texture\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"	float4 texcoord1	: TEXCOORD1_centroid;\n"
		"	float4 texcoord2	: TEXCOORD2_centroid;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// load the distortion map\n"
		"	float4 mask = tex2D( samp2, fragment.texcoord0.xy );\n"
		"\n"
		"	// kill the pixel if the distortion wound up being very small\n"
		"	mask.xy *= fragment.color.xy;\n"
		"	mask.xy -= 0.01f;\n"
		"	clip( mask );\n"
		"\n"
		"	// load the filtered normal map and convert to -1 to 1 range\n"
		"	float4 bumpMap = ( tex2D( samp1, fragment.texcoord1.xy ) * 2.0f ) - 1.0f;\n"
		"	float2 localNormal = bumpMap.wy;\n"
		"	localNormal *= mask.xy;\n"
		"\n"
		"	// calculate the screen texcoord in the 0.0 to 1.0 range\n"
		"	float2 screenTexCoord = vposToScreenPosTexCoord( fragment.position.xy );\n"
		"	screenTexCoord += ( localNormal * fragment.texcoord2.xy );\n"
		"	screenTexCoord = saturate( screenTexCoord );\n"
		"\n"
		"	result.color = tex2D( samp0, screenTexCoord );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/heatHazeWithMaskAndVertex.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"global.inc\"\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"uniform float4 rpUser0 : register(c128); // rpScroll\n"
		"uniform	float4 rpUser1 : register(c129); // rpDeformMagnitude\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	#include \"skinning.inc\"\n"
		"\n"
		"	// texture 0 takes the texture coordinates unmodified\n"
		"	result.texcoord0 = float4( vertex.texcoord, 0 , 0 );\n"
		"\n"
		"	// texture 1 takes the texture coordinates and adds a scroll\n"
		"	const float4 textureScroll = rpUser0;\n"
		"	result.texcoord1 = float4( vertex.texcoord, 0, 0 ) + textureScroll;\n"
		"\n"
		"	// texture 2 takes the deform magnitude and scales it by the projection distance\n"
		"	float4 vec = float4( 0, 1, 0, 1 );\n"
		"	vec.z = dot4( modelPosition, rpModelViewMatrixZ );\n"
		"\n"
		"	// magicProjectionAdjust is a magic scalar that scales the projection since we changed from \n"
		"	// using the X axis to the Y axis to calculate x.  It is an approximation to closely match \n"
		"	// what the original game did\n"
		"	const float magicProjectionAdjust = 0.43f;\n"
		"	float x = dot4 ( vec, rpProjectionMatrixY ) * magicProjectionAdjust;\n"
		"	float w = dot4( vec, rpProjectionMatrixW );\n"
		"\n"
		"	// don't let the recip get near zero for polygons that cross the view plane\n"
		"	w = max( w, 1.0f );\n"
		"	x /= w;\n"
		"	//x = x * ( 1.0f / w );\n"
		"\n"
		"	// clamp the distance so the the deformations don't get too wacky near the view\n"
		"	x = min( x, 0.02f );\n"
		"\n"
		"	const float4 deformMagnitude = rpUser1;\n"
		"	result.texcoord2 = x * deformMagnitude;\n"
		"	result.color = swizzleColor( vertex.color );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interaction.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D	samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D	samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D	samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"\n"
		"struct PS_IN {\n"
		"	half4 position	: VPOS;\n"
		"	half4 texcoord0	: TEXCOORD0_centroid;\n"
		"	half4 texcoord1	: TEXCOORD1_centroid;\n"
		"	half4 texcoord2	: TEXCOORD2_centroid;\n"
		"	half4 texcoord3	: TEXCOORD3_centroid;\n"
		"	half4 texcoord4	: TEXCOORD4_centroid;\n"
		"	half4 texcoord5	: TEXCOORD5_centroid;\n"
		"	half4 texcoord6	: TEXCOORD6_centroid;\n"
		"	half4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	idtex2Dproj( samp1, fragment.texcoord2 );\n"
		"	half4 lightProj	=		idtex2Dproj( samp2, fragment.texcoord3 );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMap =			tex2D( samp4, fragment.texcoord5.xy );\n"
		"\n"
		"	half3 lightVector = normalize( fragment.texcoord0.xyz );\n"
		"	half3 diffuseMap = ConvertYCoCgToRGB( YCoCG );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"	\n"
		"	// traditional very dark Lambert light model used in Doom 3\n"
		"	half ldotN = dot3( localNormal, lightVector );\n"
		"\n"
		"#if defined(USE_HALF_LAMBERT)\n"
		"	// RB: http://developer.valvesoftware.com/wiki/Half_Lambert\n"
		"	half halfLdotN = dot3( localNormal, lightVector ) * 0.5 + 0.5;\n"
		"	halfLdotN *= halfLdotN;\n"
		"\n"
		"	half lambert = halfLdotN;\n"
		"#else\n"
		"	half lambert = ldotN;\n"
		"#endif\n"
		"	\n"
		"	const half specularPower = 10.0f;\n"
		"	half hDotN = dot3( normalize( fragment.texcoord6.xyz ), localNormal );\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( abs( hDotN ), specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * rpDiffuseModifier.xyz;\n"
		"	half3 specularColor = specMap.xyz * specularContribution * rpSpecularModifier.xyz;\n"
		"	half3 lightColor = lightProj.xyz * lightFalloff.xyz;\n"
		"	\n"
		"	half rim =  1.0f - saturate( hDotN );\n"
		"	half rimPower = 16.0f;\n"
		"	half3 rimColor = diffuseColor * lightProj.xyz * lightFalloff.xyz * 1.0f * pow( rim, rimPower ) * fragment.color.rgb;// * halfLdotN;\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lambert * lightColor * fragment.color.rgb;// + rimColor;\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interaction.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBitangent = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / tangent / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 bitangent;\n"
		"	bitangent.x = dot3( matX, vBitangent );\n"
		"	bitangent.y = dot3( matY, vBitangent );\n"
		"	bitangent.z = dot3( matZ, vBitangent );\n"
		"	bitangent = normalize( bitangent );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"#else\n"
		"	float4 modelPosition = vertex.position;\n"
		"	float3 normal = vNormal.xyz;\n"
		"	float3 tangent = vTangent.xyz;\n"
		"	float3 bitangent = vBitangent.xyz;\n"
		"#endif\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light\n"
		"	float4 toLight = rpLocalLightOrigin - modelPosition;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"\n"
		"	//result.texcoord0 is the direction to the light in tangent space\n"
		"	result.texcoord0.x = dot3( tangent, toLight );\n"
		"	result.texcoord0.y = dot3( bitangent, toLight );\n"
		"	result.texcoord0.z = dot3( normal, toLight );\n"
		"	result.texcoord0.w = 1.0f;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( modelPosition, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( modelPosition, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( modelPosition, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( modelPosition, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLight = normalize( toLight );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - modelPosition );\n"
		"	\n"
		"	//# add together to become the half angle vector in object space (non-normalized)\n"
		"	float4 halfAngleVector = toLight + toView;\n"
		"\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, halfAngleVector );\n"
		"	result.texcoord6.y = dot3( bitangent, halfAngleVector );\n"
		"	result.texcoord6.z = dot3( normal, halfAngleVector );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	// for joint transformation of the tangent space, we use color and\n"
		"	// color2 for weighting information, so hopefully there aren't any\n"
		"	// effects that need vertex color...\n"
		"	result.color = float4( 1.0f, 1.0f, 1.0f, 1.0f );\n"
		"#else\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interactionSM.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D				samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D				samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D				samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D				samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D				samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"uniform sampler2DArrayShadow	samp5 : register(s5); // texture 6 is the shadowmap array\n"
		"uniform sampler2D				samp6 : register(s6); // texture 7 is the jitter texture\n"
		"\n"
		"\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	half4 position		: VPOS;\n"
		"	half4 texcoord0		: TEXCOORD0_centroid;\n"
		"	half4 texcoord1		: TEXCOORD1_centroid;\n"
		"	half4 texcoord2		: TEXCOORD2_centroid;\n"
		"	half4 texcoord3		: TEXCOORD3_centroid;\n"
		"	half4 texcoord4		: TEXCOORD4_centroid;\n"
		"	half4 texcoord5		: TEXCOORD5_centroid;\n"
		"	half4 texcoord6		: TEXCOORD6_centroid;\n"
		"	half4 texcoord7		: TEXCOORD7_centroid;\n"
		"	half4 texcoord8		: TEXCOORD8_centroid;\n"
		"	half4 texcoord9		: TEXCOORD9_centroid;\n"
		"	half4 color			: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	idtex2Dproj( samp1, fragment.texcoord2 );\n"
		"	half4 lightProj	=		idtex2Dproj( samp2, fragment.texcoord3 );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMap =			tex2D( samp4, fragment.texcoord5.xy );\n"
		"\n"
		"	half3 lightVector = normalize( fragment.texcoord0.xyz );\n"
		"	half3 diffuseMap = ConvertYCoCgToRGB( YCoCG );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"	\n"
		"	// traditional very dark Lambert light model used in Doom 3\n"
		"	half ldotN = dot3( localNormal, lightVector );\n"
		"\n"
		"#if defined(USE_HALF_LAMBERT)\n"
		"	// RB: http://developer.valvesoftware.com/wiki/Half_Lambert\n"
		"	half halfLdotN = dot3( localNormal, lightVector ) * 0.5 + 0.5;\n"
		"	halfLdotN *= halfLdotN;\n"
		"\n"
		"	half lambert = halfLdotN;\n"
		"#else\n"
		"	half lambert = ldotN;\n"
		"#endif\n"
		"	\n"
		"	const half specularPower = 10.0f;\n"
		"	half hDotN = dot3( normalize( fragment.texcoord6.xyz ), localNormal );\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( abs( hDotN ), specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * rpDiffuseModifier.xyz;\n"
		"	half3 specularColor = specMap.xyz * specularContribution * rpSpecularModifier.xyz;\n"
		"	half3 lightColor = lightProj.xyz * lightFalloff.xyz;\n"
		"	\n"
		"	half rim =  1.0f - saturate( hDotN );\n"
		"	half rimPower = 16.0f;\n"
		"	half3 rimColor = diffuseColor * lightProj.xyz * lightFalloff.xyz * 1.0f * pow( rim, rimPower ) * fragment.color.rgb;// * halfLdotN;\n"
		"	\n"
		"	//\n"
		"	// shadow mapping\n"
		"	//\n"
		"	int shadowIndex = 0;\n"
		"	\n"
		"#if defined( LIGHT_POINT )\n"
		"	float3 toLightGlobal = normalize( fragment.texcoord8.xyz );\n"
		"	\n"
		"	float axis[6];\n"
		"	axis[0] = -toLightGlobal.x;\n"
		"	axis[1] =  toLightGlobal.x;\n"
		"	axis[2] = -toLightGlobal.y;\n"
		"	axis[3] =  toLightGlobal.y;\n"
		"	axis[4] = -toLightGlobal.z;\n"
		"	axis[5] =  toLightGlobal.z;\n"
		"\n"
		"	for( int i = 0; i < 6; i++ )\n"
		"	{\n"
		"		if( axis[i] > axis[shadowIndex] )\n"
		"		{\n"
		"			shadowIndex = i;\n"
		"		}\n"
		"	}\n"
		"\n"
		"#endif // #if defined( POINTLIGHT )\n"
		"\n"
		"#if defined( LIGHT_PARALLEL )\n"
		"	\n"
		"	float viewZ = -fragment.texcoord9.z;\n"
		"	\n"
		"	shadowIndex = 4;\n"
		"	for( int i = 0; i < 4; i++ )\n"
		"	{\n"
		"		if( viewZ < rpCascadeDistances[i] )\n"
		"		{\n"
		"			shadowIndex = i;\n"
		"			break;\n"
		"		}\n"
		"	}\n"
		"#endif\n"
		"	\n"
		"#if 0\n"
		"	if( shadowIndex == 0 )\n"
		"	{\n"
		"		result.color = float4( 1.0, 0.0, 0.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 1 )\n"
		"	{\n"
		"		result.color = float4( 0.0, 1.0, 0.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 2 )\n"
		"	{\n"
		"		result.color = float4( 0.0, 0.0, 1.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 3 )\n"
		"	{\n"
		"		result.color = float4( 1.0, 1.0, 0.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 4 )\n"
		"	{\n"
		"		result.color = float4( 1.0, 0.0, 1.0, 1.0 );\n"
		"	}\n"
		"	else if( shadowIndex == 5 )\n"
		"	{\n"
		"		result.color = float4( 0.0, 1.0, 1.0, 1.0 );\n"
		"	}\n"
		"	\n"
		"	//result.color.xyz *= lightColor;\n"
		"	return;\n"
		"#endif\n"
		"	\n"
		"	float4 shadowMatrixX = rpShadowMatrices[ int ( shadowIndex * 4 + 0 ) ];\n"
		"	float4 shadowMatrixY = rpShadowMatrices[ int ( shadowIndex * 4 + 1 ) ];\n"
		"	float4 shadowMatrixZ = rpShadowMatrices[ int ( shadowIndex * 4 + 2 ) ];\n"
		"	float4 shadowMatrixW = rpShadowMatrices[ int ( shadowIndex * 4 + 3 ) ];\n"
		"	\n"
		"	float4 modelPosition = float4( fragment.texcoord7.xyz, 1.0 );\n"
		"	float4 shadowTexcoord;\n"
		"	shadowTexcoord.x = dot4( modelPosition, shadowMatrixX );\n"
		"	shadowTexcoord.y = dot4( modelPosition, shadowMatrixY );\n"
		"	shadowTexcoord.z = dot4( modelPosition, shadowMatrixZ );\n"
		"	shadowTexcoord.w = dot4( modelPosition, shadowMatrixW );\n"
		"	\n"
		"	//float bias = 0.005 * tan( acos( ldotN ) );\n"
		"	//bias = clamp( bias, 0, 0.01 );\n"
		"	float bias = 0.001;\n"
		"	\n"
		"	shadowTexcoord.xyz /= shadowTexcoord.w;\n"
		"	\n"
		"	shadowTexcoord.z = shadowTexcoord.z * rpScreenCorrectionFactor.w;\n"
		"	//shadowTexcoord.z = shadowTexcoord.z * 0.999991;\n"
		"	//shadowTexcoord.z = shadowTexcoord.z - bias;\n"
		"	shadowTexcoord.w = float(shadowIndex);\n"
		"\n"
		"#if 0\n"
		"	result.color.xyz = float3( shadowTexcoord.z, shadowTexcoord.z, shadowTexcoord.z );\n"
		"	result.color.w = 1.0;\n"
		"	return;\n"
		"#endif\n"
		"\n"
		"	// multiple taps\n"
		"	\n"
		"#if 0\n"
		"	float4 base = shadowTexcoord;\n"
		"	\n"
		"	base.xy += rpJitterTexScale.xy * -0.5;\n"
		"	\n"
		"	float shadow = 0.0;\n"
		"	\n"
		"	//float stepSize = 1.0 / 16.0;\n"
		"	float numSamples = 16;\n"
		"	float stepSize = 1.0 / numSamples;\n"
		"	\n"
		"	float4 jitterTC = ( fragment.position * rpScreenCorrectionFactor ) + rpJitterTexOffset;\n"
		"	for( float i = 0.0; i < numSamples; i += 1.0 )\n"
		"	{\n"
		"		float4 jitter = base + tex2D( samp6, jitterTC.xy ) * rpJitterTexScale;\n"
		"		jitter.zw = shadowTexcoord.zw;\n"
		"	\n"
		"		shadow += texture( samp5, jitter.xywz );\n"
		"		jitterTC.x += stepSize;\n"
		"	}\n"
		"	\n"
		"	shadow *= stepSize;\n"
		"#else\n"
		"	\n"
		"	const float2 poissonDisk[12] = float2[](\n"
		"	float2(0.6111618, 0.1050905),\n"
		"	float2(0.1088336, 0.1127091),\n"
		"	float2(0.3030421, -0.6292974),\n"
		"	float2(0.4090526, 0.6716492),\n"
		"	float2(-0.1608387, -0.3867823),\n"
		"	float2(0.7685862, -0.6118501),\n"
		"	float2(-0.1935026, -0.856501),\n"
		"	float2(-0.4028573, 0.07754025),\n"
		"	float2(-0.6411021, -0.4748057),\n"
		"	float2(-0.1314865, 0.8404058),\n"
		"	float2(-0.7005203, 0.4596822),\n"
		"	float2(-0.9713828, -0.06329931) );\n"
		"	\n"
		"	float shadow = 0.0;\n"
		"	\n"
		"	// RB: casting a float to int and using it as index can really kill the performance ...\n"
		"	float numSamples = 12.0; //int(rpScreenCorrectionFactor.w);\n"
		"	float stepSize = 1.0 / numSamples;\n"
		"	\n"
		"	float4 jitterTC = ( fragment.position * rpScreenCorrectionFactor ) + rpJitterTexOffset;\n"
		"	float4 random = tex2D( samp6, jitterTC.xy ) * PI;\n"
		"	//float4 random = fragment.position;\n"
		"	\n"
		"	float2 rot;\n"
		"	rot.x = cos( random.x );\n"
		"	rot.y = sin( random.x );\n"
		"	\n"
		"	float shadowTexelSize = rpScreenCorrectionFactor.z * rpJitterTexScale.x;\n"
		"    for( int i = 0; i < 12; i++ )\n"
		"    {\n"
		"        float2 jitter = poissonDisk[i];\n"
		"		float2 jitterRotated;\n"
		"		jitterRotated.x = jitter.x * rot.x - jitter.y * rot.y;\n"
		"		jitterRotated.y = jitter.x * rot.y + jitter.y * rot.x;\n"
		"        \n"
		"		float4 shadowTexcoordJittered = float4( shadowTexcoord.xy + jitterRotated * shadowTexelSize, shadowTexcoord.z, shadowTexcoord.w );\n"
		"       \n"
		"        shadow += texture( samp5, shadowTexcoordJittered.xywz);\n"
		"    }\n"
		"\n"
		"   shadow *= stepSize;\n"
		"\n"
		"	//float shadow = texture( samp5, shadowTexcoord.xywz );\n"
		"#endif\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lambert * lightColor * fragment.color.rgb * shadow;// + rimColor;\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interactionSM.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"#endif\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 texcoord7	: TEXCOORD7;\n"
		"	float4 texcoord8	: TEXCOORD8;\n"
		"	float4 texcoord9	: TEXCOORD9;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBitangent = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / tangent / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	float joint = vertex.color.x * 255.1 * 3;\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = vertex.color.y * 255.1 * 3;\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = vertex.color.z * 255.1 * 3;\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = vertex.color.w * 255.1 * 3;\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 bitangent;\n"
		"	bitangent.x = dot3( matX, vBitangent );\n"
		"	bitangent.y = dot3( matY, vBitangent );\n"
		"	bitangent.z = dot3( matZ, vBitangent );\n"
		"	bitangent = normalize( bitangent );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"#else\n"
		"	float4 modelPosition = vertex.position;\n"
		"	float3 normal = vNormal.xyz;\n"
		"	float3 tangent = vTangent.xyz;\n"
		"	float3 bitangent = vBitangent.xyz;\n"
		"#endif\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light\n"
		"	float4 toLightLocal = rpLocalLightOrigin - modelPosition;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"\n"
		"	//result.texcoord0 is the direction to the light in tangent space\n"
		"	result.texcoord0.x = dot3( tangent, toLightLocal );\n"
		"	result.texcoord0.y = dot3( bitangent, toLightLocal );\n"
		"	result.texcoord0.z = dot3( normal, toLightLocal );\n"
		"	result.texcoord0.w = 1.0f;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( modelPosition, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( modelPosition, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( modelPosition, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( modelPosition, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLightLocal = normalize( toLightLocal );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - modelPosition );\n"
		"	\n"
		"	//# add together to become the half angle vector in object space (non-normalized)\n"
		"	float4 halfAngleVector = toLightLocal + toView;\n"
		"\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, halfAngleVector );\n"
		"	result.texcoord6.y = dot3( bitangent, halfAngleVector );\n"
		"	result.texcoord6.z = dot3( normal, halfAngleVector );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"	\n"
		"	result.texcoord7 = modelPosition;\n"
		"	\n"
		"	float4 worldPosition;\n"
		"	worldPosition.x = dot4( modelPosition, rpModelMatrixX );\n"
		"	worldPosition.y = dot4( modelPosition, rpModelMatrixY );\n"
		"	worldPosition.z = dot4( modelPosition, rpModelMatrixZ );\n"
		"	worldPosition.w = dot4( modelPosition, rpModelMatrixW );\n"
		"	\n"
		"	float4 toLightGlobal = rpGlobalLightOrigin - worldPosition;\n"
		"	\n"
		"	result.texcoord8 = toLightGlobal;\n"
		"	\n"
		"	float4 viewPosition;\n"
		"	viewPosition.x = dot4( modelPosition, rpModelViewMatrixX );\n"
		"	viewPosition.y = dot4( modelPosition, rpModelViewMatrixY );\n"
		"	viewPosition.z = dot4( modelPosition, rpModelViewMatrixZ );\n"
		"	viewPosition.w = dot4( modelPosition, rpModelViewMatrixW );\n"
		"	\n"
		"	result.texcoord9 = viewPosition;\n"
		"\n"
		"#if defined( USE_GPU_SKINNING )\n"
		"	// for joint transformation of the tangent space, we use color and\n"
		"	// color2 for weighting information, so hopefully there aren't any\n"
		"	// effects that need vertex color...\n"
		"	result.color = float4( 1.0f, 1.0f, 1.0f, 1.0f );\n"
		"#else\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"#endif\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interactionAmbient.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D	samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D	samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D	samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"\n"
		"struct PS_IN {\n"
		"	half4 position	: VPOS;\n"
		"	half4 texcoord1	: TEXCOORD1_centroid;\n"
		"	half4 texcoord2	: TEXCOORD2_centroid;\n"
		"	half4 texcoord3	: TEXCOORD3_centroid;\n"
		"	half4 texcoord4	: TEXCOORD4_centroid;\n"
		"	half4 texcoord5	: TEXCOORD5_centroid;\n"
		"	half4 texcoord6	: TEXCOORD6_centroid;\n"
		"	half4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	idtex2Dproj( samp1, fragment.texcoord2 );\n"
		"	half4 lightProj	=		idtex2Dproj( samp2, fragment.texcoord3 );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMap =			tex2D( samp4, fragment.texcoord5.xy );\n"
		"\n"
		"	const half3 ambientLightVector = half3( 0.5f, 9.5f - 0.385f, 0.8925f );\n"
		"	half3 lightVector = normalize( ambientLightVector );\n"
		"	half3 diffuseMap = ConvertYCoCgToRGB( YCoCG );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"\n"
		"	const half specularPower = 10.0f;\n"
		"	half hDotN = dot3( normalize( fragment.texcoord6.xyz ), localNormal );\n"
		"	// RB: added abs\n"
		"	half3 specularContribution = _half3( pow( abs( hDotN ), specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * rpDiffuseModifier.xyz;\n"
		"	half3 specularColor = specMap.xyz * specularContribution * rpSpecularModifier.xyz;\n"
		"	half3 lightColor = lightProj.xyz * lightFalloff.xyz; // ambient fix\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lightColor * fragment.color.xyz;\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interactionAmbient.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 normal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 tangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 binormal = cross( normal.xyz, tangent.xyz ) * tangent.w;\n"
		"\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light in R0\n"
		"	float4 toLight = rpLocalLightOrigin - vertex.position;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( vertex.position, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( vertex.position, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( vertex.position, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( vertex.position, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLight = normalize( toLight );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - vertex.position );\n"
		"	\n"
		"	//# add together to become the half angle vector in object space (non-normalized)\n"
		"	float4 halfAngleVector = toLight + toView;\n"
		"\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, halfAngleVector );\n"
		"	result.texcoord6.y = dot3( binormal, halfAngleVector );\n"
		"	result.texcoord6.z = dot3( normal, halfAngleVector );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/interactionAmbient_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0); // texture 1 is the per-surface bump map\n"
		"uniform sampler2D	samp1 : register(s1); // texture 2 is the light falloff texture\n"
		"uniform sampler2D	samp2 : register(s2); // texture 3 is the light projection texture\n"
		"uniform sampler2D	samp3 : register(s3); // texture 4 is the per-surface diffuse map\n"
		"uniform sampler2D	samp4 : register(s4); // texture 5 is the per-surface specular map\n"
		"\n"
		"struct PS_IN {\n"
		"	half4 position	: VPOS;\n"
		"	half4 texcoord1	: TEXCOORD1_centroid;\n"
		"	half4 texcoord2	: TEXCOORD2_centroid;\n"
		"	half4 texcoord3	: TEXCOORD3_centroid;\n"
		"	half4 texcoord4	: TEXCOORD4_centroid;\n"
		"	half4 texcoord5	: TEXCOORD5_centroid;\n"
		"	half4 texcoord6	: TEXCOORD6_centroid;\n"
		"	half4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	half4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	half4 bumpMap =			tex2D( samp0, fragment.texcoord1.xy );\n"
		"	half4 lightFalloff =	idtex2Dproj( samp1, fragment.texcoord2 );\n"
		"	half4 lightProj	=		idtex2Dproj( samp2, fragment.texcoord3 );\n"
		"	half4 YCoCG =			tex2D( samp3, fragment.texcoord4.xy );\n"
		"	half4 specMap =			tex2D( samp4, fragment.texcoord5.xy );\n"
		"\n"
		"	const half3 ambientLightVector = half3( 0.5f, 9.5f - 0.385f, 0.8925f );\n"
		"	half3 lightVector = normalize( ambientLightVector );\n"
		"	half3 diffuseMap = ConvertYCoCgToRGB( YCoCG );\n"
		"\n"
		"	half3 localNormal;\n"
		"	// RB begin\n"
		"#if defined(USE_NORMAL_FMT_RGB8)\n"
		"	localNormal.xy = bumpMap.rg - 0.5;\n"
		"#else\n"
		"	localNormal.xy = bumpMap.wy - 0.5;\n"
		"#endif\n"
		"	// RB end\n"
		"	localNormal.z = sqrt( abs( dot( localNormal.xy, localNormal.xy ) - 0.25 ) );\n"
		"	localNormal = normalize( localNormal );\n"
		"\n"
		"	const half specularPower = 10.0f;\n"
		"	half hDotN = dot3( normalize( fragment.texcoord6.xyz ), localNormal );\n"
		"	half3 specularContribution = _half3( pow( hDotN, specularPower ) );\n"
		"\n"
		"	half3 diffuseColor = diffuseMap * rpDiffuseModifier.xyz;\n"
		"	half3 specularColor = specMap.xyz * specularContribution * rpSpecularModifier.xyz;\n"
		"	half3 lightColor = lightProj.xyz * lightFalloff.xyz; // ambient fix\n"
		"\n"
		"	result.color.xyz = ( diffuseColor + specularColor ) * lightColor * fragment.color.xyz;\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/interactionAmbient_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord1	: TEXCOORD1;\n"
		"	float4 texcoord2	: TEXCOORD2;\n"
		"	float4 texcoord3	: TEXCOORD3;\n"
		"	float4 texcoord4	: TEXCOORD4;\n"
		"	float4 texcoord5	: TEXCOORD5;\n"
		"	float4 texcoord6	: TEXCOORD6;\n"
		"	float4 color		: COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"\n"
		"	float4 vNormal = vertex.normal * 2.0 - 1.0;\n"
		"	float4 vTangent = vertex.tangent * 2.0 - 1.0;\n"
		"	float3 vBinormal = cross( vNormal.xyz, vTangent.xyz ) * vTangent.w;\n"
		"\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float3 normal;\n"
		"	normal.x = dot3( matX, vNormal );\n"
		"	normal.y = dot3( matY, vNormal );\n"
		"	normal.z = dot3( matZ, vNormal );\n"
		"	normal = normalize( normal );\n"
		"\n"
		"	float3 tangent;\n"
		"	tangent.x = dot3( matX, vTangent );\n"
		"	tangent.y = dot3( matY, vTangent );\n"
		"	tangent.z = dot3( matZ, vTangent );\n"
		"	tangent = normalize( tangent );\n"
		"\n"
		"	float3 binormal;\n"
		"	binormal.x = dot3( matX, vBinormal );\n"
		"	binormal.y = dot3( matY, vBinormal );\n"
		"	binormal.z = dot3( matZ, vBinormal );\n"
		"	binormal = normalize( binormal );\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	float4 defaultTexCoord = float4( 0.0f, 0.5f, 0.0f, 1.0f );\n"
		"\n"
		"	//calculate vector to light in R0\n"
		"	float4 toLight = rpLocalLightOrigin - modelPosition;\n"
		"\n"
		"	//textures 1 takes the base coordinates by the texture matrix\n"
		"	result.texcoord1 = defaultTexCoord;\n"
		"	result.texcoord1.x = dot4( vertex.texcoord.xy, rpBumpMatrixS );\n"
		"	result.texcoord1.y = dot4( vertex.texcoord.xy, rpBumpMatrixT );\n"
		"\n"
		"	//# texture 2 has one texgen\n"
		"	result.texcoord2 = defaultTexCoord;\n"
		"	result.texcoord2.x = dot4( modelPosition, rpLightFalloffS );\n"
		"\n"
		"	//# texture 3 has three texgens\n"
		"	result.texcoord3.x = dot4( modelPosition, rpLightProjectionS );\n"
		"	result.texcoord3.y = dot4( modelPosition, rpLightProjectionT );\n"
		"	result.texcoord3.z = 0.0f;\n"
		"	result.texcoord3.w = dot4( modelPosition, rpLightProjectionQ );\n"
		"\n"
		"	//# textures 4 takes the base coordinates by the texture matrix\n"
		"	result.texcoord4 = defaultTexCoord;\n"
		"	result.texcoord4.x = dot4( vertex.texcoord.xy, rpDiffuseMatrixS );\n"
		"	result.texcoord4.y = dot4( vertex.texcoord.xy, rpDiffuseMatrixT );\n"
		"\n"
		"	//# textures 5 takes the base coordinates by the texture matrix\n"
		"	result.texcoord5 = defaultTexCoord;\n"
		"	result.texcoord5.x = dot4( vertex.texcoord.xy, rpSpecularMatrixS );\n"
		"	result.texcoord5.y = dot4( vertex.texcoord.xy, rpSpecularMatrixT );\n"
		"\n"
		"	//# texture 6's texcoords will be the halfangle in texture space\n"
		"\n"
		"	//# calculate normalized vector to light in R0\n"
		"	toLight = normalize( toLight );\n"
		"\n"
		"	//# calculate normalized vector to viewer in R1\n"
		"	float4 toView = normalize( rpLocalViewOrigin - modelPosition );\n"
		"	\n"
		"	//# add together to become the half angle vector in object space (non-normalized)\n"
		"	float4 halfAngleVector = toLight + toView;\n"
		"\n"
		"	//# put into texture space\n"
		"	result.texcoord6.x = dot3( tangent, halfAngleVector );\n"
		"	result.texcoord6.y = dot3( binormal, halfAngleVector );\n"
		"	result.texcoord6.z = dot3( normal, halfAngleVector );\n"
		"	result.texcoord6.w = 1.0f;\n"
		"\n"
		"	//# generate the vertex color, which can be 1.0, color, or 1.0 - color\n"
		"	//# for 1.0 : env[16] = 0, env[17] = 1\n"
		"	//# for color : env[16] = 1, env[17] = 0\n"
		"	//# for 1.0-color : env[16] = -1, env[17] = 1	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/motionBlur.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);   // view color\n"
		"uniform sampler2D samp1 : register(s1);   // view depth\n"
		"\n"
		"struct PS_IN {\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"#if 0\n"
		"    if ( fragment.texcoord0.x < 0.5 ) {\n"
		"    // only draw on half the screen for comparison\n"
		"        discard;\n"
		"    }\n"
		"#endif\n"
		"	// don't motion blur the hands, which were drawn with alpha = 0\n"
		"	if ( tex2D( samp0, fragment.texcoord0 ).w == 0.0 ) {\n"
		"		discard;\n"
		"	}\n"
		"\n"
		"	// derive clip space from the depth buffer and screen position\n"
		"	float windowZ = tex2D( samp1, fragment.texcoord0 ).x;\n"
		"	float3 ndc = float3( fragment.texcoord0 * 2.0 - 1.0, windowZ * 2.0 - 1.0 );\n"
		"	float clipW = -rpProjectionMatrixZ.w / ( -rpProjectionMatrixZ.z - ndc.z );\n"
		"\n"
		"	float4 clip = float4( ndc * clipW, clipW );\n"
		"\n"
		"	// convert from clip space this frame to clip space previous frame\n"
		"	float4 reClip;\n"
		"	reClip.x = dot( rpMVPmatrixX, clip );\n"
		"	reClip.y = dot( rpMVPmatrixY, clip );\n"
		"	reClip.z = dot( rpMVPmatrixZ, clip );\n"
		"	reClip.w = dot( rpMVPmatrixW, clip );\n"
		"\n"
		"	// convert to NDC values\n"
		"	float2 prevTexCoord;\n"
		"	prevTexCoord.x = ( reClip.x / reClip.w ) * 0.5 + 0.5;\n"
		"	prevTexCoord.y = ( reClip.y / reClip.w ) * 0.5 + 0.5;\n"
		"\n"
		"	// sample along the line from prevTexCoord to fragment.texcoord0\n"
		"\n"
		"	float2 texCoord = prevTexCoord; //fragment.texcoord0;\n"
		"	float2 delta = ( fragment.texcoord0 - prevTexCoord );\n"
		"\n"
		"	float3 sum = float3( 0.0 );\n"
		"	float goodSamples = 0.0;\n"
		"	float samples = rpOverbright.x;\n"
		"\n"
		"	for ( float i = 0.0 ; i < samples ; i = i + 1.0 ) {\n"
		"		float2 pos = fragment.texcoord0 + delta * ( ( i / ( samples - 1.0 ) ) - 0.5 );\n"
		"		float4 color = tex2D( samp0, pos );\n"
		"		// only take the values that are not part of the weapon\n"
		"		sum += color.xyz * color.w;\n"
		"		goodSamples += color.w;\n"
		"	}\n"
		"	float invScale = 1.0 / goodSamples;\n"
		"\n"
		"	result.color = float4( sum * invScale, 1.0 );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/motionBlur.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/postprocess.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0		: register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float2 tCoords = fragment.texcoord0;\n"
		"	result.color = tex2D( samp0, tCoords );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/postprocess.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"\n"
		"	//result.position.x = vertex.position; //dot4( vertex.position, rpMVPmatrixX );\n"
		"	//result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	//result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	//result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	result.texcoord0 =  vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vPos = vertex.position - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 vPos = vertex.position - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadowDebug_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 vertexPosition = vertex.position;\n"
		"	vertexPosition.w = 1.0;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertexPosition );\n"
		"	modelPosition.y = dot4( matY, vertexPosition );\n"
		"	modelPosition.z = dot4( matZ, vertexPosition );\n"
		"	modelPosition.w = vertex.position.w;\n"
		"\n"
		"	float4 vPos = modelPosition - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/shadow_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Coypright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 vertexPosition = vertex.position;\n"
		"	vertexPosition.w = 1.0;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertexPosition );\n"
		"	modelPosition.y = dot4( matY, vertexPosition );\n"
		"	modelPosition.z = dot4( matZ, vertexPosition );\n"
		"	modelPosition.w = vertex.position.w;\n"
		"\n"
		"	float4 vPos = modelPosition - rpLocalLightOrigin;\n"
		"	vPos = ( vPos.wwww * rpLocalLightOrigin ) + vPos;\n"
		"\n"
		"	result.position.x = dot4( vPos, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vPos, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vPos, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vPos, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/simpleshade.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position		: VPOS;\n"
		"	float4 texcoord0	: TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"uniform sampler2D	samp0 : register(s0);\n"
		"\n"
		"static float2 screenPosToTexcoord( float2 pos, float4 bias_scale ) { return ( pos * bias_scale.zw + bias_scale.xy ); }\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	const float renderWidth = 1280.0f;\n"
		"	const float renderHeight = 720.0f;\n"
		"	const float4 positionToViewTexture = float4( 0.5f / renderWidth, 0.5f / renderHeight, 1.0f / renderWidth, 1.0f / renderHeight );\n"
		"	\n"
		"	float interpolatedZOverW = ( 1.0 - ( fragment.texcoord0.z / fragment.texcoord0.w ) );\n"
		"\n"
		"	float3 pos;\n"
		"	pos.z = 1.0 / interpolatedZOverW;\n"
		"	pos.xy = pos.z * ( 2.0 * screenPosToTexcoord( fragment.position.xy, positionToViewTexture ) - 1.0 );\n"
		"\n"
		"	float3 normal = normalize( cross( ddy( pos ), ddx( pos ) ) );\n"
		"\n"
		"	// light is above and to the right in the eye plane\n"
		"	float3 L = normalize( float3( 1.0, 1.0, 0.0 ) - pos );\n"
		"\n"
		"	result.color.xyz = _float3( dot3( normal, L ) * 0.75 );\n"
		"	result.color.w = 1.0;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/simpleshade.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position		: POSITION;\n"
		"	float4 texcoord0	: TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	float4 position;\n"
		"	position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.position = position;\n"
		"	result.texcoord0 = position;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/skinning.inc",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013-2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"float4 modelPosition = vertex.position;\n"
		"\n"
		"// RB: no GPU skinning with ES 2.0\n"
		"#if defined(USE_GPU_SKINNING)\n"
		"BRANCH if ( rpEnableSkinning.x > 0.0 ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"}\n"
		"#endif\n"
		"// RB end\n"
		"\n"
		"result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		
	},
	
	{
		"renderprogs/skybox.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float3 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = texCUBE( samp0, fragment.texcoord0 ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/skybox.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float3 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.position.xyz - rpLocalViewOrigin.xyz;\n"
		"	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/stereoDeGhost.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.color = rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoDeGhost.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoInterlace.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"uniform sampler2D samp1 : register(s1);\n"
		"\n"
		"struct PS_IN {\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"    // texcoords will run from 0 to 1 across the entire screen\n"
		"    if ( fract( fragment.position.y * 0.5 ) < 0.5 ) {\n"
		"        result.color = tex2D( samp0, vec2( fragment.texcoord0 ) );\n"
		"    } else {\n"
		"        result.color = tex2D( samp1, vec2( fragment.texcoord0 ) );\n"
		"    }\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoInterlace.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/stereoWarp.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"/*\n"
		"\n"
		"This shader will cover a square block of pixel coordinates, but some of them might\n"
		"be scissored off if the edges of the screen or the midpoint divider are visible through\n"
		"the optics.\n"
		"\n"
		"*/\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	vec4 texcoord0	: TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"    const float screenWarp_range   = 1.45;\n"
		"\n"
		"    const vec2    warpCenter = vec2( 0.5, 0.5 );\n"
		"    vec2    centeredTexcoord = fragment.texcoord0.xy - warpCenter;\n"
		"\n"
		"	float	radialLength = length( centeredTexcoord );\n"
		"	vec2	radialDir = normalize( centeredTexcoord );\n"
		"\n"
		"	// get it down into the 0 - PI/2 range\n"
		"	float	range = screenWarp_range;\n"
		"	float	scaledRadialLength = radialLength * range;\n"
		"	float	tanScaled = tan( scaledRadialLength );\n"
		"\n"
		"    float   rescaleValue = tan( 0.5 * range );\n"
		"\n"
		"    // If radialLength was 0.5, we want rescaled to also come out\n"
		"    // as 0.5, so the edges of the rendered image are at the edges\n"
		"    // of the warped image.\n"
		"	float	rescaled = tanScaled / rescaleValue;\n"
		"\n"
		"    vec2	warped = warpCenter + vec2( 0.5, 0.5 ) * radialDir * rescaled;\n"
		"\n"
		"	result.color = tex2D( samp0, warped );\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/stereoWarp.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord : TEXCOORD0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord0: TEXCOORD0;        // 0 to 1 box\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	result.texcoord0 = vertex.texcoord;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = tex2D( samp0, fragment.texcoord0 ) * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 color = tex2D( samp0, fragment.texcoord0 ) * fragment.color;\n"
		"	clip( color.a - rpAlphaTest.x );\n"
		"	result.color = color;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( vertex.position, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( vertex.position, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"\n"
		"	float4 vertexColor = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"	result.color =  vertexColor * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_skinned.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float2 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	float4 color = tex2D( samp0, fragment.texcoord0 ) * fragment.color;\n"
		"	clip( color.a - rpAlphaTest.x );\n"
		"	result.color = color;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_skinned.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2014 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform matrices_ubo { float4 matrices[408]; };\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"	float4 color2 : COLOR1;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	//--------------------------------------------------------------\n"
		"	// GPU transformation of the normal / binormal / bitangent\n"
		"	//\n"
		"	// multiplying with 255.1 give us the same result and is faster than floor( w * 255 + 0.5 )\n"
		"	//--------------------------------------------------------------\n"
		"	const float w0 = vertex.color2.x;\n"
		"	const float w1 = vertex.color2.y;\n"
		"	const float w2 = vertex.color2.z;\n"
		"	const float w3 = vertex.color2.w;\n"
		"\n"
		"	float4 matX, matY, matZ;	// must be float4 for vec4\n"
		"	int joint = int(vertex.color.x * 255.1 * 3.0);\n"
		"	matX = matrices[int(joint+0)] * w0;\n"
		"	matY = matrices[int(joint+1)] * w0;\n"
		"	matZ = matrices[int(joint+2)] * w0;\n"
		"\n"
		"	joint = int(vertex.color.y * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w1;\n"
		"	matY += matrices[int(joint+1)] * w1;\n"
		"	matZ += matrices[int(joint+2)] * w1;\n"
		"\n"
		"	joint = int(vertex.color.z * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w2;\n"
		"	matY += matrices[int(joint+1)] * w2;\n"
		"	matZ += matrices[int(joint+2)] * w2;\n"
		"\n"
		"	joint = int(vertex.color.w * 255.1 * 3.0);\n"
		"	matX += matrices[int(joint+0)] * w3;\n"
		"	matY += matrices[int(joint+1)] * w3;\n"
		"	matZ += matrices[int(joint+2)] * w3;\n"
		"\n"
		"	float4 modelPosition;\n"
		"	modelPosition.x = dot4( matX, vertex.position );\n"
		"	modelPosition.y = dot4( matY, vertex.position );\n"
		"	modelPosition.z = dot4( matZ, vertex.position );\n"
		"	modelPosition.w = 1.0;\n"
		"\n"
		"	result.position.x = dot4( modelPosition, rpMVPmatrixX );\n"
		"	result.position.y = dot4( modelPosition, rpMVPmatrixY );\n"
		"	result.position.z = dot4( modelPosition, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( modelPosition, rpMVPmatrixW );\n"
		"\n"
		"	// compute oldschool texgen or multiply by texture matrix\n"
		"	BRANCH if ( rpTexGen0Enabled.x > 0.0 ) {\n"
		"		result.texcoord0.x = dot4( modelPosition, rpTexGen0S );\n"
		"		result.texcoord0.y = dot4( modelPosition, rpTexGen0T );\n"
		"	} else {\n"
		"		result.texcoord0.x = dot4( vertex.texcoord.xy, rpTextureMatrixS );\n"
		"		result.texcoord0.y = dot4( vertex.texcoord.xy, rpTextureMatrixT );\n"
		"	}\n"
		"\n"
		"	float4 vertexColor = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"	result.color =  vertexColor * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_texgen.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float4 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"\n"
		"	// we always do a projective texture lookup so that we can support texgen\n"
		"	// materials without a separate shader. Basic materials will have texture\n"
		"	// coordinates with w = 1 which will result in a NOP projection when tex2Dproj\n"
		"	// gets called.\n"
		"	float4 texSample = idtex2Dproj( samp0, fragment.texcoord0 );\n"
		"\n"
		"	result.color = texSample * fragment.color;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/texture_color_texgen.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float4 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float4 tc0;\n"
		"	tc0.x = dot4( vertex.position, rpTexGen0S );\n"
		"	tc0.y = dot4( vertex.position, rpTexGen0T );\n"
		"\n"
		"	tc0.z = 0.0f;\n"
		"	tc0.w = dot4( vertex.position, rpTexGen0Q ); \n"
		"\n"
		"	// multiply the texture matrix in\n"
		"	result.texcoord0.x = dot4( tc0, rpTextureMatrixS );\n"
		"	result.texcoord0.y = dot4( tc0, rpTextureMatrixT );\n"
		"	result.texcoord0.zw = tc0.zw;\n"
		"\n"
		"	// compute vertex modulation\n"
		"	float4 vertexColor = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"	result.color =  vertexColor * rpColor;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/vertex_color.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform sampler2D samp0 : register(s0);\n"
		"\n"
		"struct PS_IN\n"
		"{\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT\n"
		"{\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result )\n"
		"{\n"
		"	result.color = fragment.color;\n"
		"}\n"
		
	},
	
	{
		"renderprogs/vertex_color.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"Copyright (C) 2013 Robert Beckebans\n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT\n"
		"{\n"
		"	float4 position : POSITION;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result )\n"
		"{\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"	\n"
		"	result.color =  swizzleColor( vertex.color );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/wobblesky.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"uniform samplerCUBE samp0 : register(s0);\n"
		"\n"
		"struct PS_IN {\n"
		"	float4 position : VPOS;\n"
		"	float3 texcoord0 : TEXCOORD0_centroid;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct PS_OUT {\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( PS_IN fragment, out PS_OUT result ) {\n"
		"	result.color = texCUBE( samp0, fragment.texcoord0 ) * fragment.color;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/wobblesky.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"	float2 texcoord : TEXCOORD0;\n"
		"	float4 normal : NORMAL;\n"
		"	float4 tangent : TANGENT;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"	float3 texcoord0 : TEXCOORD0;\n"
		"	float4 color : COLOR0;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position.x = dot4( vertex.position, rpMVPmatrixX );\n"
		"	result.position.y = dot4( vertex.position, rpMVPmatrixY );\n"
		"	result.position.z = dot4( vertex.position, rpMVPmatrixZ );\n"
		"	result.position.w = dot4( vertex.position, rpMVPmatrixW );\n"
		"\n"
		"	float3 t0 = vertex.position.xyz - rpLocalViewOrigin.xyz;\n"
		"	result.texcoord0.x = dot3( t0, rpWobbleSkyX );\n"
		"	result.texcoord0.y = dot3( t0, rpWobbleSkyY );\n"
		"	result.texcoord0.z = dot3( t0, rpWobbleSkyZ );\n"
		"	\n"
		"	result.color = ( swizzleColor( vertex.color ) * rpVertexColorModulate ) + rpVertexColorAdd;\n"
		"}\n"
		"\n"
		
	},
	
	{
		"renderprogs/zcullReconstruct.pixel",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct PS_OUT {	\n"
		"	float depth : DEPTH;\n"
		"	float4 color : COLOR;\n"
		"};\n"
		"\n"
		"void main( out PS_OUT result ) {\n"
		"	result.depth = 1;\n"
		"	result.color = float4( 0.0, 0.0, 0.0, 0.0 );\n"
		"}\n"
		
	},
	
	{
		"renderprogs/zcullReconstruct.vertex",
		"/*\n"
		"===========================================================================\n"
		"\n"
		"Doom 3 BFG Edition GPL Source Code\n"
		"Copyright (C) 1993-2012 id Software LLC, a ZeniMax Media company. \n"
		"\n"
		"This file is part of the Doom 3 BFG Edition GPL Source Code (\"Doom 3 BFG Edition Source Code\").  \n"
		"\n"
		"Doom 3 BFG Edition Source Code is free software: you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation, either version 3 of the License, or\n"
		"(at your option) any later version.\n"
		"\n"
		"Doom 3 BFG Edition Source Code is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy of the GNU General Public License\n"
		"along with Doom 3 BFG Edition Source Code.  If not, see <http://www.gnu.org/licenses/>.\n"
		"\n"
		"In addition, the Doom 3 BFG Edition Source Code is also subject to certain additional terms. You should have received a copy of these additional terms immediately following the terms and conditions of the GNU General Public License which accompanied the Doom 3 BFG Edition Source Code.  If not, please request a copy in writing from id Software at the address below.\n"
		"\n"
		"If you have questions concerning this license or the applicable additional terms, you may contact in writing id Software LLC, c/o ZeniMax Media Inc., Suite 120, Rockville, Maryland 20850 USA.\n"
		"\n"
		"===========================================================================\n"
		"*/\n"
		"\n"
		"#include \"renderprogs/global.inc\"\n"
		"\n"
		"struct VS_IN {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"struct VS_OUT {\n"
		"	float4 position : POSITION;\n"
		"};\n"
		"\n"
		"void main( VS_IN vertex, out VS_OUT result ) {\n"
		"	result.position = vertex.position;\n"
		"	result.position.z = -1.0;\n"
		"}\n"
		
	},
	
	{0, 0},
	
};
