% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fov.R
\name{FOV-methods}
\alias{FOV-methods}
\alias{Cells.FOV}
\alias{Features.FOV}
\alias{FetchData.FOV}
\alias{GetTissueCoordinates.FOV}
\alias{Keys.FOV}
\alias{RenameCells.FOV}
\alias{$.FOV}
\alias{[.FOV}
\alias{[[.FOV}
\alias{length.FOV}
\alias{names.FOV}
\alias{subset.FOV}
\alias{[[<-,FOV,character,missing,Centroids-method}
\alias{[[<-,FOV,character,missing,Molecules-method}
\alias{[[<-,FOV,character,missing,NULL-method}
\alias{[[<-,FOV,character,missing,Segmentation-method}
\alias{show,FOV-method}
\title{\code{FOV} Methods}
\usage{
\method{Cells}{FOV}(x, boundary = NULL, ...)

\method{Features}{FOV}(x, set = NULL, ...)

\method{FetchData}{FOV}(object, vars, cells = NULL, simplify = TRUE, ...)

\method{GetTissueCoordinates}{FOV}(object, which = NULL, ...)

\method{Keys}{FOV}(object, ...)

\method{RenameCells}{FOV}(object, new.names = NULL, ...)

\method{$}{FOV}(x, i, ...)

\method{[}{FOV}(x, i, j, ...)

\method{[[}{FOV}(x, i, ...)

\method{length}{FOV}(x)

\method{names}{FOV}(x)

\method{subset}{FOV}(x, cells = NULL, features = NULL, ...)

\S4method{[[}{FOV,character,missing,Centroids}(x, i, j, ...) <- value

\S4method{[[}{FOV,character,missing,Molecules}(x, i, j, ...) <- value

\S4method{[[}{FOV,character,missing,NULL}(x, i, j, ...) <- value

\S4method{[[}{FOV,character,missing,Segmentation}(x, i, j, ...) <- value

\S4method{show}{FOV}(object)
}
\arguments{
\item{x, object}{A \code{\link{FOV}} object}

\item{boundary, set}{Name of segmentation boundary or molecule set  to
extract cell or feature names for; pass \code{NA} to return all
cells or feature names}

\item{...}{Arguments passed to other methods}

\item{vars}{A vector of variables to fetch; can be the name of a
segmentation boundary, to get tissue coordinates, or molecule names,
to get molecule coordinates}

\item{simplify}{If only returning either boundary or molecule coordinates,
return a single data frame instead of a list}

\item{which}{Name of segmentation boundary or molecule set}

\item{new.names}{vector of new cell names}

\item{i, cells}{For \code{[[} and \code{[[<-}, the name of a segmentation or
\dQuote{molecules}; for \code{FetchData}, \code{subset}. and \code{[}, a
vector of cells to keep}

\item{j, features}{For \code{subset} and \code{[}, a vector of features to
keep; for \code{[[<-}, not used}

\item{value}{For \code{[[<-}, a replacement
\code{\link[SeuratObject:Molecules-class]{Molecules}},
\code{\link[SeuratObject:Centroids-class]{Centroids}}, or
\code{\link[SeuratObject:Segmentation-class]{Segmentation}} object;
otherwise \code{NULL} to remove the boundary stored at \code{i}}
}
\value{
\code{Cells}: A vector of cell names

\code{Features}: A vector of spatially-resolved molecule names;
if no molecular information present, returns \code{NULL}

\code{FetchData}: If both molecule and boundary coordinates are
requested, then a two-length list:
\itemize{
 \item \dQuote{\code{molecules}}: A data frame with the molecule coordinates
  requested. If molecules requested are keyed, the keys are preserved in the
  data frame
 \item \dQuote{\code{coordinates}}: A data frame with coordinates from the
  segmentation boundaries requested
}
If \code{simplify} is \code{TRUE} and only one data frame is generated, then
only the data frame is returned. Otherwise, a one-length list is returned
with the single data frame generated

\code{GetTissueCoordinates}: ...

\code{Keys}: A named vector of molecule set keys; names are the
names of the molecule sets and values are the keys for the respective
molecule set

\code{RenameCells}: \code{object} with the cells renamed to
\code{new.names}

\code{$}, \code{[[}: The segmentation boundary or spatially-resolved
molecule information stored at \code{i}

\code{length}: The number of segmentation layers
(\code{\link[SeuratObject:Segmentation-class]{Segmentation}} or
\code{\link[SeuratObject:Centroids-class]{Centroids}} objects)

\code{names}: A vector of segmentation boundary and molecule set names

\code{subset}: \code{x} with just the cells and features specified

\code{[[<-}: Varies depending on the class of \code{value}:
\itemize{
 \item If \code{value} is \code{NULL}, returns \code{x} with the boundary
 \code{i} removed; also allows removing \code{molecules}; does not allow
 removing the default segmentation
 \item If \code{value} is a \code{Molecules}, returns \code{x} with
 \code{value} stored in \code{molecules}; requires that \code{i} is
 \dQuote{molecules}
 \item Otherwise, stores \code{value} as a segmentation boundary named \code{i}
}

\code{show}: Invisibly returns \code{NULL}
}
\description{
Methods for \code{\link{FOV}} objects
}
\details{
The following methods are defined for interacting with a
\code{FOV} object:

\code{Cells}: Get cell names

\code{Features}: Get spatially-resolved molecule names

\code{FetchData}: Fetch boundary and/or molecule coordinates from
a \code{FOV} object

\code{GetTissueCoordinates}: Get boundary or molecule
coordinates from a \code{FOV} object

\code{Keys}: Get the keys of molecule sets contained within a
\code{FOV} object

\code{RenameCells}: Update cell names

\code{$}, \code{[[}: Extract a segmentation boundary

\code{length}: Get the number of segmentation layers in a
\code{FOV} object

\code{names}: Get the names of segmentation layers and molecule sets

\code{subset}, \code{[}: Subset a \code{FOV} object

\code{[[<-}: Add or remove segmentation layers and molecule
information to/from a \code{FOV} object

\code{show}: Display an object summary to stdout
}
\seealso{
\code{\link{FOV-class}}
}
\concept{fov}
