% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{LoadSTARmap}
\alias{LoadSTARmap}
\title{Load STARmap data}
\usage{
LoadSTARmap(
  data.dir,
  counts.file = "cell_barcode_count.csv",
  gene.file = "genes.csv",
  qhull.file = "qhulls.tsv",
  centroid.file = "centroids.tsv",
  assay = "Spatial",
  image = "image"
)
}
\arguments{
\item{data.dir}{location of data directory that contains the counts matrix,
gene name, qhull, and centroid files.}

\item{counts.file}{name of file containing the counts matrix (csv)}

\item{gene.file}{name of file containing the gene names (csv)}

\item{qhull.file}{name of file containing the hull coordinates (tsv)}

\item{centroid.file}{name of file containing the centroid positions (tsv)}

\item{assay}{Name of assay to associate spatial data to}

\item{image}{Name of "image" object storing spatial coordinates}
}
\value{
A \code{\link{Seurat}} object
}
\description{
Load STARmap data
}
\seealso{
\code{\link{STARmap}}
}
\concept{preprocessing}
