% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{HTODemux}
\alias{HTODemux}
\title{Demultiplex samples based on data from cell 'hashing'}
\usage{
HTODemux(
  object,
  assay = "HTO",
  positive.quantile = 0.99,
  init = NULL,
  nstarts = 100,
  kfunc = "clara",
  nsamples = 100,
  seed = 42,
  verbose = TRUE
)
}
\arguments{
\item{object}{Seurat object. Assumes that the hash tag oligo (HTO) data has been added and normalized.}

\item{assay}{Name of the Hashtag assay (HTO by default)}

\item{positive.quantile}{The quantile of inferred 'negative' distribution for each hashtag - over which the cell is considered 'positive'. Default is 0.99}

\item{init}{Initial number of clusters for hashtags. Default is the # of hashtag oligo names + 1 (to account for negatives)}

\item{nstarts}{nstarts value for k-means clustering (for kfunc = "kmeans"). 100 by default}

\item{kfunc}{Clustering function for initial hashtag grouping. Default is "clara" for fast k-medoids clustering on large applications, also support "kmeans" for kmeans clustering}

\item{nsamples}{Number of samples to be drawn from the dataset used for clustering, for kfunc = "clara"}

\item{seed}{Sets the random seed. If NULL, seed is not set}

\item{verbose}{Prints the output}
}
\value{
The Seurat object with the following demultiplexed information stored in the meta data:
\describe{
  \item{hash.maxID}{Name of hashtag with the highest signal}
  \item{hash.secondID}{Name of hashtag with the second highest signal}
  \item{hash.margin}{The difference between signals for hash.maxID and hash.secondID}
  \item{classification}{Classification result, with doublets/multiplets named by the top two highest hashtags}
  \item{classification.global}{Global classification result (singlet, doublet or negative)}
  \item{hash.ID}{Classification result where doublet IDs are collapsed}
}
}
\description{
Assign sample-of-origin for each cell, annotate doublets.
}
\examples{
\dontrun{
object <- HTODemux(object)
}

}
\seealso{
\code{\link{HTOHeatmap}}
}
\concept{preprocessing}
