% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-number-si.R
\name{label_number_si}
\alias{label_number_si}
\title{Label numbers with SI prefixes (2k, 1M, 5T etc)}
\usage{
label_number_si(accuracy = 1, unit = NULL, sep = NULL, ...)
}
\arguments{
\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{unit}{Optional units specifier.}

\item{sep}{Separator between number and SI unit. Defaults to \code{" "} if
\code{units} is supplied, and \code{""} if not.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
\code{number_si()} automatically scales and labels with the best SI prefix,
"K" for values \eqn{\ge} 10e3, "M" for \eqn{\ge} 10e6,
"B" for \eqn{\ge} 10e9, and "T" for \eqn{\ge} 10e12.
}
\examples{
demo_continuous(c(1, 1e9), label = label_number_si())
demo_continuous(c(1, 5000), label = label_number_si(unit = "g"))
demo_continuous(c(1, 1000), label = label_number_si(unit = "m"))

demo_log10(c(1, 1e9), breaks = log_breaks(10), labels = label_number_si())
}
\seealso{
Other labels for continuous scales: 
\code{\link{label_bytes}()},
\code{\link{label_dollar}()},
\code{\link{label_number_auto}()},
\code{\link{label_ordinal}()},
\code{\link{label_parse}()},
\code{\link{label_percent}()},
\code{\link{label_pvalue}()},
\code{\link{label_scientific}()}

Other labels for log scales: 
\code{\link{label_bytes}()},
\code{\link{label_scientific}()}
}
\concept{labels for continuous scales}
\concept{labels for log scales}
