% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{summary.recipe}
\alias{summary.recipe}
\title{Summarize a Recipe}
\usage{
\method{summary}{recipe}(object, original = FALSE, ...)
}
\arguments{
\item{object}{A \code{recipe} object}

\item{original}{A logical: show the current set of variables or the original
set when the recipe was defined.}

\item{...}{further arguments passed to or from other methods (not currently
used).}
}
\value{
A tibble with columns \code{variable}, \code{type}, \code{role},
  and \code{source}.
}
\description{
This function prints the current set of variables/features and some of their
  characteristics.
}
\details{
Note that, until the recipe has been trained, the currrent and
  original variables are the same.
}
\examples{
rec <- recipe( ~ ., data = USArrests)
summary(rec)
rec <- step_pca(rec, all_numeric(), num = 3)
summary(rec) # still the same since not yet trained
rec <- prep(rec, training = USArrests)
summary(rec)
}
\seealso{
\code{\link{recipe}} \code{\link{prep.recipe}}
}
