% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lincombo.R
\name{step_lincomb}
\alias{step_lincomb}
\title{Linear Combination Filter}
\usage{
step_lincomb(recipe, ..., role = NA, trained = FALSE, max_steps = 5,
  removals = NULL)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are 
affected by the step. See \code{\link{selections}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{max_steps}{A value .}

\item{removals}{A character string that contains the names of columns that
should be removed. These values are not determined until
\code{\link{prep.recipe}} is called.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_lincomb} creates a \emph{specification} of a recipe step that
  will potentially remove numeric variables that have linear combinations
  between them.
}
\details{
This step finds exact linear combinations between two or more
  variables and recommends which column(s) should be removed to resolve the
  issue. This algorithm may need to be applied multiple times (as defined
  by \code{max_steps}).
}
\examples{
data(biomass)

biomass$new_1 <- with(biomass,
                      .1*carbon - .2*hydrogen + .6*sulfur)
biomass$new_2 <- with(biomass,
                      .5*carbon - .2*oxygen + .6*nitrogen)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen +
                sulfur + new_1 + new_2,
              data = biomass_tr)

lincomb_filter <- rec \%>\%
  step_lincomb(all_predictors())
  
prep(lincomb_filter, training = biomass_tr)
}
\seealso{
\code{\link{step_nzv}}\code{\link{step_corr}}
  \code{\link{recipe}} \code{\link{prep.recipe}}
  \code{\link{bake.recipe}}
}
\author{
Max Kuhn, Kirk Mettler, and Jed Wing
}
\concept{
preprocessing variable_filters
}
\keyword{datagen}
