% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperbolic.R
\name{step_hyperbolic}
\alias{step_hyperbolic}
\title{Hyperbolic Transformations}
\usage{
step_hyperbolic(recipe, ..., role = NA, trained = FALSE, func = "sin",
  inverse = TRUE, columns = NULL)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are 
affected by the step. See \code{\link{selections}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{func}{A character value for the function. Valid values are "sin",
"cos", or "tan".}

\item{inverse}{A logical: should the inverse function be used?}

\item{columns}{A character string of variable names that will be (eventually)
populated by the \code{terms} argument.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_hyperbolic} creates a \emph{specification} of a recipe step that
  will transform data using a hyperbolic function.
}
\examples{
set.seed(313)
examples <- matrix(rnorm(40), ncol = 2)
examples <- as.data.frame(examples)

rec <- recipe(~ V1 + V2, data = examples)

cos_trans <- rec  \%>\%
  step_hyperbolic(all_predictors(),
                  func = "cos", inverse = FALSE)

cos_obj <- prep(cos_trans, training = examples)

transformed_te <- bake(cos_obj, examples)
plot(examples$V1, transformed_te$V1)
}
\seealso{
\code{\link{step_logit}} \code{\link{step_invlogit}}
  \code{\link{step_log}}  \code{\link{step_sqrt}} \code{\link{recipe}}
  \code{\link{prep.recipe}} \code{\link{bake.recipe}}
}
\concept{
preprocessing transformation_methods
}
\keyword{datagen}
