% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateParamExpressions.R
\name{evaluateParamExpressions}
\alias{evaluateParamExpressions}
\title{Evaluates all expressions within a parameter.}
\usage{
evaluateParamExpressions(obj, dict = NULL)
}
\arguments{
\item{obj}{(\code{\link[=Param]{Param()}} | \code{ParamHelpers::ParamSet()} | \code{list})\cr
Parameter, parameter set or list of parameter values. Expressions within
\code{len}, \code{lower} or \code{upper} boundaries, \code{default} or \code{values} will be
evaluated using the provided dictionary (\code{dict}).}

\item{dict}{(\code{environment} | \link{list} | \code{NULL})\cr
Environment or list which will be used for evaluating the variables of
expressions within a parameter, parameter set or list of parameters. The
default is \code{NULL}.}
}
\value{
[\code{\link[=Param]{Param()}} | \code{ParamHelpers::ParamSet()} | \code{list}].
}
\description{
Evaluates the expressions of a parameter, parameter set or list
of parameters for a given dictionary.
}
\examples{
ps = makeParamSet(
  makeNumericParam("x", lower = expression(p), upper = expression(ceiling(3 * p))),
  makeIntegerParam("y", lower = 1, upper = 2)
)
evaluateParamExpressions(ps, dict = list(p = 3))

ps = makeParamSet(
  makeNumericParam("x", default = expression(sum(data$Species == "setosa"))),
  makeIntegerParam("y", lower = 1, upper = 2),
  keys = c("data", "Species")
)
evaluateParamExpressions(ps, dict = list(data = iris))

par.vals = list(
  x = expression(k),
  y = 5
)
evaluateParamExpressions(par.vals, dict = list(k = 3))
}
