% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array.R
\name{nanoarrow_array_init}
\alias{nanoarrow_array_init}
\alias{nanoarrow_array_set_schema}
\alias{nanoarrow_array_modify}
\title{Modify nanoarrow arrays}
\usage{
nanoarrow_array_init(schema)

nanoarrow_array_set_schema(array, schema, validate = TRUE)

nanoarrow_array_modify(array, new_values, validate = TRUE)
}
\arguments{
\item{schema}{A \link[=as_nanoarrow_schema]{nanoarrow_schema} to attach to this
\code{array}.}

\item{array}{A \link[=as_nanoarrow_array]{nanoarrow_array}.}

\item{validate}{Use \code{FALSE} to skip validation. Skipping validation may
result in creating an array that will crash R.}

\item{new_values}{A named \code{list()} of values to replace.}
}
\value{
\itemize{
\item \code{nanoarrow_array_init()} returns a possibly invalid but initialized
array with a given \code{schema}.
\item \code{nanoarrow_array_set_schema()} returns \code{array}, invisibly. Note that
\code{array} is modified in place by reference.
\item \code{nanoarrow_array_modify()} returns a shallow copy of \code{array} with the
modified parameters such that the original array remains valid.
}
}
\description{
Create a new array or from an existing array, modify one or more parameters.
When importing an array from elsewhere, \code{nanoarrow_array_set_schema()} is
useful to attach the data type information to the array (without this
information there is little that nanoarrow can do with the array since its
content cannot be otherwise interpreted). \code{nanoarrow_array_modify()} can
create a shallow copy and modify various parameters to create a new array,
including setting children and buffers recursively. These functions power the
\verb{$<-} operator, which can modify one parameter at a time.
}
\examples{
nanoarrow_array_init(na_string())

# Modify an array using $ and <-
array <- as_nanoarrow_array(1:5)
array$length <- 4
as.vector(array)

# Modify potentially more than one component at a time
array <- as_nanoarrow_array(1:5)
as.vector(nanoarrow_array_modify(array, list(length = 4)))

# Attach a schema to an array
array <- as_nanoarrow_array(-1L)
nanoarrow_array_set_schema(array, na_uint32())
as.vector(array)

}
