% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_images.r
\name{display_<image>}
\alias{display_<image>}
\alias{display_png}
\alias{display_jpeg}
\alias{display_pdf}
\alias{display_svg}
\title{Display a specific image output}
\usage{
display_png(data = NULL, file = NULL, width = NULL, height = NULL)

display_jpeg(data = NULL, file = NULL, width = NULL, height = NULL)

display_pdf(data = NULL, file = NULL, width = NULL, height = NULL)

display_svg(data = NULL, file = NULL, width = NULL, height = NULL)
}
\arguments{
\item{data}{The data as a \code{\link[base]{raw}} vector (\code{\link[base]{character}} vector for \code{display_svg})}

\item{file}{The path to a file or a \code{\link[base]{connection}} containing the content}

\item{width}{The width to display the image}

\item{height}{The height to display the image}
}
\description{
Either \code{data} or \code{file} must be passed.
}
\examples{
\dontrun{## (Run inside of an IRkernel)
display_png(file = 'image.png')
display_svg('
<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1 -1 2 2">
  <circle r="1"/>
</svg>
')
display_jpeg(file = url('https://dummyimage.com/600x400.jpg', 'wb'), width = 100)}

}
\seealso{
\code{\link{display_<text>}}
}
