% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrink.gbm.R
\name{shrink.gbm}
\alias{shrink.gbm}
\title{L1 shrinkage of the predictor variables in a GBM}
\usage{
shrink.gbm(object, n.trees, lambda = rep(10, length(object$var.names)),
  ...)
}
\arguments{
\item{object}{A \code{\link{gbm.object}}.}

\item{n.trees}{Integer specifying the number of trees to use.}

\item{lambda}{Vector of length equal to the number of variables containing 
the shrinkage parameter for each variable.}

\item{\dots}{Additional optional arguments. (Currently ignored.)}
}
\value{
\item{predF}{Predicted values from the shrunken tree}
\item{objective}{The value of the loss function associated with the
predicted values} \item{gradient}{A vector with length equal to the number
of variables containing the derivative of the objective function with
respect to beta, the logit transform of the shrinkage parameter for each
variable}
}
\description{
Performs recursive shrinkage in each of the trees in a GBM fit using
different shrinkage parameters for each variable.
}
\details{
This function is currently experimental. Used in conjunction with a gradient
ascent search for inclusion of variables.
}
\note{
Warning: This function is experimental.
}
\references{
Hastie, T. J., and Pregibon, D.
\url{https://web.stanford.edu/~hastie/Papers/shrink_tree.pdf}. AT&T Bell 
Laboratories Technical Report (March 1990).
}
\seealso{
\code{\link{shrink.gbm.pred}}, \code{\link{gbm}}
}
\author{
Greg Ridgeway \email{gregridgeway@gmail.com}
}
\keyword{methods}
