% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_vif.R
\name{interpret_vif}
\alias{interpret_vif}
\title{Interpret the Variance Inflation Factor (VIF)}
\usage{
interpret_vif(vif, rules = "default")
}
\arguments{
\item{vif}{Value or vector of VIFs.}

\item{rules}{Can be \code{"default"} or a custom set of \code{\link[=rules]{rules()}}.}
}
\description{
Interpret VIF index of multicollinearity.
}
\section{Rules}{

\itemize{
\item Default
\itemize{
\item \strong{VIF < 5} - Low
\item \strong{5 <= VIF < 10} - Moderate
\item \strong{VIF >= 10} - High
}
}
}

\examples{

interpret_vif(c(1.4, 30.4))

}
