% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-conditions.R
\name{format_error}
\alias{format_error}
\alias{format_warning}
\alias{format_message}
\title{Format an error, warning or diagnostic message}
\usage{
format_error(message, .envir = parent.frame())

format_warning(message, .envir = parent.frame())

format_message(message, .envir = parent.frame())
}
\arguments{
\item{message}{It is formatted via a call to \code{\link[=cli_bullets]{cli_bullets()}}.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
You can then throw this message with \code{\link[=stop]{stop()}} or \code{rlang::abort()}.
}
\details{
The messages can use inline styling, pluralization and glue
substitutions.\if{html}{\out{<div class="sourceCode r">}}\preformatted{n <- "boo"
stop(format_error(c(
        "\{.var n\} must be a numeric vector",
  "x" = "You've supplied a \{.cls \{class(n)\}\} vector."
)))
}\if{html}{\out{</div>}}

\if{html}{\figure{format-error.svg}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{len <- 26
idx <- 100
stop(format_error(c(
        "Must index an existing element:",
  "i" = "There \{?is/are\} \{len\} element\{?s\}.",
  "x" = "You've tried to subset element \{idx\}."
)))
}\if{html}{\out{</div>}}

\if{html}{\figure{format-error-2.svg}}
}
