% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_tidiers.R
\name{tidy_ggpredict}
\alias{tidy_ggpredict}
\title{Marginal Predictions with \code{ggeffects::ggpredict()}}
\usage{
tidy_ggpredict(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{a model}

\item{conf.int}{logical indicating whether or not to include a confidence
interval in the tidied output}

\item{conf.level}{the confidence level to use for the confidence interval}

\item{...}{additional parameters passed to \code{ggeffects::ggpredict()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Use \code{ggeffects::ggpredict()} to estimate marginal predictions
and return a tibble tidied in a way that it could be used by \code{broom.helpers}
functions.
See \url{https://strengejacke.github.io/ggeffects/} for a list of supported
models.
}
\details{
By default, \code{ggeffects::ggpredict()} estimate marginal predictions at the
observed mean of continuous variables and at the first modality of categorical
variables (regardless of the type of contrasts used in the model).

For more information, see \code{vignette("marginal_tidiers", "broom.helpers")}.
}
\note{
By default, \code{ggeffects::ggpredict()} estimates marginal predictions for each
individual variable, regardless of eventual interactions.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  tidyr::uncount(n) \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
mod <- glm(
  Survived ~ Class + Age + Sex,
  data = df, family = binomial
)
tidy_ggpredict(mod)
tidy_plus_plus(mod, tidy_fun = tidy_ggpredict)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{ggeffects::ggpredict()}

Other marginal_tieders: 
\code{\link{tidy_all_effects}()},
\code{\link{tidy_avg_comparisons}()},
\code{\link{tidy_avg_slopes}()},
\code{\link{tidy_marginal_contrasts}()},
\code{\link{tidy_marginal_means}()},
\code{\link{tidy_marginal_predictions}()},
\code{\link{tidy_margins}()}
}
\concept{marginal_tieders}
