% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitsort.R
\name{quicksort2}
\alias{quicksort2}
\title{Low-level sorting: binary quicksort}
\usage{
quicksort2(x, na.last = NA)
}
\arguments{
\item{x}{an integer vector}

\item{na.last}{\code{NA} removes NAs, \code{FALSE} puts NAs at the beginning,
\code{TRUE} puts NAs at the end}
}
\value{
a sorted vector
}
\description{
In one pass over the vector \code{NA}s are handled according to parameter
\code{na.last} by \code{\link[=range_sortna]{range_sortna()}}, then, if the vector is unsorted,
binary quicksort is invoked.
}
\examples{
quicksort2(c(2L, 0L, 1L, NA, 2L))
quicksort2(c(2L, 0L, 1L, NA, 2L), na.last=TRUE)
quicksort2(c(2L, 0L, 1L, NA, 2L), na.last=FALSE)
}
