
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_ProgressRange.hxx>
#include <RWGltf_GltfOStreamWriter.hxx>
#include <RWGltf_GltfMaterialMap.hxx>
#include <RWGltf_GltfSceneNodeMap.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWGltf_GltfPrimArrayData.hxx>
#include <RWGltf_MaterialMetallicRoughness.hxx>
#include <RWGltf_MaterialCommon.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWGltf_GltfOStreamWriter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Image_Texture.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWGltf_GltfLatePrimitiveArray.hxx>
#include <RWGltf_GltfPrimArrayData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <RWGltf_CafReader.hxx>
#include <RWGltf_CafWriter.hxx>
#include <RWGltf_ConfigurationNode.hxx>
#include <RWGltf_DracoParameters.hxx>
#include <RWGltf_GltfAccessor.hxx>
#include <RWGltf_GltfAccessorCompType.hxx>
#include <RWGltf_GltfAccessorLayout.hxx>
#include <RWGltf_GltfAlphaMode.hxx>
#include <RWGltf_GltfArrayType.hxx>
#include <RWGltf_GltfBufferView.hxx>
#include <RWGltf_GltfBufferViewTarget.hxx>
#include <RWGltf_GltfFace.hxx>
#include <RWGltf_GltfJsonParser.hxx>
#include <RWGltf_GltfLatePrimitiveArray.hxx>
#include <RWGltf_GltfMaterialMap.hxx>
#include <RWGltf_GltfOStreamWriter.hxx>
#include <RWGltf_GltfPrimArrayData.hxx>
#include <RWGltf_GltfPrimitiveMode.hxx>
#include <RWGltf_GltfRootElement.hxx>
#include <RWGltf_GltfSceneNodeMap.hxx>
#include <RWGltf_MaterialCommon.hxx>
#include <RWGltf_MaterialMetallicRoughness.hxx>
#include <RWGltf_Provider.hxx>
#include <RWGltf_TriangulationReader.hxx>
#include <RWGltf_WriterTrsfFormat.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <istream>
#include <DE_ConfigurationContext.hxx>
#include <XSControl_WorkSession.hxx>
using std::basic_istream;
using rapidjson::BasicOStreamWrapper;

// Module definiiton
void register_RWGltf(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("RWGltf"));
py::object klass;

//Python trampoline classes

// classes

    // Class RWGltf_CafReader from ./opencascade/RWGltf_CafReader.hxx
    klass = m.attr("RWGltf_CafReader");


    // nested enums

    static_cast<py::class_<RWGltf_CafReader ,opencascade::handle<RWGltf_CafReader>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("ToParallel",
             (bool (RWGltf_CafReader::*)() const) static_cast<bool (RWGltf_CafReader::*)() const>(&RWGltf_CafReader::ToParallel),
             R"#(Return TRUE if multithreaded optimizations are allowed; FALSE by default.)#" 
          )
        .def("SetParallel",
             (void (RWGltf_CafReader::*)( bool  ) ) static_cast<void (RWGltf_CafReader::*)( bool  ) >(&RWGltf_CafReader::SetParallel),
             R"#(Setup multithreaded execution.)#"  , py::arg("theToParallel")
          )
        .def("ToSkipEmptyNodes",
             (bool (RWGltf_CafReader::*)() ) static_cast<bool (RWGltf_CafReader::*)() >(&RWGltf_CafReader::ToSkipEmptyNodes),
             R"#(Return TRUE if Nodes without Geometry should be ignored, TRUE by default.)#" 
          )
        .def("SetSkipEmptyNodes",
             (void (RWGltf_CafReader::*)( bool  ) ) static_cast<void (RWGltf_CafReader::*)( bool  ) >(&RWGltf_CafReader::SetSkipEmptyNodes),
             R"#(Set flag to ignore nodes without Geometry.)#"  , py::arg("theToSkip")
          )
        .def("ToLoadAllScenes",
             (bool (RWGltf_CafReader::*)() const) static_cast<bool (RWGltf_CafReader::*)() const>(&RWGltf_CafReader::ToLoadAllScenes),
             R"#(Return TRUE if all scenes in the document should be loaded, FALSE by default which means only main (default) scene will be loaded.)#" 
          )
        .def("SetLoadAllScenes",
             (void (RWGltf_CafReader::*)( bool  ) ) static_cast<void (RWGltf_CafReader::*)( bool  ) >(&RWGltf_CafReader::SetLoadAllScenes),
             R"#(Set flag to flag to load all scenes in the document, FALSE by default which means only main (default) scene will be loaded.)#"  , py::arg("theToLoadAll")
          )
        .def("ToUseMeshNameAsFallback",
             (bool (RWGltf_CafReader::*)() ) static_cast<bool (RWGltf_CafReader::*)() >(&RWGltf_CafReader::ToUseMeshNameAsFallback),
             R"#(Set flag to use Mesh name in case if Node name is empty, TRUE by default.)#" 
          )
        .def("SetMeshNameAsFallback",
             (void (RWGltf_CafReader::*)( bool  ) ) static_cast<void (RWGltf_CafReader::*)( bool  ) >(&RWGltf_CafReader::SetMeshNameAsFallback),
             R"#(Set flag to use Mesh name in case if Node name is empty.)#"  , py::arg("theToFallback")
          )
        .def("IsDoublePrecision",
             (bool (RWGltf_CafReader::*)() const) static_cast<bool (RWGltf_CafReader::*)() const>(&RWGltf_CafReader::IsDoublePrecision),
             R"#(Return flag to fill in triangulation using double or single precision; FALSE by default.)#" 
          )
        .def("SetDoublePrecision",
             (void (RWGltf_CafReader::*)( bool  ) ) static_cast<void (RWGltf_CafReader::*)( bool  ) >(&RWGltf_CafReader::SetDoublePrecision),
             R"#(Set flag to fill in triangulation using double or single precision.)#"  , py::arg("theIsDouble")
          )
        .def("ToSkipLateDataLoading",
             (bool (RWGltf_CafReader::*)() ) static_cast<bool (RWGltf_CafReader::*)() >(&RWGltf_CafReader::ToSkipLateDataLoading),
             R"#(Returns TRUE if data loading should be skipped and can be performed later; FALSE by default.)#" 
          )
        .def("SetToSkipLateDataLoading",
             (void (RWGltf_CafReader::*)( bool  ) ) static_cast<void (RWGltf_CafReader::*)( bool  ) >(&RWGltf_CafReader::SetToSkipLateDataLoading),
             R"#(Sets flag to skip data loading.)#"  , py::arg("theToSkip")
          )
        .def("ToKeepLateData",
             (bool (RWGltf_CafReader::*)() ) static_cast<bool (RWGltf_CafReader::*)() >(&RWGltf_CafReader::ToKeepLateData),
             R"#(Returns TRUE if data should be loaded into itself without its transfering to new structure. It allows to keep information about deferred storage to load/unload this data later. TRUE by default.)#" 
          )
        .def("SetToKeepLateData",
             (void (RWGltf_CafReader::*)( bool  ) ) static_cast<void (RWGltf_CafReader::*)( bool  ) >(&RWGltf_CafReader::SetToKeepLateData),
             R"#(Sets flag to keep information about deferred storage to load/unload data later.)#"  , py::arg("theToKeep")
          )
        .def("ToPrintDebugMessages",
             (bool (RWGltf_CafReader::*)() const) static_cast<bool (RWGltf_CafReader::*)() const>(&RWGltf_CafReader::ToPrintDebugMessages),
             R"#(Returns TRUE if additional debug information should be print; FALSE by default.)#" 
          )
        .def("SetToPrintDebugMessages",
             (void (RWGltf_CafReader::*)( const Standard_Boolean  ) ) static_cast<void (RWGltf_CafReader::*)( const Standard_Boolean  ) >(&RWGltf_CafReader::SetToPrintDebugMessages),
             R"#(Sets flag to print debug information.)#"  , py::arg("theToPrint")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWGltf_CafReader::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWGltf_CafReader::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWGltf_CafReader::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWGltf_CafReader::*)() const>(&RWGltf_CafReader::DynamicType),
             R"#(None)#"
             
         )
;

    // Class RWGltf_CafWriter from ./opencascade/RWGltf_CafWriter.hxx
    klass = m.attr("RWGltf_CafWriter");


    // nested enums

    static_cast<py::class_<RWGltf_CafWriter ,opencascade::handle<RWGltf_CafWriter>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString &,Standard_Boolean >()  , py::arg("theFile"),  py::arg("theIsBinary") )
    // custom constructors
    // methods
        .def("SetCoordinateSystemConverter",
             (void (RWGltf_CafWriter::*)( const RWMesh_CoordinateSystemConverter &  ) ) static_cast<void (RWGltf_CafWriter::*)( const RWMesh_CoordinateSystemConverter &  ) >(&RWGltf_CafWriter::SetCoordinateSystemConverter),
             R"#(Set transformation from OCCT to glTF coordinate system.)#"  , py::arg("theConverter")
          )
        .def("IsBinary",
             (bool (RWGltf_CafWriter::*)() const) static_cast<bool (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::IsBinary),
             R"#(Return flag to write into binary glTF format (.glb), specified within class constructor.)#" 
          )
        .def("TransformationFormat",
             (RWGltf_WriterTrsfFormat (RWGltf_CafWriter::*)() const) static_cast<RWGltf_WriterTrsfFormat (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::TransformationFormat),
             R"#(Return preferred transformation format for writing into glTF file; RWGltf_WriterTrsfFormat_Compact by default.)#" 
          )
        .def("SetTransformationFormat",
             (void (RWGltf_CafWriter::*)( RWGltf_WriterTrsfFormat  ) ) static_cast<void (RWGltf_CafWriter::*)( RWGltf_WriterTrsfFormat  ) >(&RWGltf_CafWriter::SetTransformationFormat),
             R"#(Set preferred transformation format for writing into glTF file.)#"  , py::arg("theFormat")
          )
        .def("NodeNameFormat",
             (RWMesh_NameFormat (RWGltf_CafWriter::*)() const) static_cast<RWMesh_NameFormat (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::NodeNameFormat),
             R"#(Return name format for exporting Nodes; RWMesh_NameFormat_InstanceOrProduct by default.)#" 
          )
        .def("SetNodeNameFormat",
             (void (RWGltf_CafWriter::*)( RWMesh_NameFormat  ) ) static_cast<void (RWGltf_CafWriter::*)( RWMesh_NameFormat  ) >(&RWGltf_CafWriter::SetNodeNameFormat),
             R"#(Set name format for exporting Nodes.)#"  , py::arg("theFormat")
          )
        .def("MeshNameFormat",
             (RWMesh_NameFormat (RWGltf_CafWriter::*)() const) static_cast<RWMesh_NameFormat (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::MeshNameFormat),
             R"#(Return name format for exporting Meshes; RWMesh_NameFormat_Product by default.)#" 
          )
        .def("SetMeshNameFormat",
             (void (RWGltf_CafWriter::*)( RWMesh_NameFormat  ) ) static_cast<void (RWGltf_CafWriter::*)( RWMesh_NameFormat  ) >(&RWGltf_CafWriter::SetMeshNameFormat),
             R"#(Set name format for exporting Meshes.)#"  , py::arg("theFormat")
          )
        .def("IsForcedUVExport",
             (bool (RWGltf_CafWriter::*)() const) static_cast<bool (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::IsForcedUVExport),
             R"#(Return TRUE to export UV coordinates even if there are no mapped texture; FALSE by default.)#" 
          )
        .def("SetForcedUVExport",
             (void (RWGltf_CafWriter::*)( bool  ) ) static_cast<void (RWGltf_CafWriter::*)( bool  ) >(&RWGltf_CafWriter::SetForcedUVExport),
             R"#(Set flag to export UV coordinates even if there are no mapped texture; FALSE by default.)#"  , py::arg("theToForce")
          )
        .def("SetDefaultStyle",
             (void (RWGltf_CafWriter::*)( const XCAFPrs_Style &  ) ) static_cast<void (RWGltf_CafWriter::*)( const XCAFPrs_Style &  ) >(&RWGltf_CafWriter::SetDefaultStyle),
             R"#(Set default material definition to be used for nodes with only color defined.)#"  , py::arg("theStyle")
          )
        .def("ToEmbedTexturesInGlb",
             (Standard_Boolean (RWGltf_CafWriter::*)() ) static_cast<Standard_Boolean (RWGltf_CafWriter::*)() >(&RWGltf_CafWriter::ToEmbedTexturesInGlb),
             R"#(Return flag to write image textures into GLB file (binary gltf export); TRUE by default. When set to FALSE, texture images will be written as separate files. Has no effect on writing into non-binary format.)#" 
          )
        .def("SetToEmbedTexturesInGlb",
             (void (RWGltf_CafWriter::*)( Standard_Boolean  ) ) static_cast<void (RWGltf_CafWriter::*)( Standard_Boolean  ) >(&RWGltf_CafWriter::SetToEmbedTexturesInGlb),
             R"#(Set flag to write image textures into GLB file (binary gltf export).)#"  , py::arg("theToEmbedTexturesInGlb")
          )
        .def("ToMergeFaces",
             (bool (RWGltf_CafWriter::*)() const) static_cast<bool (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::ToMergeFaces),
             R"#(Return flag to merge faces within a single part; FALSE by default.)#" 
          )
        .def("SetMergeFaces",
             (void (RWGltf_CafWriter::*)( bool  ) ) static_cast<void (RWGltf_CafWriter::*)( bool  ) >(&RWGltf_CafWriter::SetMergeFaces),
             R"#(Set flag to merge faces within a single part. May reduce JSON size thanks to smaller number of primitive arrays.)#"  , py::arg("theToMerge")
          )
        .def("ToSplitIndices16",
             (bool (RWGltf_CafWriter::*)() const) static_cast<bool (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::ToSplitIndices16),
             R"#(Return flag to prefer keeping 16-bit indexes while merging face; FALSE by default.)#" 
          )
        .def("SetSplitIndices16",
             (void (RWGltf_CafWriter::*)( bool  ) ) static_cast<void (RWGltf_CafWriter::*)( bool  ) >(&RWGltf_CafWriter::SetSplitIndices16),
             R"#(Set flag to prefer keeping 16-bit indexes while merging face. Has effect only with ToMergeFaces() option turned ON. May reduce binary data size thanks to smaller triangle indexes.)#"  , py::arg("theToSplit")
          )
        .def("ToParallel",
             (bool (RWGltf_CafWriter::*)() const) static_cast<bool (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::ToParallel),
             R"#(Return TRUE if multithreaded optimizations are allowed; FALSE by default.)#" 
          )
        .def("SetParallel",
             (void (RWGltf_CafWriter::*)( bool  ) ) static_cast<void (RWGltf_CafWriter::*)( bool  ) >(&RWGltf_CafWriter::SetParallel),
             R"#(Setup multithreaded execution.)#"  , py::arg("theToParallel")
          )
        .def("SetCompressionParameters",
             (void (RWGltf_CafWriter::*)( const RWGltf_DracoParameters &  ) ) static_cast<void (RWGltf_CafWriter::*)( const RWGltf_DracoParameters &  ) >(&RWGltf_CafWriter::SetCompressionParameters),
             R"#(Set Draco parameters)#"  , py::arg("theDracoParameters")
          )
        .def("Perform",
             (bool (RWGltf_CafWriter::*)( const opencascade::handle<TDocStd_Document> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Map<TCollection_AsciiString> * ,   const NCollection_IndexedDataMap<TCollection_AsciiString, TCollection_AsciiString> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_CafWriter::*)( const opencascade::handle<TDocStd_Document> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Map<TCollection_AsciiString> * ,   const NCollection_IndexedDataMap<TCollection_AsciiString, TCollection_AsciiString> & ,  const Message_ProgressRange &  ) >(&RWGltf_CafWriter::Perform),
             R"#(Write glTF file and associated binary file. Triangulation data should be precomputed within shapes!)#"  , py::arg("theDocument"),  py::arg("theRootLabels"),  py::arg("theLabelFilter"),  py::arg("theFileInfo"),  py::arg("theProgress")
          )
        .def("Perform",
             (bool (RWGltf_CafWriter::*)( const opencascade::handle<TDocStd_Document> & ,   const NCollection_IndexedDataMap<TCollection_AsciiString, TCollection_AsciiString> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_CafWriter::*)( const opencascade::handle<TDocStd_Document> & ,   const NCollection_IndexedDataMap<TCollection_AsciiString, TCollection_AsciiString> & ,  const Message_ProgressRange &  ) >(&RWGltf_CafWriter::Perform),
             R"#(Write glTF file and associated binary file. Triangulation data should be precomputed within shapes!)#"  , py::arg("theDocument"),  py::arg("theFileInfo"),  py::arg("theProgress")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWGltf_CafWriter::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWGltf_CafWriter::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWGltf_CafWriter::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::DynamicType),
             R"#(None)#"
             
         )
       .def("CoordinateSystemConverter",
             (const RWMesh_CoordinateSystemConverter & (RWGltf_CafWriter::*)() const) static_cast<const RWMesh_CoordinateSystemConverter & (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::CoordinateSystemConverter),
             R"#(Return transformation from OCCT to glTF coordinate system.)#"
             
         )
       .def("ChangeCoordinateSystemConverter",
             (RWMesh_CoordinateSystemConverter & (RWGltf_CafWriter::*)() ) static_cast<RWMesh_CoordinateSystemConverter & (RWGltf_CafWriter::*)() >(&RWGltf_CafWriter::ChangeCoordinateSystemConverter),
             R"#(Return transformation from OCCT to glTF coordinate system.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DefaultStyle",
             (const XCAFPrs_Style & (RWGltf_CafWriter::*)() const) static_cast<const XCAFPrs_Style & (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::DefaultStyle),
             R"#(Return default material definition to be used for nodes with only color defined.)#"
             
         )
       .def("CompressionParameters",
             (const RWGltf_DracoParameters & (RWGltf_CafWriter::*)() const) static_cast<const RWGltf_DracoParameters & (RWGltf_CafWriter::*)() const>(&RWGltf_CafWriter::CompressionParameters),
             R"#(Return Draco parameters)#"
             
         )
;

    // Class RWGltf_ConfigurationNode from ./opencascade/RWGltf_ConfigurationNode.hxx
    klass = m.attr("RWGltf_ConfigurationNode");


    // nested enums

    static_cast<py::class_<RWGltf_ConfigurationNode ,opencascade::handle<RWGltf_ConfigurationNode>  , DE_ConfigurationNode >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<RWGltf_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Load",
             (bool (RWGltf_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) ) static_cast<bool (RWGltf_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) >(&RWGltf_ConfigurationNode::Load),
             R"#(Updates values according the resource)#"  , py::arg("theResource")
          )
        .def("Save",
             (TCollection_AsciiString (RWGltf_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::Save),
             R"#(Writes configuration to the string)#" 
          )
        .def("Copy",
             (opencascade::handle<DE_ConfigurationNode> (RWGltf_ConfigurationNode::*)() const) static_cast<opencascade::handle<DE_ConfigurationNode> (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::Copy),
             R"#(Copies values of all fields)#" 
          )
        .def("BuildProvider",
             (opencascade::handle<DE_Provider> (RWGltf_ConfigurationNode::*)() ) static_cast<opencascade::handle<DE_Provider> (RWGltf_ConfigurationNode::*)() >(&RWGltf_ConfigurationNode::BuildProvider),
             R"#(Creates new provider for the own format)#" 
          )
        .def("IsImportSupported",
             (bool (RWGltf_ConfigurationNode::*)() const) static_cast<bool (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::IsImportSupported),
             R"#(Checks the import supporting)#" 
          )
        .def("IsExportSupported",
             (bool (RWGltf_ConfigurationNode::*)() const) static_cast<bool (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::IsExportSupported),
             R"#(Checks the export supporting)#" 
          )
        .def("GetFormat",
             (TCollection_AsciiString (RWGltf_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (RWGltf_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
        .def("GetExtensions",
             (TColStd_ListOfAsciiString (RWGltf_ConfigurationNode::*)() const) static_cast<TColStd_ListOfAsciiString (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::GetExtensions),
             R"#(Gets list of supported file extensions)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWGltf_ConfigurationNode::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWGltf_ConfigurationNode::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWGltf_ConfigurationNode::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWGltf_ConfigurationNode::*)() const>(&RWGltf_ConfigurationNode::DynamicType),
             R"#(None)#"
             
         )
;

    // Class RWGltf_DracoParameters from ./opencascade/RWGltf_DracoParameters.hxx
    klass = m.attr("RWGltf_DracoParameters");


    // nested enums

    static_cast<py::class_<RWGltf_DracoParameters , shared_ptr<RWGltf_DracoParameters>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_GltfAccessor from ./opencascade/RWGltf_GltfAccessor.hxx
    klass = m.attr("RWGltf_GltfAccessor");


    // nested enums

    static_cast<py::class_<RWGltf_GltfAccessor , shared_ptr<RWGltf_GltfAccessor>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Type", &RWGltf_GltfAccessor::Type)
        .def_readwrite("ComponentType", &RWGltf_GltfAccessor::ComponentType)
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_GltfBufferView from ./opencascade/RWGltf_GltfBufferView.hxx
    klass = m.attr("RWGltf_GltfBufferView");


    // nested enums

    static_cast<py::class_<RWGltf_GltfBufferView , shared_ptr<RWGltf_GltfBufferView>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Target", &RWGltf_GltfBufferView::Target)
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_GltfFace from ./opencascade/RWGltf_GltfFace.hxx
    klass = m.attr("RWGltf_GltfFace");


    // nested enums

    static_cast<py::class_<RWGltf_GltfFace ,opencascade::handle<RWGltf_GltfFace>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("NodePos", &RWGltf_GltfFace::NodePos)
        .def_readwrite("NodeNorm", &RWGltf_GltfFace::NodeNorm)
        .def_readwrite("NodeUV", &RWGltf_GltfFace::NodeUV)
        .def_readwrite("Indices", &RWGltf_GltfFace::Indices)
        .def_readwrite("Shape", &RWGltf_GltfFace::Shape)
        .def_readwrite("Style", &RWGltf_GltfFace::Style)
        .def_readwrite("NbIndexedNodes", &RWGltf_GltfFace::NbIndexedNodes)
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_GltfJsonParser from ./opencascade/RWGltf_GltfJsonParser.hxx
    klass = m.attr("RWGltf_GltfJsonParser");


    // nested enums

    static_cast<py::class_<RWGltf_GltfJsonParser , shared_ptr<RWGltf_GltfJsonParser>  >>(klass)
    // constructors
        .def(py::init< NCollection_Sequence<TopoDS_Shape> & >()  , py::arg("theRootShapes") )
    // custom constructors
    // methods
        .def("SetFilePath",
             (void (RWGltf_GltfJsonParser::*)( const TCollection_AsciiString &  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( const TCollection_AsciiString &  ) >(&RWGltf_GltfJsonParser::SetFilePath),
             R"#(Set file path.)#"  , py::arg("theFilePath")
          )
        .def("SetProbeHeader",
             (void (RWGltf_GltfJsonParser::*)( bool  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( bool  ) >(&RWGltf_GltfJsonParser::SetProbeHeader),
             R"#(Set flag for probing file without complete reading.)#"  , py::arg("theToProbe")
          )
        .def("SetErrorPrefix",
             (void (RWGltf_GltfJsonParser::*)( const TCollection_AsciiString &  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( const TCollection_AsciiString &  ) >(&RWGltf_GltfJsonParser::SetErrorPrefix),
             R"#(Set prefix for reporting issues.)#"  , py::arg("theErrPrefix")
          )
        .def("SetAttributeMap",
             (void (RWGltf_GltfJsonParser::*)( NCollection_DataMap<TopoDS_Shape, RWMesh_NodeAttributes, TopTools_ShapeMapHasher> &  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( NCollection_DataMap<TopoDS_Shape, RWMesh_NodeAttributes, TopTools_ShapeMapHasher> &  ) >(&RWGltf_GltfJsonParser::SetAttributeMap),
             R"#(Set map for storing node attributes.)#"  , py::arg("theAttribMap")
          )
        .def("SetExternalFiles",
             (void (RWGltf_GltfJsonParser::*)( NCollection_IndexedMap<TCollection_AsciiString> &  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( NCollection_IndexedMap<TCollection_AsciiString> &  ) >(&RWGltf_GltfJsonParser::SetExternalFiles),
             R"#(Set list for storing external files.)#"  , py::arg("theExternalFiles")
          )
        .def("SetMetadata",
             (void (RWGltf_GltfJsonParser::*)( NCollection_IndexedDataMap<TCollection_AsciiString, TCollection_AsciiString> &  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( NCollection_IndexedDataMap<TCollection_AsciiString, TCollection_AsciiString> &  ) >(&RWGltf_GltfJsonParser::SetMetadata),
             R"#(Set metadata map.)#"  , py::arg("theMetadata")
          )
        .def("SetReadAssetExtras",
             (void (RWGltf_GltfJsonParser::*)( bool  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( bool  ) >(&RWGltf_GltfJsonParser::SetReadAssetExtras),
             R"#(Set flag to translate asset.extras into metadata.)#"  , py::arg("theToRead")
          )
        .def("SetCoordinateSystemConverter",
             (void (RWGltf_GltfJsonParser::*)( const RWMesh_CoordinateSystemConverter &  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( const RWMesh_CoordinateSystemConverter &  ) >(&RWGltf_GltfJsonParser::SetCoordinateSystemConverter),
             R"#(Set transformation from glTF to OCCT coordinate system.)#"  , py::arg("theConverter")
          )
        .def("SetBinaryFormat",
             (void (RWGltf_GltfJsonParser::*)( int64_t ,  int64_t  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( int64_t ,  int64_t  ) >(&RWGltf_GltfJsonParser::SetBinaryFormat),
             R"#(Initialize binary format.)#"  , py::arg("theBinBodyOffset"),  py::arg("theBinBodyLen")
          )
        .def("SetSkipEmptyNodes",
             (void (RWGltf_GltfJsonParser::*)( bool  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( bool  ) >(&RWGltf_GltfJsonParser::SetSkipEmptyNodes),
             R"#(Set flag to ignore nodes without Geometry, TRUE by default.)#"  , py::arg("theToSkip")
          )
        .def("SetLoadAllScenes",
             (void (RWGltf_GltfJsonParser::*)( bool  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( bool  ) >(&RWGltf_GltfJsonParser::SetLoadAllScenes),
             R"#(Set flag to flag to load all scenes in the document, FALSE by default which means only main (default) scene will be loaded.)#"  , py::arg("theToLoadAll")
          )
        .def("SetMeshNameAsFallback",
             (void (RWGltf_GltfJsonParser::*)( bool  ) ) static_cast<void (RWGltf_GltfJsonParser::*)( bool  ) >(&RWGltf_GltfJsonParser::SetMeshNameAsFallback),
             R"#(Set flag to use Mesh name in case if Node name is empty, TRUE by default.)#"  , py::arg("theToFallback")
          )
        .def("Parse",
             (bool (RWGltf_GltfJsonParser::*)( const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_GltfJsonParser::*)( const Message_ProgressRange &  ) >(&RWGltf_GltfJsonParser::Parse),
             R"#(Parse glTF document.)#"  , py::arg("theProgress")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ErrorPrefix",
             (const TCollection_AsciiString & (RWGltf_GltfJsonParser::*)() const) static_cast<const TCollection_AsciiString & (RWGltf_GltfJsonParser::*)() const>(&RWGltf_GltfJsonParser::ErrorPrefix),
             R"#(Return prefix for reporting issues.)#"
             
         )
       .def("CoordinateSystemConverter",
             (const RWMesh_CoordinateSystemConverter & (RWGltf_GltfJsonParser::*)() const) static_cast<const RWMesh_CoordinateSystemConverter & (RWGltf_GltfJsonParser::*)() const>(&RWGltf_GltfJsonParser::CoordinateSystemConverter),
             R"#(Return transformation from glTF to OCCT coordinate system.)#"
             
         )
       .def("FaceList",
             (NCollection_Vector<TopoDS_Face> & (RWGltf_GltfJsonParser::*)() ) static_cast<NCollection_Vector<TopoDS_Face> & (RWGltf_GltfJsonParser::*)() >(&RWGltf_GltfJsonParser::FaceList),
             R"#(Return face list for loading triangulation.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class RWGltf_GltfLatePrimitiveArray from ./opencascade/RWGltf_GltfLatePrimitiveArray.hxx
    klass = m.attr("RWGltf_GltfLatePrimitiveArray");


    // nested enums

    static_cast<py::class_<RWGltf_GltfLatePrimitiveArray ,opencascade::handle<RWGltf_GltfLatePrimitiveArray>  >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString &,const TCollection_AsciiString & >()  , py::arg("theId"),  py::arg("theName") )
    // custom constructors
    // methods
        .def("SetName",
             (void (RWGltf_GltfLatePrimitiveArray::*)( const TCollection_AsciiString &  ) ) static_cast<void (RWGltf_GltfLatePrimitiveArray::*)( const TCollection_AsciiString &  ) >(&RWGltf_GltfLatePrimitiveArray::SetName),
             R"#(Assign entity name.)#"  , py::arg("theName")
          )
        .def("PrimitiveMode",
             (RWGltf_GltfPrimitiveMode (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<RWGltf_GltfPrimitiveMode (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::PrimitiveMode),
             R"#(Return type of primitive array.)#" 
          )
        .def("SetPrimitiveMode",
             (void (RWGltf_GltfLatePrimitiveArray::*)( RWGltf_GltfPrimitiveMode  ) ) static_cast<void (RWGltf_GltfLatePrimitiveArray::*)( RWGltf_GltfPrimitiveMode  ) >(&RWGltf_GltfLatePrimitiveArray::SetPrimitiveMode),
             R"#(Set type of primitive array.)#"  , py::arg("theMode")
          )
        .def("HasStyle",
             (bool (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<bool (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::HasStyle),
             R"#(Return true if primitive array has assigned material)#" 
          )
        .def("BaseColor",
             (Quantity_ColorRGBA (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<Quantity_ColorRGBA (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::BaseColor),
             R"#(Return base color.)#" 
          )
        .def("SetMaterialPbr",
             (void (RWGltf_GltfLatePrimitiveArray::*)( const opencascade::handle<RWGltf_MaterialMetallicRoughness> &  ) ) static_cast<void (RWGltf_GltfLatePrimitiveArray::*)( const opencascade::handle<RWGltf_MaterialMetallicRoughness> &  ) >(&RWGltf_GltfLatePrimitiveArray::SetMaterialPbr),
             R"#(Set PBR material definition.)#"  , py::arg("theMat")
          )
        .def("SetMaterialCommon",
             (void (RWGltf_GltfLatePrimitiveArray::*)( const opencascade::handle<RWGltf_MaterialCommon> &  ) ) static_cast<void (RWGltf_GltfLatePrimitiveArray::*)( const opencascade::handle<RWGltf_MaterialCommon> &  ) >(&RWGltf_GltfLatePrimitiveArray::SetMaterialCommon),
             R"#(Set common (obsolete) material definition.)#"  , py::arg("theMat")
          )
        .def("AddPrimArrayData",
             (RWGltf_GltfPrimArrayData & (RWGltf_GltfLatePrimitiveArray::*)( RWGltf_GltfArrayType  ) ) static_cast<RWGltf_GltfPrimArrayData & (RWGltf_GltfLatePrimitiveArray::*)( RWGltf_GltfArrayType  ) >(&RWGltf_GltfLatePrimitiveArray::AddPrimArrayData),
             R"#(Add primitive array data element.)#"  , py::arg("theType")
          )
        .def("HasDeferredData",
             (Standard_Boolean (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<Standard_Boolean (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::HasDeferredData),
             R"#(Return TRUE if there is deferred storage and some triangulation data that can be loaded using LoadDeferredData().)#" 
          )
        .def("LoadStreamData",
             (opencascade::handle<Poly_Triangulation> (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<opencascade::handle<Poly_Triangulation> (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::LoadStreamData),
             R"#(Load primitive array saved as stream buffer to new triangulation object.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWGltf_GltfLatePrimitiveArray::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWGltf_GltfLatePrimitiveArray::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::DynamicType),
             R"#(None)#"
             
         )
       .def("Id",
             (const TCollection_AsciiString & (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<const TCollection_AsciiString & (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::Id),
             R"#(Entity id.)#"
             
         )
       .def("Name",
             (const TCollection_AsciiString & (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<const TCollection_AsciiString & (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::Name),
             R"#(Entity name.)#"
             
         )
       .def("MaterialPbr",
             (const opencascade::handle<RWGltf_MaterialMetallicRoughness> & (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<const opencascade::handle<RWGltf_MaterialMetallicRoughness> & (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::MaterialPbr),
             R"#(Return PBR material definition.)#"
             
         )
       .def("MaterialCommon",
             (const opencascade::handle<RWGltf_MaterialCommon> & (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<const opencascade::handle<RWGltf_MaterialCommon> & (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::MaterialCommon),
             R"#(Return common (obsolete) material definition.)#"
             
         )
       .def("Data",
             (const NCollection_Sequence<RWGltf_GltfPrimArrayData> & (RWGltf_GltfLatePrimitiveArray::*)() const) static_cast<const NCollection_Sequence<RWGltf_GltfPrimArrayData> & (RWGltf_GltfLatePrimitiveArray::*)() const>(&RWGltf_GltfLatePrimitiveArray::Data),
             R"#(Return primitive array data elements.)#"
             
         )
;

    // Class RWGltf_GltfMaterialMap from ./opencascade/RWGltf_GltfMaterialMap.hxx
    klass = m.attr("RWGltf_GltfMaterialMap");


    // nested enums

    static_cast<py::class_<RWGltf_GltfMaterialMap ,opencascade::handle<RWGltf_GltfMaterialMap>  >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString &,const Standard_Integer >()  , py::arg("theFile"),  py::arg("theDefSamplerId") )
    // custom constructors
    // methods
        .def("FlushGlbImages",
             (void (RWGltf_GltfMaterialMap::*)( RWGltf_GltfOStreamWriter *  ) ) static_cast<void (RWGltf_GltfMaterialMap::*)( RWGltf_GltfOStreamWriter *  ) >(&RWGltf_GltfMaterialMap::FlushGlbImages),
             R"#(Write RWGltf_GltfRootElement_Images section with images collected by AddImagesToGlb().)#"  , py::arg("theWriter")
          )
        .def("NbImages",
             (Standard_Integer (RWGltf_GltfMaterialMap::*)() const) static_cast<Standard_Integer (RWGltf_GltfMaterialMap::*)() const>(&RWGltf_GltfMaterialMap::NbImages),
             R"#(Return extent of images map.)#" 
          )
        .def("NbTextures",
             (Standard_Integer (RWGltf_GltfMaterialMap::*)() const) static_cast<Standard_Integer (RWGltf_GltfMaterialMap::*)() const>(&RWGltf_GltfMaterialMap::NbTextures),
             R"#(Return extent of textures map.)#" 
          )
    // methods using call by reference i.s.o. return
        .def("FlushGlbBufferViews",
             []( RWGltf_GltfMaterialMap &self , RWGltf_GltfOStreamWriter * theWriter,const Standard_Integer theBinDataBufferId ){
                 Standard_Integer  theBuffViewId;

                 self.FlushGlbBufferViews(theWriter,theBinDataBufferId,theBuffViewId);
                 
                 return std::make_tuple(theBuffViewId); },
             R"#(Add bufferView's into RWGltf_GltfRootElement_BufferViews section with images collected by AddImagesToGlb().)#"  , py::arg("theWriter"),  py::arg("theBinDataBufferId")
          )
        .def("AddImages",
             []( RWGltf_GltfMaterialMap &self , RWGltf_GltfOStreamWriter * theWriter,const XCAFPrs_Style & theStyle ){
                 Standard_Boolean  theIsStarted;

                 self.AddImages(theWriter,theStyle,theIsStarted);
                 
                 return std::make_tuple(theIsStarted); },
             R"#(Add material images in case of non-GLB file (an alternative to AddImagesToGlb() + FlushBufferViews() + FlushImagesGlb()).)#"  , py::arg("theWriter"),  py::arg("theStyle")
          )
        .def("AddMaterial",
             []( RWGltf_GltfMaterialMap &self , RWGltf_GltfOStreamWriter * theWriter,const XCAFPrs_Style & theStyle ){
                 Standard_Boolean  theIsStarted;

                 self.AddMaterial(theWriter,theStyle,theIsStarted);
                 
                 return std::make_tuple(theIsStarted); },
             R"#(Add material.)#"  , py::arg("theWriter"),  py::arg("theStyle")
          )
        .def("AddTextures",
             []( RWGltf_GltfMaterialMap &self , RWGltf_GltfOStreamWriter * theWriter,const XCAFPrs_Style & theStyle ){
                 Standard_Boolean  theIsStarted;

                 self.AddTextures(theWriter,theStyle,theIsStarted);
                 
                 return std::make_tuple(theIsStarted); },
             R"#(Add material textures.)#"  , py::arg("theWriter"),  py::arg("theStyle")
          )
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWGltf_GltfMaterialMap::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWGltf_GltfMaterialMap::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("baseColorTexture_s",
                    (const opencascade::handle<Image_Texture> & (*)( const opencascade::handle<XCAFDoc_VisMaterial> &  ) ) static_cast<const opencascade::handle<Image_Texture> & (*)( const opencascade::handle<XCAFDoc_VisMaterial> &  ) >(&RWGltf_GltfMaterialMap::baseColorTexture),
                    R"#(Return base color texture.)#"  , py::arg("theMat")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWGltf_GltfMaterialMap::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWGltf_GltfMaterialMap::*)() const>(&RWGltf_GltfMaterialMap::DynamicType),
             R"#(None)#"
             
         )
;

    // Class RWGltf_GltfOStreamWriter from ./opencascade/RWGltf_GltfOStreamWriter.hxx
    klass = m.attr("RWGltf_GltfOStreamWriter");


    // nested enums

    static_cast<py::class_<RWGltf_GltfOStreamWriter , shared_ptr<RWGltf_GltfOStreamWriter>  >>(klass)
    // constructors
        .def(py::init< BasicOStreamWrapper<std::ostream> & >()  , py::arg("theOStream") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_GltfPrimArrayData from ./opencascade/RWGltf_GltfPrimArrayData.hxx
    klass = m.attr("RWGltf_GltfPrimArrayData");


    // nested enums

    static_cast<py::class_<RWGltf_GltfPrimArrayData , shared_ptr<RWGltf_GltfPrimArrayData>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< RWGltf_GltfArrayType >()  , py::arg("theType") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("StreamUri", &RWGltf_GltfPrimArrayData::StreamUri)
        .def_readwrite("Accessor", &RWGltf_GltfPrimArrayData::Accessor)
        .def_readwrite("Type", &RWGltf_GltfPrimArrayData::Type)
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_GltfSceneNodeMap from ./opencascade/RWGltf_GltfSceneNodeMap.hxx
    klass = m.attr("RWGltf_GltfSceneNodeMap");


    // nested enums

    static_cast<py::class_<RWGltf_GltfSceneNodeMap , shared_ptr<RWGltf_GltfSceneNodeMap>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("FindIndex",
             (Standard_Integer (RWGltf_GltfSceneNodeMap::*)( const TCollection_AsciiString &  ) const) static_cast<Standard_Integer (RWGltf_GltfSceneNodeMap::*)( const TCollection_AsciiString &  ) const>(&RWGltf_GltfSceneNodeMap::FindIndex),
             R"#(Find index from document node string identifier.)#"  , py::arg("theNodeId")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_MaterialCommon from ./opencascade/RWGltf_MaterialCommon.hxx
    klass = m.attr("RWGltf_MaterialCommon");


    // nested enums

    static_cast<py::class_<RWGltf_MaterialCommon ,opencascade::handle<RWGltf_MaterialCommon>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Id", &RWGltf_MaterialCommon::Id)
        .def_readwrite("Name", &RWGltf_MaterialCommon::Name)
        .def_readwrite("AmbientColor", &RWGltf_MaterialCommon::AmbientColor)
        .def_readwrite("DiffuseColor", &RWGltf_MaterialCommon::DiffuseColor)
        .def_readwrite("SpecularColor", &RWGltf_MaterialCommon::SpecularColor)
        .def_readwrite("EmissiveColor", &RWGltf_MaterialCommon::EmissiveColor)
        .def_readwrite("Shininess", &RWGltf_MaterialCommon::Shininess)
        .def_readwrite("Transparency", &RWGltf_MaterialCommon::Transparency)
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_MaterialMetallicRoughness from ./opencascade/RWGltf_MaterialMetallicRoughness.hxx
    klass = m.attr("RWGltf_MaterialMetallicRoughness");


    // nested enums

    static_cast<py::class_<RWGltf_MaterialMetallicRoughness ,opencascade::handle<RWGltf_MaterialMetallicRoughness>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Id", &RWGltf_MaterialMetallicRoughness::Id)
        .def_readwrite("Name", &RWGltf_MaterialMetallicRoughness::Name)
        .def_readwrite("BaseColor", &RWGltf_MaterialMetallicRoughness::BaseColor)
        .def_readwrite("EmissiveFactor", &RWGltf_MaterialMetallicRoughness::EmissiveFactor)
        .def_readwrite("Metallic", &RWGltf_MaterialMetallicRoughness::Metallic)
        .def_readwrite("Roughness", &RWGltf_MaterialMetallicRoughness::Roughness)
        .def_readwrite("AlphaCutOff", &RWGltf_MaterialMetallicRoughness::AlphaCutOff)
        .def_readwrite("AlphaMode", &RWGltf_MaterialMetallicRoughness::AlphaMode)
        .def_readwrite("IsDoubleSided", &RWGltf_MaterialMetallicRoughness::IsDoubleSided)
    // methods returning by ref wrapped as properties
;

    // Class RWGltf_Provider from ./opencascade/RWGltf_Provider.hxx
    klass = m.attr("RWGltf_Provider");


    // nested enums

    static_cast<py::class_<RWGltf_Provider ,opencascade::handle<RWGltf_Provider>  , DE_Provider >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<DE_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Read",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<bool (RWGltf_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&RWGltf_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("GetFormat",
             (TCollection_AsciiString (RWGltf_Provider::*)() const) static_cast<TCollection_AsciiString (RWGltf_Provider::*)() const>(&RWGltf_Provider::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (RWGltf_Provider::*)() const) static_cast<TCollection_AsciiString (RWGltf_Provider::*)() const>(&RWGltf_Provider::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWGltf_Provider::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWGltf_Provider::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWGltf_Provider::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWGltf_Provider::*)() const>(&RWGltf_Provider::DynamicType),
             R"#(None)#"
             
         )
;

    // Class RWGltf_TriangulationReader from ./opencascade/RWGltf_TriangulationReader.hxx
    klass = m.attr("RWGltf_TriangulationReader");


    // nested enums

    static_cast<py::class_<RWGltf_TriangulationReader ,opencascade::handle<RWGltf_TriangulationReader>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("LoadStreamData",
             (bool (RWGltf_TriangulationReader::*)( const opencascade::handle<RWMesh_TriangulationSource> & ,  const opencascade::handle<Poly_Triangulation> &  ) const) static_cast<bool (RWGltf_TriangulationReader::*)( const opencascade::handle<RWMesh_TriangulationSource> & ,  const opencascade::handle<Poly_Triangulation> &  ) const>(&RWGltf_TriangulationReader::LoadStreamData),
             R"#(Loads only primitive arrays saved as stream buffer (it is primarily glTF data encoded in base64 saved to temporary buffer during glTF file reading).)#"  , py::arg("theSourceMesh"),  py::arg("theDestMesh")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&RWGltf_TriangulationReader::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&RWGltf_TriangulationReader::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (RWGltf_TriangulationReader::*)() const) static_cast<const opencascade::handle<Standard_Type> & (RWGltf_TriangulationReader::*)() const>(&RWGltf_TriangulationReader::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/RWGltf_CafReader.hxx
// ./opencascade/RWGltf_CafWriter.hxx
// ./opencascade/RWGltf_ConfigurationNode.hxx
// ./opencascade/RWGltf_DracoParameters.hxx
// ./opencascade/RWGltf_GltfAccessor.hxx
// ./opencascade/RWGltf_GltfAccessorCompType.hxx
// ./opencascade/RWGltf_GltfAccessorLayout.hxx
    m.def("RWGltf_GltfParseAccessorType",
          (RWGltf_GltfAccessorLayout (*)( const char *  ))  static_cast<RWGltf_GltfAccessorLayout (*)( const char *  )>(&RWGltf_GltfParseAccessorType),
          R"#(Parse GltfAccessorLayout from string.)#"  , py::arg("theType")
          );
// ./opencascade/RWGltf_GltfAlphaMode.hxx
    m.def("RWGltf_GltfParseAlphaMode",
          (RWGltf_GltfAlphaMode (*)( const char *  ))  static_cast<RWGltf_GltfAlphaMode (*)( const char *  )>(&RWGltf_GltfParseAlphaMode),
          R"#(Parse RWGltf_GltfAlphaMode from string.)#"  , py::arg("theType")
          );
// ./opencascade/RWGltf_GltfArrayType.hxx
    m.def("RWGltf_GltfParseAttribType",
          (RWGltf_GltfArrayType (*)( const char *  ))  static_cast<RWGltf_GltfArrayType (*)( const char *  )>(&RWGltf_GltfParseAttribType),
          R"#(Parse GltfArrayType from string.)#"  , py::arg("theType")
          );
// ./opencascade/RWGltf_GltfBufferView.hxx
// ./opencascade/RWGltf_GltfBufferViewTarget.hxx
// ./opencascade/RWGltf_GltfFace.hxx
// ./opencascade/RWGltf_GltfJsonParser.hxx
// ./opencascade/RWGltf_GltfLatePrimitiveArray.hxx
// ./opencascade/RWGltf_GltfMaterialMap.hxx
// ./opencascade/RWGltf_GltfOStreamWriter.hxx
// ./opencascade/RWGltf_GltfPrimArrayData.hxx
// ./opencascade/RWGltf_GltfPrimitiveMode.hxx
// ./opencascade/RWGltf_GltfRootElement.hxx
    m.def("RWGltf_GltfRootElementName",
          (const char * (*)( RWGltf_GltfRootElement  ))  static_cast<const char * (*)( RWGltf_GltfRootElement  )>(&RWGltf_GltfRootElementName),
          R"#(Root elements within glTF JSON document - names array.)#"  , py::arg("theElem")
          );
// ./opencascade/RWGltf_GltfSceneNodeMap.hxx
// ./opencascade/RWGltf_MaterialCommon.hxx
// ./opencascade/RWGltf_MaterialMetallicRoughness.hxx
// ./opencascade/RWGltf_Provider.hxx
// ./opencascade/RWGltf_TriangulationReader.hxx
// ./opencascade/RWGltf_WriterTrsfFormat.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
