# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessRights(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MANAGE = "Manage"
    SEND = "Send"
    LISTEN = "Listen"

class DefaultAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Default Action for Network Rule Set
    """

    ALLOW = "Allow"
    DENY = "Deny"

class EncodingCaptureDescription(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enumerates the possible values for the encoding format of capture description.
    """

    AVRO = "Avro"
    AVRO_DEFLATE = "AvroDeflate"

class EndPointProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the Private Endpoint Connection.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"

class EntityStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Entity status.
    """

    ACTIVE = "Active"
    DISABLED = "Disabled"
    RESTORING = "Restoring"
    SEND_DISABLED = "SendDisabled"
    RECEIVE_DISABLED = "ReceiveDisabled"
    CREATING = "Creating"
    DELETING = "Deleting"
    RENAMING = "Renaming"
    UNKNOWN = "Unknown"

class FilterType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Rule filter types
    """

    SQL_FILTER = "SqlFilter"
    CORRELATION_FILTER = "CorrelationFilter"

class IPAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The IP Filter Action
    """

    ACCEPT = "Accept"
    REJECT = "Reject"

class KeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The access key to regenerate.
    """

    PRIMARY_KEY = "PrimaryKey"
    SECONDARY_KEY = "SecondaryKey"

class MigrationConfigurationName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    _DEFAULT = "$default"

class NameSpaceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of namespaces
    """

    MESSAGING = "Messaging"
    NOTIFICATION_HUB = "NotificationHub"
    MIXED = "Mixed"
    EVENT_HUB = "EventHub"
    RELAY = "Relay"

class NetworkRuleIPAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The IP Filter Action
    """

    ALLOW = "Allow"

class PrivateLinkConnectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the connection.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class ProvisioningStateDR(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted'
    or 'Succeeded' or 'Failed'
    """

    ACCEPTED = "Accepted"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class RoleDisasterRecovery(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or
    'Secondary'
    """

    PRIMARY = "Primary"
    PRIMARY_NOT_REPLICATING = "PrimaryNotReplicating"
    SECONDARY = "Secondary"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of this SKU.
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class SkuTier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The billing tier of this particular SKU.
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class UnavailableReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the reason for the unavailability of the service.
    """

    NONE = "None"
    INVALID_NAME = "InvalidName"
    SUBSCRIPTION_IS_DISABLED = "SubscriptionIsDisabled"
    NAME_IN_USE = "NameInUse"
    NAME_IN_LOCKDOWN = "NameInLockdown"
    TOO_MANY_NAMESPACE_IN_CURRENT_SUBSCRIPTION = "TooManyNamespaceInCurrentSubscription"
