# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Actor(Model):
    """The agent that initiated the event. For most situations, this could be from
    the authorization context of the request.

    :param name: The subject or username associated with the request context
     that generated the event.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(Actor, self).__init__(**kwargs)
        self.name = name


class AgentProperties(Model):
    """The properties that determine the run agent configuration.

    :param cpu: The CPU configuration in terms of number of cores required for
     the run.
    :type cpu: int
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'int'},
    }

    def __init__(self, *, cpu: int=None, **kwargs) -> None:
        super(AgentProperties, self).__init__(**kwargs)
        self.cpu = cpu


class Argument(Model):
    """The properties of a run argument.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the argument.
    :type name: str
    :param value: Required. The value of the argument.
    :type value: str
    :param is_secret: Flag to indicate whether the argument represents a
     secret and want to be removed from build logs. Default value: False .
    :type is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(self, *, name: str, value: str, is_secret: bool=False, **kwargs) -> None:
        super(Argument, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.is_secret = is_secret


class AuthInfo(Model):
    """The authorization properties for accessing the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param token_type: Required. The type of Auth token. Possible values
     include: 'PAT', 'OAuth'
    :type token_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TokenType
    :param token: Required. The access token used to access the source control
     provider.
    :type token: str
    :param refresh_token: The refresh token used to refresh the access token.
    :type refresh_token: str
    :param scope: The scope of the access token.
    :type scope: str
    :param expires_in: Time in seconds that the token remains valid
    :type expires_in: int
    """

    _validation = {
        'token_type': {'required': True},
        'token': {'required': True},
    }

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(self, *, token_type, token: str, refresh_token: str=None, scope: str=None, expires_in: int=None, **kwargs) -> None:
        super(AuthInfo, self).__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class AuthInfoUpdateParameters(Model):
    """The authorization properties for accessing the source code repository.

    :param token_type: The type of Auth token. Possible values include: 'PAT',
     'OAuth'
    :type token_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TokenType
    :param token: The access token used to access the source control provider.
    :type token: str
    :param refresh_token: The refresh token used to refresh the access token.
    :type refresh_token: str
    :param scope: The scope of the access token.
    :type scope: str
    :param expires_in: Time in seconds that the token remains valid
    :type expires_in: int
    """

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(self, *, token_type=None, token: str=None, refresh_token: str=None, scope: str=None, expires_in: int=None, **kwargs) -> None:
        super(AuthInfoUpdateParameters, self).__init__(**kwargs)
        self.token_type = token_type
        self.token = token
        self.refresh_token = refresh_token
        self.scope = scope
        self.expires_in = expires_in


class BaseImageDependency(Model):
    """Properties that describe a base image dependency.

    :param type: The type of the base image dependency. Possible values
     include: 'BuildTime', 'RunTime'
    :type type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependencyType
    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(self, *, type=None, registry: str=None, repository: str=None, tag: str=None, digest: str=None, **kwargs) -> None:
        super(BaseImageDependency, self).__init__(**kwargs)
        self.type = type
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class BaseImageTrigger(Model):
    """The trigger based on base image dependency.

    All required parameters must be populated in order to send to Azure.

    :param base_image_trigger_type: Required. The type of the auto trigger for
     base image dependency updates. Possible values include: 'All', 'Runtime'
    :type base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTriggerType
    :param status: The current status of trigger. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'base_image_trigger_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, base_image_trigger_type, name: str, status="Enabled", **kwargs) -> None:
        super(BaseImageTrigger, self).__init__(**kwargs)
        self.base_image_trigger_type = base_image_trigger_type
        self.status = status
        self.name = name


class BaseImageTriggerUpdateParameters(Model):
    """The properties for updating base image dependency trigger.

    All required parameters must be populated in order to send to Azure.

    :param base_image_trigger_type: The type of the auto trigger for base
     image dependency updates. Possible values include: 'All', 'Runtime'
    :type base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTriggerType
    :param status: The current status of trigger. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, base_image_trigger_type=None, status="Enabled", **kwargs) -> None:
        super(BaseImageTriggerUpdateParameters, self).__init__(**kwargs)
        self.base_image_trigger_type = base_image_trigger_type
        self.status = status
        self.name = name


class CallbackConfig(Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to Azure.

    :param service_uri: Required. The service URI for the webhook to post
     notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook
     notifications.
    :type custom_headers: dict[str, str]
    """

    _validation = {
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'customHeaders', 'type': '{str}'},
    }

    def __init__(self, *, service_uri: str, custom_headers=None, **kwargs) -> None:
        super(CallbackConfig, self).__init__(**kwargs)
        self.service_uri = service_uri
        self.custom_headers = custom_headers


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class Credentials(Model):
    """The parameters that describes a set of credentials that will be used when a
    run is invoked.

    :param source_registry: Describes the credential parameters for accessing
     the source registry.
    :type source_registry:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceRegistryCredentials
    :param custom_registries: Describes the credential parameters for
     accessing other custom registries. The key
     for the dictionary item will be the registry login server
     (myregistry.azurecr.io) and
     the value of the item will be the registry credentials for accessing the
     registry.
    :type custom_registries: dict[str,
     ~azure.mgmt.containerregistry.v2019_05_01.models.CustomRegistryCredentials]
    """

    _attribute_map = {
        'source_registry': {'key': 'sourceRegistry', 'type': 'SourceRegistryCredentials'},
        'custom_registries': {'key': 'customRegistries', 'type': '{CustomRegistryCredentials}'},
    }

    def __init__(self, *, source_registry=None, custom_registries=None, **kwargs) -> None:
        super(Credentials, self).__init__(**kwargs)
        self.source_registry = source_registry
        self.custom_registries = custom_registries


class CustomRegistryCredentials(Model):
    """Describes the credentials that will be used to access a custom registry
    during a run.

    :param user_name: The username for logging into the custom registry.
    :type user_name:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SecretObject
    :param password: The password for logging into the custom registry. The
     password is a secret
     object that allows multiple ways of providing the value for it.
    :type password:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SecretObject
    :param identity: Indicates the managed identity assigned to the custom
     credential. If a user-assigned identity
     this value is the Client ID. If a system-assigned identity, the value will
     be `system`. In
     the case of a system-assigned identity, the Client ID will be determined
     by the runner. This
     identity may be used to authenticate to key vault to retrieve credentials
     or it may be the only
     source of authentication used for accessing the registry.
    :type identity: str
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'SecretObject'},
        'password': {'key': 'password', 'type': 'SecretObject'},
        'identity': {'key': 'identity', 'type': 'str'},
    }

    def __init__(self, *, user_name=None, password=None, identity: str=None, **kwargs) -> None:
        super(CustomRegistryCredentials, self).__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.identity = identity


class RunRequest(Model):
    """The request parameters for scheduling a run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildRequest, FileTaskRunRequest, TaskRunRequest,
    EncodedTaskRunRequest

    All required parameters must be populated in order to send to Azure.

    :param is_archive_enabled: The value that indicates whether archiving is
     enabled for the run or not. Default value: False .
    :type is_archive_enabled: bool
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'DockerBuildRequest': 'DockerBuildRequest', 'FileTaskRunRequest': 'FileTaskRunRequest', 'TaskRunRequest': 'TaskRunRequest', 'EncodedTaskRunRequest': 'EncodedTaskRunRequest'}
    }

    def __init__(self, *, is_archive_enabled: bool=False, **kwargs) -> None:
        super(RunRequest, self).__init__(**kwargs)
        self.is_archive_enabled = is_archive_enabled
        self.type = None


class DockerBuildRequest(RunRequest):
    """The parameters for a docker quick build.

    All required parameters must be populated in order to send to Azure.

    :param is_archive_enabled: The value that indicates whether archiving is
     enabled for the run or not. Default value: False .
    :type is_archive_enabled: bool
    :param type: Required. Constant filled by server.
    :type type: str
    :param image_names: The fully qualified image names including the
     repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the
     image built should be pushed to the registry or not. Default value: True .
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image
     cache is enabled or not. Default value: False .
    :type no_cache: bool
    :param docker_file_path: Required. The Docker file path relative to the
     source location.
    :type docker_file_path: str
    :param target: The name of the target build stage for the docker build.
    :type target: str
    :param arguments: The collection of override arguments to be used when
     executing the run.
    :type arguments:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.Argument]
    :param timeout: Run timeout in seconds. Default value: 3600 .
    :type timeout: int
    :param platform: Required. The platform properties against which the run
     has to happen.
    :type platform:
     ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source
     context. It can be an URL to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials
     that will be used when this run is invoked.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'type': {'required': True},
        'docker_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(self, *, docker_file_path: str, platform, is_archive_enabled: bool=False, image_names=None, is_push_enabled: bool=True, no_cache: bool=False, target: str=None, arguments=None, timeout: int=3600, agent_configuration=None, source_location: str=None, credentials=None, **kwargs) -> None:
        super(DockerBuildRequest, self).__init__(is_archive_enabled=is_archive_enabled, **kwargs)
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.target = target
        self.arguments = arguments
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials
        self.type = 'DockerBuildRequest'


class TaskStepProperties(Model):
    """Base properties for any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStep, FileTaskStep, EncodedTaskStep

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'base_image_dependencies': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStep', 'FileTask': 'FileTaskStep', 'EncodedTask': 'EncodedTaskStep'}
    }

    def __init__(self, *, context_path: str=None, context_access_token: str=None, **kwargs) -> None:
        super(TaskStepProperties, self).__init__(**kwargs)
        self.base_image_dependencies = None
        self.context_path = context_path
        self.context_access_token = context_access_token
        self.type = None


class DockerBuildStep(TaskStepProperties):
    """The Docker build step.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param image_names: The fully qualified image names including the
     repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the
     image built should be pushed to the registry or not. Default value: True .
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image
     cache is enabled or not. Default value: False .
    :type no_cache: bool
    :param docker_file_path: Required. The Docker file path relative to the
     source context.
    :type docker_file_path: str
    :param target: The name of the target build stage for the docker build.
    :type target: str
    :param arguments: The collection of override arguments to be used when
     executing this build step.
    :type arguments:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.Argument]
    """

    _validation = {
        'base_image_dependencies': {'readonly': True},
        'type': {'required': True},
        'docker_file_path': {'required': True},
    }

    _attribute_map = {
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
    }

    def __init__(self, *, docker_file_path: str, context_path: str=None, context_access_token: str=None, image_names=None, is_push_enabled: bool=True, no_cache: bool=False, target: str=None, arguments=None, **kwargs) -> None:
        super(DockerBuildStep, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.target = target
        self.arguments = arguments
        self.type = 'Docker'


class TaskStepUpdateParameters(Model):
    """Base properties for updating any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStepUpdateParameters,
    FileTaskStepUpdateParameters, EncodedTaskStepUpdateParameters

    All required parameters must be populated in order to send to Azure.

    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStepUpdateParameters', 'FileTask': 'FileTaskStepUpdateParameters', 'EncodedTask': 'EncodedTaskStepUpdateParameters'}
    }

    def __init__(self, *, context_path: str=None, context_access_token: str=None, **kwargs) -> None:
        super(TaskStepUpdateParameters, self).__init__(**kwargs)
        self.context_path = context_path
        self.context_access_token = context_access_token
        self.type = None


class DockerBuildStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating a docker build step.

    All required parameters must be populated in order to send to Azure.

    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param image_names: The fully qualified image names including the
     repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the
     image built should be pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image
     cache is enabled or not.
    :type no_cache: bool
    :param docker_file_path: The Docker file path relative to the source
     context.
    :type docker_file_path: str
    :param arguments: The collection of override arguments to be used when
     executing this build step.
    :type arguments:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.Argument]
    :param target: The name of the target build stage for the docker build.
    :type target: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, *, context_path: str=None, context_access_token: str=None, image_names=None, is_push_enabled: bool=None, no_cache: bool=None, docker_file_path: str=None, arguments=None, target: str=None, **kwargs) -> None:
        super(DockerBuildStepUpdateParameters, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.image_names = image_names
        self.is_push_enabled = is_push_enabled
        self.no_cache = no_cache
        self.docker_file_path = docker_file_path
        self.arguments = arguments
        self.target = target
        self.type = 'Docker'


class EncodedTaskRunRequest(RunRequest):
    """The parameters for a quick task run request.

    All required parameters must be populated in order to send to Azure.

    :param is_archive_enabled: The value that indicates whether archiving is
     enabled for the run or not. Default value: False .
    :type is_archive_enabled: bool
    :param type: Required. Constant filled by server.
    :type type: str
    :param encoded_task_content: Required. Base64 encoded value of the
     template/definition file content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the
     parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed
     when running a task.
    :type values:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    :param timeout: Run timeout in seconds. Default value: 3600 .
    :type timeout: int
    :param platform: Required. The platform properties against which the run
     has to happen.
    :type platform:
     ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source
     context. It can be an URL to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials
     that will be used when this run is invoked.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'type': {'required': True},
        'encoded_task_content': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(self, *, encoded_task_content: str, platform, is_archive_enabled: bool=False, encoded_values_content: str=None, values=None, timeout: int=3600, agent_configuration=None, source_location: str=None, credentials=None, **kwargs) -> None:
        super(EncodedTaskRunRequest, self).__init__(is_archive_enabled=is_archive_enabled, **kwargs)
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials
        self.type = 'EncodedTaskRunRequest'


class EncodedTaskStep(TaskStepProperties):
    """The properties of a encoded task step.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param encoded_task_content: Required. Base64 encoded value of the
     template/definition file content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the
     parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed
     when running a task.
    :type values:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'base_image_dependencies': {'readonly': True},
        'type': {'required': True},
        'encoded_task_content': {'required': True},
    }

    _attribute_map = {
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(self, *, encoded_task_content: str, context_path: str=None, context_access_token: str=None, encoded_values_content: str=None, values=None, **kwargs) -> None:
        super(EncodedTaskStep, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values
        self.type = 'EncodedTask'


class EncodedTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating encoded task step.

    All required parameters must be populated in order to send to Azure.

    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param encoded_task_content: Base64 encoded value of the
     template/definition file content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the
     parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed
     when running a task.
    :type values:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(self, *, context_path: str=None, context_access_token: str=None, encoded_task_content: str=None, encoded_values_content: str=None, values=None, **kwargs) -> None:
        super(EncodedTaskStepUpdateParameters, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.encoded_task_content = encoded_task_content
        self.encoded_values_content = encoded_values_content
        self.values = values
        self.type = 'EncodedTask'


class EventInfo(Model):
    """The basic information of an event.

    :param id: The event ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(EventInfo, self).__init__(**kwargs)
        self.id = id


class Event(EventInfo):
    """The event for a webhook.

    :param id: The event ID.
    :type id: str
    :param event_request_message: The event request message sent to the
     service URI.
    :type event_request_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventRequestMessage
    :param event_response_message: The event response message received from
     the service URI.
    :type event_response_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventResponseMessage
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_request_message': {'key': 'eventRequestMessage', 'type': 'EventRequestMessage'},
        'event_response_message': {'key': 'eventResponseMessage', 'type': 'EventResponseMessage'},
    }

    def __init__(self, *, id: str=None, event_request_message=None, event_response_message=None, **kwargs) -> None:
        super(Event, self).__init__(id=id, **kwargs)
        self.event_request_message = event_request_message
        self.event_response_message = event_response_message


class EventContent(Model):
    """The content of the event request message.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~azure.mgmt.containerregistry.v2019_05_01.models.Target
    :param request: The request that generated the event.
    :type request: ~azure.mgmt.containerregistry.v2019_05_01.models.Request
    :param actor: The agent that initiated the event. For most situations,
     this could be from the authorization context of the request.
    :type actor: ~azure.mgmt.containerregistry.v2019_05_01.models.Actor
    :param source: The registry node that generated the event. Put
     differently, while the actor initiates the event, the source generates it.
    :type source: ~azure.mgmt.containerregistry.v2019_05_01.models.Source
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'Target'},
        'request': {'key': 'request', 'type': 'Request'},
        'actor': {'key': 'actor', 'type': 'Actor'},
        'source': {'key': 'source', 'type': 'Source'},
    }

    def __init__(self, *, id: str=None, timestamp=None, action: str=None, target=None, request=None, actor=None, source=None, **kwargs) -> None:
        super(EventContent, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.action = action
        self.target = target
        self.request = request
        self.actor = actor
        self.source = source


class EventRequestMessage(Model):
    """The event request message sent to the service URI.

    :param content: The content of the event request message.
    :type content:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventContent
    :param headers: The headers of the event request message.
    :type headers: dict[str, str]
    :param method: The HTTP method used to send the event request message.
    :type method: str
    :param request_uri: The URI used to send the event request message.
    :type request_uri: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'EventContent'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'method': {'key': 'method', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, content=None, headers=None, method: str=None, request_uri: str=None, version: str=None, **kwargs) -> None:
        super(EventRequestMessage, self).__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.method = method
        self.request_uri = request_uri
        self.version = version


class EventResponseMessage(Model):
    """The event response message received from the service URI.

    :param content: The content of the event response message.
    :type content: str
    :param headers: The headers of the event response message.
    :type headers: dict[str, str]
    :param reason_phrase: The reason phrase of the event response message.
    :type reason_phrase: str
    :param status_code: The status code of the event response message.
    :type status_code: str
    :param version: The HTTP message version.
    :type version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'reason_phrase': {'key': 'reasonPhrase', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, content: str=None, headers=None, reason_phrase: str=None, status_code: str=None, version: str=None, **kwargs) -> None:
        super(EventResponseMessage, self).__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.reason_phrase = reason_phrase
        self.status_code = status_code
        self.version = version


class FileTaskRunRequest(RunRequest):
    """The request parameters for a scheduling run against a task file.

    All required parameters must be populated in order to send to Azure.

    :param is_archive_enabled: The value that indicates whether archiving is
     enabled for the run or not. Default value: False .
    :type is_archive_enabled: bool
    :param type: Required. Constant filled by server.
    :type type: str
    :param task_file_path: Required. The template/definition file path
     relative to the source.
    :type task_file_path: str
    :param values_file_path: The values/parameters file path relative to the
     source.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed
     when running a task.
    :type values:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    :param timeout: Run timeout in seconds. Default value: 3600 .
    :type timeout: int
    :param platform: Required. The platform properties against which the run
     has to happen.
    :type platform:
     ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source
     context. It can be an URL to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials
     that will be used when this run is invoked.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'type': {'required': True},
        'task_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(self, *, task_file_path: str, platform, is_archive_enabled: bool=False, values_file_path: str=None, values=None, timeout: int=3600, agent_configuration=None, source_location: str=None, credentials=None, **kwargs) -> None:
        super(FileTaskRunRequest, self).__init__(is_archive_enabled=is_archive_enabled, **kwargs)
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values
        self.timeout = timeout
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_location = source_location
        self.credentials = credentials
        self.type = 'FileTaskRunRequest'


class FileTaskStep(TaskStepProperties):
    """The properties of a task step.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param task_file_path: Required. The task template/definition file path
     relative to the source context.
    :type task_file_path: str
    :param values_file_path: The task values/parameters file path relative to
     the source context.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed
     when running a task.
    :type values:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'base_image_dependencies': {'readonly': True},
        'type': {'required': True},
        'task_file_path': {'required': True},
    }

    _attribute_map = {
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(self, *, task_file_path: str, context_path: str=None, context_access_token: str=None, values_file_path: str=None, values=None, **kwargs) -> None:
        super(FileTaskStep, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values
        self.type = 'FileTask'


class FileTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties of updating a task step.

    All required parameters must be populated in order to send to Azure.

    :param context_path: The URL(absolute or relative) of the source context
     for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage
     account blob) associated with the context for a step.
    :type context_access_token: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param task_file_path: The task template/definition file path relative to
     the source context.
    :type task_file_path: str
    :param values_file_path: The values/parameters file path relative to the
     source context.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed
     when running a task.
    :type values:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(self, *, context_path: str=None, context_access_token: str=None, task_file_path: str=None, values_file_path: str=None, values=None, **kwargs) -> None:
        super(FileTaskStepUpdateParameters, self).__init__(context_path=context_path, context_access_token=context_access_token, **kwargs)
        self.task_file_path = task_file_path
        self.values_file_path = values_file_path
        self.values = values
        self.type = 'FileTask'


class IdentityProperties(Model):
    """Managed identity for the resource.

    :param principal_id: The principal ID of resource identity.
    :type principal_id: str
    :param tenant_id: The tenant ID of resource.
    :type tenant_id: str
    :param type: The identity type. Possible values include: 'SystemAssigned',
     'UserAssigned', 'SystemAssigned, UserAssigned', 'None'
    :type type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated
     with the resource. The user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.containerregistry.v2019_05_01.models.UserIdentityProperties]
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(self, *, principal_id: str=None, tenant_id: str=None, type=None, user_assigned_identities=None, **kwargs) -> None:
        super(IdentityProperties, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ImageDescriptor(Model):
    """Properties for a registry image.

    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(self, *, registry: str=None, repository: str=None, tag: str=None, digest: str=None, **kwargs) -> None:
        super(ImageDescriptor, self).__init__(**kwargs)
        self.registry = registry
        self.repository = repository
        self.tag = tag
        self.digest = digest


class ImageUpdateTrigger(Model):
    """The image update trigger that caused a build.

    :param id: The unique ID of the trigger.
    :type id: str
    :param timestamp: The timestamp when the image update happened.
    :type timestamp: datetime
    :param images: The list of image updates that caused the build.
    :type images:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.ImageDescriptor]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'images': {'key': 'images', 'type': '[ImageDescriptor]'},
    }

    def __init__(self, *, id: str=None, timestamp=None, images=None, **kwargs) -> None:
        super(ImageUpdateTrigger, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.images = images


class ImportImageParameters(Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The source of the image.
    :type source:
     ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSource
    :param target_tags: List of strings of the form repo[:tag]. When tag is
     omitted the source will be used (or 'latest' if source tag is also
     omitted).
    :type target_tags: list[str]
    :param untagged_target_repositories: List of strings of repository names
     to do a manifest only copy. No tag will be created.
    :type untagged_target_repositories: list[str]
    :param mode: When Force, any existing target tags will be overwritten.
     When NoForce, any existing target tags will fail the operation before any
     copying begins. Possible values include: 'NoForce', 'Force'. Default
     value: "NoForce" .
    :type mode: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ImportMode
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ImportSource'},
        'target_tags': {'key': 'targetTags', 'type': '[str]'},
        'untagged_target_repositories': {'key': 'untaggedTargetRepositories', 'type': '[str]'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(self, *, source, target_tags=None, untagged_target_repositories=None, mode="NoForce", **kwargs) -> None:
        super(ImportImageParameters, self).__init__(**kwargs)
        self.source = source
        self.target_tags = target_tags
        self.untagged_target_repositories = untagged_target_repositories
        self.mode = mode


class ImportSource(Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: The resource identifier of the source Azure Container
     Registry.
    :type resource_id: str
    :param registry_uri: The address of the source registry (e.g.
     'mcr.microsoft.com').
    :type registry_uri: str
    :param credentials: Credentials used when importing from a registry uri.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSourceCredentials
    :param source_image: Required. Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest'
     tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest
     ('hello-world@sha256:abc123').
    :type source_image: str
    """

    _validation = {
        'source_image': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'registry_uri': {'key': 'registryUri', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'ImportSourceCredentials'},
        'source_image': {'key': 'sourceImage', 'type': 'str'},
    }

    def __init__(self, *, source_image: str, resource_id: str=None, registry_uri: str=None, credentials=None, **kwargs) -> None:
        super(ImportSource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.registry_uri = registry_uri
        self.credentials = credentials
        self.source_image = source_image


class ImportSourceCredentials(Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to Azure.

    :param username: The username to authenticate with the source registry.
    :type username: str
    :param password: Required. The password used to authenticate with the
     source registry.
    :type password: str
    """

    _validation = {
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, *, password: str, username: str=None, **kwargs) -> None:
        super(ImportSourceCredentials, self).__init__(**kwargs)
        self.username = username
        self.password = password


class IPRule(Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of IP ACL rule. Possible values include:
     'Allow'. Default value: "Allow" .
    :type action: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :param ip_address_or_range: Required. Specifies the IP or IP range in CIDR
     format. Only IPV4 address is allowed.
    :type ip_address_or_range: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, ip_address_or_range: str, action="Allow", **kwargs) -> None:
        super(IPRule, self).__init__(**kwargs)
        self.action = action
        self.ip_address_or_range = ip_address_or_range


class NetworkRuleSet(Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to Azure.

    :param default_action: Required. The default action of allow or deny when
     no other rules match. Possible values include: 'Allow', 'Deny'. Default
     value: "Allow" .
    :type default_action: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.DefaultAction
    :param virtual_network_rules: The virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.VirtualNetworkRule]
    :param ip_rules: The IP ACL rules.
    :type ip_rules:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.IPRule]
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
    }

    def __init__(self, *, default_action="Allow", virtual_network_rules=None, ip_rules=None, **kwargs) -> None:
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.default_action = default_action
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules


class OperationDefinition(Model):
    """The definition of a container registry operation.

    :param origin: The origin information of the container registry operation.
    :type origin: str
    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The display information for the container registry
     operation.
    :type display:
     ~azure.mgmt.containerregistry.v2019_05_01.models.OperationDisplayDefinition
    :param service_specification: The definition of Azure Monitoring service.
    :type service_specification:
     ~azure.mgmt.containerregistry.v2019_05_01.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayDefinition'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationServiceSpecificationDefinition'},
    }

    def __init__(self, *, origin: str=None, name: str=None, display=None, service_specification=None, **kwargs) -> None:
        super(OperationDefinition, self).__init__(**kwargs)
        self.origin = origin
        self.name = name
        self.display = display
        self.service_specification = service_specification


class OperationDisplayDefinition(Model):
    """The display information for a container registry operation.

    :param provider: The resource provider name: Microsoft.ContainerRegistry.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that users can perform.
    :type operation: str
    :param description: The description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplayDefinition, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationMetricSpecificationDefinition(Model):
    """The definition of Azure Monitoring metric.

    :param name: Metric name.
    :type name: str
    :param display_name: Metric display name.
    :type display_name: str
    :param display_description: Metric description.
    :type display_description: str
    :param unit: Metric unit.
    :type unit: str
    :param aggregation_type: Metric aggregation type.
    :type aggregation_type: str
    :param internal_metric_name: Internal metric name.
    :type internal_metric_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, display_description: str=None, unit: str=None, aggregation_type: str=None, internal_metric_name: str=None, **kwargs) -> None:
        super(OperationMetricSpecificationDefinition, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.internal_metric_name = internal_metric_name


class OperationServiceSpecificationDefinition(Model):
    """The definition of Azure Monitoring list.

    :param metric_specifications: A list of Azure Monitoring metrics
     definition.
    :type metric_specifications:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationMetricSpecificationDefinition]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetricSpecificationDefinition]'},
    }

    def __init__(self, *, metric_specifications=None, **kwargs) -> None:
        super(OperationServiceSpecificationDefinition, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class PlatformProperties(Model):
    """The platform properties against which the run has to happen.

    All required parameters must be populated in order to send to Azure.

    :param os: Required. The operating system type required for the run.
     Possible values include: 'Windows', 'Linux'
    :type os: str or ~azure.mgmt.containerregistry.v2019_05_01.models.OS
    :param architecture: The OS architecture. Possible values include:
     'amd64', 'x86', 'arm'
    :type architecture: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.Architecture
    :param variant: Variant of the CPU. Possible values include: 'v6', 'v7',
     'v8'
    :type variant: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.Variant
    """

    _validation = {
        'os': {'required': True},
    }

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(self, *, os, architecture=None, variant=None, **kwargs) -> None:
        super(PlatformProperties, self).__init__(**kwargs)
        self.os = os
        self.architecture = architecture
        self.variant = variant


class PlatformUpdateParameters(Model):
    """The properties for updating the platform configuration.

    :param os: The operating system type required for the run. Possible values
     include: 'Windows', 'Linux'
    :type os: str or ~azure.mgmt.containerregistry.v2019_05_01.models.OS
    :param architecture: The OS architecture. Possible values include:
     'amd64', 'x86', 'arm'
    :type architecture: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.Architecture
    :param variant: Variant of the CPU. Possible values include: 'v6', 'v7',
     'v8'
    :type variant: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.Variant
    """

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(self, *, os=None, architecture=None, variant=None, **kwargs) -> None:
        super(PlatformUpdateParameters, self).__init__(**kwargs)
        self.os = os
        self.architecture = architecture
        self.variant = variant


class Policies(Model):
    """The policies for a container registry.

    :param quarantine_policy: The quarantine policy for a container registry.
    :type quarantine_policy:
     ~azure.mgmt.containerregistry.v2019_05_01.models.QuarantinePolicy
    :param trust_policy: The content trust policy for a container registry.
    :type trust_policy:
     ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicy
    :param retention_policy: The retention policy for a container registry.
    :type retention_policy:
     ~azure.mgmt.containerregistry.v2019_05_01.models.RetentionPolicy
    """

    _attribute_map = {
        'quarantine_policy': {'key': 'quarantinePolicy', 'type': 'QuarantinePolicy'},
        'trust_policy': {'key': 'trustPolicy', 'type': 'TrustPolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, *, quarantine_policy=None, trust_policy=None, retention_policy=None, **kwargs) -> None:
        super(Policies, self).__init__(**kwargs)
        self.quarantine_policy = quarantine_policy
        self.trust_policy = trust_policy
        self.retention_policy = retention_policy


class ProxyResource(Model):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class QuarantinePolicy(Model):
    """The quarantine policy for a container registry.

    :param status: The value that indicates whether the policy is enabled or
     not. Possible values include: 'enabled', 'disabled'. Default value:
     "disabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, status="disabled", **kwargs) -> None:
        super(QuarantinePolicy, self).__init__(**kwargs)
        self.status = status


class RegenerateCredentialParameters(Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Specifies name of the password which should be
     regenerated -- password or password2. Possible values include: 'password',
     'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'PasswordName'},
    }

    def __init__(self, *, name, **kwargs) -> None:
        super(RegenerateCredentialParameters, self).__init__(**kwargs)
        self.name = name


class Resource(Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param sku: Required. The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :ivar login_server: The URL that can be used to log into the container
     registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in
     ISO8601 format.
    :vartype creation_date: datetime
    :ivar provisioning_state: The provisioning state of the container registry
     at the time the operation was called. Possible values include: 'Creating',
     'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the container registry at the time the
     operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    :param admin_user_enabled: The value that indicates whether the admin user
     is enabled. Default value: False .
    :type admin_user_enabled: bool
    :param storage_account: The properties of the storage account for the
     container registry. Only applicable to Classic SKU.
    :type storage_account:
     ~azure.mgmt.containerregistry.v2019_05_01.models.StorageAccountProperties
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set:
     ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'login_server': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'login_server': {'key': 'properties.loginServer', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccountProperties'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(self, *, location: str, sku, tags=None, admin_user_enabled: bool=False, storage_account=None, network_rule_set=None, policies=None, **kwargs) -> None:
        super(Registry, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.status = None
        self.admin_user_enabled = admin_user_enabled
        self.storage_account = storage_account
        self.network_rule_set = network_rule_set
        self.policies = policies


class RegistryListCredentialsResult(Model):
    """The response from the ListCredentials operation.

    :param username: The username for a container registry.
    :type username: str
    :param passwords: The list of passwords for a container registry.
    :type passwords:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[RegistryPassword]'},
    }

    def __init__(self, *, username: str=None, passwords=None, **kwargs) -> None:
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class RegistryNameCheckRequest(Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the container registry.
    :type name: str
    :ivar type: Required. The resource type of the container registry. This
     field must be set to 'Microsoft.ContainerRegistry/registries'. Default
     value: "Microsoft.ContainerRegistry/registries" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 5, 'pattern': r'^[a-zA-Z0-9]*$'},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(self, *, name: str, **kwargs) -> None:
        super(RegistryNameCheckRequest, self).__init__(**kwargs)
        self.name = name


class RegistryNameStatus(Model):
    """The result of a request to check the availability of a container registry
    name.

    :param name_available: The value that indicates whether the name is
     available.
    :type name_available: bool
    :param reason: If any, the reason that the name is not available.
    :type reason: str
    :param message: If any, the error message that provides more detail for
     the reason that the name is not available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, name_available: bool=None, reason: str=None, message: str=None, **kwargs) -> None:
        super(RegistryNameStatus, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class RegistryPassword(Model):
    """The login password for the container registry.

    :param name: The password name. Possible values include: 'password',
     'password2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    :param value: The password value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'PasswordName'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name=None, value: str=None, **kwargs) -> None:
        super(RegistryPassword, self).__init__(**kwargs)
        self.name = name
        self.value = value


class RegistryUpdateParameters(Model):
    """The parameters for updating a container registry.

    :param tags: The tags for the container registry.
    :type tags: dict[str, str]
    :param sku: The SKU of the container registry.
    :type sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :param admin_user_enabled: The value that indicates whether the admin user
     is enabled.
    :type admin_user_enabled: bool
    :param network_rule_set: The network rule set for a container registry.
    :type network_rule_set:
     ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :param policies: The policies for a container registry.
    :type policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(self, *, tags=None, sku=None, admin_user_enabled: bool=None, network_rule_set=None, policies=None, **kwargs) -> None:
        super(RegistryUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.admin_user_enabled = admin_user_enabled
        self.network_rule_set = network_rule_set
        self.policies = policies


class RegistryUsage(Model):
    """The quota usage for a container registry.

    :param name: The name of the usage.
    :type name: str
    :param limit: The limit of the usage.
    :type limit: long
    :param current_value: The current value of the usage.
    :type current_value: long
    :param unit: The unit of measurement. Possible values include: 'Count',
     'Bytes'
    :type unit: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsageUnit
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, limit: int=None, current_value: int=None, unit=None, **kwargs) -> None:
        super(RegistryUsage, self).__init__(**kwargs)
        self.name = name
        self.limit = limit
        self.current_value = current_value
        self.unit = unit


class RegistryUsageListResult(Model):
    """The result of a request to get container registry quota usages.

    :param value: The list of container registry quota usages.
    :type value:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegistryUsage]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(RegistryUsageListResult, self).__init__(**kwargs)
        self.value = value


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the replication at the
     time the operation was called. Possible values include: 'Creating',
     'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was
     called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Replication, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.status = None


class ReplicationUpdateParameters(Model):
    """The parameters for updating a replication.

    :param tags: The tags for the replication.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(ReplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class Request(Model):
    """The request that generated the event.

    :param id: The ID of the request that initiated the event.
    :type id: str
    :param addr: The IP or hostname and possibly port of the client connection
     that initiated the event. This is the RemoteAddr from the standard http
     request.
    :type addr: str
    :param host: The externally accessible hostname of the registry instance,
     as specified by the http host header on incoming requests.
    :type host: str
    :param method: The request method that generated the event.
    :type method: str
    :param useragent: The user agent header of the request.
    :type useragent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'addr': {'key': 'addr', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'useragent': {'key': 'useragent', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, addr: str=None, host: str=None, method: str=None, useragent: str=None, **kwargs) -> None:
        super(Request, self).__init__(**kwargs)
        self.id = id
        self.addr = addr
        self.host = host
        self.method = method
        self.useragent = useragent


class RetentionPolicy(Model):
    """The retention policy for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param days: The number of days to retain an untagged manifest after which
     it gets purged. Default value: 7 .
    :type days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: datetime
    :param status: The value that indicates whether the policy is enabled or
     not. Possible values include: 'enabled', 'disabled'. Default value:
     "disabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, days: int=7, status="disabled", **kwargs) -> None:
        super(RetentionPolicy, self).__init__(**kwargs)
        self.days = days
        self.last_updated_time = None
        self.status = status


class Run(ProxyResource):
    """Run resource properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param run_id: The unique identifier for the run.
    :type run_id: str
    :param status: The current status of the run. Possible values include:
     'Queued', 'Started', 'Running', 'Succeeded', 'Failed', 'Canceled',
     'Error', 'Timeout'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.RunStatus
    :param last_updated_time: The last updated time for the run.
    :type last_updated_time: datetime
    :param run_type: The type of run. Possible values include: 'QuickBuild',
     'QuickRun', 'AutoBuild', 'AutoRun'
    :type run_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.RunType
    :param create_time: The time the run was scheduled.
    :type create_time: datetime
    :param start_time: The time the run started.
    :type start_time: datetime
    :param finish_time: The time the run finished.
    :type finish_time: datetime
    :param output_images: The list of all images that were generated from the
     run. This is applicable if the run generates base image dependencies.
    :type output_images:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.ImageDescriptor]
    :param task: The task against which run was scheduled.
    :type task: str
    :param image_update_trigger: The image update trigger that caused the run.
     This is applicable if the task has base image trigger configured.
    :type image_update_trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.ImageUpdateTrigger
    :param source_trigger: The source trigger that caused the run.
    :type source_trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerDescriptor
    :param platform: The platform properties against which the run will
     happen.
    :type platform:
     ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param source_registry_auth: The scope of the credentials that were used
     to login to the source registry during this run.
    :type source_registry_auth: str
    :param custom_registries: The list of custom registries that were logged
     in during this run.
    :type custom_registries: list[str]
    :ivar run_error_message: The error message received from backend systems
     after the run is scheduled.
    :vartype run_error_message: str
    :param provisioning_state: The provisioning state of a run. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed',
     'Canceled'
    :type provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :param is_archive_enabled: The value that indicates whether archiving is
     enabled or not. Default value: False .
    :type is_archive_enabled: bool
    :param timer_trigger: The timer trigger that caused the run.
    :type timer_trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.TimerTriggerDescriptor
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'run_error_message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'run_id': {'key': 'properties.runId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
        'run_type': {'key': 'properties.runType', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'properties.finishTime', 'type': 'iso-8601'},
        'output_images': {'key': 'properties.outputImages', 'type': '[ImageDescriptor]'},
        'task': {'key': 'properties.task', 'type': 'str'},
        'image_update_trigger': {'key': 'properties.imageUpdateTrigger', 'type': 'ImageUpdateTrigger'},
        'source_trigger': {'key': 'properties.sourceTrigger', 'type': 'SourceTriggerDescriptor'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'source_registry_auth': {'key': 'properties.sourceRegistryAuth', 'type': 'str'},
        'custom_registries': {'key': 'properties.customRegistries', 'type': '[str]'},
        'run_error_message': {'key': 'properties.runErrorMessage', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_archive_enabled': {'key': 'properties.isArchiveEnabled', 'type': 'bool'},
        'timer_trigger': {'key': 'properties.timerTrigger', 'type': 'TimerTriggerDescriptor'},
    }

    def __init__(self, *, run_id: str=None, status=None, last_updated_time=None, run_type=None, create_time=None, start_time=None, finish_time=None, output_images=None, task: str=None, image_update_trigger=None, source_trigger=None, platform=None, agent_configuration=None, source_registry_auth: str=None, custom_registries=None, provisioning_state=None, is_archive_enabled: bool=False, timer_trigger=None, **kwargs) -> None:
        super(Run, self).__init__(**kwargs)
        self.run_id = run_id
        self.status = status
        self.last_updated_time = last_updated_time
        self.run_type = run_type
        self.create_time = create_time
        self.start_time = start_time
        self.finish_time = finish_time
        self.output_images = output_images
        self.task = task
        self.image_update_trigger = image_update_trigger
        self.source_trigger = source_trigger
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.source_registry_auth = source_registry_auth
        self.custom_registries = custom_registries
        self.run_error_message = None
        self.provisioning_state = provisioning_state
        self.is_archive_enabled = is_archive_enabled
        self.timer_trigger = timer_trigger


class RunFilter(Model):
    """Properties that are enabled for Odata querying on runs.

    :param run_id: The unique identifier for the run.
    :type run_id: str
    :param run_type: The type of run. Possible values include: 'QuickBuild',
     'QuickRun', 'AutoBuild', 'AutoRun'
    :type run_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.RunType
    :param status: The current status of the run. Possible values include:
     'Queued', 'Started', 'Running', 'Succeeded', 'Failed', 'Canceled',
     'Error', 'Timeout'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.RunStatus
    :param create_time: The create time for a run.
    :type create_time: datetime
    :param finish_time: The time the run finished.
    :type finish_time: datetime
    :param output_image_manifests: The list of comma-separated image manifests
     that were generated from the run. This is applicable if the run is of
     build type.
    :type output_image_manifests: str
    :param is_archive_enabled: The value that indicates whether archiving is
     enabled or not.
    :type is_archive_enabled: bool
    :param task_name: The name of the task that the run corresponds to.
    :type task_name: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'run_type': {'key': 'runType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'output_image_manifests': {'key': 'outputImageManifests', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(self, *, run_id: str=None, run_type=None, status=None, create_time=None, finish_time=None, output_image_manifests: str=None, is_archive_enabled: bool=None, task_name: str=None, **kwargs) -> None:
        super(RunFilter, self).__init__(**kwargs)
        self.run_id = run_id
        self.run_type = run_type
        self.status = status
        self.create_time = create_time
        self.finish_time = finish_time
        self.output_image_manifests = output_image_manifests
        self.is_archive_enabled = is_archive_enabled
        self.task_name = task_name


class RunGetLogResult(Model):
    """The result of get log link operation.

    :param log_link: The link to logs for a run on a azure container registry.
    :type log_link: str
    """

    _attribute_map = {
        'log_link': {'key': 'logLink', 'type': 'str'},
    }

    def __init__(self, *, log_link: str=None, **kwargs) -> None:
        super(RunGetLogResult, self).__init__(**kwargs)
        self.log_link = log_link


class RunUpdateParameters(Model):
    """The set of run properties that can be updated.

    :param is_archive_enabled: The value that indicates whether archiving is
     enabled or not.
    :type is_archive_enabled: bool
    """

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
    }

    def __init__(self, *, is_archive_enabled: bool=None, **kwargs) -> None:
        super(RunUpdateParameters, self).__init__(**kwargs)
        self.is_archive_enabled = is_archive_enabled


class SecretObject(Model):
    """Describes the properties of a secret object value.

    :param value: The value of the secret. The format of this value will be
     determined
     based on the type of the secret object. If the type is Opaque, the value
     will be
     used as is without any modification.
    :type value: str
    :param type: The type of the secret object which determines how the value
     of the secret object has to be
     interpreted. Possible values include: 'Opaque', 'Vaultsecret'
    :type type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SecretObjectType
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, type=None, **kwargs) -> None:
        super(SecretObject, self).__init__(**kwargs)
        self.value = value
        self.type = type


class SetValue(Model):
    """The properties of a overridable value that can be passed to a task
    template.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the overridable value.
    :type name: str
    :param value: Required. The overridable value.
    :type value: str
    :param is_secret: Flag to indicate whether the value represents a secret
     or not. Default value: False .
    :type is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(self, *, name: str, value: str, is_secret: bool=False, **kwargs) -> None:
        super(SetValue, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.is_secret = is_secret


class Sku(Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name of the container registry. Required
     for registry creation. Possible values include: 'Classic', 'Basic',
     'Standard', 'Premium'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Possible values include:
     'Classic', 'Basic', 'Standard', 'Premium'
    :vartype tier: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, *, name, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class Source(Model):
    """The registry node that generated the event. Put differently, while the
    actor initiates the event, the source generates it.

    :param addr: The IP or hostname and the port of the registry node that
     generated the event. Generally, this will be resolved by os.Hostname()
     along with the running port.
    :type addr: str
    :param instance_id: The running instance of an application. Changes after
     each restart.
    :type instance_id: str
    """

    _attribute_map = {
        'addr': {'key': 'addr', 'type': 'str'},
        'instance_id': {'key': 'instanceID', 'type': 'str'},
    }

    def __init__(self, *, addr: str=None, instance_id: str=None, **kwargs) -> None:
        super(Source, self).__init__(**kwargs)
        self.addr = addr
        self.instance_id = instance_id


class SourceProperties(Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param source_control_type: Required. The type of source control service.
     Possible values include: 'Github', 'VisualStudioTeamService'
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceControlType
    :param repository_url: Required. The full URL to the source code
     repository
    :type repository_url: str
    :param branch: The branch name of the source code.
    :type branch: str
    :param source_control_auth_properties: The authorization properties for
     accessing the source code repository and to set up
     webhooks for notifications.
    :type source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AuthInfo
    """

    _validation = {
        'source_control_type': {'required': True},
        'repository_url': {'required': True},
    }

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfo'},
    }

    def __init__(self, *, source_control_type, repository_url: str, branch: str=None, source_control_auth_properties=None, **kwargs) -> None:
        super(SourceProperties, self).__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.branch = branch
        self.source_control_auth_properties = source_control_auth_properties


class SourceRegistryCredentials(Model):
    """Describes the credential parameters for accessing the source registry.

    :param login_mode: The authentication mode which determines the source
     registry login scope. The credentials for the source registry
     will be generated using the given scope. These credentials will be used to
     login to
     the source registry during the run. Possible values include: 'None',
     'Default'
    :type login_mode: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceRegistryLoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'str'},
    }

    def __init__(self, *, login_mode=None, **kwargs) -> None:
        super(SourceRegistryCredentials, self).__init__(**kwargs)
        self.login_mode = login_mode


class SourceTrigger(Model):
    """The properties of a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :param source_repository: Required. The properties that describes the
     source(code) for the task.
    :type source_repository:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceProperties
    :param source_trigger_events: Required. The source event corresponding to
     the trigger.
    :type source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerEvent]
    :param status: The current status of trigger. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'source_repository': {'required': True},
        'source_trigger_events': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceProperties'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, source_repository, source_trigger_events, name: str, status="Enabled", **kwargs) -> None:
        super(SourceTrigger, self).__init__(**kwargs)
        self.source_repository = source_repository
        self.source_trigger_events = source_trigger_events
        self.status = status
        self.name = name


class SourceTriggerDescriptor(Model):
    """The source trigger that caused a run.

    :param id: The unique ID of the trigger.
    :type id: str
    :param event_type: The event type of the trigger.
    :type event_type: str
    :param commit_id: The unique ID that identifies a commit.
    :type commit_id: str
    :param pull_request_id: The unique ID that identifies pull request.
    :type pull_request_id: str
    :param repository_url: The repository URL.
    :type repository_url: str
    :param branch_name: The branch name in the repository.
    :type branch_name: str
    :param provider_type: The source control provider type.
    :type provider_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'commit_id': {'key': 'commitId', 'type': 'str'},
        'pull_request_id': {'key': 'pullRequestId', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch_name': {'key': 'branchName', 'type': 'str'},
        'provider_type': {'key': 'providerType', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, event_type: str=None, commit_id: str=None, pull_request_id: str=None, repository_url: str=None, branch_name: str=None, provider_type: str=None, **kwargs) -> None:
        super(SourceTriggerDescriptor, self).__init__(**kwargs)
        self.id = id
        self.event_type = event_type
        self.commit_id = commit_id
        self.pull_request_id = pull_request_id
        self.repository_url = repository_url
        self.branch_name = branch_name
        self.provider_type = provider_type


class SourceTriggerUpdateParameters(Model):
    """The properties for updating a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :param source_repository: The properties that describes the source(code)
     for the task.
    :type source_repository:
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceUpdateParameters
    :param source_trigger_events: The source event corresponding to the
     trigger.
    :type source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerEvent]
    :param status: The current status of trigger. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceUpdateParameters'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, source_repository=None, source_trigger_events=None, status="Enabled", **kwargs) -> None:
        super(SourceTriggerUpdateParameters, self).__init__(**kwargs)
        self.source_repository = source_repository
        self.source_trigger_events = source_trigger_events
        self.status = status
        self.name = name


class SourceUpdateParameters(Model):
    """The properties for updating the source code repository.

    :param source_control_type: The type of source control service. Possible
     values include: 'Github', 'VisualStudioTeamService'
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.SourceControlType
    :param repository_url: The full URL to the source code repository
    :type repository_url: str
    :param branch: The branch name of the source code.
    :type branch: str
    :param source_control_auth_properties: The authorization properties for
     accessing the source code repository and to set up
     webhooks for notifications.
    :type source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AuthInfoUpdateParameters
    """

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfoUpdateParameters'},
    }

    def __init__(self, *, source_control_type=None, repository_url: str=None, branch: str=None, source_control_auth_properties=None, **kwargs) -> None:
        super(SourceUpdateParameters, self).__init__(**kwargs)
        self.source_control_type = source_control_type
        self.repository_url = repository_url
        self.branch = branch
        self.source_control_auth_properties = source_control_auth_properties


class SourceUploadDefinition(Model):
    """The properties of a response to source upload request.

    :param upload_url: The URL where the client can upload the source.
    :type upload_url: str
    :param relative_path: The relative path to the source. This is used to
     submit the subsequent queue build request.
    :type relative_path: str
    """

    _attribute_map = {
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
    }

    def __init__(self, *, upload_url: str=None, relative_path: str=None, **kwargs) -> None:
        super(SourceUploadDefinition, self).__init__(**kwargs)
        self.upload_url = upload_url
        self.relative_path = relative_path


class Status(Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and
     error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current
     value.
    :vartype timestamp: datetime
    """

    _validation = {
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'timestamp': {'readonly': True},
    }

    _attribute_map = {
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(Status, self).__init__(**kwargs)
        self.display_status = None
        self.message = None
        self.timestamp = None


class StorageAccountProperties(Model):
    """The properties of a storage account for a container registry. Only
    applicable to Classic SKU.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The resource ID of the storage account.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(StorageAccountProperties, self).__init__(**kwargs)
        self.id = id


class Target(Model):
    """The target of the event.

    :param media_type: The MIME type of the referenced object.
    :type media_type: str
    :param size: The number of bytes of the content. Same as Length field.
    :type size: long
    :param digest: The digest of the content, as defined by the Registry V2
     HTTP API Specification.
    :type digest: str
    :param length: The number of bytes of the content. Same as Size field.
    :type length: long
    :param repository: The repository name.
    :type repository: str
    :param url: The direct URL to the content.
    :type url: str
    :param tag: The tag name.
    :type tag: str
    :param name: The name of the artifact.
    :type name: str
    :param version: The version of the artifact.
    :type version: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'length': {'key': 'length', 'type': 'long'},
        'repository': {'key': 'repository', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, media_type: str=None, size: int=None, digest: str=None, length: int=None, repository: str=None, url: str=None, tag: str=None, name: str=None, version: str=None, **kwargs) -> None:
        super(Target, self).__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.length = length
        self.repository = repository
        self.url = url
        self.tag = tag
        self.name = name
        self.version = version


class Task(Resource):
    """The task that has the ARM resource and task properties.
    The task will have all information to schedule a run against it.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param identity: Identity for the resource.
    :type identity:
     ~azure.mgmt.containerregistry.v2019_05_01.models.IdentityProperties
    :ivar provisioning_state: The provisioning state of the task. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed',
     'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar creation_date: The creation date of task.
    :vartype creation_date: datetime
    :param status: The current status of task. Possible values include:
     'Disabled', 'Enabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStatus
    :param platform: Required. The platform properties against which the run
     has to happen.
    :type platform:
     ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param timeout: Run timeout in seconds. Default value: 3600 .
    :type timeout: int
    :param step: Required. The properties of a task step.
    :type step:
     ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStepProperties
    :param trigger: The properties that describe all triggers for the task.
    :type trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerProperties
    :param credentials: The properties that describes a set of credentials
     that will be used when this run is invoked.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_date': {'readonly': True},
        'platform': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'step': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepProperties'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
    }

    def __init__(self, *, location: str, platform, step, tags=None, identity=None, status=None, agent_configuration=None, timeout: int=3600, trigger=None, credentials=None, **kwargs) -> None:
        super(Task, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.creation_date = None
        self.status = status
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.timeout = timeout
        self.step = step
        self.trigger = trigger
        self.credentials = credentials


class TaskRunRequest(RunRequest):
    """The parameters for a task run request.

    All required parameters must be populated in order to send to Azure.

    :param is_archive_enabled: The value that indicates whether archiving is
     enabled for the run or not. Default value: False .
    :type is_archive_enabled: bool
    :param type: Required. Constant filled by server.
    :type type: str
    :param task_name: Required. The name of task against which run has to be
     queued.
    :type task_name: str
    :param values: The collection of overridable values that can be passed
     when running a task.
    :type values:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True},
        'task_name': {'required': True},
    }

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(self, *, task_name: str, is_archive_enabled: bool=False, values=None, **kwargs) -> None:
        super(TaskRunRequest, self).__init__(is_archive_enabled=is_archive_enabled, **kwargs)
        self.task_name = task_name
        self.values = values
        self.type = 'TaskRunRequest'


class TaskUpdateParameters(Model):
    """The parameters for updating a task.

    :param identity: Identity for the resource.
    :type identity:
     ~azure.mgmt.containerregistry.v2019_05_01.models.IdentityProperties
    :param status: The current status of task. Possible values include:
     'Disabled', 'Enabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStatus
    :param platform: The platform properties against which the run has to
     happen.
    :type platform:
     ~azure.mgmt.containerregistry.v2019_05_01.models.PlatformUpdateParameters
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration:
     ~azure.mgmt.containerregistry.v2019_05_01.models.AgentProperties
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param step: The properties for updating a task step.
    :type step:
     ~azure.mgmt.containerregistry.v2019_05_01.models.TaskStepUpdateParameters
    :param trigger: The properties for updating trigger properties.
    :type trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerUpdateParameters
    :param credentials: The parameters that describes a set of credentials
     that will be used when this run is invoked.
    :type credentials:
     ~azure.mgmt.containerregistry.v2019_05_01.models.Credentials
    :param tags: The ARM resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformUpdateParameters'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepUpdateParameters'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerUpdateParameters'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, identity=None, status=None, platform=None, agent_configuration=None, timeout: int=None, step=None, trigger=None, credentials=None, tags=None, **kwargs) -> None:
        super(TaskUpdateParameters, self).__init__(**kwargs)
        self.identity = identity
        self.status = status
        self.platform = platform
        self.agent_configuration = agent_configuration
        self.timeout = timeout
        self.step = step
        self.trigger = trigger
        self.credentials = credentials
        self.tags = tags


class TimerTrigger(Model):
    """The properties of a timer trigger.

    All required parameters must be populated in order to send to Azure.

    :param schedule: Required. The CRON expression for the task schedule
    :type schedule: str
    :param status: The current status of trigger. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'schedule': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, schedule: str, name: str, status="Enabled", **kwargs) -> None:
        super(TimerTrigger, self).__init__(**kwargs)
        self.schedule = schedule
        self.status = status
        self.name = name


class TimerTriggerDescriptor(Model):
    """TimerTriggerDescriptor.

    :param timer_trigger_name: The timer trigger name that caused the run.
    :type timer_trigger_name: str
    :param schedule_occurrence: The occurrence that triggered the run.
    :type schedule_occurrence: str
    """

    _attribute_map = {
        'timer_trigger_name': {'key': 'timerTriggerName', 'type': 'str'},
        'schedule_occurrence': {'key': 'scheduleOccurrence', 'type': 'str'},
    }

    def __init__(self, *, timer_trigger_name: str=None, schedule_occurrence: str=None, **kwargs) -> None:
        super(TimerTriggerDescriptor, self).__init__(**kwargs)
        self.timer_trigger_name = timer_trigger_name
        self.schedule_occurrence = schedule_occurrence


class TimerTriggerUpdateParameters(Model):
    """The properties for updating a timer trigger.

    All required parameters must be populated in order to send to Azure.

    :param schedule: The CRON expression for the task schedule
    :type schedule: str
    :param status: The current status of trigger. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, schedule: str=None, status="Enabled", **kwargs) -> None:
        super(TimerTriggerUpdateParameters, self).__init__(**kwargs)
        self.schedule = schedule
        self.status = status
        self.name = name


class TriggerProperties(Model):
    """The properties of a trigger.

    :param timer_triggers: The collection of timer triggers.
    :type timer_triggers:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.TimerTrigger]
    :param source_triggers: The collection of triggers based on source code
     repository.
    :type source_triggers:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SourceTrigger]
    :param base_image_trigger: The trigger based on base image dependencies.
    :type base_image_trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTrigger
    """

    _attribute_map = {
        'timer_triggers': {'key': 'timerTriggers', 'type': '[TimerTrigger]'},
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTrigger]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTrigger'},
    }

    def __init__(self, *, timer_triggers=None, source_triggers=None, base_image_trigger=None, **kwargs) -> None:
        super(TriggerProperties, self).__init__(**kwargs)
        self.timer_triggers = timer_triggers
        self.source_triggers = source_triggers
        self.base_image_trigger = base_image_trigger


class TriggerUpdateParameters(Model):
    """The properties for updating triggers.

    :param timer_triggers: The collection of timer triggers.
    :type timer_triggers:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.TimerTriggerUpdateParameters]
    :param source_triggers: The collection of triggers based on source code
     repository.
    :type source_triggers:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.SourceTriggerUpdateParameters]
    :param base_image_trigger: The trigger based on base image dependencies.
    :type base_image_trigger:
     ~azure.mgmt.containerregistry.v2019_05_01.models.BaseImageTriggerUpdateParameters
    """

    _attribute_map = {
        'timer_triggers': {'key': 'timerTriggers', 'type': '[TimerTriggerUpdateParameters]'},
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTriggerUpdateParameters]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTriggerUpdateParameters'},
    }

    def __init__(self, *, timer_triggers=None, source_triggers=None, base_image_trigger=None, **kwargs) -> None:
        super(TriggerUpdateParameters, self).__init__(**kwargs)
        self.timer_triggers = timer_triggers
        self.source_triggers = source_triggers
        self.base_image_trigger = base_image_trigger


class TrustPolicy(Model):
    """The content trust policy for a container registry.

    :param type: The type of trust policy. Possible values include: 'Notary'.
     Default value: "Notary" .
    :type type: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicyType
    :param status: The value that indicates whether the policy is enabled or
     not. Possible values include: 'enabled', 'disabled'. Default value:
     "disabled" .
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, type="Notary", status="disabled", **kwargs) -> None:
        super(TrustPolicy, self).__init__(**kwargs)
        self.type = type
        self.status = status


class UserIdentityProperties(Model):
    """UserIdentityProperties.

    :param principal_id: The principal id of user assigned identity.
    :type principal_id: str
    :param client_id: The client id of user assigned identity.
    :type client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, *, principal_id: str=None, client_id: str=None, **kwargs) -> None:
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.client_id = client_id


class VirtualNetworkRule(Model):
    """Virtual network rule.

    All required parameters must be populated in order to send to Azure.

    :param action: The action of virtual network rule. Possible values
     include: 'Allow'. Default value: "Allow" .
    :type action: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :param virtual_network_resource_id: Required. Resource ID of a subnet, for
     example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_resource_id: str
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, virtual_network_resource_id: str, action="Allow", **kwargs) -> None:
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.action = action
        self.virtual_network_resource_id = virtual_network_resource_id


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be
     changed after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the webhook at the time the operation was
     called. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered.
     For example, 'foo:*' means events for all tags under repository 'foo'.
     'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: Required. The list of actions that trigger the webhook to
     post notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the
     time the operation was called. Possible values include: 'Creating',
     'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'actions': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str, actions, tags=None, status=None, scope: str=None, **kwargs) -> None:
        super(Webhook, self).__init__(location=location, tags=tags, **kwargs)
        self.status = status
        self.scope = scope
        self.actions = actions
        self.provisioning_state = None


class WebhookCreateParameters(Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to Azure.

    :param tags: The tags for the webhook.
    :type tags: dict[str, str]
    :param location: Required. The location of the webhook. This cannot be
     changed after the resource is created.
    :type location: str
    :param service_uri: Required. The service URI for the webhook to post
     notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook
     notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was
     called. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered.
     For example, 'foo:*' means events for all tags under repository 'foo'.
     'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: Required. The list of actions that trigger the webhook to
     post notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _validation = {
        'location': {'required': True},
        'service_uri': {'required': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(self, *, location: str, service_uri: str, actions, tags=None, custom_headers=None, status=None, scope: str=None, **kwargs) -> None:
        super(WebhookCreateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions


class WebhookUpdateParameters(Model):
    """The parameters for updating a webhook.

    :param tags: The tags for the webhook.
    :type tags: dict[str, str]
    :param service_uri: The service URI for the webhook to post notifications.
    :type service_uri: str
    :param custom_headers: Custom headers that will be added to the webhook
     notifications.
    :type custom_headers: dict[str, str]
    :param status: The status of the webhook at the time the operation was
     called. Possible values include: 'enabled', 'disabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :param scope: The scope of repositories where the event can be triggered.
     For example, 'foo:*' means events for all tags under repository 'foo'.
     'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     'foo:latest'. Empty means all events.
    :type scope: str
    :param actions: The list of actions that trigger the webhook to post
     notifications.
    :type actions: list[str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(self, *, tags=None, service_uri: str=None, custom_headers=None, status=None, scope: str=None, actions=None, **kwargs) -> None:
        super(WebhookUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions
