# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SaveConfigurationParameter(Model):
    """Save Tenant Configuration Contract details.

    All required parameters must be populated in order to send to Azure.

    :param branch: Required. The name of the Git branch in which to commit the
     current configuration snapshot.
    :type branch: str
    :param force: The value if true, the current configuration database is
     committed to the Git repository, even if the Git repository has newer
     changes that would be overwritten.
    :type force: bool
    """

    _validation = {
        'branch': {'required': True},
    }

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'force': {'key': 'properties.force', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SaveConfigurationParameter, self).__init__(**kwargs)
        self.branch = kwargs.get('branch', None)
        self.force = kwargs.get('force', None)
