/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.MemberObfuscator;

public class MemberNameConflictFixer
implements MemberVisitor {
    private final boolean allowAggressiveOverloading;
    private final Map descriptorMap;
    private final WarningPrinter warningPrinter;
    private final MemberObfuscator memberObfuscator;

    public MemberNameConflictFixer(boolean bl, Map map, WarningPrinter warningPrinter, MemberObfuscator memberObfuscator) {
        this.allowAggressiveOverloading = bl;
        this.descriptorMap = map;
        this.warningPrinter = warningPrinter;
        this.memberObfuscator = memberObfuscator;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.visitMember(programClass, programField, true);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        this.visitMember(programClass, programMethod, false);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    private void visitMember(Clazz clazz, Member member, boolean bl) {
        String string;
        Map map;
        String string2;
        String string3 = member.getName(clazz);
        String string4 = member.getDescriptor(clazz);
        if (!this.allowAggressiveOverloading) {
            string4 = string4.substring(0, string4.indexOf(41) + 1);
        }
        if ((string2 = (String)(map = MemberObfuscator.retrieveNameMap(this.descriptorMap, string4)).get(string = MemberObfuscator.newMemberName(member))) != null && !string3.equals(string2)) {
            if (MemberObfuscator.hasFixedNewMemberName(member) && this.warningPrinter != null) {
                string4 = member.getDescriptor(clazz);
                this.warningPrinter.print(clazz.getName(), "Warning: " + ClassUtil.externalClassName(clazz.getName()) + (bl ? ": field '" + ClassUtil.externalFullFieldDescription(0, string3, string4) : ": method '" + ClassUtil.externalFullMethodDescription(clazz.getName(), 0, string3, string4)) + "' can't be mapped to '" + string + "' because it would conflict with " + (bl ? "field '" : "method '") + string2 + "', which is already being mapped to '" + string + "'");
            }
            MemberObfuscator.setNewMemberName(member, null);
            member.accept(clazz, this.memberObfuscator);
        }
    }
}

