/**
 * @file powermanga.h
 * @brief global header file
 * @date 2007-09-02
 * @author Jean-Michel Martin de Santero
 * @author Bruno Ethvignot
 */
/*
 * copyright (c) 1998-2007 TLK Games all rights reserved
 * $Id: powermanga.h,v 1.68 2007/09/02 16:13:56 gurumeditation Exp $
 *
 * Powermanga is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Powermanga is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef __POWERMANGA__
#define __POWERMANGA__

#ifdef __cplusplus
extern "C"
{
#endif

/** PlayStation Portable port, PSP is a handheld game console released
 * and currently manufactured by Sony Computer Entertainment */
/* #define POWERMANGA_PSP */
/** GP2X port, GP2X is an open-source,
 * Linux-based handheld video game console */
/* #define POWERMANGA_GP2X */
#ifdef POWERMANGA_GP2X
#undef POWERMANGA_PSP
#define POWERMANGA_HANDHELD_CONSOLE
#endif
#ifdef POWERMANGA_PSP
#undef POWERMANGA_GP2X
#define POWERMANGA_HANDHELD_CONSOLE
#endif

/** To define only under development 
 * If defined [Ctrl] + [V], [Ctrl] + [P], [Ctrl] + [B] are available 
 */
/* #define UNDER_DEVELOPMENT */

#ifndef SCOREFILE
#define SCOREFILE "powermanga"
#endif
#ifndef PREFIX
#define PREFIX ""
#endif
/** Use SDL for display */
#define POWERMANGA_SDL
#ifndef POWERMANGA_SDL
/** Use X Window for display */
#define POWERMANGA_X11
  typedef unsigned char Uint8;
  typedef signed char Sint8;
  typedef signed short Sint16;
  typedef unsigned short Uint16;
  typedef signed int Sint32;
  typedef unsigned int Uint32;
#else
#include <SDL/SDL.h>
#endif
/** Devel flag */
  /* #define DEVELOPPEMENT */
/** Use SDL_mixer for audio effects and musics */
#define USE_SDLMIXER
#define POWERMANGA_VERSION "POWERMANGA 0.90 (2007-09-02)"
/* #define SHAREWARE_VERSION */
/** Maximum number of levels in the game, range 0 to 41 */
#ifdef SHAREWARE_VERSION
#define MAX_NUM_OF_LEVELS 2
#else
#define MAX_NUM_OF_LEVELS 41
#endif
#define DEUX_PI 6.28318530718f
#define PI 3.14159265359f
#define PI_SUR_2 1.57079632679f
#define PI_PLUS_PI_SUR_2 4.712388980385f
#define PI_SUR_16 0.19634954085f
/** Value epsilon for the comparison of the floating with absolute error */
#define EPS 0.001
/** Index of progression in a curve  */
#define POS_CURVE 0
/** Maximum of number of images in the TLK logo animation */
#define TLKLOGO_MAXOF_IMAGES 64
  typedef enum
  {
    XCOORD,
    YCOORD
  } COORD_ENUM;
  /* "inits_game.c" file */
  bool inits_game (void);
  void release_game (void);
#ifdef UNDER_DEVELOPMENT 
  /* "special_keys.c" file */
  void special_keys (void);
#endif
  /* "powermanga.c" file */
  bool update_frame ();
  /** If TRUE display "GAME OVER" */
  extern bool gameover_enable;
  extern Sint32 global_counter;
  extern Uint32 loops_counter;
  extern bool player_pause;
  extern bool is_pause_draw;
  extern Sint32 player_score;
  extern bool quit_game;
  /** Current level number from 0 to 41 */
  extern Sint32 num_level;
#ifdef __cplusplus
}
#endif

#endif
