/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "ratingwidget.h"

#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QGraphicsSceneHoverEvent>

#include <Nepomuk/KRatingPainter>

RatingWidget::RatingWidget(QGraphicsWidget *parent)
    : QGraphicsWidget(parent),
      m_ratingPainter(new KRatingPainter())
{
    setAcceptHoverEvents(true);

    currentRating = 0;
    hoverRating = -1;
}

RatingWidget::~RatingWidget(void)
{
    delete m_ratingPainter;
}

void RatingWidget::setSpacing(int spacing)
{
    m_ratingPainter->setSpacing(spacing);
    update();
}

unsigned int RatingWidget::rating() const
{
    return currentRating;
}

void RatingWidget::setRating(unsigned int rating)
{
    currentRating = rating;
    hoverRating = rating;
    update();
}

void RatingWidget::setMaxRating(unsigned int max)
{
    m_ratingPainter->setMaxRating(max);
    update();
}

void RatingWidget::setHalfStepsEnabled(bool enabled)
{
    m_ratingPainter->setHalfStepsEnabled(enabled);
    update();
}

void RatingWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED( option )
    Q_UNUSED( widget )

    m_ratingPainter->setEnabled(isEnabled());
    QRect rect(contentsRect().topLeft().x(), contentsRect().topLeft().y(),
               contentsRect().width(), contentsRect().height());
    m_ratingPainter->setSpacing(rect.width()/10);
    m_ratingPainter->paint(painter, rect, currentRating, hoverRating);
}

// void RatingWidget::mousePressEvent(QGraphicsSceneMouseEvent* e) {
//     if ( e->button() == Qt::LeftButton )
//     {
//         QRect rect(contentsRect().topLeft().x(), contentsRect().topLeft().y(),
//                     contentsRect().width(), contentsRect().height());
//         int ratingFromPos = ratingPainter->ratingFromPosition(rect, QPoint(e->pos().x(), e->pos().y()));
//         if (ratingFromPos >= 0)
//         {
//             hoverRating = currentRating = ratingFromPos;
//             update();
//             emit ratingChanged(currentRating);
//         }
//     }
// }
// 
// 
// void RatingWidget::hoverMoveEvent(QGraphicsSceneHoverEvent* e) {
//     QRect rect(contentsRect().topLeft().x(), contentsRect().topLeft().y(),
//                     contentsRect().width(), contentsRect().height());
//     hoverRating = ratingPainter->ratingFromPosition(rect, QPoint( e->pos().x(), e->pos().y()));
// 
//     update();
// }
// 
// void RatingWidget::hoverEnterEvent(QGraphicsSceneHoverEvent* e) {
//     QRect rect(contentsRect().topLeft().x(), contentsRect().topLeft().y(),
//                     contentsRect().width(), contentsRect().height());
//     hoverRating = ratingPainter->ratingFromPosition(rect, QPoint( e->pos().x(), e->pos().y()));
// 
//     update();
// }
// 
// void RatingWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent* ) {
//     hoverRating = -1;
//     update();
// }

#include "ratingwidget.moc"
