import os
import re

from pkgme.run_script import run_subprocess


def find_changes_file(output_lines,
                      _changes_file_re=re.compile(r' dpkg-genchanges -S >(.*)')):
    for line in output_lines:
        match = _changes_file_re.match(line)
        if match:
            return match.group(1)
    raise ValueError("Could not find changes filename")


def build_source_package(directory, sign=True):
    cmd = ['debuild', '--no-lintian', '-S']
    if not sign:
        cmd.extend(['-uc', '-us'])
    output = run_subprocess(cmd, cwd=directory)
    changes_file = find_changes_file(output)
    return os.path.abspath(os.path.join(directory, changes_file))
