<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 autoindent: */
/**
 * Numbers_Words class extension to spell numbers in Polish.
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.01 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_01.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category  Numbers
 * @package   Numbers_Words
 * @author    Piotr Klaban <makler@man.torun.pl>
 * @copyright 1997-2008 The PHP Group
 * @license   http://www.php.net/license/3_01.txt  PHP License 3.01
 * @version   SVN: $Id$
 * @link      http://pear.php.net/package/Numbers_Words
 */

require_once 'Numbers/Words.php';
require_once 'PHPUnit/Framework/TestCase.php';

class Numbers_Words_PolishTest extends PHPUnit_Framework_TestCase
{
    var $handle;

    function setUp()
    {
        $this->handle = new Numbers_Words();
    }

    /**
     * Testing numbers between 0 and 9
     */
    function testDigits()
    {
        $digits = array('zero',
                        'jeden',
                        'dwa',
                        'trzy',
                        'cztery',
                        'pi',
                        'sze',
                        'siedem',
                        'osiem',
                        'dziewi'
                       );
        for ($i = 0; $i < 10; $i++)
        {
            $number = $this->handle->toWords($i, 'pl');
            $this->assertEquals($digits[$i], $number);
        }
    }

    /**
     * Testing numbers between 10 and 99
     */
    function testTens()
    {
        $tens = array(11 => 'jedenacie',
                      12 => 'dwanacie',
                      16 => 'szesnacie',
                      19 => 'dziewitnacie',
                      20 => 'dwadziecia',
                      21 => 'dwadziecia jeden',
                      26 => 'dwadziecia sze',
                      30 => 'trzydzieci',
                      31 => 'trzydzieci jeden',
                      40 => 'czterdzieci',
                      43 => 'czterdzieci trzy',
                      50 => 'pidziesit',
                      55 => 'pidziesit pi',
                      60 => 'szedziesit',
                      67 => 'szedziesit siedem',
                      70 => 'siedemdziesit',
                      79 => 'siedemdziesit dziewi'
                     );
        foreach ($tens as $number => $word) {
            $this->assertEquals($word, $this->handle->toWords($number, 'pl'));
        }
    }

    /**
     * Testing numbers between 100 and 999
     */
    function testHundreds()
    {
        $hundreds = array(100 => 'sto',
                          101 => 'sto jeden',
                          199 => 'sto dziewidziesit dziewi',
                          203 => 'dwiecie trzy',
                          287 => 'dwiecie osiemdziesit siedem',
                          300 => 'trzysta',
                          356 => 'trzysta pidziesit sze',
                          410 => 'czterysta dziesi',
                          434 => 'czterysta trzydzieci cztery',
                          578 => 'piset siedemdziesit osiem',
                          689 => 'szeset osiemdziesit dziewi',
                          729 => 'siedemset dwadziecia dziewi',
                          894 => 'osiemset dziewidziesit cztery',
                          999 => 'dziewiset dziewidziesit dziewi'
                         );
        foreach ($hundreds as $number => $word) {
            $this->assertEquals($word, $this->handle->toWords($number, 'pl'));
        }
    }

    /**
     * Testing numbers between 1000 and 9999
     */
    function testThousands()
    {
        $thousands = array(1000 => 'jeden tysic',
                           1001 => 'jeden tysic jeden',
                           1097 => 'jeden tysic dziewidziesit siedem',
                           1104 => 'jeden tysic sto cztery',
                           1243 => 'jeden tysic dwiecie czterdzieci trzy',
                           2385 => 'dwa tysice trzysta osiemdziesit pi',
                           3766 => 'trzy tysice siedemset szedziesit sze',
                           4196 => 'cztery tysice sto dziewidziesit sze',
                           5846 => 'pi tysicy osiemset czterdzieci sze',
                           6459 => 'sze tysicy czterysta pidziesit dziewi',
                           7232 => 'siedem tysicy dwiecie trzydzieci dwa',
                           8569 => 'osiem tysicy piset szedziesit dziewi',
                           9539 => 'dziewi tysicy piset trzydzieci dziewi'
                          );
        foreach ($thousands as $number => $word) {
            $this->assertEquals($word, $this->handle->toWords($number, 'pl'));
        }
    }
}
