## 113.00.00

- Add `-pa-bench-drop-with-deadcode` option.

## 112.06.00

- Made the code generated by `pa_bench` for `BENCH` not use `ignore`,
  because OCaml 4.02 will remove dead code in some cases, meaning the
  benchmarks are no longer measuring what they should.  Instead the ignore
  is deep inside `Core_bench`, which is likely out of reach of the
  compiler.

    The result of the user functions given to `BENCH_FUN` and
    `BENCH_INDEXED` are changed so they don't have to return unit and
    people are encouraged not to use `ignore` when these functions don't
    return `unit` (you will get the same warning though, i.e. a warning
    if the result of your function is a function too, thus preventing
    unintended partial applications).

    For example, here are a few benchmarks and their output before the
    fix:

        let x = if Random.bool () then 100 else 1001
        let r = ref 0
        BENCH "ig-1" = 10 / x
        BENCH "ig-2" = ()
        BENCH "ig-3" = phys_equal (10 / x) (Obj.magic 0)
        BENCH "ig-4" = r := (10 / x)
        BENCH "ig-5" = r := x

        +----------------+----------+------------+
        | Name           | Time/Run | Percentage |
        +----------------+----------+------------+
        | [misc.ml] ig-1 |   3.92ns |     29.30% |
        | [misc.ml] ig-2 |   3.34ns |     24.95% |
        | [misc.ml] ig-3 |   3.91ns |     29.23% |
        | [misc.ml] ig-4 |  13.37ns |    100.00% |
        | [misc.ml] ig-5 |   3.24ns |     24.20% |
        +----------------+----------+------------+

    Many of the the numbers above are much lower than they should be
    because of the implicit ignores inserted by the benchmark caused the
    division to to eliminated by the compiler. After the fix, the same
    benchmarks produced more meaningful numbers:

        +----------------+----------+------------+
        | Name           | Time/Run | Percentage |
        +----------------+----------+------------+
        | [misc.ml] ig-1 |  12.78ns |     94.55% |
        | [misc.ml] ig-2 |   3.23ns |     23.90% |
        | [misc.ml] ig-3 |  13.51ns |     99.94% |
        | [misc.ml] ig-4 |  13.52ns |    100.00% |
        | [misc.ml] ig-5 |   3.30ns |     24.40% |
        +----------------+----------+------------+

## 109.55.00

- Added support for inline benchmarks using the `BENCH` syntax, similar
  to `TEST`.

    This feature allows users to specify inline benchmarks in any library.

    One can specify a benchmark using the following syntax:

    ```ocaml
    BENCH "name" = expr
    ```

    In the above, the value of `expr` is ignored.  This creates
    a benchmark for `expr`, that is run using the
    `inline_benchmarks_runner` script from the command-line.  This
    workflow is similar to that of inline unit tests.

    One can specify benchmarks that require some initialization using
    `BENCH_FUN`. For example:

    ```ocaml
    BENCH_FUN "name" =
      let t = create () in
      (fun () -> test_something t)
    ```

    The function returned on the RHS of `BENCH_FUN` should have type `unit
    -> unit`. One can specify benchmarks that have a variable parameter
    using `BENCH_INDEXED`. For example:

    ```ocaml
    BENCH_INDEXED "Array.create" len [1;10;100;1000] =
      (fun () -> Array.create ~len 0)
    ```

    The above snippet measures the time taken to create arrays of
    different length.  Indexed tests are useful in highlighting
    non-linearities in the execution time of functions.

    We can group benchmarks together into modules and the output of
    `inline_benchmarks_runner` will reflect this grouping.

    ```ocaml
    BENCH_MODULE "Blit tests" = struct

      ..some benchmarks..

    end
    ```

    For examples of all of the above see `core_gc.ml` and `core_array.ml`.

    Only the generated `inline_benchmarks_runner.exe` depends on
    `Core_bench` and other libraries.  The library that includes the the
    benchmarks itself does not have a dependency on `Core_bench`.  Doing
    this is important so that we can add benchmarks to `Core` and still
    avoid cyclic dependencies.  Finally, it is important to note that
    adding inline benchmarks should have little effect on the execution or
    module initialization time.

