
# NAME
osmium - multipurpose tool for working with OpenStreetMap data


# SYNOPSIS

**osmium** *COMMAND* \[*ARG*...\]\
**osmium** --version


# DESCRIPTION

Multipurpose tool for working with OpenStreetMap data.

Run **osmium help** *COMMAND* to get more information about a command.


# OPTIONS

-h, --help
:   Show usage and list of commands.

--version
:   Show program version.


# COMMANDS

apply-changes
:   apply OSM change file(s) to OSM data file

cat
:   concatenate OSM files and convert to different formats

changeset-filter
:   filter changesets from OSM changeset files

check-refs
:   check referential integrity of OSM file

fileinfo
:   show information about an OSM file

getid
:   get objects from OSM file by ID

help
:   show help about commands

merge-changes
:   merge several OSM change files into one

renumber
:   renumber object IDs

sort
:   sort OSM files

time-filter
:   filter OSM data by time from a history file


# SEE ALSO

* **osmium-apply-changes**(1),
  **osmium-cat**(1),
  **osmium-check-refs**(1),
  **osmium-fileinfo**(1),
  **osmium-getid**(1),
  **osmium-merge-changes**(1),
  **osmium-renumber**(1),
  **osmium-time-filter**(1),
  **osmium-file-formats**(5)
* [Osmium website](http://osmcode.org/osmium)

