// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_ParamSet_HeaderFile
#define _Interface_ParamSet_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Interface_ParamSet_HeaderFile
#include <Handle_Interface_ParamSet.hxx>
#endif

#ifndef _Standard_PCharacter_HeaderFile
#include <Standard_PCharacter.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Interface_ParamList_HeaderFile
#include <Handle_Interface_ParamList.hxx>
#endif
#ifndef _Handle_Interface_ParamSet_HeaderFile
#include <Handle_Interface_ParamSet.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Interface_ParamType_HeaderFile
#include <Interface_ParamType.hxx>
#endif
class Interface_ParamList;
class Standard_OutOfRange;
class Interface_FileParameter;


//! Defines an ordered set of FileParameters, in a way to be <br>
//!           efficient as in memory requirement or in speed <br>
class Interface_ParamSet : public MMgt_TShared {

public:

  //! Creates an empty ParamSet, beginning at number "nst" and of <br>
//!           initial reservation "nres" : the "nres" first parameters <br>
//!           which follow "ndeb" (included) will be put in an Array <br>
//!           (a ParamList). The remainders are set in Next(s) ParamSet(s) <br>
  Standard_EXPORT   Interface_ParamSet(const Standard_Integer nres,const Standard_Integer nst = 1);
  //! Adds a parameter defined as its Value (CString and length) and <br>
//!           Type. Optionnal EntityNumber (for FileReaderData) can be given <br>
//!           Allows a better memory management than Appending a <br>
//!           complete FileParameter <br>
//!           If <lnval> < 0, <val> is assumed to be managed elsewhere : its <br>
//!           adress is stored as such. Else, <val> is copied in a locally <br>
//!           (quickly) managed Page of Characters <br>
//!           Returns new count of recorded Parameters <br>
  Standard_EXPORT     Standard_Integer Append(const Standard_CString val,const Standard_Integer lnval,const Interface_ParamType typ,const Standard_Integer nument) ;
  //! Adds a parameter at the end of the ParamSet (transparent <br>
//!           about reservation and "Next") <br>
//!           Returns new count of recorded Parameters <br>
  Standard_EXPORT     Standard_Integer Append(const Interface_FileParameter& FP) ;
  //! Returns the total count of parameters (including nexts) <br>
  Standard_EXPORT     Standard_Integer NbParams() const;
  //! Returns a parameter identified by its number <br>
  Standard_EXPORT    const Interface_FileParameter& Param(const Standard_Integer num) const;
  //! Same as above, but in order to be modified on place <br>
  Standard_EXPORT     Interface_FileParameter& ChangeParam(const Standard_Integer num) ;
  //! Changes a parameter identified by its number <br>
  Standard_EXPORT     void SetParam(const Standard_Integer num,const Interface_FileParameter& FP) ;
  //! Builds and returns the sub-list correspinding to parameters, <br>
//!           from "num" included, with count "nb" <br>
//!           If <num> and <nb> are zero, returns the whole list <br>
  Standard_EXPORT     Handle_Interface_ParamList Params(const Standard_Integer num,const Standard_Integer nb) const;
  //! Destructor (waiting for transparent memory management) <br>
  Standard_EXPORT     void Destroy() ;
~Interface_ParamSet()
{
  Destroy();
}



  DEFINE_STANDARD_RTTI(Interface_ParamSet)

protected:




private: 


Standard_PCharacter theval;
Standard_Integer thelnval;
Standard_Integer thelnres;
Standard_Integer thenbpar;
Standard_Integer themxpar;
Handle_Interface_ParamList thelist;
Handle_Interface_ParamSet thenext;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
