/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.transform;

import java.io.BufferedReader;
import java.io.FileReader;
import org.apache.turbine.services.intake.transform.DTDResolver;
import org.apache.turbine.services.intake.xmlmodel.AppData;
import org.apache.turbine.services.intake.xmlmodel.Rule;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private AppData app = new AppData();
    private XmlGroup currGroup;
    private XmlField currField;
    private Rule currRule;
    private String currElement;

    public AppData parseFile(String xmlFile) throws Exception {
        return this.parseFile(xmlFile, false);
    }

    public AppData parseFile(String xmlFile, boolean skipValidation) throws Exception {
        SAXParser parser = new SAXParser();
        DTDResolver dtdResolver = new DTDResolver();
        parser.setEntityResolver(dtdResolver);
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        parser.setFeature("http://xml.org/sax/features/validation", true);
        FileReader fr = new FileReader(xmlFile);
        BufferedReader br = new BufferedReader(fr);
        try {
            InputSource is = new InputSource(br);
            parser.parse(is);
        }
        finally {
            Object var8_8 = null;
            br.close();
        }
        return this.app;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        this.currElement = rawName;
        if (rawName.equals("input-data")) {
            this.app.loadFromXML(attributes);
        } else if (rawName.equals("group")) {
            this.currGroup = this.app.addGroup(attributes);
        } else if (rawName.equals("field")) {
            this.currField = this.currGroup.addField(attributes);
        } else if (rawName.equals("rule")) {
            this.currRule = this.currField.addRule(attributes);
        }
    }

    public void characters(char[] mesgArray, int start, int length) {
        String cdata = new String(mesgArray, start, length).trim();
        if ("rule".equals(this.currElement) && cdata.length() > 0) {
            this.currRule.setMessage(cdata);
        }
        if ("required-message".equals(this.currElement) && cdata.length() > 0) {
            this.currField.setIfRequiredMessage(cdata);
        }
    }

    public void warning(SAXParseException spe) {
        System.out.println("Warning Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void error(SAXParseException spe) {
        System.out.println("Error Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void fatalError(SAXParseException spe) {
        System.out.println("Fatal Error Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }
}

