/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
 */



#pragma once


/////////////////////// Qt includes
#include <QObject>
#include <QString>
#include <QWidget>


///////////////////////////// Local includes
#include <minexpert/gui/AbstractPlotWidget.hpp>
#include <minexpert/nongui/History.hpp>


namespace msXpSmineXpert
{


	//! The TicChromPlotWidget class provides a tic chromatogram-specific plot widget.
	class TicChromPlotWidget : public AbstractPlotWidget
	{
		Q_OBJECT

		public:
			QString craftAnalysisStanza(QCPGraph *theGraph = Q_NULLPTR, const QString &fileName = QString());

			int arbitraryIntegrationType();

			// Construction/Desctruction
			TicChromPlotWidget(QWidget *parent, QWidget *parentWnd, 
					const QString &name, const QString &desc, 
					MassSpecDataSet *massSpecDataSet = Q_NULLPTR, const QString &fileName = QString(),
					bool isMultiGraph = false);

			~TicChromPlotWidget();

			void mouseReleaseHandledEvent(QMouseEvent *event);
			void keyReleaseEvent(QKeyEvent *event);

			Q_INVOKABLE void integrateToMz(double lower = qSNaN(), double upper = qSNaN());
			Q_INVOKABLE void integrateToDt(double lower = qSNaN(), double upper = qSNaN());
			Q_INVOKABLE double integrateToTicIntensity(double lower = qSNaN(), double upper = qSNaN());

			Q_INVOKABLE void newPlot();

signals:
			void recordAnalysisStanza(QString stanza, const QColor &color = QColor());

			void newMassSpectrum(MassSpecDataSet *massSpecDataSet,
					const QString &msg, History history, QColor color);

			void newDriftSpectrum(MassSpecDataSet *massSpecDataSet,
					const QString &msg, History history, QColor color);
	};


} // namespace msXpSmineXpert

