#!/bin/sh
#
# Send multiples files non-interactively

# adjust if needed
attachment_header=`mhparam Attachment-Header`


if [ $# -lt 3 ]; then
    echo 'usage: sendfiles RECIPIENT SUBJECT FILES...' 1>&2
    exit 1;
fi

rcpt="$1"
shift
subject="$1"
shift

cat 1>&2 <<!
Recipient: $rcpt
Subject:   $subject
Files:     $*
!

draft=`mktemp /tmp/sendfiles.XXXXXX`
trap 'rm -f "$draft"' 1 2 15

anno "$draft" -component To -text "$rcpt" -nodate
anno "$draft" -component Subject -text "$subject" -nodate
for i in "$@" ; do
	anno "$draft" -component  "$attachment_header" -text "$i" -nodate
done

send "$draft"
